(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73827,       2456]
NotebookOptionsPosition[     61687,       2028]
NotebookOutlinePosition[     63192,       2069]
CellTagsIndexPosition[     63106,       2064]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], 
          "Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Solving Logical Combinations of Equations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "BitAnd" :> 
          Documentation`HelpLookup["paclet:ref/BitAnd"], "Nand" :> 
          Documentation`HelpLookup["paclet:ref/Nand"], "Or" :> 
          Documentation`HelpLookup["paclet:ref/Or"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 2->"\<\"BitAnd\"\>", 
       3->"\<\"Nand\"\>", 4->"\<\"Or\"\>", 
       5->"\<\"Not\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "And ",
 StyleBox["(&&, \[And])", "OperatorCharacter"]
}], "ObjectName",
 CellID->21409],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], "&&", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], "&&", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "\[LineSeparator]is the logical AND function. It evaluates its arguments \
in order, giving ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " immediately if any of them are ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if they are all ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28607]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[And]", 
    SubscriptBox["e", "2"], "\[And]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData["\[And]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&&\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]and\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->8119997]
}], "Notes",
 CellID->18038],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and explicitly controls the evaluation of its arguments. In ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "&&", 
    SubscriptBox["e", "2"], "&&", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are evaluated in order, stopping if any of them is found to be ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->76232233]
}], "Notes",
 CellID->4360],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " gives symbolic results when necessary, removing initial arguments that are \
",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->18400621]
}], "Notes",
 CellID->5471]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56213387],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->748598120],

Cell[TextData[{
 "Combine assertions with ",
 Cell[BoxData["&&"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->48276095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", ">", "1"}], "&&", 
  RowBox[{"Pi", ">", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129342052],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102995250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->276014806],

Cell["A symbolic conjunction:", "ExampleText",
 CellID->257061919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "&&", "b", "&&", 
  RowBox[{"!", "c"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40726281],

Cell[BoxData[
 RowBox[{"a", "&&", "b", "&&", 
  RowBox[{"!", "c"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40007331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143517902],

Cell["A system of equations:", "ExampleText",
 CellID->497418773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}]}], "\[Equal]", "3"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"4", "x"}], "+", 
    RowBox[{"5", "y"}]}], "\[Equal]", "6"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370474334],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}]}], "\[Equal]", "3"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", "x"}], "+", 
    RowBox[{"5", " ", "y"}]}], "\[Equal]", "6"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168720589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94842956],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]and\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[And]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"p", "&&", "q"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510274983]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->261099208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " works with any number of arguments:"
}], "ExampleText",
 CellID->234037899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11849551],

Cell[BoxData[
 RowBox[{"x", "&&", "y", "&&", "z"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25332789]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " is associative:"
}], "ExampleText",
 CellID->60318973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"And", "[", 
   RowBox[{"x", ",", 
    RowBox[{"And", "[", 
     RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237186586],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"And", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->809328553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213761091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " with explicit ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " arguments will simplify:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18400621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{"x", ",", "True", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534512268],

Cell[BoxData[
 RowBox[{"x", "&&", "z"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551767323]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{"x", ",", "False", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599319570],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181516140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39071304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " evaluates its arguments in order, stopping when an argument evaluates to \
",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->76232233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "False"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201736223],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->325449066],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441033345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "True"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200768372],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->667683752],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->182029445]
}, Open  ]],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66851914]
}, Open  ]],

Cell["The order of arguments may be important:", "ExampleText",
 CellID->128888979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "\[NotEqual]", "0"}], "&&", 
   RowBox[{"y", "\[Equal]", 
    RowBox[{"1", "/", "x"}]}]}], "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->700237770],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97003387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "\[Equal]", 
    RowBox[{"1", "/", "x"}]}], "&&", 
   RowBox[{"x", "\[NotEqual]", "0"}]}], "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->602059520],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->470692662],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->514649387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375923361],

Cell["\<\
Symbolic transformations will not preserve argument ordering:\
\>", "ExampleText",
 CellID->531520307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "&&", "y", "&&", "y", "&&", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18042936],

Cell[BoxData[
 RowBox[{"z", "&&", "y", "&&", "y", "&&", "x"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43300727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172565786],

Cell[BoxData[
 RowBox[{"x", "&&", "y", "&&", "z"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240895427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161860430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->299487167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "&&", "y", "&&", "z"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229221090],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[And]", "y", "\[And]", "z"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->301206165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->565495717],

Cell[TextData[{
 "Combine conditions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code:"
}], "ExampleText",
 CellID->102489113],

Cell[BoxData[
 RowBox[{
  RowBox[{"PositiveNumberQ", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"NumberQ", "[", "x", "]"}], "&&", 
   RowBox[{
    RowBox[{"Head", "[", "x", "]"}], "=!=", "Complex"}], "&&", 
   RowBox[{"x", ">", "0"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930520182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveNumberQ", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15657092],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457031668]
}, Open  ]],

Cell[TextData[{
 "If an argument of ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", any subsequent arguments are not evaluated:"
}], "ExampleText",
 CellID->284165656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveNumberQ", "[", "I", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->115100274],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->703935287]
}, Open  ]],

Cell[TextData[{
 "The argument order in ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " matters; if we reverse the last two arguments, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"], ">", "0"}]], "InlineFormula"],
 " is evaluated:"
}], "ExampleText",
 CellID->35985314],

Cell[BoxData[
 RowBox[{
  RowBox[{"PositiveNumberQ2", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"NumberQ", "[", "x", "]"}], "&&", 
   RowBox[{"x", ">", "0"}], "&&", 
   RowBox[{
    RowBox[{"Head", "[", "x", "]"}], "=!=", "Complex"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->779001943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PositiveNumberQ2", "[", "I", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9685162],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->680504771],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->26178946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194464135],

Cell["Combine assumptions:", "ExampleText",
 CellID->66247382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "^", "b"}], ")"}], "^", "c"}], ",", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"b", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57293133],

Cell[BoxData[
 SuperscriptBox["a", 
  RowBox[{"b", " ", "c"}]]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126951719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99999606],

Cell[TextData[{
 "Combine equations and inequalities; ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " is used both in the input and in the output:"
}], "ExampleText",
 CellID->4442628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->966390519],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "\[LessEqual]", "x", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "\[LessEqual]", "x", "<", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{422, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78350510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418832084],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " to combine conditions:"
}], "ExampleText",
 CellID->141137913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152893273],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmPtrVEcUxyf7VKvV+EhifGQTrY8qWh9tqZbWotWf+kcEEQwiKZqfBJVK
RRQRfKCsloRQ2TZNMLbqwmokNpGt0cVgpKHBQCAQMBJ/MBgkENh+z7l33d2z
M3fv4qNiA7mzM3M+Z87MOXNm7v2uum7njt3VdTXbq0Pb9lR/v7Nm+97Q1to9
aPIWKaUO4P9QmcLvJH7x/4FkEmXusxhPHwTKUHpRzkbpyaiX2v0elp5JT2rm
mlJzM+r0k/t96bqlJ1OiVGiw9E61R/EK6Rl2u6/gcWS9iMVmO1jjTi/NmJaY
9L05ncU5TOErXZIjkfahx9ZI5ZwMj2e2sy80EWM9A7Zn6rgWFF71o6xV/Oe1
m2h8jYd9gpwu+oOiPknUp4m65xX75XhFbPlk0UqzoGqNXeolMuu7bB9bK5ft
F79RNmj7ImCUkOuV3UPsLrvMJ/t6e/67kd9Fm9yOHLTjyRwRMv5lZkxLFrLz
8o+RHe3urXAv+e7F+rds8Pj4eCwW6+jowI8qo+wWegQg8gf+Yv/8eukeyomJ
iUojsZnrFnGzc0h5Eg9fKG/z790YirpCObOThI+Jsz9F+/v7qWuhcfbfCNLP
5O17T1taWsbGxlSF0cpNggwyeTn6d1tbW2pMPfm1ICczeezELyMjI9S1wEh+
JcgpTGJV4YdckmYsialirHnGlflSkNOYhPvi8Th1zTdauVGQHzLZcedJJBJx
JjcIcobGWj35hSCLmWyMdHZ3d+eSNGNJzBRrWW5cmc8FOYvJ9vjjpqYmZys/
E+QcJsPhsN1fnszMDh5NvvtUaChhDYePNo6OjmZr4PM66zSVGWa90FUqVjuf
LlK1TugoYx0nTrcMDQ1RV+q27MaetULXXKGrkLmtEbrKX2GdPhG65rGugz+e
R5M7r63Wavjr/rOGhgbniFklyPlMXv9zsLW1VR/Xklgg9q05rlcKciGTZ8JX
BgYGnK1coSXvPniO+SHVO+z4jwVZweS1G4+i0WjSMVcsF2RI5PxskmasJ5Dr
kZdSVupXZqkgK5msv3irp6cn6Zixl2jJ9JjmU+IjQVYJb5jJxVry0tWe9vZ2
6qrIWRk9gYyNUxCtTOhXpkpLwvPYtsPDw8p8ylskBgBGUGWKxBQHBweV+UZh
kft/OAdhgkKCXJSHTCQSFxrbIG9HG/bhqXOXiVxsWJne3l7MBxne3k2IzyPH
LyItcb9+ZSwSa4CEGmnusjKQD6OG62MIblwuljj73of46OrqQs7CoVSSorGR
0dLX17csmZl1vJq8xVHrR8LDiQYjEACYqXUy+ikCm0k3sgLdc5a/1JbvfY13
UQBHBKLp0JF6rDndzO48+YD0BuBMWIjFQheMh+oVrjVzFgli1ohwXPVgHHwM
VdjTyv9zU1wF4KbjJ3/bd/AMwgaGwwGrHLVT1cq90ApppAbc8BIJ5YW34Zqk
nZsLfVN1L2k6Ed6fN7P/h02FvKfqvsvp3/uUo6T7KJsieuhbDlXXi3b5BS59
O9NpcLJS2iK/HuWrF8q/7fFeN+9016x9GRcUXdZ3w9zviqroX68d4E8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{126, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390193401]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1730688],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225973783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165690619],

Cell[TextData[{
 "A cellular automaton based on ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12039839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"And", "@@", "#"}], "&"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], ",", "40"}], "]"}], ",", 
     "20"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368008395],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgHBUdFR0VHRUdFR0VHRUdhKJ8QIIFyGUB0pxAWhTKZ4XS
gkCaFUjLAWkOIM0JFeeF8mHqOEZNJ8l08mIO2spiBAA7NBvF\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159149639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313213360],

Cell["\<\
Find the area of the intersection of sets given by algebraic conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "\[Pi]"}]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39786328]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134184726]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8522],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"And", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"True", "False"},
    {"False", "False"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8122473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->485940985],

Cell[TextData[{
 Cell[BoxData["&&"], "InlineFormula"],
 " has higher precedence than ",
 Cell[BoxData["||"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135203284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "||", 
   RowBox[{"q", "&&", "r"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692597311],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Or", "[", 
    RowBox[{"p", ",", 
     RowBox[{"And", "[", 
      RowBox[{"q", ",", "r"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->671180333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142937236],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->567610107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "d", "||", "e"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306334394],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "||", "b"}], ")"}], "&&", 
  RowBox[{"(", 
   RowBox[{"c", "||", "d", "||", "e"}], ")"}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261456247]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->622865612],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "d"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"a", "&&", "e"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "c"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "d"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"b", "&&", "e"}], ")"}]}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452349729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->377524784],

Cell[TextData[{
 "De Morgan's laws relate ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->346309266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "&&", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238943236],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "||", 
  RowBox[{"!", "b"}]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339542950]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"a", "||", "b", "||", "c"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->864089889],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "a"}], "&&", 
  RowBox[{"!", "b"}], "&&", 
  RowBox[{"!", "c"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18117625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428778285],

Cell[TextData[{
 "Conjunction of conditions corresponds to the product or ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Boole", "[", "a", "]"}], 
   RowBox[{"Boole", "[", "b", "]"}]}], "-", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "&&", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Boole", "[", "a", "]"}], " ", 
   RowBox[{"Boole", "[", "b", "]"}]}], "-", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "&&", "b"}], "]"}]}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722646131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150644775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{"Boole", "[", "a", "]"}], ",", 
    RowBox[{"Boole", "[", "b", "]"}]}], "]"}], "-", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "&&", "b"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99652178],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Boole", "[", 
    RowBox[{"a", "&&", "b"}], "]"}]}], "+", 
  RowBox[{"Min", "[", 
   RowBox[{
    RowBox[{"Boole", "[", "a", "]"}], ",", 
    RowBox[{"Boole", "[", "b", "]"}]}], "]"}]}]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->160193613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->235326747],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->54779196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190795861],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " to thread over lists:"
}], "ExampleText",
 CellID->22238643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}], "&&", 
  RowBox[{"{", 
   RowBox[{"r", ",", "s"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3775642],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p", ",", "q"}], "}"}], "&&", 
  RowBox[{"{", 
   RowBox[{"r", ",", "s"}], "}"}]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5052340]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2943970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "&&", "r"}], ",", 
   RowBox[{"q", "&&", "s"}]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35570739]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14523],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11171],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->20654],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->251570994],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->65985895]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"And (&&, \[And]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 10.6426574}", "context" -> "System`", 
    "keywords" -> {
     "ampersand", "combine conditions", "and", "logical product", "meet", 
      "intersection", "logical connective", "Boolean algebra", 
      "switching algebra"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "e_1 && e_2 && ... is the logical AND function. It evaluates its \
arguments in order, giving False immediately if any of them are False, and \
True if they are all True. ", 
    "synonyms" -> {"conjunction", "double-ampersand", "&", "&&"}, "title" -> 
    "And", "type" -> "Symbol", "uri" -> "ref/And"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7610, 258, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56213387]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 62964, 2057}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2380, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3003, 84, 105, 4, 70, "ObjectName",
 CellID->21409],
Cell[3111, 90, 1197, 39, 70, "Usage",
 CellID->28607]
}, Open  ]],
Cell[CellGroupData[{
Cell[4345, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4823, 151, 1418, 51, 70, "Notes",
 CellID->18038],
Cell[6244, 204, 888, 31, 70, "Notes",
 CellID->4360],
Cell[7135, 237, 438, 16, 70, "Notes",
 CellID->5471]
}, Closed]],
Cell[CellGroupData[{
Cell[7610, 258, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56213387],
Cell[CellGroupData[{
Cell[7994, 272, 148, 5, 70, "ExampleSection",
 CellID->748598120],
Cell[8145, 279, 126, 5, 70, "ExampleText",
 CellID->48276095],
Cell[CellGroupData[{
Cell[8296, 288, 140, 5, 28, "Input",
 CellID->129342052],
Cell[8439, 295, 161, 5, 36, "Output",
 CellID->102995250]
}, Open  ]],
Cell[8615, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->276014806],
Cell[8743, 308, 66, 1, 70, "ExampleText",
 CellID->257061919],
Cell[CellGroupData[{
Cell[8834, 313, 121, 4, 70, "Input",
 CellID->40726281],
Cell[8958, 319, 209, 7, 36, "Output",
 CellID->40007331]
}, Open  ]],
Cell[9182, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->143517902],
Cell[9310, 334, 65, 1, 70, "ExampleText",
 CellID->497418773],
Cell[CellGroupData[{
Cell[9400, 339, 261, 10, 70, "Input",
 CellID->370474334],
Cell[9664, 351, 365, 13, 36, "Output",
 CellID->168720589]
}, Open  ]],
Cell[10044, 367, 124, 3, 70, "ExampleDelimiter",
 CellID->94842956],
Cell[10171, 372, 238, 8, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[10434, 384, 97, 3, 70, "Input",
 CellID->162312622],
Cell[10534, 389, 181, 6, 36, "Output",
 CellID->510274983]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10764, 401, 220, 7, 70, "ExampleSection",
 CellID->261099208],
Cell[10987, 410, 203, 7, 70, "ExampleText",
 CellID->234037899],
Cell[CellGroupData[{
Cell[11215, 421, 131, 4, 70, "Input",
 CellID->11849551],
Cell[11349, 427, 191, 6, 36, "Output",
 CellID->25332789]
}, Open  ]],
Cell[11555, 436, 182, 7, 70, "ExampleText",
 CellID->60318973],
Cell[CellGroupData[{
Cell[11762, 447, 212, 7, 70, "Input",
 CellID->237186586],
Cell[11977, 456, 355, 13, 50, "Output",
 CellID->809328553]
}, Open  ]],
Cell[12347, 472, 125, 3, 70, "ExampleDelimiter",
 CellID->213761091],
Cell[12475, 477, 492, 18, 70, "ExampleText",
 CellID->18400621],
Cell[CellGroupData[{
Cell[12992, 499, 135, 4, 70, "Input",
 CellID->534512268],
Cell[13130, 505, 181, 6, 36, "Output",
 CellID->551767323]
}, Open  ]],
Cell[CellGroupData[{
Cell[13348, 516, 136, 4, 70, "Input",
 CellID->599319570],
Cell[13487, 522, 162, 5, 36, "Output",
 CellID->181516140]
}, Open  ]],
Cell[13664, 530, 124, 3, 70, "ExampleDelimiter",
 CellID->39071304],
Cell[13791, 535, 409, 14, 70, "ExampleText",
 CellID->76232233],
Cell[CellGroupData[{
Cell[14225, 553, 245, 8, 70, "Input",
 CellID->201736223],
Cell[14473, 563, 91, 2, 70, "Print",
 CellID->325449066],
Cell[14567, 567, 162, 5, 36, "Output",
 CellID->441033345]
}, Open  ]],
Cell[CellGroupData[{
Cell[14766, 577, 244, 8, 70, "Input",
 CellID->200768372],
Cell[CellGroupData[{
Cell[15035, 589, 91, 2, 70, "Print",
 CellID->667683752],
Cell[15129, 593, 91, 2, 70, "Print",
 CellID->182029445]
}, Open  ]],
Cell[15235, 598, 160, 5, 36, "Output",
 CellID->66851914]
}, Open  ]],
Cell[15410, 606, 83, 1, 70, "ExampleText",
 CellID->128888979],
Cell[CellGroupData[{
Cell[15518, 611, 236, 8, 70, "Input",
 CellID->700237770],
Cell[15757, 621, 161, 5, 36, "Output",
 CellID->97003387]
}, Open  ]],
Cell[CellGroupData[{
Cell[15955, 631, 236, 8, 70, "Input",
 CellID->602059520],
Cell[16194, 641, 367, 7, 70, "Message",
 CellID->470692662],
Cell[16564, 650, 162, 5, 36, "Output",
 CellID->514649387]
}, Open  ]],
Cell[16741, 658, 125, 3, 70, "ExampleDelimiter",
 CellID->375923361],
Cell[16869, 663, 112, 3, 70, "ExampleText",
 CellID->531520307],
Cell[CellGroupData[{
Cell[17006, 670, 114, 3, 70, "Input",
 CellID->18042936],
Cell[17123, 675, 202, 6, 36, "Output",
 CellID->43300727]
}, Open  ]],
Cell[CellGroupData[{
Cell[17362, 686, 104, 3, 70, "Input",
 CellID->172565786],
Cell[17469, 691, 192, 6, 36, "Output",
 CellID->240895427]
}, Open  ]],
Cell[17676, 700, 125, 3, 70, "ExampleDelimiter",
 CellID->161860430],
Cell[17804, 705, 203, 7, 70, "ExampleText",
 CellID->299487167],
Cell[CellGroupData[{
Cell[18032, 716, 142, 4, 70, "Input",
 CellID->229221090],
Cell[18177, 722, 246, 7, 50, "Output",
 CellID->301206165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18472, 735, 227, 7, 70, "ExampleSection",
 CellID->565495717],
Cell[18702, 744, 140, 6, 70, "ExampleText",
 CellID->102489113],
Cell[18845, 752, 295, 9, 70, "Input",
 CellID->930520182],
Cell[CellGroupData[{
Cell[19165, 765, 110, 3, 70, "Input",
 CellID->15657092],
Cell[19278, 770, 161, 5, 36, "Output",
 CellID->457031668]
}, Open  ]],
Cell[19454, 778, 367, 13, 70, "ExampleText",
 CellID->284165656],
Cell[CellGroupData[{
Cell[19846, 795, 111, 3, 70, "Input",
 CellID->115100274],
Cell[19960, 800, 162, 5, 36, "Output",
 CellID->703935287]
}, Open  ]],
Cell[20137, 808, 391, 14, 70, "ExampleText",
 CellID->35985314],
Cell[20531, 824, 296, 9, 70, "Input",
 CellID->779001943],
Cell[CellGroupData[{
Cell[20852, 837, 110, 3, 70, "Input",
 CellID->9685162],
Cell[20965, 842, 381, 7, 70, "Message",
 CellID->680504771],
Cell[21349, 851, 161, 5, 36, "Output",
 CellID->26178946]
}, Open  ]],
Cell[21525, 859, 125, 3, 70, "ExampleDelimiter",
 CellID->194464135],
Cell[21653, 864, 62, 1, 70, "ExampleText",
 CellID->66247382],
Cell[CellGroupData[{
Cell[21740, 869, 329, 11, 70, "Input",
 CellID->57293133],
Cell[22072, 882, 204, 7, 36, "Output",
 CellID->126951719]
}, Open  ]],
Cell[22291, 892, 124, 3, 70, "ExampleDelimiter",
 CellID->99999606],
Cell[22418, 897, 251, 8, 70, "ExampleText",
 CellID->4442628],
Cell[CellGroupData[{
Cell[22694, 909, 350, 12, 70, "Input",
 CellID->966390519],
Cell[23047, 923, 1062, 39, 96, "Output",
 CellID->78350510]
}, Open  ]],
Cell[24124, 965, 125, 3, 70, "ExampleDelimiter",
 CellID->418832084],
Cell[24252, 970, 199, 8, 70, "ExampleText",
 CellID->141137913],
Cell[CellGroupData[{
Cell[24476, 982, 480, 17, 70, "Input",
 CellID->152893273],
Cell[24959, 1001, 1794, 33, 70, "Output",
 Evaluatable->False,
 CellID->390193401]
}, Open  ]],
Cell[CellGroupData[{
Cell[26790, 1039, 687, 24, 70, "Input",
 CellID->1730688],
Cell[27480, 1065, 16853, 280, 70, "Output",
 Evaluatable->False,
 CellID->225973783]
}, Open  ]],
Cell[44348, 1348, 125, 3, 70, "ExampleDelimiter",
 CellID->165690619],
Cell[44476, 1353, 202, 8, 70, "ExampleText",
 CellID->12039839],
Cell[CellGroupData[{
Cell[44703, 1365, 489, 16, 70, "Input",
 CellID->368008395],
Cell[45195, 1383, 382, 10, 70, "Output",
 Evaluatable->False,
 CellID->159149639]
}, Open  ]],
Cell[45592, 1396, 125, 3, 70, "ExampleDelimiter",
 CellID->313213360],
Cell[45720, 1401, 123, 3, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[45868, 1408, 662, 22, 70, "Input",
 CellID->310451651],
Cell[46533, 1432, 201, 7, 36, "Output",
 CellID->39786328]
}, Open  ]],
Cell[46749, 1442, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[46834, 1447, 595, 21, 70, "Input",
 CellID->167686269],
Cell[47432, 1470, 2506, 45, 70, "Output",
 Evaluatable->False,
 CellID->134184726]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49987, 1521, 232, 7, 70, "ExampleSection",
 CellID->8522],
Cell[50222, 1530, 189, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[50436, 1542, 281, 10, 70, "Input",
 CellID->95768180],
Cell[50720, 1554, 354, 13, 48, "Output",
 CellID->8122473]
}, Open  ]],
Cell[51089, 1570, 125, 3, 70, "ExampleDelimiter",
 CellID->485940985],
Cell[51217, 1575, 170, 6, 70, "ExampleText",
 CellID->135203284],
Cell[CellGroupData[{
Cell[51412, 1585, 149, 5, 70, "Input",
 CellID->692597311],
Cell[51564, 1592, 405, 15, 50, "Output",
 CellID->671180333]
}, Open  ]],
Cell[51984, 1610, 125, 3, 70, "ExampleDelimiter",
 CellID->142937236],
Cell[52112, 1615, 451, 18, 70, "ExampleText",
 CellID->567610107],
Cell[CellGroupData[{
Cell[52588, 1637, 200, 7, 70, "Input",
 CellID->306334394],
Cell[52791, 1646, 289, 10, 36, "Output",
 CellID->261456247]
}, Open  ]],
Cell[CellGroupData[{
Cell[53117, 1661, 109, 3, 70, "Input",
 CellID->622865612],
Cell[53229, 1666, 514, 18, 36, "Output",
 CellID->452349729]
}, Open  ]],
Cell[53758, 1687, 125, 3, 70, "ExampleDelimiter",
 CellID->377524784],
Cell[53886, 1692, 430, 18, 70, "ExampleText",
 CellID->346309266],
Cell[CellGroupData[{
Cell[54341, 1714, 177, 6, 70, "Input",
 CellID->238943236],
Cell[54521, 1722, 217, 8, 36, "Output",
 CellID->339542950]
}, Open  ]],
Cell[CellGroupData[{
Cell[54775, 1735, 188, 6, 70, "Input",
 CellID->864089889],
Cell[54966, 1743, 245, 9, 36, "Output",
 CellID->18117625]
}, Open  ]],
Cell[55226, 1755, 125, 3, 70, "ExampleDelimiter",
 CellID->428778285],
Cell[55354, 1760, 361, 13, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[55740, 1777, 233, 8, 70, "Input",
 CellID->551050724],
Cell[55976, 1787, 327, 11, 36, "Output",
 CellID->722646131]
}, Open  ]],
Cell[CellGroupData[{
Cell[56340, 1803, 103, 3, 70, "Input",
 CellID->40654382],
Cell[56446, 1808, 158, 5, 36, "Output",
 CellID->150644775]
}, Open  ]],
Cell[CellGroupData[{
Cell[56641, 1818, 270, 9, 70, "Input",
 CellID->99652178],
Cell[56914, 1829, 380, 13, 36, "Output",
 CellID->160193613]
}, Open  ]],
Cell[CellGroupData[{
Cell[57331, 1847, 104, 3, 70, "Input",
 CellID->235326747],
Cell[57438, 1852, 157, 5, 36, "Output",
 CellID->54779196]
}, Open  ]],
Cell[57610, 1860, 125, 3, 70, "ExampleDelimiter",
 CellID->190795861],
Cell[57738, 1865, 203, 8, 70, "ExampleText",
 CellID->22238643],
Cell[CellGroupData[{
Cell[57966, 1877, 185, 7, 70, "Input",
 CellID->3775642],
Cell[58154, 1886, 274, 10, 36, "Output",
 CellID->5052340]
}, Open  ]],
Cell[CellGroupData[{
Cell[58465, 1901, 100, 3, 70, "Input",
 CellID->2943970],
Cell[58568, 1906, 252, 9, 36, "Output",
 CellID->35570739]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58881, 1922, 311, 9, 70, "SeeAlsoSection",
 CellID->14523],
Cell[59195, 1933, 1162, 44, 70, "SeeAlso",
 CellID->21229]
}, Open  ]],
Cell[CellGroupData[{
Cell[60394, 1982, 314, 9, 70, "TutorialsSection",
 CellID->11171],
Cell[60711, 1993, 172, 3, 70, "Tutorials",
 CellID->20654],
Cell[60886, 1998, 191, 4, 70, "Tutorials",
 CellID->4500]
}, Open  ]],
Cell[CellGroupData[{
Cell[61114, 2007, 319, 9, 70, "MoreAboutSection",
 CellID->251570994],
Cell[61436, 2018, 156, 3, 70, "MoreAbout",
 CellID->65985895]
}, Open  ]],
Cell[61607, 2024, 50, 0, 70, "History"],
Cell[61660, 2026, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

