(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13732,        448]
NotebookOptionsPosition[     10987,        361]
NotebookOutlinePosition[     12409,        400]
CellTagsIndexPosition[     12324,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DefaultDuration" :> 
         Documentation`HelpLookup["paclet:ref/DefaultDuration"], 
         "RefreshRate" :> Documentation`HelpLookup["paclet:ref/RefreshRate"], 
         "Animate" :> Documentation`HelpLookup["paclet:ref/Animate"], 
         "Animator" :> Documentation`HelpLookup["paclet:ref/Animator"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"DefaultDuration\"\>", 
      2->"\<\"RefreshRate\"\>", 3->"\<\"Animate\"\>", 
      4->"\<\"Animator\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AnimationRate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AnimationRate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AnimationRate"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Animate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Animator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
     " that specifies at what rate an animation should run, in units per \
second. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AnimationRate", "->", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " specifies that the animation variables should be changed by ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " over the course of one second."
}], "Notes",
 CellID->30323],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"AnimationRate", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the rate is determined if possible from settings for options such as ",
 Cell[BoxData[
  ButtonBox["DefaultDuration",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuration"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11153]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34867596],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->49314592],

Cell[TextData[{
 "Specify the animation rate for ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1987570496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animator", "[", 
  RowBox[{"0", ",", 
   RowBox[{"AnimationRate", "\[Rule]", "0.1"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1907647039],

Cell[BoxData[
 AnimatorBox[0,
  AnimationRate->0.1,
  PausedTime->0]], "Output",
 ImageSize->{330, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26183505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145857927],

Cell[TextData[{
 "Specify the animation rate for ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1155337862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{"t", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "t"}], ")"}], 
         RowBox[{"Cos", "[", "x", "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AnimationRate", "\[Rule]", "1"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1751169916],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$16264$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$16264$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[{
         Sin[$CellContext`x], 
         Cos[$CellContext`x], $CellContext`t$$ 
          Sin[$CellContext`x] + (1 - $CellContext`t$$) 
          Cos[$CellContext`x]}, {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`t$$, 0, 1, AnimationRate -> 1, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462804699]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22908],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultDuration",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultDuration"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RefreshRate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RefreshRate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17411]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AnimationRate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 16.9709444}", "context" -> "System`", 
    "keywords" -> {
     "animation speed", "delay time", "frame delay", "frame display time", 
      "frame rate", "frames per second"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AnimationRate is an option for Animate and Animator that specifies at \
what rate an animation should run, in units per second. ", 
    "synonyms" -> {"animation rate", "fps", "framerate"}, "title" -> 
    "AnimationRate", "type" -> "Symbol", "uri" -> "ref/AnimationRate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5149, 161, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34867596]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12182, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 888, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1511, 46, 1578, 37, 70, "ObjectNameGrid"],
Cell[3092, 85, 778, 24, 70, "Usage",
 CellID->29448]
}, Open  ]],
Cell[CellGroupData[{
Cell[3907, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4385, 131, 296, 9, 70, "Notes",
 CellID->30323],
Cell[4684, 142, 428, 14, 70, "Notes",
 CellID->11153]
}, Closed]],
Cell[CellGroupData[{
Cell[5149, 161, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34867596],
Cell[CellGroupData[{
Cell[5533, 175, 147, 5, 70, "ExampleSection",
 CellID->49314592],
Cell[5683, 182, 215, 8, 70, "ExampleText",
 CellID->1987570496],
Cell[CellGroupData[{
Cell[5923, 194, 231, 6, 28, "Input",
 CellID->1907647039],
Cell[6157, 202, 210, 8, 46, "Output",
 CellID->26183505]
}, Open  ]],
Cell[6382, 213, 125, 3, 70, "ExampleDelimiter",
 CellID->145857927],
Cell[6510, 218, 213, 8, 70, "ExampleText",
 CellID->1155337862],
Cell[CellGroupData[{
Cell[6748, 230, 767, 23, 70, "Input",
 CellID->1751169916],
Cell[7518, 255, 2063, 46, 70, "Output",
 CellID->462804699]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9642, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->22908],
Cell[9956, 319, 959, 35, 70, "SeeAlso",
 CellID->17411]
}, Open  ]],
Cell[10930, 357, 27, 0, 70, "History"],
Cell[10960, 359, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

