(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24464,        690]
NotebookOptionsPosition[     21687,        602]
NotebookOutlinePosition[     23110,        642]
CellTagsIndexPosition[     23025,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AnimationRunning" :> 
         Documentation`HelpLookup["paclet:ref/AnimationRunning"], 
         "AnimationRate" :> 
         Documentation`HelpLookup["paclet:ref/AnimationRate"], 
         "AnimationDirection" :> 
         Documentation`HelpLookup["paclet:ref/AnimationDirection"], 
         "AppearanceElements" :> 
         Documentation`HelpLookup["paclet:ref/AppearanceElements"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AnimationRunning\"\>", 
      2->"\<\"AnimationRate\"\>", 3->"\<\"AnimationDirection\"\>", 
      4->"\<\"AppearanceElements\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AnimationRepetitions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AnimationRepetitions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AnimationRepetitions"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Animate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
     " and related functions that specifies how many times the animation they \
create runs before stopping."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AnimationRepetitions", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that the animation should keep running until stopped by clicking \
a button."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["AnimationRepetitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AnimationRepetitions"]], "InlineFormula"],
 " does not need to be an integer."
}], "Notes",
 CellID->592648974]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->995965979],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->652795423],

Cell[TextData[{
 "Control the number of animation cycles in ",
 Cell[BoxData[
  ButtonBox["Animate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->49100634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AnimationRepetitions", "\[Rule]", "3"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1232395666],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 10}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$16860$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$16860$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x + $CellContext`a$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`a$$, 0, 10, AnimationRepetitions -> 
         3, AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {88., 93.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594433781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1178794918],

Cell[TextData[{
 "Control the number of animation cycles in ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1469543251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "y"}], ")"}], "^", "n"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"AnimationRepetitions", "\[Rule]", "3"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403995410],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 11, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$16940$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 11, 1},
                   AnimationRate->Automatic,
                   AnimationRepetitions->3,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->0]}
                },
                ColumnsEqual->False,
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                RowsEqual->False],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->
                RowBox[{"x", "+", "y"}], 3->
                RowBox[{
                 SuperscriptBox["x", "2"], "+", 
                 RowBox[{"2", " ", "x", " ", "y"}], "+", 
                 SuperscriptBox["y", "2"]}], 4->
                RowBox[{
                 SuperscriptBox["x", "3"], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["x", "2"], " ", "y"}], "+", 
                 RowBox[{"3", " ", "x", " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 SuperscriptBox["y", "3"]}], 5->
                RowBox[{
                 SuperscriptBox["x", "4"], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["x", "3"], " ", "y"}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"4", " ", "x", " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 SuperscriptBox["y", "4"]}], 6->
                RowBox[{
                 SuperscriptBox["x", "5"], "+", 
                 RowBox[{"5", " ", 
                  SuperscriptBox["x", "4"], " ", "y"}], "+", 
                 RowBox[{"10", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"10", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"5", " ", "x", " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 SuperscriptBox["y", "5"]}], 7->
                RowBox[{
                 SuperscriptBox["x", "6"], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["x", "5"], " ", "y"}], "+", 
                 RowBox[{"15", " ", 
                  SuperscriptBox["x", "4"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"20", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"15", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 RowBox[{"6", " ", "x", " ", 
                  SuperscriptBox["y", "5"]}], "+", 
                 SuperscriptBox["y", "6"]}], 8->
                RowBox[{
                 SuperscriptBox["x", "7"], "+", 
                 RowBox[{"7", " ", 
                  SuperscriptBox["x", "6"], " ", "y"}], "+", 
                 RowBox[{"21", " ", 
                  SuperscriptBox["x", "5"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"35", " ", 
                  SuperscriptBox["x", "4"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"35", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 RowBox[{"21", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "5"]}], "+", 
                 RowBox[{"7", " ", "x", " ", 
                  SuperscriptBox["y", "6"]}], "+", 
                 SuperscriptBox["y", "7"]}], 9->
                RowBox[{
                 SuperscriptBox["x", "8"], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["x", "7"], " ", "y"}], "+", 
                 RowBox[{"28", " ", 
                  SuperscriptBox["x", "6"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"56", " ", 
                  SuperscriptBox["x", "5"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"70", " ", 
                  SuperscriptBox["x", "4"], " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 RowBox[{"56", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "5"]}], "+", 
                 RowBox[{"28", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "6"]}], "+", 
                 RowBox[{"8", " ", "x", " ", 
                  SuperscriptBox["y", "7"]}], "+", 
                 SuperscriptBox["y", "8"]}], 10->
                RowBox[{
                 SuperscriptBox["x", "9"], "+", 
                 RowBox[{"9", " ", 
                  SuperscriptBox["x", "8"], " ", "y"}], "+", 
                 RowBox[{"36", " ", 
                  SuperscriptBox["x", "7"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"84", " ", 
                  SuperscriptBox["x", "6"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"126", " ", 
                  SuperscriptBox["x", "5"], " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 RowBox[{"126", " ", 
                  SuperscriptBox["x", "4"], " ", 
                  SuperscriptBox["y", "5"]}], "+", 
                 RowBox[{"84", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "6"]}], "+", 
                 RowBox[{"36", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "7"]}], "+", 
                 RowBox[{"9", " ", "x", " ", 
                  SuperscriptBox["y", "8"]}], "+", 
                 SuperscriptBox["y", "9"]}], 11->
                RowBox[{
                 SuperscriptBox["x", "10"], "+", 
                 RowBox[{"10", " ", 
                  SuperscriptBox["x", "9"], " ", "y"}], "+", 
                 RowBox[{"45", " ", 
                  SuperscriptBox["x", "8"], " ", 
                  SuperscriptBox["y", "2"]}], "+", 
                 RowBox[{"120", " ", 
                  SuperscriptBox["x", "7"], " ", 
                  SuperscriptBox["y", "3"]}], "+", 
                 RowBox[{"210", " ", 
                  SuperscriptBox["x", "6"], " ", 
                  SuperscriptBox["y", "4"]}], "+", 
                 RowBox[{"252", " ", 
                  SuperscriptBox["x", "5"], " ", 
                  SuperscriptBox["y", "5"]}], "+", 
                 RowBox[{"210", " ", 
                  SuperscriptBox["x", "4"], " ", 
                  SuperscriptBox["y", "6"]}], "+", 
                 RowBox[{"120", " ", 
                  SuperscriptBox["x", "3"], " ", 
                  SuperscriptBox["y", "7"]}], "+", 
                 RowBox[{"45", " ", 
                  SuperscriptBox["x", "2"], " ", 
                  SuperscriptBox["y", "8"]}], "+", 
                 RowBox[{"10", " ", "x", " ", 
                  SuperscriptBox["y", "9"]}], "+", 
                 SuperscriptBox["y", "10"]}]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0,
               Background->GrayLevel[1]],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False,
             GraphicsBoxOptions->{PreserveImageOptions->True},
             Graphics3DBoxOptions->{PreserveImageOptions->True}],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         ColumnsEqual->False,
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$16940$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 11, 1}, 11, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{518., {42.5, 47.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{538, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107977362]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimationRunning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationRunning"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimationRate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationRate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimationDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationDirection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppearanceElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppearanceElements"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AnimationRepetitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 18.3303542}", "context" -> "System`", 
    "keywords" -> {
     "animation loop", "play once", "animation cycle", 
      "animation loop count"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AnimationRepetitions is an option to Animate and related functions that \
specifies how many times the animation they create runs before stopping.", 
    "synonyms" -> {"animation repetitions"}, "title" -> 
    "AnimationRepetitions", "type" -> "Symbol", "uri" -> 
    "ref/AnimationRepetitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4980, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->995965979]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22882, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 989, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1612, 49, 1585, 37, 70, "ObjectNameGrid"],
Cell[3200, 88, 672, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3909, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4387, 129, 305, 9, 70, "Notes",
 CellID->1067943069],
Cell[4695, 140, 248, 8, 70, "Notes",
 CellID->592648974]
}, Closed]],
Cell[CellGroupData[{
Cell[4980, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->995965979],
Cell[CellGroupData[{
Cell[5365, 167, 148, 5, 70, "ExampleSection",
 CellID->652795423],
Cell[5516, 174, 222, 8, 70, "ExampleText",
 CellID->49100634],
Cell[CellGroupData[{
Cell[5763, 186, 486, 14, 47, "Input",
 CellID->1232395666],
Cell[6252, 202, 1952, 43, 204, "Output",
 CellID->594433781]
}, Open  ]],
Cell[8219, 248, 126, 3, 70, "ExampleDelimiter",
 CellID->1178794918],
Cell[8348, 253, 232, 8, 70, "ExampleText",
 CellID->1469543251],
Cell[CellGroupData[{
Cell[8605, 265, 480, 14, 70, "Input",
 CellID->403995410],
Cell[9088, 281, 11136, 261, 70, "Output",
 CellID->107977362]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20285, 549, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20604, 560, 1011, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[21630, 598, 27, 0, 70, "History"],
Cell[21660, 600, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

