(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35022,       1091]
NotebookOptionsPosition[     29981,        918]
NotebookOutlinePosition[     31335,        956]
CellTagsIndexPosition[     31250,        951]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rasterize" :> Documentation`HelpLookup["paclet:ref/Rasterize"],
           "PlotPoints" :> 
          Documentation`HelpLookup["paclet:ref/PlotPoints"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rasterize\"\>", 
       2->"\<\"PlotPoints\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Antialiasing", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Antialiasing",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Antialiasing"]], "InlineFormula"],
     "\[LineSeparator]is a ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " option which specifies whether antialiasing should be done in \
rendering 2D graphics. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23088]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Antialiasing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Antialiasing"]], "InlineFormula"],
 " fuzzes out edges of graphical elements so as to avoid the appearance of \
jaggedness associated with discrete screen pixels. "
}], "Notes",
 CellID->12245],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Antialiasing", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", choices are made to optimize appearance on each type of computer system. \
"
}], "Notes",
 CellID->6231],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Antialiasing", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", black lines may appear slightly gray. "
}], "Notes",
 CellID->31920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Antialiasing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Antialiasing"]], "InlineFormula"],
 " can be turned on and off not just for complete graphics, but also for \
individual primitives or groups of primitives within a single graphic."
}], "Notes",
 CellID->12596760],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Antialiasing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Antialiasing"]], "InlineFormula"],
 " does not alter the appearance of fonts. Font antialiasing is typically \
controlled by a global operating system setting."
}], "Notes",
 CellID->387662580]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32674114],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->115906283],

Cell["Use antialiasing by default:", "ExampleText",
 CellID->195867228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4666290],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}]],
  StripOnInput->False,
  Antialiasing->True]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->151498524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37963061],

Cell["Turn off the antialiasing:", "ExampleText",
 CellID->73392904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495981589],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}]],
  StripOnInput->False,
  Antialiasing->False]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->412648383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->492640998],

Cell["\<\
Control antialiasing behavior for individual parts of the graphics: \
\>", "ExampleText",
 CellID->134926550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245244818],

Cell[BoxData[
 GraphicsBox[{
   StyleBox[CircleBox[{0, 0}],
    StripOnInput->False,
    Antialiasing->True], 
   StyleBox[CircleBox[{1, 0}],
    StripOnInput->False,
    Antialiasing->False]}]], "Output",
 ImageSize->{154, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->126268296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24122],

Cell["Antialiasing of lines:", "ExampleText",
 CellID->190330041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "4"}], "}"}]}], "}"}], "]"}], "}"}], "]"}], ",", 
     
     RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "4"}], "}"}]}], "}"}], "]"}], "}"}], "]"}], ",", 
     
     RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->36208949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[LineBox[{{0, 0}, {7, 4}}]],
    StripOnInput->False,
    Antialiasing->True], ",", 
   StyleBox[
    GraphicsBox[LineBox[{{0, 0}, {7, 4}}]],
    StripOnInput->False,
    Antialiasing->False]}], "}"}]], "Output",
 ImageSize->{230, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->271261919]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18706],

Cell[BoxData[
 RowBox[{"Clear", "[", "lines", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->745537859]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10189],

Cell["\<\
Aliasing is more apparent when the graphic is not aligned with the axes:\
\>", "ExampleText",
 CellID->96458484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Rectangle", "[", "]"}], ",", 
          RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", "]"}], ",", 
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Rectangle", "[", "]"}], ",", 
          RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->244798821],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[
     {EdgeForm[GrayLevel[0]], FaceForm[None], 
      GeometricTransformationBox[
       RectangleBox[{0, 0}], {{{0.8090169943749475, -0.5877852522924731}, {
        0.5877852522924731, 0.8090169943749475}}, Center}]}],
    StripOnInput->False,
    Antialiasing->True], ",", 
   StyleBox[
    GraphicsBox[
     {EdgeForm[GrayLevel[0]], FaceForm[None], 
      GeometricTransformationBox[
       RectangleBox[{0, 0}], {{{0.8090169943749475, -0.5877852522924731}, {
        0.5877852522924731, 0.8090169943749475}}, Center}]}],
    StripOnInput->False,
    Antialiasing->False]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->171978536]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11156],

Cell["\<\
On some computer systems, antialiased lines may look slightly thick and gray:\
\
\>", "ExampleText",
 CellID->680583245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FaceForm", "[", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "100.5"}]}], "]"}], ",", 
     RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FaceForm", "[", "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Rectangle", "[", "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "100.5"}]}], "]"}], ",", 
     RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->48063231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[
     {EdgeForm[GrayLevel[0]], FaceForm[None], RectangleBox[{0, 0}]},
     ImageSize->100.5],
    StripOnInput->False,
    Antialiasing->True], ",", 
   StyleBox[
    GraphicsBox[
     {EdgeForm[GrayLevel[0]], FaceForm[None], RectangleBox[{0, 0}]},
     ImageSize->100.5],
    StripOnInput->False,
    Antialiasing->False]}], "}"}]], "Output",
 ImageSize->{232, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171042935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40052206],

Cell[TextData[{
 "Font antialiasing depends on the system. ",
 Cell[BoxData[
  ButtonBox["Antialiasing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Antialiasing"]], "InlineFormula"],
 " has no effect:"
}], "ExampleText",
 CellID->79924646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Text", "@", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<AaBbCc\>\"", ",", "Large", ",", 
      RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}]}], ",", 
   RowBox[{"Text", "@", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<AaBbCc\>\"", ",", "Large", ",", 
      RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34337942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      Antialiasing->True,
      FontSize->Large]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, Antialiasing -> True]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      Antialiasing->False,
      FontSize->Large]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, Antialiasing -> False]]]}], "}"}]], "Output",
 ImageSize->{196, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11968525]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12351],

Cell["\<\
Moir\[EAcute] patterns in antialiased and non-antialiased graphics:\
\>", "ExampleText",
 CellID->352597339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"1", "-", "x"}]}], "}"}]}], "}"}]}], "}"}], "]"}], ",",
         
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "1", ",", ".02"}], "}"}]}], "]"}], "]"}],
      ",", 
     RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "-", "x"}], ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"1", "-", "x"}]}], "}"}]}], "}"}]}], "}"}], "]"}], ",",
         
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "1", ",", ".02"}], "}"}]}], "]"}], "]"}],
      ",", 
     RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->466129101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[{LineBox[{{{0., 0}, {1., 1}}, {{0, 0.}, {1, 1.}}}], 
      LineBox[{{{0.02, 0}, {0.98, 1}}, {{0, 0.02}, {1, 0.98}}}], 
      LineBox[{{{0.04, 0}, {0.96, 1}}, {{0, 0.04}, {1, 0.96}}}], 
      LineBox[{{{0.06, 0}, {0.94, 1}}, {{0, 0.06}, {1, 0.94}}}], 
      LineBox[{{{0.08, 0}, {0.92, 1}}, {{0, 0.08}, {1, 0.92}}}], 
      LineBox[{{{0.1, 0}, {0.9, 1}}, {{0, 0.1}, {1, 0.9}}}], 
      LineBox[{{{0.12, 0}, {0.88, 1}}, {{0, 0.12}, {1, 0.88}}}], 
      LineBox[{{{0.14, 0}, {0.86, 1}}, {{0, 0.14}, {1, 0.86}}}], 
      LineBox[{{{0.16, 0}, {0.84, 1}}, {{0, 0.16}, {1, 0.84}}}], 
      LineBox[{{{0.18, 0}, {0.8200000000000001, 1}}, {{0, 0.18}, {
         1, 0.8200000000000001}}}], 
      LineBox[{{{0.2, 0}, {0.8, 1}}, {{0, 0.2}, {1, 0.8}}}], 
      LineBox[{{{0.22, 0}, {0.78, 1}}, {{0, 0.22}, {1, 0.78}}}], 
      LineBox[{{{0.24, 0}, {0.76, 1}}, {{0, 0.24}, {1, 0.76}}}], 
      LineBox[{{{0.26, 0}, {0.74, 1}}, {{0, 0.26}, {1, 0.74}}}], 
      LineBox[{{{0.28, 0}, {0.72, 1}}, {{0, 0.28}, {1, 0.72}}}], 
      LineBox[{{{0.3, 0}, {0.7, 1}}, {{0, 0.3}, {1, 0.7}}}], 
      LineBox[{{{0.32, 0}, {0.6799999999999999, 1}}, {{0, 0.32}, {
         1, 0.6799999999999999}}}], 
      LineBox[{{{0.34, 0}, {0.6599999999999999, 1}}, {{0, 0.34}, {
         1, 0.6599999999999999}}}], 
      LineBox[{{{0.36, 0}, {0.64, 1}}, {{0, 0.36}, {1, 0.64}}}], 
      LineBox[{{{0.38, 0}, {0.62, 1}}, {{0, 0.38}, {1, 0.62}}}], 
      LineBox[{{{0.4, 0}, {0.6, 1}}, {{0, 0.4}, {1, 0.6}}}], 
      LineBox[{{{0.42, 0}, {0.5800000000000001, 1}}, {{0, 0.42}, {
         1, 0.5800000000000001}}}], 
      LineBox[{{{0.44, 0}, {0.56, 1}}, {{0, 0.44}, {1, 0.56}}}], 
      LineBox[{{{0.46, 0}, {0.54, 1}}, {{0, 0.46}, {1, 0.54}}}], 
      LineBox[{{{0.48, 0}, {0.52, 1}}, {{0, 0.48}, {1, 0.52}}}], 
      LineBox[{{{0.5, 0}, {0.5, 1}}, {{0, 0.5}, {1, 0.5}}}], 
      LineBox[{{{0.52, 0}, {0.48, 1}}, {{0, 0.52}, {1, 0.48}}}], 
      LineBox[{{{0.54, 0}, {0.45999999999999996`, 1}}, {{0, 0.54}, {
         1, 0.45999999999999996`}}}], 
      LineBox[{{{0.56, 0}, {0.43999999999999995`, 1}}, {{0, 0.56}, {
         1, 0.43999999999999995`}}}], 
      LineBox[{{{0.58, 0}, {0.42000000000000004`, 1}}, {{0, 0.58}, {
         1, 0.42000000000000004`}}}], 
      LineBox[{{{0.6, 0}, {0.4, 1}}, {{0, 0.6}, {1, 0.4}}}], 
      LineBox[{{{0.62, 0}, {0.38, 1}}, {{0, 0.62}, {1, 0.38}}}], 
      LineBox[{{{0.64, 0}, {0.36, 1}}, {{0, 0.64}, {1, 0.36}}}], 
      LineBox[{{{0.66, 0}, {0.33999999999999997`, 1}}, {{0, 0.66}, {
         1, 0.33999999999999997`}}}], 
      LineBox[{{{0.68, 0}, {0.31999999999999995`, 1}}, {{0, 0.68}, {
         1, 0.31999999999999995`}}}], 
      LineBox[{{{0.7000000000000001, 0}, {0.29999999999999993`, 1}}, {{
         0, 0.7000000000000001}, {1, 0.29999999999999993`}}}], 
      LineBox[{{{0.72, 0}, {0.28, 1}}, {{0, 0.72}, {1, 0.28}}}], 
      LineBox[{{{0.74, 0}, {0.26, 1}}, {{0, 0.74}, {1, 0.26}}}], 
      LineBox[{{{0.76, 0}, {0.24, 1}}, {{0, 0.76}, {1, 0.24}}}], 
      LineBox[{{{0.78, 0}, {0.21999999999999997`, 1}}, {{0, 0.78}, {
         1, 0.21999999999999997`}}}], 
      LineBox[{{{0.8, 0}, {0.19999999999999996`, 1}}, {{0, 0.8}, {
         1, 0.19999999999999996`}}}], 
      LineBox[{{{0.8200000000000001, 0}, {0.17999999999999994`, 1}}, {{
         0, 0.8200000000000001}, {1, 0.17999999999999994`}}}], 
      LineBox[{{{0.84, 0}, {0.16000000000000003`, 1}}, {{0, 0.84}, {
         1, 0.16000000000000003`}}}], 
      LineBox[{{{0.86, 0}, {0.14, 1}}, {{0, 0.86}, {1, 0.14}}}], 
      LineBox[{{{0.88, 0}, {0.12, 1}}, {{0, 0.88}, {1, 0.12}}}], 
      LineBox[{{{0.9, 0}, {0.09999999999999998, 1}}, {{0, 0.9}, {
         1, 0.09999999999999998}}}], 
      LineBox[{{{0.92, 0}, {0.07999999999999996, 1}}, {{0, 0.92}, {
         1, 0.07999999999999996}}}], 
      LineBox[{{{0.9400000000000001, 0}, {0.05999999999999994, 1}}, {{
         0, 0.9400000000000001}, {1, 0.05999999999999994}}}], 
      LineBox[{{{0.96, 0}, {0.040000000000000036`, 1}}, {{0, 0.96}, {
         1, 0.040000000000000036`}}}], 
      LineBox[{{{0.98, 0}, {0.020000000000000018`, 1}}, {{0, 0.98}, {
         1, 0.020000000000000018`}}}], 
      LineBox[{{{1., 0}, {0., 1}}, {{0, 1.}, {1, 0.}}}]}],
    StripOnInput->False,
    Antialiasing->True], ",", 
   StyleBox[
    GraphicsBox[{LineBox[{{{0., 0}, {1., 1}}, {{0, 0.}, {1, 1.}}}], 
      LineBox[{{{0.02, 0}, {0.98, 1}}, {{0, 0.02}, {1, 0.98}}}], 
      LineBox[{{{0.04, 0}, {0.96, 1}}, {{0, 0.04}, {1, 0.96}}}], 
      LineBox[{{{0.06, 0}, {0.94, 1}}, {{0, 0.06}, {1, 0.94}}}], 
      LineBox[{{{0.08, 0}, {0.92, 1}}, {{0, 0.08}, {1, 0.92}}}], 
      LineBox[{{{0.1, 0}, {0.9, 1}}, {{0, 0.1}, {1, 0.9}}}], 
      LineBox[{{{0.12, 0}, {0.88, 1}}, {{0, 0.12}, {1, 0.88}}}], 
      LineBox[{{{0.14, 0}, {0.86, 1}}, {{0, 0.14}, {1, 0.86}}}], 
      LineBox[{{{0.16, 0}, {0.84, 1}}, {{0, 0.16}, {1, 0.84}}}], 
      LineBox[{{{0.18, 0}, {0.8200000000000001, 1}}, {{0, 0.18}, {
         1, 0.8200000000000001}}}], 
      LineBox[{{{0.2, 0}, {0.8, 1}}, {{0, 0.2}, {1, 0.8}}}], 
      LineBox[{{{0.22, 0}, {0.78, 1}}, {{0, 0.22}, {1, 0.78}}}], 
      LineBox[{{{0.24, 0}, {0.76, 1}}, {{0, 0.24}, {1, 0.76}}}], 
      LineBox[{{{0.26, 0}, {0.74, 1}}, {{0, 0.26}, {1, 0.74}}}], 
      LineBox[{{{0.28, 0}, {0.72, 1}}, {{0, 0.28}, {1, 0.72}}}], 
      LineBox[{{{0.3, 0}, {0.7, 1}}, {{0, 0.3}, {1, 0.7}}}], 
      LineBox[{{{0.32, 0}, {0.6799999999999999, 1}}, {{0, 0.32}, {
         1, 0.6799999999999999}}}], 
      LineBox[{{{0.34, 0}, {0.6599999999999999, 1}}, {{0, 0.34}, {
         1, 0.6599999999999999}}}], 
      LineBox[{{{0.36, 0}, {0.64, 1}}, {{0, 0.36}, {1, 0.64}}}], 
      LineBox[{{{0.38, 0}, {0.62, 1}}, {{0, 0.38}, {1, 0.62}}}], 
      LineBox[{{{0.4, 0}, {0.6, 1}}, {{0, 0.4}, {1, 0.6}}}], 
      LineBox[{{{0.42, 0}, {0.5800000000000001, 1}}, {{0, 0.42}, {
         1, 0.5800000000000001}}}], 
      LineBox[{{{0.44, 0}, {0.56, 1}}, {{0, 0.44}, {1, 0.56}}}], 
      LineBox[{{{0.46, 0}, {0.54, 1}}, {{0, 0.46}, {1, 0.54}}}], 
      LineBox[{{{0.48, 0}, {0.52, 1}}, {{0, 0.48}, {1, 0.52}}}], 
      LineBox[{{{0.5, 0}, {0.5, 1}}, {{0, 0.5}, {1, 0.5}}}], 
      LineBox[{{{0.52, 0}, {0.48, 1}}, {{0, 0.52}, {1, 0.48}}}], 
      LineBox[{{{0.54, 0}, {0.45999999999999996`, 1}}, {{0, 0.54}, {
         1, 0.45999999999999996`}}}], 
      LineBox[{{{0.56, 0}, {0.43999999999999995`, 1}}, {{0, 0.56}, {
         1, 0.43999999999999995`}}}], 
      LineBox[{{{0.58, 0}, {0.42000000000000004`, 1}}, {{0, 0.58}, {
         1, 0.42000000000000004`}}}], 
      LineBox[{{{0.6, 0}, {0.4, 1}}, {{0, 0.6}, {1, 0.4}}}], 
      LineBox[{{{0.62, 0}, {0.38, 1}}, {{0, 0.62}, {1, 0.38}}}], 
      LineBox[{{{0.64, 0}, {0.36, 1}}, {{0, 0.64}, {1, 0.36}}}], 
      LineBox[{{{0.66, 0}, {0.33999999999999997`, 1}}, {{0, 0.66}, {
         1, 0.33999999999999997`}}}], 
      LineBox[{{{0.68, 0}, {0.31999999999999995`, 1}}, {{0, 0.68}, {
         1, 0.31999999999999995`}}}], 
      LineBox[{{{0.7000000000000001, 0}, {0.29999999999999993`, 1}}, {{
         0, 0.7000000000000001}, {1, 0.29999999999999993`}}}], 
      LineBox[{{{0.72, 0}, {0.28, 1}}, {{0, 0.72}, {1, 0.28}}}], 
      LineBox[{{{0.74, 0}, {0.26, 1}}, {{0, 0.74}, {1, 0.26}}}], 
      LineBox[{{{0.76, 0}, {0.24, 1}}, {{0, 0.76}, {1, 0.24}}}], 
      LineBox[{{{0.78, 0}, {0.21999999999999997`, 1}}, {{0, 0.78}, {
         1, 0.21999999999999997`}}}], 
      LineBox[{{{0.8, 0}, {0.19999999999999996`, 1}}, {{0, 0.8}, {
         1, 0.19999999999999996`}}}], 
      LineBox[{{{0.8200000000000001, 0}, {0.17999999999999994`, 1}}, {{
         0, 0.8200000000000001}, {1, 0.17999999999999994`}}}], 
      LineBox[{{{0.84, 0}, {0.16000000000000003`, 1}}, {{0, 0.84}, {
         1, 0.16000000000000003`}}}], 
      LineBox[{{{0.86, 0}, {0.14, 1}}, {{0, 0.86}, {1, 0.14}}}], 
      LineBox[{{{0.88, 0}, {0.12, 1}}, {{0, 0.88}, {1, 0.12}}}], 
      LineBox[{{{0.9, 0}, {0.09999999999999998, 1}}, {{0, 0.9}, {
         1, 0.09999999999999998}}}], 
      LineBox[{{{0.92, 0}, {0.07999999999999996, 1}}, {{0, 0.92}, {
         1, 0.07999999999999996}}}], 
      LineBox[{{{0.9400000000000001, 0}, {0.05999999999999994, 1}}, {{
         0, 0.9400000000000001}, {1, 0.05999999999999994}}}], 
      LineBox[{{{0.96, 0}, {0.040000000000000036`, 1}}, {{0, 0.96}, {
         1, 0.040000000000000036`}}}], 
      LineBox[{{{0.98, 0}, {0.020000000000000018`, 1}}, {{0, 0.98}, {
         1, 0.020000000000000018`}}}], 
      LineBox[{{{1., 0}, {0., 1}}, {{0, 1.}, {1, 0.}}}]}],
    StripOnInput->False,
    Antialiasing->False]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195407760]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15258],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->95433891],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->330137492]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Antialiasing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 21.1429262}", "context" -> "System`", 
    "keywords" -> {
     "aliasing", "dithering", "focusing", "fuzziness", "pixel averaging", 
      "sharpening", "sharp lines"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Antialiasing is a Style option which specifies whether antialiasing \
should be done in rendering 2D graphics. ", "synonyms" -> {}, "title" -> 
    "Antialiasing", "type" -> "Symbol", "uri" -> "ref/Antialiasing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6381, 199, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32674114]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31108, 944}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1509, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2132, 63, 1577, 37, 70, "ObjectNameGrid"],
Cell[3712, 102, 622, 19, 70, "Usage",
 CellID->23088]
}, Open  ]],
Cell[CellGroupData[{
Cell[4371, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4849, 143, 301, 8, 70, "Notes",
 CellID->12245],
Cell[5153, 153, 313, 10, 70, "Notes",
 CellID->6231],
Cell[5469, 165, 247, 9, 70, "Notes",
 CellID->31920],
Cell[5719, 176, 321, 8, 70, "Notes",
 CellID->12596760],
Cell[6043, 186, 301, 8, 70, "Notes",
 CellID->387662580]
}, Closed]],
Cell[CellGroupData[{
Cell[6381, 199, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32674114],
Cell[CellGroupData[{
Cell[6765, 213, 148, 5, 70, "ExampleSection",
 CellID->115906283],
Cell[6916, 220, 71, 1, 70, "ExampleText",
 CellID->195867228],
Cell[CellGroupData[{
Cell[7012, 225, 232, 7, 28, "Input",
 CellID->4666290],
Cell[7247, 234, 299, 10, 121, "Output",
 CellID->151498524]
}, Open  ]],
Cell[7561, 247, 124, 3, 70, "ExampleDelimiter",
 CellID->37963061],
Cell[7688, 252, 68, 1, 70, "ExampleText",
 CellID->73392904],
Cell[CellGroupData[{
Cell[7781, 257, 235, 7, 70, "Input",
 CellID->495981589],
Cell[8019, 266, 300, 10, 121, "Output",
 CellID->412648383]
}, Open  ]],
Cell[8334, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->492640998],
Cell[8462, 284, 119, 3, 70, "ExampleText",
 CellID->134926550],
Cell[CellGroupData[{
Cell[8606, 291, 495, 16, 70, "Input",
 CellID->245244818],
Cell[9104, 309, 389, 13, 123, "Output",
 CellID->126268296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9542, 328, 216, 7, 70, "ExampleSection",
 CellID->24122],
Cell[9761, 337, 65, 1, 70, "ExampleText",
 CellID->190330041],
Cell[CellGroupData[{
Cell[9851, 342, 936, 32, 70, "Input",
 CellID->36208949],
Cell[10790, 376, 463, 16, 82, "Output",
 CellID->271261919]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11302, 398, 223, 7, 70, "ExampleSection",
 CellID->18706],
Cell[11528, 407, 105, 3, 70, "Input",
 CellID->745537859]
}, Closed]],
Cell[CellGroupData[{
Cell[11670, 415, 233, 7, 70, "ExampleSection",
 CellID->10189],
Cell[11906, 424, 122, 3, 70, "ExampleText",
 CellID->96458484],
Cell[CellGroupData[{
Cell[12053, 431, 1001, 30, 70, "Input",
 CellID->244798821],
Cell[13057, 463, 848, 24, 123, "Output",
 CellID->171978536]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13954, 493, 226, 7, 70, "ExampleSection",
 CellID->11156],
Cell[14183, 502, 130, 4, 70, "ExampleText",
 CellID->680583245],
Cell[CellGroupData[{
Cell[14338, 510, 950, 28, 70, "Input",
 CellID->48063231],
Cell[15291, 540, 544, 19, 123, "Output",
 CellID->171042935]
}, Open  ]],
Cell[15850, 562, 124, 3, 70, "ExampleDelimiter",
 CellID->40052206],
Cell[15977, 567, 245, 8, 70, "ExampleText",
 CellID->79924646],
Cell[CellGroupData[{
Cell[16247, 579, 440, 13, 70, "Input",
 CellID->34337942],
Cell[16690, 594, 643, 21, 51, "Output",
 CellID->11968525]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17382, 621, 224, 7, 70, "ExampleSection",
 CellID->12351],
Cell[17609, 630, 118, 3, 70, "ExampleText",
 CellID->352597339],
Cell[CellGroupData[{
Cell[17752, 637, 1901, 60, 70, "Input",
 CellID->466129101],
Cell[19656, 699, 8720, 153, 203, "Output",
 CellID->195407760]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28437, 859, 311, 9, 70, "SeeAlsoSection",
 CellID->15258],
Cell[28751, 870, 457, 17, 70, "SeeAlso",
 CellID->18716]
}, Open  ]],
Cell[CellGroupData[{
Cell[29245, 892, 299, 8, 70, "MoreAboutSection"],
Cell[29547, 902, 162, 3, 70, "MoreAbout",
 CellID->95433891],
Cell[29712, 907, 197, 4, 70, "MoreAbout",
 CellID->330137492]
}, Open  ]],
Cell[29924, 914, 27, 0, 70, "History"],
Cell[29954, 916, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

