(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34341,       1222]
NotebookOptionsPosition[     28259,       1009]
NotebookOutlinePosition[     29572,       1046]
CellTagsIndexPosition[     29486,       1041]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Rational Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Together" :> Documentation`HelpLookup["paclet:ref/Together"], 
          "ApartSquareFree" :> 
          Documentation`HelpLookup["paclet:ref/ApartSquareFree"], "Cancel" :> 
          Documentation`HelpLookup["paclet:ref/Cancel"], "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Together\"\>", 2->"\<\"ApartSquareFree\"\>", 
       3->"\<\"Cancel\"\>", 4->"\<\"PolynomialQuotient\"\>", 
       5->"\<\"Expand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 
       3->"\<\"Polynomial Factoring & Decomposition\"\>", 
       4->"\<\"Rational Functions\"\>", 
       5->"\<\"New in 6.0: Symbolic Computation\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Apart", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Apart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Apart"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]rewrites a rational expression as a sum of terms with \
minimal denominators. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Apart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Apart"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]treats all variables other than ",
     Cell[BoxData[
      StyleBox["var", "TI"]], "InlineFormula"],
     " as constants. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11698]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " gives the partial fraction decomposition of a rational expression. "
}], "Notes",
 CellID->8979],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
 " writes ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as a polynomial in ",
 Cell[BoxData[
  StyleBox["var", "TI"]], "InlineFormula"],
 " together with a sum of ratios of polynomials, where the degree in ",
 Cell[BoxData[
  StyleBox["var", "TI"]], "InlineFormula"],
 " of each numerator polynomial is less than that of the corresponding \
denominator polynomial. "
}], "Notes",
 CellID->21411],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Trig",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trig"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " treats trigonometric functions as rational functions of exponentials, and \
manipulates them accordingly. "
}], "Notes",
 CellID->12489],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404280479],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->185452128],

Cell["Decompose into partial fractions:", "ExampleText",
 CellID->12529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"5", "+", "x"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66879419],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{127, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677253848]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5553],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " can handle symbolic parameters:"
}], "ExampleText",
 CellID->249315581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "a"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", "c"}], ")"}]}]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7672],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "x"}], ")"}]}]], "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{426, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547200357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52499482],

Cell[TextData[{
 "Treat neither ",
 Cell[BoxData["x"], "InlineFormula"],
 " nor ",
 Cell[BoxData["y"], "InlineFormula"],
 " as constant:"
}], "ExampleText",
 CellID->70078876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{"x", "+", "y"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35362999],

Cell[BoxData[
 RowBox[{
  FractionBox["x", 
   RowBox[{"6", "+", 
    RowBox[{"11", " ", "x"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "+", 
  FractionBox["y", 
   RowBox[{"6", "+", 
    RowBox[{"11", " ", "x"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]]}]], "Output",
 ImageSize->{233, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132839620]
}, Open  ]],

Cell[TextData[{
 "Treat ",
 Cell[BoxData["x"], "InlineFormula"],
 " as a constant:"
}], "ExampleText",
 CellID->173243604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "y"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"2", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}]}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28657541],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", "-", "y"}], 
   RowBox[{"2", "+", "x"}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "3"}], "+", "y"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", "y"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{170, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443413848]
}, Open  ]],

Cell[TextData[{
 "Treat ",
 Cell[BoxData["y"], "InlineFormula"],
 " as a constant:"
}], "ExampleText",
 CellID->360008760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", "+", "y"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"2", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}]}]], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->91997307],

Cell[BoxData[
 RowBox[{
  FractionBox["x", 
   RowBox[{"6", "+", 
    RowBox[{"11", " ", "x"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "+", 
  FractionBox["y", 
   RowBox[{"6", "+", 
    RowBox[{"11", " ", "x"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]]}]], "Output",
 ImageSize->{233, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->166123771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385185502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " threads over equations and inequalities:"
}], "ExampleText",
 CellID->192215993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "<", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "<", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184154545],

Cell[BoxData[
 RowBox[{"1", "<", 
  RowBox[{"1", "+", 
   FractionBox["2", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]]}], "<", "2"}]], "Output",
 ImageSize->{105, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297693575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30397],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"x", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->733479477],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "x", "+", 
  FractionBox["2", 
   RowBox[{"1", "+", "x"}]]}]], "Output",
 ImageSize->{82, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287911452]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->372493661],

Cell[BoxData[
 RowBox[{"1", "+", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240951841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59646380],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   RowBox[{"Sin", "[", "x", "]"}]}]]], "Output",
 ImageSize->{70, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440960531]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36469558],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], ")"}], "2"]]], "Output",
 ImageSize->{131, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->604707411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396589968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     RowBox[{"4", "x"}], "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50686913],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Cot", "[", "x", "]"}], "4"], "+", 
  FractionBox[
   RowBox[{"Sin", "[", "x", "]"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"Sin", "[", "x", "]"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"Tan", "[", "x", "]"}], "4"]}]], "Output",
 ImageSize->{384, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73608435]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " acts as an inverse of ",
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->134941247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"5", "+", "x"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226232091],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"5", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{127, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82836559]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149732105],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"5", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{93, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77746170]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27089],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ApartSquareFree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ApartSquareFree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialQuotient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialQuotient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10758],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->13490],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->30775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->104270436],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->1703821],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->524725838],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->502379357],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->781429892],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->348802125],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->134540648]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Apart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 21.6585644}", "context" -> "System`", 
    "keywords" -> {"Pade' technique", "partial fractions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Apart[expr] rewrites a rational expression as a sum of terms with \
minimal denominators. Apart[expr, var] treats all variables other than var as \
constants. ", "synonyms" -> {}, "title" -> "Apart", "type" -> "Symbol", "uri" -> 
    "ref/Apart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11558, 307, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->404280479]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29342, 1034}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3367, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3990, 100, 4189, 83, 70, "ObjectNameGrid"],
Cell[8182, 185, 951, 30, 70, "Usage",
 CellID->11698]
}, Open  ]],
Cell[CellGroupData[{
Cell[9170, 220, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9648, 237, 228, 7, 70, "Notes",
 CellID->8979],
Cell[9879, 246, 646, 21, 70, "Notes",
 CellID->21411],
Cell[10528, 269, 537, 18, 70, "Notes",
 CellID->12489],
Cell[11068, 289, 453, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[11558, 307, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404280479],
Cell[CellGroupData[{
Cell[11943, 321, 148, 5, 70, "ExampleSection",
 CellID->185452128],
Cell[12094, 328, 72, 1, 70, "ExampleText",
 CellID->12529],
Cell[CellGroupData[{
Cell[12191, 333, 273, 10, 28, "Input",
 CellID->66879419],
Cell[12467, 345, 373, 14, 53, "Output",
 CellID->677253848]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12889, 365, 215, 7, 70, "ExampleSection",
 CellID->5553],
Cell[13107, 374, 203, 7, 70, "ExampleText",
 CellID->249315581],
Cell[CellGroupData[{
Cell[13335, 385, 304, 11, 70, "Input",
 CellID->7672],
Cell[13642, 398, 815, 30, 53, "Output",
 CellID->547200357]
}, Open  ]],
Cell[14472, 431, 124, 3, 70, "ExampleDelimiter",
 CellID->52499482],
Cell[14599, 436, 175, 7, 70, "ExampleText",
 CellID->70078876],
Cell[CellGroupData[{
Cell[14799, 447, 322, 12, 70, "Input",
 CellID->35362999],
Cell[15124, 461, 519, 18, 51, "Output",
 CellID->132839620]
}, Open  ]],
Cell[15658, 482, 122, 5, 70, "ExampleText",
 CellID->173243604],
Cell[CellGroupData[{
Cell[15805, 491, 354, 13, 70, "Input",
 CellID->28657541],
Cell[16162, 506, 540, 21, 53, "Output",
 CellID->443413848]
}, Open  ]],
Cell[16717, 530, 122, 5, 70, "ExampleText",
 CellID->360008760],
Cell[CellGroupData[{
Cell[16864, 539, 354, 13, 70, "Input",
 CellID->91997307],
Cell[17221, 554, 519, 18, 51, "Output",
 CellID->166123771]
}, Open  ]],
Cell[17755, 575, 125, 3, 70, "ExampleDelimiter",
 CellID->385185502],
Cell[17883, 580, 212, 7, 70, "ExampleText",
 CellID->192215993],
Cell[CellGroupData[{
Cell[18120, 591, 260, 9, 70, "Input",
 CellID->184154545],
Cell[18383, 602, 282, 10, 51, "Output",
 CellID->297693575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18714, 618, 218, 7, 70, "ExampleSection",
 CellID->30397],
Cell[CellGroupData[{
Cell[18957, 629, 224, 7, 70, "ExampleSubsection",
 CellID->19751],
Cell[CellGroupData[{
Cell[19206, 640, 248, 9, 70, "Input",
 CellID->733479477],
Cell[19457, 651, 253, 9, 51, "Output",
 CellID->287911452]
}, Open  ]],
Cell[CellGroupData[{
Cell[19747, 665, 313, 11, 70, "Input",
 CellID->372493661],
Cell[20063, 678, 180, 6, 36, "Output",
 CellID->240951841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20292, 690, 221, 7, 70, "ExampleSubsection",
 CellID->29001],
Cell[CellGroupData[{
Cell[20538, 701, 205, 7, 70, "Input",
 CellID->59646380],
Cell[20746, 710, 232, 8, 53, "Output",
 CellID->440960531]
}, Open  ]],
Cell[CellGroupData[{
Cell[21015, 723, 268, 9, 70, "Input",
 CellID->36469558],
Cell[21286, 734, 368, 13, 61, "Output",
 CellID->604707411]
}, Open  ]],
Cell[21669, 750, 125, 3, 70, "ExampleDelimiter",
 CellID->396589968],
Cell[CellGroupData[{
Cell[21819, 757, 236, 8, 70, "Input",
 CellID->50686913],
Cell[22058, 767, 694, 24, 53, "Output",
 CellID->73608435]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22813, 798, 233, 7, 70, "ExampleSection",
 CellID->16693],
Cell[23049, 807, 319, 12, 70, "ExampleText",
 CellID->134941247],
Cell[CellGroupData[{
Cell[23393, 823, 274, 10, 70, "Input",
 CellID->226232091],
Cell[23670, 835, 372, 14, 53, "Output",
 CellID->82836559]
}, Open  ]],
Cell[CellGroupData[{
Cell[24079, 854, 104, 3, 70, "Input",
 CellID->149732105],
Cell[24186, 859, 298, 11, 53, "Output",
 CellID->77746170]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24545, 877, 311, 9, 70, "SeeAlsoSection",
 CellID->27089],
Cell[24859, 888, 1212, 44, 70, "SeeAlso",
 CellID->27296]
}, Open  ]],
Cell[CellGroupData[{
Cell[26108, 937, 314, 9, 70, "TutorialsSection",
 CellID->10758],
Cell[26425, 948, 190, 4, 70, "Tutorials",
 CellID->13490],
Cell[26618, 954, 200, 4, 70, "Tutorials",
 CellID->30775]
}, Open  ]],
Cell[CellGroupData[{
Cell[26855, 963, 319, 9, 70, "MoreAboutSection",
 CellID->104270436],
Cell[27177, 974, 159, 3, 70, "MoreAbout",
 CellID->1703821],
Cell[27339, 979, 151, 3, 70, "MoreAbout",
 CellID->524725838],
Cell[27493, 984, 167, 3, 70, "MoreAbout",
 CellID->502379357],
Cell[27663, 989, 147, 3, 70, "MoreAbout",
 CellID->781429892],
Cell[27813, 994, 169, 3, 70, "MoreAbout",
 CellID->348802125],
Cell[27985, 999, 179, 3, 70, "MoreAbout",
 CellID->134540648]
}, Open  ]],
Cell[28179, 1005, 50, 0, 70, "History"],
Cell[28232, 1007, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

