(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21054,        734]
NotebookOptionsPosition[     17076,        603]
NotebookOutlinePosition[     18446,        642]
CellTagsIndexPosition[     18361,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AppearanceElements" :> 
          Documentation`HelpLookup["paclet:ref/AppearanceElements"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "Deployed" :> 
          Documentation`HelpLookup["paclet:ref/Deployed"], 
          "ControlsRendering" :> 
          Documentation`HelpLookup["paclet:ref/ControlsRendering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AppearanceElements\"\>", 
       2->"\<\"Style\"\>", 3->"\<\"Deployed\"\>", 
       4->"\<\"ControlsRendering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Controls Options\"\>", 3->"\<\"Palettes\"\>", 
       4->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Appearance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Appearance",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
     "\[LineSeparator]is an option for displayed objects such as ",
     Cell[BoxData[
      ButtonBox["Button",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Button"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Slider",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
     " which specifies the general type of appearance they should have. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ", as well as such attributes as ",
 Cell[BoxData["\"\<Open\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Closed\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->31122],

Cell["\<\
When multiple appearance specifications refer to a particular object, they \
are given in a list. \
\>", "Notes",
 CellID->26053],

Cell[TextData[{
 "When an object can be in several different states, the setting for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " can be given in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"cond\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
     SubscriptBox[
      StyleBox["app", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"cond\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "->", 
     SubscriptBox[
      StyleBox["app", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->47647069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46443411],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->96413375],

Cell[TextData[{
 "Display all the controls of ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1736109249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.3", ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2143288859],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.3}, 
   PaneBox[
    DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[Typeset`var$$], 
        Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {34., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    BaselinePosition->Baseline,
    ImageMargins->0]],
  Manipulate`InterpretManipulator[
  0.3, {0, 1}, {Appearance -> "Open"}]]], "Output",
 ImageSize->{216, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365158435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1263479411],

Cell[TextData[{
 "Force an ",
 Cell[BoxData[
  ButtonBox["ActionMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ActionMenu"]], "InlineFormula"],
 " object to look like a ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->187626650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ActionMenu", "[", 
  RowBox[{"\"\<xxx\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<a\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", "1", "]"}]}], ",", 
     RowBox[{"\"\<b\>\"", "\[RuleDelayed]", 
      RowBox[{"Print", "[", "2", "]"}]}]}], "}"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<PopupMenu\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->733657030],

Cell[BoxData[
 PopupMenuBox[
  Dynamic[{"ActionMenu", "PopupMenu"}, 
   Part[{"a" :> Print[1], "b" :> Print[2]}, #, 2]& , Evaluator -> 
   Automatic], {1->"\<\"a\"\>", 2->"\<\"b\"\>"}, "\<\"xxx\"\>",
  Appearance->"Popup",
  Background->Automatic,
  ImageSize->Automatic,
  MenuAppearance->"Menu"]], "Output",
 ImageSize->{52, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320028064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->935112754],

Cell[TextData[{
 "Control the appearance of ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->699273785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<DialogBox\>\"", ",", "\"\<Palette\>\"", ",", "\"\<Frameless\>\"", 
       ",", "\"\<Pressed\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<DialogBox\>\"", ",", "\"\<Pressed\>\""}], "}"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149786825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->"DialogBox",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Palette",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"Palette",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Frameless",
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"Frameless",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->"Pressed",
    ButtonData->"paclet:ref/xxx",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["\<\"xxx\"\>",
    Appearance->{"DialogBox", "Pressed"},
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>Null,
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{183, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762134576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1663988111],

Cell[TextData[{
 "Control the appearance of ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2116130343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"False", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1220006974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[False,
    Appearance->Tiny], ",", 
   OpenerBox[False,
    Appearance->Small], ",", 
   OpenerBox[False,
    Appearance->Medium], ",", 
   OpenerBox[False,
    Appearance->Large]}], "}"}]], "Output",
 ImageSize->{99, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14401060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->613384578],

Cell["Different appearances for the slider thumb: ", "ExampleText",
 CellID->918932870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UpArrow\>\"", ",", "\"\<DownArrow\>\""}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321164380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->"UpArrow"], ",", 
   SliderBox[0.5,
    Appearance->"DownArrow"]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->831419931]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13917],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppearanceElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppearanceElements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deployed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deployed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlsRendering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlsRendering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23212712],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->193365653],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->41184372],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->755372016],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->612443626]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Appearance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 27.0180766}", "context" -> "System`", 
    "keywords" -> {
     "skin", "widget appearance", "control appearance", "look-and-feel", 
      "control display"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Appearance is an option for displayed objects such as Button and Slider \
which specifies the general type of appearance they should have. ", 
    "synonyms" -> {}, "title" -> "Appearance", "type" -> "Symbol", "uri" -> 
    "ref/Appearance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7222, 225, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->46443411]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18219, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1945, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2568, 71, 1575, 37, 70, "ObjectNameGrid"],
Cell[4146, 110, 781, 23, 70, "Usage",
 CellID->24160]
}, Open  ]],
Cell[CellGroupData[{
Cell[4964, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5442, 155, 832, 32, 70, "Notes",
 CellID->31122],
Cell[6277, 189, 139, 4, 70, "Notes",
 CellID->26053],
Cell[6419, 195, 766, 25, 70, "Notes",
 CellID->47647069]
}, Closed]],
Cell[CellGroupData[{
Cell[7222, 225, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->46443411],
Cell[CellGroupData[{
Cell[7606, 239, 147, 5, 70, "ExampleSection",
 CellID->96413375],
Cell[7756, 246, 218, 8, 70, "ExampleText",
 CellID->1736109249],
Cell[CellGroupData[{
Cell[7999, 258, 183, 5, 28, "Input",
 CellID->2143288859],
Cell[8185, 265, 983, 27, 71, "Output",
 CellID->365158435]
}, Open  ]],
Cell[9183, 295, 126, 3, 70, "ExampleDelimiter",
 CellID->1263479411],
Cell[9312, 300, 345, 13, 70, "ExampleText",
 CellID->187626650],
Cell[CellGroupData[{
Cell[9682, 317, 419, 11, 70, "Input",
 CellID->733657030],
Cell[10104, 330, 439, 13, 70, "Output",
 CellID->320028064]
}, Open  ]],
Cell[10558, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->935112754],
Cell[10686, 351, 205, 8, 70, "ExampleText",
 CellID->699273785],
Cell[CellGroupData[{
Cell[10916, 363, 548, 16, 70, "Input",
 CellID->149786825],
Cell[11467, 381, 1191, 41, 70, "Output",
 CellID->762134576]
}, Open  ]],
Cell[12673, 425, 126, 3, 70, "ExampleDelimiter",
 CellID->1663988111],
Cell[12802, 430, 206, 8, 70, "ExampleText",
 CellID->2116130343],
Cell[CellGroupData[{
Cell[13033, 442, 372, 12, 70, "Input",
 CellID->1220006974],
Cell[13408, 456, 382, 15, 70, "Output",
 CellID->14401060]
}, Open  ]],
Cell[13805, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->613384578],
Cell[13933, 479, 87, 1, 70, "ExampleText",
 CellID->918932870],
Cell[CellGroupData[{
Cell[14045, 484, 361, 12, 70, "Input",
 CellID->321164380],
Cell[14409, 498, 290, 11, 70, "Output",
 CellID->831419931]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14760, 516, 311, 9, 70, "SeeAlsoSection",
 CellID->13917],
Cell[15074, 527, 972, 35, 70, "SeeAlso",
 CellID->4006]
}, Open  ]],
Cell[CellGroupData[{
Cell[16083, 567, 318, 9, 70, "MoreAboutSection",
 CellID->23212712],
Cell[16404, 578, 141, 3, 70, "MoreAbout",
 CellID->193365653],
Cell[16548, 583, 142, 3, 70, "MoreAbout",
 CellID->41184372],
Cell[16693, 588, 128, 3, 70, "MoreAbout",
 CellID->755372016],
Cell[16824, 593, 180, 3, 70, "MoreAbout",
 CellID->612443626]
}, Open  ]],
Cell[17019, 599, 27, 0, 70, "History"],
Cell[17049, 601, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

