(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    186761,       4665]
NotebookOptionsPosition[    172190,       4139]
NotebookOutlinePosition[    173552,       4178]
CellTagsIndexPosition[    173465,       4173]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cos" :> Documentation`HelpLookup["paclet:ref/Cos"], "ArcSin" :> 
          Documentation`HelpLookup["paclet:ref/ArcSin"], "ArcCosh" :> 
          Documentation`HelpLookup["paclet:ref/ArcCosh"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "VectorAngle" :> 
          Documentation`HelpLookup["paclet:ref/VectorAngle"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cos\"\>", 2->"\<\"ArcSin\"\>", 
       3->"\<\"ArcCosh\"\>", 4->"\<\"Degree\"\>", 5->"\<\"VectorAngle\"\>", 
       6->"\<\"TrigToExp\"\>", 7->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Inverse Functions\"\>", 
       3->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcCos", "ObjectName",
 CellID->6645],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcCos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcCos"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc cosine ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["cos", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30175]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians. ", "Notes",
 CellID->23448],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24919],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13079]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109801049],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->777556384],

Cell["Results are in radians:", "ExampleText",
 CellID->14122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26859],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348816012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1899],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", "x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {Rational[1, 2] Pi, -1, 0, 
    Rational[-1, 6], 0, 
    Rational[-3, 40], 0, 
    Rational[-5, 112], 0, 
    Rational[-35, 1152]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{241, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174109002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32036],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->766739404]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1915],

Cell["Evaluate numerically:", "ExampleText",
 CellID->23953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "0.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19485],

Cell[BoxData["1.1592794807274085`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357740591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "1.5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10199],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.9624236501192069`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520036021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20877],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->20353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2942],

Cell[BoxData[
 RowBox[{"0.4061728165055114`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.6586932988564327`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196483990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4208],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->6844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30169],

Cell[BoxData["1.\
2309594173407746821349291782479873757103400093550948390555482078219`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230217194]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->4879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "0.33333333333333333333333333333333333333333", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21108],

Cell[BoxData["1.2309594173407746821349291782479873757103435448890012442545`41.\
064667473985864"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165530392]
}, Open  ]],

Cell["\<\
The precision of the output can be much less than the precision of the input:\
\
\>", "ExampleText",
 CellID->5259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "0.99999999999999999999999999999999999991", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25706],

Cell[BoxData["4.242640687122812812`1.2552725051040312*^-19"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->934815438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24075],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->28026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  FractionBox["1", "2"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20124],

Cell[BoxData[
 FractionBox["\[Pi]", "3"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216834250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17774],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->2884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.5", ",", "0.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.369438406004566`", ",", "1.0471975511965979`", ",", 
   "0.6435011087932843`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29167813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"1", 
       FractionBox["1", "3"]},
      {"x", 
       FractionBox["1", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"ArcCos", "[", 
      FractionBox["1", "3"], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcCos", "[", "x", "]"}], ",", 
     FractionBox["\[Pi]", "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{229, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36144656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1002762420],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->363088136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49478881],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cos", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{45, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->507469410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2343],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32097],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["\[Pi]", "3"], ",", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"-", 
      FractionBox["1", "3"]}], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194119746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20736],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->19555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25633],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191249161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->930],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->10252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19904],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", "x", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {Rational[1, 2] Pi, -1, 
    Rational[-1, 2], 
    Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{141, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87042836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1697],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->18217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15955],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"Floor", "[", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Arg", "[", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], "]"}], 
          RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", "-", "1"}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", 
            RowBox[{"x", "-", "1"}], "]"}], 
           RowBox[{"3", "/", "2"}]],
          SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
          Editable->False]}],
        SeriesData[$CellContext`x, 1, {Complex[0, 2] 2^Rational[1, 2]}, 1, 3, 
         2],
        Editable->False], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{387, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722462963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12488],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays: "
}], "ExampleText",
 CellID->24870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31754],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56857747]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32176],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    FractionBox["\[Pi]", "2"]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{190, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->812949499]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15415],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      FractionBox["\[Pi]", "2"], 
      RowBox[{"ArcCos", "[", 
       FractionBox["1", "3"], "]"}]},
     {
      FractionBox["\[Pi]", "2"], 
      FractionBox["\[Pi]", "2"], 
      FractionBox["\[Pi]", "2"]},
     {
      FractionBox["\[Pi]", "2"], 
      FractionBox["\[Pi]", "2"], 
      FractionBox[
       RowBox[{"2", " ", "\[Pi]"}], "3"]},
     {
      FractionBox["\[Pi]", "2"], "\[Pi]", 
      FractionBox["\[Pi]", "2"]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{129, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->3277057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4231],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " is a numerical function:"
}], "ExampleText",
 CellID->17480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "ArcCos", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86198580]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"ArcCos", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20514],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109189768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14990],

Cell[TextData[{
 "Plot the real and imaginary part of ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"ArcCos", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"ArcCos", "[", "x", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28981],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmQuMXVUVhjf3OYNQigISilooaKUF+phqfYwtTHnUBiuGCqESGEZgqjAV
LJrURBEMTbQSU0PSktImPMPDOIqpkgykaWNDE9ImDY0EmtQhkmJCQ9IGk4kk
47fXv8+55+y7753ROJneufucf6293mvt3esGNwzfcc/ghnVDg7OvuW/wB8Pr
hn44++r19/Goeopzbpx/vzrX8X2Sb/ZvfHKSv/fyWWE5Yqu6/6yeOHb83QNv
v//WP9w6W3u0/bh7WqjG6zv+sq3/Xn6fWfPQvi2jwO/sjK6+uWv/SyOP7ly5
0VUhcVURfTD+TzeUpOqxp0f3HNr98LMtqufWbmJb5HO3Jak+VqDaPnB/oNq1
YRvbfzTxb3dLkup0e8r7I2MHxh54IlCx697NL3gJ15ZsNNPQEyf/dXj0ry/e
vjmgR4d/E/a4KbnHJzLL7t/6pydX/9RVsj1Ye32+naQ6O5MM3uwQ9kJG/ONf
reLDE9WT1OfaUxwTrFHJJEVP/+rrEVUtyeU8e/rh8RNYviU5/kN/r+9y3tcg
iqnT3M4vaASPwA2+h57f7bldneDil6L+jP9s4l8Mr+BrUa6Y1v4XWOxGHLDH
wLSo57RRE9SEyPIQIY0k1cVGhblwt6hwOgEU6yr0Zw3Na/Ijl/Cd1/52VRI9
19D4GLcKjbMhHijF7CX+s37wqTHCIGforkxynGdYlMo5Iq27Iom91LAEhvhC
wdZuWRJ7mWHfe+Pv7A6WVPa59bUk9nLDEnOyM3bDRa6/pNMCw+B5FJacHvPV
JL9F5lJVLEQF+JUkbrHh0Fc4jPTlJK6vzA+lvpTELTGcBERtFFraBYcuhJOC
amlJVx9XPsfmG456oUgihyohPxZFfBeE5wsDpVUI1yyg+JT/akSmjIx8lYjP
wv9i7fJ9XDUs+alkywLVvCCVqxHk4Vmwfpe9Yh0tR11v9NRs5DNCvkGn6XGP
31eT3BXxL2/cAXfJ7v5n3lYtaq2nWdxT3NVWC9wrHXxcpm95uRJ872okmq+x
LiXngoDMdjCJnGJe5Yfiqmhvi1mhCEFQ2KMrikwH5btlNxRxrTh0faSWofjr
vy609e4tf9w+svPxn/3eLdm543V538frUdMtrr090bo5xfuO+CBDTyRTvG5O
8f7/jdf66e9v5dEvr33Q9WITe89f/7UZrXumWBfxUYwWrPKpaP3xKawY4+P3
Mb3mg9/t2Mejrd98yH16CnxayuForXx8ZNOrPHpsxY+dVWubfdtQtaHbX3yk
/0cEIiVkaRKnznPs2Ill/ds2LnsQKJ3VtbB57tWffuogmF/c9YTy2XXh17h+
9ZNg97x6RP2RIvDFJNpqRHPvnqOgkZUVOQoBU65LU1jn7Z2Y+EhbvDJ2hAfU
RTURphn3hc50VcJBO8nWNWU8QtKuliTp1FXefuv9qwa2Q7r/tXdECYH6OQ2x
RVnJ+9DJkxO3rH0Oit9u2WeVrEbd0GSBkH3JvdQRf/7AGGQQo2SjIKV68+Ik
pc05NWmHoIhrsRm6Nd6iHC1KUto0Vfvzrjeh5BdXnGpP8EBOuTBJ+XnDYRBZ
hvCwE0s97/y4xJ+7FiSp55apEf30jFpbQ03YKEJy2+ZUknbb1v1nlKkwEhOA
vN22p02jtReePyTqX2/eaxlY52ikoYs24afv+UnqiwyLU6ATAzi5s+wpe8q3
YRKcl+RgE3edyFg/8pIchd3dOfYUKjU39Mbf8ksbhwsNi3tvXPMMHMgBvuts
1EByDlPFSX5ukscF0nnPUVl+3fDo8eMfuln2lCFRGYs2vg58rmR9UWJ0qU+g
Yg1VRT/j57MrisDo4uTuVgPr7Mi+soG3ok4yEMkGqgBoMCfJw3asEwWrVu6E
B7Y4/MZ78k+D+pGfTBCI6DXedvpPnS5N7wY+2fTwbql1/4ZdLC1WqvnJJZzt
WIQZzPRw34u4xSet8zJJVa3QljSRb5uIptFL5qYDwlq6TclXHseKKhZy4/j4
B1Z7mmSdMlCcCW9/Kp/VkbNfftIkJR5lUz7/MHo49BryUJIGK2BXKlEux5TS
np1Ji2lzG7PU/ISbFTmtMz0J4F+dMy3uykCiKJfcZ5XOJli0dEfBt3BHcVYe
FamzrtWFBlFFqyhKrJOWTvyt+xJiNdxCnJmM15mZ/nmMEbIExXLDYUo85CfF
XMZwV3NGkps9bRBH0peYoniSiAMF2Vr3KyQUiew1Pq2UyzOMC0KoS0lDxoBr
M58Eu4kLulLifHz2JmWyyt+APPcwbGF+neF0FWWM7INgQkZ/um4kufVmOUmp
UZFCVRx8fZaTyEKAu1rGjdyxV0lu1gkbRLNyUC0Z5muyCAncvGy1JIdGFg2q
WbIV2XZzxiFMsWnqWluuyjZDJX9UM51xZlHnO1o8GzlPfqRPBZyrSh8PKaDD
WUoeFk5S+5d3lblGXrOMc+szuel3YNRukOhue2tnnaZ8pEDUtO07gs5Bd5fz
Ug3Dte4BbJce+pB6Gb+0RYxsL7W7Zt8GPU4dUxJCEp/BteOdqTyjGKRvFL9r
GiBv0eKkldcgffc1lIoktuuZLN5vDGaZVawd2P3UJM9bM5l/svHlog9OS6Lt
zreBhMhZlHlGEv2dthzHA2yV3cCk7XJzSqKDB94t3h64jtQ3dZAw1qd8F3pj
lmGRpLFeab+vyXInH00k8cxpUd+QWSnv0bBBgRmFLJLKaY2/le2eR5168ZmT
3e5RrZa1TQazktjVHXY4vxR33zCO5IpsGDjGZ05xtLpcJ5LlIiIVdrqRbsOu
ynbP6xcFAfvMTqLtHr4ON0mB80lXza1t2JWZDVQhkMJPonOSWOtL9Xx2JzZ9
nl5UsoDdQfsJPZcUT2rqb+NnN9B+Flftww4cJTXvtmFXZFhlNB7z8+bcJHag
jMUKdEWdldqwV5axfPJd02Eb9opMN1VCCpvHzivpb5hwfgTAxvOTvGzuKJ0W
L03ilhmORMrPvpclcXbvXcvP5DC+vDOuqiAmgnUybEP1GzeE165Il93sjbTe
V+U235ri+0lxsbtzf26XjgRWF1xVpY5qbp6qdsxam//82V6ywTW2cLrGaG4k
woLmsb27USGVjJp7uzFZrJ1CKYTwlYslSv/vj6jkMJ9J05NIFZBdwj3bYrtn
k4n9q0u6Wk/Uijs/MPTZVEKkBlR8J5zes8/2pBJ0pSr/X3A8kwnjTvkPkMSj
ZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->309403105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5242],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Cos", "[", 
        RowBox[{"u", "+", 
         RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Cos", "[", 
        RowBox[{"u", "+", 
         RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}], "]"}], ",", "u"}], 
     "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16070],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 321},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->257516250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24061],

Cell["Find the angle between two vectors:", "ExampleText",
 CellID->27219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{
   RowBox[{"Normalize", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}], ".", 
   RowBox[{"Normalize", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28781],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365515878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
    
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61114148],

Cell[BoxData[
 GraphicsBox[{ArrowBox[{{0, 0}, {1, 1}}], ArrowBox[{{0, 0}, {-1, 1}}]},
  PlotRange->All]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298624388]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12833],

Cell["Compose with the inverse function:", "ExampleText",
 CellID->80512647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"ArcCos", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"ArcCos", "[", 
    RowBox[{"Cos", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"ArcCos", "[", 
    RowBox[{"Cos", "[", "z", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62867012]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108860748]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{"Cos", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404146284],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->703984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31447],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " through logarithms and square roots:"
}], "ExampleText",
 CellID->10945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28406],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "z"}], "+", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}]]}], "]"}]}]}]], "Output",
 ImageSize->{157, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475999880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8686],

Cell[TextData[{
 "This shows the branch cuts of the ",
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->5794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcCos", "[", 
     RowBox[{"x", "-", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23577],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->327939786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20307],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->26793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"ArcCos", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23504],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "-", 
  RowBox[{"Arg", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "y"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["x", "2"], " ", 
               SuperscriptBox["y", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}], ")"}], "2"]}], ")"}], 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"Arg", "[", 
              RowBox[{"1", "-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], 
              "]"}]}], "]"}]}]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["x", "2"], " ", 
               SuperscriptBox["y", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}], ")"}], "2"]}], ")"}], 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"Arg", "[", 
              RowBox[{"1", "-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], 
              "]"}]}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "]"}]}]}]], "Output",\

 ImageSize->{447, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9568707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13240],

Cell["Solve an inverse trigonometric equation:", "ExampleText",
 CellID->485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCos", "[", "z", "]"}], "3"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"ArcCos", "[", "z", "]"}]}]}], "\[Equal]", "2"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16464],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  RowBox[{"Cos", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
   "]"}]}]], "Output",
 ImageSize->{218, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422667344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{"Cos", "[", "z", "]"}], "]"}], "\[Equal]", "w"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20337],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", "w", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "w", "]"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"ArcCos", "[", 
            RowBox[{"Cos", "[", "w", "]"}], "]"}]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"Cos", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "<", 
       RowBox[{"Re", "[", "w", "]"}], "<", "\[Pi]"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"ArcCos", "[", 
            RowBox[{"Cos", "[", "w", "]"}], "]"}]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"Cos", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", "w", "]"}], "\[Equal]", "\[Pi]"}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "w", "]"}], "\[LessEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"ArcCos", "[", 
            RowBox[{"Cos", "[", "w", "]"}], "]"}]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcCos", "[", 
           RowBox[{"Cos", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{562, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60552452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27168],

Cell["Solve for zeros: ", "ExampleText",
 CellID->28130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCos", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15255],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     FractionBox[
      RowBox[{"1", "-", "\[Beta]"}], "\[Alpha]"]}]}], ")"}]}]], "Output",
 ImageSize->{236, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48714748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13201],

Cell["Integrals:", "ExampleText",
 CellID->142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCos", "[", "z", "]"}], "a"], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21276],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox[
   RowBox[{"ArcCos", "[", "z", "]"}], "a"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"ArcCos", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcCos", "[", "z", "]"}]}], ")"}], "a"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "a"}], ",", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"ArcCos", "[", "z", "]"}]}]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"ArcCos", "[", "z", "]"}]}], ")"}], "a"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "a"}], ",", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcCos", "[", "z", "]"}]}]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{568, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152210801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32702],

Cell["Laplace transforms:", "ExampleText",
 CellID->10684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15023],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Pi]", "2"], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "2"], ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         FractionBox["1", "2"], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]"}], "s"], ",", 
      FractionBox["1", "2"]}], "]"}]}]}], 
  RowBox[{"2", " ", "\[Pi]", " ", "s"}]]], "Output",
 ImageSize->{332, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200088584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCos"]], "InlineFormula"],
 " is automatically returned as a special case for various mathematical \
functions: "
}], "ExampleText",
 CellID->12187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCD", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14462],

Cell[BoxData[
 RowBox[{"ArcCos", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183021663]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16859],

Cell[TextData[{
 "Generically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "\[NotEqual]", "z"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCos", "[", 
  RowBox[{"Cos", "[", "30.", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8172],

Cell[BoxData["1.4159265358979325`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103360358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"ArcCos", "[", "30.", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24441],

Cell[BoxData[
 RowBox[{"30.00000000000001`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2190734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16088],

Cell["\<\
On branch cuts machine-precision inputs can give numerically wrong answers:\
\>", "ExampleText",
 CellID->22015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13976],

Cell[BoxData[
 RowBox[{"3.141592653589793`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.3169578969248166`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44197435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCos", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", "30"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18298],

Cell[BoxData[
 RowBox[{"3.141592653589793238462643383279502884197169399375`30.\
115361337878042", "+", 
  RowBox[{
  "1.316957896924816708625046347307968659618097590197`29.737783355995724", 
   " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83044547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31283],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->3205],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cos", 
    RowBox[{"-", "1"}]], "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->19997],

Cell[BoxData[
 FractionBox["x", "cos"]], "Output",
 ImageSize->{30, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->764413898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cos", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->5769],

Cell[BoxData[
 RowBox[{"ArcCos", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84780438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6030],

Cell["Nested integrals:", "ExampleText",
 CellID->17442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"ArcCos", "[", "x", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21735],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"ArcCos", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "4"]}], " ", "x", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"ArcCos", "[", "x", "]"}]}], "-", 
    FractionBox[
     RowBox[{"ArcSin", "[", "x", "]"}], "4"]}], ",", 
   RowBox[{
    FractionBox["1", "36"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "3"], " ", 
       RowBox[{"ArcCos", "[", "x", "]"}]}], "-", 
      RowBox[{"9", " ", "x", " ", 
       RowBox[{"ArcSin", "[", "x", "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "576"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", "x", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["x", "4"], " ", 
       RowBox[{"ArcCos", "[", "x", "]"}]}], "-", 
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       RowBox[{"ArcSin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{516, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37898602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310343378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcCos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Black"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277367973],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVvQd4HFeSJpidBVJSt0wbuZ4209M9Mzsz3bPTu7O3t7u3t3e3dzdzu/tB
3nuJokzLe1GizMjRkwABkCC8K6BQVSiH8r4KBe9B70nRO5AArST+311EZGYB
SJbUffxeJVFVWZnx/xEvXjwXWfzkm88tfOnJN59f8OSv/vn1J1997vkFb/zq
n155nT6yfE9RFD+9Km9V6O//l/6Slx8AfXHF8W06FtEJ/0nevcNHC72Vd8an
7876lP/8j/LpItOn/+E7PuW7KEUznyrKtfp9/y5/X5XeXW+6v/btv+jnWkzX
/lv5dpnp07+RTxfrV/xBwW/f07+VSy5cuJD/vOoKGbW7P0RHvsCf6f+rujRX
6df4rZz1sOk+t+jfzjOuSnfRrvrvCp5/o37Vq+Xz/MnKPxY8+0e6LNfK1bWz
tR/824Ln36Cff/2s8xX5V/j8a/Xz+T7KvPz19V/9mzwvqi4D/3/jLMn5T9V0
zX8tv1qoX/nmP+nsBfq1f2o622wJfy9nP6FfW/taM6Jbv+M+fKp2n8f0+/zS
dHaR6T6/k7P/i372z3Sd/bnpV/NMv9Is5H81LCFP5C26vOa7/LzA9fh+v/uW
69ykX+evTL+bb7ru333L73+s//460/lm7q4yff+333K9H866nlFzvus61+jn
/eJbrmdc53qdBzW18TvlvLrA9a/gN69Fw35vMK6enMAfu8NsBIbBFfJQ2p3+
my5//g6JcVIq3SZFZSPSG+UaZpbMUptRadf+51nSa7YfH0V8DIkxsvUk3aeI
bpKe0G/ysz9yD7NmtHv8X5jxfLO//b6BJzpCb2J031G+LxW6cWoc2p0z33pn
Ne/vzHf8jX7Hn+tn/RCGvw4PITKM6DChi9Fd5/EtR5Ec40K3VFS6o2LR7smX
KmR7ec+vnzMfs2q/8pcmiW7FlV7lOuMqPwwNgkUypCKZ4iPIC5USodLjyEwg
W5AHc/skd5eaUMiejJr+I4P54AA0GQZZhuiQyDDMMiRGZmRgAb5DhmtNd/lN
QR5+ot/TaHuUq/19CPQjSGUAoQGRYZBlUEkC5SpNhuQoUqMzMihqdmLOVc2e
/Qf6Xf6qoAyGZzHwKz/y9sLXi84+5IUJ9YswA7owsSEhZHhGGLIRqhxFJA3J
0jVRiBGzJ/x1QWkMfzTbMq432LnJ0w1vDxeWr1fk67tCvkGWLz6EhCbfCMuX
HkWGa2+W6LJo8hWy5OtN0vxFvuaos3xmnqkfdHTBlYObSjc02Xw9IlivCNZH
dyTRlBtYsgGRbFCXLDksko3okmXH0DWOnAh2BXOFpfr9dzF1vSMLZxYkX15E
Tw7ebvi60dkj8vWyfKE+qGGS8BoWb8AQb4jFY9lGkGHdknTE2nfKx5JoGv37
K1iypdGehj0DBxVDLlcX3F0iVI7uQGIpN5oEI7ki/SLVAOKDItUQUsO6VNlR
dI0hN47ugtb2QxNnEk9I1PCtnH2/NYW2FGxUZgnM0mbhykIlcZVbNIGZxW74
exDoQbBXhO0TYfsNYQcNYYeRGZkl7HhBBgtLy21BkTITJRs1Vbm2OYGWBKxJ
Lq1JXer2FOxpONJwZtCRgUoyK7cyx10ick5E7haRexDqRbgXkT4RuR/xAV3k
9BAyw8iOoGsUuTF0j6FnvBC/PzJJrPn52Z6XBTWiMbOf13xdQwyNcTTF0UxF
Q5RgOGpbkpzWlYgIkDsrcLrgI2WonWQ6PyZIjKdH8PQi2mfgGUBq0MAzjK4R
5Ea/Hc8PTZJrGijSNWCOJm/ETBsqWK6pjaJOSn0MjCum42qJk5wESylqTYBw
2ZJoJ4T2FJSfMbC0AMsIsKwOjGD5cwgIrnCPgOpFrA/xfgPUIDJDDCo3gu5R
9Iyht7Bd/dgkt0WXW2KvKzxyHs0sbRm9FuX6qjCqI1xqIqiNoC4iaKNoiAra
GJpjjNYah0pQlT9vS+hgCasjJUjTcKXhzsCTgTcLXxadXYI0h2A3Qt0MVkfa
h2Q/UgM60i4Dae8Y+sYKIuWWVJmXx6Jr0Rxd3VQQt+G/rte1rcxbH0KllA0h
EG5FrabDdTVhA3gE9REBHjWAxxh4axyEWlFtdPg5I08K8pQZeWcW/i4EuhDM
CexuRHsQ6zVg9yM9gOwguoaQG0bPCHpHddiFUKsGziv6QZoHKRz3z9bx9/Of
lQdRIUVR19GhaH0Q6w0e1KoQdbuqQ2AawqgLGzREhIYomqNCQ0xoiINIaE/A
noAjCWcSHSm4UnCn4UnDm4Evo7MQ7EIoJxR0I9aDeC+SfUJBP7ID6BpE9xBT
0DeKfk3z5p7cbE+kfAcXRhR07az/JR5cG4BaFqBrlAdQIUVDfw2hr5SyIYiq
IBh6CLUhhq6o9XT4S8YeMbBHBXtMsMd17Aw8KcBTAjwNXxqdGfizCGQZeziH
CAHvRrwHyV6k+pAR4DkB3juMvhEMjKIA7hsL4b7C1m+GqR+6JoA1jLAkAEsp
IV/rp88JfrkURWX4/7AugPVSKgPYEBDwQdQEBXwI9SE0hNEYFuwRNEcYe2sU
bTHYYmiPwx6Hg7AnBHtSsKdmsAcyCGYR6kIkx0qPdyPRg1QvMn3I9iM3gJ5B
Bt5vAL8C+U2zrf4KxIZvNuIPyxo/1BJ6lfo1tEVlfpRLqaBP1tEnv1vvR6Vf
kAZQHRCkQdQFBWmIkTaFBWYE1oggjQrSmCCNoyMBVwLuJDxJeFPwpdCZhj/N
SENZhLsQzSGWQ6IbyR6ke5HtQ66fYfYNYWAYgwX1+2PDG+k1Vcn7baO3cJOB
f3UnqCjqmk5CSq9Seq2lD35f1onyTlRIWdeJ9Z0C048qv8AMoDYgMIMCMyQw
wwbMCMNkjDHG6JwLkzGmBGMaoQzCWUS6EOtCPIdkN9I9yPYi14eeAfQNMsah
ERiRDEG81aQ5DZcRif3U0NxqH9Q19CrxEZZSH9ZKKfOh3IcKH9b5BFEnNnQK
Ij9q/IIoIIiCgiiEljCsYYETgY0QRQVRTBDF4U7Ak4CXECUZUSCFYBrhDCIZ
RLOIdyGZQ7ob2R7ketHTj/4BDA5B1wVjsRSwzsLY5o5Z/plx3iovqCjqai+h
pVcJvbGUerHWizL+vJwORRVegetDJfFRRbr9TU0nav2CNYDGIJqCaCasIcEa
FqwRxuqIwhlDRwwuwhoXrAn4EuhMIpBEKIVIGtEMYhkkupDOIduNXA96+wTo
oBge+xCV5J5nWKOO4WbMGkmc00vh4V9jnEGxrPRglRTCSId/WONBiZRSD9Z6
UOZBuQcM0Iv1Xga4wYdqHxhgJ+r9aPCjMYCmAJqDDLA1hLYwbGG0R2CPCMCo
AIzBHYMnBm8cvjg6EwbAFGJpJDJIZZHpQq4bvb3o78PQgKD7ia5HGVn+MDMH
g9lOb56rS+1TOvEX0KOPFW6slLLKzWjp8PdrXChxo9SNtW6UuVHuRoUH6zxY
70GlF1VegepDHUHtFKh+htoShDUoUEMCNSxQI3BG0BGBKwp3FJ4ovDH4YvDH
EUwgnEQ0iXgKqQwyWeRy6O3GQC+G+wWnEeUwVqXowywIq1YsH/ArbcJ0S0Hs
5thJNVn/z/JaX+HCig6s7KBzVtHh5tUdWNOBEhdKXVjrQpkL5S5UuLHejUqP
8OBFLfHgEx460eRHs8EDk0ARCLGg3GgPwxGGM4yOMFwRuCPwRJgKXxT+GIJx
hBOIJZBIIp1GLoveHAa6MdzHJBiRjnBg+SALQv4Bq5wOVy0mBuYtTmE2CVf0
cwqNHin5sasiExs/N+xiuRNUVjix0sl8OJkPJ9Y4UeLE2g6UdaC8AxUurHdh
gxtVHtR4UOtlMhp8aBQyWgKwBtBKZASZjHbiw04R2Y8dIThD6AgJH2G4w/BG
4IvAH0UohkgM8ThSSWTT6MlioAsjPYyQx7/nmZhYTEyodLAQE+r7aVz9fmpO
bbghr9stk0bsaB77L2wlhXiRK/10mQPLHVjhwEoHVjmw2oE1DpQ4UOrAWifK
nVjXIaS4UOVmUuq8qPcyKU2daPbD6kdrQBjhmHWGkyCcUjqCcIXgDsEbRmcE
gQjCEUSjSMaRSaA7hf4MRnI6GDZ/9cMu5DlZPMPJPOJDsRAh70lRLHSY/15y
Dj/XGdreOgkqGklXzFzcOMdi5puYEU/yC/piaTuWtWN5O1a0Y2U7VrVjtR0l
dpTasdaBcgfWOVHZwcRUu1DrRp0HDV40+tDciZa5xBAt7UHYmSEiRrle46Uj
AFcQ7iC8IfhDCIYQDiEWRjqKXBz9KYxmdW1/lMOHVLo0QdXFWVIoUfK+VtKw
vMevFNRFKVy1KIl5ixJzeMmPaW87Tb/cepqZ2TyJAtz8pKD1FOJIs56lNiyz
YbkNK2xYacMqG9bYUNqOtXaU27HOgUonqjpQ40KdG/UeNHrRJAxZO9HqR1sA
toAwxNwwQUVsOQEuRI/qolj4GrcfXj86OxHoRKgT8QAyYfTFMEpWYPhTjZP3
szon72Wgvsf2sigN4mQRn0mHee8mcfW7CRS9G9fw6e1ofrx+xxlsJ4qEp3nM
02lsPo1Nk/n5ED5prv1cbeJGxmF+Ql980YolrVjWiuWtWNGKVa1Y3YYSG9ba
UNGOdXZUOlDlRG0H6t1o8KDJi2Yfj1VQbGHJc0N1ilix2ANwSFFUokZ1Usx8
jcMHlwceN7xudLoQ8iDhQ08QIzE6S9qYxV0gXt6XohInShGRskgrZC3vcjUi
St6Roqh0KHqHLeedON6WoljoUERvLe/E5jBmzN4pP9h5BszaGWyjchozpJ3G
Ro0389iNwaOM0IttFel9CVVvIa7g86f0xect+KIFS1qwrAUrrFhpxWorSlpR
1oYKG9a3Y4MDNU7UdaDBjSYPmr1o8cHqQ2sn2gw62wMamRY7MXiV3QebB3YX
nB1wOeBxwOfQ6xgLPp9oey/LxrQow5y9m9Y4K3onxYS9LUV9OwH1rQTmvxXH
NW/F6O8ofRadw5a0WdfQ+z1T2DWFnVMzlG09gy1niHtiTLEwZ6cL+ixzqyfj
fFfM2BWayzJzKchu/LwJXzRhaROWN2NlM1a3oMSKslasa8OGdlTbUetEgwtN
bjR70OKF1YtWg0mVeLTY/PQiSy1qo2/csDphc+h+O9iGVDsGXFrtVIk7lZkj
0tS32V+/lQTxRUUpejOO+W/GMO9N5uuNKN6UoljooL4ZIS4jc3gU2a/dO4UZ
HqewfWqGx81noHGoTpyeHU2h8Jy0xuLs/p1qvJ3zW2O0YjaXMj55K33xaQM+
b8CSBixrwMpGrG5CaTPKrVjfhiobah1ocKLJhWY3WjywetDqRVsniD+yRarb
RCZzStSqxLDyfTpjofGvpRUtLbA2wl6LaANyzZoXf4fYfJvYJCLVN8n63qCK
WvRGDK8bZd7rUXz/9QjmvUEcvkEx201vhvUVIfunsW8ae6exZxq7pmdROGWm
kBgcP42xwnXYbGkak9fMZU4x+iQm1rg2f1KLT2vxRR2W1mFFPdY0Ym0z1rWg
shU1NtQ70NSBZhda3MIX1dNOsA+UVpSaU6rN5CLFVTKua4jjunbUtKKqEdV1
qK5CTRnsFQhVXNasxvJWCsTXm+zn3iDOXo9DfY192mtRvCpFKXqV2HoljKtf
DUN9NYSi10LEJEe8mgXuP4t9Z5m63Rp103OoY97OYOMZM3VSk68YF71uhq/Z
rH4bYzfRFx9X4ZMqfFaNJTVYUYuSepQ3YX0LqlsZepMTVuLKY3DlZ64oMrVL
oKqxdC3xRa0MecgaO9tmpRUVDSirwpq1WLUcaz78qvbDi8LW1UTR6wm8Fgdx
9GqM6XmFCvHzMr+IE8tLYbwU4kJ/UtT3UhBFLwdx1Sv0/6tBWF4L5nkj0vac
1UnbMY3t08LYFLZMzZCmM3Yao5MYEd6KUHiM6Qf5VmOupZnPk94W3f1X/OZH
9PkH6/FxJT6rxNIqrKxGaR3Wka1YUd+GZgfa3LB50e4T5gIcuWqc3UBdHgr2
KeqngI5ClzoKhe2ooGanGaUNWF2FT1dh0cd4953Li56Y1G2NGHslhpfJptSX
iK8Xw7C8EKIXX/SFAP4QAB2V+XQoepFeL9HrZfKpr1DL/ip9cb3GG5G266yY
GTE2bTA2ZTB2hhlTx9jPaaQNT+Z5KMq3CZiZOZ1Z3WXm6kff1k784MNyfFqB
peuxegPK67h21VvRYofNBYcXFIFoLP24Q/qEdhkSoN4ydRepq0Q9BOotbHBy
+1xC7Uw9llTi/eV49QMsfAUP3XNa7jHvxQheCOMPITxPhSl6jrh41o+iZztR
9By9nu+E5Q/0/wvkI1+k10v03cvkM1+hNvz7dPvdQtSOs2JaBlGbppgllWhS
rtZN67TO0tAkBk8ZNjabB40lY5z6J4Vq4tVsSWvwaSmWV6B0AzbUob4JzW1a
23eTO8AdHa+MDnTIeIE9onNCvWjqRFKHsop63XaOXFY24bMavFeKVz7H0+/i
vgVfa/ZT9EwAC/14mgqhXeDD/AU8IrXAg6e9XEgoLyzP0OtZL9Tn6P/nfcSQ
D+oLPp0hYuxlco7Xk1A7hRrmZRpbpsWApgwDOmPwQpbE5lOkUTNwymgW8x7p
ijUdBdlhP7d4BT5bhVVrsX6DHof+or0dHg98AfjDCEQRkOEhT5wHjJwyHmiL
whriUZe6Th6FqOjgPgRFeJ/V4/1KvLoGCz7BPW+yUI978agbj7rwCI9rPEz9
eMsjTjzagcfofREf5j3egSc68KSLy1MuJs4Ny9Nu8gZuOuUZN57x4Fkp6nP0
et5Dv3neiz9IeYEKR+EvEpMv0R/XEYDtZw3upoW7KYO7Mzp3w9xnGGL+BieZ
vP6C1jUT7xpRRr43Yebx32seQPvXUIu2Fo5PAz6EwjygEJWxpqCMAHuTPILa
keCR8NYojx43BHkkdr0HpR3ccaW4+cM6vLEOz6/Bw5+zYLct+Kr4/mPFlV8V
13xT3Ijbm3BnM+5uwT2tuK8V97fhARseasfDdjxix6NUHHjMgcepOPGEE09S
6YDlqQ6mtgNPU+FYb6GL2XWBCH5WivqcW2P3R3/w6NS+6NXDkDlkTpnJZCpV
olKZp5HZR+VkwThEaw3y61G/tTW4ycQyj39Ijf13dM6HH6N0BZoq4WyGvwPR
TsQiPHyVTCMu49ChDPwyY+ZO82SiLcETTY0Rno2q9PMY8eoOLGnHxy14tw4v
V2JBKe5fhjs/vnz7om+K3/i6+J2vij//pngNiitQXIniGtzWgDsacVcT7mnB
fVbc34oH2vBgGx6y4WEq7XikHY+2Q33MTrget+MJB5cnHVCfYotf4BTWuQYs
7NBYf9aF56gw4/QiwpVrX5BIkmmenkvzGYNmqvXM8lUDkzMs955Ez8l8fzcf
+f4JHJtXv84Zn/8LOu+l1/D5+2gshbcB8Q5kgjzUkU0jm0WqC4kcz8KFZOrd
18VrDexpnrBvjvM8d1WI5wVLvFjuwmd2fNCKt5vwUg0WrMNDJbhrFe5YTmzc
9gWpungZilehuBzF61G8AcW1uK0edzTgrkbc3Yx7ifEW3G/FA614sFVIb8PD
bcz7IzY8aqOrPNZOOB5vxxN2plxRn6LDVQscYNqdWEilA890MOWKSqQr1xHl
f5BCaDdOC9NTBtNndKaZaJWIVq7WqO49pVPdfRK5E/luiLn39ifwfouJ9xt1
3qV3+Pd03rvPX2pZdjnRcrm/E4NRDCYxkENPD7pkyi/Zx0s2QrJmytvNK4Pa
s7Cm0JBATQyVEZQFeXJrqQefOPF+O95swcuNeLYOj2/A/etwdznuWou7ynDn
Oty5Hnesx+2VuH0Dbq/B7XW4ox53NuDuRsJ+dxP1ge8hBTSLAlrwgBUPWlkH
D7Xi4VY645E2qvGPtuExG5j9djxpZ/bt1AZyt/xpB3P/DI/fPktWf91zHXje
xYWwFuSbzZpZJ7aVecS3RrbOt9p1okBcPsufzJ/NuXYstGaF38qvfk0n1L13
rrvpmy0RbElgYw7jgxgeQv8QeoaRHUJS1saFBnhln7sHjm60daE5g/oUqhJY
F0VpGCsDWOLDJx6878Tbdrzahhda8EwTnmzEo/V4sA7qfbUkw711uKcOd9cR
jrvoYCGS75JC7xthYcJ/eE8T7m3Cfc1c7m/GAy14sIUZf8iKh614pBWPtuKx
NjxuwxM2PEne5imy+2sX2PE0FeLawVw/6wTxrDlt5vaM5jWowbtGo1cz5R6D
3dwsdi3Z47NHqfOjO9/Kr3kG9lqdX4lAfkcnpFbs2+Gc3JfE7hx2DGLbODaO
Y2QcA+O8sCgzxusNI8MIDMI7gI4+tPfAmkNjFrVpbEiiIo6SKFaE8UUAn3Ti
Qy8WufFmB15x4MV2PGfD0214kkghdlrwcAseEsoeEI9BlkusMtEWolm9q54Y
uLsB91BpxL2NuK8J9zfhgWb+Ef2UrNlKLR9T3IrH24RiG4jhBe3M70K78Otg
fjVy2WRPY4AjCTZaS55XRSValauJWOKUSpbKcWSOI328kNcwdnKoc6INg38z
w1frDMs6pUfohDPpoyeGcWQcB7dg91Zs24KJLRjegv7NyG3klc+xcYRG0TkM
9yCcA7D1oaUHDTnUZFGZRnkKJQmsjGFpBJ+F8XEQi/1Y1Im3vHjNg1fceNHN
NZbqL1XlBdKqkbclx0t+mFpBaguJZ2oXieY7yHvU4o4a3FHNxzup1OLOOpC9
312PextwXwPub8SDTXi4mfX1qJUVx2y34gnSYxuesgnb7cz2M3Y869CpJpLZ
cCd1grtP6YbbddLMb/oY1NSxAn5idhySH3nTx9tmdFFwzwO9lWjkH+m8yxvP
XNyFqd04ugf7d2PnbmzeibEdGNyOnq3IbkFyEyITCIzBO4qOYdgH0dqPpj7U
96A6h8oulGdQksKqJJYn8EUcn0bxcQQfhPFeCO+G8HYIbwbxWgDUVaJ+AXWi
nvNhoYfD4secHGc8aOOQj1wzOerbKC6pwm0ctd9WCZV8uHLd7VVMP3F/Vy07
nHvrcX8DHmjEQ014pBmPtuCxFjxOhq4+QQ68iDlvw9M2LCRvQowr1xBY5nkW
1XmeFTXLPkInmmxZmC5KHkPyKBJHC7V0Zlv/XkHWfyEt5uz9PawCiU442vtm
+zYcuPT1YZw9jBMHcfAAdu/Hlr2Y2IPhXejdga7tSG1FbDNCG9E5AfcYnCOw
DcM6iMZ+1PWhugeV3ajIYW0X1mSwMoNlaSxJ4fMkPkni4wQ+TGBxAu/F8W4c
78TxVgxvxPCaDKC8GAJ1b6lP97gbD9op6r58W/U3xeVfF5ddVovXQvlZcZmE
LhQprsNt67klvaMKd1bj7hrcW4v76vFAAx5sxMNNeLRZ2G/BE1b2WsT8AoN8
zc41whWVKFeKiPSsGHfmBFSmuyh1HMR4UorKhFviRxE/UnAkmZnnTXjMeGHW
f4lZK0vup8/PHz741cmzl0/jwilMncCJYzh4BHsOYdsBbNyP4b3o243cLqR3
ILYN4S3wb4JnAh3jsI+ibQQtQ2gcRG0/qvtQ2Yt1PSjrQWk31uSwsgsrurCs
C0u68EUXPu/Cp134pAv/0oWPu/BRF8+U8dSHzJp90I3FPVhNV5tA03bY91+O
HUfXJIo/ulC85HLxUhSvBIfmpbitDLeX4/Z1uGMD7qrGPUL4/XV4oB4PNeBh
aoCb8FgznmjBk1Y81Spst2GhTWdbM+zsSZ1jzaKPQxV2j4HJVWNHvsWXzOV2
9rggn3FzAW1oY+2APlqc30Wh/Obk9Onz5y99cw4Xp3F+CpOTOHoSB45j11Fs
PYyJgxj+Ev37kNuD9C7EdyCyDYEt8G6GayMcE7CNwTqKpmE0DKFuENUD2NCP
9f2o6ENZH9b2obQPa/qwmtfWr+qDuqIfym9XDGD5AFYNYtUQVo6gbBTV42ia
QPNWNO+CbT/8RxA9jiw1atTOTTGq4hfOFr+H4k8xRwfluI3iyErcXYV7a0Cx
zgN1eKgeDzcI+014vBlPtuApKxa0zmFfUTMcz6VPgM36OJLH2awVZl6Ns23H
joLYj5ICVD5YIofzsYliDNPOCkh0j27sgTLaT2Plm2LxHDTmDFgT31e0mUCe
5FH+M9W6jWe+PnLh0vSlr7/6Chcu4Ox5nD6L41M4NIl9J7HjODYfxfhhDB1E
35fI7UN6D+K7EN6BwDb4tsC9Gc6NaJ9A2zhaxtA0ioYR1A2jZghVQ9gwiMpB
rB/EukGUUxlCGZVhVAyjfATlY1g/xvzXkwo2omkL233rbjj2wX0QgSOgCpAx
FDE8hdFpjJ/V53OLF8/VyFrcVsEx/V2VuKcK99XggVo8VCfqaGR1PDFbHa26
LlKiBEUlHTD/SlH8GEgHMSkWjf0jIAWwDtTw4dl1YtZMjzYtU7ClnVUXfmxE
OL6DUifm+w7R952H0HmYi1JEBx60U34bOorQMYSPsSESBQmqptQBm8TIFLac
xf4Ll49fwpmvcIaOF3HqAo6dw6Fp7DuNnaew9QQ2HsPoEQwcQs8BZPcjtRex
3Qjvgn8HvNvg3gLnZrRvQtsErONoJp2NoWEUdSOoHUHNCKpHSKwqOtxaNYoN
Y6gaQ80Y6khLVEs2onkzWrbCth223bCTog6AIISOIK5VmkkMnmFBWVfUmz+L
zeegbjmnrU+8qXi17r/uqMDd63Evdcyq8UANa+qRejzagMcb8QT1IZrxVAue
tmKhoakE0cC1hBSkxriWRI9yFZFaQipSikhDYaMY63Zk7N3cL8XcNZ9E+8GZ
eawiwjLffxjzyPgsQbrP7/O6iFA5Lho5wRpJnkT6FLvnHoqFz2BsGgRyzwUc
vISjX4EUdPwijl3AkfM4eA77prDzNLZNYtNJjB3H0FH0HUbuINJfIrEP0T0I
7kLnTni3w7UNzi1o34y2jbBOoIUUNI5GUtAY6klHoyiqH4NK9UW5qVFTxyZY
t6B1G1p3on03nHvh3g+CFDzMNkzWTa6elXKalUJSThhKUYpIYGXepnP8fuIs
xs5iZJo6Y8IJUUFMx47xNVSimquBYgkf0QlW1NBhzZYLrGqUelBg3sPYRSiz
1v5DUIVnegWJa6JZKQofNYgmLRPTyg1k/fFZdJOB5YTxfurdTbEz2HoeOy5g
9wXsv0hSHaLDzw/Qm/PYd47ncnZO85TrpkmMncTwcfQfRfdhZA8heQCx/Qjv
RWA3fDvh2cHEO7YK8ZvQSpxuRAs1w8T9OHOvNhDjP22UloIbC9IMnbAZ1q1o
3Y72HXDsQsceuPfB9yWCB9lfUJxCESO1tdQ/IvZHp6Q+TGMzCX2OV26ch0rS
KzeQLjaem9EAuTpC13eG3V73JFsYoab6nz6JFMeiSY5FqTpQfYtzjYix3yIV
EauRoyA9sZqUeaSlkFGChzQ/ZV4BYvkWTeV3+rKmAodgIS1ZyKBU0RTXNlJX
2CiqaIvrJWns97q6yLGKyOS+s5O60ggTgRsRJ06giYCdorp9F7HvAvZewJ7z
2H1OZkhkbmSTzEwOnUT/cXQfRfYwkgcR+xLh/QjshW83PDvh2gEnxUrkkLag
bbNobhPrptlQnkrqUm5tlrrSIqV1M2ziwBw70LEL7j3w7UOALksXP4zUUe5U
9Zzgccbh0zxWs2mave62c9h+DpYdpLEbt5/nyr7JUNqwKI3Q9RgaI9SsLtEY
UaFpi+iJaUxZIke1uJ80FZIi9YkYViysK+2feU2EJd/Of/com/yO26m8VyMV
KvPo6kWiO67FM7rjdk7TnUoyKr/VlJfMK098XF5/A1LvNBUS/i3nsd3Q4h45
7qK357CDtHuW57YmZKx86BT6TqCbGvOjSJJfOojwlwhQXdkDz2507ISD6tA2
ViHpT1FJgyrpSSkilWmVjf7gT/gb5Sdtoj/7djh3wL0L3t3w70VwPyIHkDiE
9BHkjqH3BM8OjUyyACQGCbOD6xxJp5KQynUk8jZR4oTUuSGpcwQxp9U2UR9X
NJXoUOZryiOaopp3It6IO6pjhvqIW26mNA1SZQloSiy0GmMmVig0v3mNES8X
kR3Q1bQi1hHK1+yjLIFWqN4rWt07punv5sRxo/7NroKixW7RYq94Tw6opvWA
aqPY8hapkWTf6k6y8Z/SH2Tv5KnI9qkGjE/xUPzAJA8F52S4IUGBEclIzf9+
ePbCRW3PTth3wLYNbVuMWigVUeE6qDbyflr6g9wqOVdFZVX/NemyfSsc29Cx
HW5qAClI2YMQNYnUMB5A5hBy1FQew+AJjJ3i9QrkFcilk5PYcw57z7PbIOdB
GqU2gHyppsyBKcaYM2ohmTIRQm4pJq23eCvWHjc5mvYU9mvKVUR0IF8OsUL9
ut+8oaAOzXvn5+f7OpruQhzT0YErnBZHGvqiOsde28LRprgGsjM6/MMcrZ0U
rUmDN1tx+Rqo6W5C1LdZNEUMbJMKuU3eUkOzUYKwsSkeCu2f5IFP6vJRV5r6
F6FD8B+Adz9ce+GgSG4ne0QKIyiYoHateeMsrf22QdpAKo0SjmgaJP3ZNsNO
0STFlNvh3Qn/LoT2ILoPiS+ROcgtbd9RDB3ntpdaYGqHd01jL8Wv53DgPA5d
wOGL+FK0t11UNyh607ynpjRNYxFu5SguUElhFtaUhYIzTU2KhWIIiSU6D81Z
f/XDb9WYsfZa0xS9ISJCekRjoUZTJW2xsjjA1Ppix7R2liNP1tKt3GHTFHXC
UJRJV5MMpG+uusby6hLPSRqT+OvWzVr8JSdQjDB0hn9I3TK6Jt2NBCFT9B6A
az8ce2HbBesODjqsoiJSUMMER+Z1Y7BQXKj8lv6gGJEixQYJ60lZFES2boRt
Exyb0bEVHuq0UddtJyK7Ed+L1H7kDqD3MIekFJhSeEpB6q4z+HIah89x/Hri
Ik5cwrGvcOAiq4mMjsTLioKoSmnaId2QaihaDrB1B1hD1IkmzfhZQ9SrYe1Y
uLcz35fvixpLfs0rOgrXLWOloyr1iWJGjkfncQfA6K3FdB1RbHSMmUsY/ToO
mm5OX6mqUwVUNVhQW6IwVe/HKLdoGqOv6aQR6Zf2S7tPNyBPTAbqPYSOL2Hb
i7ZdaNuGli0cpFO0XjuOWurujnGnSlE3jELdQL2s31QNo5r6y8Pc/aofQeMo
a4660q0TsG2EYxM6NsOzFZ3bEdqJ6G4k93Kvjvp21MOjft6mY9h2ArtP4cAZ
HJ3GyXOYukj9wm9OXfz66MWvt5+7PHCaRePg7BZj+OCKjAEF+S/KxxD5sQSq
LEYPgA/c62LHJoX7y1xhtJrCY9EJbXRDhjkkdiU1qKQE5casNrY6Ww2ToobT
M2ogYrV+pKnqsCYsrImf6BHYtN6E0y91NRznUZyOA7Dv4W5R0zY0beIxBurJ
Vo6inPMUrB2BunaI2F87iDIqA6gYwLoBHqrYMIiqQR6/qBvmsYymEVjHYBuH
fQKuTfBugX8rQtsR24nUbnTtRd9+DB3gIZItR7HrOL48iSOTOHkGZ6Zx/tzl
qfOXJi+c33j6omKsJGayzS2KWQvqLC3MHh+WOsA9XB6Q4EoQNQoP2KnC/lFt
HCMhhcf0pBaQ+i1pGe/LyIg2aeEHMyo4NVcFp0UFvNqXlKBcPaOG6TkebB5r
4UatMtAJdK7mw8mBk1vwHUbbPjTuQNNmpn3dMI9tfjGAJVT6saQPS/ugLu2F
8uvlPVjRg5U9WN2DNb0o7cHaXpT3Yn0fj+jVDPDoXuMQWobROor2MXRMwLMJ
/s0IbUVsO9I7kduNvr0Y3o+NB7HtMPYcwaFjOHESp0/hwhlcmv7m3NQ5Ix9Z
kTGL9Ef5lyw5eg9Xs3+iPTp7bI5YJ86ZcuZdxvB4MG+ebvPajAHznZFZRs3q
T/JI9ymy3zztVzKvG/+VxGt9d2H+2s0SuOX5J/Kp9aS2yfHlN9Ztlx92XXg6
8I36bJDahRcjvETyrSTeSfH68PfTWJzGB2l8lMbHaXySxmcZfJHB0gxWZLGq
CyU5lOVQ0Y3KHh7WruvnIW7rEGwjcI7CPY7OjQhtRmwrUtuR24m+XRjZg437
sP1L7D2II4cxeQznTuCbk/jm0LELu7Zo+6kWGnvFZpi+riDzPyj0KVegvKUf
gcY4W3vCmBxIHTMsXWjP6HM3apc+L6mZ+oy1TzLnKk9lXmuiXed8Lu3s/1WK
rCwUZin/Yat0ILSuO/0oc/wbku/2StxWKbNTNTw1eK8VD7bzsqQnXVjoxfOd
eDGAV4J4LYQ3w3gngkURLI7iwyg+juGzOJYksDyJVSmUZFCeRWWOp3Dqe9HU
j9ZB2IfgGoFvDMEJRDchuQVdW9G7HcM7MbEL2/Zg7z4c2o/JL/HVflzeBwxN
KNpaSqaycN4hM/OFPhWvY7BtybOtzYNZUjPzYpqVy+SvZuUnofLEzlU9p3S+
NcoHZApZUdnFXHUl50S4ohLlimWz1i/hvhtFHyr3vv8j9d12nNeLFuxuOXOO
JLy7HnfVy9RrDc++3qEtpWnidTT3y/KZR2x43I6nZFXMcy684MbLHrzmxZs+
vOvH4gA+CuLTMJZEsTKONQmeIq7MoKYLDd1o6YWtH85BeIbhH0V4DIkJZDah
ZzMGt2JsG7Zsx87t2L8DJ7bj9CacG7lozJiwvzHnqCto31fUhRm/Q8TrnFvY
xpnsGzLH2cC1qTKN8Jy2bEQmMHsNxinul7l6JtwyJAsjRtizE+HKdWNTBuXT
YuNnubu3VRjfLgQT2buowyy95mupi7/3Ig/UUDl8/uvpU1+SbA+08JqN+5p5
Ccc9jVB57QEv7/ibuxpxj6zqeKAZDzbz3PejMgP4dBuea8dLdrzmxNsuLPbi
XzrxeQDLw1gTRXkClSnUZtDYBWs37L1w9cM3iOAwoiOcyaprHH0TGNqI8Y3Y
uhG7xrF3AAe6cSR8YlvdLn188Td/Et9mry8jl7zaIyWuhAr1c4lrlajW/Ai9
eI5yHtHcY9DcN6mvhPi+ZtbU18rTzFYta6yIYpU4Vn5uYpkpPs+jJtoIyl7p
Eh28hEOXuHs0dQlfXbhEAj0mC74eaePlRw+18oKk+62y1qOJF4sVkadR/oqX
HlQb84E1uK8aD9fhiQZek/OiFa/bsMiBj9z43IflAZSEUBHjxTz1KTRn0ZaD
sweeXvj7OZFYfIizEeVGOKXE0AjGh7GpH1uz2B7DiONycPlZNsp/ZWLPPF6l
cXyD3obm92HNI04zsmwhe5xNV1/flDthmO9JbS1JL6+F6jvF9tsvK6Q0j0GH
26/kdqOsHdSJNQbrTNzuu8DcHqbezCVMfoWzX+Hrr7g3ssDJPuFJWeJB/uEx
WdD4iKxvfKiNF9/l13qQP7mdSj379+IK3LYWt6/BnStxZwnuLcNj6/FsDV5p
xDut+MiOz11Y6cPaANaHeXlaQwLWNC9Y68hx8q9gL+eBikvykq4+9PTx9uuh
DIbjGAmhyw7Hym8+eP78n8KzNhNr7kcZI0zKVRrN2pKcPMuKymsni3q1xZTC
sqz5s2gGLOuE2U38fPTMH2P5HLO8+zyP3pJf2H+Bu4pku8TyKWH5krD8nIdX
2j7jxkI3VF6G+28WdOApKU86eb3uYw5uJx+x82KPB2Sxxz0tuKsZtzfyOlRe
bPDF5eLF39z+yeU7l+L+VXi6Aq/UYFEzPm7DUidWezhNx4YQp5ppjnOeK4ek
SuqUpEFhSR6SzPGu/q4sMnFkw8h44W9GSxmWLsbLr6AQ19cU5NocPeZnmHSG
yUswxVf1yCJVjeP+U7oZa+uFf6mRPCJLAcfyHE8ZHE/rHG+Xkcud57DrnMHx
eeb44AWD40vsJS5cYvFf7OQl4eoffCTN8z4878VzXvDK+2c8VAfp9bRHW2T+
lBtP8JrQxzug8kr03zzagYedeMiBBx14wIHihZduf+3r+7/AMyV4vRIfNOCz
Vt52vdbNOTRqgryk2BrjxDUdkqzGpyUwySCaRjzNK5LjMUQDCLrgssJahbUr
8NFH/z8YNq/Zz3uPou4TPIylMcvrJVVewj6f3YMUnVaK6ohX5c+IWZ3WKYPW
aTFd2Wqg03qOad13Hl8KrUeI1os4eZGnV89eZJlfCeBlKn7Zz6G+yHlhXvDj
BVmlREXlXR/P0etZej1D75+hs54NQPnVc0HeKVL8P3YV/+Gbhz/CS6vxbiU+
aeB9tiUOrHOjupPXwDeHeT283cgx4kvCn0QgwQkKQlFeSB/ohNsJmxWNdSgv
w5IVeF+Wx5u5NM/vaFzeqHtgWWXL8wK6WcrMlCL8zZvhb1Kv+3S4RTPN8TMG
gVMGgdNMIJnmzrM6gWyUROB5scsLOHqBpz9P8TiEvmrB8nqIg14qivpqEEUU
A1teDspuLMuL9P5F+uKvXwyDN2tF8HJEdnHF8GpcFmD891MPv44XPsHbJfik
GiuaUNKGCicnP6jr5M0YrWHJ1SIpTFyS2MMX4038vhBvyHZ7YbOjuQX19ais
xppyfLYai1cUYvCqggya14vPWGPfSanYshFF6vXPh2TjzojY4Ohpg78zBn9T
Bn/TUrVlP5A+nH2OKeSR0fM4ckHG3i7w5P7sWYI3wuBNkrxT0vI6vV7jVwSW
VyMoeo23o76mbayMa3sHlV+/mcRbKX3I7fGnv/rD23j7c3xSzhsZS1p4t1NV
BydJaPJz/pCZPCmSMcMd4WwILj86OuEkCjvQYkNdM28kWlvFm4o+XYsPSvji
f/0nsWju+RkrPqn2nuLZGt36JrXay/Y3dlonryB/OzT7M/jbdw5fnsNBjb/z
OHYeJ87nVy3JvPNbUdm/y/t4LW/GZS+07PMtejvF/eJ307x7WiT65YevXFr0
AT5aihXref/i2mbeSFfl4MQAzZ2SLkHo0hOMSE4NZxAOP+w+2L1oc6HZjnr6
SRNvRltdhWWV+GwdPiqfya5qYuJKvr416zFxJftOeB/ULSOTYmZSdEuTrYqb
ZW/Z1imxNNmZR2Ttlg2O2hg8k3WOR3mPnNPqaP7678haQIV306tv63+8k9BL
0TtJ2VuuLkrLTn31fT33w1/UfPp1yTKUlqJsAyrqec9mlY33b9Z1cLoAq9Cm
pZiwh3jDJ2+RDaC9kzeCtnl4b3aTA3Vkklasa0JpPVbW8A7IzzbgXyrxYaXo
0syceTRTY+6nusczxvuVq4dl3+GowdX4aZ0olZhSbpjhaoq52ikbQGe4Oosv
z+LgWRw6B2NeVuxpUQLzFyVhWZSSvBbq+8TGYmLjgy6Kxj/M6dUuXI2Wdajb
gNp61DSithX17Wh0yjZr2fjPe9UNZnRO/MxJq5c3YTe7+OS6dlS18R7a8maU
NGBFHZbW4vMa9oYfV38rM9+jtzNr9cz9/3zGfY0ZokUlXpQfT5w2TEi2Weu0
yPZrnRnZk73PYObAWcye56S/36dKNf/9lGSGUYoWp/XsKJwv5oMsuIOlXDvh
QaYNnU1ob+KWrc0Gq523t1pd+j7qtk7Za67cbAvoOUlsfv5Qo6XFzQQ2ulDv
RHU7KtuwzsrVdE0Tb21fVo8v6vFZHT6pY9n+8o9yY17/LNzwrmAmZlLsRbaa
bzo9i5gzs4iZmiFm7zT2T896noK+7I8t5oM0ijh/kDEOfy39sSmCXi/vMvK1
w90Opx12J9o6uEq0+7h6WMgclFvatQQksgefaGn1caYDMqBmDxrdqO9AjQNV
7VhvQ3krSq2cKGFlM5Y1YUkjPm/EZ41iJWYmiq5g4hcFmNByPY9PzpCw+fQs
Es7MImEKuyXpwV5ZOTkTKesMzDMshZchbkpigKLwToQ9nBbE64LbBaeHfahK
rtTCSURusQfmpB8g6FYf15pmr+B2cVoScsyVdqyzocyG0lassWJlC5a3YGkz
ljTj82bNv5nHBCxXYP+l7jfy2QEmJnW8kvXi6hm8kkpk5xkdr/H8Bb74Dw29
bsxiKIHuCBJBTgZDMZyvE55OblBdWs4YZ4AzuwbYtO2SWIZ8QD5dQEsne81G
D+dcqXWhuoOzhqy384bcsnaU2rCmjTO1rJCsLUutWGLFF1bh3IxTvQLnr75N
x1fpqpXUKFtP61AVlcAqFoKrTchdsUdRMPNe8Ilu7sP2JJCJIRHhLEHBMGcM
8oY4exDDllRLklvozzTM5PRmYPu5dW3ycXqiOg/n4qHwpNKJ9U5UOFAmGY3W
tHPunpU2rGjDMur5tWFJG8v16z+K+i9MZ0i0zAa5aXIGsZZRx7L9tDFPaY5a
BCsvkhun/noOvWl0JZGKIxZDOMpZoyjs9IQlcgrpcAmt5Jq6uV1yk7UFuSVk
rH7eeN7o4wis1oNqN2+4rnRxHqtyJ8oks1WJnZM5rZLETsvboS5rF00Jlnmz
Z4Zk/YngNDMhONnlbJZEU5xx6jQnwGF05vzvgo534o31Y6gHfV3IZZBOIZFA
lHojcc6b5otyGjWKDl0SJjpDM9kbtBQEBNAa4CRkFFY2dnIGrjovpyir9nDG
sko31rk4h1mZE6WS1WyNJPNaJYm9VkiSr2UOka4wSk2bv5ldVzlq2aKl0WJ2
zLna86hGBzDYh74edHdx3rtkGrEUIklOieePc5/BI/vhXZI5zxkxMgWE9UwB
rUFG1SzAGiQJX50k5Kv2YoOHs9NRl65c8tWt7eA9zSWSx261E6skm9sKyewm
Ev75dyAzt+RG7TS3UYLqb7n9HsJgP/p60d2NbI5zFyakJx5OIUh9yQTvYffG
uVfkjqFDciBSPym/3Z8if2uIs+cRsMYA5xWsl3SKNZJacYOXN2iv83AqwnJJ
S1jq4tR8a3j8YDUd5q1yYaULK6QoBraZWUu9Dl7ZSzC3RYLn7+gCw0MYGERf
P7p7OcdkOsf5JmOyvzmc5s3k1D32SXJKjySqdMU5b6VDOoA2yd1J/UGrZLhs
CgqkAOr8nAKzphNVkjOy0sf5Iyu8nE6yTFJLlro596K6hnfer5akjFp2RvNz
aWb0ZO47mv2u4OG9U0PDGBhC7wC6+3gna7qbdxDHuzhpaFhGTQJp3h9P/X5t
i7wrwSMBTkmnqqUcaJMcqy1hztvZFOIcnvWSu7RWUplWSVrTyk7O+bnOJ6gk
H+haL0q9vBN5DRUPj5Bxbk0vVnpFT0Zrp6H5G5P0Zi+S187gCO8T7R3kvLRd
fZyjNtnNuVxjOc7rGsrySJBfAHlTnP7VnWRATsl+a5dMuG2SAtgqSXKbwwyo
IcRpWOuCnGe2OsAZWjdImt31kou2opOzuJZRVLCWR7ZKfSiRwvleV3Nij1U+
w1v/fA6mv9XfFcTyr+j0gVH0DaNniFMJZ/uR7uPEyoke3t4dyXE23mCW99N3
ygiXV3ITuyRNszPBcNrjnNu3LSZwopz2tynCKYAbJPFxXYhTA9cEGdEGyY+8
ngI5ySJsqfBztt0yzsTL2XctpZ0okaJl5uUUvbNWv7A/+14e1W9NaMxzS4Lu
X9Ov+0fROyLoBjlPdLqfc0Ynejl3drSb00kHuzi1tD/LCQO8km7bLam3nUlO
ymxPCMA4J6q2xjhxc3NUAEY4p3N9WABKoutqSXqtYwxgnZYcW/Iml2mZlCWj
MmdW5gzLeqtalEf0OxMC83Og8rbXN8aIuoc533l2kHOfp/qR6ONU4NEezo4d
ElD+Ls4Y7pMc6m7Jp96hgUrykKUtwXm3W+MCKiagogIqIqAkZTmDCvFW/g2S
1Xs9teCS5bzCyH5dxvmw6cV5sUsC+izdmoDuzLW8y/qsh/acC3NOh9nvf2R4
8t4x9Iyie4TT2GeGOKV9agCJfs72Hu1FpIdTwAe7eUC7s4uT4nuzAjHDWeOd
kjvfLnn0GWJCIMYFYkwgRgWi5KSvjXBu9uowp6zfwGNylXTgXPbrqEha9/Kg
NhX2Y11TEkXI87q4RhVE8FMNQfcozxzlESQ1BP28dz/Sy09fYATdnDyhU57P
4JFnNbg0EGkBwVkQbdyJZBQJQRFnFI0xqA1RahLr5QEKtfKEAX7UAKEIa/Le
qMur5YL4vUlOc7wjcvN++B7Zl901ys+zyAwjJXvgEwOG3H38yIigPMTD381z
Cr6ciN7Fondk+KkTjjSngWiX52u0ybM2rPKgiuYEP9+hMU6Scxav+lh+N5ai
jSwWGb0G7cluprwUV0jL+Sm6x/mJG5q06WF+eEhyiJ/KERvgh3RE+nluKdQr
0vbwszx88igSjzxHxSVPKXHKE0tmBE6JwEldYOn8GHVUyyL5b02ymONike0X
9LPcOD/AJDvGT15Jj+iyxeV5NtEBka2fn4ISlMe3kHi+bk7m4JEHz7jkITTO
rMiW4Ser2NIs2xx5tCzZ/6hbYkE5uOeem+CpYk2OlDzcJzHME5sxyW0QGRA5
+vkBMoE+zijRKaJ4uqGSIIolL4rc28gQoj0f638y3dOcGUdkuJl+1jWB7Djv
9k/Lo490GYb5qUO6DAMiQ7/I0MfPA/LJQ4tIDHe37GO6FbNWECj/3nQn8zyJ
3Jlzema1O48jPSZ3HuWEA/qdh/jZR2F5aBTfud+4c6/W6Bg8a8+h+p9NdzDP
fckdr9bumJng50ylxuR2o/wYLHkW1fyoPKIrLBklggN8x9m2L3GUPKmS9Vnw
+tfR6RntQWra9cf068dG+JFbkWF+ChhdXzFy3fN1tef+/SfT9cwr7+T6PBqR
kaQBqXF+elpCu/6oXH8kn0Gff/YPctX/xXQV80oCuSr3udIb5TFzE/pV42Oa
jIaX0p7/+J9NvzavA9GeA0k/S8nVkhPgR9gZmb/4OmIX8uw+5rDg7y3a79nz
GPvf+JfaM0b/N9MvzHPMxm65H+q/+i/yq//ddJZ5Lu/P9bP/q5z9f5i+Nc9W
GZmO/knO/q+mb81zCka9+G9y9v+JWXNcpprJZxXLWf+36VtzrmkD3Z1y9j+Z
vjXvc7tWP/teOfufTd+as50bOzselLP/H11e81nz9Gs+Imf991nfLtQ3UfO3
T8i3/4OO3IV8Wt4p3/v/AFHs3iU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222781539]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13509],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCosh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCosh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27988],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->26321],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->7592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31597],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseCosine.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcCos/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ArcCos"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->593205938],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->306180861],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->8556039],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->12371548]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcCos - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 30.3306614}", "context" -> "System`", 
    "keywords" -> {
     "acos", "arccosine", "arcus cosinus", "inverse cosine", 
      "inverse trigonometric function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcCos[z] gives the arc cosine cos -1 (z) of the complex number z. ", 
    "synonyms" -> {
     "acos", "arc cos", "arccos", "invcos", "invcosine", "inversecos"}, 
    "title" -> "ArcCos", "type" -> "Symbol", "uri" -> "ref/ArcCos"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6883, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109801049]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 173322, 4166}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2844, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3467, 89, 43, 1, 70, "ObjectName",
 CellID->6645],
Cell[3513, 92, 743, 25, 70, "Usage",
 CellID->30175]
}, Open  ]],
Cell[CellGroupData[{
Cell[4293, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4771, 139, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4894, 145, 67, 1, 70, "Notes",
 CellID->23448],
Cell[4964, 148, 483, 19, 70, "Notes",
 CellID->24919],
Cell[5450, 169, 239, 8, 70, "Notes",
 CellID->9487],
Cell[5692, 179, 214, 7, 70, "Notes",
 CellID->31226],
Cell[5909, 188, 197, 7, 70, "Notes",
 CellID->28162],
Cell[6109, 197, 737, 28, 70, "Notes",
 CellID->13079]
}, Closed]],
Cell[CellGroupData[{
Cell[6883, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109801049],
Cell[CellGroupData[{
Cell[7268, 244, 148, 5, 70, "ExampleSection",
 CellID->777556384],
Cell[7419, 251, 62, 1, 70, "ExampleText",
 CellID->14122],
Cell[CellGroupData[{
Cell[7506, 256, 98, 3, 28, "Input",
 CellID->26859],
Cell[7607, 261, 182, 6, 49, "Output",
 CellID->348816012]
}, Open  ]],
Cell[7804, 270, 121, 3, 70, "ExampleDelimiter",
 CellID->10999],
Cell[CellGroupData[{
Cell[7950, 277, 214, 7, 28, "Input",
 CellID->1899],
Cell[8167, 286, 901, 30, 54, "Output",
 CellID->174109002]
}, Open  ]],
Cell[9083, 319, 120, 3, 70, "ExampleDelimiter",
 CellID->1320],
Cell[CellGroupData[{
Cell[9228, 326, 233, 8, 28, "Input",
 CellID->32036],
Cell[9464, 336, 2717, 49, 168, "Output",
 Evaluatable->False,
 CellID->766739404]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12230, 391, 215, 7, 70, "ExampleSection",
 CellID->1915],
Cell[12448, 400, 60, 1, 70, "ExampleText",
 CellID->23953],
Cell[CellGroupData[{
Cell[12533, 405, 100, 3, 70, "Input",
 CellID->19485],
Cell[12636, 410, 176, 5, 36, "Output",
 CellID->357740591]
}, Open  ]],
Cell[CellGroupData[{
Cell[12849, 420, 100, 3, 70, "Input",
 CellID->10199],
Cell[12952, 425, 256, 7, 36, "Output",
 CellID->520036021]
}, Open  ]],
Cell[13223, 435, 121, 3, 70, "ExampleDelimiter",
 CellID->20877],
Cell[13347, 440, 70, 1, 70, "ExampleText",
 CellID->20353],
Cell[CellGroupData[{
Cell[13442, 445, 122, 4, 70, "Input",
 CellID->2942],
Cell[13567, 451, 273, 7, 36, "Output",
 CellID->196483990]
}, Open  ]],
Cell[13855, 461, 120, 3, 70, "ExampleDelimiter",
 CellID->4208],
Cell[13978, 466, 65, 1, 70, "ExampleText",
 CellID->6844],
Cell[CellGroupData[{
Cell[14068, 471, 176, 6, 70, "Input",
 CellID->30169],
Cell[14247, 479, 235, 7, 36, "Output",
 CellID->230217194]
}, Open  ]],
Cell[14497, 489, 108, 3, 70, "ExampleText",
 CellID->4879],
Cell[CellGroupData[{
Cell[14630, 496, 143, 4, 70, "Input",
 CellID->21108],
Cell[14776, 502, 239, 6, 36, "Output",
 CellID->165530392]
}, Open  ]],
Cell[15030, 511, 125, 4, 70, "ExampleText",
 CellID->5259],
Cell[CellGroupData[{
Cell[15180, 519, 140, 4, 70, "Input",
 CellID->25706],
Cell[15323, 525, 201, 5, 36, "Output",
 CellID->934815438]
}, Open  ]],
Cell[15539, 533, 121, 3, 70, "ExampleDelimiter",
 CellID->24075],
Cell[15663, 538, 87, 1, 70, "ExampleText",
 CellID->28026],
Cell[CellGroupData[{
Cell[15775, 543, 119, 4, 70, "Input",
 CellID->20124],
Cell[15897, 549, 182, 6, 49, "Output",
 CellID->216834250]
}, Open  ]],
Cell[16094, 558, 121, 3, 70, "ExampleDelimiter",
 CellID->17774],
Cell[16218, 563, 214, 7, 70, "ExampleText",
 CellID->2884],
Cell[CellGroupData[{
Cell[16457, 574, 161, 5, 70, "Input",
 CellID->20128],
Cell[16621, 581, 273, 9, 36, "Output",
 CellID->29167813]
}, Open  ]],
Cell[CellGroupData[{
Cell[16931, 595, 591, 18, 70, "Input",
 CellID->3145],
Cell[17525, 615, 426, 15, 51, "Output",
 CellID->36144656]
}, Open  ]],
Cell[17966, 633, 126, 3, 70, "ExampleDelimiter",
 CellID->1002762420],
Cell[18095, 638, 203, 7, 70, "ExampleText",
 CellID->363088136],
Cell[CellGroupData[{
Cell[18323, 649, 139, 4, 70, "Input",
 CellID->49478881],
Cell[18465, 655, 278, 9, 52, "Output",
 CellID->507469410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18792, 670, 238, 7, 70, "ExampleSection",
 CellID->2343],
Cell[19033, 679, 359, 13, 70, "ExampleText",
 CellID->26133],
Cell[CellGroupData[{
Cell[19417, 696, 256, 9, 70, "Input",
 CellID->32097],
Cell[19676, 707, 348, 12, 51, "Output",
 CellID->194119746]
}, Open  ]],
Cell[20039, 722, 121, 3, 70, "ExampleDelimiter",
 CellID->20736],
Cell[20163, 727, 80, 1, 70, "ExampleText",
 CellID->19555],
Cell[CellGroupData[{
Cell[20268, 732, 112, 3, 70, "Input",
 CellID->25633],
Cell[20383, 737, 173, 5, 36, "Output",
 CellID->191249161]
}, Open  ]],
Cell[20571, 745, 119, 3, 70, "ExampleDelimiter",
 CellID->930],
Cell[20693, 750, 201, 7, 70, "ExampleText",
 CellID->10252],
Cell[CellGroupData[{
Cell[20919, 761, 292, 10, 70, "Input",
 CellID->19904],
Cell[21214, 773, 633, 21, 54, "Output",
 CellID->87042836]
}, Open  ]],
Cell[21862, 797, 120, 3, 70, "ExampleDelimiter",
 CellID->1697],
Cell[21985, 802, 95, 1, 70, "ExampleText",
 CellID->18217],
Cell[CellGroupData[{
Cell[22105, 807, 214, 7, 70, "Input",
 CellID->15955],
Cell[22322, 816, 1231, 40, 54, "Output",
 CellID->722462963]
}, Open  ]],
Cell[23568, 859, 121, 3, 70, "ExampleDelimiter",
 CellID->12488],
Cell[23692, 864, 229, 7, 70, "ExampleText",
 CellID->24870],
Cell[CellGroupData[{
Cell[23946, 875, 602, 21, 70, "Input",
 CellID->31754],
Cell[24551, 898, 478, 17, 36, "Output",
 CellID->56857747]
}, Open  ]],
Cell[CellGroupData[{
Cell[25066, 920, 98, 3, 70, "Input",
 CellID->32176],
Cell[25167, 925, 516, 18, 49, "Output",
 CellID->812949499]
}, Open  ]],
Cell[CellGroupData[{
Cell[25720, 948, 131, 4, 70, "Input",
 CellID->15415],
Cell[25854, 954, 1102, 36, 126, "Output",
 CellID->3277057]
}, Open  ]],
Cell[26971, 993, 120, 3, 70, "ExampleDelimiter",
 CellID->4231],
Cell[27094, 998, 194, 7, 70, "ExampleText",
 CellID->17480],
Cell[CellGroupData[{
Cell[27313, 1009, 107, 3, 70, "Input",
 CellID->19975],
Cell[27423, 1014, 271, 9, 36, "Output",
 CellID->86198580]
}, Open  ]],
Cell[CellGroupData[{
Cell[27731, 1028, 157, 5, 70, "Input",
 CellID->20514],
Cell[27891, 1035, 161, 5, 36, "Output",
 CellID->109189768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28101, 1046, 223, 7, 70, "ExampleSection",
 CellID->14990],
Cell[28327, 1055, 211, 8, 70, "ExampleText",
 CellID->19438],
Cell[CellGroupData[{
Cell[28563, 1067, 438, 14, 70, "Input",
 CellID->28981],
Cell[29004, 1083, 3502, 62, 70, "Output",
 Evaluatable->False,
 CellID->309403105]
}, Open  ]],
Cell[32521, 1148, 120, 3, 70, "ExampleDelimiter",
 CellID->5242],
Cell[32644, 1153, 203, 8, 70, "ExampleText",
 CellID->24618],
Cell[CellGroupData[{
Cell[32872, 1165, 686, 22, 70, "Input",
 CellID->16070],
Cell[33561, 1189, 62763, 1033, 70, "Output",
 Evaluatable->False,
 CellID->257516250]
}, Open  ]],
Cell[96339, 2225, 121, 3, 70, "ExampleDelimiter",
 CellID->24061],
Cell[96463, 2230, 74, 1, 70, "ExampleText",
 CellID->27219],
Cell[CellGroupData[{
Cell[96562, 2235, 319, 11, 70, "Input",
 CellID->28781],
Cell[96884, 2248, 182, 6, 49, "Output",
 CellID->365515878]
}, Open  ]],
Cell[CellGroupData[{
Cell[97103, 2259, 661, 23, 70, "Input",
 CellID->61114148],
Cell[97767, 2284, 246, 7, 115, "Output",
 CellID->298624388]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[98062, 2297, 233, 7, 70, "ExampleSection",
 CellID->12833],
Cell[98298, 2306, 76, 1, 70, "ExampleText",
 CellID->80512647],
Cell[CellGroupData[{
Cell[98399, 2311, 243, 8, 70, "Input",
 CellID->27587],
Cell[98645, 2321, 269, 9, 36, "Output",
 CellID->62867012]
}, Open  ]],
Cell[98929, 2333, 350, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[99304, 2350, 102, 3, 70, "Input",
 CellID->1064],
Cell[99409, 2355, 203, 7, 36, "Output",
 CellID->108860748]
}, Open  ]],
Cell[99627, 2365, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[99748, 2370, 251, 8, 70, "Input",
 CellID->404146284],
Cell[100002, 2380, 155, 5, 36, "Output",
 CellID->703984]
}, Open  ]],
Cell[100172, 2388, 121, 3, 70, "ExampleDelimiter",
 CellID->31447],
Cell[100296, 2393, 353, 13, 70, "ExampleText",
 CellID->10945],
Cell[CellGroupData[{
Cell[100674, 2410, 130, 4, 70, "Input",
 CellID->28406],
Cell[100807, 2416, 406, 14, 52, "Output",
 CellID->475999880]
}, Open  ]],
Cell[101228, 2433, 120, 3, 70, "ExampleDelimiter",
 CellID->8686],
Cell[101351, 2438, 217, 8, 70, "ExampleText",
 CellID->5794],
Cell[CellGroupData[{
Cell[101593, 2450, 421, 14, 70, "Input",
 CellID->23577],
Cell[102017, 2466, 25037, 415, 70, "Output",
 Evaluatable->False,
 CellID->327939786]
}, Open  ]],
Cell[127069, 2884, 121, 3, 70, "ExampleDelimiter",
 CellID->20307],
Cell[127193, 2889, 70, 1, 70, "ExampleText",
 CellID->26793],
Cell[CellGroupData[{
Cell[127288, 2894, 187, 6, 70, "Input",
 CellID->23504],
Cell[127478, 2902, 2590, 78, 114, "Output",
 CellID->9568707]
}, Open  ]],
Cell[130083, 2983, 121, 3, 70, "ExampleDelimiter",
 CellID->13240],
Cell[130207, 2988, 77, 1, 70, "ExampleText",
 CellID->485],
Cell[CellGroupData[{
Cell[130309, 2993, 307, 11, 70, "Input",
 CellID->16464],
Cell[130619, 3006, 419, 15, 39, "Output",
 CellID->422667344]
}, Open  ]],
Cell[CellGroupData[{
Cell[131075, 3026, 223, 8, 70, "Input",
 CellID->20337],
Cell[131301, 3036, 2472, 72, 105, "Output",
 CellID->60552452]
}, Open  ]],
Cell[133788, 3111, 121, 3, 70, "ExampleDelimiter",
 CellID->27168],
Cell[133912, 3116, 56, 1, 70, "ExampleText",
 CellID->28130],
Cell[CellGroupData[{
Cell[133993, 3121, 251, 9, 70, "Input",
 CellID->15255],
Cell[134247, 3132, 492, 16, 51, "Output",
 CellID->48714748]
}, Open  ]],
Cell[134754, 3151, 121, 3, 70, "ExampleDelimiter",
 CellID->13201],
Cell[134878, 3156, 47, 1, 70, "ExampleText",
 CellID->142],
Cell[CellGroupData[{
Cell[134950, 3161, 184, 6, 70, "Input",
 CellID->21276],
Cell[135137, 3169, 1158, 38, 68, "Output",
 CellID->152210801]
}, Open  ]],
Cell[136310, 3210, 121, 3, 70, "ExampleDelimiter",
 CellID->32702],
Cell[136434, 3215, 58, 1, 70, "ExampleText",
 CellID->10684],
Cell[CellGroupData[{
Cell[136517, 3220, 175, 5, 70, "Input",
 CellID->15023],
Cell[136695, 3227, 789, 26, 61, "Output",
 CellID->200088584]
}, Open  ]],
Cell[137499, 3256, 121, 3, 70, "ExampleDelimiter",
 CellID->30245],
Cell[137623, 3261, 252, 8, 70, "ExampleText",
 CellID->12187],
Cell[CellGroupData[{
Cell[137900, 3273, 130, 4, 70, "Input",
 CellID->14462],
Cell[138033, 3279, 190, 6, 36, "Output",
 CellID->183021663]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[138272, 3291, 226, 7, 70, "ExampleSection",
 CellID->16859],
Cell[138501, 3300, 344, 13, 70, "ExampleText",
 CellID->14016],
Cell[CellGroupData[{
Cell[138870, 3317, 129, 4, 70, "Input",
 CellID->8172],
Cell[139002, 3323, 176, 5, 36, "Output",
 CellID->103360358]
}, Open  ]],
Cell[CellGroupData[{
Cell[139215, 3333, 130, 4, 70, "Input",
 CellID->24441],
Cell[139348, 3339, 253, 7, 36, "Output",
 CellID->2190734]
}, Open  ]],
Cell[139616, 3349, 121, 3, 70, "ExampleDelimiter",
 CellID->16088],
Cell[139740, 3354, 122, 3, 70, "ExampleText",
 CellID->22015],
Cell[CellGroupData[{
Cell[139887, 3361, 503, 18, 70, "Input",
 CellID->13976],
Cell[140393, 3381, 271, 7, 36, "Output",
 CellID->44197435]
}, Open  ]],
Cell[CellGroupData[{
Cell[140701, 3393, 573, 20, 70, "Input",
 CellID->18298],
Cell[141277, 3415, 360, 10, 36, "Output",
 CellID->83044547]
}, Open  ]],
Cell[141652, 3428, 121, 3, 70, "ExampleDelimiter",
 CellID->31283],
Cell[141776, 3433, 109, 3, 70, "ExampleText",
 CellID->3205],
Cell[CellGroupData[{
Cell[141910, 3440, 159, 6, 70, "Input",
 CellID->19997],
Cell[142072, 3448, 180, 6, 49, "Output",
 CellID->764413898]
}, Open  ]],
Cell[CellGroupData[{
Cell[142289, 3459, 168, 6, 70, "Input",
 CellID->5769],
Cell[142460, 3467, 189, 6, 36, "Output",
 CellID->84780438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[142698, 3479, 223, 7, 70, "ExampleSection",
 CellID->6030],
Cell[142924, 3488, 56, 1, 70, "ExampleText",
 CellID->17442],
Cell[CellGroupData[{
Cell[143005, 3493, 250, 8, 70, "Input",
 CellID->21735],
Cell[143258, 3503, 2025, 68, 115, "Output",
 CellID->37898602]
}, Open  ]],
Cell[145298, 3574, 125, 3, 70, "ExampleDelimiter",
 CellID->310343378],
Cell[CellGroupData[{
Cell[145448, 3581, 628, 20, 70, "Input",
 CellID->277367973],
Cell[146079, 3603, 21347, 354, 70, "Output",
 Evaluatable->False,
 CellID->222781539]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167487, 3964, 311, 9, 70, "SeeAlsoSection",
 CellID->13509],
Cell[167801, 3975, 1668, 62, 70, "SeeAlso",
 CellID->19718]
}, Open  ]],
Cell[CellGroupData[{
Cell[169506, 4042, 314, 9, 70, "TutorialsSection",
 CellID->27988],
Cell[169823, 4053, 163, 3, 70, "Tutorials",
 CellID->26321],
Cell[169989, 4058, 181, 4, 70, "Tutorials",
 CellID->7592]
}, Open  ]],
Cell[CellGroupData[{
Cell[170207, 4067, 321, 9, 70, "RelatedLinksSection",
 CellID->31597],
Cell[170531, 4078, 184, 4, 70, "RelatedLinks"],
Cell[170718, 4084, 198, 4, 70, "RelatedLinks"],
Cell[170919, 4090, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[171340, 4108, 319, 9, 70, "MoreAboutSection",
 CellID->593205938],
Cell[171662, 4119, 151, 3, 70, "MoreAbout",
 CellID->306180861],
Cell[171816, 4124, 143, 3, 70, "MoreAbout",
 CellID->8556039],
Cell[171962, 4129, 156, 3, 70, "MoreAbout",
 CellID->12371548]
}, Open  ]],
Cell[172133, 4135, 27, 0, 70, "History"],
Cell[172163, 4137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

