(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53151,       1617]
NotebookOptionsPosition[     45016,       1331]
NotebookOutlinePosition[     46434,       1372]
CellTagsIndexPosition[     46348,       1367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcTanh" :> Documentation`HelpLookup["paclet:ref/ArcTanh"], 
          "Coth" :> Documentation`HelpLookup["paclet:ref/Coth"], "ArcCot" :> 
          Documentation`HelpLookup["paclet:ref/ArcCot"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcTanh\"\>", 2->"\<\"Coth\"\>", 
       3->"\<\"ArcCot\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Hyperbolic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcCoth", "ObjectName",
 CellID->31496],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcCoth",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcCoth"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse hyperbolic cotangent ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["coth", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCoth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCoth"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->10976]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26033296],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->419596434],

Cell["Evaluate numerically:", "ExampleText",
 CellID->341538452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474417426],

Cell[BoxData["0.42364893019360184`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281430445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5234212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCoth", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73786281],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74178189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30867189],

Cell["Series expansion:", "ExampleText",
 CellID->623928471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCoth", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521354216],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", "2", "]"}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "]"}]}], ")"}]}], "+", 
   FractionBox[
    RowBox[{"x", "-", "1"}], "4"], "-", 
   RowBox[{
    FractionBox["1", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "48"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   RowBox[{
    FractionBox["1", "128"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "5"],
    SeriesData[$CellContext`x, 1, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Rational[1, 2] (Log[2] - Log[-1 + $CellContext`x]), 
    Rational[1, 4], 
    Rational[-1, 16], 
    Rational[1, 48], 
    Rational[-1, 128]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{512, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46074933]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2370],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->40174808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116882886],

Cell[BoxData[
 RowBox[{"0.35133563902264625`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.15485147227122809`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->779619664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223317723],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->88315731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcCoth", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406380963],

Cell[BoxData["0.\
5493061443340548456976226184612628523237452789113751480222732250999`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521019271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18455232],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->18659275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "2.00000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399269772],

Cell[BoxData["0.5493061443340548456976226184612628523237453296602665595152`41.\
21693571162461"], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32397675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245924666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " threads elementwise over lists:"
}], "ExampleText",
 CellID->397001889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", 
  RowBox[{"{", 
   RowBox[{"1.5", ",", "2.5", ",", "3.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216118936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8047189562170501`", ",", "0.42364893019360184`", ",", 
   "0.29389333245105953`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562252374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112109847],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->306540079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220994862],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{28, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140710019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->404749289],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581253868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14152207],

Cell["Parity transformations are automatically applied:", "ExampleText",
 CellID->295677626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235359564],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcCoth", "[", "x", "]"}]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87495772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->405471749],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"ArcCot", "[", "x", "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87538544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363957679],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->278353701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCoth", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->661998605],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["coth", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{50, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->23881733]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->564284357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Coth", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->855448809],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "+", 
   FractionBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "45"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "945"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "4725"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "93555"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, -1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[-1, 45], 0, 
    Rational[2, 945], 0, 
    Rational[-1, 4725], 0, 
    Rational[2, 93555]}, -1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{259, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13953732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->244496156],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "12"],
    SeriesData[$CellContext`x, 0, {}, 1, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 1, 12, 1],
  Editable->False]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->757701583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467730006],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->41998822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2.2", ",", "3.9"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523584972],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0.2622622340620762`", ",", "0.49041462650586326`"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453652643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3426384],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->123689926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCoth", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101125233],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2822698]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19359],

Cell[TextData[{
 "Branch-cuts of ",
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->169625854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"x", "-", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108025290],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402269547]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11080],

Cell[TextData[{
 "Express ",
 Cell[BoxData[
  ButtonBox["ArcCoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCoth"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->765776941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcCoth", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408300678],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     FractionBox["1", "z"]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox["1", "z"]}], "]"}]}]}]], "Output",
 ImageSize->{185, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270766476]
}, Open  ]],

Cell["Convert back:", "ExampleText",
 CellID->383796518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37471775],

Cell[BoxData[
 RowBox[{"ArcTanh", "[", 
  FractionBox["1", "z"], "]"}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->463974438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101319019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"ArcCoth", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41484],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"ArcCoth", "[", "x", "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{186, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387940024]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6702],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7547],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->12121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23202],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseHyperbolicCotangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcCoth/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->163922098],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->350240084]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcCoth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 32.1119570}", "context" -> "System`", 
    "keywords" -> {
     "acoth", "arccth", "arcoth", "hyperbolic arccotagnent", 
      "inverse hyperbolic tangent"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcCoth[z] gives the inverse hyperbolic cotangent coth -1 (z) of the \
complex number z. ", 
    "synonyms" -> {
     "arc coth", "arccotangenth", "arccotgh", "arccoth", "arccth", "areacoth",
       "areacth", "invcoth"}, "title" -> "ArcCoth", "type" -> "Symbol", "uri" -> 
    "ref/ArcCoth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5481, 188, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26033296]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46206, 1360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2172, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2795, 79, 45, 1, 70, "ObjectName",
 CellID->31496],
Cell[2843, 82, 764, 25, 70, "Usage",
 CellID->26386]
}, Open  ]],
Cell[CellGroupData[{
Cell[3644, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4122, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4245, 135, 241, 8, 70, "Notes",
 CellID->9487],
Cell[4489, 145, 216, 7, 70, "Notes",
 CellID->31226],
Cell[4708, 154, 199, 7, 70, "Notes",
 CellID->28162],
Cell[4910, 163, 534, 20, 70, "Notes",
 CellID->10976]
}, Closed]],
Cell[CellGroupData[{
Cell[5481, 188, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26033296],
Cell[CellGroupData[{
Cell[5865, 202, 148, 5, 70, "ExampleSection",
 CellID->419596434],
Cell[6016, 209, 64, 1, 70, "ExampleText",
 CellID->341538452],
Cell[CellGroupData[{
Cell[6105, 214, 105, 3, 28, "Input",
 CellID->474417426],
Cell[6213, 219, 177, 5, 36, "Output",
 CellID->281430445]
}, Open  ]],
Cell[6405, 227, 123, 3, 70, "ExampleDelimiter",
 CellID->5234212],
Cell[CellGroupData[{
Cell[6553, 234, 237, 8, 28, "Input",
 CellID->73786281],
Cell[6793, 244, 2286, 42, 133, "Output",
 Evaluatable->False,
 CellID->74178189]
}, Open  ]],
Cell[9094, 289, 124, 3, 70, "ExampleDelimiter",
 CellID->30867189],
Cell[9221, 294, 60, 1, 70, "ExampleText",
 CellID->623928471],
Cell[CellGroupData[{
Cell[9306, 299, 294, 9, 70, "Input",
 CellID->521354216],
Cell[9603, 310, 1274, 45, 51, "Output",
 CellID->46074933]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10926, 361, 215, 7, 70, "ExampleSection",
 CellID->2370],
Cell[11144, 370, 73, 1, 70, "ExampleText",
 CellID->40174808],
Cell[CellGroupData[{
Cell[11242, 375, 128, 4, 70, "Input",
 CellID->116882886],
Cell[11373, 381, 275, 7, 36, "Output",
 CellID->779619664]
}, Open  ]],
Cell[11663, 391, 125, 3, 70, "ExampleDelimiter",
 CellID->223317723],
Cell[11791, 396, 69, 1, 70, "ExampleText",
 CellID->88315731],
Cell[CellGroupData[{
Cell[11885, 401, 156, 5, 70, "Input",
 CellID->406380963],
Cell[12044, 408, 235, 7, 36, "Output",
 CellID->521019271]
}, Open  ]],
Cell[12294, 418, 124, 3, 70, "ExampleDelimiter",
 CellID->18455232],
Cell[12421, 423, 112, 3, 70, "ExampleText",
 CellID->18659275],
Cell[CellGroupData[{
Cell[12558, 430, 148, 4, 70, "Input",
 CellID->399269772],
Cell[12709, 436, 237, 6, 36, "Output",
 CellID->32397675]
}, Open  ]],
Cell[12961, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->245924666],
Cell[13089, 450, 207, 7, 70, "ExampleText",
 CellID->397001889],
Cell[CellGroupData[{
Cell[13321, 461, 166, 5, 70, "Input",
 CellID->216118936],
Cell[13490, 468, 277, 9, 36, "Output",
 CellID->562252374]
}, Open  ]],
Cell[13782, 480, 125, 3, 70, "ExampleDelimiter",
 CellID->112109847],
Cell[13910, 485, 91, 1, 70, "ExampleText",
 CellID->306540079],
Cell[CellGroupData[{
Cell[14026, 490, 103, 3, 70, "Input",
 CellID->220994862],
Cell[14132, 495, 217, 7, 51, "Output",
 CellID->140710019]
}, Open  ]],
Cell[CellGroupData[{
Cell[14386, 507, 103, 3, 70, "Input",
 CellID->404749289],
Cell[14492, 512, 168, 5, 36, "Output",
 CellID->581253868]
}, Open  ]],
Cell[14675, 520, 124, 3, 70, "ExampleDelimiter",
 CellID->14152207],
Cell[14802, 525, 92, 1, 70, "ExampleText",
 CellID->295677626],
Cell[CellGroupData[{
Cell[14919, 530, 121, 4, 70, "Input",
 CellID->235359564],
Cell[15043, 536, 208, 7, 36, "Output",
 CellID->87495772]
}, Open  ]],
Cell[CellGroupData[{
Cell[15288, 548, 126, 4, 70, "Input",
 CellID->405471749],
Cell[15417, 554, 242, 8, 36, "Output",
 CellID->87538544]
}, Open  ]],
Cell[15674, 565, 125, 3, 70, "ExampleDelimiter",
 CellID->363957679],
Cell[15802, 570, 203, 7, 70, "ExampleText",
 CellID->278353701],
Cell[CellGroupData[{
Cell[16030, 581, 141, 4, 70, "Input",
 CellID->661998605],
Cell[16174, 587, 278, 9, 52, "Output",
 CellID->23881733]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16501, 602, 239, 7, 70, "ExampleSection",
 CellID->21920],
Cell[16743, 611, 207, 7, 70, "ExampleText",
 CellID->564284357],
Cell[CellGroupData[{
Cell[16975, 622, 176, 6, 70, "Input",
 CellID->855448809],
Cell[17154, 630, 902, 31, 54, "Output",
 CellID->13953732]
}, Open  ]],
Cell[CellGroupData[{
Cell[18093, 666, 103, 3, 70, "Input",
 CellID->244496156],
Cell[18199, 671, 420, 14, 36, "Output",
 CellID->757701583]
}, Open  ]],
Cell[18634, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->467730006],
Cell[18762, 693, 219, 7, 70, "ExampleText",
 CellID->41998822],
Cell[CellGroupData[{
Cell[19006, 704, 191, 6, 70, "Input",
 CellID->523584972],
Cell[19200, 712, 280, 9, 36, "Output",
 CellID->453652643]
}, Open  ]],
Cell[19495, 724, 123, 3, 70, "ExampleDelimiter",
 CellID->3426384],
Cell[19621, 729, 84, 1, 70, "ExampleText",
 CellID->123689926],
Cell[CellGroupData[{
Cell[19730, 734, 117, 3, 70, "Input",
 CellID->101125233],
Cell[19850, 739, 156, 5, 36, "Output",
 CellID->2822698]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20055, 750, 223, 7, 70, "ExampleSection",
 CellID->19359],
Cell[20281, 759, 196, 8, 70, "ExampleText",
 CellID->169625854],
Cell[CellGroupData[{
Cell[20502, 771, 414, 14, 70, "Input",
 CellID->108025290],
Cell[20919, 787, 18325, 304, 70, "Output",
 Evaluatable->False,
 CellID->402269547]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39293, 1097, 233, 7, 70, "ExampleSection",
 CellID->11080],
Cell[39529, 1106, 310, 13, 70, "ExampleText",
 CellID->765776941],
Cell[CellGroupData[{
Cell[39864, 1123, 139, 4, 70, "Input",
 CellID->408300678],
Cell[40006, 1129, 451, 17, 51, "Output",
 CellID->270766476]
}, Open  ]],
Cell[40472, 1149, 56, 1, 70, "ExampleText",
 CellID->383796518],
Cell[CellGroupData[{
Cell[40553, 1154, 104, 3, 70, "Input",
 CellID->37471775],
Cell[40660, 1159, 212, 7, 51, "Output",
 CellID->463974438]
}, Open  ]],
Cell[40887, 1169, 125, 3, 70, "ExampleDelimiter",
 CellID->101319019],
Cell[CellGroupData[{
Cell[41037, 1176, 159, 5, 70, "Input",
 CellID->41484],
Cell[41199, 1183, 388, 14, 51, "Output",
 CellID->387940024]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41648, 1204, 310, 9, 70, "SeeAlsoSection",
 CellID->6702],
Cell[41961, 1215, 1178, 44, 70, "SeeAlso",
 CellID->19895]
}, Open  ]],
Cell[CellGroupData[{
Cell[43176, 1264, 313, 9, 70, "TutorialsSection",
 CellID->7547],
Cell[43492, 1275, 182, 4, 70, "Tutorials",
 CellID->12121]
}, Open  ]],
Cell[CellGroupData[{
Cell[43711, 1284, 321, 9, 70, "RelatedLinksSection",
 CellID->23202],
Cell[44035, 1295, 197, 4, 70, "RelatedLinks"],
Cell[44235, 1301, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44471, 1310, 319, 9, 70, "MoreAboutSection",
 CellID->163922098],
Cell[44793, 1321, 151, 3, 70, "MoreAbout",
 CellID->350240084]
}, Open  ]],
Cell[44959, 1327, 27, 0, 70, "History"],
Cell[44989, 1329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

