(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53499,       1624]
NotebookOptionsPosition[     45531,       1345]
NotebookOutlinePosition[     46990,       1387]
CellTagsIndexPosition[     46904,       1382]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Csch" :> Documentation`HelpLookup["paclet:ref/Csch"], 
          "ArcSech" :> Documentation`HelpLookup["paclet:ref/ArcSech"], 
          "ArcCsc" :> Documentation`HelpLookup["paclet:ref/ArcCsc"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"], 
          "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Csch\"\>", 2->"\<\"ArcSech\"\>", 
       3->"\<\"ArcCsc\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Hyperbolic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcCsch", "ObjectName",
 CellID->29427],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcCsch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcCsch"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse hyperbolic cosecant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["csch", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcCsch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsch"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "i"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "i"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->32371]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103465592],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->241270236],

Cell["Evaluate numerically:", "ExampleText",
 CellID->831168907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", "4.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358897036],

Cell[BoxData["0.22043272097980168`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15599890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86072130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcCsch", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68726696],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmEtonFUUx29mvplJ2qa12tpYmiYqLnQhgqAo1qoxbZOYptNmqFVcxCAk
C22pcaMb3ehGN7qxIHbhA3wsKoaKUEEsiAWxIBZEBWmh1IVFsLgICOPvnPM9
b+73JaUbh8nNffzveZ9z753JmYW5Z56dWZifnRnefXTmyNz87PPDuw4fZare
45xb5O/IgKPfpad/i90u/w9JW5exftzjOtuRNrpyZenXX/60BYHk1hofvH/2
2Ntn4k18ntD/bdpIho1XXj711anf/PX9ute40c4+/SkMXC0ow0RMK1JZ6Cwt
/Tsxdpw2jJ9OZqEq3Vq8/2Bx9bVXv05Wl9No5+QzEb84+bOrB7GiS01Uqz/1
5Efnz/9VTvWAzl6+/E976j3tVqDgF0tYL1jdVt94/fRnJ86tRAM2MCtHqRfq
iIzgatwKVOrnStT83IlzP/2RoMQqhzJ75jg1Sq1eO/7u981yn9QPdj68dOnv
chr7dPbsDxcPP/e5dMO0DPXSi1+e/ub3BJVJO6WrsIGZdFtBGoZ6681vP/n4
x3LU3sTn0CJkXW8FKs2VEtSkzpIpcWT3FaSe9DzQF6TxmOfNJLrCXp1I/AZH
kd63eTiuxnVW8PapBegXo3o84I+V+YzpLIqgTsgD4V174ijz7RNG7+7G+caO
xDOiTzj6RnWWeokqJKjbWPDQo4n/cBKKuuuDNEZ0FnagsLy7IYh6WNrozHcX
8AxYjL0piNupOHiSDy8snKRzYxC3Q3HkDZJDks5AwUP3S9sgjrE1SQw10WBr
kNa96kJEIpqJacoQPkKVbUH0Fm92a2Il8gqJteRv9zCDXavpw978piBF1Xgt
FHEJ8nB4oCGJi/UsSHXXci75sSvltiGWJTln1Kst1MVAeAZLjY68A0NiSHXx
42wwtvNQiY6blctmT5Z+1Qk3oQRcUItw2bnjGL7Bg8ywJMqt8aj6PvB12ubx
Udtpm0Z9P5aEOu6BDcxMQ3hbiDGJ3ylC7rqr5D0YczGeYscafFzLVLRaAgPY
oKurwdG1MCxjnAkCg8daa85E+fM7FEFFxFCBu9020AKKfNFIUtJFpi9fDF1H
ghpd1zK1TUikZYPon+jje3Z7PH9zMJ40PiTTjA9fnOuMu2nIl/Aa7+bzM3x/
u/bZRbW6X7396ufX65XWrxb/f+N3rfT0fljIaekOrTD288Vf16hfpXf1ttAg
VyyerJA4ORf1/IpRPeleiVc7c9I9BKPiIypbGquSE65BPUhnpIaX083LpOdG
I19dJPI1w+pWYWhtHFmR40tNl+ve+iDFu6RZxzLXaa9Y5QsH2a2VRu4s8c4t
QXp3KL18bedaZ5WP23q+BN0S3H+bNGtYtpJmwuRLNpfO2ws2v1VGvcA5Qql6
wK3WGJc7g1w0LpoohUwcdmzg0KYg3R1Ea1VusmxoTI6xcNU9QfRNioY1IEyI
SIa+ryD1QBJduBELQVnedw8EKWq9jZAWO+AOCt+DQZxWxwjbW0XEUg8FcXZf
QmO7xrhHgqiNSs1uapgWUUcKGui6vAGgIjed0SCVDTq2GzlYtyuIWp+gkByO
dqfUF1Po5t3vofco+oCH8m8R63SM8fCISDJWukuGa3WA0sSG2Gh8VTxsV/bi
Wd0uu4FkL7KJVe3qSyQkfNDK3i3pW9uvp/oSIismU/vLYm9ik/jtla3m9xoq
e3uFUa2cp6W7twJFuJMU5aimJ9dUQepmrMu+ir3Zy34qiGp4Ng/TanjShlFR
4gmYSjy2C9LaKvWJSJJuu4JGxqkKRQ2yg6IEZZFCvSLSpbu/AkWgEq5FVPYa
zd6bVTQouXYsxKjkty0/b2tehGiEx7+LZPfp8C4OMQ7RbNdK2WG7sl+BbNd0
ACVDQ9uPbNVo10zHfHADzuikWhfvy9EyvP2+00n1TjO1gLJHYafgD5OQuhVL
OB30R3wjNfY9/wGB/eDJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144941986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148959310],

Cell["Series expansion:", "ExampleText",
 CellID->1386517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCsch", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11297164],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", "4", "]"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "x", "]"}]}]}], ")"}]}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "4"]}], "32"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "6"]}], "96"], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "8"]}], "1024"], "+", 
   FractionBox[
    RowBox[{"63", " ", 
     SuperscriptBox["x", "10"]}], "2560"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 2] (Log[4] - 2 Log[$CellContext`x]), 0, 
    Rational[1, 4], 0, 
    Rational[-3, 32], 0, 
    Rational[5, 96], 0, 
    Rational[-35, 1024], 0, 
    Rational[63, 2560]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36202017]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6153],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->22388353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25384710],

Cell[BoxData[
 RowBox[{"0.46359869504250245`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.2810349015028136`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->981270478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356451170],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->250844503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcCsch", "[", "5", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164550141],

Cell[BoxData["0.\
1986901103492414064746369159502069682213087942244537730388847731551`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1685998433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163775299],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->520491459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", "5.000000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158980370],

Cell[BoxData["0.1986901103492414064746369159502069682213087942245497294763`42.\
7046329292881"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528941266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90833780],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->4148625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsch", "[", "Infinity", "]"}], ",", 
   RowBox[{"ArcCsch", "[", "0", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107134935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "ComplexInfinity"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1481042729]
}, Open  ]],

Cell["Parity transformations are automatically applied:", "ExampleText",
 CellID->394540652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->923368155],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcCsch", "[", "x", "]"}]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402193926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3476149],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"ArcCsc", "[", "x", "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1542277173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277737985],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->568212616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCsch", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241799881],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["csch", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{50, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->924143517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26126],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " to a power series:"
}], "ExampleText",
 CellID->428786469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "6"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212828596],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSinh", "[", "1", "]"}], "-", 
   FractionBox["x", 
    SqrtBox["2"]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"4", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"24", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], 
    RowBox[{"192", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"1920", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    ArcSinh[1], -2^Rational[-1, 2], Rational[1, 4] 2^Rational[-1, 2], 
    Rational[1, 24] 2^Rational[-1, 2], Rational[-5, 192] 2^Rational[-1, 2], 
    Rational[-17, 1920] 2^Rational[-1, 2]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{406, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->924827321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53578059],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->87437617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcCsch", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128882002],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"-", 
      RowBox[{"ArcSinh", "[", 
       FractionBox["1", "2"], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcSinh", "[", 
      FractionBox["1", "2"], "]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{316, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86147061]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1495],

Cell[TextData[{
 "Branch-cut structure of ",
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 " runs along the imaginary axis:"
}], "ExampleText",
 CellID->17768507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcCsch", "[", 
     RowBox[{"x", "-", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341237082],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32885495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29213],

Cell["Compose with the inverse function:", "ExampleText",
 CellID->80512647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsch", "[", 
    RowBox[{"Csch", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Csch", "[", 
    RowBox[{"ArcCsch", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360154656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsch", "[", 
    RowBox[{"Csch", "[", "z", "]"}], "]"}], ",", "z"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1844633518]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcCsch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcCsch"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207373990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1681608934]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcCsch", "[", 
    RowBox[{"Csch", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"z", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->146068558],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1916559218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95023437],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express using logarithm:"
}], "ExampleText",
 CellID->97189382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcCsch", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24723274],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     FractionBox["1", 
      SuperscriptBox["z", "2"]]}]], "+", 
   FractionBox["1", "z"]}], "]"}]], "Output",
 ImageSize->{119, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1503555573]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129068254],

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  FractionBox["1", "z"], "]"}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->818441162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65222460],

Cell["Integrals:", "ExampleText",
 CellID->53641806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "k"}], " ", 
    RowBox[{"ArcCsch", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->613948047],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "k"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "k"}], ")"}], " ", "x", " ", 
      RowBox[{"ArcCsch", "[", "x", "]"}]}], "+", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", "k"}], "2"], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox[
          RowBox[{"3", "+", "k"}], "2"], ",", 
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}]}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox["1", 
         SuperscriptBox["x", "2"]]}]]]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "k"}], ")"}], "2"]]], "Output",
 ImageSize->{389, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->907850699]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9934],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Csch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSech"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCsc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23327],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->17073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23461],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseHyperbolicCosecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcCsch/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->417242061],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->66532722]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcCsch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 34.8151512}", "context" -> "System`", 
    "keywords" -> {
     "acsch", "arcosech", "arcsch", "area cosinus hyperbolicus", 
      "hyperbolic arccosecant", "inverse csch", 
      "inverse hyperbolic cosecant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcCsch[z] gives the inverse hyperbolic cosecant csch -1 (z) of the \
complex number z. ", 
    "synonyms" -> {
     "acsch", "arc csch", "arccosecanth", "arccsch", "areacosh", "areacsch", 
      "invcsch"}, "title" -> "ArcCsch", "type" -> "Symbol", "uri" -> 
    "ref/ArcCsch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5491, 189, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->103465592]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46761, 1375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2183, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2806, 80, 45, 1, 70, "ObjectName",
 CellID->29427],
Cell[2854, 83, 763, 25, 70, "Usage",
 CellID->10313]
}, Open  ]],
Cell[CellGroupData[{
Cell[3654, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4132, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4255, 136, 241, 8, 70, "Notes",
 CellID->9487],
Cell[4499, 146, 216, 7, 70, "Notes",
 CellID->31226],
Cell[4718, 155, 199, 7, 70, "Notes",
 CellID->28162],
Cell[4920, 164, 534, 20, 70, "Notes",
 CellID->32371]
}, Closed]],
Cell[CellGroupData[{
Cell[5491, 189, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->103465592],
Cell[CellGroupData[{
Cell[5876, 203, 148, 5, 70, "ExampleSection",
 CellID->241270236],
Cell[6027, 210, 64, 1, 70, "ExampleText",
 CellID->831168907],
Cell[CellGroupData[{
Cell[6116, 215, 105, 3, 28, "Input",
 CellID->358897036],
Cell[6224, 220, 176, 5, 36, "Output",
 CellID->15599890]
}, Open  ]],
Cell[6415, 228, 124, 3, 70, "ExampleDelimiter",
 CellID->86072130],
Cell[CellGroupData[{
Cell[6564, 235, 237, 8, 28, "Input",
 CellID->68726696],
Cell[6804, 245, 2185, 40, 133, "Output",
 Evaluatable->False,
 CellID->144941986]
}, Open  ]],
Cell[9004, 288, 125, 3, 70, "ExampleDelimiter",
 CellID->148959310],
Cell[9132, 293, 58, 1, 70, "ExampleText",
 CellID->1386517],
Cell[CellGroupData[{
Cell[9215, 298, 294, 9, 70, "Input",
 CellID->11297164],
Cell[9512, 309, 1201, 41, 54, "Output",
 CellID->36202017]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10762, 356, 215, 7, 70, "ExampleSection",
 CellID->6153],
Cell[10980, 365, 73, 1, 70, "ExampleText",
 CellID->22388353],
Cell[CellGroupData[{
Cell[11078, 370, 127, 4, 70, "Input",
 CellID->25384710],
Cell[11208, 376, 274, 7, 36, "Output",
 CellID->981270478]
}, Open  ]],
Cell[11497, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->356451170],
Cell[11625, 391, 70, 1, 70, "ExampleText",
 CellID->250844503],
Cell[CellGroupData[{
Cell[11720, 396, 156, 5, 70, "Input",
 CellID->164550141],
Cell[11879, 403, 236, 7, 36, "Output",
 CellID->1685998433]
}, Open  ]],
Cell[12130, 413, 125, 3, 70, "ExampleDelimiter",
 CellID->163775299],
Cell[12258, 418, 113, 3, 70, "ExampleText",
 CellID->520491459],
Cell[CellGroupData[{
Cell[12396, 425, 149, 4, 70, "Input",
 CellID->158980370],
Cell[12548, 431, 237, 6, 36, "Output",
 CellID->528941266]
}, Open  ]],
Cell[12800, 440, 124, 3, 70, "ExampleDelimiter",
 CellID->90833780],
Cell[12927, 445, 90, 1, 70, "ExampleText",
 CellID->4148625],
Cell[CellGroupData[{
Cell[13042, 450, 192, 6, 70, "Input",
 CellID->107134935],
Cell[13237, 458, 219, 7, 36, "Output",
 CellID->1481042729]
}, Open  ]],
Cell[13471, 468, 92, 1, 70, "ExampleText",
 CellID->394540652],
Cell[CellGroupData[{
Cell[13588, 473, 121, 4, 70, "Input",
 CellID->923368155],
Cell[13712, 479, 209, 7, 36, "Output",
 CellID->402193926]
}, Open  ]],
Cell[CellGroupData[{
Cell[13958, 491, 124, 4, 70, "Input",
 CellID->3476149],
Cell[14085, 497, 244, 8, 36, "Output",
 CellID->1542277173]
}, Open  ]],
Cell[14344, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->277737985],
Cell[14472, 513, 203, 7, 70, "ExampleText",
 CellID->568212616],
Cell[CellGroupData[{
Cell[14700, 524, 141, 4, 70, "Input",
 CellID->241799881],
Cell[14844, 530, 279, 9, 52, "Output",
 CellID->924143517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15172, 545, 239, 7, 70, "ExampleSection",
 CellID->26126],
Cell[15414, 554, 205, 8, 70, "ExampleText",
 CellID->428786469],
Cell[CellGroupData[{
Cell[15644, 566, 211, 7, 70, "Input",
 CellID->212828596],
Cell[15858, 575, 1139, 38, 58, "Output",
 CellID->924827321]
}, Open  ]],
Cell[17012, 616, 124, 3, 70, "ExampleDelimiter",
 CellID->53578059],
Cell[17139, 621, 211, 7, 70, "ExampleText",
 CellID->87437617],
Cell[CellGroupData[{
Cell[17375, 632, 208, 7, 70, "Input",
 CellID->128882002],
Cell[17586, 641, 504, 18, 51, "Output",
 CellID->86147061]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18139, 665, 222, 7, 70, "ExampleSection",
 CellID->1495],
Cell[18364, 674, 234, 8, 70, "ExampleText",
 CellID->17768507],
Cell[CellGroupData[{
Cell[18623, 686, 414, 14, 70, "Input",
 CellID->341237082],
Cell[19040, 702, 18272, 304, 70, "Output",
 Evaluatable->False,
 CellID->32885495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37361, 1012, 233, 7, 70, "ExampleSection",
 CellID->29213],
Cell[37597, 1021, 76, 1, 70, "ExampleText",
 CellID->80512647],
Cell[CellGroupData[{
Cell[37698, 1026, 251, 8, 70, "Input",
 CellID->360154656],
Cell[37952, 1036, 273, 9, 36, "Output",
 CellID->1844633518]
}, Open  ]],
Cell[38240, 1048, 352, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[38617, 1065, 107, 3, 70, "Input",
 CellID->207373990],
Cell[38727, 1070, 204, 7, 36, "Output",
 CellID->1681608934]
}, Open  ]],
Cell[38946, 1080, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[39067, 1085, 230, 7, 70, "Input",
 CellID->146068558],
Cell[39300, 1094, 159, 5, 36, "Output",
 CellID->1916559218]
}, Open  ]],
Cell[39474, 1102, 124, 3, 70, "ExampleDelimiter",
 CellID->95023437],
Cell[39601, 1107, 215, 8, 70, "ExampleText",
 CellID->97189382],
Cell[CellGroupData[{
Cell[39841, 1119, 134, 4, 70, "Input",
 CellID->24723274],
Cell[39978, 1125, 324, 12, 60, "Output",
 CellID->1503555573]
}, Open  ]],
Cell[CellGroupData[{
Cell[40339, 1142, 105, 3, 70, "Input",
 CellID->129068254],
Cell[40447, 1147, 212, 7, 51, "Output",
 CellID->818441162]
}, Open  ]],
Cell[40674, 1157, 124, 3, 70, "ExampleDelimiter",
 CellID->65222460],
Cell[40801, 1162, 52, 1, 70, "ExampleText",
 CellID->53641806],
Cell[CellGroupData[{
Cell[40878, 1167, 213, 7, 70, "Input",
 CellID->613948047],
Cell[41094, 1176, 1009, 35, 98, "Output",
 CellID->907850699]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42164, 1218, 310, 9, 70, "SeeAlsoSection",
 CellID->9934],
Cell[42477, 1229, 1178, 44, 70, "SeeAlso",
 CellID->21726]
}, Open  ]],
Cell[CellGroupData[{
Cell[43692, 1278, 314, 9, 70, "TutorialsSection",
 CellID->23327],
Cell[44009, 1289, 182, 4, 70, "Tutorials",
 CellID->17073]
}, Open  ]],
Cell[CellGroupData[{
Cell[44228, 1298, 321, 9, 70, "RelatedLinksSection",
 CellID->23461],
Cell[44552, 1309, 196, 4, 70, "RelatedLinks"],
Cell[44751, 1315, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44987, 1324, 319, 9, 70, "MoreAboutSection",
 CellID->417242061],
Cell[45309, 1335, 150, 3, 70, "MoreAbout",
 CellID->66532722]
}, Open  ]],
Cell[45474, 1341, 27, 0, 70, "History"],
Cell[45504, 1343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

