(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68785,       2218]
NotebookOptionsPosition[     58798,       1865]
NotebookOutlinePosition[     60128,       1903]
CellTagsIndexPosition[     60042,       1898]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sec" :> Documentation`HelpLookup["paclet:ref/Sec"], "ArcCsc" :> 
          Documentation`HelpLookup["paclet:ref/ArcCsc"], "ArcSech" :> 
          Documentation`HelpLookup["paclet:ref/ArcSech"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sec\"\>", 2->"\<\"ArcCsc\"\>", 
       3->"\<\"ArcSech\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcSec", "ObjectName",
 CellID->20189],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcSec",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcSec"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc secant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sec", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians. ", "Notes",
 CellID->30301],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " outside the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ", excluding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21702],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcSec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSec"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24844]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148776053],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->14219592],

Cell["Result in radians:", "ExampleText",
 CellID->20915706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4966458],

Cell[BoxData[
 FractionBox["\[Pi]", "3"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14820590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410560537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18975022],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568855898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14582757],

Cell["Series expansion:", "ExampleText",
 CellID->244210650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297909320],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    SqrtBox["2"], " ", 
    SqrtBox[
     RowBox[{"x", "-", "1"}]]}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"6", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"43", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}], 
    RowBox[{"80", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    RowBox[{"177", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"7", "/", "2"}]]}], 
    RowBox[{"448", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], 
     RowBox[{"9", "/", "2"}]],
    SeriesData[$CellContext`x, 1, {}, 1, 9, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   2^Rational[1, 2], 0, Rational[-5, 6] 2^Rational[-1, 2], 0, 
    Rational[43, 80] 2^Rational[-1, 2], 0, Rational[-177, 448] 
    2^Rational[-1, 2]}, 1, 9, 2],
  Editable->False]], "Output",
 ImageSize->{420, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1889121377]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17623],

Cell["Evaluate numerically:", "ExampleText",
 CellID->167291019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "3.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5074726],

Cell[BoxData["1.2810446253588492`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2064745991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260293824],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->5459904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", 
  RowBox[{"0.5", "+", 
   RowBox[{"2.3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2611997],

Cell[BoxData[
 RowBox[{"1.4873878043064916`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4054135307241785`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->997618864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3922382],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->878622293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "5", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328809851],

Cell[BoxData["1.\
3694384060045658277761961394221280318585466182853245242302211737145`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1575415119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8135257],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->437032725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "5.00000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->818603725],

Cell[BoxData["1.3694384060045658277761961394221280318585466182853245242353`42.\
52561812871578"], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1676021170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->521595534],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->542428298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", 
  FractionBox[
   RowBox[{"2", 
    SqrtBox["3"]}], "3"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39026668],

Cell[BoxData[
 FractionBox["\[Pi]", "6"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344806491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6068268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->26329708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSec", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12156846],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sec", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1251814631]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14899],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->23855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27804],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["\[Pi]", "3"], ",", 
    RowBox[{"ArcCos", "[", 
     FractionBox["1", "3"], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{179, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351213558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16909],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->19381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12779],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1561207350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", 
  RowBox[{"x", "+", 
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{
    RowBox[{"O", "[", 
     RowBox[{"x", ",", "Infinity"}], "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10532],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "3"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "4"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "5"], "-", 
   RowBox[{
    FractionBox["7", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "6"]}], "+", 
   RowBox[{
    FractionBox["3", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "8"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[1], {Rational[1, 2] Pi, 0, -1, 1, -1, 1, 
    Rational[-7, 6], 
    Rational[3, 2]}, 0, 8, 1],
  Editable->False]], "Output",
 ImageSize->{355, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1256732404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27842],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->8724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31149],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"Floor", "[", 
        FractionBox[
         RowBox[{"\[Pi]", "-", 
          RowBox[{"Arg", "[", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], "]"}], "-", 
          RowBox[{"Arg", "[", 
           FractionBox["1", "x"], "]"}]}], 
         RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", "-", "1"}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", 
            RowBox[{"x", "-", "1"}], "]"}], 
           RowBox[{"3", "/", "2"}]],
          SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
          Editable->False]}],
        SeriesData[$CellContext`x, 1, {2 2^Rational[1, 2]}, 1, 3, 2],
        Editable->False], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{420, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1399845783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13590],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "-", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"Arg", "[", 
      RowBox[{"2", "+", 
       FractionBox["1", "x"]}], "]"}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Floor", "[", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{"2", "+", 
        FractionBox["1", "x"]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "-", 
        RowBox[{"ArcSec", "[", 
         FractionBox["1", "2"], "]"}]}], ")"}], "+", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", 
           FractionBox["1", "2"]}], ")"}]}], 
        SqrtBox["3"]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"x", "+", 
          FractionBox["1", "2"]}], "]"}], "2"],
       SeriesData[$CellContext`x, 
        Rational[-1, 2], {}, 0, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      Rational[-1, 2], {Rational[1, 2] Pi - ArcSec[
        Rational[1, 2]], Complex[0, -4] 3^Rational[-1, 2]}, 0, 2, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{563, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1524721996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26099],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays:"
}], "ExampleText",
 CellID->6161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "3"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "1"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11047],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80227121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15290],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1904975978]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29959],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      RowBox[{"ArcSec", "[", "3", "]"}]},
     {"0", "0", "0"},
     {"0", "0", 
      FractionBox[
       RowBox[{"2", " ", "\[Pi]"}], "3"]},
     {"0", "\[Pi]", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{118, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->97569123]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10415],

Cell[TextData[{
 "Branch cut of ",
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 " runs along the real axis:"
}], "ExampleText",
 CellID->81690184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSec", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491732723],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313644853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3644],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->109338042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"Sec", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Sec", "[", 
    RowBox[{"ArcSec", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397577163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"Sec", "[", "z", "]"}], "]"}], ",", "z"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1353963805]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1332947023]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcSec", "[", 
    RowBox[{"Sec", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404146284],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->291210057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268743644],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express through logarithm:"
}], "ExampleText",
 CellID->147381088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSec", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20026373],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["z", "2"]]}]], "+", 
     FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]], "Output",
 ImageSize->{156, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252196486]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " to convert back:"
}], "ExampleText",
 CellID->415210615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300744173],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "-", 
  RowBox[{"ArcSin", "[", 
   FractionBox["1", "z"], "]"}]}]], "Output",
 ImageSize->{96, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1681104671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37957409],

Cell["Integrals:", "ExampleText",
 CellID->41963669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "k"}], " ", 
    RowBox[{"ArcSec", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165822859],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", "k"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "k"}], ")"}], " ", "z", " ", 
      RowBox[{"ArcSec", "[", "z", "]"}]}], "-", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["z", "2"]}]], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", "k"}], "2"], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox[
          RowBox[{"3", "+", "k"}], "2"], ",", 
         SuperscriptBox["z", "2"]}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        FractionBox["1", 
         SuperscriptBox["z", "2"]]}]]]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "k"}], ")"}], "2"]]], "Output",
 ImageSize->{377, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2031345565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299368825],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to convert trigs of arctrigs into algebraic function:"
}], "ExampleText",
 CellID->693964864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"5", 
    RowBox[{"ArcSec", "[", "z", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79294649],

Cell[BoxData[
 FractionBox[
  RowBox[{
   FractionBox[
    RowBox[{"5", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "z"}], ")"}]}]]}], 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
     SqrtBox[
      RowBox[{"\[ImaginaryI]", " ", "z"}]], " ", 
     SuperscriptBox["z", "4"]}]], "-", 
   FractionBox[
    RowBox[{"10", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "z"}], ")"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", "z"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SuperscriptBox["z", "2"]}]], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "z"}], ")"}]}], ")"}], 
     RowBox[{"5", "/", "2"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], ")"}], 
      RowBox[{"5", "/", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", "z"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}]]}], 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["z", "5"]], "-", 
   FractionBox[
    RowBox[{"10", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["1", 
        SuperscriptBox["z", "2"]]}], ")"}]}], 
    SuperscriptBox["z", "3"]], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}], "2"]}], 
    SuperscriptBox["z", "5"]]}]]], "Output",
 ImageSize->{303, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129890949]
}, Open  ]],

Cell["Simplify result:", "ExampleText",
 CellID->559293108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50403847],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     FractionBox["1", 
      SuperscriptBox["z", "2"]]}]], " ", "z", " ", 
   RowBox[{"(", 
    RowBox[{"16", "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     SuperscriptBox["z", "4"]}], ")"}]}], 
  RowBox[{"16", "-", 
   RowBox[{"20", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["z", "4"]}]}]]], "Output",
 ImageSize->{171, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1233794491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->823034384],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve equations involving ",
 Cell[BoxData[
  ButtonBox["ArcSec",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSec"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29135040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcSec", "[", "z", "]"}], "+", 
      RowBox[{"ArcSec", "[", 
       RowBox[{"z", "+", "1"}], "]"}]}], "\[Equal]", 
     RowBox[{"Pi", "/", "2"}]}], ",", "z"}], "]"}], "//", "Quiet"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->53629881],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox[
      RowBox[{"5", "+", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]}]]}], ")"}]}]}]], "Output",
 ImageSize->{156, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281914805]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6637],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCsc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSech"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20523],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->26539]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20609],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseSecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcSec/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->462396949],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->384222755]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcSec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 37.2214628}", "context" -> "System`", 
    "keywords" -> {"arcsecant", "arcus secans", "asec", "inverse secant"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArcSec[z] gives the arc secant sec -1 (z) of the complex number z. ", 
    "synonyms" -> {
     "arc sec", "arcsec", "arcsecans", "arcsecant", "asec", "asecans", 
      "invsec"}, "title" -> "ArcSec", "type" -> "Symbol", "uri" -> 
    "ref/ArcSec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6225, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->148776053]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 59899, 1891}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2269, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2892, 80, 44, 1, 70, "ObjectName",
 CellID->20189],
Cell[2939, 83, 743, 25, 70, "Usage",
 CellID->29372]
}, Open  ]],
Cell[CellGroupData[{
Cell[3719, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4197, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4320, 136, 67, 1, 70, "Notes",
 CellID->30301],
Cell[4390, 139, 604, 23, 70, "Notes",
 CellID->21702],
Cell[4997, 164, 239, 8, 70, "Notes",
 CellID->9487],
Cell[5239, 174, 214, 7, 70, "Notes",
 CellID->31226],
Cell[5456, 183, 197, 7, 70, "Notes",
 CellID->28162],
Cell[5656, 192, 532, 20, 70, "Notes",
 CellID->24844]
}, Closed]],
Cell[CellGroupData[{
Cell[6225, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148776053],
Cell[CellGroupData[{
Cell[6610, 231, 147, 5, 70, "ExampleSection",
 CellID->14219592],
Cell[6760, 238, 60, 1, 70, "ExampleText",
 CellID->20915706],
Cell[CellGroupData[{
Cell[6845, 243, 100, 3, 28, "Input",
 CellID->4966458],
Cell[6948, 248, 181, 6, 49, "Output",
 CellID->14820590]
}, Open  ]],
Cell[7144, 257, 125, 3, 70, "ExampleDelimiter",
 CellID->410560537],
Cell[CellGroupData[{
Cell[7294, 264, 236, 8, 28, "Input",
 CellID->18975022],
Cell[7533, 274, 2254, 41, 145, "Output",
 Evaluatable->False,
 CellID->568855898]
}, Open  ]],
Cell[9802, 318, 124, 3, 70, "ExampleDelimiter",
 CellID->14582757],
Cell[9929, 323, 60, 1, 70, "ExampleText",
 CellID->244210650],
Cell[CellGroupData[{
Cell[10014, 328, 293, 9, 70, "Input",
 CellID->297909320],
Cell[10310, 339, 1322, 47, 58, "Output",
 CellID->1889121377]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11681, 392, 216, 7, 70, "ExampleSection",
 CellID->17623],
Cell[11900, 401, 64, 1, 70, "ExampleText",
 CellID->167291019],
Cell[CellGroupData[{
Cell[11989, 406, 102, 3, 70, "Input",
 CellID->5074726],
Cell[12094, 411, 177, 5, 36, "Output",
 CellID->2064745991]
}, Open  ]],
Cell[12286, 419, 125, 3, 70, "ExampleDelimiter",
 CellID->260293824],
Cell[12414, 424, 72, 1, 70, "ExampleText",
 CellID->5459904],
Cell[CellGroupData[{
Cell[12511, 429, 146, 5, 70, "Input",
 CellID->2611997],
Cell[12660, 436, 273, 7, 36, "Output",
 CellID->997618864]
}, Open  ]],
Cell[12948, 446, 123, 3, 70, "ExampleDelimiter",
 CellID->3922382],
Cell[13074, 451, 70, 1, 70, "ExampleText",
 CellID->878622293],
Cell[CellGroupData[{
Cell[13169, 456, 155, 5, 70, "Input",
 CellID->328809851],
Cell[13327, 463, 236, 7, 36, "Output",
 CellID->1575415119]
}, Open  ]],
Cell[13578, 473, 123, 3, 70, "ExampleDelimiter",
 CellID->8135257],
Cell[13704, 478, 113, 3, 70, "ExampleText",
 CellID->437032725],
Cell[CellGroupData[{
Cell[13842, 485, 147, 4, 70, "Input",
 CellID->818603725],
Cell[13992, 491, 239, 6, 36, "Output",
 CellID->1676021170]
}, Open  ]],
Cell[14246, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->521595534],
Cell[14374, 505, 91, 1, 70, "ExampleText",
 CellID->542428298],
Cell[CellGroupData[{
Cell[14490, 510, 155, 6, 70, "Input",
 CellID->39026668],
Cell[14648, 518, 182, 6, 49, "Output",
 CellID->344806491]
}, Open  ]],
Cell[14845, 527, 123, 3, 70, "ExampleDelimiter",
 CellID->6068268],
Cell[14971, 532, 202, 7, 70, "ExampleText",
 CellID->26329708],
Cell[CellGroupData[{
Cell[15198, 543, 139, 4, 70, "Input",
 CellID->12156846],
Cell[15340, 549, 279, 9, 52, "Output",
 CellID->1251814631]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15668, 564, 239, 7, 70, "ExampleSection",
 CellID->14899],
Cell[15910, 573, 214, 7, 70, "ExampleText",
 CellID->23855],
Cell[CellGroupData[{
Cell[16149, 584, 182, 6, 70, "Input",
 CellID->27804],
Cell[16334, 592, 326, 11, 51, "Output",
 CellID->351213558]
}, Open  ]],
Cell[16675, 606, 121, 3, 70, "ExampleDelimiter",
 CellID->16909],
Cell[16799, 611, 80, 1, 70, "ExampleText",
 CellID->19381],
Cell[CellGroupData[{
Cell[16904, 616, 112, 3, 70, "Input",
 CellID->12779],
Cell[17019, 621, 183, 6, 49, "Output",
 CellID->1561207350]
}, Open  ]],
Cell[17217, 630, 121, 3, 70, "ExampleDelimiter",
 CellID->10083],
Cell[17341, 635, 199, 7, 70, "ExampleText",
 CellID->692],
Cell[CellGroupData[{
Cell[17565, 646, 242, 8, 70, "Input",
 CellID->10532],
Cell[17810, 656, 1196, 42, 52, "Output",
 CellID->1256732404]
}, Open  ]],
Cell[19021, 701, 121, 3, 70, "ExampleDelimiter",
 CellID->27842],
Cell[19145, 706, 94, 1, 70, "ExampleText",
 CellID->8724],
Cell[CellGroupData[{
Cell[19264, 711, 214, 7, 70, "Input",
 CellID->31149],
Cell[19481, 720, 1274, 41, 72, "Output",
 CellID->1399845783]
}, Open  ]],
Cell[CellGroupData[{
Cell[20792, 766, 262, 9, 70, "Input",
 CellID->13590],
Cell[21057, 777, 1556, 51, 68, "Output",
 CellID->1524721996]
}, Open  ]],
Cell[22628, 831, 121, 3, 70, "ExampleDelimiter",
 CellID->26099],
Cell[22752, 836, 227, 7, 70, "ExampleText",
 CellID->6161],
Cell[CellGroupData[{
Cell[23004, 847, 645, 23, 70, "Input",
 CellID->11047],
Cell[23652, 872, 488, 17, 36, "Output",
 CellID->80227121]
}, Open  ]],
Cell[CellGroupData[{
Cell[24177, 894, 98, 3, 70, "Input",
 CellID->15290],
Cell[24278, 899, 480, 17, 36, "Output",
 CellID->1904975978]
}, Open  ]],
Cell[CellGroupData[{
Cell[24795, 921, 131, 4, 70, "Input",
 CellID->29959],
Cell[24929, 927, 877, 27, 102, "Output",
 CellID->97569123]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25855, 960, 223, 7, 70, "ExampleSection",
 CellID->10415],
Cell[26081, 969, 217, 8, 70, "ExampleText",
 CellID->81690184],
Cell[CellGroupData[{
Cell[26323, 981, 413, 14, 70, "Input",
 CellID->491732723],
Cell[26739, 997, 18273, 304, 70, "Output",
 Evaluatable->False,
 CellID->313644853]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45061, 1307, 232, 7, 70, "ExampleSection",
 CellID->3644],
Cell[45296, 1316, 74, 1, 70, "ExampleText",
 CellID->109338042],
Cell[CellGroupData[{
Cell[45395, 1321, 247, 8, 70, "Input",
 CellID->397577163],
Cell[45645, 1331, 271, 9, 36, "Output",
 CellID->1353963805]
}, Open  ]],
Cell[45931, 1343, 350, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[46306, 1360, 102, 3, 70, "Input",
 CellID->1064],
Cell[46411, 1365, 204, 7, 36, "Output",
 CellID->1332947023]
}, Open  ]],
Cell[46630, 1375, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[46751, 1380, 251, 8, 70, "Input",
 CellID->404146284],
Cell[47005, 1390, 158, 5, 36, "Output",
 CellID->291210057]
}, Open  ]],
Cell[47178, 1398, 125, 3, 70, "ExampleDelimiter",
 CellID->268743644],
Cell[47306, 1403, 218, 8, 70, "ExampleText",
 CellID->147381088],
Cell[CellGroupData[{
Cell[47549, 1415, 133, 4, 70, "Input",
 CellID->20026373],
Cell[47685, 1421, 431, 15, 60, "Output",
 CellID->252196486]
}, Open  ]],
Cell[48131, 1439, 205, 8, 70, "ExampleText",
 CellID->415210615],
Cell[CellGroupData[{
Cell[48361, 1451, 105, 3, 70, "Input",
 CellID->300744173],
Cell[48469, 1456, 261, 9, 51, "Output",
 CellID->1681104671]
}, Open  ]],
Cell[48745, 1468, 124, 3, 70, "ExampleDelimiter",
 CellID->37957409],
Cell[48872, 1473, 52, 1, 70, "ExampleText",
 CellID->41963669],
Cell[CellGroupData[{
Cell[48949, 1478, 212, 7, 70, "Input",
 CellID->165822859],
Cell[49164, 1487, 983, 34, 98, "Output",
 CellID->2031345565]
}, Open  ]],
Cell[50162, 1524, 125, 3, 70, "ExampleDelimiter",
 CellID->299368825],
Cell[50290, 1529, 252, 8, 70, "ExampleText",
 CellID->693964864],
Cell[CellGroupData[{
Cell[50567, 1541, 193, 6, 70, "Input",
 CellID->79294649],
Cell[50763, 1549, 2354, 85, 99, "Output",
 CellID->129890949]
}, Open  ]],
Cell[53132, 1637, 59, 1, 70, "ExampleText",
 CellID->559293108],
Cell[CellGroupData[{
Cell[53216, 1642, 103, 3, 70, "Input",
 CellID->50403847],
Cell[53322, 1647, 580, 21, 78, "Output",
 CellID->1233794491]
}, Open  ]],
Cell[53917, 1671, 125, 3, 70, "ExampleDelimiter",
 CellID->823034384],
Cell[54045, 1676, 332, 13, 70, "ExampleText",
 CellID->29135040],
Cell[CellGroupData[{
Cell[54402, 1693, 342, 12, 70, "Input",
 CellID->53629881],
Cell[54747, 1707, 391, 15, 53, "Output",
 CellID->281914805]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55199, 1729, 310, 9, 70, "SeeAlsoSection",
 CellID->6637],
Cell[55512, 1740, 1416, 53, 70, "SeeAlso",
 CellID->1869]
}, Open  ]],
Cell[CellGroupData[{
Cell[56965, 1798, 314, 9, 70, "TutorialsSection",
 CellID->20523],
Cell[57282, 1809, 182, 4, 70, "Tutorials",
 CellID->26539]
}, Open  ]],
Cell[CellGroupData[{
Cell[57501, 1818, 321, 9, 70, "RelatedLinksSection",
 CellID->20609],
Cell[57825, 1829, 184, 4, 70, "RelatedLinks"],
Cell[58012, 1835, 198, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58247, 1844, 319, 9, 70, "MoreAboutSection",
 CellID->462396949],
Cell[58569, 1855, 157, 3, 70, "MoreAbout",
 CellID->384222755]
}, Open  ]],
Cell[58741, 1861, 27, 0, 70, "History"],
Cell[58771, 1863, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

