(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54469,       1632]
NotebookOptionsPosition[     46774,       1363]
NotebookOutlinePosition[     48161,       1403]
CellTagsIndexPosition[     48075,       1398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sech" :> Documentation`HelpLookup["paclet:ref/Sech"], 
          "ArcCsch" :> Documentation`HelpLookup["paclet:ref/ArcCsch"], 
          "ArcSec" :> Documentation`HelpLookup["paclet:ref/ArcSec"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"], 
          "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sech\"\>", 2->"\<\"ArcCsch\"\>", 
       3->"\<\"ArcSec\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Hyperbolic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcSech", "ObjectName",
 CellID->26467],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcSech",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcSech"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse hyperbolic secant ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sech", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcSech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSech"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21074]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->468309473],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->4220433],

Cell["Evaluate numerically:", "ExampleText",
 CellID->354428757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102103141],

Cell[BoxData["1.3169578969248166`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1367207019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401874856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcSech", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16186437],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96668501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131402818],

Cell["Series expansions:", "ExampleText",
 CellID->973969209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSech", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"z", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143372757],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", 
    SqrtBox[
     RowBox[{"z", "-", "1"}]]}], "+", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"5", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], 
       RowBox[{"3", "/", "2"}]]}], 
     RowBox[{"6", " ", 
      SqrtBox["2"]}]]}], "+", 
   FractionBox[
    RowBox[{"43", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"5", "/", "2"}]]}], 
    RowBox[{"80", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], 
     RowBox[{"7", "/", "2"}]],
    SeriesData[$CellContext`z, 1, {}, 1, 7, 2],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {
   Complex[0, 1] 2^Rational[1, 2], 0, Complex[0, 
      Rational[-5, 6]] 2^Rational[-1, 2], 0, Complex[0, 
      Rational[43, 80]] 2^Rational[-1, 2]}, 1, 7, 2],
  Editable->False]], "Output",
 ImageSize->{364, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->457568342]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSech", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19251749],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "z", "]"}]}], ")"}], "-", 
   FractionBox[
    SuperscriptBox["z", "2"], "4"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["z", "4"]}], "32"], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["z", "6"]}], "96"], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["z", "8"]}], "1024"], "-", 
   FractionBox[
    RowBox[{"63", " ", 
     SuperscriptBox["z", "10"]}], "2560"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "11"],
    SeriesData[$CellContext`z, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {Log[2] - Log[$CellContext`z], 0, 
    Rational[-1, 4], 0, 
    Rational[-3, 32], 0, 
    Rational[-5, 96], 0, 
    Rational[-35, 1024], 0, 
    Rational[-63, 2560]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{371, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->212184087]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26255],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->70817306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", 
  RowBox[{"1.5", "-", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251401134],

Cell[BoxData[
 RowBox[{"0.33568954725152905`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.118867914718337`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1355096189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255711112],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->147880070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcSech", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199240040],

Cell[BoxData["1.\
762747174039086050465218649959584618056320656523271309836035899482`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1037572088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376756117],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->451779059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", "0.33333333333333333333333333333333333333333", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->613584605],

Cell[BoxData["1.7627471740390860504652186499595846180563313500750283900377`40.\
743492511163936"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->906869376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164751678],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->262234383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126904788],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1062159673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100018944],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->524947429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSech", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321973988],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sech", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{50, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1833550247]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13163],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 " to a power series:"
}], "ExampleText",
 CellID->47204056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", "2"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->699535003],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcCosh", "[", "2", "]"}], "-", 
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    SqrtBox["3"]], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"3", " ", 
     SqrtBox["3"]}]], "-", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "4"]}], 
    RowBox[{"108", " ", 
     SqrtBox["3"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    ArcCosh[2], (-2) 3^Rational[-1, 2], Rational[-1, 3] 3^Rational[-1, 2], 
    Rational[-1, 3] 3^Rational[-1, 2], Rational[-35, 108] 3^Rational[-1, 2]}, 
   0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{327, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88666879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186464750],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->207227519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSech", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->635343390],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ArcCosh", "[", "2", "]"}], ",", 
    RowBox[{"ArcCosh", "[", "3", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2018067982]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5792],

Cell["Branch-cut line runs along the real axis:", "ExampleText",
 CellID->164562840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSech", "[", 
     RowBox[{"x", "-", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75796208],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydfQeYZFd1ZvGqunuSRtIIgQzyIowNBoxx2OS1jXexF4f9BCbYxovByEgs
WiTLgOKgMJqcemY659zVVd3Vobo655xDdc5x8oxGAQWQRvq/3XPOvfdVdXWN
YHe+O6+qXr16757/hHvuveecvv+Bx3/w0KMPPP7w9x647y9//MC//eDh7/3k
vi899mM65fyAw+Gopf/p9zjo/f+hd/K/FgB9se34JB1ddMF/kU9P8dFJH+WT
Oft02Fl++0dy9pmIs//5fc7yUxyu0FmHY49+7mfs51r0aW/E89W3L+prnRH3
/rR8eyLi7G/L2Wf1HXdH/ZZ7ySfllg899BC/jdvWR/X0f9TXflTf0Yroo6V/
y6+flXP/M+KZH9Z3iDFPoCeqH//7qNffre+mCFYPipXfqh+qs38Y9bf79LN2
/4rX36Gvv03Oh67n5/9B1F/cpn9xJ3+IsX+h0fh9GzNL35VfP/g+1z6k7/eh
yB5EPPd35erv6Tv+WpSr+fzn5arvhvNXI3hPxC8ipelzcum39S//XcTVroir
f0eu/oJ+qpGN8OdF3iEm4g5KVv4UkVJnpCXyiff+f97vbn2/j0NpUfg9YiPu
8Zlb3GNf2D0E15iiCRRN6sYKtDPiTp++xZ3uCLuTIOYqpDuZ5qS7hfcvLuKu
O/Wvf/0Wd78NkbTad3dY4ffXPNoR5f7bMLe5vEe/GhS463J1tCcUT8K2KmHW
wonotkw96a/1ne/Tr1ZBEDHyFL6/PEieYvFTXMWTxnY5tvU8kjJ1/y9FoM/3
FwTplVphEK4oT3O4ihQxYrkspizszpE8ivysnvwX2G49zbdKU/OlC9wh6RWf
LJQuCc6qH7pT8k/64VJIK7B36mdEp/0TCNnxcIyd+eMIf7oz4uksQoSAeSw/
mTnAj4yxn665HYvoltsyFsXxmxF9u+cWuJheOvOodzH0hnqpGyNi+Kb6SM2p
+2XksZjfhvXRLS2apEiPRKOiyaWxHh8zEpk7RiTljYH6pRrDZ1AsGA/noTNC
A52mf9Q57pqNoTu8f7sievCJqLjdpXG7z0Y8Z4x/zt3jPjqpixZj5wrHzipg
NLl/8q9QvbFY7oWn1L9Y7p/hqeqbur97ynDUjPa/FbVnd0QgJh1z5m7rnbBW
geewuG9iVxWCWvQi+xajxEwdWfWdjBn3rGQqKm9/I2oP90aRUqOHzuxROHNG
Id1WnZbOuxhP01NGMdbupuppEfGb7R/1U40QbgMfN+qexX18Hwv1cVtLjedg
xmGRuyzuE3WO3vPRooOL+xljI0tNYOWnc3cVtnRksXQVao2hfuqxhq+LKzZy
Z3e3hM1KRF8jbZrq6+ex3cv4qH0ucwRZ0hxO6bvqeLYmgzF26Y6S8ozprjoi
+6oE1UWoWtxP7T2WSDdVLz1T4ZaGH6O4/rkwu2P3iF74yG9d0jXu1QiyR1Sv
XKLh1EWXAlM1i7vHNoiFU1oh9dQqNBpO3SxWFkdpkHsipM6qs07uqUv1VP2L
lNT7pM+fiYLoR/S5mAzdX+o70+Cig2VoyBqxfXFHDFFD6Krm0BSxxgnMTpsO
ecudF1QVBYKz0CAIl4hQ8JspwVLAdnqmTd8iZfhj0u2d2pYar9DYVoeTSEgf
ARNiU5MxDGoOK3MYFlGkZJ0oY5bE5hhKcoUSOlp5zB2WbtOECmKIUOK0KSGz
wONWOB3cF2GCiyjwSovCCTVOhVth7vo9UTjza+ZcbG4QOePIGkOm9JNodKUP
w8mEhdEotBGdDlfWMBTTNKVWDjM0xxCp6dR+geiG8IuotIhKqzio5JHIdKum
XRLj23mMYsR4pzSliljhmBk3lI99q1GPr7K9k50Fk8ifRN4EFKnZYyClztTy
lTaMGKZXWEyvQiMTOAzVmEYn0ShSEEuk2dwrEOosVihn0TjYOvHoyRSyKdXa
IpaXDVOMRzipNImPFhHoYtqcpbeUSqemRmZA4sWGf3tnFM7a3L6NKCa6C0SX
GYMJ5CkADLszlOY504b0XdKHRAToaPHBmTHEzM/UMi7jq41L9jCbHkElhpie
Jy1f4CFLOKZ9HIJFkHEWaz+nhLSU0Yi10fAKIHR0hmFhkBMJj7Ep1hId6XHd
HRWd2xGa4Ql9t2cJ8TlB5E5AozO1DR1bPBQmqUNIkyY4CVWEjWoMEBmzIYFI
sFEjGGGTQ03gtXJHlObHEjgFY7opbCwCR1Bxaw+Z0OFGfouHMSKAvDZA0yBo
1P3pTekMtzCtEBHYNhvVCG45vzeK1HzYxih9FGmiG5kEBMERvCVeuUGDkRIk
wYjgcsSkDiLNNKVl9OpKH2TMMqSp32UNaWEin4D1zgbNYOZkzAQ20jNlL1m/
LDf9J6AcOxmzSXikeUWiCK3SKYZK5IfFyVU2s90j2IJIdHnaha0rIWY0swgi
J2O0K006m6GAChMswqdwSnspttGxFY7QcVgpg3DxG6eCSABSWA4yPoIaCZZF
EDl2ankaRq7cIG9E61qBkdKYIhEpEqdiamyFDEKxHrFECh7ChhBS2JeJnvEx
RvDxzcA3u80TvbW2fSiKFH3IRkiP1lqYLDo4U0eUJhNctmip3u8pFKlSRtpW
QR5wRa0IquQBOFMGCKLUgZAf4kwbgEVCZRFkIgmEV5a07CEoyHIVZIJsHKFV
SG0M4WAJUo7YkiArHmHlEXPpNTMHgstIE0PF3SW0DGBORuwWvuatkbtLo2SP
wc6McRAqDJogx91NE+SoxaRqK7tXSZjSQ42YGdPYngtcaSI6FuPFr4xZHIvc
AFQjyNKpsQQyamzRMweRNahRy9GaGUsilj+iRUyBZhVpnhJoDJlFkFksXE6v
WWEgbZtSVouwUs0nNoqxsggrpiPW9qg0SA4zut2J0PqgsnOZMg1gdMizFmTS
hHUESyr5GanK53LckSJyQsKWYQQr1wAVbq1suRK/IakfVnI/9T+lX6SMjlYq
HeI0RgPIoCbamTmoPaActm65w1oJCaGCEbZMJOJxBE/xmEgUTUhImoLwaPm2
SicV0g+ZfwwM2XKftkvlMyifVfbKojdW+dz7zmAUWsaKm/HemUn8yNCuMb0a
abIYMqcy6SKTIhfU7b2EWrK0qNiF+w2KGwQciVeKIGIl9sGZ1EcI9il5TekD
NcLPSutXcxESKiubLt5NoOUOQaGmICPAikahEHPrib7l5TGwVGy4+meVTan1
OJ/ARdgQXq7y2TALYKNVMXcrDyqEVuS8+S4tiVYW+SaZPJfIFEnLEB4a7ERW
XSRuhBm1ZBqZGLIdSUNIGtbCGIJuQl2/O88IHFl9UstUUUvCLKEXidQINEbP
4WT4HA4+CsZ3Enjp0ljqBpA1wLpJKOYMMoZ5cpv8YcFwhDEsHtXokbCJA+0q
mwThVib2wWLY+HT5TGiO5awQBPkYV7FV0mLDNDBsR0fveZiVZCubfLgsvR5E
2DF0jB+bMaF+B8GWKiqaImKnYCPULEYshpBLlMaGSU+lHLflbJU65YwpdbWl
jtBzWOd66CcKRyFH7B29vz2lF6l9SJOmEexnBLMHQvDlC8sK9FMtN6+IlYyH
ZI6EsJSoIxAtH0G4wyejZPm0ng9XzIBwqySpq5xTwNOrajGV8++rtbJHovdq
Qmctuunt9jiQMwnCNptn4wZjfkamYCz6HVS2iwC2Upn1KSKXLEIjgq5FsAoP
7qTTSjIzjWQqa8imUAYMBnaYgU0SrM72aEwS+E1iD59LoqOVTIcYxrZXgO3T
vkk/zwVtcAe1jbClkpC1ZHPBI9rkDTKuZdQm4ZtE+RTK9XBqVcwoGa0UYB1W
lZbJqnlQo8+MK4Mbsl+R895bYCufQzsSZgeCYZbrFNyCtdPIc2YwpCk7CO70
cd1Y00msRbItgt1K1kKkrID6xZ0JQ0gYxLlBPrLkD8M2D+ECnj9hpFtPNx2u
+C6ckXa2C9a5bjj2JHSL0ehGUjeICSk9woJezQKW7X6Net4g8odQIB0RK7Cz
ZAweauPwCj0EvG9CA69GgMoZLb+zqJoVr5Bwt/zzNvY2TTHMiAVulQvb/MOQ
V2O8ZFcE6jH2aJ47hdxJ3WweZBMPJhUPHMKEEJfJHgeRoRrNlZgHTjX+p/KQ
xrbFlTwSGg2sRJJ/YoBjD+F/ltoAzg1o+7OdC2o+z7ZZNCBBrMnpTljxneTZ
n+nEWWnnOoUJXUjqQnI3MyGtR48J2f3I6UfuAAh+QX1H0TCKR+AeRckow+8d
R2kQZUpnrcppWFWEemyV2F//LPxzDDwdnYS7cMW/gBgCOtImh/uU0WU9EnWz
p2rlTSk+M/jSrAj0DdrKomdOQGuAk2DXmI9Dwa5GmiRe3UoUWSOwzw1BoW2d
Iaxj4vtxRjAnrUg1nvduJfTKuVcDIpkdGgTPiISf6qD+nu4g5OmN60wHnyPY
Ezr1anRqD9J7kCEMyu6DlvC8ARQMolBGkeJhuEfgGYV3DKXaBXLsLJ9ExSQq
p1A1DQLeT20W1cp9sKrZylTPm104JW/VIuB0pObyMx9Y8BejSr3si9verBPh
cQL21h6fydPrj7nszRD4OSHMnYS/MwJ3tvEOZ3pQ2xw9w04Z47E0medSjP/O
xBEkCAsIfwKfMI+n1o/T/Rrzfcliemimla0kXhwCwp/MPoGf0If4bpwQrI+3
4UQbTrbhVBtipMsJHUjsRHInUrqQ2m0QJ+xz+pDbDw39IIoE/RIzhu/yBVEe
RIVoMeMu0BPu1TOMuxWYUzPAgDHmfFsrsEDfLKpb0Gs1v6WD5V9ENFt/l+Ae
bW82ct1MWZ18NVOaBr2JzdN7A0oVFA9ytHeuLBG1LGo0ImQqX85KY4FKHWfT
L/xhJsQljYJYoLhwThhxxszg953sw8lenBIrTbpB7g4ZIFKGNJqhqWXSII+8
NguOtOJoi7IpcSdacLIVp1sR3yY/b0dCu8E/tQvpojBZPcjuRW4f8vtRMICi
QTOP9o6idBRl48KFIConUCXC5p9G9TRzIUBcqJlTXlzNgrpxzSKo0WcGvmaJ
rw/Q0aKDkj3/kvGY4zSqSvbDZ3D2CtS2tTqX7XkXEA+kOSw+uDRbpLny1HoJ
a4mVw1xSaqLGBvLGsrTFdvGYLI34YqXyblaKMIY4opiSMKKkeO/pAVaHU/0g
hpzoxfEeHBP4TvTgVC9O9yK+jwcI4glPkR07Djfzt0eacLQJx5pwvBknmnGq
Rdn2nQltSGxHcgdSOpHWiYwu6V4Pcns1+rcXD8ItClE6grJR+MYMDybgF2KI
B4EZ1Myidk6PwnULSvbqFlErjR5FR2ftkkJSsUNzxFnNhxA3oq0V80dZB92m
NzaHZBdlGgXMBzo4t/FCpMNoSp7WFDo4c6a2jRqOGGIMG68JZKjB2yLWWGlB
pTMp40jWCxqO20lPzlIbwpkhxIt7xLzpx4k+HO/FsR4c6cZhgfVQh4LFsYsM
FlmrMz043IIDDXixAQcb5IoGHG7QnDnZxGfim3G2BQmtSGpDSjtSO5DeqTlz
R14vCvpQ2I/iAZQMwiMK6xtF+Rgqg8KfCVRPIiCmonZGy2v9POoX0MC6wQcW
kvolqEYPrl9G3bL2YWuWyYbRf+KQxQx6n3lApKXaHeLWljXJmAheueSQb6+O
8/YK8SpPu9H0KiwjPonV0jrjiMmcDDEnnddtFG+C4ZrruC1xFAmjODcCxaT4
IZwexCkZyU/043gfjvXiSI/m5N4DbXixHUe7WIkSB3mQYakYQ9IA2zPi03N1
eL4OL9SpOcCOQ/U4Uo+j9TjegBPCv/gmnG1WGn1HhoxCOd3I60FBL4r6UNzP
bPIOhbFpHP4gApOo0euqOxvm0DiPxgU0LqJxCU3UltG4rGSQX0OjcP0KrLoV
hVPtMohZDsWt5W3cMt5qZATXbnu0f/+VYxe2a5ht/TTiMcQ3K5xveq3aEUPM
yzFN6MieEi5ameyvZUR4x8TDFKNiciaWTB+x8Izi3xBODSpLePvBLrzYiQMd
eL6db3Gwk40heQs0NJH1yxFZIKeMpoA0FqnRhn/4fAAHanCwBodrlTly7Dvb
hIRmJLcgtRXp7cgU1uV1o6CH+eYmvg3AO4gy0bDKUVSNozqoerezfgYN4n01
zaNpAU2LaKa2hGbmR/OKegS/yj/xDRpWCdL6VdTJ2VriY82KaBoZw2UzyERG
nUTyZLftMWyxgWEcZ5bGFEzbnMvXqqYsIb3mTqtRiXtIPFEta8r4t+kTSJsA
8YNZEkTyOJLGkChj/Vnhh17dOTGA4zLZPtKLQz14sQsHOpknz7bhORnvD3Xi
SBeOd+NkD870i7sg3HAebLKlhw93HazG4QCO1YgVrceZBpxrRGITkpuR1ooM
uVluFwq6UdQLdx88/SgdhE9vYDl21E2iYRqNM2iaRbO4Y62LaCXr1crYtq6g
dTU0M2im9zub1tjoNa6CeMIcWdUcIYZI3Mz2kV/mKNt25ez5TOEMCng6VKBX
QQvUZ8E8P0I76GAJD6b1ih1Bv5OUIsMsPTP8EyH4tZ2KH8apIZwcxIlBHBvA
UcFeAf9CJ55rx0/b8HQLnmxSvgfRJ7+7Z38AP/bhcR+e9PEvninHT8vxXAUO
VOKwH8cCMlWsw9l6JDQgqRGpzUhvRZagnt+Jom64e+FV66COPTXjqAuifhKN
02ieResc2hbQLrOKjmV0rKBjVWnIjvY1tK2hdZ2/allH8zoU6lbDGuGhUGf4
7vx/wDsuDG9qDosOTgJacKZXV74e7/hNnmoKZRp9p5Gtmkh75hQypjTmaZN6
lzk5iMRxJMgQcGYEpwVywvv4ION9SLzgF7pVd0WW7/2hH/9ajRdaWcLV0EFT
wSMteKICj5bgRx4+84QXT3nxTCme9eFABQ5X4phfxo0anK1DYj1SGpHWjMxW
gbxD9WWvrx8Vg/APIyC61zCBpim0TKNtFh3z6FxElzhP3Qpvq4uA3tW5gY4N
tG+IDmygZYNhZ0lfB6F+V5jFV0fLRnq3/mT2CZ2FCklGOFyiXXSwCFyRXILX
yp1R3gTBqxohnDUt9kTo2E3gpk4iZYKbxlcmg2dGcXoEp/RWvOO+/R2hlctH
6/BDEczvV+LBMjxUhmcaeHzOVr/sxnM1eMSNhwvwSBGf+XExnnDjGQ+eLcUB
Hw6V88mTfsQHkFCL5HqkNeod4cIOuLvg7YGvD5UD8A+hRsx70wRaptA2g845
dC+gZwk9y9qv7SM4d/duomcT3Zvo2kTHJto3QxBDhe5/OEJWQ7hG2m8ZkwXX
QhlC+GjRwSpQu0rO/FmES7CR6dyZsPUhwpishozD6VPQIE8ieQKJQUFYzRhP
DOPYEI4M4GC/8jA/8lQ7ftKCxxrxSB1+EMCDVXyL73jxrWJ8swDf8+DJWr2Q
sb8aDxfigUw8mI0f5PDJHxXgiSI848ZzHrxYisM+NSbfkdGI7GbktfA17k54
u1Hei8o+VA+gdggNIsBtk+iYQfcc+hYUPbsH1jAgojp4HgMX0H8BvRfQcwFd
59FxHu3nt68EffBXwti2GkWzKGJs6SBQOxXYhWZ/SmOuIo9noRqjr2Zv9M2O
nFlkzyBrBgrqjGmkTyNN+22uxAmcE4fj9JhC1/liP57vxU/JRnxExrYjpSKx
lUioRkoN0uuQ1YA8mZy521HaifJuVPUi0I+6QTTJAmDHJLpntBe1e2QVo+sY
3cToef5u5BKGLmHwEvovofciui8amxjCaF8YGmJIbG/PeAxOR9iam8bIVTSr
Y3dJBgWrQtmF4qNFByWBBXPIlybaT2dz6T9B5NiZHbaTlT6DtGmkTiN5CkmT
al9AnnVyLLQK9Nn9PXhS1iMfa8H/bsSDNfhOBb7pxddEo+9Pfu/++JtfP4Mn
RZdPt+Nfi/HVU/i70/inc3zm4TQ8lonHc7A/Hy8U4VCJXObDuUok+5FWg6w6
5DagUKAubUd5F/w9CPShfgDNw2gfMwgPz2NsGcE1TG1i6gImL2HiMv9m9AqG
r2DwionGDyF8d1SfzM6quaU/vTcCcyVD/GGOG32IK5rTklU0j0LTrIJ5LaPz
oJY/r9cSc+eRIz/LmkPmrPaudieHzapOjeP4GI6M4NAQDgziuX7spxn+Lv7q
3vuffuM78e/Rux+m4h+O4Csv4uvH8K1Tgm0SHkvFE5nYn4MXC3FUsD3rQ1Il
0vzIDCC3DgWNAmwryjvg70JNDxr6tV73iUqMz2FiCdNrmL+A+cuYu4rZ65i6
huA1o6G31utfFVETFRVXrHew6JWbRii22CzO0ZviBRCorqIFHanIK0QFi8hf
EOstMhqXsxDCLm0WKTNIMvMZ56kJnBgPrRU4DwzhBUJ1SH1vYl4ddz9w7L0v
P46vPIOvH+CrHzyNH57DvyXhqXS8kIvDhTLylyLRh9RKZPiRU4OCOrgFzvI2
M2q2DqBrGAPywMlZzCxieQMbl7F2Fcs3sPiyov39MNwVwjA2HEN1NHHrLoLL
cjN67vkQ7U764HTrtXt65beWe1HHhrvNQg69KV4ycle0HPp9/jLylpCzhOxF
ZC0iYwFp82ZviHEM4vg4H0UO9rG6//PN+x/B3/4YX/upDPsn8Eg8fpKIn6bj
YC6OFfDJBC9SfMioRE418mu0x1bVhpoONHShpRddAxgcRVBmlmuruHQRV67i
0nWcv6G9+vfR4Z0htEK+qEbLzhwTNObAcFmEkIr8KJlHyQI3h4sPzpLF8Jmt
5aF5iGdZjQ4xnhV4VvXXXnKDLc+anlEXr6EoNEtxxGQuIm0BSbOIV7NnE83v
2PXlx/D1p/ncD47h3+LxdBIOZOBoriBUoqNrimrhqZdZazOqW1HXjuZOdPWh
fwCjshBxcRE3lt96/WXlE76PFIXhEkWKPmQ0tMQID8NBB1uPLA+N9p5FjoBd
DMmHl9dkSzUqztIVlIbR7qzYQOUmN4dVsQmr4ryWu8qLKL8AzwZylpEyZ/r6
0Pev3P+1N/gCDpty3JniQYYPORXIr0JRACXizVQ0oroZtS1oaEVbG3o6MNyN
5RE2f29evaSl4dYosN0Rj3fLWBo1IkqjQc0zjxiP1iFNvKKvdAlEe9mymQ/7
VuBbRfmqXpeI8Z9H4AJqLqL2ImoumfWUxqsh/DrnhpW/ee/9f7x+/zfe/PJ3
3/7Go/z1owfx5Em8kICj6TgtLluqGxmlyPEhvxJFfpQEUCqIVDaguhG1jWhq
REcTRhreWqt/ic7fvL4sXI1TaCQNckseQsqQLYe3Wp9w2AiZWYTtExMWDIVI
g5fXiW1pKF0E4VG2pCM+fGbJpNzMI6vWUbUB/wYCm6gRJ6j+Ihou6VWi9uvo
fAndNzD8KiZex5ublyVG5qPf/OL4/X928ctffe3v/+UXjMtzeOoIXjiDoymI
z0JiHt8n04OcMuSXo6gKJdXwygKErxaVdfDXIlCLhlrUlmOs4Mr1rCkVi32u
XyGTOMDrg4yMgBMNmci1mQ/YyISf/bCRJe+C3qEgQMqUgeUxyfItwypfUd/t
qFqDfx3VhMUGajZRex71F9CosYjruIaelzDwMsZew+wbWHkL1998RyI9HXfc
/x8mvvIX1/7h735GFz7yNJ56EQdO4lgi4tORKHKS5UZuKQrKUVwJbzVxKaDE
0RdAmR/lVaisVB0XOnee7MapbpzuQXwvzvTirEyNE/rVWJrE0Y2ETMqgFpvI
fGq2J5wgzpgoXCJX+D9icCll21G2GJobCjLlpDx7KoysVK6CkVnjj4zMBmo3
UXceDRfMWsQV/qr3OgZvYPQVTL6Gpddx4U18VGHze51f/sLqP3311QdFVp55
HgeP4+Q5JKQhJRsZMvjkl6KwHCWEjZ+wqVZ9La0Os9gFhUhNwVNPvkUf7v/e
DUXRnQeacagFh2U15XgnTnThVBdOdyO+ZwtsiYIc4Zas42lV8LEC7PYoOrcd
PZMnYHJz1D+nj3dfysPG5soVjkMhYxNLgFWvo0ZWaOo2Ua/t7M7WS+i4jK6r
6LkmjvANTLyC+Vex+prOYbzzb3+39st/NPHNv7n68D8zuc8/i6NHceYsklOR
no1sQazAi2IfPIRYFYOm/JqPe0jVKlBYiuxCJGTi+ZN86d8/ga8dwNfO4juZ
eKgQP/TyySer8UwtnqvHC4042IzDrTgqKJ7oNBB2817KuV7efKTzBGGSkj8W
W+MZqqErbODSFipS3iRO0/yYxM1HbQnleuvKEVe1Av8qt+o1BNZZxOo2tGXe
2XQeLRfQJqh1X0HvVQwIcMEbOotl7z98vurbfzLwjT9f/1//+MpTj9yk704d
QdJZpKUiOxv5hSgSF7vEp/T8Y4SXV2TLXYXiCuSVItPNRut4Op48w+e/G49v
n8O/pOPhfDzm4QU+Ork/wBsVBxpwsImXoI614rgskZ/uBAfkdPOaOMGlI4iJ
2JQBVtHUQai8AD5921YPSEfL2WvNUaOVZK3R/M5nnMMKXj+pJOtVpVfDGbxV
BNZE4vQquiyjNJ9HK+F3EZ2X0H0ZfTTruqozsXb98+fLfvhn3Q/91dJPvnX9
wCM/p6uTjiHzHHJSkZ+tvJ17fX6U+lnGSB9LA/DKyhHZ9LxyZJUiuRjx+TiU
xSd/ksGTxsdy8aNCPO7BUz7sl+WPF+p4N+5wE+9dcwRBO2RNKjZBhTc6HMn9
HLbN9pjQsiQ5IN3WT7bpnD4qq8F2ZjXLGQN1l0Zoh9FNEqoKaoRMJbsALFki
XIovO+vWUb+Bhg00qTWm82i7gA6a61/SeZRx3/8994//tH3/V2YOfOfKyX99
jS7KOK71694yN3ylqJBJc2UA5TXw1aAswLiUyvhW7GdPILsc6WVI9OBUMQ6J
uj5XiGeKsd+L/WV4tgLPywrlwTremRQsdpztwrluJPTomM+kPiTLErTEZTOB
nCJhZ9uEJCQ2XEIiKxls2ZuytTPs13foX8tMgdcZKwQ9Qq6KmkCnI2Rq1lC7
BkZvndFr3ECzANh2XucWux79/fz9f9J85G+D8Q9ckN/c40lGWSYqCuD3osqH
ahEGGvj9dewEVNShvA5lddpjKqxGnh/ZVUir4NnbaVnZOeLFoTK1577vRDNO
tuB0G+LbcaaDA67YuHcjsQdJvQJYH1L6kSI7kSRHCjNWDZemMnItR2G0fR5s
ULnDWDmXAkRpnlVNoOwIiEvNkKwJJOsMSdMGPinD6+N/kGWPCPk/ue49xKpV
nYFAHmrdqCtDXSXqA2io45vUiK/ob0RVIyob4ZNdT3c9CmuRV4OsarUKuO9k
NU4GcKIGJ+pwsh4nZUp7uoXDP86242wHx5+dkz1xRqQHyb2MiMXB6nHhuRBE
mMqtcViSrqcSkswsfXcERsouhe9mqrtIDB9dZlcx2UUA+ZdB4FALrKBmK0Cf
MtfdnfDntbnfGvE+tla+/3rNCR7gWnLRWozWMrRUorkazXVoFgwamlHXgpoW
BFp4fkGzLV+T1uMPZdUivRaptUgSvTtXhzP1iK/H6QbEN+KMrEudbQNHxXRw
fFhiFzg8UmJVU3o5AF1F9amcmnTJpCFyON8oczjKemdURMI0a7eWGfGPeaqk
4FCIBGTvixCpXdXVNz6Y8qV099dqq34w3LR/tfXI9c6Et3qzxYsqQ68fPTXo
rkNnI9qb0Crrvo1tqG/nqWZNm14J8TSjuAmFTchvRG4jshqRLiKR3IikJt7g
S2jGuWYOc0iUkT2pA0mdSJbYxGS9P88R+FY6CccORkCgIAQyBYpMldNocm81
9dHlQ45RZrA7NCr3GrQUJA7eT3c4CRZ9vWByZ9k30pu+W9P1xPDQkZWxc9eD
WW+NF/McctSP0ToMN2KwGX1t6G5Dp4y8rR3aOu0LdKCqHRVy1tsGdyuKWlHQ
wmvmOS3IEgTTWnknOqUVyW1IbkdKh7K8MWkSrMxC0M+ZHKQVA5InxDlVKs53
WPndhAZjFl0eTOySiaY0Nue+MMphz+hCv5YKKrd3/kv62GM10weHFxOWlzNf
WnL/YrHiXfrRXCOmmjHRijGaUndhoBu93Xp039fWg5YeNHajrhs1XbxKWCEm
sbQDJR0o7kBhBwo6kCf77tkdyOpARoeyJc4MCZLkOEkrg2xERr/qI1GeyQhI
EoudIqUwjlWTA5VGrjL0oyOxLdaILvh0xJVSn+m2xcfSN58PXDw3fC176bL7
pUv+ty/W3zzfwixf7MRcN6Z7EezT9N7RLzasawDt/WjpQ2Mf6ntR04tqifYs
70FZNzzdcHejuAuFXXr9KKcbWdQ4Oj1Lh19l9XE4NH3uJ10f0Dm8JrNJ8HFx
bvkIcz1nRNdJcGxds7k11Xoa9bmIqz4lynPj2aw34wM/zxl+s2Tpdf9LrzW9
83LHzWvdzOqNASwPalpvnxzG2DCGh9EvxrlzCG1DaBlE4yAvsNf0o1qcg4o+
lJl8kLiiXhQKFPm9yKPWx2F/DitHX5AjIcgOZ/aA5NqoyB+6e5zKpFTJlHTM
HRVpd3Iuuq5n8cuoDp393YjPMhruXD9VfjW7+w3PxM3AyjstN97ufufNvpuv
Dr17fVTTu3cliIUgZsYxMY7RMQzJY3vG0DmKthG0jKBxGHVDqNE5Z7t9Ayjt
523zkn6OJKFTRf0ctFXQz4GOeczdvAFFd+4ApxzojMkc8So5v8iig8sk/Klk
dPY/c0dDdbUiq1RtwyCSWqkUsmMys3WpbOpaYOHdjo2bg6/dHLn5i7F335h8
Tyjdc3EaG9NYnsL8FKYnEZzEyCQGZVG1O4iOcbSN6bXXGuFI1TAqhlA+hLIh
DsvwDHK4E50vHuRgzkKWmALOzssfDI3w+ZK/4szjcSzPpIESIiNwcaYsi3je
qBn0GRZTUEPTEcnVsFUnOvn5iG/F+/tgr3dsrOnCRuvGe6MX3518893pm+/O
sVj/bBE3ZDFqcx6rc1icw9wspmYwPoMR2Urp1fmTt7cG0TyOhnHUjaFGulc1
gooRlA/DN4zSYXiHdTie286EKFQ5OsOc0GAVEH35erTKl6RXh5U/qu2AqqUg
djyfa12MR4l8iKQ40r5F6rTUrNlX37DW2fXSXP/VN2ZuvLf09nsrTPY763hz
Da+ID3RhBWtLWF7E/CKmFxCcx6je8dvbM43OKbRPomUSTRNoCKJO9iSqx1A1
hopRlI/CN8ohomr1qmSEo9fdzM1iprRIuFvEqlpI1xSMiv2SYgoSp2mIdv1K
9EZWh4ukV+ZHd9BdagdfH5v42ZWlt967wMS+dwnvXsRbF/DqeVyXWcHGGlZW
Mb+C6WVF6W3D8xiQ3bSuGXRMo22aAwKaJlE/gVqR/uogR4ApWxZTNoZSsQFe
SU5xWCWjsNycGV88qilWWYGFYzoia0zVq5F9PKn7wdpcoHLmo8vz3ijUsnwL
lXu9I1fY8M7dXFjl8ei963jvGt65gjcv45VLuHZRqNzEyoaib8/ECu9zjixi
UBbnu+fQOYv2GbTOoHkajVMc1KPG0aogR5JWBFE+Dp/KH+REBJd3nEktkcbZ
ZmKhJZOWiCxUe2OxhVKTZ3yLN88cN9WsNC0xUSm+/RYaLPVM9vgmrzs4yee9
nkWm+O2X8e7L+MVLeP0aXr6Kq1dw8bKmdX4D0+uYXMP4KkaWMbiEPlHxznm0
z6F1Fs06pmJvnWyvBCY5ZLZqgiOcKyZQPgGfSjUKctIL062yAS038atY1TpQ
lXFUTQg6Uziu9xWDqpZUeE2iW0jznb9EmmXtaHf1xHrX2tsKy6E1XLyKmz/D
W6/ilRt46SVcua4lcsf8ecxsYnID42sYWcXgCvqW0LOo47aaZtEwg/oZ1IpN
C0zBP8UB9ZWSV6JoVvMNryT7eiTrlz7T0elWNS9ihN9MnyJL0SfL9oXvz121
Srnvl9CrfPD7P/fgyoXN2ctv6Sy0mgUOf1i6jOkLOH8dV2+IYF/DyhUsXuL3
0+cxsYnxDYysYXAV/St6zN7TscjBaS3zaJpD4xzqZ1EnUQoBySDwS06H0FTG
WSulE/BKc6hMcIeqYKHrDwj3GYMiXfNFFW+izpuCcLFRaY7cX4ukWVagd/aO
t/z81Yt0k4XrHGDEBkxigYMXzUrZ5g2sXcfSVd5Kp8+TFxA8z7gMmbW0PT0r
6JIVgLZFtCxwIGTTPBqI7DlDto7oquRQz4opSZ9zOHyTkiEq2cpeA4HYaHdY
lTSp4qar32nqQ9rtMvXUNE3OqEh88JcgIfsU+27cWGXVfue9V36O+RsczUYf
a0R5569h+gqmLmPpOhauYuYypoT/Y3qVf3f/GnrX0L2KzhW0CxQti2he4Pjc
xnnU63RAx66A5E9VTaNyGhXUbCgk1Zgz3NXYzZU4VA2TCdhouEMVpiRWSxBR
YqDLyzkct5D/u7V1i/TKZEZ+J8k9/fKVt9975W288g6C1zkIqkXor13iYPC2
NfSfx/hlzF7D1BWJUlHrGsPnOY6qbx09a+gKp36Jg5KVdaib50SNGhngqmeF
/hmm36rg6NTyLXVqHDGlqsKGNDnr4SpfUuNtMvxKrgcWVrWKx/EIWYicTSok
Phxx9nciPqsdSEJk6VXesLr8C1x5G6tvYO41TXNco2z2lM0hQNK+yrF5o2an
dBe9G5bhr38TvRvoWUfXGseltq+gVY/2u0i5GhY4JYKBmQ8DZpaB4YxSiYaS
nPMyVYVFVzkS+feYOi1SDImRIGCkzqGgYYr2iR5FRSCyCmwkAmI3eEZLIFBb
fBOrP8faz2Gt/5zcX7rt0uvousTLNb55jUTNkt6/UVGgHetoF5D6NtGzge51
dK5pDdjdIvLBGCwKBguCwTwCAoNfxyZJNnOMSrdXZQukbAgD4fRObZUYj6nv
VaIrUEoprOLJrVc9FFGnMjo2kTV1I7ExXoJ0UuGjOT/3Jubf1I9ceAPBl9F7
hZeBAysom9foBJZQv8LZLqRVDaJVPWJxu81+zu62VbSuoGWFg/mbZDujfhF1
iwLTAsOk8xj9c5xuLHnehJRUdIhRUKl6IaU6GUmqf3lMK5EahFpSSkzFSeVV
uk1dRV1S1VU8GREbLfMDQekjGoVIO8qzIEkXEaeDjMeld1gVXsHwaxh/3ejP
1OuY+hmmXuM2/BKLEm83CNfLOLOxcp7xaVplSeo+bzRLyVTrKqtc80ooSUXh
o7zHwDyqpdGHqjmpL1Axq9Bx+mbC5cESgLgmml01i/Dh+oxqRuSeMvX77JqD
NjQsWmY16wP0ObQXGlmf+LMRn81+hMheXPrc22XC/pbr6LyB3lcw8Kqm1jX6
Gn8x+ipvGVujL+u95IYNXiAsFU0pneWM2joSlnVtVzo39ZhFcsUgraJpBY0r
LGn1Rj9rF0FOTYCa4OS3oeK4oopZTb1PSvOUmTJiTlU4jo+WZ8rMtgS4El3V
0uXW1oleQ7U5zVrfVpR+/ZegZGmURNa4Q/GTHMZVoKMynLVX0HQNbS9prGJ7
X0b/yxh4BYMv84MHb2i0Bq+j5wpv79WtoWIRHvFEStXs0moig+QiGWuU5tDZ
Gbc1mX19+lcn+mcjxunMgliVDvjjGjM0fs3o4jxkrEkTCS/Lq+uLcZVEpXiq
8qdLAaYai5jT4dg2Sjm34RVZRfuzWstUpbLTk0iY4YCtnGWd+1p7RdPQeh06
RoWx6nlJa0nvNd4nptZ1mTUvoCM8nKR8fpU3zDnDkjxMdt3k5jl2NaxA5eoR
MLUqv3VRA+M3EWkkRyRFUoVH0PHNGnSsshl9TUiapIxkjMdAouVJ5qy/FJWP
aRskFjpOzfROToAaIXJuGslzRpfyV1C8Bu8mfOe1rWsgCbqKlqtou4b2a8Yu
dV7lwIMuiXXqusLodBo/x0UglRsRsrxMGaFVPi+lHFTULBl2GyCL4XGR6xgQ
77FaR53H+aUUB7VKUeEKAUvVKvLpGGguRhdbOr2lYiMduVwlf78riq5sxeXj
0fyZHSe6cEwWwA+14cVWPN+MnzbiqXqtUd/34dtufDVTz55cB0c4uJTakVFT
O2COVTBnCQUCpomWOw//BQTMTCGm8bKWvBbSO5JCq41mxe2XdaYhaSIZMEKS
lNE7h2KhzT2NEhNxHqcA9QtotYJkLe+HcPauK7AU0kyu7yD1TGIrBUtVtah8
jgVPcUOVYFMlxgTTGO/MFkBFymSVI8bGassY9xsROErs0V3nZD31TB/HHp3u
5fSyE904JhuLhztwsB0vtOHZFuxvxtOSafajejxay+kO4jiRtgZxbgrJM0if
N3PedZRtoHwTlQpMPaOIabjE0VXUmi6hmf3Llku6El6LwnGVN6PLFhjKEhPR
HechKmdhy6Zfx/7VLCvpYuXmx/qlDgkhaBGAVoWK/GZltcr0rcpUXUTBzuUN
y/5QmTw2LsZOq/W+CF9A4muThzhYLZHaABJMKZEz/Zw1TgieEhCPy9bj0S7O
Wz7UCcFqxwu9eLFfP/jkGOKDSJjkoGhlxfKNPHjWULoO34bxAc6j5oL+qv4C
x2EJ5U10LrZJYvgCa7x1X7nMGq1GRcLPlkZCsDQMQeWXkPAp7AhQv6xhEXyM
nbKc5Ub+BEOnwbA0VC3qQ1ElTWnsb2pLJuvquzViBjSugiOInR3gPK/4fp2z
tOdYL4724oi0w7K1cbiPk22ODeLEME6NIl6vlcelzSBjDlnzyFlA3iIKl1Bs
IhfifOuo2JAgx01Ub0qc46bJqSdryUEyzoZNqGAZHe1AsNlip2GbgRI8Yxfs
GjeW5NoTdH5pDqtKxRpaFaS9MSR45dLojI/ttdQBLLPzOfhuH9kmbwq1T0bI
m13hNHlY0FOVsWSNRVVUGcDpAa5iwNLEeyAnB2Cd5L28k0PmeWr8TJpEipli
ZM0hZx65xsrHlazAK+5C2RrKya1YR+W6GQECasFAggCdtfRhT91GSG+qVzhK
glTWt4DSeR5KCLUiI8300Za6CoFOxuDYqrDIZQWpk5BzKlGbC8fpY2F4hGTr
U1FQUqNw0rCpHqZ4pmvQ8OezvK15RlA5ozF07DynMgyDSApyplfKJKciZUwj
c8asAhYsoHCRo/LdyyhZhldcqTLttcVWrKFyDVXrEkUqcX9WYF1X0KCPsTUy
YdQQLfKcSWXYEkRqjGCI5kIQ6ahUkTTVKsSZpSNdwNXs+IpPaN1SaPz2rWTG
rknHJekYGhGFRIJomCuTiBQlcJ2kxDEkjXNL1tnYzrSt88wdOXPIk44ULqCI
4FiEe4nhUOs6Kti6YpWxsKrYB1Who/SP3jir6T8ZdhWNRRAoJXOLHQkHQs8C
y+VBLBcWHSwWHKdCoVzPFD+5hf5P6092piXXPHOGaj/JKJAkdVnGpOAEadMY
5wFzfnzQRIllSpZl9gxyZpFL1M5xWpAiWEuCZwneZQk0FxnwkfO0wkQLtzn+
U/b8JaaR5HyVV5pXw+R8iS2zUhNtZWZM5CDR7hU5UMKvDY1Q7qoIyyL5TJhf
5Ng2wzBawLWvxNaljMGVqqvuxaVPcG5u5hRTSZ+ZUB4JOSfPmbdF52ieuIgS
8gs5p8BLY0TpshkRiF5p5BJrY1u1Yo8GTr+OS6wQOhWjNbrEZjKqtkVVIh/G
0c9o719RFrk+YcdIpo1JsSmXqlqpyq6ZfG6mUBHBdCpSeY6SPa3rFhXMce5X
kSQuSZ85sSTGE2aLSpeMz+ejcVRaxbKil09K7CW5bnu54+ZnRKOyemrQiCCU
f/dpTZsKnI1cXTCRxs50vSPCZTi4vFaGqsuhqjvQF1lhNQV25ony5M+CibLp
UqQpu010eaktcTKAVabrWPiWbW45XJo6OWXxi5PjAKXpMdEnY2JpmMbaRDoM
ZUyKymmJXIVlfeSruCiPyGMmV9JTKzOcq++IzZ3W6bj5MjgSLZwZqcYOt8l4
8SxA0cKR64o2IsdnmrNcd7diKSSJ/J4dClvdiEUlihu/rbmh6uB8PtxL2VJN
kSs8hdecU72e0n5sqOeq89qqS6YcNfc8Z3ippB2Pzo8r1V5qGYEq4dCWT9VQ
iiNZYgn9lO6Z+OTqb2hFkROuxKYjViY5817VA+EaFKomQlgtz7gCSc1VeadF
JpFPMq2EGsml8S4wttw5yQxwqh7aSPr0OZ90mXwZxQPTV1Xr6Q+icF5+zXVm
cky15BxVZE7PUjjnnXOFLcmNVdmaxXNGet2S8KOSoLifzi3ZHNLIpeKDb0t2
2Cd1v1Rd1z+M5r1LZIwqtGZJpTvVL5vHXFKCi7Dkm+lBgc4mV3FU1Ee3MFgy
s2QM5fwbZ6kwm48WH1xlYZmPn0RYTJz8bbhQ3GWoN4o+6kqeru8iVWBUT7gz
lq7LIFnuJhPb5GmqLDq37pGH/AzqFX/xWxoR9Rcs/uOtpIora3EtOlN5Rtfi
0jEXAoVK9Jbc72KtpU56puaTVaITEj2SqOVVMvab+unqb/38p1vxI08RLU/f
UsVIqiOYigkms1q+KBaJUWRbJfxf+Vaf0E8UH1H9lcKIJwpC+aZokinEwPUZ
hP/0CKuYZbJYJSbyOXfI7+J7q7/I9kdhfBRp58o9UiemYCbcajhi6Na670IE
3ZrJKJ4L0fkb+s7qr9z9cTScdBUuVTrIZdjiLLLvHaPvwz9UfxPwT25hkYXy
Aqn4UWjqWXEfpUmfTX9EXtTfY4ui31IhrFCtgH1c/0L9ZckvaGzsygGF07ZN
MVd+Qa78r1HH+ofsv+T2MX31F+Xq/xZxdWScx0f11V+Sq78Y8W1k1MA9Gq2/
kav/XPc58qoP6nveL1f994hvI6Pw79BXf1Wu/lLEt5H7M3v01X8nV/9lxLeR
q6g79NX/KFf/FaLNvuM0Td+Wa/4aoVwB/uV35ez/gMqveFA+OT7wfwF9Wgop
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188625769]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14231],

Cell["Compose with inverse function:", "ExampleText",
 CellID->847392240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSech", "[", 
    RowBox[{"Sech", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Sech", "[", 
    RowBox[{"ArcSech", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206891546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSech", "[", 
    RowBox[{"Sech", "[", "z", "]"}], "]"}], ",", "z"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1449171412]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcSech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSech"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207373990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1611880857]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcSech", "[", 
    RowBox[{"Sech", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"z", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->146068558],

Cell[BoxData[
 RowBox[{"ArcSech", "[", 
  RowBox[{"Sech", "[", "z", "]"}], "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->375356694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95023437],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express using logarithm:"
}], "ExampleText",
 CellID->97189382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSech", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24723274],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox["1", "z"]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox["1", "z"]}]]}], "+", 
   FractionBox["1", "z"]}], "]"}]], "Output",
 ImageSize->{175, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1460484819]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129068254],

Cell[BoxData[
 RowBox[{"ArcCosh", "[", 
  FractionBox["1", "z"], "]"}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->630267723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65222460],

Cell["Integrals:", "ExampleText",
 CellID->53641806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], " ", 
    RowBox[{"ArcSech", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->613948047],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["x", 
    RowBox[{"3", "/", "2"}]], " ", 
   RowBox[{"ArcSech", "[", "x", "]"}]}], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"1", "-", "x"}], 
      RowBox[{"1", "+", "x"}]]], " ", 
    SqrtBox[
     RowBox[{"1", "+", "x"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"EllipticE", "[", 
        RowBox[{
         RowBox[{"ArcSin", "[", 
          SqrtBox["x"], "]"}], ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "+", 
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         SqrtBox["x"], "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SqrtBox[
     RowBox[{"1", "-", "x"}]]}]]}]], "Output",
 ImageSize->{514, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1520273457]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27264],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sech"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCsch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3987],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->9094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4983],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseHyperbolicSecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcSech/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->128259729],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->437868181]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcSech - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 36.5495706}", "context" -> "System`", 
    "keywords" -> {
     "arsech", "asech", "inverse hyperbolic secant", "inverse sech"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArcSech[z] gives the inverse hyperbolic secant sech -1 (z) of the \
complex number z. ", 
    "synonyms" -> {
     "arc sech", "arcsecanth", "arcsech", "areasecanth", "areasech", 
      "asecanth", "asech", "invsech"}, "title" -> "ArcSech", "type" -> 
    "Symbol", "uri" -> "ref/ArcSech"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5675, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->468309473]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47932, 1391}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2183, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2806, 80, 45, 1, 70, "ObjectName",
 CellID->26467],
Cell[2854, 83, 761, 25, 70, "Usage",
 CellID->11320]
}, Open  ]],
Cell[CellGroupData[{
Cell[3652, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4130, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4253, 136, 241, 8, 70, "Notes",
 CellID->9487],
Cell[4497, 146, 216, 7, 70, "Notes",
 CellID->31226],
Cell[4716, 155, 199, 7, 70, "Notes",
 CellID->28162],
Cell[4918, 164, 720, 27, 70, "Notes",
 CellID->21074]
}, Closed]],
Cell[CellGroupData[{
Cell[5675, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->468309473],
Cell[CellGroupData[{
Cell[6060, 210, 146, 5, 70, "ExampleSection",
 CellID->4220433],
Cell[6209, 217, 64, 1, 70, "ExampleText",
 CellID->354428757],
Cell[CellGroupData[{
Cell[6298, 222, 105, 3, 28, "Input",
 CellID->102103141],
Cell[6406, 227, 177, 5, 36, "Output",
 CellID->1367207019]
}, Open  ]],
Cell[6598, 235, 125, 3, 70, "ExampleDelimiter",
 CellID->401874856],
Cell[CellGroupData[{
Cell[6748, 242, 216, 7, 28, "Input",
 CellID->16186437],
Cell[6967, 251, 2220, 40, 141, "Output",
 Evaluatable->False,
 CellID->96668501]
}, Open  ]],
Cell[9202, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->131402818],
Cell[9330, 299, 61, 1, 70, "ExampleText",
 CellID->973969209],
Cell[CellGroupData[{
Cell[9416, 304, 294, 9, 70, "Input",
 CellID->143372757],
Cell[9713, 315, 1204, 40, 58, "Output",
 CellID->457568342]
}, Open  ]],
Cell[CellGroupData[{
Cell[10954, 360, 294, 9, 70, "Input",
 CellID->19251749],
Cell[11251, 371, 1103, 37, 54, "Output",
 CellID->212184087]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12403, 414, 216, 7, 70, "ExampleSection",
 CellID->26255],
Cell[12622, 423, 73, 1, 70, "ExampleText",
 CellID->70817306],
Cell[CellGroupData[{
Cell[12720, 428, 128, 4, 70, "Input",
 CellID->251401134],
Cell[12851, 434, 274, 7, 36, "Output",
 CellID->1355096189]
}, Open  ]],
Cell[13140, 444, 125, 3, 70, "ExampleDelimiter",
 CellID->255711112],
Cell[13268, 449, 70, 1, 70, "ExampleText",
 CellID->147880070],
Cell[CellGroupData[{
Cell[13363, 454, 181, 6, 70, "Input",
 CellID->199240040],
Cell[13547, 462, 235, 7, 36, "Output",
 CellID->1037572088]
}, Open  ]],
Cell[13797, 472, 125, 3, 70, "ExampleDelimiter",
 CellID->376756117],
Cell[13925, 477, 113, 3, 70, "ExampleText",
 CellID->451779059],
Cell[CellGroupData[{
Cell[14063, 484, 148, 4, 70, "Input",
 CellID->613584605],
Cell[14214, 490, 239, 6, 36, "Output",
 CellID->906869376]
}, Open  ]],
Cell[14468, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->164751678],
Cell[14596, 504, 92, 1, 70, "ExampleText",
 CellID->262234383],
Cell[CellGroupData[{
Cell[14713, 509, 103, 3, 70, "Input",
 CellID->126904788],
Cell[14819, 514, 159, 5, 36, "Output",
 CellID->1062159673]
}, Open  ]],
Cell[14993, 522, 125, 3, 70, "ExampleDelimiter",
 CellID->100018944],
Cell[15121, 527, 203, 7, 70, "ExampleText",
 CellID->524947429],
Cell[CellGroupData[{
Cell[15349, 538, 141, 4, 70, "Input",
 CellID->321973988],
Cell[15493, 544, 280, 9, 52, "Output",
 CellID->1833550247]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15822, 559, 239, 7, 70, "ExampleSection",
 CellID->13163],
Cell[16064, 568, 204, 8, 70, "ExampleText",
 CellID->47204056],
Cell[CellGroupData[{
Cell[16293, 580, 236, 8, 70, "Input",
 CellID->699535003],
Cell[16532, 590, 1001, 34, 58, "Output",
 CellID->88666879]
}, Open  ]],
Cell[17548, 627, 125, 3, 70, "ExampleDelimiter",
 CellID->186464750],
Cell[17676, 632, 212, 7, 70, "ExampleText",
 CellID->207227519],
Cell[CellGroupData[{
Cell[17913, 643, 239, 8, 70, "Input",
 CellID->635343390],
Cell[18155, 653, 313, 10, 36, "Output",
 CellID->2018067982]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18517, 669, 222, 7, 70, "ExampleSection",
 CellID->5792],
Cell[18742, 678, 84, 1, 70, "ExampleText",
 CellID->164562840],
Cell[CellGroupData[{
Cell[18851, 683, 413, 14, 70, "Input",
 CellID->75796208],
Cell[19267, 699, 19184, 319, 70, "Output",
 Evaluatable->False,
 CellID->188625769]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38500, 1024, 233, 7, 70, "ExampleSection",
 CellID->14231],
Cell[38736, 1033, 73, 1, 70, "ExampleText",
 CellID->847392240],
Cell[CellGroupData[{
Cell[38834, 1038, 251, 8, 70, "Input",
 CellID->206891546],
Cell[39088, 1048, 273, 9, 36, "Output",
 CellID->1449171412]
}, Open  ]],
Cell[39376, 1060, 352, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[39753, 1077, 107, 3, 70, "Input",
 CellID->207373990],
Cell[39863, 1082, 204, 7, 36, "Output",
 CellID->1611880857]
}, Open  ]],
Cell[40082, 1092, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[40203, 1097, 230, 7, 70, "Input",
 CellID->146068558],
Cell[40436, 1106, 223, 7, 36, "Output",
 CellID->375356694]
}, Open  ]],
Cell[40674, 1116, 124, 3, 70, "ExampleDelimiter",
 CellID->95023437],
Cell[40801, 1121, 215, 8, 70, "ExampleText",
 CellID->97189382],
Cell[CellGroupData[{
Cell[41041, 1133, 134, 4, 70, "Input",
 CellID->24723274],
Cell[41178, 1139, 410, 16, 60, "Output",
 CellID->1460484819]
}, Open  ]],
Cell[CellGroupData[{
Cell[41625, 1160, 105, 3, 70, "Input",
 CellID->129068254],
Cell[41733, 1165, 212, 7, 51, "Output",
 CellID->630267723]
}, Open  ]],
Cell[41960, 1175, 124, 3, 70, "ExampleDelimiter",
 CellID->65222460],
Cell[42087, 1180, 52, 1, 70, "ExampleText",
 CellID->53641806],
Cell[CellGroupData[{
Cell[42164, 1185, 221, 7, 70, "Input",
 CellID->613948047],
Cell[42388, 1194, 961, 35, 111, "Output",
 CellID->1520273457]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43410, 1236, 311, 9, 70, "SeeAlsoSection",
 CellID->27264],
Cell[43724, 1247, 1178, 44, 70, "SeeAlso",
 CellID->11538]
}, Open  ]],
Cell[CellGroupData[{
Cell[44939, 1296, 313, 9, 70, "TutorialsSection",
 CellID->3987],
Cell[45255, 1307, 181, 4, 70, "Tutorials",
 CellID->9094]
}, Open  ]],
Cell[CellGroupData[{
Cell[45473, 1316, 320, 9, 70, "RelatedLinksSection",
 CellID->4983],
Cell[45796, 1327, 194, 4, 70, "RelatedLinks"],
Cell[45993, 1333, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46229, 1342, 319, 9, 70, "MoreAboutSection",
 CellID->128259729],
Cell[46551, 1353, 151, 3, 70, "MoreAbout",
 CellID->437868181]
}, Open  ]],
Cell[46717, 1359, 27, 0, 70, "History"],
Cell[46747, 1361, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

