(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138648,       3999]
NotebookOptionsPosition[    123334,       3447]
NotebookOutlinePosition[    124690,       3485]
CellTagsIndexPosition[    124603,       3480]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sin" :> Documentation`HelpLookup["paclet:ref/Sin"], "ArcCos" :> 
          Documentation`HelpLookup["paclet:ref/ArcCos"], "ArcSinh" :> 
          Documentation`HelpLookup["paclet:ref/ArcSinh"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sin\"\>", 2->"\<\"ArcCos\"\>", 
       3->"\<\"ArcSinh\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Inverse Functions\"\>", 3->"\<\"Precollege Education\"\>", 
       4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcSin", "ObjectName",
 CellID->12729],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcSin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcSin"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc sine ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sin", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians.", "Notes",
 CellID->12274],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->5226],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->16463]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1871279],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->69712144],

Cell["Results are in radians:", "ExampleText",
 CellID->20695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13179],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101698665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17659],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266257376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6576],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{193, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{193., Automatic}},
 CellLabel->"Out[1]=",
 CellID->52778738]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3592],

Cell["Evaluate numerically:", "ExampleText",
 CellID->628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "0.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24196],

Cell[BoxData["0.41151684606748806`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90366551]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "1.5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15535],

Cell[BoxData[
 RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.9624236501192069`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164774718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20877],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->20353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2942],

Cell[BoxData[
 RowBox[{"1.1646235102893852`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.6586932988564327`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148749294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1229],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->3716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23532],

Cell[BoxData["0.\
3398369094541219370963925133917640663882446903324580714319239442047`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244765212]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->16158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "0.33333333333333333333333333333333333333333333", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29749],

Cell[BoxData["0.3398369094541219370963925133917640663882446867969241654973`43.\
5056942842974"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127668214]
}, Open  ]],

Cell["\<\
The precision of the output can be much lower than the precision of the \
input:\
\>", "ExampleText",
 CellID->23296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "0.999999999999999999999999999999999999", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19724],

Cell[BoxData["1.57079632679489661781710812926`18.346634874860516"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->954616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24526],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->16406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  FractionBox["1", "2"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8983],

Cell[BoxData[
 FractionBox["\[Pi]", "6"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386246552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420366662],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->501011316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"I", " ", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221525526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"ArcSin", "[", "x", "]"}]}], ",", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"ArcSinh", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687755572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30574],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->21691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.5", ",", "0.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2013579207903308`", ",", "0.5235987755982989`", ",", 
   "0.9272952180016123`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749850073]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"1", 
       FractionBox["1", "3"]},
      {"x", 
       FractionBox["1", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[Pi]", "2"], ",", 
     RowBox[{"ArcSin", "[", 
      FractionBox["1", "3"], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcSin", "[", "x", "]"}], ",", 
     FractionBox["\[Pi]", "6"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333154099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309462556],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->270239384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSin", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111839775],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sin", 
    RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{43, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->13179521]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->23855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27804],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcSin", "[", 
      FractionBox["1", "3"], "]"}]}], ",", 
    FractionBox["\[Pi]", "6"]}], "}"}], "]"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615152749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16909],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->19381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12779],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390918987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10532],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2], 
    Rational[1, 2]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66258287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27842],

Cell["Find series expansions at branch points and branch cuts:", "ExampleText",
 CellID->8724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31149],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"Arg", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], "]"}], 
         RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{"x", "-", "1"}]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           RowBox[{"x", "-", "1"}], "]"}], 
          RowBox[{"3", "/", "2"}]],
         SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
         Editable->False]}],
       SeriesData[$CellContext`x, 1, {Complex[0, -2] 2^Rational[1, 2]}, 1, 3, 
        2],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4777688]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13590],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"Arg", "[", 
      RowBox[{"2", "+", "x"}], "]"}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Floor", "[", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{"2", "+", "x"}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ArcSin", "[", "2", "]"}]}], "+", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "2"}], ")"}]}], 
        SqrtBox["3"]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"x", "+", "2"}], "]"}], "2"],
       SeriesData[$CellContext`x, -2, {}, 0, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, -2, {-ArcSin[2], Complex[0, -1] 
       3^Rational[-1, 2]}, 0, 2, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{480, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86949956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26099],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays:"
}], "ExampleText",
 CellID->6161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["1", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11047],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599058879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15290],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->582916530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29959],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["\[Pi]", "2"], "0", 
      RowBox[{"ArcSin", "[", 
       FractionBox["1", "3"], "]"}]},
     {"0", "0", "0"},
     {"0", "0", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "6"]}]},
     {"0", 
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{136, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->580734267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22148],

Cell[TextData[{
 "Plot the real and imaginary parts of ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"ArcSin", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"ArcSin", "[", "x", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{155, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{155., Automatic}},
 CellLabel->"Out[1]=",
 CellID->537567854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7210],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"u", "+", 
         RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"u", "+", 
         RowBox[{"\[ImaginaryI]", " ", "v"}]}], "]"}], "]"}], ",", "u"}], 
     "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25616],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244658435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24815],

Cell["Find the angle between two 3D vectors:", "ExampleText",
 CellID->6064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"Normalize", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", 
         RowBox[{"-", "2"}]}], "}"}], "]"}]}], ",", 
     RowBox[{"u", "=", 
      RowBox[{"Normalize", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"Norm", "[", 
     RowBox[{"Cross", "[", 
      RowBox[{"v", ",", "u"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29472],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173246359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19593],

Cell["\<\
Modeling Levy\[CloseCurlyQuote]s second arc sine law:\
\>", "ExampleText",
 CellID->32482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", "=", "1000"}], "}"}], ",", 
     RowBox[{"ListPlot", "[", 
      RowBox[{"MapIndexed", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"#1", ",", 
           RowBox[{
            RowBox[{
            "#2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "/",
             "n"}]}], "}"}], "&"}], ",", 
        RowBox[{"Sort", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Position", "[", 
              RowBox[{
               RowBox[{"FoldList", "[", 
                RowBox[{"Plus", ",", "0", ",", 
                 RowBox[{"RandomChoice", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "n"}], 
                  "]"}]}], "]"}], ",", "0"}], "]"}], "\[LeftDoubleBracket]", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "\[RightDoubleBracket]"}], "/", 
            "n"}], ",", 
           RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}], "]"}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "/", "Pi"}], " ", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"Sqrt", "[", "x", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89352364],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430335894]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15333],

Cell["Compose with the inverse function:", "ExampleText",
 CellID->80512647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"ArcSin", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"Sin", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"Sin", "[", "z", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53858135]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244846602]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"Sin", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"0", "<", "z", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404146284],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->213190957]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8399],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express through logarithms and square roots:"
}], "ExampleText",
 CellID->5032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSin", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17508],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "z"}], "+", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}]]}], "]"}]}]], "Output",
 ImageSize->{140, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137859373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87597427],

Cell[BoxData[
 RowBox[{"ArcSin", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->838553208]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13438],

Cell[TextData[{
 "This shows the branch cuts of the ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->23978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22638],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{160, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{160., Automatic}},
 CellLabel->"Out[1]=",
 CellID->682065132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30623],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->14852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"ArcSin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15625],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"\[Sqrt]", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "y"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["x", "2"], " ", 
               SuperscriptBox["y", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}], ")"}], "2"]}], ")"}], 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"Cos", "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"Arg", "[", 
              RowBox[{"1", "-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], 
              "]"}]}], "]"}]}]}], ")"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"4", " ", 
               SuperscriptBox["x", "2"], " ", 
               SuperscriptBox["y", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}], ")"}], "2"]}], ")"}], 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"Sin", "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"Arg", "[", 
              RowBox[{"1", "-", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], 
              "]"}]}], "]"}]}]}], ")"}], "2"]}], ")"}]}], "]"}]}]}]], "Output",\

 ImageSize->{447, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83583129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->744],

Cell["Solve an inverse trigonometric equation:", "ExampleText",
 CellID->27362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcSin", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"ArcSin", "[", "z", "]"}]}]}], "\[Equal]", "2"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24769],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       SqrtBox["17"]}], ")"}]}], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        FractionBox["3", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox["17"]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           SqrtBox["17"]}], ")"}], "2"]}]}]]}]}], "]"}]}]], "Output",
 ImageSize->{411, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14765150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "\[Equal]", "w"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26518],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", "w", "]"}], "\[Equal]", 
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}]}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "w", "]"}], "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["\[Pi]", "2"]}], "<", 
       RowBox[{"Re", "[", "w", "]"}], "<", 
       FractionBox["\[Pi]", "2"]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Re", "[", "w", "]"}], "\[Equal]", 
       FractionBox["\[Pi]", "2"]}], "&&", 
      RowBox[{
       RowBox[{"Im", "[", "w", "]"}], "\[LessEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "\[Equal]", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"z", "\[Equal]", 
         RowBox[{
          RowBox[{"ArcSin", "[", 
           RowBox[{"Sin", "[", "w", "]"}], "]"}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{485, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119792016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10558],

Cell["Solve for zeros:", "ExampleText",
 CellID->32143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23061],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
    RowBox[{"\[Beta]", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["\[Beta]", "\[Alpha]"]}]}]}], ")"}]}]], "Output",
 ImageSize->{224, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543262089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21300],

Cell["Integrals:", "ExampleText",
 CellID->31768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcSin", "[", "z", "]"}], "a"], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox[
   RowBox[{"ArcSin", "[", "z", "]"}], "a"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"ArcSin", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"ArcSin", "[", "z", "]"}]}], ")"}], "a"]}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "a"}], ",", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"ArcSin", "[", "z", "]"}]}]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        RowBox[{"ArcSin", "[", "z", "]"}]}], ")"}], "a"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "a"}], ",", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"ArcSin", "[", "z", "]"}]}]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{576, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2323375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5396],

Cell["Laplace transforms:", "ExampleText",
 CellID->4566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25230],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "2"], ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         FractionBox["1", "2"], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]"}], "s"], ",", 
      FractionBox["1", "2"]}], "]"}]}], 
   RowBox[{"2", " ", "\[Pi]", " ", "s"}]]}]], "Output",
 ImageSize->{313, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56812734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26260],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " is a special case of various mathematical functions:"
}], "ExampleText",
 CellID->12158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     FractionBox["\[Pi]", "2"], "-", 
     RowBox[{"InverseJacobiCD", "[", 
      RowBox[{"z", ",", "0"}], "]"}]}], ",", " ", 
    RowBox[{"InverseJacobiCS", "[", 
     RowBox[{
      FractionBox["\[ImaginaryI]", "z"], ",", "1"}], "]"}], ",", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox["\[Pi]"], "2"]}], " ", 
     RowBox[{"MeijerG", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           FractionBox["1", "2"]}], "}"}]}], "}"}], ",", 
       RowBox[{"\[ImaginaryI]", " ", "z"}], ",", 
       FractionBox["1", "2"]}], "]"}]}]}], "}"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23425],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"ArcSin", "[", "z", "]"}]}], ",", 
   SuperscriptBox[
    RowBox[{"ArcSin", "[", "z", "]"}], "2"]}], "}"}]], "Output",
 ImageSize->{254, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112536928]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19312],

Cell[TextData[{
 "Generically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "\[NotEqual]", "z"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSin", "[", 
  RowBox[{"Sin", "[", "30.", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5169],

Cell[BoxData[
 RowBox[{"-", "1.4159265358979327`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68408008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"ArcSin", "[", "30.", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1570],

Cell[BoxData[
 RowBox[{"30.00000000000001`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.8359493760810856`*^-15", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->570109949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29235],

Cell["\<\
On branch cuts machine-precision inputs can give numerically wrong answers:\
\>", "ExampleText",
 CellID->6890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSin", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1711],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.5707963267948966`"}], "+", 
  RowBox[{"1.3169578969248166`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145360413]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSin", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"#", ",", "30"}], "]"}], "&"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4750],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "1.570796326794896619231321691639751442098584699687`30.\
034918261302636"}], "-", 
  RowBox[{
  "1.316957896924816708625046347307968444026981971467`29.9583702750843", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{470, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358434683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7545],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->14767],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sin", 
    RowBox[{"-", "1"}]], "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->21754],

Cell[BoxData[
 FractionBox["x", "sin"]], "Output",
 ImageSize->{30, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->650863422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sin", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"ArcSin", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->564095075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2815],

Cell["Nested integrals:", "ExampleText",
 CellID->27579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"ArcSin", "[", "x", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]], "+", 
    RowBox[{"x", " ", 
     RowBox[{"ArcSin", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["3", "4"], " ", "x", " ", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}], "+", 
    FractionBox[
     RowBox[{"ArcSin", "[", "x", "]"}], "4"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"ArcSin", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "36"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{"4", "+", 
         RowBox[{"11", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", "x"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["x", "3"]}]}], ")"}], " ", 
       RowBox[{"ArcSin", "[", "x", "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "576"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", "x", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{"11", "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["x", "4"]}]}], ")"}], " ", 
       RowBox[{"ArcSin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{501, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3331802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19269],

Cell["Calculate numerical values by iteration:", "ExampleText",
 CellID->11886],

Cell[BoxData[
 RowBox[{
  RowBox[{"arcSin", "[", 
   RowBox[{"x_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"InexactNumberQ", "[", "#", "]"}], "&&", 
       RowBox[{"0", "<", "#", "<", "1"}]}], "&"}], ")"}]}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"\[Xi]", ",", 
      RowBox[{"\[Xi]", "+", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"Cos", "[", "\[Xi]", "]"}]}], 
        RowBox[{"(", 
         RowBox[{"x", "-", 
          RowBox[{"Sin", "[", "\[Xi]", "]"}]}], ")"}]}]}]}], "]"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"arcSin", "[", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"7", "/", "11"}], ",", "20"}], "]"}], "]"}], ",", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"7", "/", "11"}], ",", "20"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.68977500078549966005788188217`18.177837000633804", ",", 
   "0.68977500078549966011003611996863673134`19.922275658572488"}], 
  "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275933573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7321],

Cell[TextData[{
 "Plot",
 Cell[BoxData[
  RowBox[{" ", "ArcSin"}]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->18319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29881],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{135, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{135., Automatic}},
 CellLabel->"Out[1]=",
 CellID->525188155]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2307],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSinh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSinh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28134],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->22972],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->24348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16453],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseSine.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcSin/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ArcSin"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->154981321],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->240943129],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->20474719],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->41714103],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->393515112]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcSin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 38.7058758}", "context" -> "System`", 
    "keywords" -> {
     "arcsine", "arcsinus", "arcus sinus", "asin", "inverse sin", 
      "inverse sine", "inverse trigonometric function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcSin[z] gives the arc sine sin -1 (z) of the complex number z. ", 
    "synonyms" -> {"arc sin", "arcsen", "arcsin", "asin", "invsin"}, "title" -> 
    "ArcSin", "type" -> "Symbol", "uri" -> "ref/ArcSin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6988, 234, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1871279]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 124462, 3473}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2883, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3506, 90, 44, 1, 70, "ObjectName",
 CellID->12729],
Cell[3553, 93, 740, 25, 70, "Usage",
 CellID->9734]
}, Open  ]],
Cell[CellGroupData[{
Cell[4330, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4808, 140, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4931, 146, 66, 1, 70, "Notes",
 CellID->12274],
Cell[5000, 149, 553, 22, 70, "Notes",
 CellID->5226],
Cell[5556, 173, 239, 8, 70, "Notes",
 CellID->9487],
Cell[5798, 183, 214, 7, 70, "Notes",
 CellID->31226],
Cell[6015, 192, 197, 7, 70, "Notes",
 CellID->28162],
Cell[6215, 201, 736, 28, 70, "Notes",
 CellID->16463]
}, Closed]],
Cell[CellGroupData[{
Cell[6988, 234, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1871279],
Cell[CellGroupData[{
Cell[7371, 248, 147, 5, 70, "ExampleSection",
 CellID->69712144],
Cell[7521, 255, 62, 1, 70, "ExampleText",
 CellID->20695],
Cell[CellGroupData[{
Cell[7608, 260, 98, 3, 28, "Input",
 CellID->13179],
Cell[7709, 265, 182, 6, 49, "Output",
 CellID->101698665]
}, Open  ]],
Cell[7906, 274, 121, 3, 70, "ExampleDelimiter",
 CellID->23144],
Cell[CellGroupData[{
Cell[8052, 281, 215, 7, 28, "Input",
 CellID->17659],
Cell[8270, 290, 841, 29, 54, "Output",
 CellID->266257376]
}, Open  ]],
Cell[9126, 322, 121, 3, 70, "ExampleDelimiter",
 CellID->21907],
Cell[CellGroupData[{
Cell[9272, 329, 232, 8, 28, "Input",
 CellID->6576],
Cell[9507, 339, 2469, 45, 138, "Output",
 Evaluatable->False,
 CellID->52778738]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12025, 390, 215, 7, 70, "ExampleSection",
 CellID->3592],
Cell[12243, 399, 58, 1, 70, "ExampleText",
 CellID->628],
Cell[CellGroupData[{
Cell[12326, 404, 100, 3, 70, "Input",
 CellID->24196],
Cell[12429, 409, 176, 5, 36, "Output",
 CellID->90366551]
}, Open  ]],
Cell[CellGroupData[{
Cell[12642, 419, 100, 3, 70, "Input",
 CellID->15535],
Cell[12745, 424, 273, 7, 36, "Output",
 CellID->164774718]
}, Open  ]],
Cell[13033, 434, 121, 3, 70, "ExampleDelimiter",
 CellID->20877],
Cell[13157, 439, 70, 1, 70, "ExampleText",
 CellID->20353],
Cell[CellGroupData[{
Cell[13252, 444, 122, 4, 70, "Input",
 CellID->2942],
Cell[13377, 450, 273, 7, 36, "Output",
 CellID->148749294]
}, Open  ]],
Cell[13665, 460, 120, 3, 70, "ExampleDelimiter",
 CellID->1229],
Cell[13788, 465, 65, 1, 70, "ExampleText",
 CellID->3716],
Cell[CellGroupData[{
Cell[13878, 470, 176, 6, 70, "Input",
 CellID->23532],
Cell[14057, 478, 235, 7, 36, "Output",
 CellID->244765212]
}, Open  ]],
Cell[14307, 488, 109, 3, 70, "ExampleText",
 CellID->16158],
Cell[CellGroupData[{
Cell[14441, 495, 146, 4, 70, "Input",
 CellID->29749],
Cell[14590, 501, 237, 6, 36, "Output",
 CellID->127668214]
}, Open  ]],
Cell[14842, 510, 127, 4, 70, "ExampleText",
 CellID->23296],
Cell[CellGroupData[{
Cell[14994, 518, 138, 4, 70, "Input",
 CellID->19724],
Cell[15135, 524, 205, 5, 36, "Output",
 CellID->954616]
}, Open  ]],
Cell[15355, 532, 121, 3, 70, "ExampleDelimiter",
 CellID->24526],
Cell[15479, 537, 87, 1, 70, "ExampleText",
 CellID->16406],
Cell[CellGroupData[{
Cell[15591, 542, 118, 4, 70, "Input",
 CellID->8983],
Cell[15712, 548, 182, 6, 49, "Output",
 CellID->386246552]
}, Open  ]],
Cell[15909, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->420366662],
Cell[16037, 562, 90, 1, 70, "ExampleText",
 CellID->501011316],
Cell[CellGroupData[{
Cell[16152, 567, 228, 8, 70, "Input",
 CellID->221525526],
Cell[16383, 577, 330, 11, 36, "Output",
 CellID->687755572]
}, Open  ]],
Cell[16728, 591, 121, 3, 70, "ExampleDelimiter",
 CellID->30574],
Cell[16852, 596, 215, 7, 70, "ExampleText",
 CellID->21691],
Cell[CellGroupData[{
Cell[17092, 607, 161, 5, 70, "Input",
 CellID->26588],
Cell[17256, 614, 275, 9, 36, "Output",
 CellID->749850073]
}, Open  ]],
Cell[CellGroupData[{
Cell[17568, 628, 592, 18, 70, "Input",
 CellID->20664],
Cell[18163, 648, 455, 16, 51, "Output",
 CellID->333154099]
}, Open  ]],
Cell[18633, 667, 125, 3, 70, "ExampleDelimiter",
 CellID->309462556],
Cell[18761, 672, 203, 7, 70, "ExampleText",
 CellID->270239384],
Cell[CellGroupData[{
Cell[18989, 683, 140, 4, 70, "Input",
 CellID->111839775],
Cell[19132, 689, 277, 9, 52, "Output",
 CellID->13179521]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19458, 704, 238, 7, 70, "ExampleSection",
 CellID->7328],
Cell[19699, 713, 359, 13, 70, "ExampleText",
 CellID->23855],
Cell[CellGroupData[{
Cell[20083, 730, 256, 9, 70, "Input",
 CellID->27804],
Cell[20342, 741, 348, 12, 51, "Output",
 CellID->615152749]
}, Open  ]],
Cell[20705, 756, 121, 3, 70, "ExampleDelimiter",
 CellID->16909],
Cell[20829, 761, 80, 1, 70, "ExampleText",
 CellID->19381],
Cell[CellGroupData[{
Cell[20934, 766, 112, 3, 70, "Input",
 CellID->12779],
Cell[21049, 771, 173, 5, 36, "Output",
 CellID->390918987]
}, Open  ]],
Cell[21237, 779, 121, 3, 70, "ExampleDelimiter",
 CellID->10083],
Cell[21361, 784, 199, 7, 70, "ExampleText",
 CellID->692],
Cell[CellGroupData[{
Cell[21585, 795, 292, 10, 70, "Input",
 CellID->10532],
Cell[21880, 807, 575, 20, 54, "Output",
 CellID->66258287]
}, Open  ]],
Cell[22470, 830, 121, 3, 70, "ExampleDelimiter",
 CellID->27842],
Cell[22594, 835, 94, 1, 70, "ExampleText",
 CellID->8724],
Cell[CellGroupData[{
Cell[22713, 840, 214, 7, 70, "Input",
 CellID->31149],
Cell[22930, 849, 1155, 38, 54, "Output",
 CellID->4777688]
}, Open  ]],
Cell[CellGroupData[{
Cell[24122, 892, 235, 8, 70, "Input",
 CellID->13590],
Cell[24360, 902, 1229, 41, 59, "Output",
 CellID->86949956]
}, Open  ]],
Cell[25604, 946, 121, 3, 70, "ExampleDelimiter",
 CellID->26099],
Cell[25728, 951, 227, 7, 70, "ExampleText",
 CellID->6161],
Cell[CellGroupData[{
Cell[25980, 962, 597, 21, 70, "Input",
 CellID->11047],
Cell[26580, 985, 479, 17, 36, "Output",
 CellID->599058879]
}, Open  ]],
Cell[CellGroupData[{
Cell[27096, 1007, 98, 3, 70, "Input",
 CellID->15290],
Cell[27197, 1012, 479, 17, 36, "Output",
 CellID->582916530]
}, Open  ]],
Cell[CellGroupData[{
Cell[27713, 1034, 131, 4, 70, "Input",
 CellID->29959],
Cell[27847, 1040, 944, 31, 118, "Output",
 CellID->580734267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28840, 1077, 223, 7, 70, "ExampleSection",
 CellID->22148],
Cell[29066, 1086, 212, 8, 70, "ExampleText",
 CellID->29444],
Cell[CellGroupData[{
Cell[29303, 1098, 438, 14, 70, "Input",
 CellID->24745],
Cell[29744, 1114, 3327, 59, 70, "Output",
 Evaluatable->False,
 CellID->537567854]
}, Open  ]],
Cell[33086, 1176, 120, 3, 70, "ExampleDelimiter",
 CellID->7210],
Cell[33209, 1181, 202, 8, 70, "ExampleText",
 CellID->4698],
Cell[CellGroupData[{
Cell[33436, 1193, 686, 22, 70, "Input",
 CellID->25616],
Cell[34125, 1217, 28614, 473, 70, "Output",
 Evaluatable->False,
 CellID->244658435]
}, Open  ]],
Cell[62754, 1693, 121, 3, 70, "ExampleDelimiter",
 CellID->24815],
Cell[62878, 1698, 76, 1, 70, "ExampleText",
 CellID->6064],
Cell[CellGroupData[{
Cell[62979, 1703, 588, 19, 70, "Input",
 CellID->29472],
Cell[63570, 1724, 182, 6, 49, "Output",
 CellID->173246359]
}, Open  ]],
Cell[63767, 1733, 121, 3, 70, "ExampleDelimiter",
 CellID->19593],
Cell[63891, 1738, 100, 3, 70, "ExampleText",
 CellID->32482],
Cell[CellGroupData[{
Cell[64016, 1745, 1540, 46, 70, "Input",
 CellID->89352364],
Cell[65559, 1793, 3925, 68, 70, "Output",
 Evaluatable->False,
 CellID->430335894]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69533, 1867, 233, 7, 70, "ExampleSection",
 CellID->15333],
Cell[69769, 1876, 76, 1, 70, "ExampleText",
 CellID->80512647],
Cell[CellGroupData[{
Cell[69870, 1881, 243, 8, 70, "Input",
 CellID->27587],
Cell[70116, 1891, 269, 9, 36, "Output",
 CellID->53858135]
}, Open  ]],
Cell[70400, 1903, 350, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[70775, 1920, 102, 3, 70, "Input",
 CellID->1064],
Cell[70880, 1925, 203, 7, 36, "Output",
 CellID->244846602]
}, Open  ]],
Cell[71098, 1935, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[71219, 1940, 251, 8, 70, "Input",
 CellID->404146284],
Cell[71473, 1950, 158, 5, 36, "Output",
 CellID->213190957]
}, Open  ]],
Cell[71646, 1958, 120, 3, 70, "ExampleDelimiter",
 CellID->8399],
Cell[71769, 1963, 231, 8, 70, "ExampleText",
 CellID->5032],
Cell[CellGroupData[{
Cell[72025, 1975, 130, 4, 70, "Input",
 CellID->17508],
Cell[72158, 1981, 370, 13, 48, "Output",
 CellID->137859373]
}, Open  ]],
Cell[CellGroupData[{
Cell[72565, 1999, 104, 3, 70, "Input",
 CellID->87597427],
Cell[72672, 2004, 190, 6, 36, "Output",
 CellID->838553208]
}, Open  ]],
Cell[72877, 2013, 121, 3, 70, "ExampleDelimiter",
 CellID->13438],
Cell[73001, 2018, 218, 8, 70, "ExampleText",
 CellID->23978],
Cell[CellGroupData[{
Cell[73244, 2030, 421, 14, 70, "Input",
 CellID->22638],
Cell[73668, 2046, 20003, 332, 70, "Output",
 Evaluatable->False,
 CellID->682065132]
}, Open  ]],
Cell[93686, 2381, 121, 3, 70, "ExampleDelimiter",
 CellID->30623],
Cell[93810, 2386, 70, 1, 70, "ExampleText",
 CellID->14852],
Cell[CellGroupData[{
Cell[93905, 2391, 187, 6, 70, "Input",
 CellID->15625],
Cell[94095, 2399, 2556, 77, 110, "Output",
 CellID->83583129]
}, Open  ]],
Cell[96666, 2479, 119, 3, 70, "ExampleDelimiter",
 CellID->744],
Cell[96788, 2484, 79, 1, 70, "ExampleText",
 CellID->27362],
Cell[CellGroupData[{
Cell[96892, 2489, 307, 11, 70, "Input",
 CellID->24769],
Cell[97202, 2502, 852, 31, 60, "Output",
 CellID->14765150]
}, Open  ]],
Cell[CellGroupData[{
Cell[98091, 2538, 223, 8, 70, "Input",
 CellID->26518],
Cell[98317, 2548, 2592, 75, 163, "Output",
 CellID->119792016]
}, Open  ]],
Cell[100924, 2626, 121, 3, 70, "ExampleDelimiter",
 CellID->10558],
Cell[101048, 2631, 55, 1, 70, "ExampleText",
 CellID->32143],
Cell[CellGroupData[{
Cell[101128, 2636, 251, 9, 70, "Input",
 CellID->23061],
Cell[101382, 2647, 488, 16, 51, "Output",
 CellID->543262089]
}, Open  ]],
Cell[101885, 2666, 121, 3, 70, "ExampleDelimiter",
 CellID->21300],
Cell[102009, 2671, 49, 1, 70, "ExampleText",
 CellID->31768],
Cell[CellGroupData[{
Cell[102083, 2676, 182, 6, 70, "Input",
 CellID->423],
Cell[102268, 2684, 1203, 39, 68, "Output",
 CellID->2323375]
}, Open  ]],
Cell[103486, 2726, 120, 3, 70, "ExampleDelimiter",
 CellID->5396],
Cell[103609, 2731, 57, 1, 70, "ExampleText",
 CellID->4566],
Cell[CellGroupData[{
Cell[103691, 2736, 175, 5, 70, "Input",
 CellID->25230],
Cell[103869, 2743, 755, 25, 61, "Output",
 CellID->56812734]
}, Open  ]],
Cell[104639, 2771, 121, 3, 70, "ExampleDelimiter",
 CellID->26260],
Cell[104763, 2776, 222, 7, 70, "ExampleText",
 CellID->12158],
Cell[CellGroupData[{
Cell[105010, 2787, 970, 32, 70, "Input",
 CellID->23425],
Cell[105983, 2821, 399, 13, 39, "Output",
 CellID->112536928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106431, 2840, 226, 7, 70, "ExampleSection",
 CellID->19312],
Cell[106660, 2849, 342, 13, 70, "ExampleText",
 CellID->452],
Cell[CellGroupData[{
Cell[107027, 2866, 129, 4, 70, "Input",
 CellID->5169],
Cell[107159, 2872, 192, 6, 36, "Output",
 CellID->68408008]
}, Open  ]],
Cell[CellGroupData[{
Cell[107388, 2883, 129, 4, 70, "Input",
 CellID->1570],
Cell[107520, 2889, 277, 7, 36, "Output",
 CellID->570109949]
}, Open  ]],
Cell[107812, 2899, 121, 3, 70, "ExampleDelimiter",
 CellID->29235],
Cell[107936, 2904, 121, 3, 70, "ExampleText",
 CellID->6890],
Cell[CellGroupData[{
Cell[108082, 2911, 507, 18, 70, "Input",
 CellID->1711],
Cell[108592, 2931, 270, 8, 36, "Output",
 CellID->145360413]
}, Open  ]],
Cell[CellGroupData[{
Cell[108899, 2944, 577, 20, 70, "Input",
 CellID->4750],
Cell[109479, 2966, 380, 12, 36, "Output",
 CellID->358434683]
}, Open  ]],
Cell[109874, 2981, 120, 3, 70, "ExampleDelimiter",
 CellID->7545],
Cell[109997, 2986, 110, 3, 70, "ExampleText",
 CellID->14767],
Cell[CellGroupData[{
Cell[110132, 2993, 159, 6, 70, "Input",
 CellID->21754],
Cell[110294, 3001, 180, 6, 49, "Output",
 CellID->650863422]
}, Open  ]],
Cell[CellGroupData[{
Cell[110511, 3012, 168, 6, 70, "Input",
 CellID->8217],
Cell[110682, 3020, 190, 6, 36, "Output",
 CellID->564095075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110921, 3032, 223, 7, 70, "ExampleSection",
 CellID->2815],
Cell[111147, 3041, 56, 1, 70, "ExampleText",
 CellID->27579],
Cell[CellGroupData[{
Cell[111228, 3046, 250, 8, 70, "Input",
 CellID->30837],
Cell[111481, 3056, 1913, 65, 115, "Output",
 CellID->3331802]
}, Open  ]],
Cell[113409, 3124, 121, 3, 70, "ExampleDelimiter",
 CellID->19269],
Cell[113533, 3129, 79, 1, 70, "ExampleText",
 CellID->11886],
Cell[113615, 3132, 663, 22, 70, "Input",
 CellID->13830],
Cell[CellGroupData[{
Cell[114303, 3158, 349, 12, 70, "Input",
 CellID->10809],
Cell[114655, 3172, 321, 10, 36, "Output",
 CellID->275933573]
}, Open  ]],
Cell[114991, 3185, 120, 3, 70, "ExampleDelimiter",
 CellID->7321],
Cell[115114, 3190, 143, 6, 70, "ExampleText",
 CellID->18319],
Cell[CellGroupData[{
Cell[115282, 3200, 478, 15, 70, "Input",
 CellID->29881],
Cell[115763, 3217, 2905, 52, 70, "Output",
 Evaluatable->False,
 CellID->525188155]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[118729, 3276, 310, 9, 70, "SeeAlsoSection",
 CellID->2307],
Cell[119042, 3287, 1417, 53, 70, "SeeAlso",
 CellID->19912]
}, Open  ]],
Cell[CellGroupData[{
Cell[120496, 3345, 314, 9, 70, "TutorialsSection",
 CellID->28134],
Cell[120813, 3356, 163, 3, 70, "Tutorials",
 CellID->22972],
Cell[120979, 3361, 182, 4, 70, "Tutorials",
 CellID->24348]
}, Open  ]],
Cell[CellGroupData[{
Cell[121198, 3370, 321, 9, 70, "RelatedLinksSection",
 CellID->16453],
Cell[121522, 3381, 182, 4, 70, "RelatedLinks"],
Cell[121707, 3387, 198, 4, 70, "RelatedLinks"],
Cell[121908, 3393, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[122329, 3411, 319, 9, 70, "MoreAboutSection",
 CellID->154981321],
Cell[122651, 3422, 151, 3, 70, "MoreAbout",
 CellID->240943129],
Cell[122805, 3427, 144, 3, 70, "MoreAbout",
 CellID->20474719],
Cell[122952, 3432, 150, 3, 70, "MoreAbout",
 CellID->41714103],
Cell[123105, 3437, 157, 3, 70, "MoreAbout",
 CellID->393515112]
}, Open  ]],
Cell[123277, 3443, 27, 0, 70, "History"],
Cell[123307, 3445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

