(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48864,       1856]
NotebookOptionsPosition[     37991,       1471]
NotebookOutlinePosition[     39397,       1512]
CellTagsIndexPosition[     39311,       1507]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sinh" :> Documentation`HelpLookup["paclet:ref/Sinh"], 
          "ArcCosh" :> Documentation`HelpLookup["paclet:ref/ArcCosh"], 
          "ArcSin" :> Documentation`HelpLookup["paclet:ref/ArcSin"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"], 
          "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sinh\"\>", 2->"\<\"ArcCosh\"\>", 
       3->"\<\"ArcSin\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Hyperbolic Functions\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcSinh", "ObjectName",
 CellID->30665],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcSinh",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcSinh"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse hyperbolic sine ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sinh", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcSinh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSinh"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "i"}], " ", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "i"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "i"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"+", "i"}], " ", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->12755]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15824988],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->38735538],

Cell["Evaluate numerically:", "ExampleText",
 CellID->421737812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", "1.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8886193],

Cell[BoxData["1.1947632172871094`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->814820220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150653341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110764896],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529194447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30713750],

Cell["Series expansion:", "ExampleText",
 CellID->20485981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244283407],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[-5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1016034877]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19917],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->33822123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"1.5", "+", 
   RowBox[{"0.7", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->681513570],

Cell[BoxData[
 RowBox[{"1.256224290548298`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3776375126004896`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1855700442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106023922],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->9904269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "1", "]"}], ",", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->584665810],

Cell[BoxData["0.\
881373587019543025232609324979792309028160328261635410753295608653377184222026\
0878337068919102560428567398161922299`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->852323313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43295368],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->290155055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  "1.000000000000000000000000000000000000000000000000000000", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->235781622],

Cell[BoxData["0.\
8813735870195430252326093249797923090281603282616354107533008174776`54.\
095675029275306"], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1281996101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581922953],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->84932575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"{", 
   RowBox[{"0.1", ",", "0.2", ",", "0.3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481445295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.09983407889920758`", ",", "0.19869011034924142`", ",", 
   "0.29567304756342244`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->805039156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10153993],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->169533667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45555883],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1146118792]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->177004872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357920636],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcSinh", "[", "x", "]"}]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2037707201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278640855],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"ArcSin", "[", "x", "]"}]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1823208498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341603016],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->17928106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSinh", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->885521475],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sinh", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{49, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->221066843]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->96316276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693031855],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSinh", "[", "1", "]"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], 
    RowBox[{"48", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "6"]}], 
    RowBox[{"2880", " ", 
     SqrtBox["2"]}]], "+", 
   FractionBox[
    RowBox[{"491", " ", 
     SuperscriptBox["x", "8"]}], 
    RowBox[{"322560", " ", 
     SqrtBox["2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    ArcSinh[1], 0, Rational[-1, 2] 2^Rational[-1, 2], 0, Rational[-1, 48] 
    2^Rational[-1, 2], 0, Rational[11, 2880] 2^Rational[-1, 2], 0, 
    Rational[491, 322560] 2^Rational[-1, 2]}, 0, 10, 1],
  Editable->False]], "Output",
 ImageSize->{393, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323720991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53578059],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->87437617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128882002],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcSinh", "[", 
      FractionBox["1", "2"], "]"}]}], ",", 
    RowBox[{"ArcSinh", "[", 
     FractionBox["1", "2"], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{256, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1202617886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->916885233],

Cell["Infinite arguments generate exact results:", "ExampleText",
 CellID->111044719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSinh", "[", "Infinity", "]"}], ",", 
   RowBox[{"ArcSinh", "[", "ComplexInfinity", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175646384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", "ComplexInfinity"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282724438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12060],

Cell[TextData[{
 "Compute the length of hyperbola ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "2"], "-", 
     SuperscriptBox["x", "2"]}], "\[LongEqual]", "1"}], TraditionalForm]], 
  "InlineMath"],
 " from the base to given ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->962713930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"t", "^", "2"}]}]], ",", "t"}], "]"}], "^", "2"}], "+", 
     "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "x"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364859164],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"EllipticE", "[", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"ArcSinh", "[", "x", "]"}]}], ",", "2"}], "]"}]}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1515802302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"x", "\[Rule]", "3"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4896192],

Cell[BoxData[
 RowBox[{"3.75781461299273042784426524689403174796`20.15051499783199", "+", 
  RowBox[{"0``19.575579646905226", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490785353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113372206],

Cell["Solve a differential equation:", "ExampleText",
 CellID->2857874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}], " ", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31573443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"ArcSinh", "[", "x", "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"ArcSinh", "[", "x", "]"}], "2"]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{273, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144739744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31175],

Cell["Compose with the inverse function:", "ExampleText",
 CellID->80512647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    RowBox[{"Sinh", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Sinh", "[", 
    RowBox[{"ArcSinh", "[", "z", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360154656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    RowBox[{"Sinh", "[", "z", "]"}], "]"}], ",", "z"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1689389004]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the ",
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->177493682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207373990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1679693241]
}, Open  ]],

Cell["Alternatively, evaluate under additional assumptions:", "ExampleText",
 CellID->409086740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"ArcSinh", "[", 
    RowBox[{"Sinh", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"z", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->146068558],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1931761672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95023437],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " using logarithm:"
}], "ExampleText",
 CellID->97189382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSinh", "[", "z", "]"}], "//", "TrigToExp"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24723274],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"z", "+", 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["z", "2"]}]]}], "]"}]], "Output",
 ImageSize->{110, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1460645958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129068254],

Cell[BoxData[
 RowBox[{"ArcSinh", "[", "z", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1191047249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89209706],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve an equation in terms of ",
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->215676816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], "\[Equal]", "y"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42335745],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "-", 
      RowBox[{"ArcSinh", "[", "y", "]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"ArcSinh", "[", "y", "]"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
       RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{521, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1236040256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10958284],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcSinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSinh"]], "InlineFormula"],
 " is a special case of some special functions:"
}], "ExampleText",
 CellID->550797062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"3", "/", "2"}], ",", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312503018],

Cell[BoxData[
 RowBox[{"ArcSinh", "[", "x", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1519265161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65222460],

Cell["Integrals:", "ExampleText",
 CellID->53641806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSinh", "[", "x", "]"}], "^", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->613948047],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        RowBox[{"ArcSinh", "[", "x", "]"}]}], ")"}], 
      RowBox[{"-", "a"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcSinh", "[", "x", "]"}], "a"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "+", "a"}], ",", 
       RowBox[{"-", 
        RowBox[{"ArcSinh", "[", "x", "]"}]}]}], "]"}]}], "-", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"1", "+", "a"}], ",", 
      RowBox[{"ArcSinh", "[", "x", "]"}]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{550, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->708998097]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9074],

Cell[TextData[{
 "Generically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "\[NotEqual]", "z"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"Sinh", "[", 
   RowBox[{"30.", " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5169],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.4159265358979327`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1891742723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"ArcSin", "[", 
   RowBox[{"30.", " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1570],

Cell[BoxData[
 RowBox[{"29.999999999999993`", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{36, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1024551626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7545],

Cell["\<\
When using input in traditional form, parentheses are needed around the \
argument:\
\>", "ExampleText",
 CellID->14767],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sinh", 
    RowBox[{"-", "1"}]], "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->21754],

Cell[BoxData[
 FractionBox["x", "sinh"]], "Output",
 ImageSize->{37, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1115296536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sinh", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{"ArcSinh", "[", "x", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1551609536]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32501],

Cell[TextData[{
 "Compute 100,000 digits of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sinh", 
     RowBox[{"-", "1"}]], "(", "1", ")"}], TraditionalForm]], "InlineMath"],
 ", and show the first and last 20 digits:"
}], "ExampleText",
 CellID->109948936],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"ArcSinh", "[", "1", "]"}], ",", 
     RowBox[{"10", "^", "5"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128063979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"ToString", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"StringTake", "[", 
       RowBox[{"s", ",", "20"}], "]"}], ",", "\"\<\[CenterEllipsis]\>\"", ",",
       
      RowBox[{"StringTake", "[", 
       RowBox[{"s", ",", 
        RowBox[{"-", "20"}]}], "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->746610611],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"0.881373587019543025\"\>", 
   "\[InvisibleSpace]", "\<\"\[CenterEllipsis]\"\>", 
   "\[InvisibleSpace]", "\<\"68849909192694622718\"\>"}],
  Row[{"0.881373587019543025", "\[CenterEllipsis]", 
    "68849909192694622718"}]]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1007546031]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6824],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sinh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sinh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCosh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCosh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31999]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11417],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->22844]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3554],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseHyperbolicSine.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcSinh/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->399403084],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->86424676],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->96728498],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->780795469]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcSinh - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 38.0808598}", "context" -> "System`", 
    "keywords" -> {
     "arcsh", "argsinh", "arsh", "arsinh", "asinh", 
      "inverse sine hyperbolic function", "inverse sinh"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcSinh[z] gives the inverse hyperbolic sine sinh -1 (z) of the complex \
number z. ", 
    "synonyms" -> {
     "arc sinh", "arcsenh", "arcsinh", "areasinh", "arsinh", "asinh", 
      "invsinh"}, "title" -> "ArcSinh", "type" -> "Symbol", "uri" -> 
    "ref/ArcSinh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6036, 206, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15824988]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39169, 1500}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2471, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3094, 85, 45, 1, 70, "ObjectName",
 CellID->30665],
Cell[3142, 88, 759, 25, 70, "Usage",
 CellID->14552]
}, Open  ]],
Cell[CellGroupData[{
Cell[3938, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4416, 135, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4539, 141, 241, 8, 70, "Notes",
 CellID->9487],
Cell[4783, 151, 216, 7, 70, "Notes",
 CellID->31226],
Cell[5002, 160, 199, 7, 70, "Notes",
 CellID->28162],
Cell[5204, 169, 795, 32, 70, "Notes",
 CellID->12755]
}, Closed]],
Cell[CellGroupData[{
Cell[6036, 206, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15824988],
Cell[CellGroupData[{
Cell[6420, 220, 147, 5, 70, "ExampleSection",
 CellID->38735538],
Cell[6570, 227, 64, 1, 70, "ExampleText",
 CellID->421737812],
Cell[CellGroupData[{
Cell[6659, 232, 103, 3, 28, "Input",
 CellID->8886193],
Cell[6765, 237, 176, 5, 36, "Output",
 CellID->814820220]
}, Open  ]],
Cell[6956, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->150653341],
Cell[CellGroupData[{
Cell[7106, 252, 240, 8, 28, "Input",
 CellID->110764896],
Cell[7349, 262, 2323, 42, 136, "Output",
 Evaluatable->False,
 CellID->529194447]
}, Open  ]],
Cell[9687, 307, 124, 3, 70, "ExampleDelimiter",
 CellID->30713750],
Cell[9814, 312, 59, 1, 70, "ExampleText",
 CellID->20485981],
Cell[CellGroupData[{
Cell[9898, 317, 220, 7, 70, "Input",
 CellID->244283407],
Cell[10121, 326, 844, 29, 54, "Output",
 CellID->1016034877]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11014, 361, 216, 7, 70, "ExampleSection",
 CellID->19917],
Cell[11233, 370, 73, 1, 70, "ExampleText",
 CellID->33822123],
Cell[CellGroupData[{
Cell[11331, 375, 149, 5, 70, "Input",
 CellID->681513570],
Cell[11483, 382, 273, 7, 36, "Output",
 CellID->1855700442]
}, Open  ]],
Cell[11771, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->106023922],
Cell[11899, 397, 68, 1, 70, "ExampleText",
 CellID->9904269],
Cell[CellGroupData[{
Cell[11992, 402, 157, 5, 70, "Input",
 CellID->584665810],
Cell[12152, 409, 284, 7, 54, "Output",
 CellID->852323313]
}, Open  ]],
Cell[12451, 419, 124, 3, 70, "ExampleDelimiter",
 CellID->43295368],
Cell[12578, 424, 113, 3, 70, "ExampleText",
 CellID->290155055],
Cell[CellGroupData[{
Cell[12716, 431, 163, 5, 70, "Input",
 CellID->235781622],
Cell[12882, 438, 251, 7, 36, "Output",
 CellID->1281996101]
}, Open  ]],
Cell[13148, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->581922953],
Cell[13276, 453, 215, 7, 70, "ExampleText",
 CellID->84932575],
Cell[CellGroupData[{
Cell[13516, 464, 166, 5, 70, "Input",
 CellID->481445295],
Cell[13685, 471, 278, 9, 36, "Output",
 CellID->805039156]
}, Open  ]],
Cell[13978, 483, 124, 3, 70, "ExampleDelimiter",
 CellID->10153993],
Cell[14105, 488, 91, 1, 70, "ExampleText",
 CellID->169533667],
Cell[CellGroupData[{
Cell[14221, 493, 102, 3, 70, "Input",
 CellID->45555883],
Cell[14326, 498, 159, 5, 36, "Output",
 CellID->1146118792]
}, Open  ]],
Cell[14500, 506, 90, 1, 70, "ExampleText",
 CellID->177004872],
Cell[CellGroupData[{
Cell[14615, 511, 121, 4, 70, "Input",
 CellID->357920636],
Cell[14739, 517, 210, 7, 36, "Output",
 CellID->2037707201]
}, Open  ]],
Cell[CellGroupData[{
Cell[14986, 529, 126, 4, 70, "Input",
 CellID->278640855],
Cell[15115, 535, 226, 7, 36, "Output",
 CellID->1823208498]
}, Open  ]],
Cell[15356, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->341603016],
Cell[15484, 550, 202, 7, 70, "ExampleText",
 CellID->17928106],
Cell[CellGroupData[{
Cell[15711, 561, 141, 4, 70, "Input",
 CellID->885521475],
Cell[15855, 567, 279, 9, 52, "Output",
 CellID->221066843]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16183, 582, 239, 7, 70, "ExampleSection",
 CellID->15793],
Cell[16425, 591, 208, 7, 70, "ExampleText",
 CellID->96316276],
Cell[CellGroupData[{
Cell[16658, 602, 212, 7, 70, "Input",
 CellID->693031855],
Cell[16873, 611, 1098, 36, 58, "Output",
 CellID->323720991]
}, Open  ]],
Cell[17986, 650, 124, 3, 70, "ExampleDelimiter",
 CellID->53578059],
Cell[18113, 655, 211, 7, 70, "ExampleText",
 CellID->87437617],
Cell[CellGroupData[{
Cell[18349, 666, 261, 9, 70, "Input",
 CellID->128882002],
Cell[18613, 677, 383, 13, 51, "Output",
 CellID->1202617886]
}, Open  ]],
Cell[19011, 693, 125, 3, 70, "ExampleDelimiter",
 CellID->916885233],
Cell[19139, 698, 85, 1, 70, "ExampleText",
 CellID->111044719],
Cell[CellGroupData[{
Cell[19249, 703, 206, 6, 70, "Input",
 CellID->175646384],
Cell[19458, 711, 228, 7, 36, "Output",
 CellID->282724438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19735, 724, 223, 7, 70, "ExampleSection",
 CellID->12060],
Cell[19961, 733, 363, 14, 70, "ExampleText",
 CellID->962713930],
Cell[CellGroupData[{
Cell[20349, 751, 490, 17, 70, "Input",
 CellID->364859164],
Cell[20842, 770, 346, 11, 36, "Output",
 CellID->1515802302]
}, Open  ]],
Cell[CellGroupData[{
Cell[21225, 786, 175, 6, 70, "Input",
 CellID->4896192],
Cell[21403, 794, 293, 7, 36, "Output",
 CellID->490785353]
}, Open  ]],
Cell[21711, 804, 125, 3, 70, "ExampleDelimiter",
 CellID->113372206],
Cell[21839, 809, 71, 1, 70, "ExampleText",
 CellID->2857874],
Cell[CellGroupData[{
Cell[21935, 814, 701, 23, 70, "Input",
 CellID->31573443],
Cell[22639, 839, 506, 18, 51, "Output",
 CellID->144739744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23194, 863, 233, 7, 70, "ExampleSection",
 CellID->31175],
Cell[23430, 872, 76, 1, 70, "ExampleText",
 CellID->80512647],
Cell[CellGroupData[{
Cell[23531, 877, 251, 8, 70, "Input",
 CellID->360154656],
Cell[23785, 887, 273, 9, 36, "Output",
 CellID->1689389004]
}, Open  ]],
Cell[24073, 899, 352, 13, 70, "ExampleText",
 CellID->177493682],
Cell[CellGroupData[{
Cell[24450, 916, 107, 3, 70, "Input",
 CellID->207373990],
Cell[24560, 921, 204, 7, 36, "Output",
 CellID->1679693241]
}, Open  ]],
Cell[24779, 931, 96, 1, 70, "ExampleText",
 CellID->409086740],
Cell[CellGroupData[{
Cell[24900, 936, 230, 7, 70, "Input",
 CellID->146068558],
Cell[25133, 945, 159, 5, 36, "Output",
 CellID->1931761672]
}, Open  ]],
Cell[25307, 953, 124, 3, 70, "ExampleDelimiter",
 CellID->95023437],
Cell[25434, 958, 338, 13, 70, "ExampleText",
 CellID->97189382],
Cell[CellGroupData[{
Cell[25797, 975, 134, 4, 70, "Input",
 CellID->24723274],
Cell[25934, 981, 277, 10, 48, "Output",
 CellID->1460645958]
}, Open  ]],
Cell[CellGroupData[{
Cell[26248, 996, 105, 3, 70, "Input",
 CellID->129068254],
Cell[26356, 1001, 192, 6, 36, "Output",
 CellID->1191047249]
}, Open  ]],
Cell[26563, 1010, 124, 3, 70, "ExampleDelimiter",
 CellID->89209706],
Cell[26690, 1015, 339, 13, 70, "ExampleText",
 CellID->215676816],
Cell[CellGroupData[{
Cell[27054, 1032, 191, 7, 70, "Input",
 CellID->42335745],
Cell[27248, 1041, 736, 21, 36, "Output",
 CellID->1236040256]
}, Open  ]],
Cell[27999, 1065, 124, 3, 70, "ExampleDelimiter",
 CellID->10958284],
Cell[28126, 1070, 220, 7, 70, "ExampleText",
 CellID->550797062],
Cell[CellGroupData[{
Cell[28371, 1081, 301, 10, 70, "Input",
 CellID->312503018],
Cell[28675, 1093, 192, 6, 36, "Output",
 CellID->1519265161]
}, Open  ]],
Cell[28882, 1102, 124, 3, 70, "ExampleDelimiter",
 CellID->65222460],
Cell[29009, 1107, 52, 1, 70, "ExampleText",
 CellID->53641806],
Cell[CellGroupData[{
Cell[29086, 1112, 191, 7, 70, "Input",
 CellID->613948047],
Cell[29280, 1121, 766, 26, 51, "Output",
 CellID->708998097]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30095, 1153, 225, 7, 70, "ExampleSection",
 CellID->9074],
Cell[30323, 1162, 342, 13, 70, "ExampleText",
 CellID->452],
Cell[CellGroupData[{
Cell[30690, 1179, 155, 5, 70, "Input",
 CellID->5169],
Cell[30848, 1186, 257, 7, 36, "Output",
 CellID->1891742723]
}, Open  ]],
Cell[CellGroupData[{
Cell[31142, 1198, 153, 5, 70, "Input",
 CellID->1570],
Cell[31298, 1205, 211, 6, 36, "Output",
 CellID->1024551626]
}, Open  ]],
Cell[31524, 1214, 120, 3, 70, "ExampleDelimiter",
 CellID->7545],
Cell[31647, 1219, 130, 4, 70, "ExampleText",
 CellID->14767],
Cell[CellGroupData[{
Cell[31802, 1227, 160, 6, 70, "Input",
 CellID->21754],
Cell[31965, 1235, 182, 6, 49, "Output",
 CellID->1115296536]
}, Open  ]],
Cell[CellGroupData[{
Cell[32184, 1246, 169, 6, 70, "Input",
 CellID->8217],
Cell[32356, 1254, 192, 6, 36, "Output",
 CellID->1551609536]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32597, 1266, 224, 7, 70, "ExampleSection",
 CellID->32501],
Cell[32824, 1275, 272, 9, 70, "ExampleText",
 CellID->109948936],
Cell[33099, 1286, 228, 8, 70, "Input",
 CellID->128063979],
Cell[CellGroupData[{
Cell[33352, 1298, 497, 16, 70, "Input",
 CellID->746610611],
Cell[33852, 1316, 415, 11, 36, "Output",
 CellID->1007546031]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34328, 1334, 310, 9, 70, "SeeAlsoSection",
 CellID->6824],
Cell[34641, 1345, 1178, 44, 70, "SeeAlso",
 CellID->31999]
}, Open  ]],
Cell[CellGroupData[{
Cell[35856, 1394, 314, 9, 70, "TutorialsSection",
 CellID->11417],
Cell[36173, 1405, 182, 4, 70, "Tutorials",
 CellID->22844]
}, Open  ]],
Cell[CellGroupData[{
Cell[36392, 1414, 320, 9, 70, "RelatedLinksSection",
 CellID->3554],
Cell[36715, 1425, 192, 4, 70, "RelatedLinks"],
Cell[36910, 1431, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37146, 1440, 319, 9, 70, "MoreAboutSection",
 CellID->399403084],
Cell[37468, 1451, 150, 3, 70, "MoreAbout",
 CellID->86424676],
Cell[37621, 1456, 150, 3, 70, "MoreAbout",
 CellID->96728498],
Cell[37774, 1461, 145, 3, 70, "MoreAbout",
 CellID->780795469]
}, Open  ]],
Cell[37934, 1467, 27, 0, 70, "History"],
Cell[37964, 1469, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

