(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79034,       2587]
NotebookOptionsPosition[     66637,       2150]
NotebookOutlinePosition[     68151,       2192]
CellTagsIndexPosition[     68065,       2187]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arg" :> Documentation`HelpLookup["paclet:ref/Arg"], "Tan" :> 
          Documentation`HelpLookup["paclet:ref/Tan"], "ArcCot" :> 
          Documentation`HelpLookup["paclet:ref/ArcCot"], "ArcTanh" :> 
          Documentation`HelpLookup["paclet:ref/ArcTanh"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Arg\"\>", 2->"\<\"Tan\"\>", 
       3->"\<\"ArcCot\"\>", 4->"\<\"ArcTanh\"\>", 5->"\<\"Degree\"\>", 
       6->"\<\"TrigToExp\"\>", 7->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Inverse Functions\"\>", 3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArcTan", "ObjectName",
 CellID->28428],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcTan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcTan"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc tangent ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["tan", 
         RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArcTan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArcTan"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the arc tangent of ",
     Cell[BoxData[
      FormBox[
       FractionBox["y", "x"], TraditionalForm]], "InlineMath"],
     ", taking into account which quadrant the point ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
     " is in. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16678]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["All results are given in radians. ", "Notes",
 CellID->101],

Cell[TextData[{
 "For real ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ", the results are always in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20949],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "i"}], " ", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "i"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "i"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"+", "i"}], " ", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->2364],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " is complex, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "i"}], " ", "log", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "i", "y"}], ")"}], "/", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". When ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "=", "1"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " gives the number ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "cos\[Phi]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "sin\[Phi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->26385]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->721973089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->399539159],

Cell["Results are in radians:", "ExampleText",
 CellID->27873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29935],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32571159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30096],

Cell[TextData[{
 "Divide by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to get results in degrees:"
}], "ExampleText",
 CellID->20381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "1", "]"}], "/", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21561],

Cell[BoxData["45.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15299932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5584],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " gives the angle of the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28499],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405828685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11849],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", " ", "\[Pi]"}], "4"]}]], "Output",
 ImageSize->{34, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260144808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6850],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmEtonUUUxyff/e5N0uah1tqbaDW+X9RXq7Zp01Rj0xciLsSFdBGDkCy0
UuNGN7rRjW4UgoFiFz7Ax6IiVIQWxEJpQSyIBVFBKkhdWASLi4Bw/Z1zvud8
c2+auPNy79z5Zs75z3/mnDNz5nt0am7mmWen5manp0Z2HZx6fmZ2+oWRyQMH
aap1Oefm+e1vOuotavrb22q1XE1q+nF7pHA1KeNz5/488+1vfC9c+HuCFhEr
9Dc+eP/Mgec+5/v4Y++Njy3snDgU8eDqC++cPvzuN8eP/YwqGG40OEaPlIOL
i//YGICh9Oorx4DY/9RH4IFK/c03TtCVIG0MIl0uZR8kkfrsyFmGzzAoX5w7
CvCJr385f/6vDaVZNKVcBe7pU78i8vJLXz75xIf79hw2DcAgd1twxPVS9ly8
uGiaDMfkZ2eOMDQtNwd1bpCy++z3vzMdRoAcJXTh7a6nL0JBreFu0dUFiLmz
COAixmDXBnFvl7IOrkm//tpX1N01Qdk7VZZpfXH0B2D5si5uOCh7l/oAWKzL
9NOfshy9yepFnrwwr5dmcI/q/vTjH+YfgPR4OuZh+bNzcZDFfdrK4HClTwV8
yUvF2qStLD/TgZtyXhon95f7VQh/MYusmMcDKocVsBhfKv6KXirSZm2FCzYC
Ri3RSCxRL3HfopL4FNxxJTcQxBstSAlef1BqayqVjNpXsv027cXB8ESprg5i
jGkr8YI5pLoqKLVdW/EgHECqvaWRrJf4wZ4SRb1BjPHUg4CRqu+JJrVDW7EG
iynV7rYzl/FraS/7i3hlNQJGKxZUnTqrRthnjR08NU4jreoHMQtP4HbyjOr4
pskmCGexmu/dVY10Rn6cdJJXObZRGSHMLF3D7uS/zGKNp9NMVuIKbQcVbLF1
zZNbl8hd7bVfFkQdKjyLFaz/k4+/e/utk1L147HpyYdH6Us4GDn7RAl6HLCU
P6coWRF/P07XQM85Kwtc1odQ69lcEin/PFjnoaiWllFbTJhyOlK2wWwm2mWs
4YqfrNUW6EHSWoYqMsMlrJD9pPeqVrIDJB4XJVhRgJ3ZaLe2sjWxQckc9hVa
ORPYSfJW9cgasZbYcm+hlf0kWTxrzfIoQFqZr8+7zB0KTHw/WOrZj7/l6v/f
xutq+XEgVT9qhpbo958HW6kda2o0vCrpmcx6Uh81392dt9etPffEXVlflLqA
KRV6Ui0+JBVylBT6GlkfH9vvJ9v0mt9OlkY0n8vPiUdy3WLm1sr9vr2UjzWh
UpWzsGW7QvEsjD1806yeHP5p6++/scfg4f+EA58kv1kOTs2lJ1y+cz3URr/d
yWnP5F8YW3b8TvqdIqChz9ywuC9JdUfJIsWTVf4t40EUBamOB61sc4YV3CRD
DEsZVp7dbc+kZCTL4vIsaiyIYXka629XgzZShmXZtvDZFpSy7BIUsMSiW0t8
LH/NM9XRIEZ/YTVFaktQaiCdOSMJn82ZlAgNpjxgS47lHsws0unGVDmfZL7E
itzK9JaQZNNeLHa8Gei+GMOQOWMkKpuWgSQCa9KZ4gnCZOMKmVypEngUTEh6
Cbt7V4ik53yMHVkbwEC6exlIaVbgYmYDAlw4vjdkFvJvTZVTQrJ2e6VA3Evc
3hH0EM04GliQDYKbOERZQ9b/1qD0dSoNI4xkLx0AZ2Y3ZdLC50Z56mZ8MKEO
LE5KdMn9dSSIq28femGJQxOJKO2cOAT77CWIZa8VPX2PsNrexxTfhqDK2PYO
RrTXlvipHfqZJL3wt3cvKI6PLRAJ9iaFdnol0geCI+u9ukG/vU1hNDDQjgBx
NSo8skguolPjFDSZfxxEs5slaEhJkqdasb1YMvepZXr5vWPe3KXrX05AjMU=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->51594255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22769],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "5"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "7"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "9"], "-", 
   FractionBox[
    SuperscriptBox["x", "11"], "11"], "+", 
   FractionBox[
    SuperscriptBox["x", "13"], "13"], "-", 
   FractionBox[
    SuperscriptBox["x", "15"], "15"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "16"],
    SeriesData[$CellContext`x, 0, {}, 1, 16, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[1, 5], 0, 
    Rational[-1, 7], 0, 
    Rational[1, 9], 0, 
    Rational[-1, 11], 0, 
    Rational[1, 13], 0, 
    Rational[-1, 15]}, 1, 16, 1],
  Editable->False]], "Output",
 ImageSize->{282, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394691793]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16467],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->40174808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116882886],

Cell[BoxData[
 RowBox[{"1.2334258556831201`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.12367406045902668`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561689246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223317723],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->88315731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406380963],

Cell[BoxData["0.\
4636476090008061162142562314612144020285370542861202638109332031838`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48391413]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->18659275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", "0.50000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399269772],

Cell[BoxData["0.4636476090008061162142562314612144020285370542861208606035`40.\
76309803750571"], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134483100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245924666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->397001889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"{", 
   RowBox[{"0.1", ",", "0.2", ",", "0.3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216118936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.09966865249116204`", ",", "0.19739555984988078`", ",", 
   "0.2914567944778671`"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150133129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112109847],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->306540079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcTan", "[", "0", "]"}], ",", 
   RowBox[{"ArcTan", "[", "1", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220994862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["\[Pi]", "4"]}], "}"}]], "Output",
 ImageSize->{49, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70574974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14152207],

Cell["Parity transformations are automatically applied:", "ExampleText",
 CellID->295677626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235359564],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcTan", "[", "x", "]"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->941055828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->530678434],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"ArcTanh", "[", "x", "]"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168490167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19545242],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->215421212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592624624],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["tan", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->179167271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTan", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41188240],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["tan", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{58, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->510636917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12083],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->104876922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"{", 
   RowBox[{"Infinity", ",", 
    RowBox[{"I", " ", "Infinity"}], ",", 
    RowBox[{"-", "Infinity"}], ",", 
    RowBox[{
     RowBox[{"-", "I"}], " ", "Infinity"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485059841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "2"], ",", 
   FractionBox["\[Pi]", "2"], ",", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}]}], "}"}]], "Output",
 ImageSize->{116, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328271010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"Infinity", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304287381],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218256324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->726536818],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5445478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287937181],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->68190708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tan", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1294035],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[17, 315], 0, 
    Rational[62, 2835]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178840328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269126107],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32351543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366756755],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->97758880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20487026],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "4"]}], ",", 
    RowBox[{"ArcTan", "[", "3", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{182, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320376416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11158],

Cell[TextData[{
 "Find angles of the right triangle with sides ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 " and hypotenuse ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->240083676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"4", ",", "3"}], "]"}], ",", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"3", ",", "4"}], "]"}]}], "}"}], "/", "Degree"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314912519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"36.86989764584402`", ",", "53.13010235415598`"}], "}"}]], "Output",\

 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32394336]
}, Open  ]],

Cell[TextData[{
 "They total to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["90", "\[Degree]"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->257310361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->645679116],

Cell[BoxData["90.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129692411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->441634],

Cell[TextData[{
 "Find integrals of rational functions in terms of ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->289691853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", " ", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122469095],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434818239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732296731],

Cell["Addition theorem for tangent function:", "ExampleText",
 CellID->183417949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{
     RowBox[{"ArcTan", "[", "x", "]"}], "+", 
     RowBox[{"ArcTan", "[", "y", "]"}]}], "]"}], "//", "TrigExpand"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87639809],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  RowBox[{"1", "-", 
   RowBox[{"x", " ", "y"}]}]]], "Output",
 ImageSize->{45, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39640757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7791063],

Cell["Solve a differential equation:", "ExampleText",
 CellID->353107707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}], " ", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"2", " ", "x", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270483439],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"ArcTan", "[", "x", "]"}]}], "+", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{257, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493579725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->910005128],

Cell[TextData[{
 "Branch cuts of ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " run along the imaginary axis:"
}], "ExampleText",
 CellID->286484814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5918093],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydvQd4HMeV7zvbMwCjJMqWk+y1fX03vPvehXftjXef9+569z17r3fhbK92
tdeyLFKJFEWJFEkxgEQics4ZmEGawQwGeTDIwCDnROTInCSSokRJJv7fu3VO
VQPgENLze/gKPd09PdV1fnXqVOiq0/7PH3l532vPH3nlhee//v03nz/08isv
HP76915/U5wy/p7BYKgR/+lfNIj9/0fs8X8NAPHF77x9VWxN4off46P9tDWK
Qz7Szx7YdJZ2/28++5rX2f/rU87SXQymjbOb76eJo+9/QuoOiS1F9l0+OqiO
DEaxs2/fPtr9+/UUauoLvo/4Vt7ncSWfHx/+WMXwBXW9L18vL964fjMB+buf
eEn1lPq9vKG82Ic363Gp3/uq+5u8YvivW8b7pErfTj6/kS7N67rdXsf/x5ax
PaFi26WfV1S807Lrd4rtMSXz7nXZzZNQMfp4XbvtkfzemuMurzg1EaXBaDmv
567vFvHSdd9cz01NyeedGzv0GC2ToAiZJn2qy7yv/yvefXZTeozq1yb6lUn+
Wkbgnaq/4N8+o3JaT43RMimvUr/TOJ5Clk1sRdC2iOvPOa5fqjh05iaL4lIo
JaBoWCKxXzgl4qbNpli8c/jPONafe8XqQ9JRTL4UjR45JW8KpqJPj/HbHONP
dcpe327fRJ/1QHyKUDgJX7oJnRHxiyBuRnfSiqY/9W7f4rv9lYr1C15yGLZZ
JiDvIG9C4kxK2IZtRSyVvJ3cIW5GOvIRty3Ww1b69qd83798RJuf8kqBUSSA
M7xQ3l+jzQZVlYTz4LuaijkhxVJ6cWepizIJnIBNqaCvvvUJqdCtxToHH0qG
gC1oMBBBQGGQKaAcoT1KRjEHg0YbdW/iounp8SmZRsmMClux+eYnpOqJR1Jl
lunhwCdEqjgdJkmFYJyHj0iJUdyUy5pMrDjypbt/imb4fUIq9Ls/ppdk87go
yeL+PoUTSj9EKKK8UlS04vMyZp1MiUqPspysaKUz0EpnPzVF//UTUrQLXlrr
I5IkPsRWBMs4WYgJaIX0PynTTBpDqSKNKWGlUWni35tEYkS6Sjl7jOLDKFIm
dYmSuKlWesS26yVpp3eafAvGYB6DTBOp0jgoVcZCJjeplIiyjRRLpM1E6dol
TpROqy/FjkiLldMmttZZaXOtMm0afVrnHkqTccs0/r2XHhlF0gy+64mzjCtV
p7TJPBRJ8imeVOokQsl5mYtaKen4egJFGqZhFEljTbPNQga6l49t7pHUaer+
Ml//uzp6XCdmyh+leEXiRNDMnEZOnUVPo0qfKHUTpHCsc8UKH2Xpecpbo0ij
ptLGlsPKDG0zlDSRTG1TCk22+U/l9184pd/xSqlGCTUWjFI6OTkirSbKXz4Q
iSziIIyB0L4SVRZEqgge8xcp00R6DD7iQKarjJMmvy1T1MrmUUbJo40PJZT/
bAuy5Hul9H/jlP4NHq2P1+t0n7xR5OtBpN6gUfopDjOrqig1SgZT4Thk4RZi
kBTChk2SEohQen5dDo3lEJS3CyHKZGAdlVtibReM7fOy/IpPO4vEvy1bEL9d
+FT6f8xCfE1p7+c35QKX6bwRUE5QRrC2cO04pltnIYKQYz0vDEpTpBylHCQp
K5sDEoNk0YQQhu1CALseKOVzlDuOORgd8+J/ge9vtIvU+9gXUaaHrfLlj1iG
r3ud/ay3ZTflDiN3BEIk1i/x4SszSQbzKGWQvFKISNnDQZNqNgFZWEUZpdZN
6fmN8imE87VNwcZFtmya8sguLC/J5euYVdcJyVR+lc/DVL6g+gbli3BwMGhi
owlRNZLyU3LsD1naL0G237y/3aOk1suRUQhtMOUNk9gbknN+6sVK5afMzaJx
yspiDiQpa4FV5KMQ0LBNiFjGgTJshnKO5GNdKxe2qHxetvOcCxDBoNHG6ORM
o63mXJIaVL4EGTTHEuXvkl7uts5fXyXLV7bMZ73PtFt9Gkw5Q8gRWc1BE6KL
UjmCfBZebAtGVIpFhmsku6mQAZDkIrdZ7omH5TaWTZHQdtJfIbZRyWvY7pyD
c57DguoEVCygYlG2giuEWMaKZZZebDWSl8UT8pZxsC2tt/A3t6B8H6mNv7yl
5Ho/ZD2vs4fE90J6sU9bo5KfclzeWchuZk23jHK2ayS6TxEb/uJxynMhuqRT
SlpuZZW3Uc0kEGgCgOaQ8huF6FqFsDOVC7JmqlxUmWisXIKpUgjsI2WXf+VE
wEFn7csoW94kvXduG39H6Xd6lW8ta1B8nz0IQYFAaISA4skdAgXFgm8plYFo
MBBhlYUuEAtj0RgkDoO0BIJHqQiTECg0AkH1iWBhZ3VwTCtaTirrTi7iFXMQ
XCpFENa3anG9hVjN4hqrl6FVr4hvVqQF2FaxAucKyjk4VmBfITyGrXrh2ieQ
+Roebh+t1/bGzMF1KyXoaAIOq4dRUlmX0keAyedQMCLPCi7ERNS0oxBcilQl
ZtipeEwQD5sI51EmApt3h2rpbSufgeBRIcMcKudknFWkKdW6mggoxpplGW3t
CmpWhHw1qzInq1YFzcpVprkKEZyrREem1bqM0iWULKFIRsWUfNapqDLk3cf7
Ep//L3i4nW0wZgwgk4NBow2dFKRIlYiWljOoSApceRyE/RRaVEBW1cywLCNg
7VEW1bd4DKIolbASESdhT2xUlgQnuwiqXheWfxrOGQoGTXAymASmKhHmUaXX
DTVLqF2S/b86gcdYx0RqV5XO1VwQmiT+qy4IU0CoLii0QoVsKxCcBKTiRRQu
wsINGtMj+rM1pT/aVLI4Jab0AWTowUScKJasAVBpk4SIFOfCOiiByUCcSJfY
Lu8qGiVFEnxKxohPKSOyTZAelU0SHElmh2MK5VzFCDgVM6icJTDVIsyTjiwo
znVLqFumIAC5VlAvdKdeEDC6GIPrIgG7CK2WdmouofrShr77OlZRxpBKl1G8
RIRknuTN6eXFu17dqH/+wLtd4ZPWj3QO4oC2WobYeGkWc/TNZmQ5HHK5bGqC
lJZPZVKgMg9vpHFX4QiETglmxaOKmQBmHSeFIhM0qeuR4zzKpygIK6Ra40Rs
lojVzKNW8doheLnYBNUvo36FqLlX0XABDRdVTKYGRuS+BPdlwfKyMLGuy6i7
TCcrL8J5AQ5Ga1tF6QpKlnVbOo/cOWTPInMGGaoDurlt/FXe3aFq58/pdZUX
322KKsE0GDdYGpllZv+6HeN7kupxyBkglAaNYFL0eYMQMEXg63YLoBYRuJwK
nhImkdRh2lRvZ5d9EgSSWTqnUDGNyhlUcWdVclS0XYuoX6Jg0NzKTDesEsym
CzKm7U2X0XwZTVcoiOPGK2i4AvcVRavmMqouwXmRWJatKlrbCxaQN4+cOWQx
w7QppJxH8iS8awCpgTu92gufxcP9Yi21T34vPmnXJ00dp/exlkorLcBmcshi
uBKpKMcDkDTz1usOEWOB0NCd5iFIoIUMtGiEaY4STatqOe8qY+10CJqTRJNQ
TqFymlBWz6JmTtc11wLqFym4RauoQZDc1riCplV9YMdgaLmEFqF6WqugaGy9
ihYRrilevu6rcF1F7RVUXUbFJTgu6iNrrOA588icRfo0UqYIIo/vbaYoa00j
th7r3uNF0yelT+azpCmCSfCUUgigGXrQSElNEmZ2P0QglqLXMbCJY76AukPA
FCgtQ4xyGEVMs2SEUKqybxuDbRxl47AzzvJJOM8zyClUTaN6Rl33WB3bq/oF
uBfRsITGJTQto3kFLatouaBYthPFdkHRp/0q2q9xuI6263qN3ngdrmuouYLK
yyhnC1C8AvMScpmi1PqECb1q3eFF62lm6T3Cr49Ib7TJk/uQ3KuCMaVXEhWf
qRxkLUNqKpW0D0YmSnqb1aeI8g00wumbx0wFzIJBhVITIA1fLhpG8Yg+sjMK
6ygEybIx2JlkOcOsOM8Yp1DNdUztLARF1xzqufffsEgUm5fRsoK2C4rz9o5L
qnnfeRWd19B5HV030HVT0nms4ybabqLlBueFQHmVdqyrKFxG/iKy5pAyjYRJ
+YTj0drWm533KJcxSdAyCmxin7Y+tDGl9G5olSmVTqfxmfReiJDRS7WQJCjT
mN1HGpnDIbcfAmA+MywYgHkQlkFiWDik5N1dwhCtDxN0TMA5gQruElTJ8R/D
l+tm4JpF/Rzcc2iYRwM3NJqX0LqMNi7NnZfQdRldVwhgzzU603sDvTfRe4v3
30H3O+h6B+230HITjTeUVppESRbal3Qe0WN4UpF4er0mebgVo/cEdqnPbUxM
7IhP2tWSe2RfOUV8pvbIdkoag9JZsZZn9kIqm2j7ic/tOX2MioOkZWZaklHR
EIqHUDKMUq61rSMoG4V9DI5xUrSKCVROqpq3Zhp103DNoH4W7lk0zKFxHs2L
aFlS0m7rvIjuS+i9gr6rxKn/Ovp1ErsGb2PgNvpuo+c2PO+ilbk5L6F0Fdlz
6/b/YSJfWq8nKAX60yW9v2hMVHzEJ+36JPbI3yf16H042jMm8yFtiZwxVVI0
7EjvIWgiEDDWuuxeECwBTROsDNvy+1GgV9mWARQOoohqacHLsE0QszIxwjUK
xxic4yoHPlc1iRoeWBG86mcY1iyaBKwFtC6ija27ZxVdF9AjcF1G/1UMXiNi
QzcxfEtvP47ewchdDN/F0F303aHfNN0QNcWDnNn7Uoc2lbbPMyl9rEjXJFNC
L7SEHnml+KRdPjYl9mwqd4ndMCZ1y6uSu5FMuyndymamdtOVaWKrCWBahvih
b2YPsnp0YL0ETLaWJCwL1b+FA/QUaBAlQygdIlI2LouO9bqhYhxVE6hmUrUM
q34aDTNomkXLPFoXdJvVyb3v3ovou4SBKxi6iuHrPDbLjCZv4/xdJcr4PYze
o/2WGx9XXbgvWxmPMNJLoT7WqSUoLRKftOuzmVe3GoVNUHTEp4AlNK1Llcyu
9ZauMYXOpXZt0BIbU0Y3MjkIXpJRbi/yepFPOlZApZOA9aNoAMUC1iDDGkKZ
6uHvKh+FcxSVY6gaR/UEaiZRdx713E9tnEGzGrUy7PEsonMJ3cvoZWs1eBnD
VzB6DRM3iNX0u5i5g9m7mLuH+Q8w+4HK286bH0k8ht/3YvU5ZrXemlWfO9Sn
kZnF9yJeqpEPfZriuzd0yigOtHgiksBEEvRdY0InEjvXqWlJYn9bcheSO5HC
QRHsIoJ0vSSoX2/Ynd2DnB7k9jDFXhT0wszGrlBA7EfJAEoH9bbwMBysdBWC
4CiqxlAzjtoJuCbhnkLjtF7O2ufhWUDXInqW0LuM/lUMXaSfjYsKUKP60nf2
HaK4+B6W38fqB1i9r/iNvqvz+5oXv6eYn3eLTX8GrlsyCVL+aQKnSXCULbL4
TeVTiyPti2MutOVdn7hOxHeqi2iHWxUJtCPx0pboaoKsqGc9xJbAdspxv0wR
x64sjjO7GzndRDS/h3H2wsKpKurT61HrAGyDsA/BMYxyNnqCZ/UoasfhmoB7
Eo1TqmfomUPXPHoW0beE/mUMrYIfmO8U383fwuK7WLlDKC9/gGsfUjwX7v92
/s6dbygeUuv0Xtd6ydqCol5P7OM/k66n8aosx/UgjlQyTvI0CoJMzRjLEscS
JtoQxXXOcR5xIl5sTAkeJuiBCFqS+E/2yHx5PNWDNA/SOylkdCKzE1kcQ04X
cruR100MzT2wqHzcXdyHkj5Y+2EbQNkgHIMo5wGryhFUj6B2FC71HGVbyxTa
uCXXOYeeefQtYGBJ6d/uCW7PznGzY/kWLtzG5bu4dk815m7ev3/p7o0/9KL0
mU/UQO5bQ/+Tk0mkNsZzSYpXhVvg64UiSVooLZgW2y1bHgKlDDFdiiZ9HevZ
sIi0z+c6ENchZBEbLa6dLEU724QOJHYoq5jcQWdS6KpUsdlOkD3I8CCT48vu
RE4n8rrk1U8JvEWcqJJelDLesn7YB1A+iArGWz2MWi767nE0TqBlEm1T6GC8
rI+PjyxhnC3l7GUsXMUKN3qv3cbNu3j3Ht67T1hu37tz4dLIH3kRfPKTuW4+
1nEySGUTBU6doklQ1Agc6bH4jOmkoEUTxWjPuvbHeOAT06GuakcsB2Nsm8yJ
hDaqitqQ1I6kNubXTvyIcFoH0juQ0YFMRfjxvE7kd6GgC5ZuFLJBLe5BaS+s
vSjrg6Mf5QOoGESVGnPwcY3APYrGMbRMoG1SaeIT4pv+OQzOY5RHLWdWMX8J
y1dw6Rquc4vuvbu4/z7tfPTBh/ybP/Yis2dLft4jeHxMWiYYqkBaGaeXb1ZM
WYPEUn0dyxLFkKEkqj7RXYjWi3Z0pz6aE+VBVIfUT/FpjBKkfKLaEM3wxDam
TW+3x7QitpUNbquox8TetoRWJHIgzm1IbUNaG9VR7ZLvY9kdyO1Angf5nTB3
wtKFQrY1Jd2w9qCsF44+OPVRC1MNj0q4huEelhbS2DGJrvPo1Ueetk0tYW4F
Sxdw8TKuXcW7N3HvXfVrH7z/2/u3716daZLl1+DNmOprUhnf9Vqcn+Rs+uSr
JVgu5kZF0kQIyT4QQBk6EaXqDIHPGCn4GSPb13U6sg1aZKsqxVEtiOZg0Ghj
imlha9uCuBZBkc4ktCCRTya3yDgzBMTdmZwBOe3IbUdeB/I7YPbA0okizsLS
LthUa9RU0YeqftQMoE7U8iT6nsZhtIygbQyecXRNoJebksPTmJjD9ALml7Cy
gssXcOMy7lzD/Zv6M+/bH9y7cvHmRK3SvI1Zf3+gKG3bxNSwzvIxL9I6U43K
Nl8W24tYvfKO6YHgqUXTfxd8mJeyiREdiCBrFyH0J0KpXXjrRjvHFN6CCCYV
0SyoN0OLahI5E93ERJsgQlwT4ptU6U5qRkozUluQ1oL0FmS0Iosjy2lDbhvy
21HQAUsHCj0qp8q64OiGs0eKzjnuHkTjEFqG0TYCj3oK8MQgd5MnZzAzi8V5
rC7gyjJuruIu10hr1z8mFDfufrAwcrUpSVnBDZbedZL3MzKfLZnqz0m1WGqO
C5gxeuCkR1Mhj+ra3EIwmCI7IchGcNAILPNsRziV0TCyk2GtGzV9mABrDBNM
w5pkCzy8CeGNFCJEaEBkA6IaZS/xibhGxHMQB0mNSG5CShNSm5DejIxmZHIW
5bYirxUFbXrpLupACdsZm0dq6dMV3ajqQU0v6riKbehH8wDa2Ah0j6BvFINj
GOVxndkpLM3g4iyuzuMd7ik+uIC1ix/h0j2x//FU721XvOn/I2fTOmejYZM9
EERJN1nObYIoQeRAWudBuFBVLVzU2WHtrLtaKGELbaavaauFNkELFWCM5xro
HG2NYW7FLcqNaDdi3Ih1I86NeDc3qRqQ1ICURqQ2Ir0RGazN2c36yEVBKyxt
KGpTWrmtrAMOD5ydqOxCdTdqe+BSnTPDZzoG0DWI3iEMDGOY6/qZcSxO4sIU
rnJF//4cfjsPzH2Mufc/nrwoztyvjPb5fyHnPYq6QW7z2fWxG6mW0apvZ4ri
WihSkOwSWig4+iqMUus6cE6RDBH2MESIvSOkCcEMIbgRwQ0IdiPITdvgenkD
w55zLpyrQ1gdZ4oLkS5EuRDtQowLsS7E1TPWeiS7keJGaoMq39mNyG1CfrOq
t3cUtaKEC4CtDfZ2lHegwoMqD2o6FfunGrvR0oP2Xnj60N2P3n4MDWCMNXR+
BCs8t+DWGN4bx/2xNYx9/NvhO/d7Fj9qbV2zRvhuRfVTn9BtzVUftzDsFmoZ
pYdILusRXRBEwzuJZ5gIsl2jhYr6J0RI5hvCJTG4GUFNCBShEVpgg4w90I2z
9XrNHsgkg+oQXCt+WStuGlKD0Bo6GVaL8FpE1iKqFtG1iKlFXJ3UZmNaPdLd
yHQrzdyR3whzEwqbUdSMEr5zWSscbXDqNmBXbQdcnPPNXWjtQnsXOrvR3Y2B
Hoz0YlLvW+240I/r/XinD3d71j7q+ejDtpvvu6fedzbdz4xSddCjdZM+O27b
lhR3620nhU8S1ARAvuOT4Zv6PKEdCOXKPKQNwSK0IqgFQc0I5FJ+thFnRGiQ
0RmMAXUIqMVpAUsLqJFPa89WQ4TAagSJUIWQKgZZjfBqRFQjslrpY3wtEmuR
XKfzy3Rx7eRGnhv5DTA3oLARxU0oaVL59EVnCypbUdOGujbUcxKb29Hajo4O
dHnQ58FQJ8YY8JwHyx5casf1VrzT8uA993vvV1++ax+5k+++Ex2/3YvhNx7R
TX4OtV7r6DX6E9DnWwmApHxdCJf9D+2csOqh1CoPaUdIm4KpBZJ1PNuMM00I
aNS17VQ9Trpwso6C7OedrMHJapysonCqkn58upJ4VoifnHHirBNBFarsmyIr
EVWJaL6Ky/GupBqk1CCtFul1yGRNznEhrx4F9TC7UehWWvW0tRFljXA0wdmM
qmbUNKOOtbSxBc0taG2BpxU9rejnk6Oc2bMNWKrHxTpcq/zwZtnNd4tW3s0e
fCe+9npACo9XiPt794Wk/vk8QnSr2VyyHAndC+vEOY9eUwqMAmJwO4JEOQ5s
Zeto8D3VgJNcX5xw4e06HBcl9bjQtx3Hq+nk8Uocq8AxJ46X4+1yvswhG60G
Y0g5zjkR7lR6RnNk4yqQUImkKiRXIbUa6RxHdi1yapFXp9LxlUIXitmUWt0o
c6O8ARWNqGpETSNcXPU3NqK5EW0N8HDCelzoY/zj1ZhyYt6xtlD8wUretcvp
C5dj+q8E1l48lLlri9Lr3c75XejpI5aiTdiFsC4GKPqKoaolGdyBoHZVQned
bsKpRpxswAk3TtTjbS5mx2pxtAZHqnGENO1IhfzdYQdrrqz9j9lw3Iq3rThp
xWkrAmyyJcoMw+yIcCDSgSj+RVw54p1IrEByJVIrkV6ldP2JvBoU1MJci8Ja
FDMcqwt2F8rrUVGPqnrU1sPFkBvq9Sd/bVXoqECnE72ckcMla6OWB2NZ9yaT
rkzHzI2f7Rs/UjO8L1M9Xfpklj6fwpLuxONxpCKCn4AXKoIHIao17BPYhrNt
ONOKgBac1lsjPicacNyNY/U4WocjtbKhaNhx0IqDpThYgteLcaiY7nG4GEeL
caxY6RyNdQWWItiKUCvCbIhgljF2xDmQUC7vuCeDy3R2FXKrkFeFgmqYq1HI
qllSA1st7LUor0VFLaprUVOrWuOuKridaHSguQytpego4fGinAfdGR/3JNzp
Db/cGzTb9mZv60vVrmczVb2wwew/Y9P6q99B74gZa9VuUrEOBLIVXgd1qhkn
m/A2l46jbnD5277fgVfteMWGV6x4pZS+eqUIrxZCe9UMw+MHzHRGjtm9ZcYx
C962sAUsxJkiBBUjpARhpYi0SkpPJtiR5EBKOdKcdFlWBbIrkFuBvEoUVMJS
iUKubkqrYKuGvRrlVSrvnqxivjXlqCmDywp3CRoL0ViAhqw1cb4p/qOmc++6
T1+qPzbjfLHH/u+VBT/JUKvQvHiJw0/TrUeeL2wTx0K7QjoR7EGQR+cm27en
1/sgXOoef6MOh2pxsBoHKvAqF4AXrdhbiheK8UIRfsNsXsjH3jw5RkAK+FoO
Xs/BG7k4kofjBQzPItnvibUi3obEMiTbkWpHOpfWrHLklCPXiXwnCpywVPDI
TwVKKqROfbbMCUc5yvnuFTZUlKCqCNVmVOehOmutMoV4VZ77sPzUrbLDF6wH
pvP+vSvjXyoiv5+hngNv8OLZ1zyWAX1YUbXzNtetm4npa4pETdpJsAI9ONuh
ZlmdaMHxZhxtxJEGvMlW42AtDlTj1Uq87MSLDr0G+VURni3As3n49xzZ16Kf
/yoNv0nHvnRQdhieCihAoBnBFpwrRHgRF8cSxJYivhSJViTbkFqGdDvjciDH
gVwH8h0oKIelXKbvc0UOFNtRWgZrGWw2lFnpYnsh7AWw58CeAXvKmjWeWJUG
fpj/5s3sV1Yzn5+K+2Hnub9zHv2bdDnqtYnVlxUr756cHPr2Xhv4tF5/7hR4
Ajpwuh2nuN1xopUgvdWEww14ww1SEKP+bMz404T1URrafOHFJLyajENpeCsD
x7PouzN5CCxASAHCzIhgbYspQlwxEkqQVIpkK1LZdmWWIbsMOWXILdOfcBYw
LUsZCm0osqKoBMUlKGG0JfkozkFxBoqSURi/VhC5lhdCYFIP3op9bjnql5Nn
/qGDY3nSS/YvKCberd4NJiTHV3Sd8QnsxFkPznhwugOn9BrQ941GHHQrwfdW
4Xkna4Ws5f2T1/xj1/yj6OsfheNn5/DLUDwbRofPRWNfHPYn4FASjqTSmZOZ
OJONoDyE5iOsAJFsu2ItiCtEQhGSipFSgrRSmS9PZVuRY0Uuq0W+DQVWmEtg
KUZhEcxmFOTR+YJM5KchPxE5UWsZIWupAQ8I+CvvyBbyfr/K3/hl6fX9Zvk/
q7h4r0/dWldonhrbg22n18eRRZupDW+14s1mGQGXii/4cwL8T6/9+DR+fgq/
DKDLfxWGfdHYH4tD8TiSyBzSEJCBoGyE5iKcBYkuQKwZ8RYkFqq6/6n0UqSX
IKMEmSXIKkF2CXK4csorQX4x8otQYEFePnKzuZClIisJmXFIC19LOrsm6+CT
z1w88oPpQ/+9++U/qf2VX76cDbBJ2icUBe9abYMC5fF/0rVjW1APgroR2I2z
3TjTjYCujRaN76kunOrGafFFL4IHEDECH/13e/xfW/vhYfxUhGP0i/8ZhH1h
2B+FQzE4Esc8khGQiqAMhGYhIkfmv68gkVyEVG4PCBDpxdDSRWl4LKMImVwq
souQU4hcC3ILkJ2LrExkpNH5lHgkR+vPuiOOrQUdpCG1w/96Zf8/zb323b59
365/1q/wKVUT7VYMvK3J1prwDWU12Cb7hG6avxU9tqmvveuHB/CjwyxrAPYG
YX8YDkVyOzsepxJxNkX1Rp6KyUdcARLMSLIgpQhpUthiCEHTC5FmQboFGWxF
sizIMiMrDxnZSM9Aaoq8086okLWw02vBx9YC3iCL8Oovb7zw/aXn/8+R5/+i
6Rk/6+e9pNqmpH7K67y2pbR/oK42+EYNI2oE0SOIGUXcGBImIGt2/+9dUfLv
YLlDUxGRgegcLtd5iM1HfAESzUi2ILVQagvl4XYpXJoZaVzfphcgIx/pOWrc
P4GtbEwUwkMRdHot4NjacRbuN79459nvrf7izyd/9ddtv/BzsHXzzjM69JZa
Sqc/0fSuMf+T+pU+AmAwJq7PaWOt+KL/9274//y+//OcoW9h3wm8dhaH2cad
isXZBIQmIzwNUVmIzaWT8XmIz0fCw5ILkTUhs8EopU7LV+V8T3ImEtMQn4w4
tg2RUQg9hzNn8PYxHD609tqrZFGe+edrP/6ruZ9+q+unflVf3CQdr1oTmy9t
KfGW6yc2HX9N5a/3WBNbyyf9/br8/+G6/4/fEz949iB+cxivnsDhIBxnwc/G
ITQR4amIykAsm6AEYci0RCGWb1IBksxIsSixhdSaEFqOiaWyuUvOQUIm4tMQ
m4LoRETF8wBSGE6fxdG3cfANvPwqZfjPf3L7Z9+95P/t0R99s87f78jnVU59
5XeSVs/Pr6pf6T1ufor7ef9vj/j//VX/X3wgrvj1Abx8BIdO4VgwTrF0ofEI
T0aUSF8WEjhPk/KQlI/kAqSIYEaqWVqpz6eKw3wKdE0uErIRm46oFEQmIZyl
OhOGE0E4fAL7D+OF/Xj2N5SfP/4fN/3/etn/W53+fgf1ush7pP93y1PvUcCn
VWzeLe8nVJ66/f9q/sc/uEXV80trL72OQ8fw9lkEnKOkigSLZEenIjaDBEnK
kyWWhDOmFui2jvPxiwKAwCBgJOcTGHltQg5iMwmbgCcQBkazzQvB4QDsP4a9
r+M/XqEz/j+95//da/5/MeXv9/IebN1C+eL/L+m/uCmP6ZOl3uPvl+T/p70/
++7FX/zsjrh2/2trh9/CyQAEstRC+WKSEJuK+HRSyuRcVf9QObVQEAepFiQL
DRaKbXhKqHgCSxufS5ov9D88hcpCIFdlonQcCcZrp7DvLTx3iM788FcP/H90
1/8fr/v/ycRjSlrvcQxvS/bpGq2XA287xz36JzxJe//1z1t+9Bcz//Yv18XF
h15bO3pk7fQphIQigiuhuCQkpCIpHclZygZ9TVgjskkssSix6Vy/CrslhE4U
9VM+2bM4FlpYuKhMsnYhyQhMwGkW+kgYXg/CSyfx/FH8+5ucxULon37g//2b
XDeo9Hr3bj7ZTm/Vs/msytOnsVFzG3b92O+t//izhn/9y/H/+T8uiGvfOvDg
1JG1wJNr54IQHYn4OH3cLz2XqhixJ+Qka2TYs1nUtCKkFFIlLIx2XD5iWdQY
IWo2wjMQkoqzSdjFdcPS86/IJMn6ZL2kiTojfpzqRtUv3ZDqc1tKudNLOr0c
fNXran4usuPnfid//aeufX87+OIPlg/+G0ENOrIWdnItKmhNtRbT0pCeicwc
ZOcjWzQUWG0zuAGRVqgETefmhWhRJRci0ULNDtH4iMmTIxJPiIbJcbZYoqly
QDRZg/FcAJ45wSr8OvxfxcwzB0f+eV/tt/bqSWTJfePGETOG6FFqIUQOI3II
WoRaSSaHJR7J599bJ0AXPa7y8xvqkyX2ecYvcK9f9Wt/1/P6P88f+7erMhcf
S4laS4tHRjI3/7KRk4c8M7UAc4qQzcKJlqFoH8pWhg81pEp0kYuUrn8umtUg
PBshmQhMp4bnCY5PNEVFg/RAJF4Mw3PBeIbb7j85gvEfHe77h1fdf7K38pt7
ORGUvu2ivRepzycPGUBIP4JFULM2TSF9CO1TAzPe+S+l954tr7dD/8jrarni
8z/8zr3kZ3njO53H/2Va1qPxxx4kBqylnVvLil3LTkIut3zzc5FfAHMhCoqo
j5DHo0U5pdR3yOJ+hOhNCCKcxqeTipBQiDgzdTyo3SG6ZHkIyUFgFnVOTnKE
orsiOi2i6/JiFH7NNeMvAtD6g8MN39lf47fX5rc3z29vjB9h4WcCJtHsF43/
0z042Q3jKTW3aMfpLuornOF+g+g9iG5EcI+CY/BuiW7QWZ9RKr7837GppfLF
X/tFG/S/yF9dSDx4m3I+eC0nYq0gAeZUWLJQyLV2oZm6i6LTaCmF2YoC7nvn
2ZBrQ7ZNtki+msE9zFTROS+hLqjoiIruaAyXnwjRjc9HiOjS5yIgG6L7SkxS
qEMrurUvxuLXXMM9G4qC//Zqpt/eRL+9EX57T/ntPey394DfXjk+f6Z3TaWV
y9nON5pxuAVHW3G8HSf4kfYp0d/2IKATZzrVs52gLn205zO/k/ZsU9rzTa+r
uU3x1P5vJwT8pT3snzxJ/zGd8uKFnCPEyxKxVhy/VpqC0gyU5sLK9bu1GKWl
KC6lAYjCMljssi7801w7jVVklXGLzoZUK41kJJYivgSxxYhmGxpuwTkzggsQ
mI8ANqDHMnEkHYdSaYxkXyJe4GZ9+F++HOi397jf3oN+e5/32/tLv70/89v7
Q7+9/klrP2Sd+3Eefm7BMyV41oZfl+MFHnZ8pRYHXHjdjTcacLhJzTY/2U6D
FKc7cKaDhi0COxHUqXtc8u7xb83NR+nVt9Un8/ps8N8mJf1jefovuswvzxQe
ulR6gnjZ4x6Up65VZMGZC6cZ5UVwsG2x22Gzw2pHiUPvuVvKaaArvxy55TT0
lcWjhml2pJQhyUbDY/GliOUfRxbT4FloIQ2knTUjoECOrvm8/mcvveS391c6
G8MeOrvnjXq86caRRhxtojGqEzz0eaqNxq4C2nUIHr1kGR4ZIXu4bOm9Jfbw
8tT6VVn/lFL8E6f1Nz1Vh2drTl52hd51xdCU3LrsNVc+XIWoLUaVFVWsCxVO
lKtRzydtlSitRDFnl6UCBRXIr6BR0mwnsnisOc2BFAeS7EgoQ5wNMVb1hOnL
p7mwHc/HkVy8kYOD2TjAPYqXs7EvGy9k4fls/DoHz3G38rl8PGfGcxb8ugi/
YYj7yvCSA684aRzzQDVeq1F1sO+b9TjipvHO4014uxkn1bMwn8AOGhkNXtcV
73bJ1rpC+vE3Sk8MT1T9PN39XGXD630dZ+Y9oVc98ffa02iYodWMlmI0laKh
DC4H6ipQq4+g76msgbMGjhrYalDKDyYKq2CpQkEVDb/nViKb4WVU0OB8SrnU
8qejbIiw4lwpjeQHFtOovjh7woLjZhw144gZbxTgda7T9ufjlXy8LEIBXjLj
Rca6rxj7SrCvFC9a8ZKyeb77nXitEq9X01j5m3U47JLjW7tOtyKAR0HPttMY
e5AE5aGxd8XKu1/hxUrV+ORdxvBY/3OZgwerB08PjEctjCRcH866P1jwYIDr
aY8d7Q60OtFUqUrN43Uu1LhQ6YKTH3HZ6lDKT7wKa2Cpocc5edXIqUZ2lbSR
v59cgUQn4ssRy+UrsgzhZThnQ4gVQVac5brvVDFOFOM4P0p6qwhvMrvXi3Cw
CK+JUIwDJTjAVx6w4UAZ9tshRzIeP8YDnm830gOZU8043YKAVnpKc5bxSDbB
HcRmvb2nrDy1D35PHBKZTSVOnPk7OvrK0mvZS6dqlqOGVtOWFnJvzhZ/NF22
Ns4PC/qr0VODTha7tR7NDWjkaUB1DahuQGUDnA2wu2GrRykP3xe6YKmjJ4Sc
hs9n85SL9GqkVtGTxMQKeqoYy2Uvip82hjtwzo4QO4K49AbYcMqKE/yQ8pgV
R62gB22Gz7xRgTcrcbiKnm+K46N1OObC8Xq87caJBpzgx1OnmuixXkALM2lF
YJua8xTioceAofw8VYgcJscIdz/CRK/Z/5bbt1dO512Pdt3KGr1lWb1me+dS
5YOVWsy5MKU/9d/d0wIPP2VvbkZjM0NpRnUzKptQ3gR7I2wNMgWfKXAhz4Uc
hphZi/QapNYguRqJVUioQhwXsagKRFYggh9rn3MipBzySeRxB445cLQcR504
WoGjfPGxKhwTILRj/Ly8Fsc56hP19ED4ZANONdDz4dNN+owOgSKonXRDPfMU
OM55CEdYJ013kOOlXjOfHmbjPR5LVsfwhZux5ndzGu/Yzt+runbH/f7N5rUr
LVhtxwK3IcY9GPag34OuDprP0dqOZn62WN+G2jZUt6KyBeUt+nPl4kaaHGJu
QAFPF8lhbcp00RSItDqk1CKpFgmsTbFVykpvD6mkaRRnnTjjREAFTvNjr1OV
0E6K/xPiMtOJapzgH50QGnmCJqaccPFcjXoZh3a2RfrYCmqlyQnB7TRRIaQD
oR08fcFgoElInarHpkrU1oT0PgOT+dzdnPx75a333Asftb1zv+fj2z241Ycr
vHBqnrdjvRjsQW8PzRfq4LlDzTxhx+VBjZ5PT5S3wd4KG0/fKG5GYRNNR8pv
RF4DcrgUZtQjvR5p9UhxKY47YmsRU4OoGkTWIKIGYVxeQqsRQvoSJDY+gTyZ
R5w9UwOa4KOdroF2uhY880dZDNlDPcM3OdsEETSaLLSD5g210hwicV6QCm1n
UhKWLG3hnWoejQiR3bqNfpTXHsXrr7l986Ej98NWz/2eiw9G7j0Y++37Y7jD
DhcujmGJnYBNDGF4AP0D6OlHZx/NYGvpQWOPPsOgphOVHjg9cHSgjLWstBXF
rShsgbmZZsjlNiGnUaVxd4obSfVIZBWLcyGmDtF1iKpDRB3CGcE5oS2hRCSk
FiF1CK6Tj3wNprP8m0A3AhsEETIFgU00F42+1IJFRvkEtyKklSYMiRCqP6/y
EWoUzvPaDDzHzaDRZC2fSH3ym6K0/RFK+qgRt4ieFJc8GO77+Px1zH2A+d9+
zOtXb83iyjRWpjDPs3jHRjE4gr5hdA+hY1C3Va5emldZ3Y2KLpR3wu6Bjcto
STtNxCxsg7lV2qo9GU00ZzO1ESk8izORK504nuAZU4/oekTVI5IphLsQ5lIz
Hd3QgulfKIwpmK1xMM951IKbQfMgORmh8sG4LEthfH/aauEeGGkepVHOAaRZ
v5qAYvQqc76P0PHuqbEvzq/cac4Wv1i7eBuX3sfF34r991ZxcwmX57E6i4UZ
TPPKuqEJ9I+hh7WrbQjNg2jghyd1fTSDt6oHzm44ulDWCatHsnmsoA15bchl
MTJbaGZwWjPNEk5pQnIjElnu+AZaA9Mg23XGCDfCGygYtLAGqX7nGiGDnFnb
rNi0gCbe8q9MYW0Ia1eB5uYajHJ6aQTNqIrsBGmPfA4a3U3zUuUEVUnqUUqf
UzrEdIy3+mz3l2dYX1nlPryG25dx/QIuLWN5EXPzOD+HsWn11MgzhrZRmnrf
OAQ3L7qpHUB1Hyp7Ud4De7feUirywOKBuYMmoee2I4cNRFYrTVFP5+nqqS1I
bkZSs5xbFydKjCm2CTFccqKaYIykKYERTYholmUpnOZtE5uwFt0mySd+Ya0g
PG006TucS3o4z7DvgEZ4aOq9nNss9cxHaBNB2rRyhJaMxfYgtncLYsoDqjhi
z6C735lupUUZdz7EHVKk92/h3eu4dgUXL2JpFbNLmFT+b3Z2n4dnEm3jaBlF
4wit+HDJRUoDqBpQ69rLemHtRgmnpZAXkBR4kO+hJSU5LEpmG2iphNSCJF5F
kdCC+BZocaQcscyCFl808/oLWoohr41oRUQbBT4QWhOpZscTDo+s64zRvGam
m1YrUJAz7XllDa1nMOh/korPQ1S+pKj8CR19/s6FYdx7Dx/QKMIHvDD3xk1a
HLR8GfMXMb1CZ4YXMMArvrum4ZmixUUt47TQyD0K14ia/+scoCVJ9j7YelHK
ySniZUvmLhR0Iq8TuWru1raMdqS3I60dqe1IYSlpLZRGC3V8E1oRzyGOC2as
smTG9QU/wpqItmCUMsZRHVBB1VnG6E4wG6NUEdISjVVlfYkHf2XidUkbrWrj
Q4S+7GWL2NPmf16ZdNx/78bHH9ETlrv38O5d3LhNca5cpwVps+yuZmwFQ4vo
X0Av8/LM0DK2lkla0ubmSlAucqscgnMQjgGUDcDWTyviSjjTCnkholp/n8tL
6EiTeF1degfSOpDagRS2tsk0RympncaG2x8qVca4NsS20bIzoQ/0fQx/T1st
pkPQIW3atGJNUZPE5NpAWuemqHVvpkZr4Qw+cZxUWtDVK9d4xfdtzOORxNZJ
fkXpGhPcfuP25Tv3qbf/zn3ceB9X7kIY9uVbahxv/CKGV2kNZd8iehZoVao4
2zaDFt1z1U7XOGpGUcUIncNwDME+SOs0rf0o6VdPd809KOhBPi/tzO1CNldD
mbz2kxaB8mrQVL2F45vEKxpFSGCo8R0w0cJHUxzzifUgVtUXvFxSrkPVYohW
jL6YUq1p65arhWj9Kq0s0te16iu2DKoYrisVAZOMvqoYsZfPHf5+e698cJ+K
4Ue4eh8X79EC3MV3Ma97Gdg+fhnDFzGwir5lWrfbtQDPPNrnpF3a2TCF+knU
TdDS6aoxWkYtzpYPwz6MMrVScFdxP4p4/NjCy7Hze5HHC7RzupGtVm5nqtFV
YyrLnUK1VbJaW5uo8CV4IEK8hyXnhbmb1jxrYkProE38nVxda6IV0wbdR/LG
M2bJ4euKA69F+IzgMPsecVj9kJZvL7+Pxfcwfwcz73AT8jpG2dvJwEX0rdIy
+q4lWhMuZ+g3s/uk+inUTaJmAtVMomKMFuarNpSNnRyUDNIy/kJuxJv7UNDH
KHoZhVoh4pvZjYxupIvQhTSWTksRkiWTjUnqQlInhfW13FqCsj3xXaDF9CZe
UR//UCkyxiuvF+JTBp2L3muVPL7hZYV4pozAImfRzb6P2XuYuYupO2r+zNgN
DF/D4BX081Kv7lWQJwZJpHUezXNonEW99D1znhwTVE+gclzp5k7bCPl8EFCK
2WdG4QAs0k9LP/JV2TLm9CJb1TSZ4nNbRg+D6UYaC5jajZRuvX8lHS3Q1pgo
eCWqLxK6IQPpjC97tpAr6qUzB7pkz0O2WJ/T+XUlPSMcfQ9j7+myjbEVHr6F
oRsYvI6Bq+i7TG46unQvOjvaltCySO48GubItUf9DLlFEV9U657fdjnHUT5G
XkHKuLwIEiXD5GWlaIh8iFj0tjf5F8nrJ/cZIuT0IbtX0aDSTjQ4SG0QNMgn
h8GYzHDYXYfcrNdEdG/2gUI/EJ/spEFRoN6CcZ3CHyoKPDdhu8BQd/WBjKPv
DgbuYPA2hm6rmcr9N9B3Db1X0XMF3ZfRya4R2lbQwn45GhfIXY57jnzC1M2g
VvlO3Fl5njzsOCfIjYx9jDhYGQW5hxpWs64FBzOvL8ofIEc+Bi2XnCPl9CO7
jx3YcP8hXVm+tB6QyxtNbMiLC3+XpGQVn7SrCZnJJ4yPkpccVsr5p3+s5OXn
9I+lTj2wraKK3Zq13kIHO+7pfgc9bAt6b6LnBnqu674POq/Ac1khbl0ll0pN
S2hYZJMwTw6X6pR3qZ1V7NhK7DknycmQnT1f2cZI8lK1nnJb8QiK2FuWZYiE
L5DOyTQS35g7QF6N9HJNPo/Ie5TBlM5qkdYLEbTUXlWDpOhuqNipkvSlIb/T
52jwUy7pl3pTuZfPaGLHda2Rz3lab6L9pjrluQHPdXRcQ8dVdFxB+2XdQ8EF
NK+iaQWNy+Sly72I+gV9bKF6hjx6VbKbtHJegmufQNkEEVBrr0s4/8lJGPu4
MlmGyeVVwRDyBznV7GXMmK37cTOQHzL2/ZTep89x0B2XpXJtk0IeuMT3yfI5
5mdVjvNsBYP+DI5Hy33iJ5A6TW6GChZRpFsxU80V1F2F+xoar6mR5pZraJXh
KlqvkOM2WUc26y4pG5bhXiZfb/WLcOn+LatnyS1cBfkTcZKXXSG/Q/lYZsDW
cXItR84i2W+faldZ2E8iuUqU+ZnHrhTJZZ0iMYCsgXUS8k7KnyApBflu2+Qf
T9caPe9ZbvaeThTk8/vEyc2WQvcyJ/7KL5L3uarL5IlOsXFfQeMV9bXWSD4U
m7gaaLxIvhbdq3CvoJ4tgGsJdbrfyZp58tZYpXulMTqndZ+Osvaz8QpXK/vM
LGEXmlrRKHku1h9O093IJ6kxXzoppeNc6b+UiWxKP3ujzOhXdxZk0jgY9BJg
0mdP8TsT1ufx+yZNklPC9Cny8yg0Im9e5XHpykYayi+gku1crdCAukvQXEJ4
X9fFjSvqL7CnThf7M11GHbs4VVyrF8jFZ9UcefysmGXvqOv+JO3saJYcqWrk
AJMSWzJOIESQV0gvj+STlb2OkvtRo0SRqyYqkEdXg1Eqx7pfzgzy0Ze+aY7n
U9g070a+U2PjnTtQ88m35+qeQovYF23pMmzL5FOU71N1UXpmrVE+IU21q+rq
2hVotcuqB1a1oM5WzpGfXBJ5Vtdq+xTLSzWjlf2NS9fM6zpYNEbeQS0czLo3
Y4OSevih/M4ZYs+/0j8yiT4I3YWrnt/SX9i3NuW3THfhAnnZFfJZle9qo2OF
nPE6dc+VxipdMlGchWzVy4rAInnwXSA3yBXzJJw46VT2fptjRrlPln6DhZAk
InmclrIXjZPP4UL2lk9NRfOo7pdYloY83bl3ru7qmj1fm7IGH83F32fJ/myT
ZPIetiXYlylIr9TG8uXNzIyVy9DIjzUdV4j2rFP0gnY551CuZ7uDfbzbpT/0
KdimYD2vz0IqkQ7UpT9xioFcbZMUm3OFfHKTP2ryz27MGVaCGDZbZPZ4ze/r
0WdFaHrapf9wZScd7EvdyYHjd6rc2uZchPTFXs69OLEtVy8+MGwnz/szKkm2
aZaAhZAWvUS+mWKSJCH3/kIS9g+/7vyfEkIvODDmr9sgeluAdDi/IaduV3nd
mXyTh5JF6k/ZIuwcDCaHtIZaOfn8dyzAMa8H5TWUPeoby2bVexD4XQKyR1fK
r00QadZ99JPP/m2F4xtplenmNzCQ7/t8lfK8EWxOKVGXb0T4b161/7pvhTJV
e5nK+FULSlLaM9rXvQdrZaog2+RLMWZA73FgbSqhd7dQiaaXa2yUaHovhKhZ
5PtMOK30jg5+jcRD9ZN824j+hFp/cxG9Y4PeacH9GhtRsvELOTihnJ+l/E4W
+XoJmbH0BhJZnuRrKOQbQOh1JaJ2KZBWVW8NyrfnfEfddd0PglX1dk1W/S0H
/L4UegdO6QzUK0y4PNF7V0wl/J4TEdSd+T0t9DIii/K4Lm6u39Wo5muod5io
uzLB0llQ9HI0mN77I183wxRF5DJ31t/+Iu7B7zsymTdpw5NKLvkurL//hLw2
0dt8fEumN35Xwu9eMhZP8RuBZGkUO5vfo2Rcf6sR59uTShbWJ34znJ5v3BKn
VxkZ5RuWpN4qf2DGwo33S8hYJ/X3EdFd96j0f4dj/cdNsfJNi6b59VEmFRtH
Ru/Dka+cMvALrtbjodQxAX5T3ub8FRSnNmTX1DvADPSKsfX3V1H8+gqTf+RY
vv8JNH34vWaWh9pSjys55Pv1/mmzHPymEX4XmbrL4+ouP+Brf7AprfTtYyom
f/72Xza3XDalZaeKg9/sZvih17feHm18VZw/56t/pOL0vkqfYfMMX/UTPLyW
b5+au/8sf/szFcdzfPRJbzk0/N7/AhkQozQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511814773]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15606],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->205968855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcTan", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16938],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", " ", "z"}]}], "]"}]}]}]], "Output",
 ImageSize->{213, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190186080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986050146],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490682306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20920],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions with ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->106708612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"16", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "/", "5"}], "]"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "/", "239"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18366],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63193355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27929745],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " is a special case of some special functions: "
}], "ExampleText",
 CellID->576963788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", "1", ",", 
    RowBox[{"3", "/", "2"}], ",", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41186033],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869292477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112398708],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities involving ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8823338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", "x", "]"}], ">", 
    RowBox[{"Pi", "/", "3"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232768942],

Cell[BoxData[
 RowBox[{"x", ">", 
  SqrtBox["3"]}]], "Output",
 ImageSize->{49, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70419237]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19685],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["ArcTan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcTan"]], "InlineFormula"],
 " is a multivalued function, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["tan", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"tan", "(", "x", ")"}], ")"}], "\[NotEqual]", "x"}], 
   TraditionalForm]], "InlineMath"]
}], "ExampleText",
 CellID->747222780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{"Tan", "[", "4.", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370567959],

Cell[BoxData["0.8584073464102068`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507940996]
}, Open  ]],

Cell[TextData[{
 "This differs from the original argument by a factor of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->98877673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"%", "-", "4"}], ")"}], "/", "Pi"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53185421],

Cell[BoxData[
 RowBox[{"-", "1.`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36185529]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20229],

Cell[TextData[{
 "Expansion about the branch point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[LongEqual]", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->71531658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "I", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19298],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{
      FractionBox["\[Pi]", "2"], "-", 
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", "2", "]"}]}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], "]"}]}]}], ")"}]}], 
     "+", 
     FractionBox[
      RowBox[{"x", "-", "\[ImaginaryI]"}], "4"], "+", 
     RowBox[{
      FractionBox["1", "16"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "2"]}], "-", 
     RowBox[{
      FractionBox["1", "48"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "\[ImaginaryI]"}], "]"}], "4"],
      SeriesData[$CellContext`x, 
       Complex[0, 1], {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     Complex[0, 1], {
     Rational[1, 4] (Pi + Complex[0, 2] Log[2] + 
       Complex[0, -2] Log[Complex[0, -1] + $CellContext`x]), 
      Rational[1, 4], 
      Complex[0, 
       Rational[1, 16]], 
      Rational[-1, 48]}, 0, 4, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{525, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126967200]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17096]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27626],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->17157],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->2737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4841],

Cell[TextData[{
 ButtonBox["Demonstrations with ArcTan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ArcTan"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseTangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/ArcTan/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ArcTan"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->231488846],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->33350885],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->296735547],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->213649294],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->12520942]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArcTan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 40.8465556}", "context" -> "System`", 
    "keywords" -> {
     "arctangent", "arctg", "arcus tangens", "atan", "inverse tan function", 
      "inverse tangent"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArcTan[z] gives the arc tangent tan -1 (z) of the complex number z. \
ArcTan[x, y] gives the arc tangent of y/x, taking into account which quadrant \
the point (x, y) is in. ", 
    "synonyms" -> {
     "arc tan", "arctan", "arctangens", "arctangent", "arctg", "atan", 
      "atan2", "atangens", "atg", "invtan"}, "title" -> "ArcTan", "type" -> 
    "Symbol", "uri" -> "ref/ArcTan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9098, 315, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->721973089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67922, 2180}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2981, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3604, 92, 44, 1, 70, "ObjectName",
 CellID->28428],
Cell[3651, 95, 1377, 45, 70, "Usage",
 CellID->16678]
}, Open  ]],
Cell[CellGroupData[{
Cell[5065, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5543, 162, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5666, 168, 65, 1, 70, "Notes",
 CellID->101],
Cell[5734, 171, 384, 15, 70, "Notes",
 CellID->20949],
Cell[6121, 188, 239, 8, 70, "Notes",
 CellID->9487],
Cell[6363, 198, 214, 7, 70, "Notes",
 CellID->31226],
Cell[6580, 207, 197, 7, 70, "Notes",
 CellID->28162],
Cell[6780, 216, 792, 32, 70, "Notes",
 CellID->2364],
Cell[7575, 250, 1486, 60, 70, "Notes",
 CellID->26385]
}, Closed]],
Cell[CellGroupData[{
Cell[9098, 315, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->721973089],
Cell[CellGroupData[{
Cell[9483, 329, 148, 5, 70, "ExampleSection",
 CellID->399539159],
Cell[9634, 336, 62, 1, 70, "ExampleText",
 CellID->27873],
Cell[CellGroupData[{
Cell[9721, 341, 98, 3, 28, "Input",
 CellID->29935],
Cell[9822, 346, 181, 6, 49, "Output",
 CellID->32571159]
}, Open  ]],
Cell[10018, 355, 121, 3, 70, "ExampleDelimiter",
 CellID->30096],
Cell[10142, 360, 211, 8, 70, "ExampleText",
 CellID->20381],
Cell[CellGroupData[{
Cell[10378, 372, 155, 5, 70, "Input",
 CellID->21561],
Cell[10536, 379, 160, 5, 36, "Output",
 CellID->15299932]
}, Open  ]],
Cell[10711, 387, 120, 3, 70, "ExampleDelimiter",
 CellID->5584],
Cell[10834, 392, 429, 17, 70, "ExampleText",
 CellID->25923],
Cell[CellGroupData[{
Cell[11288, 413, 121, 4, 70, "Input",
 CellID->28499],
Cell[11412, 419, 182, 6, 49, "Output",
 CellID->405828685]
}, Open  ]],
Cell[CellGroupData[{
Cell[11631, 430, 159, 6, 70, "Input",
 CellID->11849],
Cell[11793, 438, 224, 8, 51, "Output",
 CellID->260144808]
}, Open  ]],
Cell[12032, 449, 120, 3, 70, "ExampleDelimiter",
 CellID->8606],
Cell[CellGroupData[{
Cell[12177, 456, 232, 8, 28, "Input",
 CellID->6850],
Cell[12412, 466, 2154, 40, 114, "Output",
 Evaluatable->False,
 CellID->51594255]
}, Open  ]],
Cell[14581, 509, 121, 3, 70, "ExampleDelimiter",
 CellID->26040],
Cell[CellGroupData[{
Cell[14727, 516, 215, 7, 70, "Input",
 CellID->22769],
Cell[14945, 525, 1008, 35, 54, "Output",
 CellID->394691793]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16002, 566, 216, 7, 70, "ExampleSection",
 CellID->16467],
Cell[16221, 575, 73, 1, 70, "ExampleText",
 CellID->40174808],
Cell[CellGroupData[{
Cell[16319, 580, 127, 4, 70, "Input",
 CellID->116882886],
Cell[16449, 586, 274, 7, 36, "Output",
 CellID->561689246]
}, Open  ]],
Cell[16738, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->223317723],
Cell[16866, 601, 69, 1, 70, "ExampleText",
 CellID->88315731],
Cell[CellGroupData[{
Cell[16960, 606, 180, 6, 70, "Input",
 CellID->406380963],
Cell[17143, 614, 234, 7, 36, "Output",
 CellID->48391413]
}, Open  ]],
Cell[17392, 624, 112, 3, 70, "ExampleText",
 CellID->18659275],
Cell[CellGroupData[{
Cell[17529, 631, 147, 4, 70, "Input",
 CellID->399269772],
Cell[17679, 637, 238, 6, 36, "Output",
 CellID->134483100]
}, Open  ]],
Cell[17932, 646, 125, 3, 70, "ExampleDelimiter",
 CellID->245924666],
Cell[18060, 651, 214, 7, 70, "ExampleText",
 CellID->397001889],
Cell[CellGroupData[{
Cell[18299, 662, 165, 5, 70, "Input",
 CellID->216118936],
Cell[18467, 669, 277, 9, 36, "Output",
 CellID->150133129]
}, Open  ]],
Cell[18759, 681, 125, 3, 70, "ExampleDelimiter",
 CellID->112109847],
Cell[18887, 686, 91, 1, 70, "ExampleText",
 CellID->306540079],
Cell[CellGroupData[{
Cell[19003, 691, 183, 6, 70, "Input",
 CellID->220994862],
Cell[19189, 699, 228, 8, 49, "Output",
 CellID->70574974]
}, Open  ]],
Cell[19432, 710, 124, 3, 70, "ExampleDelimiter",
 CellID->14152207],
Cell[19559, 715, 92, 1, 70, "ExampleText",
 CellID->295677626],
Cell[CellGroupData[{
Cell[19676, 720, 120, 4, 70, "Input",
 CellID->235359564],
Cell[19799, 726, 208, 7, 36, "Output",
 CellID->941055828]
}, Open  ]],
Cell[CellGroupData[{
Cell[20044, 738, 125, 4, 70, "Input",
 CellID->530678434],
Cell[20172, 744, 226, 7, 36, "Output",
 CellID->168490167]
}, Open  ]],
Cell[20413, 754, 124, 3, 70, "ExampleDelimiter",
 CellID->19545242],
Cell[20540, 759, 203, 7, 70, "ExampleText",
 CellID->215421212],
Cell[CellGroupData[{
Cell[20768, 770, 140, 4, 70, "Input",
 CellID->592624624],
Cell[20911, 776, 278, 9, 52, "Output",
 CellID->179167271]
}, Open  ]],
Cell[CellGroupData[{
Cell[21226, 790, 163, 5, 70, "Input",
 CellID->41188240],
Cell[21392, 797, 302, 10, 52, "Output",
 CellID->510636917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21743, 813, 239, 7, 70, "ExampleSection",
 CellID->12083],
Cell[21985, 822, 84, 1, 70, "ExampleText",
 CellID->104876922],
Cell[CellGroupData[{
Cell[22094, 827, 288, 9, 70, "Input",
 CellID->485059841],
Cell[22385, 838, 368, 13, 49, "Output",
 CellID->328271010]
}, Open  ]],
Cell[CellGroupData[{
Cell[22790, 856, 132, 4, 70, "Input",
 CellID->304287381],
Cell[22925, 862, 158, 5, 36, "Output",
 CellID->218256324]
}, Open  ]],
Cell[CellGroupData[{
Cell[23120, 872, 151, 5, 70, "Input",
 CellID->726536818],
Cell[23274, 879, 180, 6, 49, "Output",
 CellID->5445478]
}, Open  ]],
Cell[23469, 888, 125, 3, 70, "ExampleDelimiter",
 CellID->287937181],
Cell[23597, 893, 206, 7, 70, "ExampleText",
 CellID->68190708],
Cell[CellGroupData[{
Cell[23828, 904, 173, 6, 70, "Input",
 CellID->1294035],
Cell[24004, 912, 843, 29, 54, "Output",
 CellID->178840328]
}, Open  ]],
Cell[CellGroupData[{
Cell[24884, 946, 102, 3, 70, "Input",
 CellID->269126107],
Cell[24989, 951, 419, 14, 36, "Output",
 CellID->32351543]
}, Open  ]],
Cell[25423, 968, 125, 3, 70, "ExampleDelimiter",
 CellID->366756755],
Cell[25551, 973, 209, 7, 70, "ExampleText",
 CellID->97758880],
Cell[CellGroupData[{
Cell[25785, 984, 206, 7, 70, "Input",
 CellID->20487026],
Cell[25994, 993, 323, 11, 49, "Output",
 CellID->320376416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26366, 1010, 223, 7, 70, "ExampleSection",
 CellID->11158],
Cell[26592, 1019, 329, 12, 70, "ExampleText",
 CellID->240083676],
Cell[CellGroupData[{
Cell[26946, 1035, 303, 11, 70, "Input",
 CellID->314912519],
Cell[27252, 1048, 239, 8, 36, "Output",
 CellID->32394336]
}, Open  ]],
Cell[27506, 1059, 176, 7, 70, "ExampleText",
 CellID->257310361],
Cell[CellGroupData[{
Cell[27707, 1070, 101, 3, 70, "Input",
 CellID->645679116],
Cell[27811, 1075, 161, 5, 36, "Output",
 CellID->129692411]
}, Open  ]],
Cell[27987, 1083, 122, 3, 70, "ExampleDelimiter",
 CellID->441634],
Cell[28112, 1088, 229, 8, 70, "ExampleText",
 CellID->289691853],
Cell[CellGroupData[{
Cell[28366, 1100, 238, 9, 70, "Input",
 CellID->122469095],
Cell[28607, 1111, 190, 6, 36, "Output",
 CellID->434818239]
}, Open  ]],
Cell[28812, 1120, 125, 3, 70, "ExampleDelimiter",
 CellID->732296731],
Cell[28940, 1125, 81, 1, 70, "ExampleText",
 CellID->183417949],
Cell[CellGroupData[{
Cell[29046, 1130, 263, 9, 70, "Input",
 CellID->87639809],
Cell[29312, 1141, 247, 9, 51, "Output",
 CellID->39640757]
}, Open  ]],
Cell[29574, 1153, 123, 3, 70, "ExampleDelimiter",
 CellID->7791063],
Cell[29700, 1158, 73, 1, 70, "ExampleText",
 CellID->353107707],
Cell[CellGroupData[{
Cell[29798, 1163, 712, 23, 70, "Input",
 CellID->270483439],
Cell[30513, 1188, 531, 19, 51, "Output",
 CellID->493579725]
}, Open  ]],
Cell[31059, 1210, 125, 3, 70, "ExampleDelimiter",
 CellID->910005128],
Cell[31187, 1215, 223, 8, 70, "ExampleText",
 CellID->286484814],
Cell[CellGroupData[{
Cell[31435, 1227, 415, 14, 70, "Input",
 CellID->5918093],
Cell[31853, 1243, 20928, 347, 70, "Output",
 Evaluatable->False,
 CellID->511814773]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52830, 1596, 233, 7, 70, "ExampleSection",
 CellID->15606],
Cell[53066, 1605, 442, 18, 70, "ExampleText",
 CellID->205968855],
Cell[CellGroupData[{
Cell[53533, 1627, 134, 4, 70, "Input",
 CellID->16938],
Cell[53670, 1633, 503, 16, 51, "Output",
 CellID->190186080]
}, Open  ]],
Cell[CellGroupData[{
Cell[54210, 1654, 105, 3, 70, "Input",
 CellID->986050146],
Cell[54318, 1659, 190, 6, 36, "Output",
 CellID->490682306]
}, Open  ]],
Cell[54523, 1668, 121, 3, 70, "ExampleDelimiter",
 CellID->20920],
Cell[54647, 1673, 345, 13, 70, "ExampleText",
 CellID->106708612],
Cell[CellGroupData[{
Cell[55017, 1690, 300, 10, 70, "Input",
 CellID->18366],
Cell[55320, 1702, 161, 5, 36, "Output",
 CellID->63193355]
}, Open  ]],
Cell[55496, 1710, 124, 3, 70, "ExampleDelimiter",
 CellID->27929745],
Cell[55623, 1715, 219, 7, 70, "ExampleText",
 CellID->576963788],
Cell[CellGroupData[{
Cell[55867, 1726, 275, 9, 70, "Input",
 CellID->41186033],
Cell[56145, 1737, 190, 6, 36, "Output",
 CellID->869292477]
}, Open  ]],
Cell[56350, 1746, 125, 3, 70, "ExampleDelimiter",
 CellID->112398708],
Cell[56478, 1751, 334, 13, 70, "ExampleText",
 CellID->8823338],
Cell[CellGroupData[{
Cell[56837, 1768, 210, 7, 70, "Input",
 CellID->232768942],
Cell[57050, 1777, 191, 7, 38, "Output",
 CellID->70419237]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57290, 1790, 226, 7, 70, "ExampleSection",
 CellID->19685],
Cell[57519, 1799, 430, 16, 70, "ExampleText",
 CellID->747222780],
Cell[CellGroupData[{
Cell[57974, 1819, 133, 4, 70, "Input",
 CellID->370567959],
Cell[58110, 1825, 176, 5, 36, "Output",
 CellID->507940996]
}, Open  ]],
Cell[58301, 1833, 186, 6, 70, "ExampleText",
 CellID->98877673],
Cell[CellGroupData[{
Cell[58512, 1843, 139, 5, 70, "Input",
 CellID->53185421],
Cell[58654, 1850, 176, 6, 36, "Output",
 CellID->36185529]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58879, 1862, 224, 7, 70, "ExampleSection",
 CellID->20229],
Cell[59106, 1871, 210, 8, 70, "ExampleText",
 CellID->71531658],
Cell[CellGroupData[{
Cell[59341, 1883, 214, 7, 70, "Input",
 CellID->19298],
Cell[59558, 1892, 1812, 57, 89, "Output",
 CellID->126967200]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61431, 1956, 311, 9, 70, "SeeAlsoSection",
 CellID->11593],
Cell[61745, 1967, 1652, 62, 70, "SeeAlso",
 CellID->17096]
}, Open  ]],
Cell[CellGroupData[{
Cell[63434, 2034, 314, 9, 70, "TutorialsSection",
 CellID->27626],
Cell[63751, 2045, 163, 3, 70, "Tutorials",
 CellID->17157],
Cell[63917, 2050, 181, 4, 70, "Tutorials",
 CellID->2737]
}, Open  ]],
Cell[CellGroupData[{
Cell[64135, 2059, 320, 9, 70, "RelatedLinksSection",
 CellID->4841],
Cell[64458, 2070, 357, 12, 70, "RelatedLinks"],
Cell[64818, 2084, 185, 4, 70, "RelatedLinks"],
Cell[65006, 2090, 198, 4, 70, "RelatedLinks"],
Cell[65207, 2096, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65628, 2114, 319, 9, 70, "MoreAboutSection",
 CellID->231488846],
Cell[65950, 2125, 150, 3, 70, "MoreAbout",
 CellID->33350885],
Cell[66103, 2130, 145, 3, 70, "MoreAbout",
 CellID->296735547],
Cell[66251, 2135, 155, 3, 70, "MoreAbout",
 CellID->213649294],
Cell[66409, 2140, 156, 3, 70, "MoreAbout",
 CellID->12520942]
}, Open  ]],
Cell[66580, 2146, 27, 0, 70, "History"],
Cell[66610, 2148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

