(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    157225,       3756]
NotebookOptionsPosition[    146455,       3396]
NotebookOutlinePosition[    147743,       3433]
CellTagsIndexPosition[    147656,       3428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/ComplexNumbers"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcTan" :> Documentation`HelpLookup["paclet:ref/ArcTan"], 
          "Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], "Abs" :> 
          Documentation`HelpLookup["paclet:ref/Abs"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "Re" :> 
          Documentation`HelpLookup["paclet:ref/Re"], "Conjugate" :> 
          Documentation`HelpLookup["paclet:ref/Conjugate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcTan\"\>", 2->"\<\"Sign\"\>", 
       3->"\<\"Abs\"\>", 4->"\<\"Im\"\>", 5->"\<\"Re\"\>", 
       6->"\<\"Conjugate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Functions of Complex Variables\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Arg", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Arg",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arg"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the argument of the complex number ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5284]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is left unevaluated if ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " is not a numeric quantity. "
}], "Notes",
 CellID->20727],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " gives the phase angle of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " in radians. "
}], "Notes",
 CellID->30285],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is always between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->2426],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to 0."
}], "Notes",
 CellID->19670],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", "0", "]"}]], "InlineFormula"],
 " gives 0."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->123195765],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375466130],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->524738321],

Cell["The result is given in radians:", "ExampleText",
 CellID->20280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3867360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"1", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->439534410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->931523658]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
For purely real or imaginary arguments, exact results are returned:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76901791]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{
   RowBox[{"-", "3.2"}], " ", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Pi]", "2"]}]], "Output",
 ImageSize->{24, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272380008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
For generic approximate complex arguments, approximate results are returned:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"1.6", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.5585993153435624`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554752964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"1.60000000000000000000000", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.55859931534356243597150821640166127037`23.298550397038014"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170856459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", 
    RowBox[{"1.5", "I"}], ",", 
    RowBox[{
     RowBox[{"-", "1.8"}], "I"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["\[Pi]", "2"], ",", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}]}], "}"}]], "Output",
 ImageSize->{80, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505105609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"(", GridBox[{
      {"1", "u"},
      {"v", 
       RowBox[{"-", "I"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\:f3a2", ")"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"Abs", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", "v", "]"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128268683]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " returns exact answers for exact numerical arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"2", " ", "+", " ", 
   RowBox[{"I", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  FractionBox["\[Pi]", "2"], "]"}]], "Output",
 ImageSize->{73, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223500280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252743734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->480439421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " threads element-wise over sparse arrays: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
     RowBox[{"-", "6"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"I", " ", "Pi"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", "u"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}], "->", "1"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490638023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Arg", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Pi]", ",", "0", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Arg", "[", "u", "]"}], ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{323, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72275813]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30571],

Cell["Polar decomposition of a complex number: ", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", "#", "]"}], ",", 
     RowBox[{"Arg", "[", "#", "]"}]}], "}"}], "&"}], "[", 
  RowBox[{"1", "+", 
   RowBox[{"3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["10"], ",", 
   RowBox[{"ArcTan", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{124, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540166963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Color a plot according to value of ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"Arg", "[", 
        RowBox[{"Sin", "[", 
         RowBox[{"#1", "+", 
          RowBox[{"I", " ", "#2"}]}], "]"}], "]"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->450214755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Expand multivalued functions without making assumptions about variables:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Floor", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       RowBox[{"Arg", "[", "z", "]"}], "\[Pi]"]}], "]"}]}]], " ", 
  "z"}]], "Output",
 ImageSize->{118, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190983033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox[
      RowBox[{"Arg", "[", "z", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{210, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56895945]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27376],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Arg", "[", 
     RowBox[{"I", " ", "x"}], "]"}]}], ",", " ", 
   RowBox[{"x", " ", ">", " ", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", "x"}], "2"]], "Output",
 ImageSize->{27, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130630061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Arg", "[", "z", "]"}], "-", 
   RowBox[{"I", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"z", "/", 
      RowBox[{"Abs", "[", "z", "]"}]}], "]"}]}], " ", "-", " ", 
   RowBox[{"I", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Sign", "[", "z", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"Arg", "[", "z", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->934373686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Generate ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->340133147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Im", "[", 
   RowBox[{"Log", "[", "z", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279433710],

Cell[BoxData[
 RowBox[{"Arg", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388475351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269973736],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " as a target function in ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexExpand", "[", 
   RowBox[{"z", ",", "z", ",", 
    RowBox[{"TargetFunctions", "->", 
     RowBox[{"{", 
      RowBox[{"Abs", ",", "Arg"}], "}"}]}]}], "]"}], "//", 
  "TrigToExp"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Arg", "[", "z", "]"}]}]], " ", 
  RowBox[{"Abs", "[", "z", "]"}]}]], "Output",
 ImageSize->{94, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563039451]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"TargetFunctions", "->", 
    RowBox[{"{", "Arg", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}]], "Output",
 ImageSize->{210, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413217800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Rescale ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " to run from 0 to 1:"
}], "ExampleText",
 CellID->25529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rescale", "[", 
    RowBox[{
     RowBox[{"Arg", "[", 
      RowBox[{"I", "^", "n"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", "1", ",", 
   FractionBox["1", "4"], ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["3", "4"]}], "}"}]], "Output",
 ImageSize->{115, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619037330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"I", "^", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "2"], ",", "\[Pi]", ",", 
   RowBox[{"-", 
    FractionBox["\[Pi]", "2"]}], ",", "0", ",", 
   FractionBox["\[Pi]", "2"]}], "}"}]], "Output",
 ImageSize->{122, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102190526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find the domain of positivity for a linear function:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"x", "+", "c"}], "]"}], ">", "0"}], ",", "x", ",", "Complexes"}],
   "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "x", "]"}], "<", 
     RowBox[{"-", 
      RowBox[{"Re", "[", "c", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "\[GreaterEqual]", 
     RowBox[{"-", 
      RowBox[{"Im", "[", "c", "]"}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Re", "[", "x", "]"}], "\[GreaterEqual]", 
     RowBox[{"-", 
      RowBox[{"Re", "[", "c", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], ">", 
     RowBox[{"-", 
      RowBox[{"Im", "[", "c", "]"}]}]}]}], ")"}]}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->773191311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33301947],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " to specify assumptions about complex variables:"
}], "ExampleText",
 CellID->3502470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"Pi", "/", "4"}], "<", 
     RowBox[{"Arg", "[", "x", "]"}], "<", 
     RowBox[{"3", 
      RowBox[{"Pi", "/", "4"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->594147553],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", "4", "]"}]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", 
        FractionBox["1", "x"], "]"}]}]}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "3"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[], {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[], {
   Rational[1, 2] (Pi + Complex[0, 1] Log[4] + 
     Complex[0, -2] Log[$CellContext`x^(-1)]), 0, 
    Complex[0, 
     Rational[-1, 4]]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{305, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1051532920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "]"}], ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->545915949],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"]}], "]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"]}], "]"}]}], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", "x", "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"Log", "[", "4", "]"}]}], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           RowBox[{"Log", "[", 
            FractionBox["1", "x"], "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], "2"]}], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          FractionBox["1", "x"], "]"}], "3"],
        SeriesData[$CellContext`x, 
         DirectedInfinity[], {}, 0, 3, 1],
        Editable->False]}],
      SeriesData[$CellContext`x, 
       DirectedInfinity[], {
       Rational[1, 2] (Pi + Complex[0, -1] Log[4] + 
         Complex[0, 2] Log[$CellContext`x^(-1)]), 0, 
        Complex[0, 
         Rational[1, 4]]}, 0, 3, 1],
      Editable->False], ")"}]}], ")"}]}]], "Output",
 ImageSize->{496, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269998504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30000],

Cell["Degenerate cases give intervals as results :", "ExampleText",
 CellID->463970747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108827445],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(Arg[ComplexInfinity]\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Arg::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->628226818],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306874012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91197171],

Cell[TextData[{
 "Machine\[Hyphen]precision evaluation of ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " can give wrong results:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"], "-", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Exp", "[", "E", "]"}], "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Log[\\(\\(\\(\\(-1\\)\\) - \\(\\(2\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 - \[ExponentialE]\\^\\(-\
\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \\((1 + \
\[ExponentialE])\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->22102041],

Cell[BoxData[
 RowBox[{"ArcTan", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
    SuperscriptBox["\[ExponentialE]", "2"], "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ExponentialE]"}]]}]], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], ",", "0"}], 
  "]"}]], "Output",
 ImageSize->{249, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110039191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1862050]
}, Open  ]],

Cell["\<\
Arbitrary\[Hyphen]precision evaluation gives the correct result:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(ArcTan[\\(\\(\\(\\(\\(\\(-1\\)\\) - \
\\(\\(2\\\\ \[ExponentialE]\\)\\) - \[ExponentialE]\\^2 - \
\[ExponentialE]\\^\\(-\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \
\\((1 + \[ExponentialE])\\)\\^2\\)\\), 0\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->225978230],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102764643]
}, Open  ]],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"%%%", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData["3.\
141592653589793238462643383279502884197169399375105820974944592307816406286208\
9986280348253421170679821480865090363`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->221225627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "The Argument Principle of complex analysis cannot be used because ",
 Cell[BoxData[
  ButtonBox["Arg",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arg"]], "InlineFormula"],
 " has range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", "/", "2"}], " ", 
          RowBox[{"Exp", "[", 
           RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}], ")"}], "^", "4"}], "-",
        " ", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->746580885]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", " ", "+", " ", 
          RowBox[{"I", " ", "y"}]}], ")"}], "^", "8"}], "-", " ", "1"}], 
      ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "False"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "<", "2"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294583678]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9077],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26199]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14536],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "Tutorials",
 CellID->3281],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->23370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6549],

Cell[TextData[{
 ButtonBox["Demonstrations with Arg",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Arg"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ArgumentComplexNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ComplexComponents/Arg/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->336172863],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->668992528],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->303737599],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->32595652]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 41.8622066}", "context" -> "System`", 
    "keywords" -> {
     "angle", "arg", "argument", "argument of complex number", 
      "complex number", "phase", "phase shift", "phase-angle"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Arg[z] gives the argument of the complex number z. ", "synonyms" -> {}, 
    "title" -> "Arg", "type" -> "Symbol", "uri" -> "ref/Arg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10722, 308, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->375466130]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 147512, 3421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2611, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3234, 86, 4187, 83, 70, "ObjectNameGrid"],
Cell[7424, 171, 555, 18, 70, "Usage",
 CellID->5284]
}, Open  ]],
Cell[CellGroupData[{
Cell[8016, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8494, 211, 120, 4, 70, "Notes",
 CellID->20640],
Cell[8617, 217, 329, 12, 70, "Notes",
 CellID->20727],
Cell[8949, 231, 316, 12, 70, "Notes",
 CellID->30285],
Cell[9268, 245, 438, 18, 70, "Notes",
 CellID->2426],
Cell[9709, 265, 448, 16, 70, "Notes",
 CellID->19670],
Cell[10160, 283, 331, 11, 70, "Notes",
 CellID->123195765],
Cell[10494, 296, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[10722, 308, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->375466130],
Cell[CellGroupData[{
Cell[11107, 322, 148, 5, 70, "ExampleSection",
 CellID->524738321],
Cell[11258, 329, 70, 1, 70, "ExampleText",
 CellID->20280],
Cell[CellGroupData[{
Cell[11353, 334, 97, 3, 28, "Input"],
Cell[11453, 339, 160, 5, 36, "Output",
 CellID->3867360]
}, Open  ]],
Cell[CellGroupData[{
Cell[11650, 349, 102, 3, 28, "Input"],
Cell[11755, 354, 182, 6, 49, "Output",
 CellID->439534410]
}, Open  ]],
Cell[11952, 363, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[12082, 369, 357, 12, 28, "Input"],
Cell[12442, 383, 25206, 417, 195, "Output",
 Evaluatable->False,
 CellID->931523658]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37697, 806, 200, 6, 70, "ExampleSection"],
Cell[37900, 814, 98, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38023, 820, 81, 2, 70, "Input"],
Cell[38107, 824, 157, 5, 36, "Output",
 CellID->76901791]
}, Open  ]],
Cell[CellGroupData[{
Cell[38301, 834, 123, 4, 70, "Input"],
Cell[38427, 840, 200, 7, 49, "Output",
 CellID->272380008]
}, Open  ]],
Cell[38642, 850, 105, 2, 70, "ExampleDelimiter"],
Cell[38750, 854, 107, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38882, 860, 104, 3, 70, "Input"],
Cell[38989, 865, 176, 5, 36, "Output",
 CellID->554752964]
}, Open  ]],
Cell[39180, 873, 105, 2, 70, "ExampleDelimiter"],
Cell[39288, 877, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[39406, 883, 126, 3, 70, "Input"],
Cell[39535, 888, 219, 6, 36, "Output",
 CellID->170856459]
}, Open  ]],
Cell[39769, 897, 105, 2, 70, "ExampleDelimiter"],
Cell[39877, 901, 193, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[40095, 911, 203, 7, 70, "Input"],
Cell[40301, 920, 285, 10, 49, "Output",
 CellID->505105609]
}, Open  ]],
Cell[CellGroupData[{
Cell[40623, 935, 580, 19, 70, "Input"],
Cell[41206, 956, 368, 13, 36, "Output",
 CellID->128268683]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41623, 975, 223, 6, 70, "ExampleSection"],
Cell[41849, 983, 200, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42074, 993, 137, 4, 70, "Input"],
Cell[42214, 999, 215, 7, 49, "Output",
 CellID->223500280]
}, Open  ]],
Cell[42444, 1009, 105, 2, 70, "ExampleDelimiter"],
Cell[42552, 1013, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42641, 1017, 86, 2, 70, "Input"],
Cell[42730, 1021, 158, 5, 36, "Output",
 CellID->252743734]
}, Open  ]],
Cell[CellGroupData[{
Cell[42925, 1031, 104, 3, 70, "Input"],
Cell[43032, 1036, 162, 5, 36, "Output",
 CellID->480439421]
}, Open  ]],
Cell[43209, 1044, 105, 2, 70, "ExampleDelimiter"],
Cell[43317, 1048, 189, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43531, 1058, 632, 21, 70, "Input"],
Cell[44166, 1081, 489, 17, 36, "Output",
 CellID->490638023]
}, Open  ]],
Cell[CellGroupData[{
Cell[44692, 1103, 112, 3, 70, "Input"],
Cell[44807, 1108, 524, 17, 49, "Output",
 CellID->72275813]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45380, 1131, 223, 7, 70, "ExampleSection",
 CellID->30571],
Cell[45606, 1140, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[45695, 1144, 252, 9, 70, "Input"],
Cell[45950, 1155, 252, 9, 43, "Output",
 CellID->540166963]
}, Open  ]],
Cell[46217, 1167, 105, 2, 70, "ExampleDelimiter"],
Cell[46325, 1171, 188, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[46538, 1182, 700, 24, 70, "Input"],
Cell[47241, 1208, 49517, 816, 70, "Output",
 Evaluatable->False,
 CellID->450214755]
}, Open  ]],
Cell[96773, 2027, 105, 2, 70, "ExampleDelimiter"],
Cell[96881, 2031, 103, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[97009, 2037, 222, 7, 70, "Input"],
Cell[97234, 2046, 421, 14, 44, "Output",
 CellID->190983033]
}, Open  ]],
Cell[CellGroupData[{
Cell[97692, 2065, 221, 7, 70, "Input"],
Cell[97916, 2074, 440, 14, 52, "Output",
 CellID->56895945]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[98405, 2094, 233, 7, 70, "ExampleSection",
 CellID->27376],
Cell[98641, 2103, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[98851, 2114, 228, 7, 70, "Input"],
Cell[99082, 2123, 205, 7, 49, "Output",
 CellID->130630061]
}, Open  ]],
Cell[CellGroupData[{
Cell[99324, 2135, 368, 11, 70, "Input"],
Cell[99695, 2148, 210, 7, 36, "Output",
 CellID->934373686]
}, Open  ]],
Cell[99920, 2158, 105, 2, 70, "ExampleDelimiter"],
Cell[100028, 2162, 320, 13, 70, "ExampleText",
 CellID->340133147],
Cell[CellGroupData[{
Cell[100373, 2179, 168, 5, 70, "Input",
 CellID->279433710],
Cell[100544, 2186, 187, 6, 36, "Output",
 CellID->388475351]
}, Open  ]],
Cell[100746, 2195, 125, 3, 70, "ExampleDelimiter",
 CellID->269973736],
Cell[100874, 2200, 316, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[101215, 2216, 255, 8, 70, "Input"],
Cell[101473, 2226, 316, 10, 38, "Output",
 CellID->563039451]
}, Open  ]],
Cell[CellGroupData[{
Cell[101826, 2241, 296, 9, 70, "Input"],
Cell[102125, 2252, 498, 17, 48, "Output",
 CellID->413217800]
}, Open  ]],
Cell[102638, 2272, 105, 2, 70, "ExampleDelimiter"],
Cell[102746, 2276, 196, 8, 70, "ExampleText",
 CellID->25529],
Cell[CellGroupData[{
Cell[102967, 2288, 367, 13, 70, "Input",
 CellID->17731],
Cell[103337, 2303, 322, 11, 51, "Output",
 CellID->619037330]
}, Open  ]],
Cell[CellGroupData[{
Cell[103696, 2319, 225, 8, 70, "Input",
 CellID->20342],
Cell[103924, 2329, 336, 11, 49, "Output",
 CellID->102190526]
}, Open  ]],
Cell[104275, 2343, 105, 2, 70, "ExampleDelimiter"],
Cell[104383, 2347, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[104483, 2351, 208, 7, 70, "Input"],
Cell[104694, 2360, 750, 26, 36, "Output",
 CellID->773191311]
}, Open  ]],
Cell[105459, 2389, 124, 3, 70, "ExampleDelimiter",
 CellID->33301947],
Cell[105586, 2394, 222, 8, 70, "ExampleText",
 CellID->3502470],
Cell[CellGroupData[{
Cell[105833, 2406, 448, 14, 70, "Input",
 CellID->594147553],
Cell[106284, 2422, 1077, 35, 52, "Output",
 CellID->1051532920]
}, Open  ]],
Cell[CellGroupData[{
Cell[107398, 2462, 262, 9, 70, "Input",
 CellID->545915949],
Cell[107663, 2473, 1833, 57, 85, "Output",
 CellID->269998504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109545, 2536, 226, 7, 70, "ExampleSection",
 CellID->30000],
Cell[109774, 2545, 87, 1, 70, "ExampleText",
 CellID->463970747],
Cell[CellGroupData[{
Cell[109886, 2550, 113, 3, 70, "Input",
 CellID->108827445],
Cell[110002, 2555, 388, 8, 70, "Message",
 CellID->628226818],
Cell[110393, 2565, 268, 9, 36, "Output",
 CellID->306874012]
}, Open  ]],
Cell[110676, 2577, 124, 3, 70, "ExampleDelimiter",
 CellID->91197171],
Cell[110803, 2582, 216, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[111044, 2593, 429, 13, 70, "Input"],
Cell[111476, 2608, 616, 11, 70, "Message",
 CellID->22102041],
Cell[112095, 2621, 608, 19, 45, "Output",
 CellID->110039191]
}, Open  ]],
Cell[CellGroupData[{
Cell[112740, 2645, 77, 2, 70, "Input"],
Cell[112820, 2649, 173, 5, 36, "Output",
 CellID->1862050]
}, Open  ]],
Cell[113008, 2657, 95, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[113128, 2663, 107, 3, 70, "Input"],
Cell[113238, 2668, 635, 11, 70, "Message",
 CellID->225978230],
Cell[113876, 2681, 158, 5, 36, "Output",
 CellID->102764643]
}, Open  ]],
Cell[114049, 2689, 219, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[114293, 2700, 231, 7, 70, "Input"],
Cell[114527, 2709, 284, 7, 54, "Output",
 CellID->221225627]
}, Open  ]],
Cell[114826, 2719, 105, 2, 70, "ExampleDelimiter"],
Cell[114934, 2723, 397, 15, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[115356, 2742, 514, 17, 70, "Input"],
Cell[115873, 2761, 2750, 49, 70, "Output",
 Evaluatable->False,
 CellID->746580885]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118672, 2816, 224, 7, 70, "ExampleSection",
 CellID->30916],
Cell[CellGroupData[{
Cell[118921, 2827, 790, 27, 70, "Input"],
Cell[119714, 2856, 22315, 370, 70, "Output",
 Evaluatable->False,
 CellID->294583678]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142090, 3233, 310, 9, 70, "SeeAlsoSection",
 CellID->9077],
Cell[142403, 3244, 1387, 53, 70, "SeeAlso",
 CellID->26199]
}, Open  ]],
Cell[CellGroupData[{
Cell[143827, 3302, 314, 9, 70, "TutorialsSection",
 CellID->14536],
Cell[144144, 3313, 139, 3, 70, "Tutorials",
 CellID->3281],
Cell[144286, 3318, 148, 3, 70, "Tutorials",
 CellID->23370]
}, Open  ]],
Cell[CellGroupData[{
Cell[144471, 3326, 320, 9, 70, "RelatedLinksSection",
 CellID->6549],
Cell[144794, 3337, 346, 11, 70, "RelatedLinks"],
Cell[145143, 3350, 192, 4, 70, "RelatedLinks"],
Cell[145338, 3356, 193, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145568, 3365, 319, 9, 70, "MoreAboutSection",
 CellID->336172863],
Cell[145890, 3376, 141, 3, 70, "MoreAbout",
 CellID->668992528],
Cell[146034, 3381, 169, 3, 70, "MoreAbout",
 CellID->303737599],
Cell[146206, 3386, 154, 3, 70, "MoreAbout",
 CellID->32595652]
}, Open  ]],
Cell[146375, 3392, 50, 0, 70, "History"],
Cell[146428, 3394, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

