(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55960,       1986]
NotebookOptionsPosition[     46139,       1641]
NotebookOutlinePosition[     47713,       1683]
CellTagsIndexPosition[     47627,       1678]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Table" :> Documentation`HelpLookup["paclet:ref/Table"], 
          "ConstantArray" :> 
          Documentation`HelpLookup["paclet:ref/ConstantArray"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "ArrayPlot" :> 
          Documentation`HelpLookup["paclet:ref/ArrayPlot"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"], "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Table\"\>", 
       2->"\<\"ConstantArray\"\>", 3->"\<\"SparseArray\"\>", 
       4->"\<\"Grid\"\>", 5->"\<\"ArrayPlot\"\>", 6->"\<\"Tuples\"\>", 
       7->"\<\"ArrayFlatten\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"Language Overview\"\>", 
       5->"\<\"List Manipulation\"\>", 6->"\<\"Operations on Vectors\"\>", 
       7->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Array", "ObjectName",
 CellID->17933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Array",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Array"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", with elements ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["i", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Array",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Array"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "..."}], TraditionalForm]], 
      "InlineMath"],
     " array of nested lists, with elements ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Array",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Array"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list using the index origins ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " (default ",
     Cell[BoxData["1"], "InlineFormula"],
     "). "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Array",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Array"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["dims", "TI"], ",", 
        StyleBox["origin", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ", rather than ",
     Cell[BoxData[
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"]], "InlineFormula"],
     ", for each level of the array. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25188]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->7844076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"f", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "7", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "9", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 ImageSize->{406, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1220103670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"#", "^", "2"}]}], "&"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "10", ",", "17", ",", "26", ",", "37", ",", "50", ",", 
   "65", ",", "82", ",", "101"}], "}"}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2108520134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3198],

Cell[TextData[{
 "Generate a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "2"}], TraditionalForm]], "InlineMath"],
 " array:"
}], "ExampleText",
 CellID->12280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"3", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122749344]
}, Open  ]],

Cell[TextData[{
 "Generate a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "4"}], TraditionalForm]], "InlineMath"],
 " array:"
}], "ExampleText",
 CellID->1813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"10", "#1"}], "+", "#2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22", ",", "23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32", ",", "33", ",", "34"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1463923488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29846],

Cell[TextData[{
 "Use index origin ",
 Cell[BoxData["0"], "InlineFormula"],
 " instead of ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"f", ",", "10", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32182],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "5", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "7", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "9", "]"}]}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441919137]
}, Open  ]],

Cell[TextData[{
 "Start with indices ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["4"], "InlineFormula"],
 " instead of ",
 Cell[BoxData["1"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->79388808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272100553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"0", ",", "4"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"0", ",", "5"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"0", ",", "6"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "4"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "5"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", ",", "6"}], "]"}]}], "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{380, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->500921262]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25636],

Cell[TextData[{
 "Use ",
 Cell[BoxData["##"], "InlineFormula"],
 " to pick up a sequence of indices:"
}], "ExampleText",
 CellID->12353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FromDigits", "[", 
     RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"111", ",", "112", ",", "113", ",", "114"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"121", ",", "122", ",", "123", ",", "124"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"131", ",", "132", ",", "133", ",", "134"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"211", ",", "212", ",", "213", ",", "214"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"221", ",", "222", ",", "223", ",", "224"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"231", ",", "232", ",", "233", ",", "234"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{450, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1336484233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7639],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " to combine elements:"
}], "ExampleText",
 CellID->32046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", "1", ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3362],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", 
   RowBox[{"1", ",", "1"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"1", ",", "3"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"2", ",", "1"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"2", ",", "2"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"2", ",", "3"}], "]"}]}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1926370204]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14078],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " matrix of 0s:"
}], "ExampleText",
 CellID->4985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{"0", "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1040556456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->377],

Cell["Totally antisymmetric tensor:", "ExampleText",
 CellID->26350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Signature", "[", 
     RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6048],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsFOwzAMbVfKxmCw7cK4jZ+BEx9RTUjsgEBjXwnfARyAbxhNu3J42LWd
thsSQVoXJ7Ff/OKkicdNtr67vc/Wy0U2v15lj3fLxdP86mGVVyVxFMXPURRd
zqK8vMlLxcf9veSfsliWjt0zqVo30QHIRyCfgXwu6A+N9lC22hsb7Un2rXxY
xz8R9NGfrvlFOXEPkRXX3svF8fb7grDi6tEO6iEbkt6E0aO8oOxIfmjHMwW9
aUv+S7PTU82OQ3diCvV9pv40f6S5KKEPGuJw9RJOjxnfoCGOhKvl9ZAZn6+/
Q6M9jod9zZ9f1Ba90h+50Ck5cCulX9uqWUeuH+6WTTD5Vg0y12/QEqbPGOrZ
oLSb83BitlrP0t+ZdXlFSPORkFgjtjYl1ibKo4YYv2slBOpt42sbGUIsHYN4
JvLzK2EYp63RXu9+dqTIjAs9v72aHoF0Y8DZsNimayUEbLdEpMSfhEV7p4tI
CQv3Uksk7n5Wujw1hEgMkRgi0cJqiMQQiZStEIkhElmmxGyy65VsGUy20eZu
UXgqxfs76lXfaJ/Sq/IBdXqSnTo/qvydZjxD6K/V0/qvy+a6Iv4OYC9ZsbvO
/FvtYayiPdwJrZnzt4KlxKjVNCMu6aHXld6M0eMy6e9e3u0qQ2zF4TK2Ugxz
OFwG3Tdj+urF9v6ymU2QtZlRXAH1mFRcN8+glmu8Z5yX7nNsFgTc18j8nMq2
Pvslxf/Hpr14b/MsakGQ3hf4yy5tG99Cfqe1z8Bn4DPw+c/49LnDaW4ZmtsJ
davD/4qo9KpbIHcbQvmr8M4VNfeUKP4GSZ0rhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64714736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18494],

Cell["Lower-triangular matrix:", "ExampleText",
 CellID->20216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Array", "[", 
    RowBox[{"Greater", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vwjAQNXYpLYW9I7+mFQMzc4QqwVC1ogxsjBkzZuQnZMyYMWNGRkZG
xozp+QuHNLhNk5AgGSk52zr8nu/OT3ATazV/e7dWi5k1el1an/PF7Gv08rGE
JdJBCE3hGT8jGCcwYs80ScCm3136JtvtNmEfNGbzzWYj5oR53bHhbrfzfV+u
dmHD/gX7BJaA7cndoyjK7ua6rsDgHCg/Ph8UnPfZJqc5w0DonnnFcbxerxU2
kascXnhVjc3Pbds2ANEhPmHjMAx7NWJCgiBN55gs1ofDoe7zqvpIY6taqhMb
As2L+KrYDzK6YqmTi03rG4P3UGMp1GPme/m7TYyXWKU6olOfQaG4Fq2Q/IrQ
1YlhYBjcBgOdYhW/WW3Vj+YVK6tU1SpWkbqos14ND8OjDTzyVO3/t6+tGtOc
ql1Ss3KqVr46qqxdw8awuT02aeUrf0PbqkNFvBzH+YOX6oulveD//vF4lHHV
xVNanqX9fu95Hh2mexS+74vuGOuL1VAjur5JEAQ5/SI4nmDaBCfIzVnfLNsv
JA1wUpWhOGHI23XjQ1UFQ2YYquibqrjgq3P5kRXBiTcbm+Kk0Dmn336XSDtk
3rwvjjrfQoJpYQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->609199547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84766922],

Cell["Matrix with generic symbolic entries:", "ExampleText",
 CellID->24228588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524524391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWNtOwkAQXdpC8UKrURIfEPgA/Q198iMIMYEHo0FevXybfljtNl2spzPM
7AaERNiZPXM509ll8GG2Xjw+zdbL+Wx6v5q9LJbz1+nd86pUxR1jOl/GmPzK
lOuiXFV/o6IoTGxX1cuMQZ4I8o0nHv3feuJxf2jfTAJalNPyrVuKEegp3aCJ
TTb68mVB6JlHRwQ6Y/KIau+oR/tjkPu1XUzwQl3WxLZ4ITpn0RwvykvE6DW8
qDgcrw1W5MWjrba7DR3Aq9r3Zh87qpvcTJ2DzeWMQv8yKRe9bUhg0a7BucZq
ixzXfpDVEVWFFstubZ1T6D8sHRJZUs+qzZL0L7DSsDyh/LAssdaQq4QU5BA7
qVcrvKrvqXsuFaJx9zTaae93KV6fsbMnKFGc734g733nH1pnx1v6Pj007133
iZa3rvvpM09xoG6UNMg68bLG5+dui77KuteQDVM16w1v/LC6+DHjqqpjxtVF
FxvrgtOEX12wqj3GG52bZL2926hzE27drANXl/Ypk2ZhekqS+uFUZYVPMtuj
VVrQs+dAxbdZJeP6HL2IVmmhyVyy0sVysz125CH57rNKHF/s506F10xWSR0l
anjPQY93TOa5j3Mtnkacn11e1JlwUzq1j+czU+IGDI6aTP4jby4fLT8p711O
IiNSe+2hvRCqSsf1iUDneLnDuD5VwLjhv4qsOK4/J/ApsYsZO+dv6GmPeaB9
GMsPIYtPz306C2lSfwMZfwe/e+7T/9mxy2/FynR+ACjtV/I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392242409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180813122],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWDtvGkEQXu54GGNLfiQ2jlz4D+RvJFV+BLIi2UXkyHGBXJgSOkpKfgIl
JSUlJSUlJSXlZWYft3tzc+c94YsIJ92ys/PYmd2Z/dj70Xl5+Pmr8/J437n7
/tz5/fB4/+fu29MzDIUVIcQA3q9tAf0IevIdRBH8XmMbIi0fcVuQPpdWsA1g
sEq4NUF41ZgHDwpeZHJx9DLDbqC1T+TsNckdj8ea22KkpSuxbeiLz5yU9QA6
V5xEDn1RUF753ev1NB3KaVWsy+VyOp1Kl6BB56l2g9CtfyRXhwaXqW5WfbFY
UO9Ho5EbU2rt6X7WCX1cohaNs+mlVXNo5Csr2+222+3a6EMzqhZAWUnZDoit
I684qFaD0K0StdDDIPa03+9DiJHJaBl1MJ/PTWaEzD6h9mkGn8u8XeToeqo8
gXKCokp6LTN1vV5n79WXnUfVCWvr2Z3d1j7mF7p8m/HbjnRmqWMuw8qbiUnT
lRwpSx+ilMSlHXDt1GsWzMCQyUCDezGPxT2ea3CPs2tw78jbO1ebz/BLTiqB
g584iRxcOyso3/CKBitkH3HQby/4tX/vhOOR4GO06CnJ4yB3lrvI0Nwh+v8X
B/2ixozdRzz0q7ey8LDtvXZ5eHjjZWVf0elQ8RArljsrcezM5aXw8DyTG2i0
5Owm8XA4HOZ6d0K0+bsJRTuC0CJ9c+RQOnVHLiCv6tPeZ91o4L/dZrOJov3F
QyW/Wq0mk0kcnfYe/gLr2+Kh4qGyMpvNmLsGbJxekzKjpx7xyPYxWuihvRdC
/SXuhfRbANJVnTlGy8VBM94ks7QK8o/Z2Ow5YL0LIBvLwjn8ehTAfkv7+vtB
8rtIHr5dM/LGirqwYveV0Epq4LSi8hdCrwom\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{136, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->173615794]
}, Open  ]],

Cell["Use it to see the effects of some linear algebra functions:", \
"ExampleText",
 CellID->194245192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", "m", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->301330263],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{493, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->479619665]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Take", "[", 
   RowBox[{"m", ",", "All", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->36076642],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWNtOg0AQ3XIrTSlU05s+KP6MPvkRpDFpH4ym9v9xd4WmPQzsLILEkrQw
uzPnnJm9cHnNjru39+y432bpyyH73O23X+nzx0E2uSMhHCGPZCPkdS6v9G+Z
57lw1ZU+xBrsFdhpz/5Phn6MR/yu/QP1J2L578tGR1neqVceqqaqV4W4lV7V
GhVeHiArvEUtrnKc1eI6Ra89bkUvRE7PUSuKVue4RGS92rgRd9lYh6hBb1SL
67TWW9a+HlfHiDmgoj5knYIN2KKK6JRiT+xqCW8o3guchGJqUBa157XNt4KK
WmEOyIt7ireCM7PMGf2rvHfGOsesDMlRbbBxT7bI90LdDYNX3hbESJ11yCSn
18sY7IDp5zP92sZdq455x3hcfclAvEHP9eTi/ayCMKfWG+52Idj02scoZKSj
cO/C+vBQTNx+qzzp3agfxUPWOOmQq11eJoVxjwp5cwUVklHWM+6vFV/eA4uH
O3245Z5hZD8fG9UfkFEOeI3BpjVjFM6echfk1enalfLWlim/8o7R5YzlcLYb
Cb5SrGn7cexb6ZA11f36adgrLPXWNyFq6TGU+zV+QQ2u/894S7wxU9cceELL
eG7+iSEfU31CCz2Uvr7za3paXZKtC7IVv3nRK21YxEcLXxr34dcI+K2Q3sds
EPUbup6XblE1t+BR59Sy/QnsNfhz22+1qlKn06ElRt/qSL1w\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{512, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3168353]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16038],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["c", "TI"], "&"}], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " are equivalent:"
}], "ExampleText",
 CellID->296476528],

Cell[BoxData[
 RowBox[{
  RowBox[{"dims", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190163079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstantArray", "[", 
   RowBox[{"c", ",", "dims"}], "]"}], "===", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{"c", "&"}], ",", "dims"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226552683],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->507984]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is a machine number, ",
 Cell[BoxData[
  ButtonBox["ConstantArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConstantArray"]], "InlineFormula"],
 " is much faster for large arrays:"
}], "ExampleText",
 CellID->294785572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"Timing", "[", 
     RowBox[{"ca", "=", 
      RowBox[{"ConstantArray", "[", 
       RowBox[{"0.", ",", 
        RowBox[{"{", 
         RowBox[{"2000", ",", "2000"}], "}"}]}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"First", "[", 
    RowBox[{"Timing", "[", 
     RowBox[{"a", "=", 
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{"0.", "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"2000", ",", "2000"}], "}"}]}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ca", "===", "a"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->920046352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.029999999999999888`", ",", "0.22999999999999965`", ",", "True"}],
   "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475012373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178672156],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " can be generated using ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->745479165],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dims", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], "]"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "args___", "]"}], ":=", 
  RowBox[{"Total", "[", 
   RowBox[{"{", "args", "}"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->130931651],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"Array", "[", 
    RowBox[{"f", ",", "dims"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56184360],

Cell[TextData[{
 "Set up the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " limit specifications:"
}], "ExampleText",
 CellID->7789323],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Length", "[", "dims", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"tl", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"v", ",", "dims"}], "}"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->6048894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->30508468]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " to splice them into a ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command:"
}], "ExampleText",
 CellID->623132213],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"f", "@@", "v"}], ",", "##"}], "]"}], "&"}], "@@", " ", 
    "tl"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->687378590],

Cell[TextData[{
 "The result is identical to the array generated using ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->282257782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "===", "t"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->773057721],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->96435072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->397694197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["i_", "TI"], ",", 
       StyleBox["j_", "TI"]}], "}"}], "->", 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"]}], "]"}]}], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " gives a sparse representation of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->253394150],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dims", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"i_", ",", "j_"}], "]"}], ":=", " ", 
  RowBox[{"i", "-", 
   RowBox[{"2", " ", "j"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->293401076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "j_"}], "}"}], "\[Rule]", 
     RowBox[{"f", "[", 
      RowBox[{"i", ",", "j"}], "]"}]}], ",", "dims"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132973428],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "33", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 33, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "7"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14545228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"f", ",", "dims"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95023340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "11"}], ",", 
     RowBox[{"-", "13"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "10"}], ",", 
     RowBox[{"-", "12"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}], ",", 
     RowBox[{"-", "11"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "6"}], ",", 
     RowBox[{"-", "8"}], ",", 
     RowBox[{"-", "10"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "9"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{568, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->359567860]
}, Open  ]],

Cell[TextData[{
 "The results are ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->648911896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "\[Equal]", "a"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->615359722],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->36528535]
}, Open  ]],

Cell["\<\
The objects are not identical, but the represented arrays are:\
\>", "ExampleText",
 CellID->493305469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SameQ", "[", 
    RowBox[{"s", ",", "a"}], "]"}], ",", 
   RowBox[{"SameQ", "[", 
    RowBox[{
     RowBox[{"Normal", "[", "s", "]"}], ",", "a"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74310668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->368185635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18352],

Cell["Array of powers:", "ExampleText",
 CellID->15862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"Power", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81", ",", "243"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "16", ",", "64", ",", "256", ",", "1024"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"5", ",", "25", ",", "125", ",", "625", ",", "3125"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{364, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425205876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11128],

Cell["Array of GCDs:", "ExampleText",
 CellID->21465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"GCD", ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14329],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm09uglAQxiF2IYmbdlV2pk28ANsm7tqNbpu4JKZWF00bce+6CRewB3DT
jYnuvYAX8AJcgAPYGWDIA4TaSqMNHwm+P/O9+SXwcN48tGtPhk8v9mTUt5sP
Y/ttOOo7zfvXMXXVdE3TVnxea1TfUS08a7sdV/hY0KmHzRrbgkNb0IceCo7v
vYh76aj7vm94nheUm83GWK/XdWob1K5zm/un06nYYz3pjMge69k5OOBUiPPB
4xqNBo+H5nea+Npvt1tDrvlyuYzvgeu68b2k/r160zRFDw444JTPeedxrVbL
LHiWq6zJxBw1hsxmMyNlT+gty0royQ4OOOCUz7lkO3/38TheF1Kd+wzu43ZU
D3TtdvtK0fP6EH7h95R+E/Ne5juX8/lc5r9qD8pOp5PR+weuK8ABB5wfc57Z
3uv17vz8NWOVNYk8ROK95C3cjvKTQDcYDL7TgwMOOOVzHtnuOE634FmGpliT
iTnqfrTEHNmPVmMP70enYw7pwAGnShzJpSRHCvIo13Uln0rYo374gq9T+Dpq
Hyuy//l+GTjgnCnHYj3l4moJ7Wm0iZxB7p36blHNMfLeLSp6cMABp3zODY+j
NbVa8hr7Niox7rzHFcZW+b1aXmzdowcHHHDK5+zNE1Nl2g5f8HWor8x+mjov
vZx3kwV6cMABp3zOZ8Ez/E9tR/+zaBXa9C8uFQ4b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89616112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24082],

Cell["Array of arrays:", "ExampleText",
 CellID->5389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{"x", "&"}], ",", "#"}], "]"}], "&"}], ",", 
   RowBox[{"{", "6", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->933119044]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30542],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17855],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->39801072],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->176326365],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->408059916],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->466344252],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->16192463],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->331159101],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->955845346],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->193618400],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->618155562]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Array - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 45.9248106}", "context" -> "System`", 
    "keywords" -> {
     "lists", "matrices", "tensors", "vectors", "array constructor", 
      "array from function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Array[f, n] generates a list of length n, with elements f[i]. Array[f, \
{n_1, n_2, ...}] generates an n_1*n_2* ... array of nested lists, with \
elements f[i_1, i_2, ...]. Array[f, {n_1, n_2, ...}, {r_1, r_2, ...}] \
generates a list using the index origins r_i (default 1). Array[f, dims, \
origin, h] uses head h, rather than List, for each level of the array. ", 
    "synonyms" -> {}, "title" -> "Array", "type" -> "Symbol", "uri" -> 
    "ref/Array"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7609, 224, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47492, 1671}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3287, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3910, 97, 43, 1, 70, "ObjectName",
 CellID->17933],
Cell[3956, 100, 3616, 119, 70, "Usage",
 CellID->25188]
}, Open  ]],
Cell[CellGroupData[{
Cell[7609, 224, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[7986, 238, 146, 5, 70, "ExampleSection",
 CellID->7844076],
Cell[CellGroupData[{
Cell[8157, 247, 121, 4, 28, "Input",
 CellID->18584],
Cell[8281, 253, 576, 17, 36, "Output",
 CellID->1220103670]
}, Open  ]],
Cell[CellGroupData[{
Cell[8894, 275, 191, 7, 28, "Input",
 CellID->31668],
Cell[9088, 284, 301, 9, 36, "Output",
 CellID->2108520134]
}, Open  ]],
Cell[9404, 296, 120, 3, 70, "ExampleDelimiter",
 CellID->3198],
Cell[9527, 301, 172, 7, 70, "ExampleText",
 CellID->12280],
Cell[CellGroupData[{
Cell[9724, 312, 169, 6, 28, "Input",
 CellID->27479],
Cell[9896, 320, 709, 25, 36, "Output",
 CellID->122749344]
}, Open  ]],
Cell[10620, 348, 171, 7, 70, "ExampleText",
 CellID->1813],
Cell[CellGroupData[{
Cell[10816, 359, 236, 9, 70, "Input",
 CellID->6860],
Cell[11055, 370, 436, 14, 36, "Output",
 CellID->1463923488]
}, Open  ]],
Cell[11506, 387, 121, 3, 70, "ExampleDelimiter",
 CellID->29846],
Cell[11630, 392, 169, 7, 70, "ExampleText",
 CellID->7271],
Cell[CellGroupData[{
Cell[11824, 403, 131, 4, 70, "Input",
 CellID->32182],
Cell[11958, 409, 574, 17, 36, "Output",
 CellID->441919137]
}, Open  ]],
Cell[12547, 429, 224, 9, 70, "ExampleText",
 CellID->79388808],
Cell[CellGroupData[{
Cell[12796, 442, 232, 8, 70, "Input",
 CellID->272100553],
Cell[13031, 452, 720, 25, 36, "Output",
 CellID->500921262]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13800, 483, 239, 7, 70, "ExampleSection",
 CellID->25636],
Cell[14042, 492, 136, 5, 70, "ExampleText",
 CellID->12353],
Cell[CellGroupData[{
Cell[14203, 501, 263, 9, 70, "Input",
 CellID->7549],
Cell[14469, 512, 816, 25, 54, "Output",
 CellID->1336484233]
}, Open  ]],
Cell[15300, 540, 120, 3, 70, "ExampleDelimiter",
 CellID->7639],
Cell[15423, 545, 323, 13, 70, "ExampleText",
 CellID->32046],
Cell[CellGroupData[{
Cell[15771, 562, 191, 6, 70, "Input",
 CellID->3362],
Cell[15965, 570, 534, 18, 36, "Output",
 CellID->1926370204]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16548, 594, 223, 7, 70, "ExampleSection",
 CellID->14078],
Cell[16774, 603, 162, 6, 70, "ExampleText",
 CellID->4985],
Cell[CellGroupData[{
Cell[16961, 613, 188, 7, 70, "Input",
 CellID->10103],
Cell[17152, 622, 392, 13, 36, "Output",
 CellID->1040556456]
}, Open  ]],
Cell[17559, 638, 119, 3, 70, "ExampleDelimiter",
 CellID->377],
Cell[17681, 643, 68, 1, 70, "ExampleText",
 CellID->26350],
Cell[CellGroupData[{
Cell[17774, 648, 262, 9, 70, "Input",
 CellID->6048],
Cell[18039, 659, 1044, 21, 70, "Output",
 Evaluatable->False,
 CellID->64714736]
}, Open  ]],
Cell[19098, 683, 121, 3, 70, "ExampleDelimiter",
 CellID->18494],
Cell[19222, 688, 63, 1, 70, "ExampleText",
 CellID->20216],
Cell[CellGroupData[{
Cell[19310, 693, 250, 9, 70, "Input",
 CellID->12729],
Cell[19563, 704, 849, 18, 70, "Output",
 Evaluatable->False,
 CellID->609199547]
}, Open  ]],
Cell[20427, 725, 124, 3, 70, "ExampleDelimiter",
 CellID->84766922],
Cell[20554, 730, 79, 1, 70, "ExampleText",
 CellID->24228588],
Cell[CellGroupData[{
Cell[20658, 735, 245, 9, 70, "Input",
 CellID->524524391],
Cell[20906, 746, 992, 20, 70, "Output",
 Evaluatable->False,
 CellID->392242409]
}, Open  ]],
Cell[CellGroupData[{
Cell[21935, 771, 106, 3, 70, "Input",
 CellID->180813122],
Cell[22044, 776, 1114, 22, 70, "Output",
 Evaluatable->False,
 CellID->173615794]
}, Open  ]],
Cell[23173, 801, 104, 2, 70, "ExampleText",
 CellID->194245192],
Cell[CellGroupData[{
Cell[23302, 807, 138, 4, 70, "Input",
 CellID->301330263],
Cell[23443, 813, 2822, 50, 70, "Output",
 Evaluatable->False,
 CellID->479619665]
}, Open  ]],
Cell[CellGroupData[{
Cell[26302, 868, 165, 5, 70, "Input",
 CellID->36076642],
Cell[26470, 875, 929, 19, 70, "Output",
 Evaluatable->False,
 CellID->3168353]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27448, 900, 233, 7, 70, "ExampleSection",
 CellID->16038],
Cell[27684, 909, 547, 21, 70, "ExampleText",
 CellID->296476528],
Cell[28234, 932, 258, 9, 70, "Input",
 CellID->190163079],
Cell[CellGroupData[{
Cell[28517, 945, 240, 8, 70, "Input",
 CellID->226552683],
Cell[28760, 955, 158, 5, 36, "Output",
 CellID->507984]
}, Open  ]],
Cell[28933, 963, 314, 11, 70, "ExampleText",
 CellID->294785572],
Cell[CellGroupData[{
Cell[29272, 978, 687, 22, 70, "Input",
 CellID->920046352],
Cell[29962, 1002, 259, 8, 36, "Output",
 CellID->475012373]
}, Open  ]],
Cell[30236, 1013, 125, 3, 70, "ExampleDelimiter",
 CellID->178672156],
Cell[30364, 1018, 414, 16, 70, "ExampleText",
 CellID->745479165],
Cell[30781, 1036, 491, 17, 70, "Input",
 CellID->130931651],
Cell[31275, 1055, 180, 6, 70, "Input",
 CellID->56184360],
Cell[31458, 1063, 207, 8, 70, "ExampleText",
 CellID->7789323],
Cell[CellGroupData[{
Cell[31690, 1075, 329, 11, 70, "Input",
 CellID->6048894],
Cell[32022, 1088, 363, 13, 36, "Output",
 CellID->30508468]
}, Open  ]],
Cell[32400, 1104, 330, 13, 70, "ExampleText",
 CellID->623132213],
Cell[32733, 1119, 268, 10, 70, "Input",
 CellID->687378590],
Cell[33004, 1131, 230, 8, 70, "ExampleText",
 CellID->282257782],
Cell[CellGroupData[{
Cell[33259, 1143, 94, 3, 70, "Input",
 CellID->773057721],
Cell[33356, 1148, 160, 5, 36, "Output",
 CellID->96435072]
}, Open  ]],
Cell[33531, 1156, 125, 3, 70, "ExampleDelimiter",
 CellID->397694197],
Cell[33659, 1161, 773, 29, 70, "ExampleText",
 CellID->253394150],
Cell[34435, 1192, 418, 14, 70, "Input",
 CellID->293401076],
Cell[CellGroupData[{
Cell[34878, 1210, 301, 10, 70, "Input",
 CellID->132973428],
Cell[35182, 1222, 480, 17, 36, "Output",
 CellID->14545228]
}, Open  ]],
Cell[CellGroupData[{
Cell[35699, 1244, 150, 5, 70, "Input",
 CellID->95023340],
Cell[35852, 1251, 1344, 46, 54, "Output",
 CellID->359567860]
}, Open  ]],
Cell[37211, 1300, 193, 8, 70, "ExampleText",
 CellID->648911896],
Cell[CellGroupData[{
Cell[37429, 1312, 99, 3, 70, "Input",
 CellID->615359722],
Cell[37531, 1317, 160, 5, 36, "Output",
 CellID->36528535]
}, Open  ]],
Cell[37706, 1325, 113, 3, 70, "ExampleText",
 CellID->493305469],
Cell[CellGroupData[{
Cell[37844, 1332, 266, 9, 70, "Input",
 CellID->74310668],
Cell[38113, 1343, 210, 7, 36, "Output",
 CellID->368185635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38372, 1356, 224, 7, 70, "ExampleSection",
 CellID->18352],
Cell[38599, 1365, 55, 1, 70, "ExampleText",
 CellID->15862],
Cell[CellGroupData[{
Cell[38679, 1370, 172, 6, 70, "Input",
 CellID->6421],
Cell[38854, 1378, 657, 19, 54, "Output",
 CellID->425205876]
}, Open  ]],
Cell[39526, 1400, 121, 3, 70, "ExampleDelimiter",
 CellID->11128],
Cell[39650, 1405, 53, 1, 70, "ExampleText",
 CellID->21465],
Cell[CellGroupData[{
Cell[39728, 1410, 212, 7, 70, "Input",
 CellID->14329],
Cell[39943, 1419, 923, 19, 70, "Output",
 Evaluatable->False,
 CellID->89616112]
}, Open  ]],
Cell[40881, 1441, 121, 3, 70, "ExampleDelimiter",
 CellID->24082],
Cell[41005, 1446, 54, 1, 70, "ExampleText",
 CellID->5389],
Cell[CellGroupData[{
Cell[41084, 1451, 245, 9, 70, "Input",
 CellID->24986],
Cell[41332, 1462, 616, 19, 36, "Output",
 CellID->933119044]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42009, 1488, 311, 9, 70, "SeeAlsoSection",
 CellID->30542],
Cell[42323, 1499, 1684, 62, 70, "SeeAlso",
 CellID->14659]
}, Open  ]],
Cell[CellGroupData[{
Cell[44044, 1566, 314, 9, 70, "TutorialsSection",
 CellID->17855],
Cell[44361, 1577, 152, 3, 70, "Tutorials",
 CellID->39801072],
Cell[44516, 1582, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[44682, 1590, 319, 9, 70, "MoreAboutSection",
 CellID->176326365],
Cell[45004, 1601, 147, 3, 70, "MoreAbout",
 CellID->408059916],
Cell[45154, 1606, 153, 3, 70, "MoreAbout",
 CellID->466344252],
Cell[45310, 1611, 154, 3, 70, "MoreAbout",
 CellID->16192463],
Cell[45467, 1616, 145, 3, 70, "MoreAbout",
 CellID->331159101],
Cell[45615, 1621, 145, 3, 70, "MoreAbout",
 CellID->955845346],
Cell[45763, 1626, 152, 3, 70, "MoreAbout",
 CellID->193618400],
Cell[45918, 1631, 126, 3, 70, "MoreAbout",
 CellID->618155562]
}, Open  ]],
Cell[46059, 1637, 50, 0, 70, "History"],
Cell[46112, 1639, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

