(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20555,        760]
NotebookOptionsPosition[     15954,        598]
NotebookOutlinePosition[     17331,        636]
CellTagsIndexPosition[     17246,        631]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Nested Lists\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "Depth" :> 
          Documentation`HelpLookup["paclet:ref/Depth"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dimensions\"\>", 2->"\<\"Depth\"\>",
        3->"\<\"ArrayQ\"\>", 4->"\<\"VectorQ\"\>", 5->"\<\"MatrixQ\"\>", 
       6->"\<\"PadLeft\"\>", 7->"\<\"ArrayFlatten\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArrayDepth", "ObjectName",
 CellID->16807],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayDepth",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayDepth"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the depth to which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a full array, with all the parts at a particular level being lists \
of the same length, or is a ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   RowBox[{
    ButtonBox["Dimensions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dimensions"], "[", 
    StyleBox["list", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15374]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->789046748],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->173965751],

Cell["Find the depth to which an array is full:", "ExampleText",
 CellID->9389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27625],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "c", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3128],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2039]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20394],

Cell[TextData[{
 "Find the depth of a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12690304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_", ",", "j_"}], "}"}], "\[Rule]", 
     RowBox[{"j", "/", 
      RowBox[{"(", 
       RowBox[{"i", "+", "1"}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250975695],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "15", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 15, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675853810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124460948],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37640522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289028199],

Cell["Find the array depth of a list of sparse matrices:", "ExampleText",
 CellID->508969794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sl", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"j", "/", "i"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215790648],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtOwzAMTZt2V7YxCaHxNpAQXwGP8MQvMFUT0vaAQGP/X3JzCY6zpkOb
dkmkLrGT2M6Z4yR+LdaL949ivZwX05dV8bVYzr+nz58rweIJY8kbY+x2wkS7
FC31yTITn27q1lD8ctH5KOpM1LmoU1HfyF4Os0rWQ3QX0SNEZ0ZOjviDPevj
apV49BMx26YnRhq2omf445r53Izbt15Mp2r1HdWluUwVbtCX43NgMNMnvtTq
l7WGFQoooWblhg31Jutall26cGJWC9EdAmtO/PNtD78OM9uqiFa4h6VmTZaN
YJ/Lye11VJA53JTS7oyqQ47W6IsYwKdnwc5umRrHpXSjrra3tw5zmB1R3iXK
rmdfbI111xknVxOy0/2YwKjqv0T2UlgBlkPEbyMan1XYSkyPIzIeGutPyiBP
KvXpQWEAkR5jFOrXmavNM7PaP3/sou4e+KTBKJFRpYn/nBkedPzpWqsNiv1m
HB3D6bhJIQgxu6ks8tZC7EUymhDYX5b+88Om4R0TcdrGy6hbYlotWRd73+E+
uCHD7dLWwjxzUo8cuBvzCiZm9eK3pE1f1WDadEdi+RGVcA+Sa3hAvCmi1Xns
7IxrSr4zakBy62zF2Bymlf6TwPYM+XtveHem7pfaQyaEBEmOStcTQaMdRXap
g87QyObs3y2sE161p53dwhEASzvVbBfozUgU7BvAb6SMeZx6qyJaYRGZ8riY
n6nwiVmwI0ZZb1uMCXoJN8D81HM+MRvmo5UeOmLH7E+4/5wZHrTXwDkeszyb
0YvZsDCcaC/DvhnzPpT8iEq4Bx1mnuk4smEaYeoFdgrZsL4SLVmzgBZLfgAB
oAc0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523380755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", "sl", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->510476733],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39249535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8490],

Cell[TextData[{
 "Use a head other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"c", ",", "d"}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28054],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12618],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayDepth"]], "InlineFormula"],
 " gives the length of the dimensions list:"
}], "ExampleText",
 CellID->3148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayDepth", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2282],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29743]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27222],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dimensions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dimensions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17438],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->21156],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->14820]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->336587270],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->78395244],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->457812423]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArrayDepth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 44.5966516}", "context" -> "System`", 
    "keywords" -> {
     "array dimensions", "tensor rank", "multi dimensional array"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArrayDepth[expr] gives the depth to which expr is a full array, with all \
the parts at a particular level being lists of the same length, or is a \
SparseArray object. ", "synonyms" -> {"array depth"}, "title" -> "ArrayDepth",
     "type" -> "Symbol", "uri" -> "ref/ArrayDepth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5054, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->789046748]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17103, 624}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2479, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3102, 82, 48, 1, 70, "ObjectName",
 CellID->16807],
Cell[3153, 85, 809, 24, 70, "Usage",
 CellID->845]
}, Open  ]],
Cell[CellGroupData[{
Cell[3999, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4477, 131, 540, 20, 70, "Notes",
 CellID->15374]
}, Closed]],
Cell[CellGroupData[{
Cell[5054, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->789046748],
Cell[CellGroupData[{
Cell[5439, 170, 148, 5, 70, "ExampleSection",
 CellID->173965751],
Cell[5590, 177, 79, 1, 70, "ExampleText",
 CellID->9389],
Cell[CellGroupData[{
Cell[5694, 182, 251, 9, 28, "Input",
 CellID->27625],
Cell[5948, 193, 153, 5, 36, "Output",
 CellID->8029]
}, Open  ]],
Cell[CellGroupData[{
Cell[6138, 203, 224, 8, 28, "Input",
 CellID->3128],
Cell[6365, 213, 153, 5, 36, "Output",
 CellID->2039]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6567, 224, 216, 7, 70, "ExampleSection",
 CellID->20394],
Cell[6786, 233, 208, 8, 70, "ExampleText",
 CellID->12690304],
Cell[CellGroupData[{
Cell[7019, 245, 393, 13, 70, "Input",
 CellID->250975695],
Cell[7415, 260, 491, 17, 36, "Output",
 CellID->675853810]
}, Open  ]],
Cell[CellGroupData[{
Cell[7943, 282, 106, 3, 70, "Input",
 CellID->124460948],
Cell[8052, 287, 157, 5, 36, "Output",
 CellID->37640522]
}, Open  ]],
Cell[8224, 295, 125, 3, 70, "ExampleDelimiter",
 CellID->289028199],
Cell[8352, 300, 93, 1, 70, "ExampleText",
 CellID->508969794],
Cell[CellGroupData[{
Cell[8470, 305, 441, 15, 70, "Input",
 CellID->215790648],
Cell[8914, 322, 1070, 22, 70, "Output",
 Evaluatable->False,
 CellID->523380755]
}, Open  ]],
Cell[CellGroupData[{
Cell[10021, 349, 107, 3, 70, "Input",
 CellID->510476733],
Cell[10131, 354, 157, 5, 36, "Output",
 CellID->39249535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10337, 365, 238, 7, 70, "ExampleSection",
 CellID->8490],
Cell[10578, 374, 193, 8, 70, "ExampleText",
 CellID->29648],
Cell[CellGroupData[{
Cell[10796, 386, 266, 9, 70, "Input",
 CellID->28054],
Cell[11065, 397, 153, 5, 36, "Output",
 CellID->5517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11267, 408, 233, 7, 70, "ExampleSection",
 CellID->12618],
Cell[11503, 417, 217, 7, 70, "ExampleText",
 CellID->3148],
Cell[CellGroupData[{
Cell[11745, 428, 219, 7, 70, "Input",
 CellID->24056],
Cell[11967, 437, 209, 7, 36, "Output",
 CellID->22990]
}, Open  ]],
Cell[CellGroupData[{
Cell[12213, 449, 218, 7, 70, "Input",
 CellID->2282],
Cell[12434, 458, 154, 5, 36, "Output",
 CellID->29743]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12649, 470, 311, 9, 70, "SeeAlsoSection",
 CellID->27222],
Cell[12963, 481, 1672, 62, 70, "SeeAlso",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[14672, 548, 314, 9, 70, "TutorialsSection",
 CellID->17438],
Cell[14989, 559, 134, 3, 70, "Tutorials",
 CellID->21156],
Cell[15126, 564, 125, 3, 70, "Tutorials",
 CellID->14820]
}, Open  ]],
Cell[CellGroupData[{
Cell[15288, 572, 319, 9, 70, "MoreAboutSection",
 CellID->336587270],
Cell[15610, 583, 143, 3, 70, "MoreAbout",
 CellID->78395244],
Cell[15756, 588, 126, 3, 70, "MoreAbout",
 CellID->457812423]
}, Open  ]],
Cell[15897, 594, 27, 0, 70, "History"],
Cell[15927, 596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

