(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79886,       2547]
NotebookOptionsPosition[     69321,       2183]
NotebookOutlinePosition[     70811,       2223]
CellTagsIndexPosition[     70725,       2218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingNestedLists"], 
          "Combining Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/CombiningLists"], 
          "Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rearranging Nested Lists\"\>", 
       2->"\<\"Combining Lists\"\>", 3->"\<\"Structural Operations\"\>", 
       4->"\<\"Vectors and Matrices\"\>", 
       5->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flatten" :> Documentation`HelpLookup["paclet:ref/Flatten"], 
          "Join" :> Documentation`HelpLookup["paclet:ref/Join"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"], "ArrayQ" :> 
          Documentation`HelpLookup["paclet:ref/ArrayQ"], "ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Flatten\"\>", 2->"\<\"Join\"\>", 
       3->"\<\"Band\"\>", 4->"\<\"ArrayQ\"\>", 5->"\<\"ArrayDepth\"\>", 
       6->"\<\"PadLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Constructing Matrices\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>", 
       6->"\<\"New in 6.0: List Manipulation\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       8->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>", 
       9->"\<\"New in 6.0: Numerical Data Handling\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ArrayFlatten", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayFlatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayFlatten"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["m", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["m", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["m", "TI"], 
            StyleBox["21", "TR"]], ",", 
           SubscriptBox[
            StyleBox["m", "TI"], 
            StyleBox["22", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a single flattened matrix from a matrix of \
matrices ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["m", 
        RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayFlatten",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayFlatten"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]flattens out ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " pairs of levels in the array ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " requires that the blocks it flattens have dimensions that fit together."
}], "Notes",
 CellID->695197793],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " can be used to form block matrices from arrays of blocks. "
}], "Notes",
 CellID->25412],

Cell[TextData[{
 "For a matrix of matrices, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " yields a matrix whose elements are in the same order as in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5881],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " is normally equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->84678301]
}], "Notes",
 CellID->13467],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " is normally equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{
         StyleBox["r", "TI"], "+", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{
         StyleBox["r", "TI"], "+", "2"}]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        RowBox[{"2", 
         StyleBox["r", "TI"]}]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->285642332],

Cell[TextData[{
 "For a tensor with rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "r"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 " gives a tensor with rank ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->93072372],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["12", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["21", "TR"]], ",", 
       SubscriptBox[
        StyleBox["m", "TI"], 
        StyleBox["22", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " all the matrices ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " in the same row must have the same first dimension, and matrices ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " in the same column must have the same second dimension."
}], "Notes",
 CellID->381535951],

Cell[TextData[{
 "In general, in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
 ", all the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " dimensions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "[", 
    RowBox[{"[", 
     RowBox[{
      SubscriptBox["i", "1"], ",", 
      SubscriptBox["i", "2"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["i", "r"]}], "]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 " must be equal for each possible value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", "k"], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->12629040],

Cell[TextData[{
 "Elements at level ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " whose array depth is less than ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " are treated as scalars, and are replicated to fill out a rank ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " array of the appropriate dimensions."
}], "Notes",
 CellID->977832692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->383845108]
}], "Notes",
 CellID->567196614]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27368941],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->57568274],

Cell["\<\
Create a block matrix by flattening out a matrix of matrices:\
\>", "ExampleText",
 CellID->5041],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayFlatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", ",", "m", ",", "m"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "m", ",", "m"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8383],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3", ",", "4", ",", "3", ",", "4"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3", ",", "4", ",", "3", ",", "4"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{500, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118134838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30144],

Cell["Use 0s to represent zero matrices:", "ExampleText",
 CellID->30388],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayFlatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "m"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "m", ",", "0"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "3", ",", "4"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3", ",", "4", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{500, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385558437]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4202],

Cell["Flatten a rank 4 array to rank 2:", "ExampleText",
 CellID->126285817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}], "]"}], "//",
   "Dimensions"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465263435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64540470]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42094289],

Cell["Flatten only the first four levels of a rank 6 array:", "ExampleText",
 CellID->46568723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
      "}"}]}], "]"}], "]"}], "//", "Dimensions"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127977059],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "8", ",", "5", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56206048]
}, Open  ]],

Cell["Flatten a rank 6 array to rank 3:", "ExampleText",
 CellID->344938154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
       "}"}]}], "]"}], ",", "3"}], "]"}], "//", "Dimensions"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187415012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "10", ",", "18"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->973515370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610512187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->383845108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_", ",", " ", "j_", ",", "k_"}], "}"}], "\[Rule]", 
     
     RowBox[{"i", "/", 
      RowBox[{"(", 
       RowBox[{"j", "+", "k", "-", "1"}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550113518],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "12", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 12, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "2", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525523788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"ArrayFlatten", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192035114],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "12", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 12, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315338505]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->113945058],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      FractionBox["1", "2"], "0", "0", "0", "0"},
     {
      FractionBox["1", "2"], 
      FractionBox["1", "3"], "0", "0", "0", "0"},
     {"0", "0", "2", "1", "0", "0"},
     {"0", "0", "1", 
      FractionBox["2", "3"], "0", "0"},
     {"0", "0", "0", "0", "3", 
      FractionBox["3", "2"]},
     {"0", "0", "0", "0", 
      FractionBox["3", "2"], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {6, 6}, 0, {
     1, {{0, 2, 4, 6, 8, 10, 12}, {{2}, {1}, {2}, {1}, {3}, {4}, {4}, {3}, {
       5}, {6}, {5}, {6}}}, {
      Rational[1, 2], 1, Rational[1, 3], Rational[1, 2], 2, 1, Rational[2, 3],
        1, 3, Rational[3, 2], Rational[3, 2], 1}}], 
    BoxForm`opts$3497]]]], "Output",
 ImageSize->{126, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->331094596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24180098],

Cell[TextData[{
 "Make a sparse matrix from a block matrix of ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->242809919],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"s2", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
     RowBox[{"i", "-", "j"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->48230059],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451964813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "s1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "s2"}], ",", "0"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269838550],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122501572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->186495430],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmD9PwkAUwI+Wggo4ACYmOvBpNA5+AAeHhhhgMBpkYGNkZOzIR2DsyMjI
yMjIyMh4vvvHXY8T25S2GNuk3PV4vfv1/bv2PbuD7tu7O+i13dZj3/3s9tpf
rYePPgzZBYRQB86nWwR9DD16djCGVv11yK89nU4xPdALvR6NRvzaplJF2l2t
Vr7vky65tmHCO2gdaCv8uqq1ZTH7crnUZ/M8T12DTIPFAX10T//aj6Iro1SU
0RKdcbfbDYdDSWOLUQbE6A7urfMndU5OxXQ0Ho8BgXStPZW1WCyclHTDKMC8
YOQgBbXUZrP5WTdJ0Uh/U2mkb6ZLA+ZhYZIxzQUORk/BSEP8xubrW9DWsDlC
L7X7zLO95lJ8lOhNzXgNbM6A4fR6jcN4RzOU1DFv+Y2jiKNkt+R5zkUvOcd5
cpBspma1JjZnuTy7RZMSu4bIag0cZ9cw74i6d9SNUsnkuJwmp/nbNCJCRca7
wfl73SmkVL2qrdAneb9zYvqM2Uey9eP4TBUcjIQ4e0N8mqpGk61uahpNOVMa
/e2tlCnNqbKgKVr/XxacTCYhpGSdT5XyPG+73R7Tq8h+4iuXWWm9Xs9mM9JV
KyK+7/NqX3zP0aP5WH1mPp8balfwYJwxXRqwR6CeF67mmRSN9ANJY4GV0tIJ
yTQW2IGux6sMUhdWihQHNuA0rMCZPo1cl9GICDNlNvULl+4svIaPCt+zeMGt
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{103, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->169902411]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5058],

Cell["Put together many copies of a \"tile\":", "ExampleText",
 CellID->464331860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "10", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38403044],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQA2INIGZiJA4zMjEwEoMZmJiIwqP2jto7au+ovaTaCwAM
QQaf
   "], {{0, 0}, {40, 30}}, {0, 2}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageSize->{188., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{192, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206255980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36560279],

Cell["Iterate a 2D substitution system:", "ExampleText",
 CellID->17879736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArrayFlatten", "[", 
     RowBox[{"#", "/.", " ", 
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", "1", "}"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78414153],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1y0zAQx9W4oQUmbcKJE+QEHICXYAZOfYhMh5n20IEpfUbgALyS8Udc
PDur7K52FSt0OxM7kmVptfu3LP1c52Jzd/X5ZnN3fblZf7rdfL26vvy2/vjl
tsmqjkKYLUIIH56H5nvdfOs+w9958/mX7FPP2m11Xyo8Bulz4/SSOH4M0k+U
9lHtSdPQvqeF+w+m1+0mrBAvz5rkkrlfjfbjeqptPoxarP4Vox2sfuh1K/sp
771EvTdrNvMmCUs/iuSfNJs2OWfmx+qJ5Z8K68fO5/RPam/MLqmfpOVhOXiN
SuOXO/9EWD5NtdhZ7TUBvTPkt1aF+fh+Era20EdjdcbyTxPb4rYh71+apWm+
lJ+FlYZjsDTeufMx+7jxotUO75NwTID3zQXqWzyXukefCeqCdi0Iu3kW4Rbw
+swrBe06E/o79zyIugfA9IuuX9QYWYpqKLvg8VJUA+2CUaT6NfXsOe3O6qpx
1bhqXDWuGlfNNKqBlK9d8UIuUm19NOwhLxkfh61gRATWC+vBji8j9XPs5/Ce
IS2dHa47L9bbP4yj2qScxsrSh0ZjX7cbp69E/W9QL1lRSCl9jeXvi7Ja0UOr
fltTVqv2pfHWxu9VjanUli5qmOvuo1MQVitCmM8reQhrPnvTdGMZ+/6ORtFW
zYxckpuTvErnAvre2JBXfYu8OGl8/7bmjKUlqki6zi1FRdJ1bokqgja+q11F
fdpV5CpyFbmKLHriKppaRbvoZxVwmjrew3wJvY3xIqydWP0c++F+fJyy/33n
pcGP+egs5F4U8ZiaNpZOa390XqVW0YdGR3+yepWbhh0azbSyKxfN/M6K6v4J
0P/CAPNYul8e2I9nlCfs+UyphExvgT0t+1WnXMflxkg7Wy8hRtDG37XHyGPk
MfIYPZQYUStLzop5vLdY8WP1cFf8f7peDf3OtyLnzL93rYCp8tS1Q62otSty
a/ukK3qt/VMTC+v6pfFpmUDot4KzqNEgRjJi5ERKQihqndI+h5xQZMaK7EAe
mUKGOP45Top+jJxQaUhgtMTJmvDkst+KEFn399DewrbuvzSfc13Ir6aUNJdn
Yeftj5rlPC8Pb7P2wFQM0/pN8Rx+keRz2ulnMjPh2XCMocYcSBjT2KmWW1pb
qV9hantU6hvp1v+DKY1kd01mv6dIVw156Ie1lXpVa3tU6vuI2n5pV53dGO+q
TirvqnZVu6pd1a5qV7WrWqdqqUqHp1DUrJ3ir/BpGXU+fPpl1T781YTUp3HW
v74gbR/uKf90HP1ekNJneuHoL6O33FE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{525, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482930919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34329950],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt289TgkAUB/AHglbaGbp5qHN171xdunVWGa3RQ1Nj/oH1l9F7QLg9NlCE
dKavM8gu+3b3swvyYxweotX86SVaLabR8G4Zvc0X0/fh7euSN3UcIueDiJ5D
4nTMqWSRzycvRD3+nvGmAa+nlvVRHkWd75oxTVT+eMfyE5Ufq3z3gBUjTroV
PY05SZ2kOll7UuV9o1yKRqq8BwkkkEACCSQtSvqU3gkMsrWZP1Vt7e/qCCWU
UEIJJZRNK0NOBpyQ9ZkqM2OlmYCXkNOBJRZCCCGEEEIIIfxbodw5nMfpHcQF
hC0JPf52JdTLe+TP3p3euozIT1JJV37eRlbqHoK2oPIghri+2Fv3kv2Xp81+
bs7q66iC/Eeb5jy0N9tyXtFnwPG6sWyTLaps3l012ob9hVLrCIxjRo/arxpL
oYe6oynMt8pbjqdsvrsbjMkWV3JUWfakdSwlXietYzi830ZU8pu+5OR1jRj9
e5aYKxUjNIezInW22wd7EtvneLezZuPeVs7tUEIJJZRNKOs/JTUutDwZ1XnK
bPOaU//ZtymV+a/DDXTQQQcddNBBt7FOnvHvK3SBJQYqqKCCCiqo/otKrtKP
UEEFFVRQQXVAqklFb9uWb/6+rbyh3I/tbyqnbyhLhfSNZnK+ADi5Xvg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118164971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348974320],

Cell["Iterate a 3D substitution system:", "ExampleText",
 CellID->13820705],

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArrayFlatten", "[", 
      RowBox[{
       RowBox[{"#", "/.", " ", 
        RowBox[{"1", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}]}]}], ",", 
       "3"}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "1", "}"}], "}"}], "}"}], ",", "3"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17786375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "/@", 
      RowBox[{"Position", "[", 
       RowBox[{"#", ",", "1"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], "&"}], "/@", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->802054960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CuboidBox[{1, 1, 1}],
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFmO1OE0EUhrfd7fcH/aClLQUKYkOqCAKCqDHREFCJd8CfBpvAD4NB/nst
ekneT6Nzzkx3tu+cyhIlNmHazrzP+549u1129+Pw5mL0eXhzeT7snVwPv1xc
nn/tHV9dqyk/4Xnemfr71PLU51/qE/+djcdjz3upRn80Gi3zt0M1JtW3pHlf
4tl9o+FZhdqVPaPzzYqXutr8pt7UlJpRo9dl3dOIg6/WfZKltFCNRrvI2i3w
TEe04+/XU9rNSL3kmyVtOtSG1h1WD2A7iuxsbENnrd2AKsrsHGpD5zar+1BH
hdQZ6xwBvBYTD6CWOhG+9U/S4GuEgAWmViGnIVI2S1PLkNViynbJn1Amq8lU
FzrQASqAChtMdaDCrkjZCjW1ABWuAJWCrHmmGpC1KlI2S1M1yFoHKg1UnakK
dKMPVAYqrDFVhgo3RMpmaaoAFT4CKgv7q8pUDrI2gcpBhRWmsjT6eoo+Ut62
SNoqNZmhMTBm/NoBLg+Jc5bzLbcrUjZNpvbgyM9DT8qxqAJUWLoDZSsESi0Q
gFQRKiwylYasZ9CNImTFo0pAFWJRZehG/g6UzYpHzUE3ctOU6SFSFaiQj171
O5/O2hcpW2E8qgoVZu5Gmax4VA2y0v+PMp2fSZnt0lQAWQdA1WF/pUTqOfxS
an9B2e3699TsHgJlehiP8iHr8JbO3yeF+yu4d8p2Q6aoh/R1XlQnpbNMoFX6
lfzxc/ynfSD77Dg+afDBs4Pss+X45NnHHn94bpJ9Hjs+JbEeuw980Sd6/UFp
dL1QBSc8x8pOD52KmuCDZ3jZZ83x6YBPWfThRoU2PcdlGfpciuHSFbqzCtXE
8Wk71fTBBf+rSy5Nx2UALngdIrnUHZcnootlkoIL3c/Qpd4OsHiFZ9jI/i05
+QewZ3LQUdcj73i8gDpu98g4Hq/BA6+qXY/AdOEtkHgVP+mgJbXNCXB4p6E5
wk6hR2noc2IqQX85Fd1dJpwZ67uLD8CloA+J8Hc7ubvgVUUR+A7oQKT5rDZV
LabiPajmUjNST6A/SZHOOKnviZtxX66ZrEmc/JjoxWmZsFaByjtJzKSjjAa0
viDrnaccWl2c0YUjGgLTQCa1vuy4H0/6pWXGd07Y1qPIfrHKquP4RulIRusJ
SmbzmqN7ZXR0BOgC6jO2ZlcNgVGShS6q4ThuGx2tp9SCvsJuCtsyiCjJQt87
tRzHdXDU97dtcKQal8FRP71YdBzboNNPibqOrg7JSzy9JGxLCRzXeGnFccyC
rs/TvYljEG4LJA94YS3ip4+Wic8Wr9NTK3oItqttEr8B17aZzA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}], CuboidBox[{3, 1, 1}], 
     CuboidBox[{3, 3, 1}], CuboidBox[{3, 3, 3}], CuboidBox[{4, 1, 1}], 
     CuboidBox[{4, 2, 1}], CuboidBox[{4, 2, 2}], CuboidBox[{4, 3, 1}], 
     CuboidBox[{4, 3, 3}], CuboidBox[{4, 4, 1}], CuboidBox[{4, 4, 2}], 
     CuboidBox[{4, 4, 3}], CuboidBox[{4, 4, 4}]},
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1WttuHEUQHc99d9bre+z4EtuAACmKIqFICPEOT3xCHqxgKXlARiHvfAv+
JP5nBd116cuZGs8iIFJmp70955yuqq6u7p2f7j69v//l7tOHd3c3P368+/X9
h3e/3fzw8NH9qdopiuKt+//zWeHu/3J39P/tZrMpiu/dtbq/v7+m1nfuWrpW
KZ8v6K/fpn91jxb+AXfvrsUV9XgjKNqjfHj1+7jXN4JTSa/a96r990XBHS+p
3+sErXLftb5f427SrsUF9X0FmIuk7+aPj1nfl8k4PO7g+7ahb4A+p95fg4rd
vHcA595fgg62gLtxn/6WuLr06TiS54TwBairLYQqqi39pYooZ4RyC57oZlAq
vhCEBzgllGvQstgKJWphlEvQsgKUpbvEeGKjBCTR84yQzsG6ReWfJ6CoRVD9
iH2zfPxzkyLXMNITQj6DkVaGxrTdiOZG0f2gA3q0AKOfgAWaKTtKuxTtHaA3
oP2Y0I9A+6SvFd3dLhXZf/rxErzQBPWMvw/q0RaDqF15rJoxGZZis2XUFPiI
cNeJN8M8THAXgrueww1zkHFXYA+cgxjFrfBUZBN3IzyDv3SBl6l5GKNIPyTm
xYyfkbnK/ByZU+/4Wx/DlClhVhwQ6zDhd2KrQ1sidmmNsk5HmTHJ+JipF8um
LL3B6kl3rTGZPDyTY1TvBS6NfWsG9jKeA+BZ+EsTI5ufJm/A7GGeTnmoNY7C
JssjkWcP2sGHLDlmkCzvRIva7DjKWkbZAtsa2rW7VErr4DS6VEERxh+jZz2t
IIsayvwz/HGlYnLNYoQUZn+ZZJm4Ks/rYD9iRK0lhjqLN7F8NZGFdk1ezTro
Xz9PvJzeYuvSXGRkCYFf5YwyuE58jBGGNu5EAeazFhRVud1lhmHGYi0tjF6j
vZnzt2jBDGdqSXwRqxVss6rBVFWJheaiMBsnKvh/FRay/iVqdmVONv+BIh0Z
5sqFqWbfyIkhO/Bk+teqyM69GffuoWXUVbMulobKWl0HIFfV/1BdKRFCo2rC
Ui1oJWT+PqprgroJ25Viu3Yqn2+hkDSkMzyNrQm1MeL6kY/9bUntfC7Ukr/y
rDs3I8IclpWrMVUy03Ruo6zm7J+rrEHlINakPUCyEsDIJ5RqXUzpR5Z4WhnH
SBJXqUo/PFtlAyp7eTrY+AF2AUau0Oyp/dXnNdRypDdfFcHeuBdrTc0taNYK
oIRcsHoYz1vdmXqz9aCvGemrrHiY1ddJDcwG0H8higvYtSWzqgpWy/PElBW5
V23EpK1soZaTdj/j5TDTUwuN2lFbJ56g6M12KazMjsHjLVRQtWNUfil7r99D
ZixN29Sg4mRbW0h0oZrKsEXI723wF9hiToWvkGqKHi8hem5cFyN/VhdLDD7t
lzktuvMPEZrO2iZoE/ugPprr2S4oVs4xj2AFi6t+s5XS/BTBylr2SlJp7lSt
Yfb2SdYWkmJcWc5HlubGwc7dG95Fqybtrfv5dN1fJIoiNp7x2PY6Fry9cUZO
T/DcZ6y6gRl8hPtz5q2A9xnYez3ibzfJKVTcizmIYRS7PGTMfDbzqcWcxJ2e
xLQ27/Se4knWM4PVu2xhs2CkGjO1NXmei8e07l4l+Lz8W/hZbpQItsdxAePQ
PI9VAu0g/SkQRExvje6JdbU2VVwas5V3GeM8RZM3OSOtQFEHiuqQw9L9uW2N
K3eh+sHKOt5HRu2WcmM93YTcrl5m3hJ4b6HdJfxerZ+71jkb7mVoLw/xW2/F
2Ep+wnPsEUsxVTthZo/Y1VYKKCeRb6k7+RbV6Lqv1dZ0rYyzeN4KameMufTs
TLM2rsjj+hfXD5v/RqyO8abnjZ3Fk+W2bViuNrr2bPLdIuzsMt9O1KgNKMBV
SZyX/OVC/IorVQcKps6NsRINu+tZ5rPMujYzWbEYnyCbtbkV85Ps+vvIYLCX
xfgsDhlLWVEwksdMh8K0BqbgY1wZs6hNa6HJc6NJ7j3h3gfu5Qy3nkCkZ7vN
RA1bj1gHiakjYB0M1niil+dKPd+MV55DOsbcjr55CmwrYFs+2qepKVsgnGRr
hO0c2HaBrdE6G+bR3MkxrsjlSIHWqlegYA0KKEMBO1fTgX2idmVO3+0GOPZk
dgyAy3VVHNW4Lh2P4zPAvgTMZWKp4glE1u29hYhXlspZRKw6rmdQUSdmfUb1
ceDXrzm0QdEk8LFOZDQ8mbucQV0p6kSU7RBqBygXW4ycskQbkMPUYZ36690c
UisrKq1vGRp7h9GWgHI2g1pqzUUTMo6ejx0ZcxCFFpbP7yutX+71TY347C48
czKl5zH5/W70NgnbXn+ZRowXFkYdYtZd+XnM8IdmFANOUlsxygE8he0bQFnp
fiToOJRx4JO38GT7qOdnnM346WN4CtdMmuF1QEkwQg1DXiiN9fbzjbz7I735
jBtXDawH/LsxPnT4tyt9ZwN73Qgm/2aNawNWOBeCyW9q4NzAWXgq2Py2z6Uo
wF5H0ovfm3oB32J1txYFZM/wzg1mPl3Hv6Je5MH4y4q7Wcj3L+n7NPveS7Xr
OV7Tt976fmK/oVax8zdsQ7EE\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}], CuboidBox[{3, 1, 1}], 
     CuboidBox[{3, 3, 1}], CuboidBox[{3, 3, 3}], CuboidBox[{4, 1, 1}], 
     CuboidBox[{4, 2, 1}], CuboidBox[{4, 2, 2}], CuboidBox[{4, 3, 1}], 
     CuboidBox[{4, 3, 3}], CuboidBox[{4, 4, 1}], CuboidBox[{4, 4, 2}], 
     CuboidBox[{4, 4, 3}], CuboidBox[{4, 4, 4}], CuboidBox[{5, 1, 1}], 
     CuboidBox[{5, 5, 1}], CuboidBox[{5, 5, 5}], CuboidBox[{6, 1, 1}], 
     CuboidBox[{6, 2, 1}], CuboidBox[{6, 2, 2}], CuboidBox[{6, 5, 1}], 
     CuboidBox[{6, 5, 5}], CuboidBox[{6, 6, 1}], CuboidBox[{6, 6, 2}], 
     CuboidBox[{6, 6, 5}], CuboidBox[{6, 6, 6}], CuboidBox[{7, 1, 1}], 
     CuboidBox[{7, 3, 1}], CuboidBox[{7, 3, 3}], CuboidBox[{7, 5, 1}], 
     CuboidBox[{7, 5, 5}], CuboidBox[{7, 7, 1}], CuboidBox[{7, 7, 3}], 
     CuboidBox[{7, 7, 5}], CuboidBox[{7, 7, 7}], CuboidBox[{8, 1, 1}], 
     CuboidBox[{8, 2, 1}], CuboidBox[{8, 2, 2}], CuboidBox[{8, 3, 1}], 
     CuboidBox[{8, 3, 3}], CuboidBox[{8, 4, 1}], CuboidBox[{8, 4, 2}], 
     CuboidBox[{8, 4, 3}], CuboidBox[{8, 4, 4}], CuboidBox[{8, 5, 1}], 
     CuboidBox[{8, 5, 5}], CuboidBox[{8, 6, 1}], CuboidBox[{8, 6, 2}], 
     CuboidBox[{8, 6, 5}], CuboidBox[{8, 6, 6}], CuboidBox[{8, 7, 1}], 
     CuboidBox[{8, 7, 3}], CuboidBox[{8, 7, 5}], CuboidBox[{8, 7, 7}], 
     CuboidBox[{8, 8, 1}], CuboidBox[{8, 8, 2}], CuboidBox[{8, 8, 3}], 
     CuboidBox[{8, 8, 4}], CuboidBox[{8, 8, 5}], CuboidBox[{8, 8, 6}], 
     CuboidBox[{8, 8, 7}], CuboidBox[{8, 8, 8}]},
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{420, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256995862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9328204],

Cell[TextData[{
 "Form a block matrix semidiscretization of the wave equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", 
     RowBox[{"t", "\[InvisibleSpace]", "t"}]], "\[LongEqual]", 
    SubscriptBox["u", 
     RowBox[{"x", "\[InvisibleSpace]", "x"}]]}], TraditionalForm]], 
  "InlineMath"],
 " with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " spatial points:"
}], "ExampleText",
 CellID->535027253],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "100"}], ";", 
  RowBox[{"h", "=", 
   RowBox[{"1.", "/", "n"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2354699],

Cell[TextData[{
 "Differentiation matrix for second order approximation of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", 
    RowBox[{"x", "\[InvisibleSpace]", "x"}]], TraditionalForm]]],
 " with periodic boundary conditions:"
}], "ExampleText",
 CellID->67296627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dm", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{
        RowBox[{"-", "2"}], "/", 
        RowBox[{"h", "^", "2"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"h", "^", "2"}]}]}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", "1"}], "}"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"h", "^", "2"}]}]}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "n"}], "}"}], "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"h", "^", "2"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}], ",", "0."}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162744250],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "300", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 300, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->450039825]
}, Open  ]],

Cell["Identity matrix of size n:", "ExampleText",
 CellID->642595577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"im", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1."}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}], ",", "0."}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112299673],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "100", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 100, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590018713]
}, Open  ]],

Cell[TextData[{
 "Form block matrix ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " for system ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["U", "\[Prime]",
     MultilineFunction->None], "=", 
    RowBox[{"a", ".", "U"}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"U", "=", 
    RowBox[{"{", 
     RowBox[{"u", ",", 
      SubscriptBox["u", "t"]}], "}"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->52386830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "=", " ", 
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "im"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"dm", ",", "0."}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45627206],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "400", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 400, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"200", ",", "200"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->500300754]
}, Open  ]],

Cell[TextData[{
 "Set up an initial condition vector for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"0", ",", "x"}], ")"}], "=", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "100"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "0.5`"}], ")"}], "2"]}]]}], ",", 
    RowBox[{
     RowBox[{
      SubscriptBox["u", "t"], "(", 
      RowBox[{"0", ",", "x"}], ")"}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->139577851],

Cell[BoxData[
 RowBox[{
  RowBox[{"ic", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "100"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"i", " ", "h"}], " ", "-", " ", ".5"}], ")"}], "^", 
          "2"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"ConstantArray", "[", 
      RowBox[{"0.", ",", "n"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->485092356],

Cell["\<\
Approximate the solution at t = 0.25 using the backward Euler method with \
time step k:\
\>", "ExampleText",
 CellID->271703410],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", " ", 
   RowBox[{"h", "/", "100"}]}], ";", 
  RowBox[{"lsf", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{"a", ",", "0"}], "]"}], "-", 
     RowBox[{"k", " ", "a"}]}], "]"}]}], ";", 
  RowBox[{"solt", " ", "=", " ", "ic"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"solt", " ", "=", 
     RowBox[{"lsf", "[", "solt", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"Round", "[", 
      RowBox[{"0.25", "/", "k"}], "]"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->68638723],

Cell[TextData[{
 "Show ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "x"], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0.25`"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->311167890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"solt", ",", "n"}], "]"}], ",", " ", 
     RowBox[{"Take", "[", 
      RowBox[{"solt", ",", 
       RowBox[{"-", "n"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->201589299],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->18809629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " displays matrices of matrices in the same order as ",
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65743898],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "m", ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "m", ",", "m"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->834593470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "b", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72433186],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWj1vwjAQDQkQoBR17NCB/9G9nfojIlQJhqoVMLAxMjKmGxJ/gDEjIyMj
IyMjIyP1FzhcXMVxHRKXIEF89vnyXmxfwnPevGH3/cMb9jpe+7XvfXV7nUH7
5bOPqpySZVlz9H1+tFD5iErkOz8e0ZH+tvCvg2vJx3oC9sMf20l8q0JqZ7MZ
q60AL2xjs8WOsB2i1O3vEns8HjPbIajLpLjZbIIgwMUq6EXaK2eb9Ile0XIM
tiyjuKdxWa/XkLfv+8wL8q4J7KrEKKTdj7I5HA6j0YizcU61lFCETV10tsiV
dIFXM0dRqD2ZTBBJXLTPvO3VaiXytpFJzl3m9fHortGT2mjBoWV3yYXMyN1u
JzOGjZCtct3T7k9tnlnCLHkWgizJfI/MhmbMuSDWLKOcVyi9FUjyxvYpe9sS
2HT70/zD82FJCnU75qxJ22vgfAWKAkWBQgcKnMtwKmuwo0zu0+mvhhpGIfec
xE8cWUbRw/tOGFUea9r99bCMQ5F1ux6W98CG/nEo0u4vxxJGhVGS/re7dv+6
FpbiHBCHJcsoarxxdsdPjXjuOIIsJ9IidPrLoYZZSbfO05BC8X0DXvm40qJZ
is2sFDa1tWW+wqbGO68Kmxyb/6ewqT/d5FdpU+NkmtKm/o/QbKVNjXc+lDYz
VYQCRYHi1lBMp9NEKPKhtPF96DBq3/f3+70ItflKG7W32+1iscDF8L5LEARs
99d0pY36L5dLwd4hGlrG3XSljdpo5V3s9sI9e/HeOLfzrrTBNzI4SxvNVtMV
NvKUjuYjqWdj9fvYma+suYChE+JNt/RFvLNW1lyAj6K+zhtT9O0sq/QDLhlO
5w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->229819496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"ArrayFlatten", "[", "b", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677069472],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "1", "2", "1", "2"},
     {"3", "4", "3", "4", "3", "4"},
     {"1", "2", "1", "2", "1", "2"},
     {"3", "4", "3", "4", "3", "4"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$3680]]]], "Output",
 ImageSize->{106, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->225868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75339246],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->84678301],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";", " ", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", 
       RowBox[{"2", "m"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "m"}], ",", 
       RowBox[{"4", "m"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95402828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "b", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100817936],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTtvGkEQXu6Oh8HPRIldpEBKESlF/kD6pMqPQFYku7AcOS6QUlBZlJRX
8hMor6SkpKSkpKSkJPv0Lp/n2L1zyEMBidubu9mZb2ZnZ+d2v3Tur77edO6v
Lzvtz3edb1fXl9/bn27v+KO4whh74P+PF4zfr/md/D+s17xV12NxjcVT+WNv
gT4F+j3Qsj+ryqfD4VA/rQJXwi+CPORtlbeRbmuUNOjn8jd1G2t5deBXdK/X
03Qs0SXydjabZVkmblErSmkBHUmTHmkp048d39NSDkvpqht/T6dTtDNN0xwE
DaCbQMcev/gsxP5Hz7BttVp1u11rW2yeKvOe9BJ0Qvgz8diE/Pge+4eNFx2X
/X6fG/DYS9oUTSYT5K6SMlEzzjH0iM8y7E9FvfAoRo2Sw6cSn1CbtsjYWywW
FJowm8heBWzC/hjhEdAHpDybKVzbbFYpZ1tYpPgsDMsiOBPpMeTBqFJ2oJ2C
Nlk8Yirrx0SEUKPq8pv+Rh7aqOTZPFYJQvfOg+IDqcXK22vZa/k7tLjzTLQn
Hq0NzXeWw18OBZ3VmuRTrAwQIebZkyAp5XCjrkYpxML6GidP/wmkT3ud7RC3
yNcif4uKIQmIT9k/sTRjL9bPiVR6vcinUcu2Ojbfd1jNHpTCmpCysfZChH8S
sVm1j5x2GzYTHWaM8X0YChzDot+lzSAtP/4DLvTkG6DPPe8vgrTkRc2xbrGS
f5XDb9Y8lHdeCgU926hdhm3YaCn0Soi5shxuKqPVAry4e6Tl1jC07yXQRWoN
lPW6FG6TpeRatbE2hWA1Ow3U1085POhH98s12IO4Bu/Id/7v3RDEKLW1Q8Sm
ohYzPwrAVtf8rfWvHOO2Ryu+32vZa/k9WgaDQSEtIgO4+/Eh2UnwmRoS5SkU
9vzARZGm6XK5pFCg1rD1ImztwRqBXnnn8/loNBK37g5almV6X77oSQPmmZCc
WSP8qdCNx2Nij5Y7U2P2ofPtRVJZs/h4KKw8Ajf2xvEsA/2PUvCrBG1DrORZ
yNY6QOG0c8LijPho+3aii9ac285qWM6IR3xcpVztrXzvkfvk3goxrNrEOoCW
YrHFDmJ1eEAhFnTkZBB6dDb53RWfRmH1KRQ4SkW/lSStT1ZZ5SfO08lT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{133, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->153025451]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Flatten", "[", 
   RowBox[{"b", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"ArrayFlatten", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->207049398],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34535004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31913165],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 " is defined as ",
 Cell[BoxData[
  ButtonBox["ArrayFlatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFormula"],
 " of an ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " product: "
}], "ExampleText",
 CellID->131273519],

Cell[BoxData[
 RowBox[{
  RowBox[{"m1", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"m2", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->797482055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KroneckerProduct", "[", 
   RowBox[{"m1", ",", "m2"}], "]"}], "\[Equal]", 
  RowBox[{"ArrayFlatten", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", "m1", ",", "m2"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18446585],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527052274]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21424],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Join",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Join"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17699]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17322],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->31969],

Cell[TextData[ButtonBox["Combining Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombiningLists"]], "Tutorials",
 CellID->13709],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->2230],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->30248],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ArrayFlatten",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ArrayFlatten"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->123813820],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->1165325],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->3860572],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->178922328],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->175668825],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->28549116],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->184583759],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->50154217],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->6122428],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->384821292]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArrayFlatten - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 44.9404104}", "context" -> "System`", 
    "keywords" -> {
     "flat list", "flatten matrix", "join block matrices", "join lists", 
      "one-dimensional list", "outer product", "Kronecker product"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArrayFlatten[{{m_11, m_12, ...}, {m_21, m_22, ...}, ...}] creates a \
single flattened matrix from a matrix of matrices m ij. ArrayFlatten[a, r] \
flattens out r pairs of levels in the array a.", 
    "synonyms" -> {"array flatten"}, "title" -> "ArrayFlatten", "type" -> 
    "Symbol", "uri" -> "ref/ArrayFlatten"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14971, 472, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->27368941]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70582, 2211}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4280, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4903, 117, 1577, 37, 70, "ObjectNameGrid"],
Cell[6483, 156, 1857, 59, 70, "Usage",
 CellID->19217]
}, Open  ]],
Cell[CellGroupData[{
Cell[8377, 220, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8855, 237, 251, 7, 70, "Notes",
 CellID->695197793],
Cell[9109, 246, 234, 7, 70, "Notes",
 CellID->25412],
Cell[9346, 255, 497, 17, 70, "Notes",
 CellID->5881],
Cell[9846, 274, 700, 26, 70, "Notes",
 CellID->13467],
Cell[10549, 302, 956, 35, 70, "Notes",
 CellID->285642332],
Cell[11508, 339, 495, 19, 70, "Notes",
 CellID->93072372],
Cell[12006, 360, 1227, 42, 70, "Notes",
 CellID->381535951],
Cell[13236, 404, 866, 32, 70, "Notes",
 CellID->12629040],
Cell[14105, 438, 409, 12, 70, "Notes",
 CellID->977832692],
Cell[14517, 452, 417, 15, 70, "Notes",
 CellID->567196614]
}, Closed]],
Cell[CellGroupData[{
Cell[14971, 472, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27368941],
Cell[CellGroupData[{
Cell[15355, 486, 147, 5, 70, "ExampleSection",
 CellID->57568274],
Cell[15505, 493, 107, 3, 70, "ExampleText",
 CellID->5041],
Cell[15615, 498, 261, 10, 70, "Input",
 CellID->15264],
Cell[CellGroupData[{
Cell[15901, 512, 272, 9, 28, "Input",
 CellID->8383],
Cell[16176, 523, 595, 19, 36, "Output",
 CellID->118134838]
}, Open  ]],
Cell[16786, 545, 121, 3, 70, "ExampleDelimiter",
 CellID->30144],
Cell[16910, 550, 73, 1, 70, "ExampleText",
 CellID->30388],
Cell[16986, 553, 261, 10, 70, "Input",
 CellID->14077],
Cell[CellGroupData[{
Cell[17272, 567, 273, 9, 70, "Input",
 CellID->18213],
Cell[17548, 578, 595, 19, 36, "Output",
 CellID->385558437]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18192, 603, 215, 7, 70, "ExampleSection",
 CellID->4202],
Cell[18410, 612, 76, 1, 70, "ExampleText",
 CellID->126285817],
Cell[CellGroupData[{
Cell[18511, 617, 275, 9, 70, "Input",
 CellID->465263435],
Cell[18789, 628, 202, 7, 36, "Output",
 CellID->64540470]
}, Open  ]],
Cell[19006, 638, 124, 3, 70, "ExampleDelimiter",
 CellID->42094289],
Cell[19133, 643, 95, 1, 70, "ExampleText",
 CellID->46568723],
Cell[CellGroupData[{
Cell[19253, 648, 299, 9, 70, "Input",
 CellID->127977059],
Cell[19555, 659, 222, 7, 36, "Output",
 CellID->56206048]
}, Open  ]],
Cell[19792, 669, 76, 1, 70, "ExampleText",
 CellID->344938154],
Cell[CellGroupData[{
Cell[19893, 674, 328, 10, 70, "Input",
 CellID->187415012],
Cell[20224, 686, 215, 7, 36, "Output",
 CellID->973515370]
}, Open  ]],
Cell[20454, 696, 125, 3, 70, "ExampleDelimiter",
 CellID->610512187],
Cell[20582, 701, 336, 12, 70, "ExampleText",
 CellID->383845108],
Cell[CellGroupData[{
Cell[20943, 717, 445, 14, 70, "Input",
 CellID->550113518],
Cell[21391, 733, 501, 17, 36, "Output",
 CellID->525523788]
}, Open  ]],
Cell[CellGroupData[{
Cell[21929, 755, 131, 4, 70, "Input",
 CellID->192035114],
Cell[22063, 761, 481, 17, 36, "Output",
 CellID->315338505]
}, Open  ]],
Cell[CellGroupData[{
Cell[22581, 783, 106, 3, 70, "Input",
 CellID->113945058],
Cell[22690, 788, 1360, 39, 168, "Output",
 CellID->331094596]
}, Open  ]],
Cell[24065, 830, 124, 3, 70, "ExampleDelimiter",
 CellID->24180098],
Cell[24192, 835, 241, 8, 70, "ExampleText",
 CellID->242809919],
Cell[CellGroupData[{
Cell[24458, 847, 704, 24, 70, "Input",
 CellID->48230059],
Cell[25165, 873, 479, 17, 36, "Output",
 CellID->451964813]
}, Open  ]],
Cell[CellGroupData[{
Cell[25681, 895, 311, 11, 70, "Input",
 CellID->269838550],
Cell[25995, 908, 479, 17, 36, "Output",
 CellID->122501572]
}, Open  ]],
Cell[CellGroupData[{
Cell[26511, 930, 106, 3, 70, "Input",
 CellID->186495430],
Cell[26620, 935, 956, 20, 70, "Output",
 Evaluatable->False,
 CellID->169902411]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27625, 961, 222, 7, 70, "ExampleSection",
 CellID->5058],
Cell[27850, 970, 82, 1, 70, "ExampleText",
 CellID->464331860],
Cell[CellGroupData[{
Cell[27957, 975, 559, 16, 70, "Input",
 CellID->38403044],
Cell[28519, 993, 452, 14, 164, "Output",
 CellID->206255980]
}, Open  ]],
Cell[28986, 1010, 124, 3, 70, "ExampleDelimiter",
 CellID->36560279],
Cell[29113, 1015, 75, 1, 70, "ExampleText",
 CellID->17879736],
Cell[CellGroupData[{
Cell[29213, 1020, 489, 16, 70, "Input",
 CellID->78414153],
Cell[29705, 1038, 1525, 29, 70, "Output",
 Evaluatable->False,
 CellID->482930919]
}, Open  ]],
Cell[CellGroupData[{
Cell[31267, 1072, 218, 8, 70, "Input",
 CellID->34329950],
Cell[31488, 1082, 879, 18, 70, "Output",
 Evaluatable->False,
 CellID->118164971]
}, Open  ]],
Cell[32382, 1103, 125, 3, 70, "ExampleDelimiter",
 CellID->348974320],
Cell[32510, 1108, 75, 1, 70, "ExampleText",
 CellID->13820705],
Cell[32588, 1111, 869, 29, 70, "Input",
 CellID->17786375],
Cell[CellGroupData[{
Cell[33482, 1144, 319, 11, 70, "Input",
 CellID->802054960],
Cell[33804, 1157, 11616, 199, 123, "Output",
 CellID->256995862]
}, Open  ]],
Cell[45435, 1359, 123, 3, 70, "ExampleDelimiter",
 CellID->9328204],
Cell[45561, 1364, 441, 15, 70, "ExampleText",
 CellID->535027253],
Cell[46005, 1381, 168, 6, 70, "Input",
 CellID->2354699],
Cell[46176, 1389, 268, 8, 70, "ExampleText",
 CellID->67296627],
Cell[CellGroupData[{
Cell[46469, 1401, 1049, 34, 70, "Input",
 CellID->162744250],
Cell[47521, 1437, 487, 17, 36, "Output",
 CellID->450039825]
}, Open  ]],
Cell[48023, 1457, 69, 1, 70, "ExampleText",
 CellID->642595577],
Cell[CellGroupData[{
Cell[48117, 1462, 314, 10, 70, "Input",
 CellID->112299673],
Cell[48434, 1474, 487, 17, 36, "Output",
 CellID->590018713]
}, Open  ]],
Cell[48936, 1494, 508, 20, 70, "ExampleText",
 CellID->52386830],
Cell[CellGroupData[{
Cell[49469, 1518, 299, 10, 70, "Input",
 CellID->45627206],
Cell[49771, 1530, 487, 17, 36, "Output",
 CellID->500300754]
}, Open  ]],
Cell[50273, 1550, 570, 21, 70, "ExampleText",
 CellID->139577851],
Cell[50846, 1573, 607, 20, 70, "Input",
 CellID->485092356],
Cell[51456, 1595, 139, 4, 70, "ExampleText",
 CellID->271703410],
Cell[51598, 1601, 602, 19, 70, "Input",
 CellID->68638723],
Cell[52203, 1622, 331, 14, 70, "ExampleText",
 CellID->311167890],
Cell[CellGroupData[{
Cell[52559, 1640, 471, 15, 70, "Input",
 CellID->201589299],
Cell[53033, 1657, 2761, 49, 70, "Output",
 Evaluatable->False,
 CellID->18809629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55843, 1712, 233, 7, 70, "ExampleSection",
 CellID->16575],
Cell[56079, 1721, 365, 12, 70, "ExampleText",
 CellID->65743898],
Cell[56447, 1735, 478, 17, 70, "Input",
 CellID->834593470],
Cell[CellGroupData[{
Cell[56950, 1756, 105, 3, 70, "Input",
 CellID->72433186],
Cell[57058, 1761, 1082, 22, 70, "Output",
 Evaluatable->False,
 CellID->229819496]
}, Open  ]],
Cell[CellGroupData[{
Cell[58177, 1788, 145, 4, 70, "Input",
 CellID->677069472],
Cell[58325, 1794, 856, 24, 92, "Output",
 CellID->225868]
}, Open  ]],
Cell[59196, 1821, 124, 3, 70, "ExampleDelimiter",
 CellID->75339246],
Cell[59323, 1826, 378, 13, 70, "ExampleText",
 CellID->84678301],
Cell[59704, 1841, 526, 20, 70, "Input",
 CellID->95402828],
Cell[CellGroupData[{
Cell[60255, 1865, 106, 3, 70, "Input",
 CellID->100817936],
Cell[60364, 1870, 1378, 26, 70, "Output",
 Evaluatable->False,
 CellID->153025451]
}, Open  ]],
Cell[CellGroupData[{
Cell[61779, 1901, 357, 12, 70, "Input",
 CellID->207049398],
Cell[62139, 1915, 160, 5, 36, "Output",
 CellID->34535004]
}, Open  ]],
Cell[62314, 1923, 124, 3, 70, "ExampleDelimiter",
 CellID->31913165],
Cell[62441, 1928, 475, 17, 70, "ExampleText",
 CellID->131273519],
Cell[62919, 1947, 372, 13, 70, "Input",
 CellID->797482055],
Cell[CellGroupData[{
Cell[63316, 1964, 280, 8, 70, "Input",
 CellID->18446585],
Cell[63599, 1974, 161, 5, 36, "Output",
 CellID->527052274]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63821, 1986, 311, 9, 70, "SeeAlsoSection",
 CellID->21424],
Cell[64135, 1997, 1411, 53, 70, "SeeAlso",
 CellID->17699]
}, Open  ]],
Cell[CellGroupData[{
Cell[65583, 2055, 314, 9, 70, "TutorialsSection",
 CellID->17322],
Cell[65900, 2066, 157, 3, 70, "Tutorials",
 CellID->31969],
Cell[66060, 2071, 140, 3, 70, "Tutorials",
 CellID->13709],
Cell[66203, 2076, 151, 3, 70, "Tutorials",
 CellID->2230],
Cell[66357, 2081, 149, 3, 70, "Tutorials",
 CellID->30248],
Cell[66509, 2086, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[66675, 2094, 305, 8, 70, "RelatedLinksSection"],
Cell[66983, 2104, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67389, 2121, 319, 9, 70, "MoreAboutSection",
 CellID->123813820],
Cell[67711, 2132, 163, 3, 70, "MoreAbout",
 CellID->1165325],
Cell[67877, 2137, 151, 3, 70, "MoreAbout",
 CellID->3860572],
Cell[68031, 2142, 155, 3, 70, "MoreAbout",
 CellID->178922328],
Cell[68189, 2147, 177, 3, 70, "MoreAbout",
 CellID->175668825],
Cell[68369, 2152, 155, 3, 70, "MoreAbout",
 CellID->28549116],
Cell[68527, 2157, 164, 3, 70, "MoreAbout",
 CellID->184583759],
Cell[68694, 2162, 178, 3, 70, "MoreAbout",
 CellID->50154217],
Cell[68875, 2167, 196, 4, 70, "MoreAbout",
 CellID->6122428],
Cell[69074, 2173, 175, 3, 70, "MoreAbout",
 CellID->384821292]
}, Open  ]],
Cell[69264, 2179, 27, 0, 70, "History"],
Cell[69294, 2181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

