(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35142,       1318]
NotebookOptionsPosition[     27409,       1050]
NotebookOutlinePosition[     28987,       1091]
CellTagsIndexPosition[     28901,       1086]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Nested Lists\"\>", 3->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"], "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"], "ArrayFlatten" :> 
          Documentation`HelpLookup["paclet:ref/ArrayFlatten"], "Array" :> 
          Documentation`HelpLookup["paclet:ref/Array"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArrayDepth\"\>", 2->"\<\"MatrixQ\"\>", 
       3->"\<\"VectorQ\"\>", 4->"\<\"Dimensions\"\>", 5->"\<\"PadLeft\"\>", 
       6->"\<\"ArrayFlatten\"\>", 7->"\<\"Array\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Tensors\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArrayQ", "ObjectName",
 CellID->22233],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a full array or a ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object, and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]requires ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be a full array with a depth that matches the pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]requires also that ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yield ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " when applied to each of the array elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
In a full array all parts at a particular level must be lists of the same \
length. \
\>", "Notes",
 CellID->3161],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"1", "|", "2"}]}], "]"}]], "InlineFormula"],
 " tests whether ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is either a vector or a matrix. "
}], "Notes",
 CellID->27818],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "_", ",", 
    ButtonBox["NumberQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberQ"]}], "]"}]], "InlineFormula"],
 " tests whether ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a numerical array at all levels. "
}], "Notes",
 CellID->9546]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125221436],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->56620764],

Cell["A vector of numbers is a full array:", "ExampleText",
 CellID->376390107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72361871],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27685258]
}, Open  ]],

Cell["\<\
A vector in which one element is itself a list is not a full array:\
\>", "ExampleText",
 CellID->468736057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", 
    RowBox[{"{", "3", "}"}], ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->714661665],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352765467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438589447],

Cell["A ragged collection of nested lists is not a full array:", "ExampleText",
 CellID->413565131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509903990],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358935497]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651988430],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->504185149]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25254],

Cell["Test for a vector:", "ExampleText",
 CellID->215160481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90609924],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->640472518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64778042],

Cell["Test for a matrix:", "ExampleText",
 CellID->143506927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138855499],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->862188047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->893879023],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81432257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240143905],

Cell["Test for a vector or a matrix:", "ExampleText",
 CellID->87415787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"1", "|", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296054557],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101995073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->548062579],

Cell["Test for a numeric vector:", "ExampleText",
 CellID->222375698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "x"}], "}"}], ",", "1", ",", 
   "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558524952],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197824935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81873559],

Cell["Test for an array of any depth with numeric entries:", "ExampleText",
 CellID->165816259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"E", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Pi", ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "1", "]"}], ",", 
         RowBox[{"Cos", "[", "2", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sinh", "[", "1", "]"}], ",", 
         RowBox[{"Cosh", "[", "1", "]"}]}], "}"}]}], "}"}]}], "}"}], ",", "_",
    ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188891914],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->589046520]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3586],

Cell["Define a function that only evaluates with arrays:", "ExampleText",
 CellID->290371992],

Cell[BoxData[
 RowBox[{
  RowBox[{"iptp", "[", 
   RowBox[{
    RowBox[{"a_", "?", "ArrayQ"}], ",", "x_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", "perm", ",", 
      RowBox[{"at", "=", "a"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"n", "=", 
      RowBox[{"ArrayDepth", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"at", " ", "=", " ", 
         RowBox[{"Transpose", "[", 
          RowBox[{"at", ",", 
           RowBox[{"RotateRight", "[", 
            RowBox[{"Range", "[", 
             RowBox[{"ArrayDepth", "[", "at", "]"}], "]"}], "]"}]}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"at", "=", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"InterpolatingPolynomial", "[", 
             RowBox[{"#", ",", 
              SubscriptBox["x", "i"]}], "]"}], "&"}], ",", "at", ",", 
           RowBox[{"{", 
            RowBox[{"n", "-", "i"}], "}"}]}], "]"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     "at"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557160628],

Cell["\<\
This constructs the tensor product interpolating polynomial assuming integer \
coordinates:\
\>", "ExampleText",
 CellID->196022972],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"9", ",", "10", ",", "11", ",", "12"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"13", ",", "14", ",", "15", ",", "16"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"17", ",", "18", ",", "19", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"21", ",", "22", ",", "23", ",", "24"}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{"poly", "=", 
  RowBox[{"iptp", "[", 
   RowBox[{"data", ",", "x"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->480909756],

Cell[BoxData[
 RowBox[{
  RowBox[{"12", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SubscriptBox["x", "1"]}], ")"}]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SubscriptBox["x", "2"]}], ")"}]}], "+", 
  SubscriptBox["x", "3"]}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->494162291]
}, Open  ]],

Cell["The polynomial interpolates the data:", "ExampleText",
 CellID->403986496],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pos", " ", "=", " ", 
   RowBox[{"Position", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"_", "?", "NumberQ"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"poly", " ", "/.", " ", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Thread", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["x", "3"]}], "}"}], "\[Rule]", "#"}], "]"}], "&"}], ",",
     "pos"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->79256396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21", ",", 
   "22", ",", "23", ",", "24"}], "}"}]], "Output",
 ImageSize->{549, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88474507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"Extract", "[", 
   RowBox[{"data", ",", "pos"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->386588549],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->182297418]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248136993],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2.", ",", "E", ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->548544250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", "v", "]"}], ",", 
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->263198888],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438102040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", 
    RowBox[{"v", ",", "NumericQ"}], "]"}], ",", 
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1", ",", "NumericQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->618900711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127629230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VectorQ", "[", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}], ",", 
   
   RowBox[{"ArrayQ", "[", 
    RowBox[{"v", ",", "1", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->344826294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->387966540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468759063],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->45593824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371158469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9252636886737409`", ",", "0.5221176593545447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1885812639080069`", ",", "0.9210654019973841`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24125796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", "m", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106621055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59358925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2", ",", "MachineNumberQ"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", 
    RowBox[{"m", ",", "MachineNumberQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37529934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->737160467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2", ",", "IntegerQ"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", 
    RowBox[{"m", ",", "IntegerQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->178405380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->95148630]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9594],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dimensions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dimensions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayFlatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayFlatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21350],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->21263],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->16461],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->104054693],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->182675272],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->21016886],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->331812059]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArrayQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 53.1437454}", "context" -> "System`", 
    "keywords" -> {
     "arrays", "tensors", "array testing", "full array", "ragged array", 
      "matrix test", "array element test", "array type test"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ArrayQ[expr] gives True if expr is a full array or a SparseArray object, \
and gives False otherwise. ArrayQ[expr, patt] requires expr to be a full \
array with a depth that matches the pattern patt. ArrayQ[expr, patt, test] \
requires also that test yield True when applied to each of the array elements \
in expr. ", "synonyms" -> {"array q"}, "title" -> "ArrayQ", "type" -> 
    "Symbol", "uri" -> "ref/ArrayQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7281, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->125221436]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28758, 1079}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2838, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3461, 89, 44, 1, 70, "ObjectName",
 CellID->22233],
Cell[3508, 92, 2258, 73, 70, "Usage",
 CellID->9421]
}, Open  ]],
Cell[CellGroupData[{
Cell[5803, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6281, 187, 124, 4, 70, "Notes",
 CellID->3161],
Cell[6408, 193, 380, 14, 70, "Notes",
 CellID->27818],
Cell[6791, 209, 453, 16, 70, "Notes",
 CellID->9546]
}, Closed]],
Cell[CellGroupData[{
Cell[7281, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->125221436],
Cell[CellGroupData[{
Cell[7666, 244, 147, 5, 70, "ExampleSection",
 CellID->56620764],
Cell[7816, 251, 79, 1, 70, "ExampleText",
 CellID->376390107],
Cell[CellGroupData[{
Cell[7920, 256, 168, 5, 28, "Input",
 CellID->72361871],
Cell[8091, 263, 160, 5, 36, "Output",
 CellID->27685258]
}, Open  ]],
Cell[8266, 271, 118, 3, 70, "ExampleText",
 CellID->468736057],
Cell[CellGroupData[{
Cell[8409, 278, 194, 6, 28, "Input",
 CellID->714661665],
Cell[8606, 286, 162, 5, 36, "Output",
 CellID->352765467]
}, Open  ]],
Cell[8783, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->438589447],
Cell[8911, 299, 99, 1, 70, "ExampleText",
 CellID->413565131],
Cell[CellGroupData[{
Cell[9035, 304, 225, 8, 70, "Input",
 CellID->509903990],
Cell[9263, 314, 162, 5, 36, "Output",
 CellID->358935497]
}, Open  ]],
Cell[CellGroupData[{
Cell[9462, 324, 251, 9, 70, "Input",
 CellID->651988430],
Cell[9716, 335, 161, 5, 36, "Output",
 CellID->504185149]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9926, 346, 216, 7, 70, "ExampleSection",
 CellID->25254],
Cell[10145, 355, 61, 1, 70, "ExampleText",
 CellID->215160481],
Cell[CellGroupData[{
Cell[10231, 360, 196, 7, 70, "Input",
 CellID->90609924],
Cell[10430, 369, 161, 5, 36, "Output",
 CellID->640472518]
}, Open  ]],
Cell[10606, 377, 124, 3, 70, "ExampleDelimiter",
 CellID->64778042],
Cell[10733, 382, 61, 1, 70, "ExampleText",
 CellID->143506927],
Cell[CellGroupData[{
Cell[10819, 387, 197, 7, 70, "Input",
 CellID->138855499],
Cell[11019, 396, 162, 5, 36, "Output",
 CellID->862188047]
}, Open  ]],
Cell[CellGroupData[{
Cell[11218, 406, 280, 10, 70, "Input",
 CellID->893879023],
Cell[11501, 418, 160, 5, 36, "Output",
 CellID->81432257]
}, Open  ]],
Cell[11676, 426, 125, 3, 70, "ExampleDelimiter",
 CellID->240143905],
Cell[11804, 431, 72, 1, 70, "ExampleText",
 CellID->87415787],
Cell[CellGroupData[{
Cell[11901, 436, 218, 7, 70, "Input",
 CellID->296054557],
Cell[12122, 445, 161, 5, 36, "Output",
 CellID->101995073]
}, Open  ]],
Cell[12298, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->548062579],
Cell[12426, 458, 69, 1, 70, "ExampleText",
 CellID->222375698],
Cell[CellGroupData[{
Cell[12520, 463, 215, 7, 70, "Input",
 CellID->558524952],
Cell[12738, 472, 162, 5, 36, "Output",
 CellID->197824935]
}, Open  ]],
Cell[12915, 480, 124, 3, 70, "ExampleDelimiter",
 CellID->81873559],
Cell[13042, 485, 95, 1, 70, "ExampleText",
 CellID->165816259],
Cell[CellGroupData[{
Cell[13162, 490, 680, 23, 70, "Input",
 CellID->188891914],
Cell[13845, 515, 161, 5, 36, "Output",
 CellID->589046520]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14055, 526, 222, 7, 70, "ExampleSection",
 CellID->3586],
Cell[14280, 535, 93, 1, 70, "ExampleText",
 CellID->290371992],
Cell[14376, 538, 1329, 37, 70, "Input",
 CellID->557160628],
Cell[15708, 577, 142, 4, 70, "ExampleText",
 CellID->196022972],
Cell[CellGroupData[{
Cell[15875, 585, 871, 26, 70, "Input",
 CellID->480909756],
Cell[16749, 613, 450, 17, 36, "Output",
 CellID->494162291]
}, Open  ]],
Cell[17214, 633, 80, 1, 70, "ExampleText",
 CellID->403986496],
Cell[CellGroupData[{
Cell[17319, 638, 575, 19, 70, "Input",
 CellID->79256396],
Cell[17897, 659, 453, 11, 36, "Output",
 CellID->88474507]
}, Open  ]],
Cell[CellGroupData[{
Cell[18387, 675, 157, 5, 70, "Input",
 CellID->386588549],
Cell[18547, 682, 161, 5, 36, "Output",
 CellID->182297418]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18757, 693, 233, 7, 70, "ExampleSection",
 CellID->25419],
Cell[18993, 702, 318, 12, 70, "ExampleText",
 CellID->248136993],
Cell[19314, 716, 207, 7, 70, "Input",
 CellID->548544250],
Cell[CellGroupData[{
Cell[19546, 727, 209, 7, 70, "Input",
 CellID->263198888],
Cell[19758, 736, 209, 7, 36, "Output",
 CellID->438102040]
}, Open  ]],
Cell[CellGroupData[{
Cell[20004, 748, 258, 8, 70, "Input",
 CellID->618900711],
Cell[20265, 758, 209, 7, 36, "Output",
 CellID->127629230]
}, Open  ]],
Cell[CellGroupData[{
Cell[20511, 770, 429, 16, 70, "Input",
 CellID->344826294],
Cell[20943, 788, 212, 7, 36, "Output",
 CellID->387966540]
}, Open  ]],
Cell[21170, 798, 125, 3, 70, "ExampleDelimiter",
 CellID->468759063],
Cell[21298, 803, 317, 12, 70, "ExampleText",
 CellID->45593824],
Cell[CellGroupData[{
Cell[21640, 819, 204, 7, 70, "Input",
 CellID->371158469],
Cell[21847, 828, 376, 12, 36, "Output",
 CellID->24125796]
}, Open  ]],
Cell[CellGroupData[{
Cell[22260, 845, 209, 7, 70, "Input",
 CellID->106621055],
Cell[22472, 854, 208, 7, 36, "Output",
 CellID->59358925]
}, Open  ]],
Cell[CellGroupData[{
Cell[22717, 866, 269, 8, 70, "Input",
 CellID->37529934],
Cell[22989, 876, 209, 7, 36, "Output",
 CellID->737160467]
}, Open  ]],
Cell[CellGroupData[{
Cell[23235, 888, 258, 8, 70, "Input",
 CellID->178405380],
Cell[23496, 898, 211, 7, 36, "Output",
 CellID->95148630]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23768, 912, 310, 9, 70, "SeeAlsoSection",
 CellID->9594],
Cell[24081, 923, 1680, 62, 70, "SeeAlso",
 CellID->27371]
}, Open  ]],
Cell[CellGroupData[{
Cell[25798, 990, 314, 9, 70, "TutorialsSection",
 CellID->21350],
Cell[26115, 1001, 170, 3, 70, "Tutorials",
 CellID->21263],
Cell[26288, 1006, 134, 3, 70, "Tutorials",
 CellID->16461],
Cell[26425, 1011, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[26591, 1019, 319, 9, 70, "MoreAboutSection",
 CellID->104054693],
Cell[26913, 1030, 144, 3, 70, "MoreAbout",
 CellID->182675272],
Cell[27060, 1035, 125, 3, 70, "MoreAbout",
 CellID->21016886],
Cell[27188, 1040, 149, 3, 70, "MoreAbout",
 CellID->331812059]
}, Open  ]],
Cell[27352, 1046, 27, 0, 70, "History"],
Cell[27382, 1048, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

