(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73787,       2714]
NotebookOptionsPosition[     62440,       2311]
NotebookOutlinePosition[     63995,       2352]
CellTagsIndexPosition[     63909,       2347]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting and Setting Pieces of Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingAndSettingPiecesOfMatrices"], 
          "Sparse Arrays: Manipulating Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-ManipulatingLists"], 
          "Sparse Arrays: Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SparseArrays-LinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Getting and Setting Pieces of Matrices\"\>", 
       2->"\<\"Sparse Arrays: Manipulating Lists\"\>", 
       3->"\<\"Sparse Arrays: Linear Algebra\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SparseArray\"\>", 2->"\<\"Position\"\>", 
       3->"\<\"Normal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Parts of Matrices\"\>", 
       4->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArrayRules", "ObjectName",
 CellID->21374],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayRules",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayRules"], "[", 
       RowBox[{
        ButtonBox["SparseArray",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SparseArray"], "[", 
        StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the rules ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["pos", "TI"], 
          StyleBox["1", "TR"]], "->", 
         SubscriptBox[
          StyleBox["val", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["pos", "TI"], 
          StyleBox["2", "TR"]], "->", 
         SubscriptBox[
          StyleBox["val", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " specifying elements in a sparse array. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ArrayRules",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ArrayRules"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives rules for ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["SparseArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SparseArray"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5152]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The last element of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is always ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"_", ",", "_", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
   StyleBox["def", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["def", "TI"]], "InlineFormula"],
 " is the default value for unspecified elements in the sparse array. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->172739598]
}], "Notes",
 CellID->23848],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " takes the default value to be ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->474750985]
}], "Notes",
 CellID->29235],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " assumes a default value of 0. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->295240034]
}], "Notes",
 CellID->28638]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118113986],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->253732070],

Cell[TextData[{
 "Get the explicit elements in a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->52770811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"3", 
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96507874],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107047335]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ar", "=", 
  RowBox[{"ArrayRules", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512159276],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWttOGzEQNbubG0kgIB4qSilt/6V96kdECAkeqlaU/0/XWbtsz854PLaX
pEgJzNqey/F47D3m+/bl8eHH9uXpfnv37Xn76/Hp/vfd15/P7aP6xJjqxhjz
6Z1p/961f+0//ue2/byKnbS03/XfXmYB8jnI70E+VY7/kjlea39T2P9ji38/
fwMtVq5a8QKeX7vnsf0/K/tL+i8z/Snlf9V+TVuxcu1zJ9cC2qck2naUFSfw
fNp+TVqxobT05AnTb070qwkvF8xzXNurTDszJk6002TamTN2UnHj5ofDrbSd
WNxi5wfHYY3Ado8ziSe5Nsykv28Y55NdKTO2NeTBFGSvDasd9vPrE/VVBHID
+2wMsVbjYkXbiLLW6nxUhMOzK+E8jtU0nHVzvHTP8TyAWusoX7qVgzZmgm5E
y9pa+Ph7z8+IfnZ3Wrnf6E3j9HB1F+uD14dYYB30etFvzj/cfVFfbLzYvmTi
TtVH4ZGD58fA+GEuUbvQsAoj5mvChmZlos/0ilyTT6WViL7F2cJskWo64hZn
BU+c2oqGVrCdr0IlrZCxZszIB2G8pgpi5voKLFUDHBe1SptX2XTr/J8nEu6o
k6pkQxsxZzdpxoaaNw4n6ZQbg4sVz0U0cjTHYCChi1lHvTekZp12xVwJ/ftW
jUe3J6NXtyCH6rXxuRuoblr/pDon6cPVudmF49Xqw3aMV8IPc2cfb2Ku5Ox9
pfPmmrQqaS2dPWdFYj90DsVhmZNJ1PtRv0JSEVK8l98j/R6Akd44fbiH+nF2
vhpinGRP62fl7HB+SuM4P7n4kG+7YvztWE8/XxSvXUai3rT68rGzxf87217a
/30eku97aOUQ7Pmxse2p/jRRKNsaQb1dl2bNtXZSWdlD2ynNzofslJwfLWuO
dtaZdmJvTzjc9qdJMdspeXw+nbMq9cvjWg/P9o7hQSyvH7ZNsSUlZnqMW5tV
Qcy1Nzgc2t0OjqMxEhyN70upTLzEQVJea5hkqZ3Khhz9eEJIvQFAvXgyQFzG
Yu69Xm7vwfGxNw0cDh13r6390qxouUWtfi1b/Nb6S98MoH58S3lrth71Y9aX
uXOQUErLXenOUMsx564NiXOWckM69Wn123aK1dfmlDanU3DvM1DSKRvnndoB
PMOku5MpU1OlmqFhRGPaJb5aWxNK65Pi1e7oWn2l4+23U9UO/UvLovJ3ADHt
cbx1zq3F+BYkTGjd0k6cpnV8TKRbHTobpezz/wFmUakZrRzbHqrlHNsu3V6k
jgv5WQf8lMal+nmxC99e5N0mmJM/fPupOw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{540, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68274309]
}, Open  ]],

Cell[TextData[{
 "These rules are sufficient to efficiently construct an identical ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16238655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"SparseArray", "[", "ar", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->697121316],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->61652705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "===", "s2"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->265007570],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->305305808]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19984],

Cell[TextData[{
 "The last element of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArrayRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayRules"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is always ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"_", ",", "_", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
   StyleBox["def", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->172739598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"2", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396327120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175402398]
}, Open  ]],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " with a default value of 2:"
}], "ExampleText",
 CellID->347415084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"m", ",", "Automatic", ",", " ", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143006370],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], ",", "2"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531253478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ar2", "=", 
  RowBox[{"ArrayRules", "[", "s2", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37915247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "2"}]}], "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->614148613]
}, Open  ]],

Cell["\<\
You can override this by explicitly specifying what default you would like:\
\>", "ExampleText",
 CellID->440682771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ar1", "=", 
  RowBox[{"ArrayRules", "[", 
   RowBox[{"s2", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->539887843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "1"}]}], "}"}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->162217332]
}, Open  ]],

Cell[TextData[{
 "These will construct a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", "1"}], "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->196100995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"ar1", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "===", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"m", ",", "Automatic", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->92859862],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->39480278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45870002],

Cell["\<\
Positions of 1 in an explicit array with the default taken to be 0:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->295240034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199866653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354942132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->675015606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], 
  "}"}]], "Output",
 ImageSize->{557, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44570256]
}, Open  ]],

Cell[TextData[{
 "These will construct a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->128350417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], "===", 
  RowBox[{"SparseArray", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->881578640],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->476190467]
}, Open  ]],

Cell["Positions of 0 with 1 taken as default:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->474750985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", 
  RowBox[{"a", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->588418771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "2"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_", ",", "_"}], "}"}], "\[Rule]", "1"}]}], 
  "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->389630357]
}, Open  ]],

Cell[TextData[{
 "These will construct a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], ",", "1"}], "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->46186867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], "===", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"a", ",", "Automatic", ",", " ", "1"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->471409985],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->825209263]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30079],

Cell[TextData[{
 "Get the number of explicit elements in a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->375233124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "1"}], "}"}], "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], ",", "1000"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75162469],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "8", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 8, ">"],
     Editable->False], ",", 
    RowBox[{"{", "1000", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77593858]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Length", "[", 
   RowBox[{"ArrayRules", "[", "s", "]"}], "]"}], "-", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7691771],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67744838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607193689],

Cell["\<\
Get the explicit elements of a sparse array satisfying a condition:\
\>", "ExampleText",
 CellID->26156169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";", 
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"19", ",", "2"}], "}"}]}], "]"}], "\[Rule]", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", "19"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "9"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117644219],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "17", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 17, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "9"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537517389]
}, Open  ]],

Cell[TextData[{
 "Note the more complicated pattern is needed since ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " has special behavior for ",
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26337973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"ArrayRules", "[", "s", "]"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", ":", 
      RowBox[{"(", 
       RowBox[{"_", "\[Rule]", 
        RowBox[{"x_", "/;", 
         RowBox[{"Positive", "[", "x", "]"}]}]}], ")"}]}], ")"}], "\[Rule]", 
    "r"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224529849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "7"}], "}"}], "\[Rule]", "7"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}], "\[Rule]", "5"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", "4"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}], "\[Rule]", "6"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "9"}], "}"}], "\[Rule]", "8"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "1"}], "}"}], "\[Rule]", "7"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "2"}], "}"}], "\[Rule]", "3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"7", ",", "7"}], "}"}], "\[Rule]", "8"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"8", ",", "1"}], "}"}], "\[Rule]", "1"}]}], "}"}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92675635]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects with positive and negative values:"
}], "ExampleText",
 CellID->82033721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spos", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"%", ",", 
    RowBox[{"Dimensions", "[", "s", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->354106678],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 9, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "9"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11075937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sneg", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"Cases", "[", 
     RowBox[{
      RowBox[{"ArrayRules", "[", "s", "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", ":", 
         RowBox[{"(", 
          RowBox[{"_", "\[Rule]", 
           RowBox[{"x_", "/;", 
            RowBox[{"Negative", "[", "x", "]"}]}]}], ")"}]}], ")"}], 
       "\[Rule]", "r"}]}], "]"}], ",", 
    RowBox[{"Dimensions", "[", "s", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->58694742],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "8", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 8, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "9"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->213340659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265975841],

Cell["Get the upper and lower triangular parts of a sparse matrix:", \
"ExampleText",
 CellID->52692084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "6"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365020294],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "16", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 16, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388128576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"upperrules", "=", 
  RowBox[{"Cases", "[", 
   RowBox[{
    RowBox[{"ArrayRules", "[", "s", "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"r", ":", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
          RowBox[{"i", "\[LessEqual]", "j"}]}], "\[Rule]", "_"}], ")"}]}], 
      ")"}], "\[Rule]", "r"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49826543],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], "\[Rule]", 
    RowBox[{"-", "6"}]}]}], "}"}]], "Output",
 ImageSize->{471, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309879555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"upperrules", ",", 
    RowBox[{"Dimensions", "[", "s", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->177982359],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "12", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 12, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->179485949]
}, Open  ]],

Cell["Lower triangular part with ones on the diagonal:", "ExampleText",
 CellID->444612691],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lowerrules", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"ArrayRules", "[", "s", "]"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", ":", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
           RowBox[{"i", ">", "j"}]}], "\[Rule]", "_"}], ")"}]}], ")"}], 
      "\[Rule]", "r"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"l", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"Append", "[", 
     RowBox[{"lowerrules", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "1"}]}], "]"}], ",", 
    RowBox[{"Dimensions", "[", "s", "]"}]}], "]"}]}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->760444274],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "9", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 9, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->385459543]
}, Open  ]],

Cell["\<\
This just happens to be the LU decomposition of a tridiagonal matrix:\
\>", "ExampleText",
 CellID->82656795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"l", ".", "u"}], ")"}], "[", 
   RowBox[{"[", 
    RowBox[{"{", 
     RowBox[{"5", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->165051066],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPAkEQPjhQRATlkRgjhl+jsfBHXIgJFEZFTOiupKSk5CdQXklJSUlJ
SUlJec6+uGPYO+6xd1BIArOzjDPf7Xz7GebN6HfeP4x+t220XnrGV6fb/mk9
f/ZgS89ommbC+/Veg7UNK/o2bRus+zNPPvXJZGLTl/ZNfdM0ua/TqBxdLpdL
y7LIkvg6JKwjWwObB/vA7YXIvlgscLbxeOyuQcJt8YK1Vg2xW6dpdru0/mEU
Q7PdbgeDgYNGF7sMEEOnFE2Vn0YO7ReoPxwOoThZZnd4svP5PK8cxyPyL6kP
LYXG7ten3Vmv18mcRxP5rC8Ou9w4HCaqx/GEfHYXoBnsOqSGQ87WgugD38pI
0RDMsptIbBZsk/tX6O/k2X7/ozzOFStbkdvbQNnCcCYYO0ooKnkcXip2kzoS
rGPpnwVWsOvUEWDtKqaOQCUvZSrmVq8S96uBsp2rppxOxbzUq8a/vwuUTc6W
aLyQcywOa6PqVfJIjulV8giO6VXyCI7pVfIIkuelW8Vk6tWww9y2c9WU9KNI
f/3US/zXCHau7NeGGl7EYQvGEU+vVCKJplcqEUTTK5UIoumVSgSn4iVRMT/1
CnfbzlVTwkSNRqMAUc4MzR0Fv983m43Nb5GfegnLurRarabTKVm6pxCWZfFJ
GuWBUnbIdys042w2k8yI4ME4RqHQKrXLDw90ZG9mhieKuG5S5+JwwMGRhQ5V
UL04+iXfLZNKcPr0yfnkynn+MqoXR7286x/McDkONjjc1U2BpWVUl6ERN8xL
wYRt0GiT5cr8AfFDa/o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->39613693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->662807284],

Cell[TextData[{
 "Make a plot showing the positions of the explicit elements of a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " with tooltips:"
}], "ExampleText",
 CellID->155080815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"1", "/", "i"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "+", 
            RowBox[{"2", " ", "j"}]}], ",", "4"}], "]"}], "\[Equal]", "0"}]}],
        "\[Rule]", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"i", "+", "j"}], ")"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567538515],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "33", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 33, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40840742]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{"Tooltip", ",", 
     RowBox[{"Drop", "[", 
      RowBox[{
       RowBox[{"ArrayRules", "[", "s", "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", 
     RowBox[{"1", "/", "10"}], "]"}]}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", "\"\<\[FilledSquare]\>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226976999],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.6, 0.6], PointSize[
      NCache[
       Rational[1, 10], 0.1]], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {1., 1.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 2.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 7.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 1.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 3.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 5.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {2., 9.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {3., 3.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {4., 8.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {4., 2.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {4., 6.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {4., 4.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {4., 10.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {5., 5.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 1.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 3.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 7.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 5.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 6.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {6., 9.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {7., 7.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {8., 10.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {8., 2.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {8., 6.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {8., 8.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {8., 4.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {9., 9.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 3.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 9.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 10.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 7.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 1.}], InsetBox[
      TagBox["\[FilledSquare]",
       "InsetString"], {10., 5.}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1.}}]},
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2.}}]},
      FractionBox["1", "2"]],
     Annotation[#, 
      Rational[1, 2], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 7.}}]},
      FractionBox["1", "9"]],
     Annotation[#, 
      Rational[1, 9], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1.}}]},
      FractionBox["1", "3"]],
     Annotation[#, 
      Rational[1, 3], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 3.}}]},
      FractionBox["1", "5"]],
     Annotation[#, 
      Rational[1, 5], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 5.}}]},
      FractionBox["1", "7"]],
     Annotation[#, 
      Rational[1, 7], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 9.}}]},
      FractionBox["1", "11"]],
     Annotation[#, 
      Rational[1, 11], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 3.}}]},
      FractionBox["1", "3"]],
     Annotation[#, 
      Rational[1, 3], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 8.}}]},
      FractionBox["1", "12"]],
     Annotation[#, 
      Rational[1, 12], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 2.}}]},
      FractionBox["1", "6"]],
     Annotation[#, 
      Rational[1, 6], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 6.}}]},
      FractionBox["1", "10"]],
     Annotation[#, 
      Rational[1, 10], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 4.}}]},
      FractionBox["1", "4"]],
     Annotation[#, 
      Rational[1, 4], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 10.}}]},
      FractionBox["1", "14"]],
     Annotation[#, 
      Rational[1, 14], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 5.}}]},
      FractionBox["1", "5"]],
     Annotation[#, 
      Rational[1, 5], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 1.}}]},
      FractionBox["1", "7"]],
     Annotation[#, 
      Rational[1, 7], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 3.}}]},
      FractionBox["1", "9"]],
     Annotation[#, 
      Rational[1, 9], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 7.}}]},
      FractionBox["1", "13"]],
     Annotation[#, 
      Rational[1, 13], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 5.}}]},
      FractionBox["1", "11"]],
     Annotation[#, 
      Rational[1, 11], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 6.}}]},
      FractionBox["1", "6"]],
     Annotation[#, 
      Rational[1, 6], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 9.}}]},
      FractionBox["1", "15"]],
     Annotation[#, 
      Rational[1, 15], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 7.}}]},
      FractionBox["1", "7"]],
     Annotation[#, 
      Rational[1, 7], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 10.}}]},
      FractionBox["1", "18"]],
     Annotation[#, 
      Rational[1, 18], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 2.}}]},
      FractionBox["1", "10"]],
     Annotation[#, 
      Rational[1, 10], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 6.}}]},
      FractionBox["1", "14"]],
     Annotation[#, 
      Rational[1, 14], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 8.}}]},
      FractionBox["1", "8"]],
     Annotation[#, 
      Rational[1, 8], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 4.}}]},
      FractionBox["1", "12"]],
     Annotation[#, 
      Rational[1, 12], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 9.}}]},
      FractionBox["1", "9"]],
     Annotation[#, 
      Rational[1, 9], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 3.}}]},
      FractionBox["1", "13"]],
     Annotation[#, 
      Rational[1, 13], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 9.}}]},
      FractionBox["1", "19"]],
     Annotation[#, 
      Rational[1, 19], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 10.}}]},
      FractionBox["1", "10"]],
     Annotation[#, 
      Rational[1, 10], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 7.}}]},
      FractionBox["1", "17"]],
     Annotation[#, 
      Rational[1, 17], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 1.}}]},
      FractionBox["1", "11"]],
     Annotation[#, 
      Rational[1, 11], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 5.}}]},
      FractionBox["1", "15"]],
     Annotation[#, 
      Rational[1, 15], "Tooltip"]& ]}},
  AspectRatio->1,
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6193372]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " generally makes a visually better plot:"
}], "ExampleText",
 CellID->13927219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->378700442],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz9v1DAU911ybeGOnBBqxYT6BSo+AAsTSAjEzNDhVCFaJP6oVF1YGECo
AwtDhWBgYmWqEEs3JgQCIRAs/CmlVfkUwc+xL7bznDhxrvKFO90lZ+f5957t
93t+Tu4uDdaWr94YrK0sDebPrw5uL68s3Zk/d2uVVgUtQsgW/bw+Sej3mH5j
n604pufscZYeAyrQpeeQn6F8DK7Cl5i9yFGpvo1c7/L6Hj8LnDYvzzFtc0gr
UaZHEiFa5bKu9QgcwrSc6M8gKBLFGG1N4gRqu65Jx53hI6r3KavPrlcgkO2N
na3YbIpZkse/X9pWgdTLSNZla9egUXiiGJvice7WZmO2HaYd44nuNTY2Vbd7
1jBWmFWYXFerF2MfxDKrTbEFWj0V2jI6pwtGBh2pEvKu7XX7ug3uxaZZKvUy
+or239+DGNH/83EDPL6/8/kxlKNfXzZZ/fdvz6ODd3eDCR6QMkxOyUushB03
LUpLeYVlV5M4kBsZ2m76zUhcFyQgLTiPsT1QZANKLaFv0rO0SJ3xsLHjc3j2
cLcmYkLqZpC8miWqfI8qI8GTatehxd+368cbJd3hczxl2QpkWQaZWUH1UTQi
aGWmmR0DHhvgLFr3eTng5+mh1SpDwjztubztjA3iVCzxvBiHS8/EfnmcLs2Y
SFnImLn34T4r7356xBh78OY6q//59ZkdS5uLZpr9UqgG7yj21YpaHNhRt0Z5
/OCiLb6au4g18f8ct7r9zme+jRPaFZDe31487bm0nmXovqu07sg+Q4Z5Rx0Y
RbmLqRd47oKhQVGgLMRpbmPXurotxfFBwbPkP2a9ASeW8zR/PA/bHWwvMtbR
TIWxDnYLe68uR3S3wOrpbiEng5lgWWMpK0g1zHJ5i6uOkqtveldke5G+Sc9C
o9jXZPf6uTuckfYscJsjOYYNZwiN1tXwc2J52218tKjaVuOXh4yqHUuqPQPS
uy/PXvRcWvFYi1apT84gc26FoJU7h4QGRYFywdDr/FxdscEQS4vyKgXDhosW
Y4CwzQvfcpNmfKPcYzn8zosFkeszXvJcP6K5fomdQiPRijLfquj2WfrotAED
Q4QJVbWEambArxCi3c+wQM4+fZPR0lhg3PPbWp8TZ0aFfbhz7DO3xgntFLT6
8WR2xXNpU8ZhamWfcRgRtHJ+jiBQrhnszM8RFBsq8svUD5w/9Y5K9dnxx8OQ
vJ7K9n9vtCD7SPL6JM+P+LMxyPOt9wiNw1JWWWfMdI2Vc2Hihj+tZcocMdGD
8sm5H/ZsgyJTSrXQN+lZaBN3LvDognLauUdmxhfeI7HVVvZJiKuWOPMcxEN+
jRFWfJM89FZWuYeOtzHcQbeIEIjWEjugGrGG0YSi0Dfp0cODuPSzDw96l8N0
dL5ymey1Zzbzd7vj24v0d+GmX49P/p9iwpj8P8Xe1sn/U5J2k/+nyEfS+gfP
lgmS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->302050917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24399],

Cell[TextData[{
 "For a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    RowBox[{"ArrayRules", "[", 
     StyleBox["s", "TI"], "]"}], ",", 
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["s", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " is identical to ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->626618173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "2"}], "}"}]}], "]"}], "\[RuleDelayed]", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "9"}], ",", "9"}], "}"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24093697],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519964468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ar", " ", "=", " ", 
  RowBox[{"ArrayRules", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->78827667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "4"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "7"}], "}"}], "\[Rule]", 
    RowBox[{"-", "3"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "1"}], "}"}], "\[Rule]", 
    RowBox[{"-", "2"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"9", ",", "4"}], "}"}], "\[Rule]", "7"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{478, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208612295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "===", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"ar", ",", 
    RowBox[{"Dimensions", "[", "s", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->236496891],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->178390154]
}, Open  ]],

Cell["\<\
Specifying the dimensions is needed since they would be inferred from \
explicit elements:\
\>", "ExampleText",
 CellID->391304851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"ar", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "2"}]}], ",", "1", ",", "1"}], "]"}], "]"}], "]"}], ",", 
   
   RowBox[{"Max", "[", 
    RowBox[{"ar", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", 
        RowBox[{"-", "2"}]}], ",", "1", ",", "2"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->112554282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "7"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->227164525]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", "ar", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->234587755],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "7"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->235793248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26695148],

Cell[TextData[{
 "For an explicit array ",
 Cell[BoxData[
  ButtonBox["ArrayRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayRules"]], "InlineFormula"],
 " can be written in terms of ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2949963],

Cell[BoxData[
 RowBox[{
  RowBox[{"par", "[", 
   RowBox[{
    RowBox[{"list_", "?", "ArrayQ"}], ",", 
    RowBox[{"def_:", "0"}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", "=", 
       RowBox[{"ArrayDepth", "[", "list", "]"}]}], ",", " ", "pos"}], "}"}], 
    ",", 
    RowBox[{
     RowBox[{"pos", "=", 
      RowBox[{"Position", "[", 
       RowBox[{"list", ",", 
        RowBox[{"x_", "/;", 
         RowBox[{"x", "\[NotEqual]", "def"}]}], ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Append", "[", 
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"pos", "->", 
         RowBox[{"Extract", "[", 
          RowBox[{"list", ",", "pos"}], "]"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"_", ",", 
          RowBox[{"{", "n", "}"}]}], "]"}], "\[Rule]", "def"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13043141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85113432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350037350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"par", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->584462726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->562123050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "===", 
  RowBox[{"ArrayRules", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->267713421],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->666741241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"par", "[", 
   RowBox[{"a", ",", "1"}], "]"}], "===", 
  RowBox[{"ArrayRules", "[", 
   RowBox[{"a", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->110762020],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->429160789]
}, Open  ]],

Cell[TextData[{
 "This will not work for ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects because pattern matching works on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82004077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", "a", "]"}], ",", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"ArrayDepth", "[", "a", "]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->413819676],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->563024125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"SparseArray", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->682100070],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{"Automatic", ",", 
     RowBox[{"List", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", 
       RowBox[{"List", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "2", ",", "4"}], "]"}], ",", 
         RowBox[{"List", "[", 
          RowBox[{
           RowBox[{"List", "[", "1", "]"}], ",", 
           RowBox[{"List", "[", "3", "]"}], ",", 
           RowBox[{"List", "[", "1", "]"}], ",", 
           RowBox[{"List", "[", "2", "]"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{557, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//FullForm=",
 CellID->61211368]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26343],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22762],

Cell[TextData[ButtonBox["Getting and Setting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GettingAndSettingPiecesOfMatrices"]], "Tutorials",
 CellID->28237],

Cell[TextData[ButtonBox["Sparse Arrays: Manipulating Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-ManipulatingLists"]], "Tutorials",
 CellID->13299],

Cell[TextData[ButtonBox["Sparse Arrays: Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SparseArrays-LinearAlgebra"]], "Tutorials",
 CellID->385244474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->477384689],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->250151988],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->420807710],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->368899204],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout",
 CellID->19451849]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArrayRules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 53.5968820}", "context" -> "System`", 
    "keywords" -> {
     "specify elements in sparse array", "sparse arrays as rules", 
      "explicit elements in sparse array", "sparse array indices", 
      "nonzero elements in sparse array", "sparse matrix rules", 
      "nonzero sparse elements"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ArrayRules[SparseArray[...]] gives the rules {pos_1 -> val_1, pos_2 -> \
val_2, ...} specifying elements in a sparse array. ArrayRules[list] gives \
rules for SparseArray[list]. ", "synonyms" -> {"array rules"}, "title" -> 
    "ArrayRules", "type" -> "Symbol", "uri" -> "ref/ArrayRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7226, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118113986]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63766, 2340}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2812, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3435, 91, 48, 1, 70, "ObjectName",
 CellID->21374],
Cell[3486, 94, 1696, 54, 70, "Usage",
 CellID->5152]
}, Open  ]],
Cell[CellGroupData[{
Cell[5219, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5697, 170, 665, 23, 70, "Notes",
 CellID->23848],
Cell[6365, 195, 478, 17, 70, "Notes",
 CellID->29235],
Cell[6846, 214, 343, 12, 70, "Notes",
 CellID->28638]
}, Closed]],
Cell[CellGroupData[{
Cell[7226, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118113986],
Cell[CellGroupData[{
Cell[7611, 245, 148, 5, 70, "ExampleSection",
 CellID->253732070],
Cell[7762, 252, 219, 8, 70, "ExampleText",
 CellID->52770811],
Cell[CellGroupData[{
Cell[8006, 264, 592, 20, 28, "Input",
 CellID->96507874],
Cell[8601, 286, 481, 17, 36, "Output",
 CellID->107047335]
}, Open  ]],
Cell[CellGroupData[{
Cell[9119, 308, 130, 4, 28, "Input",
 CellID->512159276],
Cell[9252, 314, 1528, 29, 54, "Output",
 Evaluatable->False,
 CellID->68274309]
}, Open  ]],
Cell[10795, 346, 253, 8, 70, "ExampleText",
 CellID->16238655],
Cell[CellGroupData[{
Cell[11073, 358, 132, 4, 70, "Input",
 CellID->697121316],
Cell[11208, 364, 480, 17, 36, "Output",
 CellID->61652705]
}, Open  ]],
Cell[CellGroupData[{
Cell[11725, 386, 95, 3, 70, "Input",
 CellID->265007570],
Cell[11823, 391, 161, 5, 36, "Output",
 CellID->305305808]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12033, 402, 216, 7, 70, "ExampleSection",
 CellID->19984],
Cell[12252, 411, 497, 18, 70, "ExampleText",
 CellID->172739598],
Cell[CellGroupData[{
Cell[12774, 433, 207, 7, 70, "Input",
 CellID->396327120],
Cell[12984, 442, 391, 13, 36, "Output",
 CellID->175402398]
}, Open  ]],
Cell[13390, 458, 217, 8, 70, "ExampleText",
 CellID->347415084],
Cell[CellGroupData[{
Cell[13632, 470, 178, 5, 70, "Input",
 CellID->143006370],
Cell[13813, 477, 489, 17, 36, "Output",
 CellID->531253478]
}, Open  ]],
Cell[CellGroupData[{
Cell[14339, 499, 131, 4, 70, "Input",
 CellID->37915247],
Cell[14473, 505, 639, 22, 36, "Output",
 CellID->614148613]
}, Open  ]],
Cell[15127, 530, 126, 3, 70, "ExampleText",
 CellID->440682771],
Cell[CellGroupData[{
Cell[15278, 537, 156, 5, 70, "Input",
 CellID->539887843],
Cell[15437, 544, 912, 31, 54, "Output",
 CellID->162217332]
}, Open  ]],
Cell[16364, 578, 534, 20, 70, "ExampleText",
 CellID->196100995],
Cell[CellGroupData[{
Cell[16923, 602, 288, 9, 70, "Input",
 CellID->92859862],
Cell[17214, 613, 160, 5, 36, "Output",
 CellID->39480278]
}, Open  ]],
Cell[17389, 621, 124, 3, 70, "ExampleDelimiter",
 CellID->45870002],
Cell[17516, 626, 166, 4, 70, "ExampleText",
 CellID->295240034],
Cell[CellGroupData[{
Cell[17707, 634, 222, 7, 70, "Input",
 CellID->199866653],
Cell[17932, 643, 514, 19, 36, "Output",
 CellID->354942132]
}, Open  ]],
Cell[CellGroupData[{
Cell[18483, 667, 106, 3, 70, "Input",
 CellID->675015606],
Cell[18592, 672, 792, 26, 36, "Output",
 CellID->44570256]
}, Open  ]],
Cell[19399, 701, 407, 15, 70, "ExampleText",
 CellID->128350417],
Cell[CellGroupData[{
Cell[19831, 720, 255, 8, 70, "Input",
 CellID->881578640],
Cell[20089, 730, 161, 5, 36, "Output",
 CellID->476190467]
}, Open  ]],
Cell[20265, 738, 130, 2, 70, "ExampleText",
 CellID->474750985],
Cell[CellGroupData[{
Cell[20420, 744, 129, 4, 70, "Input",
 CellID->588418771],
Cell[20552, 750, 591, 20, 36, "Output",
 CellID->389630357]
}, Open  ]],
Cell[21158, 773, 533, 20, 70, "ExampleText",
 CellID->46186867],
Cell[CellGroupData[{
Cell[21716, 797, 302, 9, 70, "Input",
 CellID->471409985],
Cell[22021, 808, 161, 5, 36, "Output",
 CellID->825209263]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22231, 819, 223, 7, 70, "ExampleSection",
 CellID->30079],
Cell[22457, 828, 230, 8, 70, "ExampleText",
 CellID->375233124],
Cell[CellGroupData[{
Cell[22712, 840, 345, 12, 70, "Input",
 CellID->75162469],
Cell[23060, 854, 455, 16, 36, "Output",
 CellID->77593858]
}, Open  ]],
Cell[CellGroupData[{
Cell[23552, 875, 161, 5, 70, "Input",
 CellID->7691771],
Cell[23716, 882, 157, 5, 36, "Output",
 CellID->67744838]
}, Open  ]],
Cell[23888, 890, 125, 3, 70, "ExampleDelimiter",
 CellID->607193689],
Cell[24016, 895, 117, 3, 70, "ExampleText",
 CellID->26156169],
Cell[CellGroupData[{
Cell[24158, 902, 663, 21, 70, "Input",
 CellID->117644219],
Cell[24824, 925, 481, 17, 36, "Output",
 CellID->537517389]
}, Open  ]],
Cell[25320, 945, 368, 13, 70, "ExampleText",
 CellID->26337973],
Cell[CellGroupData[{
Cell[25713, 962, 382, 13, 70, "Input",
 CellID->224529849],
Cell[26098, 977, 1002, 34, 54, "Output",
 CellID->92675635]
}, Open  ]],
Cell[27115, 1014, 225, 7, 70, "ExampleText",
 CellID->82033721],
Cell[CellGroupData[{
Cell[27365, 1025, 196, 6, 70, "Input",
 CellID->354106678],
Cell[27564, 1033, 478, 17, 36, "Output",
 CellID->11075937]
}, Open  ]],
Cell[CellGroupData[{
Cell[28079, 1055, 540, 17, 70, "Input",
 CellID->58694742],
Cell[28622, 1074, 479, 17, 36, "Output",
 CellID->213340659]
}, Open  ]],
Cell[29116, 1094, 125, 3, 70, "ExampleDelimiter",
 CellID->265975841],
Cell[29244, 1099, 104, 2, 70, "ExampleText",
 CellID->52692084],
Cell[CellGroupData[{
Cell[29373, 1105, 831, 25, 70, "Input",
 CellID->365020294],
Cell[30207, 1132, 481, 17, 36, "Output",
 CellID->388128576]
}, Open  ]],
Cell[CellGroupData[{
Cell[30725, 1154, 487, 16, 70, "Input",
 CellID->49826543],
Cell[31215, 1172, 1376, 48, 54, "Output",
 CellID->309879555]
}, Open  ]],
Cell[CellGroupData[{
Cell[32628, 1225, 202, 6, 70, "Input",
 CellID->177982359],
Cell[32833, 1233, 481, 17, 36, "Output",
 CellID->179485949]
}, Open  ]],
Cell[33329, 1253, 91, 1, 70, "ExampleText",
 CellID->444612691],
Cell[CellGroupData[{
Cell[33445, 1258, 805, 26, 70, "Input",
 CellID->760444274],
Cell[34253, 1286, 479, 17, 36, "Output",
 CellID->385459543]
}, Open  ]],
Cell[34747, 1306, 119, 3, 70, "ExampleText",
 CellID->82656795],
Cell[CellGroupData[{
Cell[34891, 1313, 292, 10, 70, "Input",
 CellID->165051066],
Cell[35186, 1325, 1036, 21, 70, "Output",
 Evaluatable->False,
 CellID->39613693]
}, Open  ]],
Cell[36237, 1349, 125, 3, 70, "ExampleDelimiter",
 CellID->662807284],
Cell[36365, 1354, 267, 8, 70, "ExampleText",
 CellID->155080815],
Cell[CellGroupData[{
Cell[36657, 1366, 765, 26, 70, "Input",
 CellID->567538515],
Cell[37425, 1394, 482, 17, 36, "Output",
 CellID->40840742]
}, Open  ]],
Cell[CellGroupData[{
Cell[37944, 1416, 603, 17, 70, "Input",
 CellID->226976999],
Cell[38550, 1435, 8242, 280, 70, "Output",
 CellID->6193372]
}, Open  ]],
Cell[46807, 1718, 220, 7, 70, "ExampleText",
 CellID->13927219],
Cell[CellGroupData[{
Cell[47052, 1729, 106, 3, 70, "Input",
 CellID->378700442],
Cell[47161, 1734, 1681, 32, 70, "Output",
 Evaluatable->False,
 CellID->302050917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48891, 1772, 233, 7, 70, "ExampleSection",
 CellID->24399],
Cell[49127, 1781, 731, 28, 70, "ExampleText",
 CellID->626618173],
Cell[CellGroupData[{
Cell[49883, 1813, 550, 18, 70, "Input",
 CellID->24093697],
Cell[50436, 1833, 481, 17, 36, "Output",
 CellID->519964468]
}, Open  ]],
Cell[CellGroupData[{
Cell[50954, 1855, 139, 4, 70, "Input",
 CellID->78827667],
Cell[51096, 1861, 810, 29, 36, "Output",
 CellID->208612295]
}, Open  ]],
Cell[CellGroupData[{
Cell[51943, 1895, 196, 6, 70, "Input",
 CellID->236496891],
Cell[52142, 1903, 161, 5, 36, "Output",
 CellID->178390154]
}, Open  ]],
Cell[52318, 1911, 141, 4, 70, "ExampleText",
 CellID->391304851],
Cell[CellGroupData[{
Cell[52484, 1919, 478, 18, 70, "Input",
 CellID->112554282],
Cell[52965, 1939, 203, 7, 36, "Output",
 CellID->227164525]
}, Open  ]],
Cell[CellGroupData[{
Cell[53205, 1951, 108, 3, 70, "Input",
 CellID->234587755],
Cell[53316, 1956, 479, 17, 36, "Output",
 CellID->235793248]
}, Open  ]],
Cell[53810, 1976, 124, 3, 70, "ExampleDelimiter",
 CellID->26695148],
Cell[53937, 1981, 359, 13, 70, "ExampleText",
 CellID->2949963],
Cell[54299, 1996, 1003, 32, 70, "Input",
 CellID->13043141],
Cell[CellGroupData[{
Cell[55327, 2032, 206, 7, 70, "Input",
 CellID->85113432],
Cell[55536, 2041, 322, 11, 36, "Output",
 CellID->350037350]
}, Open  ]],
Cell[CellGroupData[{
Cell[55895, 2057, 99, 3, 70, "Input",
 CellID->584462726],
Cell[55997, 2062, 639, 22, 36, "Output",
 CellID->562123050]
}, Open  ]],
Cell[CellGroupData[{
Cell[56673, 2089, 131, 4, 70, "Input",
 CellID->267713421],
Cell[56807, 2095, 161, 5, 36, "Output",
 CellID->666741241]
}, Open  ]],
Cell[CellGroupData[{
Cell[57005, 2105, 209, 7, 70, "Input",
 CellID->110762020],
Cell[57217, 2114, 161, 5, 36, "Output",
 CellID->429160789]
}, Open  ]],
Cell[57393, 2122, 382, 13, 70, "ExampleText",
 CellID->82004077],
Cell[CellGroupData[{
Cell[57800, 2139, 300, 9, 70, "Input",
 CellID->413819676],
Cell[58103, 2150, 175, 6, 36, "Output",
 CellID->563024125]
}, Open  ]],
Cell[CellGroupData[{
Cell[58315, 2161, 142, 4, 70, "Input",
 CellID->682100070],
Cell[58460, 2167, 991, 29, 68, "Output",
 CellID->61211368]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59512, 2203, 311, 9, 70, "SeeAlsoSection",
 CellID->26343],
Cell[59826, 2214, 698, 26, 70, "SeeAlso",
 CellID->17519]
}, Open  ]],
Cell[CellGroupData[{
Cell[60561, 2245, 314, 9, 70, "TutorialsSection",
 CellID->22762],
Cell[60878, 2256, 185, 4, 70, "Tutorials",
 CellID->28237],
Cell[61066, 2262, 174, 3, 70, "Tutorials",
 CellID->13299],
Cell[61243, 2267, 170, 3, 70, "Tutorials",
 CellID->385244474]
}, Open  ]],
Cell[CellGroupData[{
Cell[61450, 2275, 319, 9, 70, "MoreAboutSection",
 CellID->477384689],
Cell[61772, 2286, 144, 3, 70, "MoreAbout",
 CellID->250151988],
Cell[61919, 2291, 163, 3, 70, "MoreAbout",
 CellID->420807710],
Cell[62085, 2296, 144, 3, 70, "MoreAbout",
 CellID->368899204],
Cell[62232, 2301, 136, 3, 70, "MoreAbout",
 CellID->19451849]
}, Open  ]],
Cell[62383, 2307, 27, 0, 70, "History"],
Cell[62413, 2309, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

