(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    113899,       3441]
NotebookOptionsPosition[    102831,       3061]
NotebookOutlinePosition[    104343,       3102]
CellTagsIndexPosition[    104256,       3097]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Line" :> Documentation`HelpLookup["paclet:ref/Line"], 
          "Arrowheads" :> Documentation`HelpLookup["paclet:ref/Arrowheads"], 
          "Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "DirectedEdges" :> 
          Documentation`HelpLookup["paclet:ref/DirectedEdges"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Line\"\>", 2->"\<\"Arrowheads\"\>", 
       3->"\<\"Inset\"\>", 4->"\<\"DirectedEdges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arrows and Arrow-Like Forms" :> 
          Documentation`HelpLookup["paclet:guide/ArrowsAndArrowLikeForms"], 
          "Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Arrows and Arrow-Like Forms\"\>", 
       2->"\<\"Graphics Objects\"\>", 3->"\<\"Symbolic Graphics Language\"\>",
        4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Arrow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Arrow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arrow"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics primitive which represents an arrow from \
",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]]}], ")"}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]]}], ")"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Arrow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arrow"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an arrow with its ends set back from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " by a distance ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Arrow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Arrow"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["pt", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets back by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18440]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["pt", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["pt", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " represents an arrow whose shaft passes through the sequence of points ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10089],

Cell[TextData[{
 "The positions of points can be specified either in ordinary coordinates as \
",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ", or in scaled coordinates as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", or using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->29494],

Cell["\<\
The shaft of the arrow consists of a sequence of straight segments joining \
the specified points. \
\>", "Notes",
 CellID->22642],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["pt", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["pt", "TI"], 
      StyleBox["2", "TR"]]}], "}"}], "]"}]], "InlineFormula"],
 " is drawn by default with its tail at ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and its head at ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pt", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31620],

Cell[TextData[{
 "The form, orientation and position of arrowheads can be specified by an ",
 Cell[BoxData[
  ButtonBox["Arrowheads",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrowheads"]], "InlineFormula"],
 " directive. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21486],

Cell[TextData[{
 "Graphics directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " apply to both the shaft and arrowhead elements of an arrow. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6146],

Cell["\<\
You can prevent directives from applying to an arrowhead by including \
explicit directives within the graphic used to specify the arrowhead. \
\>", "Notes",
 CellID->27964],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arrow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrow"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 " the setback distance ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is measured in the ordinary coordinate system of the whole graphic, so \
that the arrow will just touch ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["pt", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11486],

Cell[TextData[{
 "If the whole graphic does not have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", then a specified arrow setback may correspond to different distances in \
different directions in the graphic. "
}], "Notes",
 CellID->1271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5097180],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->218430882],

Cell["An arrow primitive:", "ExampleText",
 CellID->85891808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Arrow", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177837131],

Cell[BoxData[
 GraphicsBox[ArrowBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]]], "Output",
 ImageSize->{154, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->346941914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131549723],

Cell["Double-headed arrow:", "ExampleText",
 CellID->5535965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".1"}], ",", ".1"}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432984065],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{-0.1, 0.1}], 
   ArrowBox[NCache[{{0, 0}, {1, Rational[1, 3]}}, {{0, 0}, {
      1, 0.3333333333333333}}]]}]], "Output",
 ImageSize->{154, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->50008692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->451011723],

Cell[TextData[{
 "Differently styled arrows: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6146,
  ButtonNote->"6146"]
}], "ExampleText",
 CellID->141538734],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", ".5"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393439396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "a"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "a"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "a"}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Dashed", ",", "Red", ",", "a"}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29092915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], 
     {Arrowheads[0.1], ArrowBox[{{0, 0}, {1, 0.5}}]}}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], 
     {Arrowheads[0.1], ArrowBox[{{0, 0}, {1, 0.5}}]}}], ",", 
   GraphicsBox[
    {Thickness[Large], 
     {Arrowheads[0.1], ArrowBox[{{0, 0}, {1, 0.5}}]}}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], Thickness[Large], Dashing[{Small, Small}], 
     {Arrowheads[0.1], ArrowBox[{{0, 0}, {1, 0.5}}]}}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->164770448]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14246],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Arrow Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->67980053],

Cell["Single arrow:", "ExampleText",
 CellID->14849191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Arrow", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388054008],

Cell[BoxData[
 GraphicsBox[ArrowBox[{{0, 0}, {2, 1}}]]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->676927723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76563312],

Cell["Multiple connected arrow:", "ExampleText",
 CellID->534470755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Arrow", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357996701],

Cell[BoxData[
 GraphicsBox[ArrowBox[{{0, 0}, {2, 1}, {4, 0}}]]], "Output",
 ImageSize->{154, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->32922086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227688895],

Cell[TextData[{
 "Specify the setback distance: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11486,
  ButtonNote->"11486"]
}], "ExampleText",
 CellID->182972311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", ".3"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", ".3"}], "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", ".3"}], "]"}]}], "}"}], "]"}]}],
   "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197994173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{ArrowBox[{{0, 0}, {2, 1}}], CircleBox[{2, 1}, 0.3]}], ",", 
   GraphicsBox[{ArrowBox[{{0, 0}, {2, 1}}, 0.3], CircleBox[{2, 1}, 0.3]}]}], 
  "}"}]], "Output",
 ImageSize->{330, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->382206069]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".1"}], ",", ".1"}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", ".1"}], "]"}], ",", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", ".1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470715082],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{-0.1, 0.1}], ArrowBox[{{0, 0}, {2, 1}}, {0.1, 0.1}], 
   CircleBox[{0, 0}, 0.1], CircleBox[{2, 1}, 0.1]}]], "Output",
 ImageSize->{154, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->705232406]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Arrow Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->679204336],

Cell[TextData[{
 "Arrows with different thicknesses:",
 " ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6146,
  ButtonNote->"6146"]
}], "ExampleText",
 CellID->8688762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "i", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491605289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Small], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Medium], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], ArrowBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->127464382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->863853020],

Cell[TextData[{
 "Dashed arrows: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6146,
  ButtonNote->"6146"]
}], "ExampleText",
 CellID->230593937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dotted", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"DotDashed", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24488683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], ArrowBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->311866964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->455405189],

Cell[TextData[{
 "Colored arrows:",
 " ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6146,
  ButtonNote->"6146"]
}], "ExampleText",
 CellID->108302694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432527933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], ArrowBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->201668412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403087194],

Cell[TextData[{
 "Arrows with different sizes of arrowheads: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21486,
  ButtonNote->"21486"]
}], "ExampleText",
 CellID->460148652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "i", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".5"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15679934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Arrowheads[Tiny], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[Small], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[Medium], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[Large], ArrowBox[{{0, 0}, {1, 0.5}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->707867924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "i", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", ".5"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{".1", ",", ".2", ",", ".3", ",", ".4"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->910617604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Arrowheads[0.1], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[0.2], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[0.3], ArrowBox[{{0, 0}, {1, 0.5}}]}], ",", 
   GraphicsBox[
    {Arrowheads[0.4], ArrowBox[{{0, 0}, {1, 0.5}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->729837980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416238178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " can be used as an arrowhead:"
}], "ExampleText",
 CellID->702867360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407816311],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{-1, Rational[1, 2]}, {0, 
     0}, {-1, Rational[-1, 2]}, {-1, Rational[1, 2]}}, {{-1, 0.5}, {0, 
     0}, {-1, -0.5}, {-1, 0.5}}]]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->720315391]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".1"}], ",", "0", ",", 
         RowBox[{"{", 
          RowBox[{"h", ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "1", ",", 
         RowBox[{"{", 
          RowBox[{"h", ",", "1"}], "}"}]}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184026874],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[{{-0.1, 0, {
       GraphicsBox[
        LineBox[
         NCache[{{-1, 
            Rational[1, 2]}, {0, 0}, {-1, 
            Rational[-1, 2]}, {-1, 
            Rational[1, 2]}}, {{-1, 0.5}, {0, 0}, {-1, -0.5}, {-1, 0.5}}]]], 
       1}}, {0.1, 1, {
       GraphicsBox[
        LineBox[
         NCache[{{-1, 
            Rational[1, 2]}, {0, 0}, {-1, 
            Rational[-1, 2]}, {-1, 
            Rational[1, 2]}}, {{-1, 0.5}, {0, 0}, {-1, -0.5}, {-1, 0.5}}]]], 
       1}}}], ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{154, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->100280671]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->651701038],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29494]
}], "ExampleText",
 CellID->357815512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15794583],

Cell[BoxData[
 GraphicsBox[ArrowBox[{Scaled[{0, 0.2}], Scaled[{1, 0.8}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->581032446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34213591],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29494]
}], "ExampleText",
 CellID->291780269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".2"}], "}"}], "]"}], ",", 
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", ".8"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318804262],

Cell[BoxData[
 GraphicsBox[ArrowBox[{ImageScaled[{0, 0.2}], ImageScaled[{1, 0.8}]}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->136026709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367142567],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29494]
}], "ExampleText",
 CellID->64236019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", 
          RowBox[{"-", "20"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125041549],

Cell[BoxData[
 GraphicsBox[ArrowBox[{Offset[{10, 20}, {0, 0}], Offset[{-10, -20}, {1, 1}]}],
  
  Frame->True]], "Output",
 ImageSize->{154, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->131357286]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16114],

Cell["Make programmatic annotations to plots: ", "ExampleText",
 CellID->224978355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"Pi", "/", "2"}]}], ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Pi", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Zero\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", 
           RowBox[{"Pi", "/", "2"}]}], ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121138027],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168982210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2802229],

Cell["Display vector fields:", "ExampleText",
 CellID->363920439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "u"}], "}"}], "/", "5"}], "-", "1"}]}], "}"}], ",", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v"}], "}"}], ",", 
         RowBox[{"f", "+", 
          RowBox[{"{", 
           RowBox[{"u", ",", "v"}], "}"}]}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488250265],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57840332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->378816448],

Cell["Define an annotated arrow primitive:", "ExampleText",
 CellID->40438109],

Cell[BoxData[
 RowBox[{
  RowBox[{"AnnotatedArrow", "[", 
   RowBox[{"p_", ",", "q_", ",", "label_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", ".5", ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"Inset", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"label", ",", "Medium"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Center", ",", "Top"}], "}"}]}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545140746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AnnotatedArrow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "\"\<diameter = 2\>\""}], "]"}], 
    ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1581989],

Cell[BoxData[
 GraphicsBox[{
   {Arrowheads[{{-0.1, 0}, {0.1, 0.5, 
       GraphicsBox[
        InsetBox[
         BoxData[
          FormBox[
           StyleBox["\"diameter = 2\"", Medium, StripOnInput -> False], 
           TraditionalForm]], {Center, Top}]]}, {0.1, 1}}], 
    ArrowBox[{{-1, 0}, {1, 0}}]}, CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->565232007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AnnotatedArrow", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], ",", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ",", "\"\<\!\(\*
StyleBox[\"d\",
FontSlant->\"Italic\"]\) = 2\>\""}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->806913435],

Cell[BoxData[
 GraphicsBox[{
   {Arrowheads[{{-0.1, 0}, {0.1, 0.5, 
       GraphicsBox[
        InsetBox[
         BoxData[
          FormBox[
           StyleBox[
           "\"\\!\\(\\*\\nStyleBox[\\\"d\\\",\\nFontSlant->\\\"Italic\\\"]\\) \
= 2\"", Medium, StripOnInput -> False], TraditionalForm]], {Center, Top}]]}, {
      0.1, 1}}], 
    ArrowBox[NCache[{{-2^Rational[-1, 2], -2^Rational[-1, 2]}, {
       2^Rational[-1, 2], 2^
        Rational[-1, 2]}}, {{-0.7071067811865475, -0.7071067811865475}, {
      0.7071067811865475, 0.7071067811865475}}]]}, 
   CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->495043843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->817861041],

Cell["Parallel dimensioning:", "ExampleText",
 CellID->340659753],

Cell[BoxData[
 RowBox[{
  RowBox[{"ParallelDim", "[", 
   RowBox[{"p_", ",", "q_", ",", "offset_", ",", "label_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "0", ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", ".5", ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"Inset", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"label", ",", "Medium"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Center", ",", "Top"}], "}"}]}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "1", ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{".1", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "+", "offset"}], ",", 
       RowBox[{"q", "+", "offset"}]}], "}"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389679117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Thick", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", "Thin", ",", 
    RowBox[{"ParallelDim", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".1"}], ",", ".1"}], "}"}], ",", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->255957265],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[Large], LineBox[{{0, 0}, {1, 1}, {1, 0}, {0, 0}}]}, 
   {Thickness[Tiny], 
    {Arrowheads[{{-0.1, 0}, {0.1, 0, 
        GraphicsBox[
         LineBox[{{0, 1}, {0, -1}}]]}, {0.1, 0.5, 
        GraphicsBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             SqrtBox["2"], Medium, StripOnInput -> False], 
            TraditionalForm]], {Center, Top}]]}, {0.1, 1, 
        GraphicsBox[
         LineBox[{{0, 1}, {0, -1}}]]}, {0.1, 1}}], 
     ArrowBox[{{-0.1, 0.1}, {0.9, 1.1}}]}}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75403647]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10350],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Arrow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrow"]], "InlineFormula"],
 " as an ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->488466117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "+", "1"}], ",", "6"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Arrow", "[", "#1", "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Arrowheads", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261664233],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     {Arrowheads[Medium], 
      ArrowBox[{{1.487566918778423, 1.745569922551708}, {1.999646045934499, 
       0.8861424682982579}}], 
      ArrowBox[{{1.999646045934499, 0.8861424682982579}, {1.5115834480959633`,
        0.013316663887551372`}}], 
      ArrowBox[{{1.5115834480959633`, 0.013316663887551372`}, {
       0.5114456436526332, 0.}}], 
      ArrowBox[{{0.5114456436526332, 0.}, {0., 0.8594781450792934}}], 
      ArrowBox[{{0., 0.8594781450792934}, {0.48875342842880154`, 
       1.7322387782105335`}}], 
      ArrowBox[{{0.48875342842880154`, 1.7322387782105335`}, {
       1.487566918778423, 1.745569922551708}}]}, 
     GraphicsComplexBox[{{1.487566918778423, 1.745569922551708}, {
      1.999646045934499, 0.8861424682982579}, {1.5115834480959633`, 
      0.013316663887551372`}, {0.5114456436526332, 0.}, {0., 
      0.8594781450792934}, {0.48875342842880154`, 1.7322387782105335`}}, 
      {RGBColor[0, 0, 0.7], Arrowheads[Medium], 
       TagBox[
        TooltipBox[PointBox[1],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "5"],
        Annotation[#, 5, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.487566918778423, 1.745569922551708}, {
     1.999646045934499, 0.8861424682982579}, {1.5115834480959633`, 
     0.013316663887551372`}, {0.5114456436526332, 0.}, {0., 
     0.8594781450792934}, {0.48875342842880154`, 1.7322387782105335`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412525628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491424592],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Arrowheads",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrowheads"]], "InlineFormula"],
 " to style the axes: "
}], "ExampleText",
 CellID->130459707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Arrowheads", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.05"}], ",", "0.05"}], "}"}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->318764515],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80818622]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14943],

Cell["A random collection of arrows:", "ExampleText",
 CellID->227287259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"Random", "[", "]"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "75", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13495254],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.8094943111754934], 
    ArrowBox[{{0.41060623649405104`, 0.25567310350869565`}, {
     0.056239260056649254`, 0.2866825120374221}}]}, 
   {Hue[0.1365088396270623], 
    ArrowBox[{{0.749987672272034, 0.53334002929514}, {0.7644569658764115, 
     0.5315576038554335}}]}, 
   {Hue[0.06574592712649723], 
    ArrowBox[{{0.40405756452820185`, 0.2760861679903466}, {
     0.13025561334586966`, 0.027857753109331806`}}]}, 
   {Hue[0.9446172781184239], 
    ArrowBox[{{0.11569036800480825`, 0.2488941658191952}, {0.9270229191205737,
      0.4216837106923692}}]}, 
   {Hue[0.10681819574595987`], 
    ArrowBox[{{0.42015014703708475`, 0.9080605335049206}, {0.3569477879122471,
      0.40129457747934194`}}]}, 
   {Hue[0.08987617015586231], 
    ArrowBox[{{0.2535835219474676, 0.4698313692350926}, {0.33355803500354964`,
      0.8075357987894873}}]}, 
   {Hue[0.07950931862679243], 
    ArrowBox[{{0.862182690924497, 0.8948889408275587}, {0.9616863331328325, 
     0.3817021061900623}}]}, 
   {Hue[0.2718169698174601], 
    ArrowBox[{{0.15415169622591263`, 0.24472883723874705`}, {
     0.8613137640403714, 0.5509157363428838}}]}, 
   {Hue[0.17432331964489378`], 
    ArrowBox[{{0.14523130623723235`, 0.6380166143093537}, {0.857241892205002, 
     0.46922431158319977`}}]}, 
   {Hue[0.891541675880502], 
    ArrowBox[{{0.5186765390293391, 0.43230850640644025`}, {0.140657315861217, 
     0.41443826525921934`}}]}, 
   {Hue[0.7016534774963621], 
    ArrowBox[{{0.3919101584684772, 0.6859678405717096}, {0.9525101148655313, 
     0.9496709481583787}}]}, 
   {Hue[0.5059773715942752], 
    ArrowBox[{{0.9945556669519087, 0.422479207014677}, {0.25670139980381523`, 
     0.4732545166964568}}]}, 
   {Hue[0.24065948169317697`], 
    ArrowBox[{{0.3793300701791045, 0.3066850529396512}, {0.3947655902498286, 
     0.17481950740835073`}}]}, 
   {Hue[0.5535262741272672], 
    ArrowBox[{{0.9503192738636042, 0.04014615350607742}, {0.5118654086580725, 
     0.21441974637962025`}}]}, 
   {Hue[0.9030823453126683], 
    ArrowBox[{{0.898743682679144, 0.8555749830788022}, {0.764725826222882, 
     0.5295581634677953}}]}, 
   {Hue[0.9651645186250691], 
    ArrowBox[{{0.6007057389897592, 0.03130750958276418}, {
     0.28639200448635616`, 0.86241228564427}}]}, 
   {Hue[0.3799165280494872], 
    ArrowBox[{{0.18969931349991298`, 0.2723697872056734}, {
     0.00905846149547318, 0.4617694782315169}}]}, 
   {Hue[0.25916741412167027`], 
    ArrowBox[{{0.5293983889632468, 0.3788806136122638}, {0.31592442254922837`,
      0.9192147114635691}}]}, 
   {Hue[0.8798177625538645], 
    ArrowBox[{{0.6799092127483937, 0.38302893480747646`}, {0.2614011056553196,
      0.9772050351731096}}]}, 
   {Hue[0.1698073013550846], 
    ArrowBox[{{0.5487558467969382, 0.5808260766958302}, {0.6492852301564089, 
     0.6042606479433383}}]}, 
   {Hue[0.5349784202661138], 
    ArrowBox[{{0.04535220087088043, 0.8854920102011503}, {0.6994392512596839, 
     0.8876421434974195}}]}, 
   {Hue[0.8706117909168616], 
    ArrowBox[{{0.6236933540509031, 0.17251609946450008`}, {0.605480812339992, 
     0.9764144105274377}}]}, 
   {Hue[0.7931567546600804], 
    ArrowBox[{{0.8956562543693674, 0.934777873070437}, {0.46028503683962585`, 
     0.3644103220604209}}]}, 
   {Hue[0.01631678074244026], 
    ArrowBox[{{0.7474441832389656, 0.3433585996945334}, {0.941771253514357, 
     0.18403125280626464`}}]}, 
   {Hue[0.7254841090906202], 
    ArrowBox[{{0.18262472997651735`, 0.05862544552206006}, {
     0.4102765870657823, 0.9368903444452357}}]}, 
   {Hue[0.7341029512897993], 
    ArrowBox[{{0.9359696457991149, 0.7406032451797742}, {0.5968023700512803, 
     0.5796309288046964}}]}, 
   {Hue[0.7274108275335832], 
    ArrowBox[{{0.34943196755091765`, 0.9277518216126317}, {
     0.10131267904903485`, 0.7066723174983136}}]}, 
   {Hue[0.07169950262401638], 
    ArrowBox[{{0.8550746747192657, 0.17800874902127806`}, {0.3373245628274406,
      0.1445175058863275}}]}, 
   {Hue[0.6186659133446604], 
    ArrowBox[{{0.3031860859075528, 0.81110377080579}, {0.3109754520925254, 
     0.2746848884655084}}]}, 
   {Hue[0.644226781133937], 
    ArrowBox[{{0.2245189264532501, 0.18499766620898805`}, {
     0.27800572147396374`, 0.4190403251605357}}]}, 
   {Hue[0.6479015089067908], 
    ArrowBox[{{0.5824211682703102, 0.5865313314659821}, {0.879885555609262, 
     0.9262961554164693}}]}, 
   {Hue[0.7998825328065562], 
    ArrowBox[{{0.9028558820839969, 0.40941714133043905`}, {0.874530952701519, 
     0.4886135029743901}}]}, 
   {Hue[0.44434259369976664`], 
    ArrowBox[{{0.34389828101800735`, 0.3941607513818761}, {
     0.028467066539625385`, 0.9327031948515581}}]}, 
   {Hue[0.752685105253435], 
    ArrowBox[{{0.905529937381784, 0.5519610018962939}, {0.19537723918002503`, 
     0.287542126421378}}]}, 
   {Hue[0.9462480314104287], 
    ArrowBox[{{0.11971195067417484`, 0.5689650455415025}, {
     0.31445764072984383`, 0.48208389455734246`}}]}, 
   {Hue[0.29390516121228105`], 
    ArrowBox[{{0.6972727520635209, 0.5996866126874993}, {0.6375239211270272, 
     0.5714392000300177}}]}, 
   {Hue[0.20368311200658964`], 
    ArrowBox[{{0.01975368699443747, 0.9911347002265121}, {
     0.11286942991655202`, 0.6933753414983792}}]}, 
   {Hue[0.1991588311261678], 
    ArrowBox[{{0.8598290489577154, 0.7120850951958204}, {0.05145152276218701, 
     0.2995608082684311}}]}, 
   {Hue[0.04316568609776034], 
    ArrowBox[{{0.5426173975395383, 0.7031473101968213}, {0.2633811952519576, 
     0.7508698615137563}}]}, 
   {Hue[0.32874064258721186`], 
    ArrowBox[{{0.6660297971886919, 0.7404099251065535}, {0.24205496795662218`,
      0.4189274270351493}}]}, 
   {Hue[0.8237665839571024], 
    ArrowBox[{{0.383917490424982, 0.17361141417717163`}, {0.2800442082756096, 
     0.8420576533884301}}]}, 
   {Hue[0.9399914170044975], 
    ArrowBox[{{0.5896044640993592, 0.6926026766612574}, {0.9196829591134854, 
     0.29299535685750744`}}]}, 
   {Hue[0.16334792354389585`], 
    ArrowBox[{{0.9835429284498818, 0.03068439981374116}, {0.8874266451299013, 
     0.7555966182351386}}]}, 
   {Hue[0.1589333412321273], 
    ArrowBox[{{0.255575704859337, 0.7404590388138312}, {0.9723363100616293, 
     0.6544816486928622}}]}, 
   {Hue[0.2887881636909887], 
    ArrowBox[{{0.7520054120053559, 0.5974661059036304}, {0.38679533222582596`,
      0.44708182886945447`}}]}, 
   {Hue[0.06937962608763594], 
    ArrowBox[{{0.007343988332831897, 0.60836213967819}, {0.9375399375676989, 
     0.4077129808386899}}]}, 
   {Hue[0.3701911688838155], 
    ArrowBox[{{0.6427448941391747, 0.824770372392923}, {0.17925925411751908`, 
     0.19593709105810708`}}]}, 
   {Hue[0.14261656048968704`], 
    ArrowBox[{{0.6384086653032994, 0.1902312409253577}, {0.4032216799092665, 
     0.8446985283766235}}]}, 
   {Hue[0.5633040546003684], 
    ArrowBox[{{0.37089920931960796`, 0.12227138304157514`}, {
     0.9004469823216505, 0.6948497601441672}}]}, 
   {Hue[0.3352766747978366], 
    ArrowBox[{{0.8050151544077695, 0.10607861743837255`}, {0.4059997617594435,
      0.15854616969265423`}}]}, 
   {Hue[0.6427803413502323], 
    ArrowBox[{{0.8682130324495845, 0.7320398481186758}, {0.48930041143087233`,
      0.6412889300670583}}]}, 
   {Hue[0.07091705786567067], 
    ArrowBox[{{0.20298366905913467`, 0.9489237556415266}, {0.3769940294345979,
      0.7309274416875946}}]}, 
   {Hue[0.944638141255708], 
    ArrowBox[{{0.9063714078353045, 0.314897159533192}, {0.008222801376450484, 
     0.49163956025284383`}}]}, 
   {Hue[0.6910498936638996], 
    ArrowBox[{{0.23634645609544336`, 0.010824532163094869`}, {
     0.46129161646542793`, 0.32802529108241973`}}]}, 
   {Hue[0.9948788324434416], 
    ArrowBox[{{0.46409521465994796`, 0.5164957294779546}, {0.6913927525472474,
      0.03411325836847334}}]}, 
   {Hue[0.2710345250591144], 
    ArrowBox[{{0.23576102573671953`, 0.35577985641840315`}, {
     0.478875989751252, 0.7617058583218641}}]}, 
   {Hue[0.5002955475559414], 
    ArrowBox[{{0.9227047607061076, 0.7203154335271051}, {0.1712643160292242, 
     0.5606723907765301}}]}, 
   {Hue[0.9383647884104647], 
    ArrowBox[{{0.8531298353852785, 0.5877076293336807}, {0.986064900694064, 
     0.5982857492975195}}]}, 
   {Hue[0.04863080103301286], 
    ArrowBox[{{0.6706223355911767, 0.8921260165178864}, {0.37755552726502883`,
      0.794159653823602}}]}, 
   {Hue[0.9771293638468334], 
    ArrowBox[{{0.8181763663221384, 0.3138434944707882}, {0.13335425866277473`,
      0.4877879909591081}}]}, 
   {Hue[0.2966124355493517], 
    ArrowBox[{{0.9493046214097443, 0.4133610405747363}, {0.9848292601879398, 
     0.8497130469315068}}]}, 
   {Hue[0.7392059572842968], 
    ArrowBox[{{0.3951644511767789, 0.5079804980761464}, {0.32340826801954226`,
      0.5582757591914898}}]}, 
   {Hue[0.005465114935252515], 
    ArrowBox[{{0.3690133743213686, 0.892871824768998}, {0.007622228254780206, 
     0.366778879889313}}]}, 
   {Hue[0.6483887212596215], 
    ArrowBox[{{0.8878386185248344, 0.4502147831484924}, {0.22918432482521567`,
      0.9000343149388756}}]}, 
   {Hue[0.4728458515922493], 
    ArrowBox[{{0.7203735445867954, 0.5498104474858323}, {0.7659253975304365, 
     0.878823736211015}}]}, 
   {Hue[0.7992145402797993], 
    ArrowBox[{{0.6627840801219709, 0.7398415428980143}, {0.05786998046447822, 
     0.9793990791079292}}]}, 
   {Hue[0.8421171913913567], 
    ArrowBox[{{0.7492419119809599, 0.404294318011869}, {0.7982068891840763, 
     0.6145581353488048}}]}, 
   {Hue[0.4894553800274942], 
    ArrowBox[{{0.1062855945122847, 0.8278117867599617}, {0.10729860271456304`,
      0.5691265123180713}}]}, 
   {Hue[0.18405768790126062`], 
    ArrowBox[{{0.12069285666932039`, 0.8840485909308391}, {0.4005669037698918,
      0.9134900880565886}}]}, 
   {Hue[0.7298349141921633], 
    ArrowBox[{{0.8940777746966071, 0.919839835027308}, {0.8934632556532349, 
     0.18120261011090455`}}]}, 
   {Hue[0.4719260225075412], 
    ArrowBox[{{0.21591079167364402`, 0.41862152464165403`}, {
     0.35915011934786834`, 0.9370726527723876}}]}, 
   {Hue[0.34683881953780715`], 
    ArrowBox[{{0.3610956352130317, 0.547910479110316}, {0.30967180215440315`, 
     0.7706963404318763}}]}, 
   {Hue[0.6207536333008923], 
    ArrowBox[{{0.9734768374893157, 0.37915450674363327`}, {0.4775833597938153,
      0.3271211183723417}}]}, 
   {Hue[0.3945582393943267], 
    ArrowBox[{{0.313384567322498, 0.7020149385340857}, {0.909554517584344, 
     0.42050673995582266`}}]}, 
   {Hue[0.8291456811573089], 
    ArrowBox[{{0.2537798687135624, 0.937186209190771}, {0.2965608833509623, 
     0.3524361254245938}}]}}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300768376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->513759988],

Cell["An arrow wheel:", "ExampleText",
 CellID->125901112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"k", "/", "40"}], "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "k", " ", 
             RowBox[{"Pi", "/", "40"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "k", " ", 
             RowBox[{"Pi", " ", "/", "40"}]}], "]"}]}], "}"}]}], "}"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301116094],

Cell[BoxData[
 GraphicsBox[{
   {Hue[
     NCache[
      Rational[1, 40], 0.025]], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[1, 20] Pi], Sin[Rational[1, 20] Pi]}}, {{0, 0}, {
       0.9876883405951378, 0.15643446504023087`}}]]}, 
   {Hue[
     NCache[
      Rational[1, 20], 0.05]], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0, 0}, {
       0.9510565162951535, 0.30901699437494745`}}]]}, 
   {Hue[
     NCache[
      Rational[3, 40], 0.075]], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[3, 20] Pi], Sin[Rational[3, 20] Pi]}}, {{0, 0}, {
       0.8910065241883679, 0.45399049973954675`}}]]}, 
   {Hue[
     NCache[
      Rational[1, 10], 0.1]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.8090169943749475, 0.5877852522924731}}]]}, 
   {Hue[
     NCache[
      Rational[1, 8], 0.125]], 
    ArrowBox[NCache[{{0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2]}}, {{0, 
       0}, {0.7071067811865475, 0.7071067811865475}}]]}, 
   {Hue[
     NCache[
      Rational[3, 20], 0.15]], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{0, 0}, {
       0.5877852522924731, 0.8090169943749475}}]]}, 
   {Hue[
     NCache[
      Rational[7, 40], 0.175]], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[3, 20] Pi], Cos[Rational[3, 20] Pi]}}, {{0, 0}, {
       0.45399049973954675`, 0.8910065241883679}}]]}, 
   {Hue[
     NCache[
      Rational[1, 5], 0.2]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.30901699437494745`, 0.9510565162951535}}]]}, 
   {Hue[
     NCache[
      Rational[9, 40], 0.225]], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[1, 20] Pi], Cos[Rational[1, 20] Pi]}}, {{0, 0}, {
       0.15643446504023087`, 0.9876883405951378}}]]}, 
   {Hue[
     NCache[
      Rational[1, 4], 0.25]], ArrowBox[{{0, 0}, {0, 1}}]}, 
   {Hue[
     NCache[
      Rational[11, 40], 0.275]], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[1, 20] Pi], Cos[Rational[1, 20] Pi]}}, {{0, 
       0}, {-0.15643446504023087`, 0.9876883405951378}}]]}, 
   {Hue[
     NCache[
      Rational[3, 10], 0.3]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.30901699437494745`, 0.9510565162951535}}]]}, 
   {Hue[
     NCache[
      Rational[13, 40], 0.325]], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[3, 20] Pi], Cos[Rational[3, 20] Pi]}}, {{0, 
       0}, {-0.45399049973954675`, 0.8910065241883679}}]]}, 
   {Hue[
     NCache[
      Rational[7, 20], 0.35]], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{0, 
       0}, {-0.5877852522924731, 0.8090169943749475}}]]}, 
   {Hue[
     NCache[
      Rational[3, 8], 0.375]], 
    ArrowBox[NCache[{{0, 0}, {-2^Rational[-1, 2], 2^Rational[-1, 2]}}, {{0, 
       0}, {-0.7071067811865475, 0.7071067811865475}}]]}, 
   {Hue[
     NCache[
      Rational[2, 5], 0.4]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.8090169943749475, 0.5877852522924731}}]]}, 
   {Hue[
     NCache[
      Rational[17, 40], 0.425]], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[3, 20] Pi], Sin[Rational[3, 20] Pi]}}, {{0, 
       0}, {-0.8910065241883679, 0.45399049973954675`}}]]}, 
   {Hue[
     NCache[
      Rational[9, 20], 0.45]], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0, 
       0}, {-0.9510565162951535, 0.30901699437494745`}}]]}, 
   {Hue[
     NCache[
      Rational[19, 40], 0.475]], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[1, 20] Pi], Sin[Rational[1, 20] Pi]}}, {{0, 
       0}, {-0.9876883405951378, 0.15643446504023087`}}]]}, 
   {Hue[
     NCache[
      Rational[1, 2], 0.5]], ArrowBox[{{0, 0}, {-1, 0}}]}, 
   {Hue[
     NCache[
      Rational[21, 40], 0.525]], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[1, 20] Pi], -Sin[Rational[1, 20] Pi]}}, {{0, 
       0}, {-0.9876883405951378, -0.15643446504023087`}}]]}, 
   {Hue[
     NCache[
      Rational[11, 20], 0.55]], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2])}}, {{0, 
       0}, {-0.9510565162951535, -0.30901699437494745`}}]]}, 
   {Hue[
     NCache[
      Rational[23, 40], 0.575]], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[3, 20] Pi], -Sin[Rational[3, 20] Pi]}}, {{0, 
       0}, {-0.8910065241883679, -0.45399049973954675`}}]]}, 
   {Hue[
     NCache[
      Rational[3, 5], 0.6]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.8090169943749475, -0.5877852522924731}}]]}, 
   {Hue[
     NCache[
      Rational[5, 8], 0.625]], 
    ArrowBox[NCache[{{0, 0}, {-2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, 
       0}, {-0.7071067811865475, -0.7071067811865475}}]]}, 
   {Hue[
     NCache[
      Rational[13, 20], 0.65]], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{0, 
       0}, {-0.5877852522924731, -0.8090169943749475}}]]}, 
   {Hue[
     NCache[
      Rational[27, 40], 0.675]], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[3, 20] Pi], -Cos[Rational[3, 20] Pi]}}, {{0, 
       0}, {-0.45399049973954675`, -0.8910065241883679}}]]}, 
   {Hue[
     NCache[
      Rational[7, 10], 0.7]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}}, {{0, 
       0}, {-0.30901699437494745`, -0.9510565162951535}}]]}, 
   {Hue[
     NCache[
      Rational[29, 40], 0.725]], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[1, 20] Pi], -Cos[Rational[1, 20] Pi]}}, {{0, 
       0}, {-0.15643446504023087`, -0.9876883405951378}}]]}, 
   {Hue[
     NCache[
      Rational[3, 4], 0.75]], ArrowBox[{{0, 0}, {0, -1}}]}, 
   {Hue[
     NCache[
      Rational[31, 40], 0.775]], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[1, 20] Pi], -Cos[Rational[1, 20] Pi]}}, {{0, 0}, {
       0.15643446504023087`, -0.9876883405951378}}]]}, 
   {Hue[
     NCache[
      Rational[4, 5], 0.8]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.30901699437494745`, -0.9510565162951535}}]]}, 
   {Hue[
     NCache[
      Rational[33, 40], 0.825]], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[3, 20] Pi], -Cos[Rational[3, 20] Pi]}}, {{0, 0}, {
       0.45399049973954675`, -0.8910065241883679}}]]}, 
   {Hue[
     NCache[
      Rational[17, 20], 0.85]], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{0, 0}, {
       0.5877852522924731, -0.8090169943749475}}]]}, 
   {Hue[
     NCache[
      Rational[7, 8], 0.875]], 
    ArrowBox[NCache[{{0, 0}, {2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, 
       0}, {0.7071067811865475, -0.7071067811865475}}]]}, 
   {Hue[
     NCache[
      Rational[9, 10], 0.9]], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.8090169943749475, -0.5877852522924731}}]]}, 
   {Hue[
     NCache[
      Rational[37, 40], 0.925]], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[3, 20] Pi], -Sin[Rational[3, 20] Pi]}}, {{0, 0}, {
       0.8910065241883679, -0.45399049973954675`}}]]}, 
   {Hue[
     NCache[
      Rational[19, 20], 0.95]], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (1 - 5^Rational[1, 2])}}, {{0, 0}, {
       0.9510565162951535, -0.30901699437494745`}}]]}, 
   {Hue[
     NCache[
      Rational[39, 40], 0.975]], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[1, 20] Pi], -Sin[Rational[1, 20] Pi]}}, {{0, 0}, {
       0.9876883405951378, -0.15643446504023087`}}]]}, 
   {Hue[1], ArrowBox[{{0, 0}, {1, 0}}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421280350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55799409],

Cell["Tangent vectors along an elliptic curve:", "ExampleText",
 CellID->57565437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{
           RowBox[{"t", "/", 
            RowBox[{"(", 
             RowBox[{"2", "Pi"}], ")"}]}], ",", "1", ",", ".8"}], "]"}], ",", 
         
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"f", ",", 
            RowBox[{
             RowBox[{"Normalize", "[", 
              RowBox[{"D", "[", 
               RowBox[{"f", ",", "x"}], "]"}], "]"}], "+", "f"}]}], "}"}], 
          "]"}]}], "}"}], "/.", 
       RowBox[{"x", "\[Rule]", "t"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", ".1"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316243333],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0., 1, 0.8], 
    ArrowBox[{{1., 0.}, {1.7071067811865475`, 0.7071067811865475}}]}, 
   {Hue[0.015915494309189534`, 1, 0.8], 
    ArrowBox[{{1.094837581924854, 0.09983341664682815}, {1.7636648428808375`, 
     0.8432512634881026}}]}, 
   {Hue[0.03183098861837907, 1, 0.8], 
    ArrowBox[{{1.1787359086363027`, 0.19866933079506122`}, {1.802138039729897,
      0.9805707203244348}}]}, 
   {Hue[0.04774648292756861, 1, 0.8], 
    ArrowBox[{{1.2508566957869456`, 0.2955202066613396}, {1.8191519135638443`,
      1.118344942222873}}]}, 
   {Hue[0.06366197723675814, 1, 0.8], 
    ArrowBox[{{1.3104793363115357`, 0.3894183423086505}, {1.8103861294825117`,
      1.2554975523936813`}}]}, 
   {Hue[0.07957747154594767, 1, 0.8], 
    ArrowBox[{{1.3570081004945758`, 0.479425538604203}, {1.7701709796703633`, 
     1.3900826833470386`}}]}, 
   {Hue[0.09549296585513722, 1, 0.8], 
    ArrowBox[{{1.3899780883047137`, 0.5646424733950355}, {1.6911733759293677`,
      1.5182049510086957`}}]}, 
   {Hue[0.11140846016432675`, 1, 0.8], 
    ArrowBox[{{1.4090598745221796`, 0.6442176872376911}, {1.5648459637362113`,
      1.6320085023434998`}}]}, 
   {Hue[0.12732395447351627`, 1, 0.8], 
    ArrowBox[{{1.4140628002466882`, 0.7173560908995228}, {1.3844372525332238`,
      1.7169171580298295`}}]}, 
   {Hue[0.1432394487827058, 1, 0.8], 
    ArrowBox[{{1.4049368778981477`, 0.7833269096274834}, {1.15315960382653, 
     1.7511121152702778`}}]}, 
   {Hue[0.15915494309189535`, 1, 0.8], 
    ArrowBox[{{1.3817732906760363`, 0.8414709848078965}, {0.8948945915176176, 
     1.7149405791875783`}}]}, 
   {Hue[0.17507043740108488`, 1, 0.8], 
    ArrowBox[{{1.3448034814870127`, 0.8912073600614354}, {0.6504911901640069, 
     1.6108812043254863`}}]}, 
   {Hue[0.19098593171027445`, 1, 0.8], 
    ArrowBox[{{1.2943968404438997`, 0.9320390859672264}, {
     0.45062351811608947`, 1.4687387976570028`}}]}, 
   {Hue[0.20690142601946396`, 1, 0.8], 
    ArrowBox[{{1.2310570140417803`, 0.963558185417193}, {0.29761425087073706`,
      1.3222845545115316`}}]}, 
   {Hue[0.2228169203286535, 1, 0.8], 
    ArrowBox[{{1.155416872888701, 0.9854497299884603}, {0.1764544189979884, 
     1.1894902011511055`}}]}, 
   {Hue[0.238732414637843, 1, 0.8], 
    ArrowBox[{{1.0682321882717574`, 0.9974949866040544}, {0.0711324734245856, 
     1.0736012192771336`}}]}, 
   {Hue[0.25464790894703254`, 1, 0.8], 
    ArrowBox[{{0.9703740807402162, 
     0.9995736030415051}, {-0.029223369124849307`, 0.971202169816205}}]}, 
   {Hue[0.27056340325622213`, 1, 0.8], 
    ArrowBox[{{0.8628203161569437, 0.9916648104524686}, {-0.1306334733676649, 
     0.8774301043461602}}]}, 
   {Hue[0.2864788975654116, 1, 0.8], 
    ArrowBox[{{0.7466455361851081, 0.9738476308781951}, {-0.2359282252025195, 
     0.7879745466713373}}]}, 
   {Hue[0.30239439187460115`, 1, 0.8], 
    ArrowBox[{{0.623010520823911, 0.9463000876874145}, {-0.3460645170701743, 
     0.6995338603981488}}]}, 
   {Hue[0.3183098861837907, 1, 0.8], 
    ArrowBox[{{0.4931505902785393, 0.9092974268256817}, {-0.4609298413890091, 
     0.6097468803246534}}]}, 
   {Hue[0.33422538049298023`, 1, 0.8], 
    ArrowBox[{{0.35836326204901614`, 
     0.8632093666488737}, {-0.5797960490296175, 0.5170055147978821}}]}, 
   {Hue[0.35014087480216977`, 1, 0.8], 
    ArrowBox[{{0.21999528656424427`, 
     0.8084964038195901}, {-0.7015712683067716, 0.4202759961345136}}]}, 
   {Hue[0.36605636911135936`, 1, 0.8], 
    ArrowBox[{{0.0794291908968956, 0.74570521217672}, {-0.824941316170836, 
     0.31895705934409946`}}]}, 
   {Hue[0.3819718634205489, 1, 0.8], 
    ArrowBox[{{-0.061930534990095154`, 
     0.6754631805511506}, {-0.9484507868713645, 0.212773389217507}}]}, 
   {Hue[0.3978873577297384, 1, 0.8], 
    ArrowBox[{{-0.20267147144297726`, 
     0.5984721441039564}, {-1.0705502563325289`, 0.1016961234078731}}]}, 
   {Hue[0.4138028520389279, 1, 0.8], 
    ArrowBox[{{-0.34138738154748316`, 
     0.5155013718214642}, {-1.1896231274639626`, -0.014117471640051948`}}]}, 
   {Hue[0.42971834634811745`, 1, 0.8], 
    ArrowBox[{{-0.47669226178323143`, 
     0.4273798802338298}, {-1.3039985773824556`, -0.1343711857817469}}]}, 
   {Hue[0.445633840657307, 1, 0.8], 
    ArrowBox[{{-0.6072341905127536, 
     0.33498815015590466`}, {-1.4119529389169463`, -0.25866809378227695`}}]}, \

   {Hue[0.4615493349664966, 1, 0.8], 
    ArrowBox[{{-0.7317088359356086, 
     0.23924932921398198`}, {-1.5116990305894886`, -0.3865424063049543}}]}, 
   {Hue[0.477464829275686, 1, 0.8], 
    ArrowBox[{{-0.8488724885405782, 
     0.1411200080598672}, {-1.6013604721644608`, -0.5174859701256208}}]}, 
   {Hue[0.4933803235848756, 1, 0.8], 
    ArrowBox[{{-0.957554487839989, 
     0.04158066243329049}, {-1.6789251973110346`, -0.6509684690492636}}]}, 
   {Hue[0.5092958178940651, 1, 0.8], 
    ArrowBox[{{-1.0566689192223333`, -0.058374143427580086`}, \
{-1.7421686086171666`, -0.7864470627423881}}]}, 
   {Hue[0.5252113122032547, 1, 0.8], 
    ArrowBox[{{-1.1452254640521136`, -0.15774569414324865`}, \
{-1.7885316720108762`, -0.9233546823361232}}]}, 
   {Hue[0.5411268065124443, 1, 0.8], 
    ArrowBox[{{-1.2223392946062925`, -0.25554110202683167`}, \
{-1.8149330972788489`, -1.061042551456986}}]}, 
   {Hue[0.5570423008216338, 1, 0.8], 
    ArrowBox[{{-1.2872399149804161`, -0.35078322768961984`}, \
{-1.8174914596014755`, -1.1986236014788023`}}]}, 
   {Hue[0.5729577951308232, 1, 0.8], 
    ArrowBox[{{-1.3392788596289995`, -0.44252044329485246`}, \
{-1.7911489578761617`, -1.3346041917793205`}}]}, 
   {Hue[0.5888732894400128, 1, 0.8], 
    ArrowBox[{{-1.3779361726189014`, -0.5298361409084934}, \
{-1.7292787015964146`, -1.4660831314679745`}}]}, 
   {Hue[0.6047887837492023, 1, 0.8], 
    ArrowBox[{{-1.4028256028571358`, -0.6118578909427193}, \
{-1.6236779885590154`, -1.5871651367528734`}}]}, 
   {Hue[0.6207042780583919, 1, 0.8], 
    ArrowBox[{{-1.4136984633841139`, -0.6877661591839741}, \
{-1.4662013002074457`, -1.686386934115831}}]}, 
   {Hue[0.6366197723675814, 1, 0.8], 
    ArrowBox[{{-1.4104461161715403`, -0.7568024953079282}, \
{-1.2545543346607086`, -1.7445766357152275`}}]}, 
   {Hue[0.652535266676771, 1, 0.8], 
    ArrowBox[{{-1.3931010575976792`, -0.8182771110644108}, \
{-1.0031099793769567`, -1.7390957462517305`}}]}, 
   {Hue[0.6684507609859605, 1, 0.8], 
    ArrowBox[{{-1.3618365937542876`, -0.8715757724135882}, \
{-0.7478949981942424, -1.6609272259760592`}}]}, 
   {Hue[0.6843662552951499, 1, 0.8], 
    ArrowBox[{{-1.3169651088294303`, -0.9161659367494549}, \
{-0.5275819802263793, -1.5300668051939121`}}]}, 
   {Hue[0.7002817496043395, 1, 0.8], 
    ArrowBox[{{-1.2589349438679354`, -0.951602073889516}, \
{-0.3563672012639345, -1.3821499458047286`}}]}, 
   {Hue[0.716197243913529, 1, 0.8], 
    ArrowBox[{{-1.1883259170958766`, -0.977530117665097}, \
{-0.22410247715079717`, -1.2426209659803071`}}]}, 
   {Hue[0.7321127382227187, 1, 0.8], 
    ArrowBox[{{-1.1058435305685186`, -0.9936910036334645}, \
{-0.11383952030723424`, -1.1198973569819783`}}]}, 
   {Hue[0.7480282325319082, 1, 0.8], 
    ArrowBox[{{-1.0123119210269913`, -0.9999232575641008}, \
{-0.01239060078604668, -1.0124673130329715`}}]}, 
   {Hue[0.7639437268410978, 1, 0.8], 
    ArrowBox[{{-0.9086656253963933, -0.9961646088358406}, {
     0.08809045694056393, -0.91568285733725}}]}, 
   {Hue[0.7798592211502873, 1, 0.8], 
    ArrowBox[{{-0.7959402432017567, -0.9824526126243325}, {
     0.1915690930026317, -0.8248921134211111}}]}, 
   {Hue[0.7957747154594768, 1, 0.8], 
    ArrowBox[{{-0.6752620891999122, -0.9589242746631385}, {
     0.2996573228989497, -0.7363661026882375}}]}, 
   {Hue[0.8116902097686663, 1, 0.8], 
    ArrowBox[{{-0.5478369396147511, -0.9258146823277321}, {
     0.41261624871936636`, -0.6473731749714678}}]}, 
   {Hue[0.8276057040778558, 1, 0.8], 
    ArrowBox[{{-0.41493798441977603`, -0.8834546557201531}, {
     0.529934268196041, -0.5560154610034673}}]}, 
   {Hue[0.8435211983870454, 1, 0.8], 
    ArrowBox[{{-0.27789310604473927`, -0.8322674422239008}, {
     0.6506487732556901, -0.46103977840393856`}}]}, 
   {Hue[0.8594366926962349, 1, 0.8], 
    ArrowBox[{{-0.13807161161335246`, -0.7727644875559871}, {
     0.7735255332431328, -0.3616797694144534}}]}, 
   {Hue[0.8753521870054244, 1, 0.8], 
    ArrowBox[{{0.0031294487208680666`, -0.7055403255703919}, {
     0.8971606165165542, -0.2575355588436509}}]}, 
   {Hue[0.891267681314614, 1, 0.8], 
    ArrowBox[{{0.14429924063792932`, -0.6312666378723208}, {
     1.0200394810909637`, -0.1484840457552669}}]}, 
   {Hue[0.9071831756238035, 1, 0.8], 
    ArrowBox[{{0.2840272422415222, -0.5506855425976376}, {
     1.1405711887429535`, -0.03461145129702481}}]}, 
   {Hue[0.9230986699329932, 1, 0.8], 
    ArrowBox[{{0.4209173375275628, -0.4646021794137566}, {1.257106656148762, 
     0.08383872298486483}}]}, 
   {Hue[0.9390141642421826, 1, 0.8], 
    ArrowBox[{{0.5536017659138, -0.373876664830236}, {1.3679447607359057`, 
     0.20650724844111218`}}]}, 
   {Hue[0.954929658551372, 1, 0.8], 
    ArrowBox[{{0.6807547884514401, -0.27941549819892586`}, {
     1.4713269000484912`, 0.3329534562435573}}]}, 
   {Hue[0.9708451528605617, 1, 0.8], 
    ArrowBox[{{0.8011059341704897, -0.18216250427209502`}, {1.5654180781857, 
     0.4626839476146104}}]}, 
   {Hue[0.9867606471697512, 1, 0.8], 
    ArrowBox[{{0.9134526942057211, -0.0830894028174964}, {1.648269987728047, 
     0.5951756966388476}}]}}]], "Output",
 ImageSize->{184, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104570811]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11788],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arrowheads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arrowheads"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Arrow",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Arrow"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->117061836],

Cell[TextData[ButtonBox["Arrows and Arrow-Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArrowsAndArrowLikeForms"]], "MoreAbout",
 CellID->51608703],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->623118787],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->284909524],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->348589070],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->526406914]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arrow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 54.8469140}", "context" -> "System`", 
    "keywords" -> {
     "graphics arrow", "edges", "double arrow", "single arrow", "arrowhead", 
      "vector"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Arrow[{{x_1, y_1}, {x_2, y_2}}] is a graphics primitive which represents \
an arrow from (x_1, y_1) to (x_2, y_2). Arrow[{pt_1, pt_2}, s] represents an \
arrow with its ends set back from pt_1 and pt_2 by a distance s. Arrow[{pt_1, \
pt_2}, {s_1, s_2}] sets back by s_1 from pt_1 and s_2 from pt_2. ", 
    "synonyms" -> {}, "title" -> "Arrow", "type" -> "Symbol", "uri" -> 
    "ref/Arrow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13267, 444, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5097180]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 104114, 3090}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2206, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2829, 74, 1570, 37, 70, "ObjectNameGrid"],
Cell[4402, 113, 3706, 129, 70, "Usage",
 CellID->18440]
}, Open  ]],
Cell[CellGroupData[{
Cell[8145, 247, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8623, 264, 630, 23, 70, "Notes",
 CellID->10089],
Cell[9256, 289, 846, 31, 70, "Notes",
 CellID->29494],
Cell[10105, 322, 140, 4, 70, "Notes",
 CellID->22642],
Cell[10248, 328, 654, 26, 70, "Notes",
 CellID->31620],
Cell[10905, 356, 308, 9, 70, "Notes",
 CellID->21486],
Cell[11216, 367, 438, 14, 70, "Notes",
 CellID->6146],
Cell[11657, 383, 183, 4, 70, "Notes",
 CellID->27964],
Cell[11843, 389, 946, 35, 70, "Notes",
 CellID->11486],
Cell[12792, 426, 438, 13, 70, "Notes",
 CellID->1271]
}, Closed]],
Cell[CellGroupData[{
Cell[13267, 444, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5097180],
Cell[CellGroupData[{
Cell[13650, 458, 148, 5, 70, "ExampleSection",
 CellID->218430882],
Cell[13801, 465, 61, 1, 70, "ExampleText",
 CellID->85891808],
Cell[CellGroupData[{
Cell[13887, 470, 417, 14, 28, "Input",
 CellID->177837131],
Cell[14307, 486, 265, 7, 75, "Output",
 CellID->346941914]
}, Open  ]],
Cell[14587, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->131549723],
Cell[14715, 501, 61, 1, 70, "ExampleText",
 CellID->5535965],
Cell[CellGroupData[{
Cell[14801, 506, 502, 18, 70, "Input",
 CellID->432984065],
Cell[15306, 526, 345, 10, 75, "Output",
 CellID->50008692]
}, Open  ]],
Cell[15666, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->451011723],
Cell[15794, 544, 189, 7, 70, "ExampleText",
 CellID->141538734],
Cell[15986, 553, 415, 15, 70, "Input",
 CellID->393439396],
Cell[CellGroupData[{
Cell[16426, 572, 527, 17, 70, "Input",
 CellID->29092915],
Cell[16956, 591, 696, 20, 75, "Output",
 CellID->164770448]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17701, 617, 216, 7, 70, "ExampleSection",
 CellID->14246],
Cell[CellGroupData[{
Cell[17942, 628, 239, 7, 70, "ExampleSubsection",
 CellID->67980053],
Cell[18184, 637, 55, 1, 70, "ExampleText",
 CellID->14849191],
Cell[CellGroupData[{
Cell[18264, 642, 291, 10, 70, "Input",
 CellID->388054008],
Cell[18558, 654, 249, 7, 99, "Output",
 CellID->676927723]
}, Open  ]],
Cell[18822, 664, 124, 3, 70, "ExampleDelimiter",
 CellID->76563312],
Cell[18949, 669, 68, 1, 70, "ExampleText",
 CellID->534470755],
Cell[CellGroupData[{
Cell[19042, 674, 354, 12, 70, "Input",
 CellID->357996701],
Cell[19399, 688, 256, 7, 64, "Output",
 CellID->32922086]
}, Open  ]],
Cell[19670, 698, 125, 3, 70, "ExampleDelimiter",
 CellID->227688895],
Cell[19798, 703, 194, 7, 70, "ExampleText",
 CellID->182972311],
Cell[CellGroupData[{
Cell[20017, 714, 1011, 35, 70, "Input",
 CellID->197994173],
Cell[21031, 751, 396, 11, 111, "Output",
 CellID->382206069]
}, Open  ]],
Cell[CellGroupData[{
Cell[21464, 767, 815, 28, 70, "Input",
 CellID->470715082],
Cell[22282, 797, 343, 9, 106, "Output",
 CellID->705232406]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22674, 812, 234, 7, 70, "ExampleSubsection",
 CellID->679204336],
Cell[22911, 821, 200, 8, 70, "ExampleText",
 CellID->8688762],
Cell[CellGroupData[{
Cell[23136, 833, 613, 21, 70, "Input",
 CellID->491605289],
Cell[23752, 856, 536, 16, 75, "Output",
 CellID->127464382]
}, Open  ]],
Cell[24303, 875, 125, 3, 70, "ExampleDelimiter",
 CellID->863853020],
Cell[24431, 880, 177, 7, 70, "ExampleText",
 CellID->230593937],
Cell[CellGroupData[{
Cell[24633, 891, 1059, 37, 70, "Input",
 CellID->24488683],
Cell[25695, 930, 491, 15, 75, "Output",
 CellID->311866964]
}, Open  ]],
Cell[26201, 948, 125, 3, 70, "ExampleDelimiter",
 CellID->455405189],
Cell[26329, 953, 183, 8, 70, "ExampleText",
 CellID->108302694],
Cell[CellGroupData[{
Cell[26537, 965, 571, 20, 70, "Input",
 CellID->432527933],
Cell[27111, 987, 540, 16, 75, "Output",
 CellID->201668412]
}, Open  ]],
Cell[27666, 1006, 125, 3, 70, "ExampleDelimiter",
 CellID->403087194],
Cell[27794, 1011, 207, 7, 70, "ExampleText",
 CellID->460148652],
Cell[CellGroupData[{
Cell[28026, 1022, 614, 21, 70, "Input",
 CellID->15679934],
Cell[28643, 1045, 548, 16, 75, "Output",
 CellID->707867924]
}, Open  ]],
Cell[CellGroupData[{
Cell[29228, 1066, 601, 21, 70, "Input",
 CellID->910617604],
Cell[29832, 1089, 540, 16, 75, "Output",
 CellID->729837980]
}, Open  ]],
Cell[30387, 1108, 125, 3, 70, "ExampleDelimiter",
 CellID->416238178],
Cell[30515, 1113, 206, 7, 70, "ExampleText",
 CellID->702867360],
Cell[CellGroupData[{
Cell[30746, 1124, 634, 22, 70, "Input",
 CellID->407816311],
Cell[31383, 1148, 375, 10, 121, "Output",
 CellID->720315391]
}, Open  ]],
Cell[CellGroupData[{
Cell[31795, 1163, 730, 25, 70, "Input",
 CellID->184026874],
Cell[32528, 1190, 749, 22, 99, "Output",
 CellID->100280671]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33326, 1218, 245, 7, 70, "ExampleSubsection",
 CellID->651701038],
Cell[33574, 1227, 279, 11, 70, "ExampleText",
 CellID->357815512],
Cell[CellGroupData[{
Cell[33878, 1242, 437, 14, 70, "Input",
 CellID->15794583],
Cell[34318, 1258, 285, 8, 162, "Output",
 CellID->581032446]
}, Open  ]],
Cell[34618, 1269, 124, 3, 70, "ExampleDelimiter",
 CellID->34213591],
Cell[34745, 1274, 289, 11, 70, "ExampleText",
 CellID->291780269],
Cell[CellGroupData[{
Cell[35059, 1289, 448, 14, 70, "Input",
 CellID->318804262],
Cell[35510, 1305, 295, 8, 162, "Output",
 CellID->136026709]
}, Open  ]],
Cell[35820, 1316, 125, 3, 70, "ExampleDelimiter",
 CellID->367142567],
Cell[35948, 1321, 278, 11, 70, "ExampleText",
 CellID->64236019],
Cell[CellGroupData[{
Cell[36251, 1336, 670, 22, 70, "Input",
 CellID->125041549],
Cell[36924, 1360, 306, 9, 169, "Output",
 CellID->131357286]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37291, 1376, 223, 7, 70, "ExampleSection",
 CellID->16114],
Cell[37517, 1385, 83, 1, 70, "ExampleText",
 CellID->224978355],
Cell[CellGroupData[{
Cell[37625, 1390, 984, 32, 70, "Input",
 CellID->121138027],
Cell[38612, 1424, 2876, 51, 70, "Output",
 Evaluatable->False,
 CellID->168982210]
}, Open  ]],
Cell[41503, 1478, 123, 3, 70, "ExampleDelimiter",
 CellID->2802229],
Cell[41629, 1483, 65, 1, 70, "ExampleText",
 CellID->363920439],
Cell[CellGroupData[{
Cell[41719, 1488, 774, 27, 70, "Input",
 CellID->488250265],
Cell[42496, 1517, 10488, 176, 70, "Output",
 Evaluatable->False,
 CellID->57840332]
}, Open  ]],
Cell[52999, 1696, 125, 3, 70, "ExampleDelimiter",
 CellID->378816448],
Cell[53127, 1701, 78, 1, 70, "ExampleText",
 CellID->40438109],
Cell[53208, 1704, 902, 28, 70, "Input",
 CellID->545140746],
Cell[CellGroupData[{
Cell[54135, 1736, 416, 14, 70, "Input",
 CellID->1581989],
Cell[54554, 1752, 526, 15, 171, "Output",
 CellID->565232007]
}, Open  ]],
Cell[CellGroupData[{
Cell[55117, 1772, 656, 22, 70, "Input",
 CellID->806913435],
Cell[55776, 1796, 779, 21, 171, "Output",
 CellID->495043843]
}, Open  ]],
Cell[56570, 1820, 125, 3, 70, "ExampleDelimiter",
 CellID->817861041],
Cell[56698, 1825, 65, 1, 70, "ExampleText",
 CellID->340659753],
Cell[56766, 1828, 1783, 54, 70, "Input",
 CellID->389679117],
Cell[CellGroupData[{
Cell[58574, 1886, 824, 26, 70, "Input",
 CellID->255957265],
Cell[59401, 1914, 708, 21, 201, "Output",
 CellID->75403647]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60158, 1941, 233, 7, 70, "ExampleSection",
 CellID->10350],
Cell[60394, 1950, 469, 18, 70, "ExampleText",
 CellID->488466117],
Cell[CellGroupData[{
Cell[60888, 1972, 597, 18, 70, "Input",
 CellID->261664233],
Cell[61488, 1992, 2192, 58, 70, "Output",
 CellID->412525628]
}, Open  ]],
Cell[63695, 2053, 125, 3, 70, "ExampleDelimiter",
 CellID->491424592],
Cell[63823, 2058, 210, 8, 70, "ExampleText",
 CellID->130459707],
Cell[CellGroupData[{
Cell[64058, 2070, 398, 14, 70, "Input",
 CellID->318764515],
Cell[64459, 2086, 2501, 45, 70, "Output",
 Evaluatable->False,
 CellID->80818622]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67009, 2137, 224, 7, 70, "ExampleSection",
 CellID->14943],
Cell[67236, 2146, 73, 1, 70, "ExampleText",
 CellID->227287259],
Cell[CellGroupData[{
Cell[67334, 2151, 471, 15, 70, "Input",
 CellID->13495254],
Cell[67808, 2168, 10683, 231, 200, "Output",
 CellID->300768376]
}, Open  ]],
Cell[78506, 2402, 125, 3, 70, "ExampleDelimiter",
 CellID->513759988],
Cell[78634, 2407, 58, 1, 70, "ExampleText",
 CellID->125901112],
Cell[CellGroupData[{
Cell[78717, 2412, 780, 25, 70, "Input",
 CellID->301116094],
Cell[79500, 2439, 9112, 248, 201, "Output",
 CellID->421280350]
}, Open  ]],
Cell[88627, 2690, 124, 3, 70, "ExampleDelimiter",
 CellID->55799409],
Cell[88754, 2695, 82, 1, 70, "ExampleText",
 CellID->57565437],
Cell[CellGroupData[{
Cell[88861, 2700, 1132, 37, 70, "Input",
 CellID->316243333],
Cell[89996, 2739, 9534, 195, 194, "Output",
 CellID->104570811]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99591, 2941, 311, 9, 70, "SeeAlsoSection",
 CellID->11788],
Cell[99905, 2952, 941, 35, 70, "SeeAlso",
 CellID->17349]
}, Open  ]],
Cell[CellGroupData[{
Cell[100883, 2992, 305, 8, 70, "RelatedLinksSection"],
Cell[101191, 3002, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101583, 3019, 319, 9, 70, "MoreAboutSection",
 CellID->117061836],
Cell[101905, 3030, 161, 3, 70, "MoreAbout",
 CellID->51608703],
Cell[102069, 3035, 143, 3, 70, "MoreAbout",
 CellID->623118787],
Cell[102215, 3040, 162, 3, 70, "MoreAbout",
 CellID->284909524],
Cell[102380, 3045, 197, 4, 70, "MoreAbout",
 CellID->348589070],
Cell[102580, 3051, 179, 3, 70, "MoreAbout",
 CellID->526406914]
}, Open  ]],
Cell[102774, 3057, 27, 0, 70, "History"],
Cell[102804, 3059, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

