(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39658,       1479]
NotebookOptionsPosition[     32425,       1229]
NotebookOutlinePosition[     33857,       1268]
CellTagsIndexPosition[     33771,       1263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Refine" :> Documentation`HelpLookup["paclet:ref/Refine"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Assumptions" :> Documentation`HelpLookup["paclet:ref/Assumptions"],
           "$Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/$Assumptions"], "Block" :> 
          Documentation`HelpLookup["paclet:ref/Block"], "Module" :> 
          Documentation`HelpLookup["paclet:ref/Module"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Refine\"\>", 2->"\<\"Reduce\"\>", 
       3->"\<\"Simplify\"\>", 4->"\<\"Assumptions\"\>", 
       5->"\<\"$Assumptions\"\>", 6->"\<\"Block\"\>", 
       7->"\<\"Module\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Formula Manipulation\"\>", 
       3->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Assuming", "ObjectName",
 CellID->15948],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Assuming",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Assuming"], "[", 
       RowBox[{
        StyleBox["assum", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"],
     " appended to ",
     Cell[BoxData[
      ButtonBox["$Assumptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
     ", so that ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"],
     " is included in the default assumptions used by functions such as ",
     Cell[BoxData[
      ButtonBox["Refine",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Simplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " affects the default assumptions for all functions that have an ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option. "
}], "Notes",
 CellID->5081],

Cell["\<\
The assumptions can be equations, inequalities or domain specifications, or \
lists or logical combinations of these. \
\>", "Notes",
 CellID->32271],

Cell[TextData[{
 "Assumptions from nested invocations of ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are combined. "
}], "Notes",
 CellID->31825],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"], "[", 
   RowBox[{
    StyleBox["assum", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      ButtonBox["$Assumptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Assumptions"], "=", 
      RowBox[{
       ButtonBox["$Assumptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/$Assumptions"], "&&", 
       StyleBox["assum", "TI"]}]}], "}"}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9228],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " converts lists of assumptions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], "&&", 
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["2", "TR"]], "&&", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31173]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408134268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->27970821],

Cell[TextData[{
 "Give the same assumptions to ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->387683152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "^", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"x", "^", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174243371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "a"}]]}], "}"}]], "Output",
 ImageSize->{67, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87935725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1296605],

Cell[TextData[{
 "Specify the same assumptions for several ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " calls:"
}], "ExampleText",
 CellID->421340568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "<", "0"}]}], ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"TrueQ", "[", 
      RowBox[{"Refine", "[", 
       RowBox[{
        RowBox[{"x", "-", "y"}], ">", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}], ",", "0"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246183367],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->785927523]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29877],

Cell["Specify assumptions for simplifiers:", "ExampleText",
 CellID->496046392],

Cell[BoxData[
 RowBox[{
  RowBox[{"operations", ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Refine", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "Pi"}], "]"}], "]"}], ",", 
     RowBox[{"Simplify", "[", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"n", "^", "p"}], ",", "p"}], "]"}], "]"}], ",", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"EulerPhi", "[", 
        RowBox[{"p", "^", "n"}], "]"}], "-", 
       RowBox[{"p", "^", "n"}]}], "]"}], ",", 
     RowBox[{"FunctionExpand", "[", 
      RowBox[{"Factorial2", "[", "n", "]"}], "]"}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->119598163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"p", "\[Element]", "Primes"}], "&&", 
    RowBox[{"n", ">", "0"}]}], ",", "operations"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270336134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", 
   RowBox[{"-", 
    SuperscriptBox["p", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{
      FractionBox["1", "4"], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], "4"], "+", 
      FractionBox["n", "2"]}]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], "4"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["n", "2"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{357, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->842392883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144582480],

Cell[TextData[{
 "Specify assumptions for ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " and in integral transforms:"
}], "ExampleText",
 CellID->148351672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"x", "+", "a"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"FourierTransform", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", "a"}], ")"}]}], ",", "x", ",", "w"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46628139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     FractionBox["1", "a"]}], "]"}], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["a"]}], " ", "w"}]], " ", 
     SqrtBox[
      FractionBox["\[Pi]", "2"]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", 
          SqrtBox["a"], " ", "w"}]], " ", 
        RowBox[{"HeavisideTheta", "[", 
         RowBox[{"-", "w"}], "]"}]}], "+", 
       RowBox[{"HeavisideTheta", "[", "w", "]"}]}], ")"}]}], 
    SqrtBox["a"]]}], "}"}]], "Output",
 ImageSize->{491, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37599785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130304687],

Cell[TextData[{
 "Specify assumptions for ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->612674636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"a", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"x", "^", "a"}], ",", 
       RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}], ",", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], ",", 
           RowBox[{"1", "+", "a"}]}], "]"}], 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509467335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   InterpretationBox[
    RowBox[{"x", "+", 
     SuperscriptBox["x", "2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "3"],
      SeriesData[$CellContext`x, 0, {}, 1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1}, 1, 3, 1],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{116, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->738150067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19056],

Cell[TextData[{
 "Write code that uses assumptions; find the number of real roots of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], " ", 
    SuperscriptBox[
     StyleBox["x", "TI"], "2"]}], "+", 
   RowBox[{
    StyleBox["b", "TI"], " ", 
    StyleBox["x", "TI"]}], "+", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->195830381],

Cell[BoxData[
 RowBox[{
  RowBox[{"numberOfRealRoots", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_", ",", "c_"}], "}"}], ",", "assum_"}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Assuming", "[", 
   RowBox[{"assum", ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Refine", "[", 
       RowBox[{"a", "\[Equal]", "0"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Refine", "[", 
         RowBox[{"b", "\[Equal]", "0"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"Refine", "[", 
           RowBox[{"c", "\[Equal]", "0"}], "]"}], ",", "Infinity", ",", "0", 
          ",", "Indeterminate"}], "]"}], ",", "\[IndentingNewLine]", "1", ",",
         "\[IndentingNewLine]", "Indeterminate"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{
        RowBox[{"Refine", "[", 
         RowBox[{"Sign", "[", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"4", "a", " ", "c"}]}], "]"}], "]"}], ",", 
        "\[IndentingNewLine]", "1", ",", "2", ",", "\[IndentingNewLine]", "0",
         ",", "1", ",", "\[IndentingNewLine]", 
        RowBox[{"-", "1"}], ",", "0", ",", "\[IndentingNewLine]", "_", ",", 
        "Indeterminate"}], "]"}], ",", "\[IndentingNewLine]", 
      "Indeterminate"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54559622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"a", ">", "b", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->426535775],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->585006652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a"}], "}"}], ",", 
   RowBox[{"b", ">", 
    RowBox[{"2", "a"}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->818536],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32796706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfRealRoots", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"b", "!=", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->286593832],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->155683210]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " locally sets the value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->327934170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"$Assumptions", ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105796528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52871886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281473934],

Cell[TextData[{
 "Assumptions from nested invocations of ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are combined:"
}], "ExampleText",
 CellID->620275880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"y", "<", "0"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510819696],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->925205498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2464174],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " can also be used to locally set the value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->227201957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"$Assumptions", ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216179541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208640608]
}, Open  ]],

Cell[TextData[{
 "Here the assumptions from ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are not used inside ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->442768236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$Assumptions", "=", 
       RowBox[{"y", "<", "0"}]}], "}"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286472822],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32696594]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to using nested ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->312568976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$Assumptions", "=", 
       RowBox[{"$Assumptions", "&&", 
        RowBox[{"y", "<", "0"}]}]}], "}"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->352904902],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->635623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107628890],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " affects functions using ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " ",
 Cell[BoxData[":>"], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " option setting:"
}], "ExampleText",
 CellID->14679804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ToExpression", "/@", 
    RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "#", "]"}], "===", "Symbol"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Options", "[", "#", "]"}], ",", 
       RowBox[{"Assumptions", "\[RuleDelayed]", "$Assumptions"}]}], "]"}]}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387781780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "ExpectedValue", ",", "FourierCosTransform", ",", "FourierSinTransform", 
   ",", "FourierTransform", ",", "FullSimplify", ",", "FunctionExpand", ",", 
   "Integrate", ",", "InverseFourierCosTransform", ",", 
   "InverseFourierSinTransform", ",", "InverseFourierTransform", ",", 
   "LaplaceTransform", ",", "Limit", ",", "PiecewiseExpand", ",", 
   "PossibleZeroQ", ",", "Refine", ",", "Series", ",", "Simplify"}], 
  "}"}]], "Output",
 ImageSize->{521, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25552353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->542607948],

Cell["\<\
For some functions assumptions can be given both as an argument and as an \
option value:\
\>", "ExampleText",
 CellID->294389964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"m", ",", "2"}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"k", " ", "Pi"}], "]"}], "^", "m"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"k", ",", "Integers"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237031262],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152905907]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30589],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is set directly, assumptions specified with ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are not used:"
}], "ExampleText",
 CellID->313243743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318847199],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608134411]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13991],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13454],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->10309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8009626],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->351996124],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->190371472],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->37850420]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Assuming - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 59.7532896}", "context" -> "System`", 
    "keywords" -> {
     "assume", "Assumptions", "evaluation using assumptions", 
      "global assumptions", "scope", "type assumptions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Assuming[assum, expr] evaluates expr with assum appended to \
$Assumptions, so that assum is included in the default assumptions used by \
functions such as Refine, Simplify and Integrate. ", "synonyms" -> {}, 
    "title" -> "Assuming", "type" -> "Symbol", "uri" -> "ref/Assuming"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7557, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->408134268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33628, 1256}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2615, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3238, 86, 46, 1, 70, "ObjectName",
 CellID->15948],
Cell[3287, 89, 1432, 46, 70, "Usage",
 CellID->28251]
}, Open  ]],
Cell[CellGroupData[{
Cell[4756, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5234, 157, 369, 12, 70, "Notes",
 CellID->5081],
Cell[5606, 171, 159, 4, 70, "Notes",
 CellID->32271],
Cell[5768, 177, 226, 8, 70, "Notes",
 CellID->31825],
Cell[5997, 187, 811, 29, 70, "Notes",
 CellID->9228],
Cell[6811, 218, 709, 28, 70, "Notes",
 CellID->31173]
}, Closed]],
Cell[CellGroupData[{
Cell[7557, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408134268],
Cell[CellGroupData[{
Cell[7942, 265, 147, 5, 70, "ExampleSection",
 CellID->27970821],
Cell[8092, 272, 339, 13, 70, "ExampleText",
 CellID->387683152],
Cell[CellGroupData[{
Cell[8456, 289, 463, 16, 28, "Input",
 CellID->174243371],
Cell[8922, 307, 249, 9, 51, "Output",
 CellID->87935725]
}, Open  ]],
Cell[9186, 319, 123, 3, 70, "ExampleDelimiter",
 CellID->1296605],
Cell[9312, 324, 226, 8, 70, "ExampleText",
 CellID->421340568],
Cell[CellGroupData[{
Cell[9563, 336, 565, 19, 70, "Input",
 CellID->246183367],
Cell[10131, 357, 198, 7, 36, "Output",
 CellID->785927523]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10378, 370, 216, 7, 70, "ExampleSection",
 CellID->29877],
Cell[10597, 379, 79, 1, 70, "ExampleText",
 CellID->496046392],
Cell[10679, 382, 670, 21, 70, "Input",
 CellID->119598163],
Cell[CellGroupData[{
Cell[11374, 407, 277, 8, 70, "Input",
 CellID->270336134],
Cell[11654, 417, 924, 33, 54, "Output",
 CellID->842392883]
}, Open  ]],
Cell[12593, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->144582480],
Cell[12721, 458, 236, 8, 70, "ExampleText",
 CellID->148351672],
Cell[CellGroupData[{
Cell[12982, 470, 627, 21, 70, "Input",
 CellID->46628139],
Cell[13612, 493, 810, 28, 73, "Output",
 CellID->37599785]
}, Open  ]],
Cell[14437, 524, 125, 3, 70, "ExampleDelimiter",
 CellID->130304687],
Cell[14565, 529, 326, 13, 70, "ExampleText",
 CellID->612674636],
Cell[CellGroupData[{
Cell[14916, 546, 721, 24, 70, "Input",
 CellID->509467335],
Cell[15640, 572, 531, 17, 39, "Output",
 CellID->738150067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16220, 595, 223, 7, 70, "ExampleSection",
 CellID->19056],
Cell[16446, 604, 381, 14, 70, "ExampleText",
 CellID->195830381],
Cell[16830, 620, 1494, 37, 70, "Input",
 CellID->54559622],
Cell[CellGroupData[{
Cell[18349, 661, 229, 7, 70, "Input",
 CellID->426535775],
Cell[18581, 670, 158, 5, 36, "Output",
 CellID->585006652]
}, Open  ]],
Cell[CellGroupData[{
Cell[18776, 680, 246, 8, 70, "Input",
 CellID->818536],
Cell[19025, 690, 157, 5, 36, "Output",
 CellID->32796706]
}, Open  ]],
Cell[CellGroupData[{
Cell[19219, 700, 220, 7, 70, "Input",
 CellID->286593832],
Cell[19442, 709, 158, 5, 36, "Output",
 CellID->155683210]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19649, 720, 233, 7, 70, "ExampleSection",
 CellID->10773],
Cell[19885, 729, 337, 12, 70, "ExampleText",
 CellID->327934170],
Cell[CellGroupData[{
Cell[20247, 745, 310, 10, 70, "Input",
 CellID->105796528],
Cell[20560, 757, 226, 8, 36, "Output",
 CellID->52871886]
}, Open  ]],
Cell[20801, 768, 125, 3, 70, "ExampleDelimiter",
 CellID->281473934],
Cell[20929, 773, 235, 8, 70, "ExampleText",
 CellID->620275880],
Cell[CellGroupData[{
Cell[21189, 785, 404, 13, 70, "Input",
 CellID->510819696],
Cell[21596, 800, 198, 7, 36, "Output",
 CellID->925205498]
}, Open  ]],
Cell[21809, 810, 123, 3, 70, "ExampleDelimiter",
 CellID->2464174],
Cell[21935, 815, 350, 12, 70, "ExampleText",
 CellID->227201957],
Cell[CellGroupData[{
Cell[22310, 831, 369, 12, 70, "Input",
 CellID->216179541],
Cell[22682, 845, 227, 8, 36, "Output",
 CellID->208640608]
}, Open  ]],
Cell[22924, 856, 348, 13, 70, "ExampleText",
 CellID->442768236],
Cell[CellGroupData[{
Cell[23297, 873, 467, 15, 70, "Input",
 CellID->286472822],
Cell[23767, 890, 236, 9, 45, "Output",
 CellID->32696594]
}, Open  ]],
Cell[24018, 902, 218, 8, 70, "ExampleText",
 CellID->312568976],
Cell[CellGroupData[{
Cell[24261, 914, 508, 16, 70, "Input",
 CellID->352904902],
Cell[24772, 932, 195, 7, 36, "Output",
 CellID->635623]
}, Open  ]],
Cell[24982, 942, 125, 3, 70, "ExampleDelimiter",
 CellID->107628890],
Cell[25110, 947, 525, 19, 70, "ExampleText",
 CellID->14679804],
Cell[CellGroupData[{
Cell[25660, 970, 493, 15, 70, "Input",
 CellID->387781780],
Cell[26156, 987, 608, 14, 88, "Output",
 CellID->25552353]
}, Open  ]],
Cell[26779, 1004, 125, 3, 70, "ExampleDelimiter",
 CellID->542607948],
Cell[26907, 1009, 140, 4, 70, "ExampleText",
 CellID->294389964],
Cell[CellGroupData[{
Cell[27072, 1017, 437, 14, 70, "Input",
 CellID->237031262],
Cell[27512, 1033, 158, 5, 36, "Output",
 CellID->152905907]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27719, 1044, 226, 7, 70, "ExampleSection",
 CellID->30589],
Cell[27948, 1053, 383, 13, 70, "ExampleText",
 CellID->313243743],
Cell[CellGroupData[{
Cell[28356, 1070, 398, 13, 70, "Input",
 CellID->318847199],
Cell[28757, 1085, 237, 9, 45, "Output",
 CellID->608134411]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29055, 1101, 311, 9, 70, "SeeAlsoSection",
 CellID->13991],
Cell[29369, 1112, 1672, 62, 70, "SeeAlso",
 CellID->13739]
}, Open  ]],
Cell[CellGroupData[{
Cell[31078, 1179, 314, 9, 70, "TutorialsSection",
 CellID->13454],
Cell[31395, 1190, 144, 3, 70, "Tutorials",
 CellID->10309]
}, Open  ]],
Cell[CellGroupData[{
Cell[31576, 1198, 317, 9, 70, "MoreAboutSection",
 CellID->8009626],
Cell[31896, 1209, 156, 3, 70, "MoreAbout",
 CellID->351996124],
Cell[32055, 1214, 151, 3, 70, "MoreAbout",
 CellID->190371472],
Cell[32209, 1219, 144, 3, 70, "MoreAbout",
 CellID->37850420]
}, Open  ]],
Cell[32368, 1225, 27, 0, 70, "History"],
Cell[32398, 1227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

