(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27434,       1034]
NotebookOptionsPosition[     21768,        839]
NotebookOutlinePosition[     23235,        879]
CellTagsIndexPosition[     23150,        874]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Definite Integrals" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiniteIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Definite Integrals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assuming" :> Documentation`HelpLookup["paclet:ref/Assuming"], 
          "$Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/$Assumptions"], 
          "GenerateConditions" :> 
          Documentation`HelpLookup["paclet:ref/GenerateConditions"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "Refine" :> Documentation`HelpLookup["paclet:ref/Refine"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Assuming\"\>", 2->"\<\"$Assumptions\"\>", 
       3->"\<\"GenerateConditions\"\>", 4->"\<\"Integrate\"\>", 
       5->"\<\"Refine\"\>", 6->"\<\"Limit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>", 
       2->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Assumptions", "ObjectName",
 CellID->26112],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Assumptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
     "\[LineSeparator]is an option for functions such as ",
     Cell[BoxData[
      ButtonBox["Simplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Refine",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     " which specifies default assumptions to be made about symbolic \
quantities. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"Assumptions", ":>", 
   ButtonBox["$Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Assumptions"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11845],

Cell["\<\
The assumptions can be equations, inequalities or domain specifications, or \
lists or logical combinations of these. \
\>", "Notes",
 CellID->2486],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " modifies ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " and so modifies the value of default settings for ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " options. "
}], "Notes",
 CellID->29556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Reals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reals"]}]], "InlineFormula"],
 " can be used to specify that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " should be treated as a real variable. "
}], "Notes",
 CellID->28603],

Cell["\<\
Quantities that appear algebraically in inequalities are always assumed to be \
real. \
\>", "Notes",
 CellID->1364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4030546],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->71013429],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->264582929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716513161],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186089507]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->38841855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "Pi"}], "]"}], "^", "m"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"k", ",", "Integers"}], "]"}], "&&", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"m", ",", "2"}], "]"}], "\[Equal]", "0"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223134867],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30637697]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->96188692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Factorial2", "[", "n", "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"n", "\[Element]", "Integers"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->291176668],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    FractionBox["1", "4"], "+", 
    FractionBox["n", "2"], "-", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}]], " ", 
  SuperscriptBox["\[Pi]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["n", "2"]}], "]"}]}]], "Output",
 ImageSize->{246, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53241778]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->77586316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->193440536],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "a"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->630121062]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->641279454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "a"}], ")"}]}], ",", "x", ",", "w", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->734688313],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["a"]}], " ", "w"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        SqrtBox["a"], " ", "w"}]], " ", 
      RowBox[{"HeavisideTheta", "[", 
       RowBox[{"-", "w"}], "]"}]}], "+", 
     RowBox[{"HeavisideTheta", "[", "w", "]"}]}], ")"}]}], 
  SqrtBox["a"]]], "Output",
 ImageSize->{401, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->19446913]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->133714493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"x", "^", "a"}], ",", 
   RowBox[{"x", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->658170253],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->4104994]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->98957933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], ",", 
       RowBox[{"1", "+", "a"}]}], "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->708852297],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   SuperscriptBox["x", "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1}, 1, 3, 1],
  Editable->False]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->296793292]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16544],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " is the default value of ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " for most functions that have the option:"
}], "ExampleText",
 CellID->5576546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"ToExpression", "/@", 
    RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "#", "]"}], "===", "Symbol"}], "&&", 
     RowBox[{"MemberQ", "[", 
      RowBox[{
       RowBox[{"Options", "[", "#", "]"}], ",", 
       RowBox[{"Assumptions", "\[RuleDelayed]", "$Assumptions"}]}], "]"}]}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387781780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "FourierCosTransform", ",", "FourierSinTransform", ",", "FourierTransform", 
   ",", "FullSimplify", ",", "FunctionExpand", ",", "Integrate", ",", 
   "InverseFourierCosTransform", ",", "InverseFourierSinTransform", ",", 
   "InverseFourierTransform", ",", "LaplaceTransform", ",", "Limit", ",", 
   "PiecewiseExpand", ",", "PossibleZeroQ", ",", "Refine", ",", "Series", ",",
    "Simplify"}], "}"}]], "Output",
 ImageSize->{496, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190171226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59169],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " locally sets the value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->327934170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"$Assumptions", ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105796528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184378388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2464174],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " can also be used to locally set the value of ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->227201957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$Assumptions", "=", 
     RowBox[{"x", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"$Assumptions", ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216179541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87438570]
}, Open  ]],

Cell[TextData[{
 "Here the assumptions from ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are not used inside ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->442768236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$Assumptions", "=", 
       RowBox[{"y", "<", "0"}]}], "}"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->286472822],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85683479]
}, Open  ]],

Cell[TextData[{
 "Assumptions from nested ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " are combined:"
}], "ExampleText",
 CellID->312568976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"Assuming", "[", 
    RowBox[{
     RowBox[{"y", "<", "0"}], ",", 
     RowBox[{"Refine", "[", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "]"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->352904902],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1903546]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6723],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GenerateConditions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenerateConditions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16498],

Cell[TextData[ButtonBox["Definite Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiniteIntegrals"]], "Tutorials",
 CellID->2508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41591254],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->112061712],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->294413504]
}, Open  ]],

Cell["New in 3  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Assumptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 0.1126738}", "context" -> "System`", 
    "keywords" -> {
     "applicability", "conditions", "criteria", "inequalities", "inferences", 
      "parameters", "types", "additional conditions", 
      "additional assumptions", "prerequisites"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Assumptions is an option for functions such as Simplify, Refine and \
Integrate which specifies default assumptions to be made about symbolic \
quantities. ", "synonyms" -> {}, "title" -> "Assumptions", "type" -> "Symbol",
     "uri" -> "ref/Assumptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5956, 195, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4030546]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23009, 867}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2407, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3030, 82, 49, 1, 70, "ObjectName",
 CellID->26112],
Cell[3082, 85, 938, 29, 70, "Usage",
 CellID->20576]
}, Open  ]],
Cell[CellGroupData[{
Cell[4057, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4535, 136, 242, 9, 70, "Notes",
 CellID->11845],
Cell[4780, 147, 158, 4, 70, "Notes",
 CellID->2486],
Cell[4941, 153, 500, 17, 70, "Notes",
 CellID->29556],
Cell[5444, 172, 346, 12, 70, "Notes",
 CellID->28603],
Cell[5793, 186, 126, 4, 70, "Notes",
 CellID->1364]
}, Closed]],
Cell[CellGroupData[{
Cell[5956, 195, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4030546],
Cell[CellGroupData[{
Cell[6339, 209, 147, 5, 70, "ExampleSection",
 CellID->71013429],
Cell[6489, 216, 174, 7, 70, "ExampleText",
 CellID->264582929],
Cell[CellGroupData[{
Cell[6688, 227, 242, 8, 28, "Input",
 CellID->716513161],
Cell[6933, 237, 175, 6, 36, "Output",
 CellID->186089507]
}, Open  ]],
Cell[7123, 246, 177, 7, 70, "ExampleText",
 CellID->38841855],
Cell[CellGroupData[{
Cell[7325, 257, 445, 15, 28, "Input",
 CellID->223134867],
Cell[7773, 274, 157, 5, 36, "Output",
 CellID->30637697]
}, Open  ]],
Cell[7945, 282, 189, 7, 70, "ExampleText",
 CellID->96188692],
Cell[CellGroupData[{
Cell[8159, 293, 247, 7, 70, "Input",
 CellID->291176668],
Cell[8409, 302, 695, 25, 52, "Output",
 CellID->53241778]
}, Open  ]],
Cell[9119, 330, 179, 7, 70, "ExampleText",
 CellID->77586316],
Cell[CellGroupData[{
Cell[9323, 341, 286, 9, 70, "Input",
 CellID->193440536],
Cell[9612, 352, 201, 7, 51, "Output",
 CellID->630121062]
}, Open  ]],
Cell[9828, 362, 194, 7, 70, "ExampleText",
 CellID->641279454],
Cell[CellGroupData[{
Cell[10047, 373, 322, 10, 70, "Input",
 CellID->734688313],
Cell[10372, 385, 649, 23, 73, "Output",
 CellID->19446913]
}, Open  ]],
Cell[11036, 411, 172, 7, 70, "ExampleText",
 CellID->133714493],
Cell[CellGroupData[{
Cell[11233, 422, 260, 8, 70, "Input",
 CellID->658170253],
Cell[11496, 432, 156, 5, 36, "Output",
 CellID->4104994]
}, Open  ]],
Cell[11667, 440, 173, 7, 70, "ExampleText",
 CellID->98957933],
Cell[CellGroupData[{
Cell[11865, 451, 484, 16, 70, "Input",
 CellID->708852297],
Cell[12352, 469, 455, 15, 36, "Output",
 CellID->296793292]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12856, 490, 233, 7, 70, "ExampleSection",
 CellID->16544],
Cell[13092, 499, 379, 12, 70, "ExampleText",
 CellID->5576546],
Cell[CellGroupData[{
Cell[13496, 515, 493, 15, 70, "Input",
 CellID->387781780],
Cell[13992, 532, 584, 13, 88, "Output",
 CellID->190171226]
}, Open  ]],
Cell[14591, 548, 121, 3, 70, "ExampleDelimiter",
 CellID->59169],
Cell[14715, 553, 337, 12, 70, "ExampleText",
 CellID->327934170],
Cell[CellGroupData[{
Cell[15077, 569, 310, 10, 70, "Input",
 CellID->105796528],
Cell[15390, 581, 227, 8, 36, "Output",
 CellID->184378388]
}, Open  ]],
Cell[15632, 592, 123, 3, 70, "ExampleDelimiter",
 CellID->2464174],
Cell[15758, 597, 350, 12, 70, "ExampleText",
 CellID->227201957],
Cell[CellGroupData[{
Cell[16133, 613, 369, 12, 70, "Input",
 CellID->216179541],
Cell[16505, 627, 226, 8, 36, "Output",
 CellID->87438570]
}, Open  ]],
Cell[16746, 638, 348, 13, 70, "ExampleText",
 CellID->442768236],
Cell[CellGroupData[{
Cell[17119, 655, 467, 15, 70, "Input",
 CellID->286472822],
Cell[17589, 672, 236, 9, 45, "Output",
 CellID->85683479]
}, Open  ]],
Cell[17840, 684, 220, 8, 70, "ExampleText",
 CellID->312568976],
Cell[CellGroupData[{
Cell[18085, 696, 404, 13, 70, "Input",
 CellID->352904902],
Cell[18492, 711, 196, 7, 36, "Output",
 CellID->1903546]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18749, 725, 310, 9, 70, "SeeAlsoSection",
 CellID->6723],
Cell[19062, 736, 1450, 53, 70, "SeeAlso",
 CellID->3005]
}, Open  ]],
Cell[CellGroupData[{
Cell[20549, 794, 314, 9, 70, "TutorialsSection",
 CellID->16498],
Cell[20866, 805, 145, 3, 70, "Tutorials",
 CellID->2508]
}, Open  ]],
Cell[CellGroupData[{
Cell[21048, 813, 318, 9, 70, "MoreAboutSection",
 CellID->41591254],
Cell[21369, 824, 156, 3, 70, "MoreAbout",
 CellID->112061712],
Cell[21528, 829, 145, 3, 70, "MoreAbout",
 CellID->294413504]
}, Open  ]],
Cell[21688, 835, 50, 0, 70, "History"],
Cell[21741, 837, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

