(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52660,       1947]
NotebookOptionsPosition[     42728,       1596]
NotebookOutlinePosition[     44153,       1635]
CellTagsIndexPosition[     44067,       1630]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Everything Is an Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EverythingIsAnExpression"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Specifying Types of Expression in Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Everything Is an Expression\"\>", 
       2->"\<\"Putting Constraints on Patterns\"\>", 
       3->"\<\"Specifying Types of Expression in Patterns\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberQ" :> Documentation`HelpLookup["paclet:ref/NumberQ"], 
          "Head" :> Documentation`HelpLookup["paclet:ref/Head"], "LeafCount" :> 
          Documentation`HelpLookup["paclet:ref/LeafCount"], "Length" :> 
          Documentation`HelpLookup["paclet:ref/Length"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NumberQ\"\>", 2->"\<\"Head\"\>", 
       3->"\<\"LeafCount\"\>", 4->"\<\"Length\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AtomQ", "ObjectName",
 CellID->8507],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AtomQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AtomQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an expression which cannot be divided into subexpressions, and \
yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4299]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["AtomQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AtomQ"]], "InlineFormula"],
 " in a recursive procedure to tell when you have reached the bottom of the \
tree corresponding to an expression. "
}], "Notes",
 CellID->7730],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AtomQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AtomQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for symbols, numbers, strings and other raw objects, such as sparse \
arrays. "
}], "Notes",
 CellID->4075],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AtomQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AtomQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for any object whose subparts cannot be accessed using functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8803]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118641467],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->187339180],

Cell["Test if an expression cannot be subdivided:", "ExampleText",
 CellID->144208119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"x", "+", 
   RowBox[{"22", "/", "7"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18103997],

Cell[BoxData[
 RowBox[{
  FractionBox["22", "7"], "+", "x"}]], "Output",
 ImageSize->{42, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485864624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268252591],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->408319964]
}, Open  ]],

Cell["Since it is not an atom, its parts can be extracted:", "ExampleText",
 CellID->23445925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->120981426],

Cell[BoxData[
 FractionBox["22", "7"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->326206653]
}, Open  ]],

Cell["This is a number that is an atom:", "ExampleText",
 CellID->814545277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->614437025],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->315640759]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23713],

Cell["Strings are not subdividable:", "ExampleText",
 CellID->41448152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "\"\<This is an atom\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45961280],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210164192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274333616],

Cell["Symbols are not subdividable:", "ExampleText",
 CellID->300294551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "ThisIsAnAtom", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57449333],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105137113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495710137],

Cell["Numbers are not subdividable:", "ExampleText",
 CellID->106486724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "1.23", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303166402],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137763059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168356790],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 " numbers appear to have a compound structure:"
}], "ExampleText",
 CellID->528752783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91201356],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Rational", "[", 
    RowBox[{"22", ",", "7"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->329174309]
}, Open  ]],

Cell["As numbers, they are not subdividable:", "ExampleText",
 CellID->232439557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", 
  RowBox[{"22", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253334785],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->263103276]
}, Open  ]],

Cell[TextData[{
 "The parts can be accessed through ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11759016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"22", "/", "7"}], "]"}], ",", 
   RowBox[{"Denominator", "[", 
    RowBox[{"22", "/", "7"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->289332125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"22", ",", "7"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->847895787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146149606],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers appear to have a compound structure:"
}], "ExampleText",
 CellID->408024854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90832169],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"1", ",", "2"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->904315152]
}, Open  ]],

Cell["As numbers, they are not subdividable:", "ExampleText",
 CellID->231428832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156139700],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98935113]
}, Open  ]],

Cell[TextData[{
 "The parts can be accessed through ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Im",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Im"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->393388551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}], "]"}], ",", 
   RowBox[{"Im", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10006695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194281838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->378922110],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects are atomic raw objects:"
}], "ExampleText",
 CellID->320170032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", "i"}], ",", "3"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->727677116],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458373065]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->550185659],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->265856205]
}, Open  ]],

Cell[TextData[{
 "Commands that work with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects typically do so on the represented array:"
}], "ExampleText",
 CellID->723605137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Normal", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18976978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->173387415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7693667],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->110936445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "[", 
  RowBox[{"[", 
   RowBox[{"2", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1007162104],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->614749497]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object is designed to be sufficient to reconstruct the raw object:"
}], "ExampleText",
 CellID->123721136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->179300633],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{"Automatic", ",", 
     RowBox[{"List", "[", 
      RowBox[{"3", ",", "3"}], "]"}], ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", 
       RowBox[{"List", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "]"}], ",", 
         RowBox[{"List", "[", 
          RowBox[{
           RowBox[{"List", "[", "1", "]"}], ",", 
           RowBox[{"List", "[", "2", "]"}], ",", 
           RowBox[{"List", "[", "3", "]"}]}], "]"}]}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"1", ",", "2", ",", "3"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{543, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm=",
 CellID->882627844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  TagBox[
   StyleBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{"Automatic", ",", 
      RowBox[{"List", "[", 
       RowBox[{"3", ",", "3"}], "]"}], ",", "0", ",", 
      RowBox[{"List", "[", 
       RowBox[{"1", ",", 
        RowBox[{"List", "[", 
         RowBox[{
          RowBox[{"List", "[", 
           RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "]"}], ",", 
          RowBox[{"List", "[", 
           RowBox[{
            RowBox[{"List", "[", "1", "]"}], ",", 
            RowBox[{"List", "[", "2", "]"}], ",", 
            RowBox[{"List", "[", "3", "]"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"List", "[", 
         RowBox[{"1", ",", "2", ",", "3"}], "]"}]}], "]"}]}], "]"}],
    ShowSpecialCharacters->False,
    ShowStringCharacters->True,
    NumberMarks->True],
   FullForm]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->71415819],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->777726799]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18170],

Cell["Find the number of unsubdividable leaves in an expression:", \
"ExampleText",
 CellID->16385381],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"leaves", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], " ", ":=", " ", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "=", "0"}], ",", "cl", ",", "e"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"cl", "[", 
        RowBox[{"e_", "?", "AtomQ"}], "]"}], ":=", 
       RowBox[{"c", "++"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"cl", "[", "e_", "]"}], ":=", 
       RowBox[{"Scan", "[", 
        RowBox[{"cl", ",", "e", ",", 
         RowBox[{"Heads", "\[Rule]", 
          RowBox[{"OptionValue", "[", "Heads", "]"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"cl", "[", "expr", "]"}], ";", "\[IndentingNewLine]", "c"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "leaves", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"Heads", "\[Rule]", "True"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->47701796],

Cell["A deeply nested expression:", "ExampleText",
 CellID->36965831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Fold", "[", 
   RowBox[{"f", ",", "x", ",", 
    RowBox[{"Range", "[", "5", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30261075],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", "3"}], 
      "]"}], ",", "4"}], "]"}], ",", "5"}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->690336706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leaves", "[", "e", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->361541834],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->69677251]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->516055606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LeafCount", "[", "e", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->223920044],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->502054562]
}, Open  ]],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", only atoms with no branches are counted:"
}], "ExampleText",
 CellID->227125673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"leaves", "[", 
  RowBox[{"e", ",", 
   RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->152853652],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->116749313]
}, Open  ]],

Cell[TextData[{
 "This corresponds to the dangling leaves you see with ",
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1032529263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "e", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->293907515],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.23606797749979, 4.47213595499958}, {
    1.7888543819998317`, 3.577708763999664}, {1.3416407864998738`, 
    2.683281572999748}, {0.8944271909999159, 1.788854381999832}, {
    0.4472135954999579, 0.8944271909999162}, {0., 0.}, {0.8944271909999159, 
    0.}, {1.3416407864998738`, 0.8944271909999162}, {1.7888543819998317`, 
    1.788854381999832}, {2.23606797749979, 2.683281572999748}, {
    2.6832815729997477`, 3.577708763999664}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 11}, {2, 3}, {2, 10}, {3, 4}, {3, 9}, {4, 5}, {4, 
       8}, {5, 6}, {5, 7}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{
                 RowBox[{"f", "[", 
                   RowBox[{
                    RowBox[{"f", "[", 
                    RowBox[{
                    RowBox[{"f", "[", 
                    RowBox[{"x", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", 
                    "3"}], "]"}], ",", "4"}], "]"}], ",", "5"}], "]"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[
          $CellContext`f[
           $CellContext`f[
            $CellContext`f[
             $CellContext`f[$CellContext`x, 1], 2], 3], 4], 5]], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{
                 RowBox[{"f", "[", 
                   RowBox[{
                    RowBox[{"f", "[", 
                    RowBox[{"x", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", 
                 "3"}], "]"}], ",", "4"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[
          $CellContext`f[
           $CellContext`f[
            $CellContext`f[$CellContext`x, 1], 2], 3], 4]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{
                 RowBox[{"f", "[", 
                   RowBox[{"x", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", 
             "3"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[
          $CellContext`f[
           $CellContext`f[$CellContext`x, 1], 2], 3]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{"x", ",", "1"}], "]"}], ",", "2"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[
          $CellContext`f[$CellContext`x, 1], 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{"x", ",", "1"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[$CellContext`x, 1]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["4",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["4", HoldForm]],
       Annotation[#, 
        HoldForm[4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["5",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["5", HoldForm]],
       Annotation[#, 
        HoldForm[5], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.23606797749979, 4.47213595499958}, {
     1.7888543819998317`, 3.577708763999664}, {1.3416407864998738`, 
     2.683281572999748}, {0.8944271909999159, 1.788854381999832}, {
     0.4472135954999579, 0.8944271909999162}, {0., 0.}, {0.8944271909999159, 
     0.}, {1.3416407864998738`, 0.8944271909999162}, {1.7888543819998317`, 
     1.788854381999832}, {2.23606797749979, 2.683281572999748}, {
     2.6832815729997477`, 3.577708763999664}}]& ],
  AspectRatio->NCache[6^Rational[1, 2], 2.449489742783178],
  FrameTicks->None,
  ImageSize->{120.70297805423132`, Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{125, 278},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//TreeForm=",
 CellID->118469836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->639046],

Cell["Find the minimum and maximum \"depth\" of an expression:", "ExampleText",
 CellID->641515616],

Cell[BoxData[
 RowBox[{
  RowBox[{"depth", "[", "expr_", "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mind", "=", "Infinity"}], ",", 
      RowBox[{"maxd", "=", "0"}], ",", "burrow", ",", " ", "d"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"burrow", "[", 
       RowBox[{
        RowBox[{"e_", "?", "AtomQ"}], ",", "d_"}], "]"}], ":=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mind", "=", 
         RowBox[{"Min", "[", 
          RowBox[{"d", ",", "mind"}], "]"}]}], ";", 
        RowBox[{"maxd", "=", 
         RowBox[{"Max", "[", 
          RowBox[{"d", ",", "maxd"}], "]"}]}]}], ")"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"burrow", "[", 
       RowBox[{"e_", ",", "d_"}], "]"}], ":=", 
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"burrow", "[", 
          RowBox[{"#", ",", 
           RowBox[{"d", "+", "1"}]}], "]"}], "&"}], ",", "e"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"burrow", "[", 
      RowBox[{"expr", ",", "0"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"mind", ",", "maxd"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198185649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"depth", "[", 
  RowBox[{"1", " ", "+", " ", "x", " ", "+", " ", 
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319255733],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58853646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"depth", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->503548254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->126559041]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Depth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Depth"]], "InlineFormula"],
 " gives the maximum depth plus 1:"
}], "ExampleText",
 CellID->147517008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Depth", "[", 
  RowBox[{"1", " ", "+", " ", "x", " ", "+", " ", 
   RowBox[{"2", 
    RowBox[{"x", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->333316110],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->178631170]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24978],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"-", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 " generally maps ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " on atoms in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127519371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"1", " ", "+", " ", "x", " ", "+", " ", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77837797],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], "+", 
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"f", "[", "2", "]"}]]}]}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->704739891]
}, Open  ]],

Cell["This is equivalent to the following recursive function:", "ExampleText",
 CellID->192455249],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mapf", "[", 
    RowBox[{"e_", "?", "AtomQ"}], "]"}], ":=", 
   RowBox[{"f", "[", "e", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"mapf", "[", 
   RowBox[{"head_", "[", "args___", "]"}], "]"}], ":=", 
  RowBox[{"Apply", "[", 
   RowBox[{"head", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"mapf", "[", "arg", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"arg", ",", 
        RowBox[{"{", "args", "}"}]}], "}"}]}], "]"}]}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->242703053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"1", " ", "+", " ", "x", " ", "+", " ", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->343127822],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "1", "]"}], "+", 
  RowBox[{"f", "[", "x", "]"}], "+", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"f", "[", "2", "]"}]]}]}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2205984]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26673],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Head",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Head"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21439],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "Tutorials",
 CellID->27427],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->26194],

Cell[TextData[ButtonBox["Specifying Types of Expression in Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]], "Tutorials",
 CellID->83007426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with AtomQ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=AtomQ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->59033774],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->378989754]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AtomQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 6.1128274}", "context" -> "System`", 
    "keywords" -> {
     "atom", "atomic expressions", "atomic objects", "atomic types", 
      "base types", "elementary expression", "leaves", "subexpressions", 
      "unsubdividable expressions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AtomQ[expr] yields True if expr is an expression which cannot be divided \
into subexpressions, and yields False otherwise. ", "synonyms" -> {"atom q"}, 
    "title" -> "AtomQ", "type" -> "Symbol", "uri" -> "ref/AtomQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5866, 189, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118641467]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43924, 1623}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2630, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3253, 87, 42, 1, 70, "ObjectName",
 CellID->8507],
Cell[3298, 90, 888, 29, 70, "Usage",
 CellID->4299]
}, Open  ]],
Cell[CellGroupData[{
Cell[4223, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4701, 141, 290, 9, 70, "Notes",
 CellID->7730],
Cell[4994, 152, 362, 13, 70, "Notes",
 CellID->4075],
Cell[5359, 167, 470, 17, 70, "Notes",
 CellID->8803]
}, Closed]],
Cell[CellGroupData[{
Cell[5866, 189, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118641467],
Cell[CellGroupData[{
Cell[6251, 203, 148, 5, 70, "ExampleSection",
 CellID->187339180],
Cell[6402, 210, 86, 1, 70, "ExampleText",
 CellID->144208119],
Cell[CellGroupData[{
Cell[6513, 215, 139, 5, 28, "Input",
 CellID->18103997],
Cell[6655, 222, 202, 7, 51, "Output",
 CellID->485864624]
}, Open  ]],
Cell[CellGroupData[{
Cell[6894, 234, 101, 3, 28, "Input",
 CellID->268252591],
Cell[6998, 239, 162, 5, 36, "Output",
 CellID->408319964]
}, Open  ]],
Cell[7175, 247, 94, 1, 70, "ExampleText",
 CellID->23445925],
Cell[CellGroupData[{
Cell[7294, 252, 120, 4, 70, "Input",
 CellID->120981426],
Cell[7417, 258, 179, 6, 51, "Output",
 CellID->326206653]
}, Open  ]],
Cell[7611, 267, 76, 1, 70, "ExampleText",
 CellID->814545277],
Cell[CellGroupData[{
Cell[7712, 272, 101, 3, 70, "Input",
 CellID->614437025],
Cell[7816, 277, 161, 5, 36, "Output",
 CellID->315640759]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8026, 288, 216, 7, 70, "ExampleSection",
 CellID->23713],
Cell[8245, 297, 71, 1, 70, "ExampleText",
 CellID->41448152],
Cell[CellGroupData[{
Cell[8341, 302, 122, 3, 70, "Input",
 CellID->45961280],
Cell[8466, 307, 161, 5, 36, "Output",
 CellID->210164192]
}, Open  ]],
Cell[8642, 315, 125, 3, 70, "ExampleDelimiter",
 CellID->274333616],
Cell[8770, 320, 72, 1, 70, "ExampleText",
 CellID->300294551],
Cell[CellGroupData[{
Cell[8867, 325, 111, 3, 70, "Input",
 CellID->57449333],
Cell[8981, 330, 161, 5, 36, "Output",
 CellID->105137113]
}, Open  ]],
Cell[9157, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->495710137],
Cell[9285, 343, 72, 1, 70, "ExampleText",
 CellID->106486724],
Cell[CellGroupData[{
Cell[9382, 348, 104, 3, 70, "Input",
 CellID->303166402],
Cell[9489, 353, 161, 5, 36, "Output",
 CellID->137763059]
}, Open  ]],
Cell[9665, 361, 125, 3, 70, "ExampleDelimiter",
 CellID->168356790],
Cell[9793, 366, 222, 7, 70, "ExampleText",
 CellID->528752783],
Cell[CellGroupData[{
Cell[10040, 377, 127, 4, 70, "Input",
 CellID->91201356],
Cell[10170, 383, 352, 13, 50, "Output",
 CellID->329174309]
}, Open  ]],
Cell[10537, 399, 81, 1, 70, "ExampleText",
 CellID->232439557],
Cell[CellGroupData[{
Cell[10643, 404, 125, 4, 70, "Input",
 CellID->253334785],
Cell[10771, 410, 161, 5, 36, "Output",
 CellID->263103276]
}, Open  ]],
Cell[10947, 418, 353, 13, 70, "ExampleText",
 CellID->11759016],
Cell[CellGroupData[{
Cell[11325, 435, 243, 8, 70, "Input",
 CellID->289332125],
Cell[11571, 445, 204, 7, 36, "Output",
 CellID->847895787]
}, Open  ]],
Cell[11790, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->146149606],
Cell[11918, 460, 220, 7, 70, "ExampleText",
 CellID->408024854],
Cell[CellGroupData[{
Cell[12163, 471, 150, 5, 70, "Input",
 CellID->90832169],
Cell[12316, 478, 349, 13, 50, "Output",
 CellID->904315152]
}, Open  ]],
Cell[12680, 494, 81, 1, 70, "ExampleText",
 CellID->231428832],
Cell[CellGroupData[{
Cell[12786, 499, 148, 5, 70, "Input",
 CellID->156139700],
Cell[12937, 506, 160, 5, 36, "Output",
 CellID->98935113]
}, Open  ]],
Cell[13112, 514, 322, 13, 70, "ExampleText",
 CellID->393388551],
Cell[CellGroupData[{
Cell[13459, 531, 276, 10, 70, "Input",
 CellID->10006695],
Cell[13738, 543, 203, 7, 36, "Output",
 CellID->194281838]
}, Open  ]],
Cell[13956, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->378922110],
Cell[14084, 558, 215, 7, 70, "ExampleText",
 CellID->320170032],
Cell[CellGroupData[{
Cell[14324, 569, 244, 9, 70, "Input",
 CellID->727677116],
Cell[14571, 580, 479, 17, 36, "Output",
 CellID->458373065]
}, Open  ]],
Cell[CellGroupData[{
Cell[15087, 602, 101, 3, 70, "Input",
 CellID->550185659],
Cell[15191, 607, 161, 5, 36, "Output",
 CellID->265856205]
}, Open  ]],
Cell[15367, 615, 262, 8, 70, "ExampleText",
 CellID->723605137],
Cell[CellGroupData[{
Cell[15654, 627, 124, 4, 70, "Input",
 CellID->18976978],
Cell[15781, 633, 391, 13, 36, "Output",
 CellID->173387415]
}, Open  ]],
Cell[CellGroupData[{
Cell[16209, 651, 142, 5, 70, "Input",
 CellID->7693667],
Cell[16354, 658, 158, 5, 36, "Output",
 CellID->110936445]
}, Open  ]],
Cell[CellGroupData[{
Cell[16549, 668, 145, 5, 70, "Input",
 CellID->1007162104],
Cell[16697, 675, 158, 5, 36, "Output",
 CellID->614749497]
}, Open  ]],
Cell[16870, 683, 389, 13, 70, "ExampleText",
 CellID->123721136],
Cell[CellGroupData[{
Cell[17284, 700, 104, 3, 70, "Input",
 CellID->179300633],
Cell[17391, 705, 942, 28, 68, "Output",
 CellID->882627844]
}, Open  ]],
Cell[CellGroupData[{
Cell[18370, 738, 888, 26, 70, "Input",
 CellID->71415819],
Cell[19261, 766, 479, 17, 36, "Output",
 CellID->777726799]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19789, 789, 223, 7, 70, "ExampleSection",
 CellID->18170],
Cell[20015, 798, 102, 2, 70, "ExampleText",
 CellID->16385381],
Cell[20120, 802, 1068, 32, 70, "Input",
 CellID->47701796],
Cell[21191, 836, 69, 1, 70, "ExampleText",
 CellID->36965831],
Cell[CellGroupData[{
Cell[21285, 841, 190, 6, 70, "Input",
 CellID->30261075],
Cell[21478, 849, 456, 16, 36, "Output",
 CellID->690336706]
}, Open  ]],
Cell[CellGroupData[{
Cell[21971, 870, 102, 3, 70, "Input",
 CellID->361541834],
Cell[22076, 875, 158, 5, 36, "Output",
 CellID->69677251]
}, Open  ]],
Cell[22249, 883, 207, 8, 70, "ExampleText",
 CellID->516055606],
Cell[CellGroupData[{
Cell[22481, 895, 105, 3, 70, "Input",
 CellID->223920044],
Cell[22589, 900, 159, 5, 36, "Output",
 CellID->502054562]
}, Open  ]],
Cell[22763, 908, 339, 12, 70, "ExampleText",
 CellID->227125673],
Cell[CellGroupData[{
Cell[23127, 924, 163, 5, 70, "Input",
 CellID->152853652],
Cell[23293, 931, 158, 5, 36, "Output",
 CellID->116749313]
}, Open  ]],
Cell[23466, 939, 237, 8, 70, "ExampleText",
 CellID->1032529263],
Cell[CellGroupData[{
Cell[23728, 951, 104, 3, 70, "Input",
 CellID->293907515],
Cell[23835, 956, 9391, 267, 70, "Output",
 CellID->118469836]
}, Open  ]],
Cell[33241, 1226, 122, 3, 70, "ExampleDelimiter",
 CellID->639046],
Cell[33366, 1231, 99, 1, 70, "ExampleText",
 CellID->641515616],
Cell[33468, 1234, 1284, 39, 70, "Input",
 CellID->198185649],
Cell[CellGroupData[{
Cell[34777, 1277, 198, 6, 70, "Input",
 CellID->319255733],
Cell[34978, 1285, 202, 7, 36, "Output",
 CellID->58853646]
}, Open  ]],
Cell[CellGroupData[{
Cell[35217, 1297, 250, 9, 70, "Input",
 CellID->503548254],
Cell[35470, 1308, 203, 7, 36, "Output",
 CellID->126559041]
}, Open  ]],
Cell[35688, 1318, 203, 7, 70, "ExampleText",
 CellID->147517008],
Cell[CellGroupData[{
Cell[35916, 1329, 198, 6, 70, "Input",
 CellID->333316110],
Cell[36117, 1337, 158, 5, 36, "Output",
 CellID->178631170]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36324, 1348, 233, 7, 70, "ExampleSection",
 CellID->24978],
Cell[36560, 1357, 480, 19, 70, "ExampleText",
 CellID->127519371],
Cell[CellGroupData[{
Cell[37065, 1380, 275, 9, 70, "Input",
 CellID->77837797],
Cell[37343, 1391, 384, 13, 36, "Output",
 CellID->704739891]
}, Open  ]],
Cell[37742, 1407, 98, 1, 70, "ExampleText",
 CellID->192455249],
Cell[37843, 1410, 553, 18, 70, "Input",
 CellID->242703053],
Cell[CellGroupData[{
Cell[38421, 1432, 276, 9, 70, "Input",
 CellID->343127822],
Cell[38700, 1443, 382, 13, 36, "Output",
 CellID->2205984]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39143, 1463, 311, 9, 70, "SeeAlsoSection",
 CellID->26673],
Cell[39457, 1474, 929, 35, 70, "SeeAlso",
 CellID->27048]
}, Open  ]],
Cell[CellGroupData[{
Cell[40423, 1514, 314, 9, 70, "TutorialsSection",
 CellID->21439],
Cell[40740, 1525, 162, 3, 70, "Tutorials",
 CellID->27427],
Cell[40905, 1530, 170, 3, 70, "Tutorials",
 CellID->26194],
Cell[41078, 1535, 196, 4, 70, "Tutorials",
 CellID->83007426]
}, Open  ]],
Cell[CellGroupData[{
Cell[41311, 1544, 305, 8, 70, "RelatedLinksSection"],
Cell[41619, 1554, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42011, 1571, 299, 8, 70, "MoreAboutSection"],
Cell[42313, 1581, 168, 3, 70, "MoreAbout",
 CellID->59033774],
Cell[42484, 1586, 149, 3, 70, "MoreAbout",
 CellID->378989754]
}, Open  ]],
Cell[42648, 1592, 50, 0, 70, "History"],
Cell[42701, 1594, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

