(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34143,       1243]
NotebookOptionsPosition[     27422,       1011]
NotebookOutlinePosition[     28822,       1050]
CellTagsIndexPosition[     28736,       1045]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flat and Orderless Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FlatAndOrderlessFunctions"], "Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Flat and Orderless Functions\"\>", 
       2->"\<\"Attributes\"\>", 
       3->"\<\"Patterns and Transformation Rules\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetAttributes" :> 
          Documentation`HelpLookup["paclet:ref/SetAttributes"], 
          "ClearAttributes" :> 
          Documentation`HelpLookup["paclet:ref/ClearAttributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetAttributes\"\>", 
       2->"\<\"ClearAttributes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Symbol Handling\"\>", 
       3->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Attributes", "ObjectName",
 CellID->10344],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Attributes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Attributes"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of attributes for a symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29863]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The attributes of a symbol can be set by assigning a value to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". If a single attribute is assigned, it need not be in a list. "
}], "Notes",
 CellID->13749],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Attributes", "[", 
    StyleBox["s", "TI"], "]"}], "=", 
   RowBox[{"{", "}"}]}]], "InlineFormula"],
 " clears all attributes of a symbol. "
}], "Notes",
 CellID->29276],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of the attributes for each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10597],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", "\"\<\!\(\*
StyleBox[\"str\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives a list of the attributes for all symbols which match the string \
pattern ",
 Cell[BoxData[
  StyleBox["str", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14334],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   RowBox[{
    ButtonBox["HoldPattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldPattern"], "[", 
    StyleBox["s", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is treated as equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16647],

Cell["\<\
Attributes for functions must be set before any definitions that involve the \
functions are given. \
\>", "Notes",
 CellID->22426],

Cell[TextData[{
 "The complete list of possible attributes for a symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is: "
}], "Notes",
 CellID->20043],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Constant",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Constant"], Cell[TextData[{
     "all derivatives of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are zero "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Flat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flat"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is associative "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAll"], Cell[TextData[{
     "all the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are not evaluated"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HoldAllComplete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldAllComplete"], Cell[TextData[{
     "the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are completely shielded from evaluation "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldFirst"], Cell[TextData[{
     "the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not evaluated "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["HoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldRest"], Cell[TextData[{
     "all but the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are not evaluated "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Listable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Listable"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over lists "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Locked",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Locked"], Cell[TextData[{
     "attributes of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be changed "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NHoldAll",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldAll"], Cell[TextData[{
     "the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are not affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NHoldFirst",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldFirst"], Cell[TextData[{
     "the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is not affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NHoldRest",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NHoldRest"], Cell[TextData[{
     "all but the first argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are not affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumericFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumericFunction"], Cell[TextData[{
     "the value of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is assumed to be a number when its arguments are numbers "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OneIdentity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/OneIdentity"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["a", "TI"], "]"}], "]"}]], "InlineFormula"],
     ", etc. are equivalent to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " in pattern matching "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Orderless",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Orderless"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is commutative "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Protected",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Protected"], Cell[TextData[{
     "values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be changed "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReadProtected",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ReadProtected"], Cell[TextData[{
     "values of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " cannot be read "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SequenceHold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SequenceHold"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Sequence",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
     " objects in the arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are not flattened out "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Stub",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Stub"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Needs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Needs"]], "InlineFormula"],
     " is automatically called if the symbol is ever input "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Temporary",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Temporary"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is a local variable, removed when no longer used "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True}}}},
 CellID->3244]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220214593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->155918205],

Cell["Attributes for an existing symbol: ", "ExampleText",
 CellID->444668977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19078851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268901847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->248359209],

Cell["Set attributes for a new symbol: ", "ExampleText",
 CellID->271253813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"Listable", ",", "Protected"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143106605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72303781]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425086092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433419946]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16030],

Cell["Attributes of a symbol:", "ExampleText",
 CellID->564243848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4721982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
   "Orderless", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38554593]
}, Open  ]],

Cell["Attributes of several symbols in a list:", "ExampleText",
 CellID->39984788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"Plus", ",", "Minus"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17118798],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
     "Orderless", ",", "Protected"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219036896]
}, Open  ]],

Cell["The symbol can be given as a string:", "ExampleText",
 CellID->208084330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\"\<Set\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->287730586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected", ",", "SequenceHold"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->766782100]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29059],

Cell[TextData[{
 "Add a single attribute to the symbols ",
 Cell[BoxData["f"], "InlineFormula"],
 " and ",
 Cell[BoxData["g"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->185355637],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "f", "]"}], "=", "Listable"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "g", "]"}], "=", "Listable"}], ";"}]}], "Input",\

 CellLabel->"In[1]:=",
 CellID->162615976],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " adds to the already existing attributes; ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Attributes", "[", 
    StyleBox["g", "TI"], "]"}], "=", 
   RowBox[{"{", "..", "}"}]}]], "InlineFormula"],
 " resets the list:"
}], "ExampleText",
 CellID->1032991489],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "HoldAll"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "g", "]"}], "=", "HoldAll"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->673722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112979945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"HoldAll", ",", "Listable"}], "}"}], ",", 
   RowBox[{"{", "HoldAll", "}"}]}], "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->266724036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114449006],

Cell[TextData[{
 "An assignment to ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 " is associated with ",
 Cell[BoxData["f"], "InlineFormula"],
 ", not with ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->435609719],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Attributes", "[", "f", "]"}], "=", "Listable"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26068280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->89755135],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234314341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189417431],

Cell[TextData[{
 "Protecting a symbol is equivalent to setting the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->52594906],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634542146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->491598477],

Cell[BoxData[
 RowBox[{"{", "Protected", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->709341894]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unprotect", "[", "f", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->105125778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->285426974],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->579211837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435754424],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->44046302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Attributes", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281343092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Listable", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593242926]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"syms", "=", 
   RowBox[{"{", 
    RowBox[{"Plus", ",", "Times", ",", "Power"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6852680],

Cell[TextData[{
 "This gives the attributes of the symbol ",
 Cell[BoxData["syms"], "InlineFormula"],
 " itself:"
}], "ExampleText",
 CellID->662401302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "syms", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112037164],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->154241397]
}, Open  ]],

Cell[TextData[{
 "This gives the attributes of all symbols in the list ",
 Cell[BoxData["syms"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141994131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"Evaluate", "[", "syms", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->248856248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
     "Orderless", ",", "Protected"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
     "Orderless", ",", "Protected"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", 
     "Protected"}], "}"}]}], "}"}]], "Output",
 ImageSize->{480, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->138748743]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24696],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAttributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAttributes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13592],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "Tutorials",
 CellID->28761],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->17269],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->302364233],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->334766768],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->109609137],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->78363571]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Attributes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 6.5815894}", "context" -> "System`", 
    "keywords" -> {
     "associativity", "check attributes", "commutativity", 
      "evaluation control", "evaluation properties", "get attributes", 
      "pattern matching properties", "properties", "symbol properties"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Attributes[symbol] gives the list of attributes for a symbol. ", 
    "synonyms" -> {}, "title" -> "Attributes", "type" -> "Symbol", "uri" -> 
    "ref/Attributes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13769, 443, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->220214593]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28592, 1038}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2506, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3129, 86, 48, 1, 70, "ObjectName",
 CellID->10344],
Cell[3180, 89, 494, 15, 70, "Usage",
 CellID->29863]
}, Open  ]],
Cell[CellGroupData[{
Cell[3711, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4189, 126, 352, 10, 70, "Notes",
 CellID->13749],
Cell[4544, 138, 223, 8, 70, "Notes",
 CellID->29276],
Cell[4770, 148, 614, 23, 70, "Notes",
 CellID->10597],
Cell[5387, 173, 390, 13, 70, "Notes",
 CellID->14334],
Cell[5780, 188, 555, 20, 70, "Notes",
 CellID->16647],
Cell[6338, 210, 141, 4, 70, "Notes",
 CellID->22426],
Cell[6482, 216, 169, 6, 70, "Notes",
 CellID->20043],
Cell[6654, 224, 7078, 214, 70, "2ColumnTableMod",
 CellID->3244]
}, Closed]],
Cell[CellGroupData[{
Cell[13769, 443, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->220214593],
Cell[CellGroupData[{
Cell[14154, 457, 148, 5, 70, "ExampleSection",
 CellID->155918205],
Cell[14305, 464, 78, 1, 70, "ExampleText",
 CellID->444668977],
Cell[CellGroupData[{
Cell[14408, 469, 108, 3, 28, "Input",
 CellID->19078851],
Cell[14519, 474, 301, 9, 36, "Output",
 CellID->268901847]
}, Open  ]],
Cell[14835, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->248359209],
Cell[14963, 491, 76, 1, 70, "ExampleText",
 CellID->271253813],
Cell[CellGroupData[{
Cell[15064, 496, 191, 6, 70, "Input",
 CellID->143106605],
Cell[15258, 504, 218, 7, 36, "Output",
 CellID->72303781]
}, Open  ]],
Cell[CellGroupData[{
Cell[15513, 516, 106, 3, 70, "Input",
 CellID->425086092],
Cell[15622, 521, 219, 7, 36, "Output",
 CellID->433419946]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15890, 534, 216, 7, 70, "ExampleSection",
 CellID->16030],
Cell[16109, 543, 66, 1, 70, "ExampleText",
 CellID->564243848],
Cell[CellGroupData[{
Cell[16200, 548, 107, 3, 70, "Input",
 CellID->4721982],
Cell[16310, 553, 300, 9, 36, "Output",
 CellID->38554593]
}, Open  ]],
Cell[16625, 565, 82, 1, 70, "ExampleText",
 CellID->39984788],
Cell[CellGroupData[{
Cell[16732, 570, 159, 5, 70, "Input",
 CellID->17118798],
Cell[16894, 577, 445, 14, 54, "Output",
 CellID->219036896]
}, Open  ]],
Cell[17354, 594, 79, 1, 70, "ExampleText",
 CellID->208084330],
Cell[CellGroupData[{
Cell[17458, 599, 116, 3, 70, "Input",
 CellID->287730586],
Cell[17577, 604, 244, 8, 36, "Output",
 CellID->766782100]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17870, 618, 233, 7, 70, "ExampleSection",
 CellID->29059],
Cell[18106, 627, 189, 7, 70, "ExampleText",
 CellID->185355637],
Cell[18298, 636, 275, 10, 70, "Input",
 CellID->162615976],
Cell[18576, 648, 397, 13, 70, "ExampleText",
 CellID->1032991489],
Cell[18976, 663, 268, 8, 70, "Input",
 CellID->673722],
Cell[CellGroupData[{
Cell[19269, 675, 153, 5, 70, "Input",
 CellID->112979945],
Cell[19425, 682, 296, 10, 36, "Output",
 CellID->266724036]
}, Open  ]],
Cell[19736, 695, 125, 3, 70, "ExampleDelimiter",
 CellID->114449006],
Cell[19864, 700, 406, 15, 70, "ExampleText",
 CellID->435609719],
Cell[20273, 717, 154, 5, 70, "Input",
 CellID->26068280],
Cell[CellGroupData[{
Cell[20452, 726, 105, 3, 70, "Input",
 CellID->89755135],
Cell[20560, 731, 519, 17, 36, "Output",
 CellID->234314341]
}, Open  ]],
Cell[21094, 751, 125, 3, 70, "ExampleDelimiter",
 CellID->189417431],
Cell[21222, 756, 243, 8, 70, "ExampleText",
 CellID->52594906],
Cell[21468, 766, 121, 4, 70, "Input",
 CellID->634542146],
Cell[CellGroupData[{
Cell[21614, 774, 106, 3, 70, "Input",
 CellID->491598477],
Cell[21723, 779, 188, 6, 36, "Output",
 CellID->709341894]
}, Open  ]],
Cell[21926, 788, 123, 4, 70, "Input",
 CellID->105125778],
Cell[CellGroupData[{
Cell[22074, 796, 106, 3, 70, "Input",
 CellID->285426974],
Cell[22183, 801, 175, 6, 36, "Output",
 CellID->579211837]
}, Open  ]],
Cell[22373, 810, 125, 3, 70, "ExampleDelimiter",
 CellID->435754424],
Cell[22501, 815, 322, 12, 70, "ExampleText",
 CellID->44046302],
Cell[CellGroupData[{
Cell[22848, 831, 115, 3, 70, "Input",
 CellID->281343092],
Cell[22966, 836, 235, 7, 36, "Output",
 CellID->593242926]
}, Open  ]],
Cell[23216, 846, 181, 6, 70, "Input",
 CellID->6852680],
Cell[23400, 854, 152, 5, 70, "ExampleText",
 CellID->662401302],
Cell[CellGroupData[{
Cell[23577, 863, 109, 3, 70, "Input",
 CellID->112037164],
Cell[23689, 868, 175, 6, 36, "Output",
 CellID->154241397]
}, Open  ]],
Cell[23879, 877, 158, 5, 70, "ExampleText",
 CellID->141994131],
Cell[CellGroupData[{
Cell[24062, 886, 144, 4, 70, "Input",
 CellID->248856248],
Cell[24209, 892, 633, 19, 71, "Output",
 CellID->138748743]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24903, 918, 311, 9, 70, "SeeAlsoSection",
 CellID->24696],
Cell[25217, 929, 475, 17, 70, "SeeAlso",
 CellID->19481]
}, Open  ]],
Cell[CellGroupData[{
Cell[25729, 951, 314, 9, 70, "TutorialsSection",
 CellID->13592],
Cell[26046, 962, 164, 3, 70, "Tutorials",
 CellID->28761],
Cell[26213, 967, 131, 3, 70, "Tutorials",
 CellID->17269],
Cell[26347, 972, 178, 3, 70, "Tutorials",
 CellID->244552785]
}, Open  ]],
Cell[CellGroupData[{
Cell[26562, 980, 319, 9, 70, "MoreAboutSection",
 CellID->302364233],
Cell[26884, 991, 132, 3, 70, "MoreAbout",
 CellID->334766768],
Cell[27019, 996, 141, 3, 70, "MoreAbout",
 CellID->109609137],
Cell[27163, 1001, 164, 3, 70, "MoreAbout",
 CellID->78363571]
}, Open  ]],
Cell[27342, 1007, 50, 0, 70, "History"],
Cell[27395, 1009, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

