(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16474,        483]
NotebookOptionsPosition[     13249,        380]
NotebookOutlinePosition[     14898,        427]
CellTagsIndexPosition[     14780,        421]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FontSlant" :> Documentation`HelpLookup["paclet:ref/FontSlant"],
           "SingleLetterItalics" :> 
          Documentation`HelpLookup["paclet:ref/SingleLetterItalics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FontSlant\"\>", 
       2->"\<\"SingleLetterItalics\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AutoItalicWords", "ObjectName",
 CellID->8835],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AutoItalicWords",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which gives a list of words which should automatically be put in \
italics when they are entered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["AutoItalicWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFormula"],
 " include ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"Mathematica\",
FontSlant->\"Plain\"]\)\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"MathLink\",
FontSlant->\"Plain\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AutoItalicWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFormula"],
 " affects only ordinary text strings, not elements of more general \
expressions. "
}], "Notes",
 CellID->25589]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->301774083],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55787350],

Cell[TextData[{
 "Create a cell with an ",
 Cell[BoxData[
  ButtonBox["AutoItalicWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->211460894],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"TextCell", "[", 
     RowBox[{"\"\< \>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"AutoItalicWords", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<banana\>\"", ",", "\"\<cherry\>\""}], "}"}]}]}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747264102],

Cell["\<\
As soon as you type a space or a punctuation mark after \"cherry\", it is \
italicized:\
\>", "ExampleText",
 CellID->1085542],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TVGUYxmn63vQv9H/0qZevOTV9qWZSnESrcZqavjXTBye1oppMBTWl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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->88961208],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPlFcUhml63/gX+j961cOtpk1v2iZVTEVt05g2vWvSC1O11drUE6hV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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->654262371]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32189],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FontSlant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FontSlant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingleLetterItalics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingleLetterItalics"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7629],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->332215097],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->651875687]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AutoItalicWords - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 8.2378818}", "context" -> "System`", 
    "keywords" -> {
     "auto-italic words", "automatic italic", "italicization", 
      "special words"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AutoItalicWords is an option for Cell which gives a list of words which \
should automatically be put in italics when they are entered. ", 
    "synonyms" -> {"auto italic words"}, "title" -> "AutoItalicWords", "type" -> 
    "Symbol", "uri" -> "ref/AutoItalicWords"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4672, 154, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->301774083]},
 "Notebook Image"->{
  Cell[5959, 204, 2584, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->88961208],
  Cell[8546, 251, 2605, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->654262371]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14410, 407},
 {"Notebook Image", 14551, 411}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2096, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2719, 79, 52, 1, 70, "ObjectName",
 CellID->8835],
Cell[2774, 82, 649, 19, 70, "Usage",
 CellID->24987]
}, Open  ]],
Cell[CellGroupData[{
Cell[3460, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3938, 123, 432, 16, 70, "Notes",
 CellID->20570],
Cell[4373, 141, 262, 8, 70, "Notes",
 CellID->25589]
}, Closed]],
Cell[CellGroupData[{
Cell[4672, 154, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->301774083],
Cell[CellGroupData[{
Cell[5057, 168, 147, 5, 70, "ExampleSection",
 CellID->55787350],
Cell[5207, 175, 227, 8, 70, "ExampleText",
 CellID->211460894],
Cell[5437, 185, 380, 11, 70, "Input",
 CellID->747264102],
Cell[5820, 198, 136, 4, 70, "ExampleText",
 CellID->1085542],
Cell[5959, 204, 2584, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->88961208],
Cell[8546, 251, 2605, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->654262371]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11200, 302, 311, 9, 70, "SeeAlsoSection",
 CellID->32189],
Cell[11514, 313, 475, 17, 70, "SeeAlso",
 CellID->13163]
}, Open  ]],
Cell[CellGroupData[{
Cell[12026, 335, 313, 9, 70, "TutorialsSection",
 CellID->7629],
Cell[12342, 346, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[12566, 355, 299, 8, 70, "MoreAboutSection"],
Cell[12868, 365, 171, 3, 70, "MoreAbout",
 CellID->332215097],
Cell[13042, 370, 135, 3, 70, "MoreAbout",
 CellID->651875687]
}, Open  ]],
Cell[13192, 376, 27, 0, 70, "History"],
Cell[13222, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

