(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35037,        868]
NotebookOptionsPosition[     29963,        701]
NotebookOutlinePosition[     32154,        763]
CellTagsIndexPosition[     32036,        757]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Visible" :> Documentation`HelpLookup["paclet:ref/Visible"], 
          "ShowSelection" :> 
          Documentation`HelpLookup["paclet:ref/ShowSelection"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Visible\"\>", 
       2->"\<\"ShowSelection\"\>", 
       3->"\<\"NotebookWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AutoScroll", "ObjectName",
 CellID->11787],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AutoScroll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AutoScroll"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["SelectionMove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
     " and related functions that specifies whether a notebook should \
automatically be scrolled to display the current selection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->439738945],

Cell["Create a notebook with many cells:", "ExampleText",
 CellID->311013355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273168499],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVFUcx3Ganjf9C/0r/XiqU9OTaqbESbSapqnpQTPN9MBJ+2E1mQpi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   "], {{0, 0}, {458, 130}}, {0, 255}],
  ImageSize->{458 0.75, 130 0.75},
  PlotRange->{{0, 458}, {0, 130}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->299206971]
}, Open  ]],

Cell["\<\
Move the selection and allow automatic scrolling to the new selection:\
\>", "ExampleText",
 CellID->677638334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17546017],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/HtdCZP2ulkJn9BJn9Fn7bNs1YnTZ6knWnAVCTtZBw7eZCZ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   "], {{0, 0}, {458, 133}}, {0, 255}],
  ImageSize->{458 0.75, 133 0.75},
  PlotRange->{{0, 458}, {0, 133}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->228895528]
}, Open  ]],

Cell["Move the selection further without automatic scrolling:", "ExampleText",
 CellID->502240655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "5", ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->474079634],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtvFOcdB2BXva/yFfpVergNapWbtlIDqBzSKopS9aJSpV5EJWlDU5UA
5hBwEhdIICQEUwiBmpPB+AA2YA62sU1qG1RzCtAYQYFOZz27s7O7hhjvvBTa
59Ev1vufeWfiq5+sFfb77fmv/HD+NxsaGpbE/3V9o6GhsF648LciIhIi9+4/
EBGRHJO264eb94qISC6patf/+o/QIiL/A5m2XSMAHmnVuvZXf93y/efXJFn8
ytbs3YWlz1q1K0COtCtACNoVIATtChCCdgUIQbsChKBdAULQrgAhaFeAWfvV
b3akv03wgx+9m72lXQFyERdsdtSuALmov10bSgJ/pwDPkjrbNVuqChYgpV0B
QtCuACH43BUgBD+7AuSo/E9e52hXgJwNjVz1yQBAvuJqTX6CzV702wQA9Uiq
9Z9f3dWuAHlJqzXym7AAOclWa6RdAXLixG2AJ0+7AoSgXQFC0K4AIWhXgBC0
K0AI2hUgBO0KEIJ2BZg1J24DhOY3YQFCyKVd/XFXgCraFSCEvD4ZULAAWdoV
IATtChBCjv9mQMECOHEbIJz6T9xuqBT+WwZ42jlxGyB3TtwGyJ0TtwFy58Rt
gBCcuA3w5GlXgBC0K0AI2hUgBO0KEIJ2BQhBuwKEoF0BQtCuALPmxG2A0Pwm
LEAI9berP+4KUKv+v5497Rrg/5x2BQhBuwKEkOO5WuG/WYBnRo4/uwKQ14nb
kYIFqFH/idsJHw4ApJy4DZA7J24D5M6J2wC5c+I2QAhO3AZ48rQrQAjaFSAE
7QoQgnYFCEG7AoSgXQFC0K4AIWhXgFlz4jZAaH4TFiAEJ24DhODUQoAQcvxk
QLsCpLQrQAg+dwUIIZd2Dfw9AjwznLgNEE4uJ243ZAT+fgGeAU7cBsidE7cB
cufEbYDcOXEbIAQnbgM8edoVIATtChCCdgUIQbsChKBdAULQrgAhaFeAELQr
wKw5cRsgNL8JCxBCXu3qT7wCZDm1ECCEOtu1oUb4bxngGfCIdv3Fy0uHh77Y
vqPjzaUbRESkztz71732jnOv/nLZwpffits1zsDAiIiI1Jlsuw70j0XRgwcP
7ouISD3594P72XY9e2b03r37k7fvxLk9leJ6Mv56Nx0nJ4sb4ovp5nSdzW2j
0Wh8SsfH7rTV6zavf+E7m+Z8d+Oc79Umvh7fjfckD965c3dy8m7arqdOXrh5
a/LqtZtXr92Y+nqztL5Rvb6e3ZDuTy/eqrxrNBqNT9U4m05reeH5+8tXRO81
R01N0+S95vhuvCd58Nr1wiNpu/b2Dl36x7XR8SujYxPfeu65bEbHJ0bHLxfX
Y9n15TiZbVdKi8vpOhnL1zP7p91cfvPU5uRusqh+qvKu0Wg0zmgslNjE1MXk
ykTpeinFWxOFp0pvOL9oXrRrZ7Rty0Oza2e8J3l27OKVsfGrabt2HxscunBp
4PxYUl/xIklpHC9fHyzvKS1GpzYX9wxWvGQ0O1a9vOpuPFZuKNzNbn70XaPR
aPzasbQYL18crBwL69HMnsIbBhfOi1q2Rx99UPxHV/EiSTq2bI/3TD0yPjg0
fn74UtquHZ39fWcunOwbThosXpzoG86O6WK6iyPTXj9R+ZITlS+vvXuicp3c
zW5+9F2j0Wic4Xiycl2TkexT8aK6XWNbM+tSuyZPnTo9fPrs39N2jRfdPf1d
x88lDdZ5rL+ju7/zWHksLc5l18XF8f7O7nPlsTt96lxXvD8zVn0CULs5WXdU
7uwo/E8r7qZvjhdGo9E487HrWH+cztLXzsL1/sL1qcZLNqedlr5hcOHcqGVb
tGVjIVU2vRttbIo+2Ry3a2fyzuP9PSeG0nY90n7mcHtfW3tf0mDxou1I36H2
U8XxSMX1qouHpi62HUk3nypfb+/LjumDhx6yubg+cip9Ntk8k7tGo9E4g7F4
JV6XrxSvF5N2WvqGgZ+9WOjV5nei5rXR+5nfzGpqjNaviN55Oy7YgQUvlh45
1dHVv//gyaRdD7ef2XegN07SYK0HC+t9B3uSMb2eJru5dKWnalE1th7oba18
pLXwkp7pXt6TbE7upuOj7xqNRuMMxuKV1uL1imT2V7yh0K4b1kdrlkWrl1X/
7Lr8rejtP0br18Ttmr7ncPvpv+7qSNq17cjp3Xs6P9/blTRYvEiSjLv3dn9e
SNfne7ridWHc053ZPHWrcL1ramf61PRj1ebsmL6w9m7avQ971mg0Gr923F2+
Pk2nJXdrO21gwdyoac39Py9NO/Xun8rr2394I1q1cnDB3Klnu3bv6Tpw6MSH
W/YV2/Xw6R272nd+1pE0WLxIUjVWpfLu0XTMXD9aO2ZSPVa98LHuGo1G42OO
j87R9Gvhc9dVK2+98XpSp1/9/vVbU0nGL5csiVauiPekz7bu71nXtKPUrme2
bT+6fUdHiCStmO9OEZEnluHF86LGxquvvfblkt/VJr4erWocXjQ32fxpS8ee
v/UuW76l2K5tZ7d+dPiTj9tFRKQqPS/9OFq7KloVp3GaNDZGa9cd+/lPk80f
b23/bFfPm0s3JO164EBf8/utmzbsFxGRqqxet7l3wU9GXpo/tGhebUYWz+tZ
NC/ek2ze+Jd9n27r0K4iIvlGu4qIhIh2FREJkap2PdTWt6G59YNN+0VEpJ5s
2rivZXu5XcfGrw+PXB4emRARkTpz8eKNtF1FRCTfxO36H0B8SOo=
   "], {{0, 0}, {458, 133}}, {0, 255}],
  ImageSize->{458 0.75, 133 0.75},
  PlotRange->{{0, 458}, {0, 133}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->116430672]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20066],

Cell["Create a notebook window with many cells:", "ExampleText",
 CellID->829122302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414131879],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtvFdcZBmBXva/yF/pXergFtcpNW6kBVAxpFUWpelGpUi+iQtrQVCWA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   "], {{0, 0}, {458, 134}}, {0, 255}],
  ImageSize->{458 0.75, 134 0.75},
  PlotRange->{{0, 458}, {0, 134}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->58773988]
}, Open  ]],

Cell["Find and select the number 12 without scrolling:", "ExampleText",
 CellID->99038393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookFind", "[", 
   RowBox[{"nb", ",", "\"\<12\>\"", ",", 
    RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356698429],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtvFdcZBmBXva/yF/pXergFtcpNW6kBVAxpFUWpelGpUi+iQtrQVCWA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   "], {{0, 0}, {458, 134}}, {0, 255}],
  ImageSize->{458 0.75, 134 0.75},
  PlotRange->{{0, 458}, {0, 134}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->65543836]
}, Open  ]],

Cell["Read what is currently selected:", "ExampleText",
 CellID->200985734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookRead", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->32920195],

Cell[BoxData["\<\"12\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->468402517]
}, Open  ]],

Cell["Make content changes without scrolling:", "ExampleText",
 CellID->5600520],

Cell[BoxData[
 RowBox[{"NotebookApply", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"SqrtBox", "[", "\"\<\[SelectionPlaceholder]\>\"", "]"}], ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->93675271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\</2\>\"", ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->129989150],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VlvFecdB2BXva/yFfpVutwGtcpNW6kBVJa0iqJUvahUqRdRSZrQVCWA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   "], {{0, 0}, {458, 137}}, {0, 255}],
  ImageSize->{458 0.75, 137 0.75},
  PlotRange->{{0, 458}, {0, 137}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->611223106]
}, Open  ]],

Cell["Select the current cell's contents with automatic scrolling:", \
"ExampleText",
 CellID->345865536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->145625632],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9PVNkdx3GaPuFRw59g/wMf8rg/Eh6p2+yTbZMumIpsm42x6QOSJo3Z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   "], {{0, 0}, {458, 137}}, {0, 255}],
  ImageSize->{458 0.75, 137 0.75},
  PlotRange->{{0, 458}, {0, 137}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->323990838]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3815],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Visible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Visible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowSelection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21002]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->244699095],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->200855991]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AutoScroll - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 16.1912104}", "context" -> "System`", 
    "keywords" -> {
     "automatic scrolling", "fixed scroll position", "invisible selection", 
      "scroll", "scroll to cursor"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AutoScroll is an option to SelectionMove and related functions that \
specifies whether a notebook should automatically be scrolled to display the \
current selection.", "synonyms" -> {"auto scroll"}, "title" -> "AutoScroll", 
    "type" -> "Symbol", "uri" -> "ref/AutoScroll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2833, 90, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Notebook Image"->{
  Cell[3654, 124, 2987, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->299206971],
  Cell[6963, 192, 3174, 55, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->228895528],
  Cell[10490, 262, 2970, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->116430672],
  Cell[14028, 341, 3022, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->58773988],
  Cell[17397, 409, 3022, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->65543836],
  Cell[21383, 502, 3052, 53, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->611223106],
  Cell[24739, 570, 3536, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->323990838]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31156, 728},
 {"Notebook Image", 31288, 732}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1439, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2062, 63, 48, 1, 70, "ObjectName",
 CellID->11787],
Cell[2113, 66, 683, 19, 70, "Usage",
 CellID->21984]
}, Open  ]],
Cell[CellGroupData[{
Cell[2833, 90, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3210, 104, 148, 5, 70, "ExampleSection",
 CellID->439738945],
Cell[3361, 111, 77, 1, 70, "ExampleText",
 CellID->311013355],
Cell[CellGroupData[{
Cell[3463, 116, 188, 6, 70, "Input",
 CellID->273168499],
Cell[3654, 124, 2987, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->299206971]
}, Open  ]],
Cell[6656, 179, 121, 3, 70, "ExampleText",
 CellID->677638334],
Cell[CellGroupData[{
Cell[6802, 186, 158, 4, 70, "Input",
 CellID->17546017],
Cell[6963, 192, 3174, 55, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->228895528]
}, Open  ]],
Cell[10152, 250, 98, 1, 70, "ExampleText",
 CellID->502240655],
Cell[CellGroupData[{
Cell[10275, 255, 212, 5, 70, "Input",
 CellID->474079634],
Cell[10490, 262, 2970, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->116430672]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13509, 319, 216, 7, 70, "ExampleSection",
 CellID->20066],
Cell[13728, 328, 84, 1, 70, "ExampleText",
 CellID->829122302],
Cell[CellGroupData[{
Cell[13837, 333, 188, 6, 70, "Input",
 CellID->414131879],
Cell[14028, 341, 3022, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->58773988]
}, Open  ]],
Cell[17065, 396, 90, 1, 70, "ExampleText",
 CellID->99038393],
Cell[CellGroupData[{
Cell[17180, 401, 214, 6, 70, "Input",
 CellID->356698429],
Cell[17397, 409, 3022, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->65543836]
}, Open  ]],
Cell[20434, 464, 75, 1, 70, "ExampleText",
 CellID->200985734],
Cell[CellGroupData[{
Cell[20534, 469, 108, 3, 70, "Input",
 CellID->32920195],
Cell[20645, 474, 167, 5, 36, "Output",
 CellID->468402517]
}, Open  ]],
Cell[20827, 482, 80, 1, 70, "ExampleText",
 CellID->5600520],
Cell[20910, 485, 250, 6, 70, "Input",
 CellID->93675271],
Cell[CellGroupData[{
Cell[21185, 495, 195, 5, 70, "Input",
 CellID->129989150],
Cell[21383, 502, 3052, 53, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->611223106]
}, Open  ]],
Cell[24450, 558, 105, 2, 70, "ExampleText",
 CellID->345865536],
Cell[CellGroupData[{
Cell[24580, 564, 156, 4, 70, "Input",
 CellID->145625632],
Cell[24739, 570, 3536, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->323990838]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28336, 638, 310, 9, 70, "SeeAlsoSection",
 CellID->3815],
Cell[28649, 649, 714, 26, 70, "SeeAlso",
 CellID->21002]
}, Open  ]],
Cell[CellGroupData[{
Cell[29400, 680, 319, 9, 70, "MoreAboutSection",
 CellID->244699095],
Cell[29722, 691, 169, 3, 70, "MoreAbout",
 CellID->200855991]
}, Open  ]],
Cell[29906, 697, 27, 0, 70, "History"],
Cell[29936, 699, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

