(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    264162,       5443]
NotebookOptionsPosition[    252525,       5039]
NotebookOutlinePosition[    253895,       5078]
CellTagsIndexPosition[    253808,       5073]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AxesLabel" :> Documentation`HelpLookup["paclet:ref/AxesLabel"],
           "Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], "Frame" :> 
          Documentation`HelpLookup["paclet:ref/Frame"], "GridLines" :> 
          Documentation`HelpLookup["paclet:ref/GridLines"], "Boxed" :> 
          Documentation`HelpLookup["paclet:ref/Boxed"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AxesLabel\"\>", 2->"\<\"Ticks\"\>", 
       3->"\<\"Frame\"\>", 4->"\<\"GridLines\"\>", 
       5->"\<\"Boxed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Axes", "ObjectName",
 CellID->13139],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Axes",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Axes"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies \
whether axes should be drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Axes", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " draws all axes. "
}], "Notes",
 CellID->24370],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Axes", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " draws no axes. "
}], "Notes",
 CellID->6676],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Axes", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"], ",", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], "}"}]}]], "InlineFormula"],
 " draws a ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " axis but no ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " axis in two dimensions. "
}], "Notes",
 CellID->10143],

Cell[TextData[{
 "In two dimensions, axes are drawn to cross at the position specified by the \
option ",
 Cell[BoxData[
  ButtonBox["AxesOrigin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesOrigin"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->180501439]
}], "Notes",
 CellID->30556],

Cell[TextData[{
 "In three dimensions, axes are drawn on the edges of the bounding box \
specified by the option ",
 Cell[BoxData[
  ButtonBox["AxesEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->913199839]
}], "Notes",
 CellID->17973]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343555024],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->8383472],

Cell["Draw all the axes:", "ExampleText",
 CellID->458529206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136523611],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->571018372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->299586600],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->319664002,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164152086],

Cell[TextData[{
 StyleBox["Draw the ",
  Deletable->True],
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  Deletable->True],
 "axis but no ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->147860468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->507563028],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->36552272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->406724686],

Cell[TextData[{
 "Draw the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis only:"
}], "ExampleText",
 CellID->395805850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "True"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->59629905],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylfQd8VNe557yRaO5OHDt26kvebvbtLuCWxKkvLy+b5lwwxjbGlW56B0mA
BOpd07t6o3dsugFjOpjei0Ag1HuX5v/b/b7v3JHkQc5z3vI7jObeuXPvOf//
18+5d7TxC6dOnjV+4bSJ43/4p/nj506dNnHBD/84Zz7tCvkng8Gwjf7HfdtA
7/8vvZP/KwAYQiZPngz5Z3iBXwyR9DqAdr4oW0vp1UhbIfpftTecXvmLA/qc
gV71MyzWjx3MW6E956c3z8vnC/RvP/QVn8/Tv/8obw3o+Vy/xnA5ZrZ+jif6
PWaYHDNDP+abf+eYafq1ng7Cwhi0/b/k6Cn6Gb8d9GlI0Pb/lKMn6ef+ztc6
erx+7u8FfRoatP2vcvSH+rl/+LWOfk8/94+CPh0QtP0/5Oh39HP/t6BPBwZt
/0SOHqOf+ydf6+g39KP/Z9Cng4K2/7sc/brek6FBnw4O2paeGkbq5x7+tY7W
0Eei+3w6JGj7X+Tov+rnfjno04eCtn8sR/9ZP/dP+S+p2n/+jf/T5/wh8g37
uFv0hyX10aBvCIuG/9Cv0fONQfYJt+0TSuzjS2zyVSg5D/72P8u3fxd8vSGO
SXfsE+/IOW7b+Bwl1q/sgTrHb4LPEeqccs8x+S69s08qNdLZDANtcjJrn5M9
FnQukWDDr4JH87hz6n3nR2XUHFOo3VMntU2kdsc24Y51/G06qWVcid7Dx4PO
+gM56yt6D1/qQdU1vYL+OKeVG4x0AcMAx0f3HXIJ++R7tkl3DUa6giHEyhe4
Yxl322DkS/Q5bzAS6jo/69N74XuQe2aVa0YlN/2CFXJNx9RywyN0TTu1KWX0
AV3TOrHUOqHUQtcbf5suaR53O2DX+lzn+3Kdl4LHM9g9u9o9q9pFV5MLOmdU
8tWmVxod0yoMg+hydmofUbtP+62T7lkn0hgtE0oNoXRBMzW52pNBV/ueXO0F
fVQ9V3vIM7fOM6eW3rln17hmUaMrVztnVjlnVNFOo2N6peFhx7RK+7QK+1Ru
to/K+bKTy+jKlol36brm8aUGI12379WCuVNXH6aP9cXA1Z/wzm/wzKvnNrfO
PbeOdrlm17qkJ05qM6sd1KQnjulV9ulVRvu0SqNtaoUh1Cr9sEwus0y8ZzRP
uEv/S+WKSk0MwWh/V3rwv4PHH+pd2ORd0OihNr/B6J5Xbwhxz63nfsypI3ma
XWsYQh1xzKxxSF9YZGdU22dwX2zTq0i2plVSX6ZWSF/umyeVhZon3uvbj2Ae
xHOIDf8SEo/5wlp8i1u8i5ppw7OwiTrknt/ontfgoiYdcs6pd86pc86uMzpm
1RrtM2sMoYHeVNtmVBu5OwOs06qs01heLFPKzZPvG0KpR/95b36CXrupUMmM
aPeFt/nCW31hrUbv4hbDAOlWs3tBE3XLNb/RYKSOGUKccxtU10hSqGf2WbVk
5WbWcu9YemwzagyDqHPW6dKmMZGWjyrMU8oNIebJ9GKaXK46Z/hmUM+ek579
Sx+cRAsHZi3rzFzaSe98S9p9Ee3e8DajN6zVMNBDnSQhpi4ubHYtaHLNbzI6
5zUaHnbO4x465jY45tTbZ1Ors8+qs82qtc1koefXECv1MpT6Z6EmXTSap1SE
mKZUSH/4bz/9e1b698/BPA7OiurOiuzOjOzKXKZ62eGNaPeEtxs9YW2GAe7F
re5FrSxe3MtmkjDqp4P6OUB10j6HGvfTEGKbVWfgU1pn1lIzGK0zaknDZ9RY
plNjQRxg+qgywO1X9/AHfbgNlcOyV/izlnPLjKJ+dvuWddFe75JOT0QH9dMd
Rq3NvbjNtVj1s8W5gFqzY34TcTyvyTDQTt0lwZvbSJ21UZtdb7TOqhdptM6s
o2aZWRdi4d6ap7MYmKZWUwsJ+Ex6z2+fCuqtxF+ipbzzhR4LkROPnDhkx9KH
hqwV/kzutt9HLbLbu6zbu5Q774nodId3uMPbXWHtRtfiNsNAFspFrc6FLY4F
LY75zfb5zUY79Z37aJvbaJvDzWid3UC8z6q3zGL9ssysN1LPjeYZdXxYiGla
jUSy9JffPoiv6vFzffAVCf12bhJyE5GTgOx4ZMchS7qeGQ3fcu63l1qkn7ru
WdrNAruk0xXR4QrvoK47qS1ucy5qY1lY2Gq0L2ghtOc32+Zxk643Wec2Ga3U
dwv33TKLZZu6b55Zr/Clzpum18pb+sv9MppmKDnSe/2Y3s/gaPgZGc0zwfg/
nJvC3c9JQk4ishOQFY+sOGTGIjOG93tX+A1GGpJhiCfS71nmdy/jQbmWdLki
Op3hHc4wau0kN4vblbVa2GZf2Gpb0Gq0zW8xWmlQzJRVhmWZQ63RMrtRpHQg
Dcmk2ox6HoISHqOJhixSNLtBQgpdqoNHI7G/RIkhPZ/2YsDjH6DjMDww0ifz
MpCXjtw05KQgJ1nkLRFZMuTMOPhi4dOHDM9yvyfK746ksbuX+Q2hLqHSGdHl
DO80OsI6DIPtizvsNGYa8aI228I2GrF1PjUec4v0xDK3WVgSazO7Ud7Q2Hh4
RtNM4pbeTZZ/ptlNRtOcJsMA85wm81xuusoHmDSEbLiLlVdh+EochgSNX7KV
0N5tg56/GHoizKGBcz+Vb+XP80zIzUBuOnLSkJ2CbIEnMxGZCciMh0/g8Qo8
nhVwL/e7o/yuSL/Rxeg4l/pZoCO6HOFdRntYp6BjW9zBAr2ondCxLqDWapnf
Kkya5zYbaahGGrdCZXaTvOVuhRIQJkHOPK8lxEx4mklH+vg3icQH04Y2dBK9
rivByivIOQXnp+gHnW/J4I26DIV8LZQU4gom6PmVyM/TBXbk25AneOWakJOB
nHRkpyErBVmCly8RvgR44+GNgzcWnhh4onm/azlcUX4n4eUkvB526Hh12yO6
7OFdtrBO22JqHdZFDJl1Ybt00jCQADPPa1VYmOe2EC4kJ82k+HObTXNbGBPW
f8NA07xW07wW1QgywXhhW4iZ7EyIZXGbLk2C3JAe5NbfZuSyjsG+B6kbYOjB
pxe9p/4B2erP4vw4gNyzhR4UuJDvRJ4deTbkWsTkmJCdgex0ZKUhMwWZyfAl
if7Fw0MtDp5YuGPgDkDojPI7WCMdhOEgwtC+hGG0R3TbwrusYV3WxZ3SLcMg
y8J2y4J284I283xqOoYE27xWEaSHGFH+nA8xcWs1L6TGVtm8uMNoCaP/4R2E
XUSHZUknf2VIH6lT8BVdQtYJ2PciZUMfC/Rfw+5Llgu9NQLB7ptFWSj08aEF
buS7kOdErh25NuRYkG0WI5aOTEIwFb4U+JLhFRAJQbJdcZSku2PhioFLUHQu
hyMKgqKdUAyxL/XbBEWFHElLp2VRp0FJUMcAgkg+mBz4ZyS4KCxZ2G4WUTUv
6uQ3RvOidrJei9vNYR3mcP66JaKLMpYlXYYBlqVd1mXd1shua5SfkRwUGK+O
5EC5bpgZ8xL6lcFv/oMyGFwd+U5Ao39YlIeiHBRmoyAT+T7ke8TsuZDrQI4d
2TZkW5AlgGamw5cGXyq8KfAmw5MEd6LIYBxcsXBSi4EzGo4VvNMeBXuk37bM
LwgOtkb4LeHdljBqXebF1AihTsGTgAph5Ba3BzQ3xLSow2gi7EJMizvoSIV7
WJfhcXNYJwHJLaKLYSREl3ZblvktkX7C0bocthWwiTUWoxnQPwJUaUDiakT6
EGb2z43DtHBMnN0vtt9AwIfytwfqf0ODsA5G9JmAZD5XXMinLcxDQQ7ys5Gf
iTwvcgXXHCdyHMi2I8uKTAsyzfBliG6nwZMKTwo8yXAnwSW4OuMYVKODBhTi
iIZ9BQKe0zDQusxvXeq3LPFbIlhOzeF+ozm8m6QtrJuQYrDIgRB0otmPmMM7
CDqT2hvWZeL3HfzKYPJOc0R3iHlJt+FRM+EpkDK2USBIrdGwxcIWB3sC7IkB
bEP6YGt4pMd6mnfyAVGZWJjunxvfPW2Jf8JsvD+5+ytR/paOWnDN7JsBNL9f
vApFxSgsQmGBaHsu8nOQl4XcTOR4keNBtku03YFMOzKt8FngNcErsLrT4E6F
OwWuZMbUKbrkiIMjFvYYDFCSGQmWIAJzKSxLYF4CwcMfQphQJB/e3UfLSYkH
mZd0mpd2mpd08ecEZ3i3iSAMMZFqhxKEZrEb5qXEB4E42EJnj4JlBawilgSj
LR6OFGI1lUTIkSaUCqQB8QphJB/mM+9AwhpEZfEhs2L8U5d0TZjb9d6k7rEf
dBh65LEXsSd78AxIqQwv6KgnAnr/vZXr+YCi1ShchcJiFBQivwD5eeLEc5Cb
hRwfsr3IciNTAPbZ4bPBa4XXAo8JbgHYlQpXCpzJcCbBkQhHgjI/hgG2aFhX
iPgsV/EZAUFoLIOZ2lJujNISv2mJn0RO/PXDpiXdJoVpRJeJ8F3aZY7sNEd2
mSW2piMpQlzSbTRRmPAogUtn4nMQussZYAtdMRZWklMx9PZk2FP13gxyO2Ho
CfECsqqQZtmNW41lPiyQEU1ajHGzu96b0jHm/Y633m554/X6frCWGovIrDHI
V8lY9W/w3+AK6SMBuf7Oyo0o3oCidWIrVqNgJfKLkVeI3HzkCgs52cjOQpYP
mV5kuuFzwusQF2aDxwK3GW4TXBlwigyRSKmxDiT5oj8MRQzrLsFiJHTEoRBQ
BBe3SObBaFomOY/hSXNkt2mZn4A1SQjGRCzrZuSXd5lX0KufvsP76ZhI+T6R
ajSvUKO2xDDqlKcT+SG2RNiSe+3UQy4H3B643fB44cmGN083IIqC0AADS32Y
l45pKzApjA8YO7HrzXfbR7/V8vqo+lF/q/5KBgY+4O8GfXmPzsLDQd8O5EeG
51ZuQ/EWFG1G4UYUrkfBOhSsEQe4ErlFyClAdj6yc5GVIw4wE5k++Dzw0nic
8AgdbitcFrjMcJpUnWEgiZ4tCYQEIWIVNkIsZMcJJ4pdo2GWkIPQIxRNUYoB
NkWmSL8pym9azq8k6RSMPEZ7MxjzbvPybnN0tyWm2xzj17+/nE9E56RTW+Lo
7PGQmOExpxVOu+imk6H3ZMGTA28+fEXIXA0l/UoNRP4fpTeROVhowfRoTFiM
D+fyMW+81zbqzZbXRzeNGlk38i+VotJBGD7eG2AoGyZyrw7rQ4hiZEBfRnhv
cO05NMDIt1fuxMrtKP5Y9GILCjYhfwPy1iFvLfKEmpyVyC5CdgGy8pCZC1+2
ONBMeEnCaLwukLa77Mq6h9rTYU+DTXJ5o5UswwBrIiwJ0uJ1y0TCO4BQNFOL
4SbSqzKI5ciI4sZECDchJkr8H6M3tMmcEVvRfnOs3xLfbYmjN0JNLJ+brkDX
E4l42pYGuwkOizQbnNRBCQfcRE4uvAXwrUTmWmRtRPZW5GzvZUmpCb0OEWxH
arWvabUj/lSh/fvd/jh57O9pxQMcyNG9c5YBz/Dsyr1YuRvFO1G0A0WfoFCo
yN+MvI3I3YCcdchZg+zVyF4pfrcQmdT/PHhzRNYyZVxeuNxwuXSb9JjdDJsJ
tgzY0mFNgzVVTFQyLNSSYBFGzOKcQ81xUPUO4uEJUzQyVkhbHmAh2m+K8Zti
5TXanyExER1mIvLi/UZLIkXvloSARIpEPUUX5UtLY1NJBDh0Dlw+uLPhyRcH
twqZ65C1CdkfI2cncvci7zM96+0lQ7YHT4vFhHC8M9P/5sSutz5oef1tTi61
V/Van/a7Ut0ZBFutr+InUJMJjjEfDWjF08X7UCypfOEuFOxE/nbkf4y8bcjb
IipBgrMeWWtZwzNXsTSxShSy2nvy4M6BK0vpw+N2B+w22CRXt5lhNcGaAWs6
LGmwCCvmFFhSYE6GOYltPAV8IaaEQNSn6mqkNwNNccJGLLjFIIO8TLruD2iT
2CALFuennEh9LHrBXxR5+FeLuGgSA6uixgy7BXYrd432O11wernL7lx4CuAt
hk8UP2uLULMLOfuQexB5R5B/EvlngrVlmuj12JkYM7nz9ffaR7zRMmIEl9G0
P1Zov79HEevv7gbi+gdmw76CmwcyUdp8pJebgyj+DEX7UbgPBXtFWXYhbwdy
P0HONuRsRfZmZG8SB7IevrXwroZ3JTzF8Eii4M7T63AOH+xeIcYFmxM2O6w2
WK2wSlnAYobFBEsGzOkwp8GcqqyXKYUZSoYpCT35U0YC+Xb2xhnCXAbnvBmc
86bHIj2Gm85dHPgw8RvfY8pTdDng13RdRGwWpsVuh8MJh1gtVzaoz54ieFfx
cDI3IIvGuEMiR8XMUeSfQv5Z5F/UGX+EujU90T9Bwos3J3W/9UHr6DFNI0bW
a39h7679vkz7zZ0Q7Zc3SXt+flXXnmDr9gj6Rl2Bv8E1ziEBO/atoiMoOiw5
w2fIP4D8fcj7FHl7kLuLd2ZvR9bHyNyKzC3wbYJvo+jMOnjWwL0KrmK9599y
5MCeBVsmbF7YZPxWF6xOWByw2GC2wiz0mM0wm2DOgCkdpjSYhJ6MFDUAY0aS
Ol16AlQLySDNGqT44T3xSI8D0xOnX/eHRCgdQ82UpOslUW4WYkgISBSskpST
lNidsLvh8MKZBVcu3GLNmJv1yNwk3GxHDg17vwQ2x4Sbcwqjb+ZeQ/Y1eK/C
fq5hvgPTkrga8e48/+jJzNTot5tHjaob8Zdq7f+Q7vAcr/br29or17WfXiE9
evlyX9yDbZ1i66k+bKm6TeExFJDmHkbe5ywrbL32IftTZO9B9m5k7USWSJJv
G7xb4NkMz0a4N8C1TsflaXsh7PmwSSBpy4Y1C1YfLF5YPLC4BSknzA6Y7TBZ
YbIgQ2AymZBBLQMZ6eJfQtIpB0unSDUkXeBNIzoGpCeqGCo0XekNwZ9ETNFR
z5GaKUpZ+wR+iwVWO+spuxQvHJlwZgv8BfCshFcsFslV5jZWDRpczn7kHgLD
/4XCfkD+FeReZfh91/yOMxXKt3xjWrJ/QpT/nflMxIj3OTl/bVTDa69Wa38o
1/79nvbbUmGhRHvlGhGgvXhBe/6c4cH8+eEe9CWnDKD/jYKTuhDkHkXuYeQc
QvZBZB0Q4/QpfHvh2w3vLnh3wCNhiHsrXFuU73jYtgq2YtiKYC2ANR9WocCS
DXMWzD6YvWzz3aoeaHLC5ECGHRk2pFuQLhwY001SwzOEpKUhTdmv0DTiIS1Z
aXCaUCGBivBC28yLkV6MTNN3lUpxS0VGmqiauHTiwmJlOkgv7R44suCUgN2V
D1ch3MWs1N4N8G1mOlj3e+g4rs+u5l9A3mXkXUfOdWRe87svtg0Sf8le5W2e
z9BerR1BSvC7e2SotF/yUg3tVze1V65qL13UXjivDT/Lhwdn2w/1+JTgPFE8
iUH3+A/kK4Yn804j7wvknkTOCWQfE+93GJmH4DsI32fw7odnn9CzG65dcO2A
c7uuH8/aN8K2Hta1sK6BVQJ+SzHMhTAXwJQHcy5MAo0pCxk+ZHiR7ka6C+ki
x+kOpNuRZkOaBWlm3XalEcQDUtORmoZUIS01RfmM0FS2aqnJSJOMj16NzOB3
6Q2xmi4xN7GUISyZzGwozTZY7AEb6obNB0c2nMRSkWS2a+Ah97heiPqYbQER
xV7lcIClc+xSSG/yriH3BrKutsv+hxwHkbgFEbmYZcYE8W5vz+4aNb5Le7uD
dV2kV/tNqfaLW9rPbmgvX2P2XrmivUTKc1Ybdlob+oWhHx1S7A14ICIIfWCP
MPtNw5fj6+zTyDqFrJPIPA7fMXiPwCveyH0QrgNw7ee5GedeOPbozH3bug3W
LbBsFs42wLwO5jUwr4ZpFUwS0WUUIiMf6blIz0G6pD3pmUjzIc2DNDdSXUgV
Fo2pdj2rTDHxdkoGuKWrFCA0hZ1SilDGr/zWSCSKdtFfYpd0kzQ0nZoEAWw4
zWxNyaZanGxlreIH2SdmwZELZwH7SzexJzUl72b4FHt7Vf7zAw4FLjBv+deR
dwM5N5B5lYtYq6+IPO3AsiLMdWBiPN6T8tsbkzqJOu31Zk2r10s2vxa798ot
Yk8bfonfk+K9RIp3mmuQp/rqVXBkN+Rr8xgcSwivPC/iOQH3cbiPwXUEzsNw
fg6HuC77fn1tgUUKn+aPYd4G01aYNsMkEV/GeqSvRfpqpK9C+kqkF4umFCAt
D6m5SCUSjalZSp1SfUjxIMWNZCeSHSoLSrYqjzQwOR3JadxoIykVSSkITdZL
PsnJ4EZ2lJn9dorS0TTWV1JdsrlkfTPID0rMb7KD/aOL3aWV+BMpsufCkQ9n
EVyr4F4LzwZ2vTKu75GNzD2GPInmCi5KMHUd+Tf8Odf8Wdc4RNhTgY23kHsa
ZklPFngxJRkfLOseO6/r9Slct9NebyEWtT9V60T+okT7+U19XkUbelZ7/ow2
/Avm8GRf5IN1cfA/xGHPjAcLvP0obIdhPQTr57qmPWPaC9NuZOxCxg6ki59L
24a0LUjbjLRNSNuINBHk1DVIWYWUlUgpRkoRUiRcT85Dcg6SmLmkTCUtSV4k
eVR3+YLGRDadieKZEkmDjPRiTCTqQhOFm8QUUAtNCvAnvKakEX908FOp8r1U
ExvgdCvSbeJGpdREtJkpyvFx0GPL4RjILjVxJ8WrazlKEs/5EJnLHs5I7Qqu
oOAacSah1g2/WMyn91fh47soOs9ynCA55DQT3qe4Y2HXmGkdoz4QlzeiQftz
jfb7clI+nTxSvpevUvSnvXBRxTBkOrVhJ4k85s9geGDF6T/GW/D8irD1nfT9
SNuHNMmsUncjdSdSdiBlO5I/RrK486TNSNqIpA1IXo/kdUhaKztXIbEYiYVI
LECihMSJuUjMQUKW8ryiX3z+0HgH4m3cuBfxFM2HxpsRb0J8htqTjtCENNU3
YpGJDBE2k0Qbk8W6hrCpfSJV4pw0K7tQcqQZTmS4QDGRSeylhULVHA6bbAWw
F8OxSo3vUR/FvBT/HkDO50wc7aKktoCIu8zEFdxg7shqqmrGtw/XY3cF1lOY
chJpu7B0JeaI1X8nrHvMzM43xreNfKtVG8ErlbT/qNB+c1d7pUT72U2OY14k
2i5pL13ioHHoGYk+tKEn/p7WDfqHtU6+8QzDcgDJ+5D0KZL2InE3EiXnStiO
hE+Q8DEStiJ+C+LFRMZvQPw6xK9F/BrES8ASvxJxRcooqpnpWA9iJbaPdSLW
gVg7Ym2IFYMWa4Ex1gxjHOEfEieMMW8h/BKakIEEcWH0GsqqGJIkR6QQyUZ+
eSTFilRqwn2agyOhDDcyPDD5OKylnUSXaNVjbtES4ipzD7L2I/tzDqHzTugF
COaK9Ow6Cm6pWCU05zIv1Dnb2HWiEY/IGbS/Shnit2XaL24TJdpPrxtULXzY
OQritRfPsTPjWsYJfWbt+H/OTSC2/KoYM5AlGx6J24PYXYjdiZgdiPmE+xyz
DTFbEb0Z0ZsQvRHR6zFYrHJ0PlbkIjpHXc4wONqHaC+iPYh2I1rmgqIdiLbD
GG2DMcaqJCHGghgzmIlYk9oTR0okzRjP3CRILMKvRnoxJvK+JNGXFDtHIfQy
kAKXVLF0HJR6OUAV7J+0r4JjLVyUCW6GextnJz4JDCl3yTmC3BMcK1NsWHAJ
hbIcqPCW0nHDwLzrbMno34XGtjNNOFyr0HjIdwLJOxBeiGlWvLcCYxZwojXq
vdYRo5q1V+vlmIe1X97Rfso0aS9fIeWRAtM5behpokl7/gvdgR3XZ+2PyWmD
OJJIROYye+aCWKijdiDqE0R9jKhtiNqqUB8UuQqRxYgsQmQhIsWsR+ZCrWR5
NDILUVJYjfIiyoMoN6JcWE5NNH+5HSuokQwbV+hsRFsRTYSQbhAphtAYwT7O
AmohbOFC4gX5BHZU/BKaaEWyBOYpLoRQJCm4P23Og4VyPUr6RC8d6+HcxARQ
bkhJIiWMWZ9JfH68N0IovIzC6yi6JTSU6LpwoYIXzF9uaL7QpPzPYx+XovA8
H7NiPeb6MC4Rb4d3vzmT5/pHvtms/a1B+2O19u/l2q/uKr60l4iCS+R2dJUh
tzP0FGkKEyA8HAvpB381GfGNPjohxNJfGd8jEVL0iViP8HWIWIOI1YhYJXuK
EVGEJYVYUqAi6SFLsrE0C0szsdTHc4V0zDIPlrmwjBgwRjrVCqIoO7jZEGXF
cguWi4FiSoxEhjHarOIRslhkuuJsiONP4q2qb/SX3xoTrJDM8+m0TGRIpkaJ
G6VvlMRZV8K2BnYhgfa7P4FnJ6fsmQeQfQg5RzldZFN0gUkouqaqY8zEs0U3
eKnPxftX6PVaff2VJpb24w3YV4UNFIuLLtCeKWaMjcJb87pGT25/bazUtP9c
q/2+Qvv1Pe3nkvK+dE2vgGvDz4nYnxUymAalAhQQHO1rf4Iz4gE9HuWrZk4D
KwukHsuzUws2YcFGLNiAheuxUKZLF67GImorsagYiyRz1OdrwnIRJpiFZyE8
E+E+GCO8kNn0JW4scWGJE0scWOrAMjEzy+yItCGScY+0KM0h0lZIM67gPStE
T8jIkcMRPQ1NdCLJhWSPyrRIK59Ky+KELCMPJgkQLas59batA2Xiji1wyfSJ
dw98+5B1ENnKXp1G/nkUXtL1o/gWVt5GMbUSv7D/vbNiq7aXcohmO4jlshLt
gwS8FYbXp/tHvc+Gign4QxX7k1duay/e4M0XL7OWPH9euFHO5KQwdIx5UV7l
KGnLkeCK6QP3XfXj4wc9sEfmAFnyZ6/DnLWYswZzVmOOqNDcYswr0j3I47Q9
Pxfzc7AgBwuzsUg86yIfFnmxyIPFboSJdw93IZx4MYaTJQqNEHO01I6l5GWW
WsEkGgbE2Nn7xzm4yXgoeDMMSHAi0cUxeLJP7eXE6sk0SpTzQUmzyp6ta2Hb
APtmOLfBtR2e3fBJypJ1GDmBcFnFWANWivladRurbvtXlXSpitSAmw11hsC/
gzVq4OQl/sZ+Xvu3+9ovSrWXbmovXNOev8x7XuDSnDbstCEwh6SYOCociB8g
HgLtsEHFzjwdN+Dv4R9UP3o8kOVMW4XpKzGDWrGO+kMz8zErD7Op5fLX52Rh
TibmZmKeD/N9eIJxWmJRZ1xmES0IIcNl+P5yKWiTPyEfH+OQgMuJOHE18S4k
uJHoQZIPlP0kS/qYmgfKaDOKuVBhXgOr5E72rXB+AvdOePbCtx+ZnyP7qD4/
XnwVK2+C0b2D1aVYfUfff+3+xZtVN2/V8W0HN1q6LzQr7Riy9iqcRxCzGbN9
eD+Rk85RMzpHvtemjWxWfA3RfnqLcX/hijacHQRXdV6gaOoLTkpUHECQK/SV
HhDmoQx6UK4vleEgbQj5B9h4InBUz5qhx8RaznFxkD7XwW2eyPUCOxaSXC9k
f71I/MRiC8LIS4TT/wizEq6lFiyzciNuouSg5TZ29eRPSOqfjqFgWMKxOA/i
vUggSrI4N00RutOKkLEKpjWwrId1I2xbYJdkyb0b3n1cRCS5V9JOZqiIKLmB
Vbew+jadfU2pGtm6kqaAVTY8da2MLX5JLU8832puud7KJztah0/uSJ3jU3ad
UziY6n5zLrsX7Y1W7dUGNlC/KVM8as8TP5d0ioZ9ocIo3XMEsskjwtIRRRFr
ymH6f+hLPNERwRWer+KoPz8jbkXn2vB92vd+Dj7IxofZGJeF8WKZJvgw0YtJ
XkwWK/+RGx+5MNWFaU5MFzWY6cAsO2bZMNuGOULMXCvmWTCfmhkLVLV7Ef35
wWIzwqTRnggLSN+I1KUBUg0qeKNo2smRdYwbsXJFylEpU03KRXI+Vx3SpGpk
WgvzBlg3M4+OT+DcGZhbyznJ/qTgPIouYeU1PpRYJA7X3uX360u7NpbUCtM/
uXrvDP25Xc3R2J3GupIWjrfONvk/r8aWEi5V0ua8XExI9b+7pPuNafwpKZn2
pxrt38rJvIlq8eycNvyCNvy8NuysMHlSG35SG3Y8oFmHDXqI1i+LSi0e8Dl/
j8H+V4+EBCzlU7TjHS+ovevBe4Lfh2586MI4F8YLXRMdmGTHZDum2PCRpHoU
9U+3YAbp2kwydj+mPbPNmGPGXBPmmZlDVlEzFppBLDKHYhIjrFhiY3/EcYOo
MQXgK1xY4ebsKMaLuEy9zpCUj+QCrhmlruTiH+0k6riyK9W8wdnHkCv+pvAi
iq+w6q0uwdo7uj5uKm3bfLte+Zmzd3T/8dCdSo7e7jVU3G1mz3+lxX+6Cfuk
EuA4pN/T+PaC7tcndGqjecm29h+VFD1rL9/Snr+mKFN3c2rDzwgvrHba8GOK
JnZPh2UtSIA2YYz+f/73ormQL0VzPblmnzVBQ3SmhO+XaMebLrzlxBgn3hYH
/q4d7zvwvh0fCJ7jrJhgxUQrJolyTLHgIzOmmoUsIWWmGbNMmG3CHBMrHO0h
nVtg4fVLiyxYrGiyB4I8Jyg0jxIbudyDFZTE+hDjQ1w2EmTyKrmIq3upq5SI
GR6174BzD9z74D2IrCPIPiHx9DldsVbdxJrbWFeq55ahm+51bbnLZexdt26q
lR83y87cKb8gb+WlpLX7Sqv/RJ0eV4SESSAyNlLX3MGsVj+/rb1wnUyjrlbD
zlBiE7CGx8Rh6eGBQXmswBLGw4avz9CTfRmarJ5GINHLj94VxN4340Mzxpsx
QUCeZMJkE6aYMNWEabJnhgkzTTrycx+EXXSKwuullBC5EUnNw3kq7VzhQ3Sm
ymieSF/PdXHLNtik5OraC/d+eD9H1lGwCZOaV9FlrLqONbew7o4+S7q5DFvK
urfdY6D33C7Ro6nLd0/fuMcBrr5dXl+mS5yKCHbcRe4ZJO3EHDJnUvMZORHa
W+3kktQ3HtFevEmaoT0vcwnDKVo4I4XMEwLuMYV6j9Wi9zrihw2DAgwckvY5
H2N4MPfsRb6/KOOJwP6R6RhJ/TO+lqG2R6fjTXr7Iz7lUzG5iMtHYhGSJaZO
W4/0DcjYxJMMth0yc2QweD6D7xDfsJLTx6KsvqHfu73xHhjA+9h2nwOnnXdr
9965oxB4+hJhePcUG5UKdu3ldXfotay5/m4r10wo/KLXrSXwHkP0Vkz34m2Z
WdPe7+SJmT/XaL+5r+fmwy+TU1dToOzUGcZjPd4gpBdDBqwXQ4WbAlCX8OB1
mlIT7pm97u9utsC6Qf6S3FvyPT5nMlSj9yNS8FoKXk/BaKm9v5WKMSkYm4p3
ZfPDNIxLw/hUTEzDZKkUTs3AtAxMz8CMDJZ3g7j2+VxbWUAv310kZiqCkkkv
1wEiM3mB9nKJGqJzEJuP+EIkrkTyGqRKGJy+mcmybod9N5z74JZ6SdZx5ErB
qugi37+mqk0bxFszU+X4pJzf7yljJ3Ck9OqZ0vOX7p5RrD13r5xxrqjhfK+q
saKyhUu9t9pwrhHkxum94zCWr8d0B95cBm0as679tUH7faX2ijjwF8WBD7ug
vLeR2GLjf1T3A3rlMZixQ2Srhh7uQ9ohUZBj/ci9sdeTf707fPSI4NsI3FGQ
oDwF/R2RyG2k3HUwOglvJmFMEsYKr++n4IMUfJiik0d7PkrH1HRMS2fyZgaY
m2dj8oi6ReJuIjxY4sOyLERlY7lUCqLzEFuI+GIkrua5g1SpCJm2wbIdtgBl
vsMgygziCvR8Ys1NrL+DjXfJNglhFSqHeeLo3Rtn7l5Sluj2/bN3y1mzKqsu
V9XerKm/U93Ed1nfb+8uacf5ZuwrU5ZxoPaXGu3XZdrPSrjAwkHWeRUJsB5R
YDUs4AHE2of2MiM+oSeu4g8DueZxBfUDcdY/xk7v954NfEPrcxfK/9biMSIe
I2XB3ah4jE7AG4l4S+h6JwnvJeH9ZKaINiemYnIaFEXTxR7PsnDozPzYsUDI
CfMgwss1tmXZiMrFcnHRscWIX4XEtUjewNNzGZLD2PfAuR+ez+E7oueOq65h
7S1suINN97D1Pj6u0L3H3oqu/eWsIUfv3Tpz74rC5+GS+xwDlZfza3U1K0Rt
AytHZWtTeTtutgZYXnlJxKgAY0gK53dqH3TpMdQv73IB/0Vx2sMoyT/FSwh6
chghjF1DD2e6NhkCjA1Qlk+K/3S4yn/+q5oUij7P5hmgkdZHQpPbLpgsiWx+
pNh5U9Y1jU3EO4lCjWjShFRMSsWUNLDpMwWosWGuHfMdWCjRU7gPS7KYl0ji
JR8xkpAkrmNSUjcjfRtM22HdrbgYnCvJSPFlrL7Oh228g833yP/oazj2VOLT
Sv+BipZD5dXH7t85XXZNrdYrKWM27itOqjiIqq+7UdfAbr2mtb2slXPK0/XY
cw+F55As0+1jYv1vzW177b1m7a/1Cv1HeX3Hi5f60HI84NIPB7z1QV1FPjcq
ug5JUK5CX9G2k/8fXARnpqI3g7VwaBHQZG0D8xMFYkaLVtr/jE5GSoCMNExJ
57hrhsTAc+xcNZjvxEI3FsvyUK5F5yIyHysKESMRZdIGPbN40iOmirwLmari
S1h9DetuYWMpH/SxOJXdVdhb5d9fxX7hSGXdifJ7uqxfL+eq1d2K84qCmooz
at6rro2jgVutOFGNPWUcVcV8rCfGI6Z2jnyrRfsjPyRAe+WWLv8qv2DsJbkw
KrQP6jrwuVipPjohBoy3BymaRCeOa8NPcenM8OCM8tdlIni+7FkEZsI0uceE
CVnKqsLvl2PEcrwWjVGyUPnNePAUpuGJlK1I/wTmXbB9Cudn8Mj6nZw+4K6/
hU2l2FrG+3dW6tb8Yvm16xVsVEoruBBbWf6FerZIYy0b96bGsoaWOmWnydKc
aRB7KlgP1F5rkYouP+CGIlPthUtG3WScVAEpR/xfhecjPds9Qal8SQpfBKdM
LvaPZqDmHphFDD5KpHg4n3C+nthpi6GEWkn0iEiMXI6RcmfK6Di8GYe3E/Cu
mJfxaZiQjknpnMlNl0RhrhvzPVjgw6JMhEkFcWk+ooqwYhVi1yJhA5JlqjVj
J6x74TgA9yFeQkWw084e2HV9316BXSTR1dhfg4O1fMTx6pZTVTVnK+9drLh5
vZIRLy0/r2cFdRWMQWMN2+3m+ltNTfwonfq2lqoOdT62ooE7t9iWyJzHCxza
BrLmo2LbdSuiDf2MDzT2snEwwEZIwMj0eu5jKr9mJs70Y2H+SZh4Rrflz/X4
21l+bZ5uxX9MFoTBjsII8cKvx+INhbQsnByfjomEdAamSoY224V5XizI5HJ7
WA4ixJ1GFSN6DeI2IHEzUsSXmnfDth+uz+E9iuxTyDvLUanC67Ft97C9HGQy
Pq3GAUH3aK3/RG37FzX156rKL1XeZstQeaW0/JxaY1dXebah8mxj9aXmmssC
MR/Q0lLb2N7OEOuSpVcDX7rIs3is58cCluBgL6Kf6XGOwvmgWIhHeyVet+gq
x+DpJ4H2jJr6eEB+FbbPBu0NRJykX7MkTJ4HbZGqpPygxzQQ0qNi8EYsxiTo
Yec4gjkDk82YKtI828MF9YXZWJyLcIXxKkSvRdxGJG1F6nZeZkQ7HQfhOcIl
NspzFZuP7BBo99XgM4H2WF33yTr2cudrqi9V80PCblVdk948Ui1y21DJctNc
w+6ttZYNTFvjPUK3qZ3rPQ8HRhPCmHJt52jA9n6mS+dn/FaP8BWiPTbjsJJu
g6rMkvEe9gUj+vyFr0TzuX7Q1Fd1zQbZCW2h7pOeJrtKYjomMYBfGiaaMMWC
aZJLzfFifhYWEXj5WCqTedHreWVI0jak7YBpD+wH1HkfW3kFa29g422QWO4Q
Z0bY0evhOv/xev+pel5tdqG2/nJNhZLeskrufXXFmV7sqi+2Vp9vqz7fXsvy
2d54t62FnZd6OiMPnucMVPB2MIBUQBI/Uy2A35dicTYKR9Unw86QPJEkDj+n
6gT9oxf8HEWRzYe0CW26eZ0BbY7Y1oVgU7uEpVHmH4dMsmCqADfbi3lZWJiD
sHxeBbR8nY73EK9aQyQ+as01bCzB1rvYfh+7K9VUKCFTxcOvruTkpJ4UVsBp
reLNjmrWoM76m52NHBE/HpCqQT3aqQ090PPK0nVAiZhSVrGFA3s1dBjJIYVg
x/XYYNh5WexyQUHzFdh8t68NfFJ7v0mb2KHDMlMwmc96yv5bNHTkCnbblHWo
lH6cSZ+ZezRWpslTdyJjD6wH4DoM3wleqUg7V1/FhpvYcgfby3RP8u2DdThS
DxKkLxrYGFxsaL9SzzN7t2rvltbcKqu+VlF9tbrqYm0V49MoCtlaxSl0R9WZ
TgGtq55z8p7VBr22bL++fUDf7kFM3z7I6CrEOBnQnj8lKnwykFEMu8jBgKxA
4R3BNT6F2vf70Ucln+OkHDxV8fh9tnIL2XkbVNyzAq/HcVpNmx+aMcGCyTZM
dWKmRHjzc7G4EEtWIWodYmVhcuouXunJ1kzcBUVCKy/z/s23dVu6r5od8ZF6
//EGfa3Hxcauqw28mqCkrry0lqVKVS90KHXhO9tWeXpgAL+BPfgRetrQffRq
DEjboz3YKX8bMF7HGLQXzuiLqIZfCOTCL16j2FQWMvWL2w/6wU333lO6teni
tZSE6HGjeN/R8Rgj4c04C88tTHFgugezpPy/uAhLV/OMfewWJMlCK8t+OA/B
d5yFr+iCfh/MzvsUiOOzGpa6ExIEnmvyX2ryX21iYS9pqC6t49ynorZEoOJJ
s8aqs82Elro/orvqrL9Gas1P9UpcQML2MVT79V2C2mO9EhlYrsTJEUOmJktl
zcALVwguHbc/VChQHshpFG7BT2vtwS1Um9SlcCMTJpb7yRHRDNjbkuGMt2Ky
E1PdmClz9YuKsETQituKpB1Il5qm60igYr7uOrbcxvZ7upY+dqgOx3WwcLEZ
V5vZ6Jc01pc28E3KFVLCrK25Ul99Sc3Zd1ac7K7gGqdfdFWeCxWokZBUfcpQ
GQNaOkA3bcMCYqXnCxR9DxOceO2kzF6STL18Q/vlbe3fmKPJ6vnA/0R/GRuF
zz/rVkwsuzxfaIw+p6NN9StwlBUzqKxhigszfJgrc7cRqxGlr+YdnHMahRdA
BmvjTWwrxa5yXrXzub6ObcjZZoGhhb9V0tRS2shLFCrq71VT6CXYD2mt5KVq
HRWc1XYpKCq/0NF4psfvMRKfPoCHrmPDDqtEogeP0zzD/uIl7WUpgBASv7it
/a5M+2OV9mqdwmPQA3j8OEhenumR2jfrtLHN+iwXCY4Chj+I5DT5tXi8JZr2
oUWthX84dhvn/6Z9PO/lkyma4otgQSlhQdlboctKyMlGnJUittySZHikvuZq
YzXT11rJJqJDgOmq/KJb3vjlVdj6rox7r7RP5f0+pUq6SeKSzVFJb0/JfvJo
5wUOKd79vET77T1ee6s1aKNbRrzbqRAJylB59bHg8i/94CL9/472dpM2rlOX
mR5QlnPh4PUEjBFvN96Oj8jwZGNBIa9goz2Mzi6Y9sNB/u6kLGoxGDbcwLY7
Oi7PHqplHTrdxCXIKzKNX9LSVdrCXqKiqbqqgbPP+robKk3SowLycSI73QKd
v/wEBC4VBaq4fA/hFRAlhddBHazhJ7RhJwI3aRge5rV8L1/Xfsaz0NofKklm
eELhna7Rcr/AZP3pMv1h9d/683EiQ281MFRqtSgJzYhYjE7CWKnoT3ZjRjbm
FSBsNSKlvJu8G+YDfCtH1imuVPFdKKq2vrccn1XjaB1Okeg08aHXWnGr1V/a
yja5vLmhqqmqtpFVvrGOF++2Vl9oU/GSODECxy8ooZxrTt/t9WQ92JAzO6DW
U7BKDT/JAScF3ENlNZ2aBPzpLe1XUqn/U43g0jFqsv+DxX5D4AEm6L3v9csa
9t/7QUfPbz7k/mvToM3Vn244krQqFe9LhWl6FuYUYNEqLN3Qi46yHt8lnVIC
eKiGvdQZAeVqK2624U4bJyvlLc1VzfU1TWx+G+pvN0uNo62G1ayz+lxf1fLf
P9oHl0EBXD4N4PKZzDXwtQaxuJCFobRbLWV76br28k29dqv9mR/zqI1tHzkR
Y+dj/Ar/PEcvOKL4DyATeM6rqsbx198I2GLBxCBFDImNB7korvmC3fS6a9h2
G7vKcKBK90bfutyKG2243cZfuN/aUdnSUtPMvWloLGuqZz/dVssUdtZc7BYD
62eBYMOL+7L67vu9npo1RGUXj4izOS66ckJy2Ava8+JlXrrBUwK/LdP+XK0y
q4kxWODC8lWBdWo9XOuDV1ryr/1Z2me/NGqysvMCwUwc3kzD+5LLTs/hRXvh
6xBNRmQ373EfQ/ZpkH1dfx0f38Ge+zhYHUCDxOCWgqKtu7Kto6aV1yU0NFU2
NXLy2lZ3vUOS1G7REH/VGX/lKQUF7stq6R88GCl/bnhcX0rNIdwZrr28cFmf
FPnVXd1YvM2LWd+YjUmxek9CV17QpVSv3wTYNxiCn83e63VGy2I+o7IYUtai
KOW1RLydgXGyamR2ARavRdQWvnfBJHfIkiteeREbb+CTwBqAkBP1bCguteg9
ebi8vbNKCqYNlJc3V7Y08nKpDjEW3TWX/NXnxCD8c69m6mU9cidfyJ4niHsO
L16S9Zy/K9derdVGN2vvd46eJQxl8L1ylBUXncOeCpyqbRbOH5AENfr/1c/o
VW6sTfIbAv9IAkan4F0rJkrMv2gNIjcjfifSKWzV1+wN/rQch2twqp59xlXx
GaXtuN+udGYgqs6gIkBuGYfjP+rVceUpA85y2PmeSv1t3v5rjTaykYzcyI/w
juQkSwqRuoPzil33hVS1JqhnDD3MBp5o3Sden+zn0gNF6XK/xXNE1I5S7K/A
Een5RQmSbrfjXgcqOlDdzt6msbW5uYVVuL3xTmcDq7C/9rJfJFZ5OJJVlPHU
6L/02A6uN51Q94xqQy9qw69qL93U1yGObdcm+McsxLRULMziy+WewnaZ2P1S
FN3L0LAghuS5pU/ymUeJmZvi1+YyUyPJ5yfjXRsmSdQctg4rPkbyXr6zjZwY
6aduOQ9U4GiNrgzXW3GnHWV6bdPweENbe3Mrz4W1N93vbORI2V93zS+mGpWn
ETBUikDla9VzMU9xxDdUJQjXtVfu8LKVV/UZl9C3F2FcLOa4ELdJZKX/cQb/
joGM8xs94+Q383icr8Xx8ocPXZgupbTILXzzkOVzjmTIJG+4zoyq+aIzjbjU
zH6IBJG2q9q76to7GtvbWlo5a+9out+lhlh7FZImQSIXlB/XbbH8hsNDMr4z
2lA+go3tr+/xkveRbMlGT9frWZtu6YCqZwL2SODz/Y1JbMsosS0iE4OJtrdJ
tTIxW4pbsTuQcQCe4/qzQ/ZLHetsI6606Ma0vL2rur2rvr1TlfXaW6o7mzgi
89ffJLp4CNXnesZi0K09r7DWlx0TPX+o4pWXYzpek4c4zLYgopCT9jVXcFDJ
xkNfspGBZ+P3RJ4h2oed2ky/FuZXkfOAvLNYdxWf3Ma++zhWo9u6J+91+Cs7
/LUd3Y0dHAm0tTZ0SDXN31jqry9BoLP8WnFSdVbssVqrpv2xRhvVMvLDrncW
ci/nZyF5OwpOY6+o/UNfQvqlIKTlKXdPar+9yQMe36XN9qu5tbEWTCCgi7FU
ahXWQ+zKadgfl3DPWTGE0cerOlHXyVdtbW9rb2vq0rt9Fw0sMqi5hOoLqtt8
+NAeSflbgza2Y+zsrjHL/DMk6Mg8pqs35zuhgSjfEPzLGoGnHFKf5/lV1epd
B6bmYdF6vh2LNkm+SYk338Dee7x5pkEEorVXex9t7uhqa2/vbOMluf7mCr8I
BequQkqZPQosFoVZC9V7pO4T+2k/PdLv5JjS6wnG+TB7JZZuYcuinpx3qBKn
63G5GSVt0hdybJ06/0P8ray6aC6XjlyjvghmkhcEfq1CPYci8JsSfbLvaSJe
bC9Ewki8tt/GZ+X4og6XmwLWrLoTdLkmEa+uNlZKvia7lZf10aknKr0SNDqp
iDyk/Z7ZZEGWx1l+QHlSMZZtRcqnrH9yhW/sv48TohMKa7pgfSf7hfaOjq72
Fr+gjaYyiGtA7RWIa3hBv7p6huUv+rv6w9of7ypQR6zgq0+kFG0d34FHFpty
sk3X9TE+cb4BN1pQ2sbXZons9Hd0dHaL7qOlWq59u++1h+rXVk+4/mV/1xYb
NL5DW6DXFp7cIWu0z9TjShNfid7XdaCFr9TV3d7ecyV+U38DMncjmhoaqML2
/KaJaN5zfP6JXSPDMEoy87lrELOTB0bJFInwPhHhK00qNCRNQzMNSEj0tzX6
+VJKdm9AwuWf6LKifhfkN0Ej+kZAdwaPWiZL48j7bULKPvhOYe0V7C7VMxoK
RkinmzqYvc721s7Whq4WfrYQGktRz4ZCPDiPSP3iy2+DrtPzCxG6Lojle2z/
PZyuw3UpI9R0MJFtnV3t7S2dbY0i+1VovAeZ5vqhfnbxm4Z/Czq7rPd7XC+o
yT8KVV6Pwwdy40vCHnhPYP1V7LmL49W4UIc7gTUog1o7uzo62rvbW4WmGjSy
usnvivDV1G8i/S7oasG/QqJr+ny8mYyJMuOacZClkOziQX1dRkhZK+sav1V+
3d/WjJY6NPHdGM/qVxNLaPh3XRaCf/0m8DxxQ8hUuRGKgke9gn2yBhfrUdqK
2g40tgdqe2jhdCRgjfj86je3/iPovMGrAnueRv74a0sDnplM8SlsuoZDFThf
j5IWlEm019bZ3dHe6RdtUk/Dmax+ychg+EPQWYPnY3vmgQeNWoEPPQiT2QSK
/3fdwYmqwMjqeUBd3R3d/naZo3hCH4lYJPklpAeeRBF0N5zCgnLwqO296A88
JyJQ1U4CjU6h5VH9zL+WM/9R5yD4jBx9ic4POFiGyw0g/dNZfUj/vsiK/KrT
A3eqBt1drHoy1oSFqzhmWSmPf6COBVYS89kERcNf+hlX8FMAVKYWthmOIzpp
A/RzSF/kV6keuAstSAp6VnzS7r/Jt17VcQg+OoDWSDlKQ3850sP6MaPlmBEI
zjMCYxwjn4/sc4VAjYo/fVc+fQ3ql+Y+lC3DP/0/o+smmw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318556658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3532064],

Cell[TextData[{
 "Specify overall axes style, including axes labels, ticks and tick labels, \
using ",
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->256827188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120129542],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59007003]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20920],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->973565391],

Cell[TextData[{
 "Determine ",
 Cell[BoxData[
  ButtonBox["AxesOrigin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesOrigin"]], "InlineFormula"],
 " automatically:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->180501439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92125971],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesOrigin->Automatic]], "Output",
 ImageSize->{104, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7106707]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440134790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylV0toFEEQ7exssu6uX1T84Cf+UBOjRtSLiDdFRURFPIiHmAjJwQ8aL3rR
i170ohdzMRcV/BwUQREUREEMiAExICqIgujBIBg8BITxVdV093TtJOvGhZ3p
mql+VfWquqZ7R1t356HDbd1d7W2NW463Hevsaj/RuPnocTyK6owxHfhvmGkw
jjHif0cc4155LeAaQSFHEg1i/pkchntYY5x6E9El72Vj6pXGNnkcyY1+OStW
xSGFVn49PPzn3t2Brs67JrdpY4+Jtm/tPXvmcf/rr2bKGP1azRoDb7+3H7xz
8cJzDDjq+qGh4SePP8IS8DE2k2rAp8gYN3r44N3RI/c/f/7JnJpIIL99+2Um
jtHflRb3/LmnYMMUWYYF2CHcCS6D5EVD6p5GaWH5+bNPp089omGZZcwHCxTt
eEaZkcwWbbB8svsB2WQb0Yf3PxALyWWnnbbRzPLg4G9g4ioMJp7TsBTYWMFv
EQTM0HAyy1DFBBoWM200sYySQOpoyFUQIYID+2+SzWLARrrabAVahposA5hJ
MU1VDHGmhMcgP4WsDKbk5SyDuL6XX2g4jWWAApqGhThrXUjaU2aq2rFrlvzM
J/fIzsv7OAxzYjVNHiwhYrHcUEOMDiH1PC0TXjnL53qwu2/vDdhNtMYrLWf/
8qUXsV8DGX7ZtaarW/tVVHIpk8ueK33Xr/WTR1GG7846ah6VX8Wr9EzrZTUv
bJXy/AbwA5aoEi2dI/IkyXUeWZwAbxR2tB/ZPQnJuH3rjTwi1FIqqohJkwJ3
M9zK1nEXKhhjrgvuCX6+t+RS9jJzClU0mCR23R8Kcba3+ThchXo1FdU87gTJ
u1wQ3ZI46YVwgoZzlRxl+rWYZahAkYbzlD+5zFmL4rAnzY/DnhV6pm00suzy
aOoybSxUNhaw7KtRZk3HdSf3DDcf30nuXiTXu6KVa7CTqKKV/bSknrqaF7Fm
vP/wpc7FLZUh9LrKHqXvuJUlSal4X01WtZRwIHn138ClXitZZWJOasx1X7Ms
qJZ0zqWGUSZJB/aalhH85JNm5ijU5Qo15sVMK5Q0c71XXzV5tIb0mpfqn63q
TbTHxSN/wW1/lbxiJwRjNHOWqndBquw+OmsVu16FI/z7DtX8X7h+fyS4fqdQ
C27kuPH7q+lxuJJXjIBn+dPfibzyR3ZEfm/VMgqexvH4eofld3gtQaZt584r
NEHROz64CEdpuDKoP+HK7yonqRhW+VrUX9aKnavvzqsCG7Kqw90x1XlrJrZo
4xyAfknDso0nyVqrY2GkE5jmt2jzDgf9iQBbmQRxDSNm9pIgbzZPZeshosdx
yLMBj7FHMmtrwEtrMG4J6xPrRrhELSAVyB1yieUOk+tqwCYFPokUpMaBgOMg
cg0yiYf1Y/Rz2z/O2xXUqz1H7OanlWdqU/cXdgdK7Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->28268093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288243120],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["AxesOrigin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesOrigin"]], "InlineFormula"],
 " explicitly:"
}], "ExampleText",
 CellID->93392161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345832742],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesOrigin->{0, -1}]], "Output",
 ImageSize->{104, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->224232822]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Pi", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->728952763],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWD1oFFEQftndyyX3l5gf/9EYRaII/jTaiJ0iYikWYnEmQlJoRGOjjTba
aKONabRRwZ9CERRBQRREQRREQVSQCBILg6BYBIT1mzfvb9/u5i7qcbf7Znfm
m3kz8+bNu531seH9B+pjI4P1vm2H64eGRwaP9G0dPYxHYYsQYgi/bfMFxjFG
8jcUx7i7135cQ7wKiKJBLD8iwHCT5FjuvQnpEllaiI3ytghXehw15C94HF10
aZ2c/PHwwcdLF1/g++rll+np3/Oa1E94ZO8c+Qayowfv7N519fix+wGwRARy
x/ZLp089goreWWC6HDXJ8fPnNGCAByWSI4KZ9+6+27vn2pXLr3r+Ersq6YmJ
7yPDtwAm2jXy+IXnmAQGXSZWNM9W5+7iVCT94f23wX03gaboJ48/MQj7R2zw
pMpaCtoxP55p+PzZZyXVmSlVkvTU1C/ogluZi6SOjt2lYUemlJxZCFTogkaO
fHj71tuzZ54YL+dInTzxAM6hYbekEQhFV40UeYW5kUoQoGGP1qm8Us3UUZQ0
ZgIu8sJcxyvkhcoMUpwPNJQZGyIVEDnjW2NZ0ZvtAklDwds3X41PTZRDR5eg
FZoR8YK2GglIVi70rGbEZakMLGblaAoXCYDkoeEiSZ8/9/TG9dcmImbFB03h
BybzOSNpuFjHBssVuaRwZ29v6OXVEi8H2nJwdeXw/cp4mCymTMOlkkZqANzE
XYWIP5RVBFB2fdLAwzbKvI7IA371LClcs7aVPmVBYjZVT7ackUHFRCSceu9F
2LfDx27XvuQk0T5sYFHFo2WVKBoaH5u7ofJkLU8zp32Tmn26pvzA87aZ7q+6
jjztuMNb/6BdFAzNJdvU9aq6V1TsRYh5oiiZuDTQVnJsZI7OpD4VM1dfKkpK
ntdAIc7Kd9fWOeouQt5/Y1Mdk7iujAh52Ru/c31Vmnm1DcTJlejwETKXErEq
TtYRy8V6eNnSQx8vSOKpurRa46l6wlyBfqpisUbTEKSdhWlb3VpSXqvLq6mX
PMXMCpp+ku4jmpHKeVJwn8BpIvg3vP/1xMmWFukrXo+8QGxkOH70fr0U5mpl
V/GAlw80u3UOp8WTnJHNB43o74ArpddMnVYhdXktpuSNTC1VWcj6eafBtoTN
iYYrJA1EWEqZ5HthrSNluVjKVutsqaLH1a/tdCpsnpTdkfo9T2RLtTlxoWGf
5xN/P3GlYAsKHHWR8+L83kd2l0o62wbu/Oz6603lmNt/CJHeBRmHe1vb1fWk
cORsIptftpNY5yBYT+choE1Es+ja5tvCe7jl604hcV1gXVxl/G7GRbK+zkFS
/Sjh6F6B58R7t63u3W6sItPVxtn9BdtQ9WbDXbbtuttnkLIdfK+mYQmZWkrY
yf0Cn6YIk3xP58ByJnaHlzNdHp0txacdu7I6dbxhEemsJCyS5y7nvFLTs4aF
FAl//2UdbAmOU0qq4uggKb8vcqQoM6EO9mFQ0jNS+WG7HivrnirZZj41YXoq
HWRVaEWuo3TxwdDJ2hlPt2yXjFmZsxRfpAsvLsQJpgEUKwklMbuzbwJfnrza
gIkshIO2bB5HmsNQYMLW5v6TIAZGm/0Zvlk5/q/EP8nzPy3pf2dEyx+KHrNy
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->29165364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59886176],

Cell["In 3D, axes are drawn on the bounding box edges:", "ExampleText",
 CellID->152787229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255148411],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->301316807,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQuUHkWVxzvzzOT9lgQicYMs6HZmIKIbBUE5EBFmQhjC5AUkwECSyWQm
k0kmyTy/LxiRhyhiDKC8E1/Lqrvurh49x3P2rEd3dV+uoqKrLj4RdQVMQgh9
dqtuVXXfunWrv/q++eZ4zIGZ79F9q+6vq6vv/d/qntbN/Vs6uzf3b71585KV
fZt7t2y9edeSy3v6xEe1k6IoOiT+f+q0SLz+P/EK/j+UJIn4Av3cKH7Wiq9q
5Dv5IoF/UY142QJbXE++qZU/6rL3UdT8J7Gd9FR61aB/tzgsVupvapHFSLIR
/18Gry93bDeS1ueR928M3G+Obhsa7+zsLGffWXhf3e0aYcO3f73efpY+9vC+
xPa4vel6/8nwueqs+Bm9waLYqH9P1a00sVuv199Og1bVt2qDc+H75cwxSfT4
PJ3xG+zUp3Z0W+fABuc7ntU5n7xG92f2OO3M132bh7yGfpP3rw+2OFf3bH7V
LJrjT8/9ucRiLXl/VnALM5gjdBqxVkfeL03wcTdn6zTd18VBe5sxSD07nWxd
T97/Gey9JPHPA6frfryO7NlA3sP30ZkOEXruztf25FkyTfyeHmR3kfgpzSoH
kHnH/lzmCEhmjfKzaZ97a/HzFxW/cHHxS+888JXLDvzjygNfffeBr19V/Maq
4r9dU/zPa4vf7ig2pFazXtD3SwK9na17U2/6v/BQc+HBluLDLcXHzysePb/4
qTcVn3pLMaRb311XfGZj8Yc3FH+8ufjszcWf3VqIzFyWx8/XUzMnzk7cc8Ic
+2jJwbhwV1y4d1nhQ82FjzQXHmopPtJSfEL1/IIyev59u+e/3FJ4rqvwfHeh
jlwBJpPen5nTe8yZO+9qzGfn7o3HhuOxYjwW4s7fgTtfrsid3/WO/b5v7MXd
Y38YGBMNyxl0CvHotdYZR68Z5qhEb+yJR/vj0X2m5+/19Pzj0PO/rmrPj+8f
lT2nV7ys9zOYMZPoa9QZiT2PRc2d8UhXPNJr/Bkpy59LQv35H9uf3zr+nBwd
eaUwEhnq2KvF4NVM4o0bVy2kR2n5hnh4Uzxyq/RwVHi4m3i4rPoe/oL1cB94
OCI9PHVgODk4HNVE7tyg/GzUc1FdSX8XaH+B1wrxYnU8dF08LJzebDu9H5w+
UNLpvxyH09t4p19GTid3DCV3DUWM52cEHuF5SRbpwRFesToevAa83mi83h6P
7nS8vntZ4QPLCvc3Fw43Fz7aUny0XK+vy/W6Z+x/hdf9nNfvAa/vHEruGYRj
TuOD0wM9n6OPNZzxF4sXbfH+q+NB5X6Hcf822/1RcP+Oarj/NHG/U7r/K8f9
Y5b7I9j95N7B5L796UWgAgYzNQMaewPTdwCTfascLDchLHsMlttzsXwasPxN
IJYNpbDsQVjGJJZXHSzJ/fs4MovS+RzP2eY95BaXihet8V7k+pBy/XpwfUs8
0m1cHxyn66286z/yuP6Cz/X3DkvX7wbXPyhdTw7t5bxfCN4v1fMheHsZeDvQ
Gu8jDq8Fh282DvcFOPwkdvht5Ti8STr8U87hl4IdTh4YiNJrNPX5dfoIwzmx
EnzeIw4ycbsd3L7BdnsA3B4bv9ur/W7fJt3+9XZwe6ft9vDISeF2kXP7Q+D2
4YHkoT2c55CHQSxptIDoXeD5bjjgyvn9rPNbPc7fs6zwwWWFDzcXHsDOL58A
5/dyzr8PnH8/dT752G7e9zP0/Cbn+uiK1rgfjjrv+zrw/RbwfYfxfcj4/j7L
9+LHyvf9v0r4XnB8H9W+3875/mHw/UHpO3fsX5OYLFL6D/n+lXDsvQiuBQQ3
IgS7EIL3lELwmWoh2BWA4AMYwYBAkDzSz1FYkFKo05lfdBVQ2JUPYr0DYi+A
KOSC+ETFIG6yQPyGBSGieQXiIIC4awiB2Jcc3itBfFSCePWxPp6Dybm4LAbn
lzIXgjOmtTXemc9qDbDaFA+LnGdbPNKjWY0FsXpzeax+AKx+Aqx+7mGVZT4s
KxEWCFYfyVglj/Vx4wYUOHV9zI2fiB4mDMAs2wZjTKHb7aAbNOiGAd1Iiq4f
0A370T0Wgu4qje4/ctBtBXQ7Cr9T6Hbb6Ao2untsdA8IdHuShwW6Xa8+0cuT
M+oPjStdgrUJVuIyO6CSrQrkuCGX451x4f3LCvctKxyaSI6/1xzHGI532Bzv
Zzhyo3Be4ChkKSM7YGFVa7yDZYnjezvXHcGSTDVZrgWW1xuWtzAsXSEDZ7wQ
5dssHwKWjwqWO189ssNhMLdCljS7BHXrahiXPa1xH8HZ5uDcaEsHGOfBicJZ
FDh/meLsDcQ5yON8XOKsFk2qUkDFaDWi2Z9Ds8OhuRvphYTmgzbNvypF818F
zfbx0SQpKEpLVIia0uQyM7jewhUa56VUsaJa9+SMX6/Nj2Y2OHln1buDcYHl
d8Th98VS/L4H/P4b+D2b8usy/IhK6VM2Un6HbX5P9vj5LSS82KrG6tZ4u81r
wMfrelvsSCWwCeF1o+F1q+T1nMuLkTy8+SDExIJXn+ZF5zGIhXWlLuPVRLZq
0Ly6ES8+EEwFgxxeSv+ugNe/VItXmj+TFPJBxUuGzoLXi0e3OTPVrJSXqV44
VUbFqUTA3M5x2oM44TqB4vRwtTll1Q+iMLo6A003BzCnPxztyuGExxXlVVcO
r3W2IoN5HXB5QanxsfPCeLWF8votx4vRZazc1EozRIx3/Mh2ZwafaY0rWhuu
1Zz4yM3N3m9wBLsQTp8sl9N6zUlW1W6BKhTi5Eq0JXJ4Kx2TsfDLghOduWew
44ryqqkGr1GnsFMWr6/ZvL4DvJ4hvNKalqvrDju83PTVzh1OHekeJ6+eklkW
FkVcQdgthKUl/wnihfRRRyPK4ZXmB7TOO53lBRTX4DVCbNjvZKRUQEqF1FFU
PhsvqzUBrFxJ0ZVG3LzUDv49rJoS/xoaOb/XGs35WrVna7yVjfJVCkpkEVeG
HLSLbzy8N5UPb6OB51YgA+H5ElEZq+6gERXkTIqou46mPv1Es4Q8q13s3Rp3
OSE+TZHSWvUmD7zbQ+CtmEh4riKSpp1uoiQCV7qWBOIImLXqjF4SQBF0lHY7
ik0R7nNz9g2OosmWgNKKP4vw798uEB4IR5hWwH+FEboaMEaYkyuZ2P+Fo1ud
qH5qWWOQo7eHy5kwvRFCb6gUvaPVo+eWEnjdg6VnZwIviUyAjsEpHnpmjQzN
2edk/NhYl2ocLr+9HL/70XoTL79LS/P7IcfPq6oTpcPNPC1+vcdEhlAOP1fF
dDnuKJkzOFpRJgrjel5Jjn8bxvG7IRyxxO4qHmymhTKHEyIipjlUk3UVNuvq
2JW+7SERMauwYWppSSItf1dG7VsstU5EzSpMUJ3In5/SPOKkiItBURO7q1G3
IEFrtoOotPupkEINofLExFBRZYZUPXvZRyUtDKbZVZYtqIhODiW8ErUpJcSN
n5yo16ts9Drlg7SklS6fIKQ+G0iqw5DC64RuK0UK60A0D/XkCfWaFNXPJrO0
YI5a0xpvqRjY7kBg508IsDzhDANjEytIFmBaF3vTfHSydf7N1Zy2hXBKU3Ui
LeJCCq6VMpzeUjmnnxJOvR5OeI0KTkD5vKBHnnx0Rs8ZU9c6mrU3TceyBmGV
lkkIq0cRq6cUqwsnihWTrOMElEsDprGc5nMz1RpPlF+CU7dH3p9YTlxRiRHN
2EQdczKxvtStKavGlFV63fMyaqOZuCVjdDtSdVoCIUvCqsXo55UxuhcxyvKh
fsVIatZ+Rp7xtDM/73FVCyK/cqyKmNWnqs6qz2Y1bLPC6bcv+5F6dbmsfLG5
leO4Cg+RqnFpDS8bGierHyFWtCCJhX0sKLqscKaDInSpWZdmFaFrXxArrEZg
VlhK9LH6eDCrf3dZbbJYPUdYYfEVa2Ikq85YWXH5KyIu51mZLIa7F7SOzGFB
GQ3RI1gp9i5nEUbl/Mya/tL8WE3R5YezQRPBy7iU5wfVpRJ3bFK2Zjzm1ACs
DJHw3FUWzwvyeH7d5vltwvMmi+fzhicrM1oqz902T50R2XF+5TzZjPs6pHaX
kXQTwXHUrtzhyjlF+tZKkP6EIDX1Oy9SXrDgM4HqE+0aJ1ElY+QQfTKc6NV+
orfkEeWkNE/a7uQM7J3DwUTTubOjVC7B5KepjEbkyKyq7Cf5ucpJ0hq8nyQn
gOAsVZLMMgqpitPxWR5NZ3x2lMo8fFRHjThpibxW7bmqVOnKhp4AqiT3xzmt
ztOMWs5TNdd1s66NvQaVJDjI6iauUPlHILhzfARFBgf1hmNMdqII0qeOALEG
EwVlxGoEr2hVmyfbzSdGKoPp+kl8A29eICSIXZNLjFSmSXlhxCFGdBQr59U5
ygkm7lbE5hJiQHBKftxdI3hFVxJ9wBUzyyL2+XBiGwKIIUmcV57cDNhkdSpT
OclE3xNFDKt0bvGvKsR+gIgxqx9YEdjVn2gebOUrp5j4MIdYhz+WJpqB1ldY
rU7pv3nE1J1npYh9M4SYXXJ+0UfsYCgxGVHTaKU+JZZGImtzlXKvwOKDRWp6
eslWVWGhJQ6yspcnb7qwSDqM0g8/K2fOvzRMNc/EA7xma+KYZQ8ysBd/22sa
rDIDPMEqmkuhuXpLVtuzltbkjDCH2iUo5g2UDBjZk634EWqfMDeEhlN7OqV2
I6WmasiCGlTr5h/bN3piEC6WY6VUAzcle7LHQ2wON4tdGBjPssSwoDfhxDZn
xGTlKVqIhWKB6+XhEfExxcVmsHa+xenpGTE5i4G2tyKclMpMlXziSp9Fp+SX
rpCpCqkfby6CK9FitkRjaMl8X2zF0HKzUxT9c8p6zvh6s62sTxS1I+OgBqyW
PEuWdDj6OobGiCRuIooC/uNHuspgttyOxYI0ECx82gUJD7PzSjP7J4eZGldL
s2Xh7toFWzxOoYmYX/ru6iBMlqRjfqm105mszk+tnkSwkciRBqJzfIklwaak
I4ztzmBs/0CwXSGxwRx1tnoSwvfQqcks97CRHUfIxDiTvruCh1P2UkH/K0e6
eWJGVfet4k1nuQY3D4Bc86w2T3bOKposxMPBEGGUvcE6WX0cb2M46nTT4iiT
JwnFTdBp8qQDW56je+9jo/MJPJPhXJQdMPkUztkDOGZFRczxcQ9HdZbG6VD8
54pAvoBAnrBBigEpwbi16qAMIZwkrJGYmquxS5gRZKeL0uzU1TJTnT2cJjBs
+eI76HnNwnwGwXRXRxDh7cSQH6ZI6d10KyeDKJ9ljrqesVzAsRx1axY5LGH+
W56d2wTklQ7ItR6QUMJ9fgejC0uQzuolycaXt+bFyD6SZr2veYIBzJJLcvMM
mv6zotwAV91NMcLoqydndzRdTtlnP23fDoJJ+RR0QYrVRKT7JfIvKaLT2CWP
lVXP5a7Ti8PiaK0GeARNphIJHZws7657/FuJ/B29Nkf9pkRQGi/9zM2vXjq6
jSdirqS+Vbrg/6JA/9MlFK48mfovxyWs7xQvhNfiv2ix+AFPH11E1GrlMc3B
TUYpXaEpUhb0Hzvaxd6zqO4vph4ucPXqHO3C9VDGJKKhPzeeLMjrPVzNmd5n
0bcUj/nem+dtw9w4N6zXQ2mvlaQX6WPQLHpbCws/fJ0UV0rZAdpJHe1Kvdbf
S/qk4WhWeI6g8nZp9gLTx1lMyncf9M7umooqT7lRZU7P6nDPamQg3sj2DMy9
TfQInkc5w41wZWtWhOuJzPi+wEhsMMpjFohBVlCrugOnjvhxieEyFUczsoVs
9Y8vmrFHEhBoZLU72AmeQG98bkqvT9KcfaEPHAvzNPHtaXtqPlD+yUaukJNC
k9zDbUldCWeQlmDWcp4qaTzr7jT/Ms+kN1carxrFJUQaIwoLe0+q04rM7CBy
aCCXV7HJKumJfNy1mI6lHWNdKhJ+6+nz8cWXtXpMWPOv+H61tCwfjy3mPCmJ
wJx33J3z+D5P09ahVlCPZxGJo13ahrutHtklbfN5LW+5SVtuss4r+SirNdKq
nByVyZPuGcpbbNAW1fVLWZS97JD2apW9U8zoU9b0ZU7/454vJgmbe/bkcZyp
2+lRF6hoLWpHfkXbmQQNUMtupEGf6i1NzNFtbdVtrTNtidNJDqlxtyWNmHNc
tNOl21lv2knUM9VobBDajhVhoit6av+Fo9vGY99aWYfsbyD9p+vVQ+2bqv8c
zr719DR6r9ikDIAeW8aWeV7xbM6mdQ+j7Dm9A1LZNauiZxAbG5HfSeL+/QX6
DAdlLe/petiD6WW2JmPGSeKtbEW1VPq5S2a9z9QSbdGn6DQ4bZX3JDe8xZSc
0QQ7k7brK/DT3GfeVKIt+pSSugraclcGNZRolY6T2gpabUzQE8lRW+tIW/Qe
/RqnLfpsqSmk7fpxt7AEtYAtdRBL9CzHlrIn9dL+XEes8H8HRtlYmpB7cbWN
NcQGnIvW36RR+5/l2b+d7D8TeZK1bv5qDaep4pmgllhfTazPYq0vYscIbaeG
2G7TURg87z31U74r5076Gj0aW0lP51tHML+H5ohbPSa9fZfurbRbl2PXaDB4
XZn8vZL0b7a2U59jx31umN0/afdS3S953OtN/JUeb5Pdm2uTua5erPearnuh
ns3SgraSTa3QucZUvZV6otl5SfYXGOTv5XqrJt0D9WTXs5kRlyRZ5OVEeuJt
rC1N1u2pZ8a/3mGTv4I8MhbE77OExXrNQVo8M9iiIYX/mon0UIbepwmr5i/U
SI+XBls1o4LGLfJonqYZyn6eE2zRzMY0njhTW/qLYEvpFcsacZnFRdrbFuv4
2h5lR4BeaRbo/lwA31+Y4Hk528rkVCtgq7cneM7Ltpque3IRbHV+4p/bahMc
AWUWDOd3JmZEB8wOdantTnU3qbRweaAFMw9Y8YV4+e7A/c1dv6s825t5Z33O
99jeOoudmSfUpxcl/rhxVXpk8qOEtj+J7S5K7FGsvHP/YmE06f8BdT7X8g==
\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4810412],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236213887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->521509723],

Cell["\<\
Choose the bounding box edges automatically to draw the axes:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->913199839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184914044],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->Automatic]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->46840637,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62198761],

Cell[TextData[{
 "Specify the edges explicitly, using ",
 Cell[BoxData[
  ButtonBox["AxesEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->373081102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None", ",", "None"}], 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "None"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55835140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{{-1, 1}, None, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, {1, -1}, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->9966339]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2572579],

Cell["Specify the style of each axes:", "ExampleText",
 CellID->25797943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "12"}], "]"}], ",", "Blue"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144070148],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35357309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111620456],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->618981887,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63652544],

Cell["Display the axes without the bounding box:", "ExampleText",
 CellID->662240017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82204535],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  Boxed->False]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->19357227,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Axes Labels and Ticks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->465560348],

Cell[TextData[StyleBox["Specify a label for each axis:",
 Deletable->True]], "ExampleText",
 CellID->5660721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155681055],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10071717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104675169],

Cell[TextData[{
 "Use labels based on variables specified in ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->597796483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"\[Theta]", " ", "\[Rho]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13529119],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->764048929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->870514339],

Cell["Draw the axes but no tick marks:", "ExampleText",
 CellID->409273366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52504916],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->597732935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26480736],

Cell["Place tick marks automatically:", "ExampleText",
 CellID->467350673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268606094],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->115436817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165593776],

Cell["Draw tick marks at the specific positions:", "ExampleText",
 CellID->77268436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->709539987],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->382991111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90566560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390500440]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9053],

Cell["In 2D, the axes are drawn above the graphics:", "ExampleText",
 CellID->824055203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206505545],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Axes->True]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->253848895]
}, Open  ]],

Cell[TextData[{
 "Objects in ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 " are drawn on top of any graphics, including the axes:"
}], "ExampleText",
 CellID->109784410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", ".5"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154466856],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Axes->True,
  Epilog->{
    RGBColor[0, 0, 1], 
    DiskBox[{0, 0}, 0.5]}]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->129401496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360963046],

Cell[TextData[{
 "If the option ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the ticks are drawn on the edges of the frame:"
}], "ExampleText",
 CellID->187633893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195771483],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->881770176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60624786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " puts grids across the image:"
}], "ExampleText",
 CellID->50562259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16430822],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->312042939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->963264167],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceGrids",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGrids"]], "InlineFormula"],
 " puts grids on the faces of the bounding box in 3D:"
}], "ExampleText",
 CellID->545823904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490910882],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->All]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->142359323,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34950058],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " and related functions display the frame, instead of the axes:"
}], "ExampleText",
 CellID->106244178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10399395],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->827885913]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3323],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Axes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axes"]], "InlineFormula"],
 " are both present, the axes ticks are suppressed:"
}], "ExampleText",
 CellID->691359341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108317878],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->110344946]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5491],

Cell["Move the axes using a locator:", "ExampleText",
 CellID->109965688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{"Framed", "[", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "3"}], ",", 
        RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"AxesOrigin", "\[Rule]", "p"}]}], "]"}], "]"}], ",", "p"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705423511],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {-0.7799999999999998, 
    0.30000000000000027`}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {0, 0}}, Automatic}}, Typeset`size$$ = {
    190., {108., 97.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {0, 0}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Labeled[
        Framed[
         Graphics[
          Circle[{0, 0}, 3], PlotRange -> 3, ImagePadding -> 20, Axes -> True,
           AxesOrigin -> $CellContext`p$$]], $CellContext`p$$], 
      "Specifications" :> {{{$CellContext`p$$, {0, 0}}, Automatic, 
         ControlType -> Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{236., {128., 133.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{240, 263},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15229065]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19814],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLines",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLines"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boxed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boxed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21298]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27116],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->85241713],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->351435910],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->601391765],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->352732663]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Axes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 24.5351740}", "context" -> "System`", 
    "keywords" -> {
     "axis", "abscissa", "axis position in plot", "display axes", "ordinates",
       "show axis", "show axes", "Cartesian axes", "coordinate", 
      "coordinate axes"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Axes is an option for graphics functions that specifies whether axes \
should be drawn. ", "synonyms" -> {}, "title" -> "Axes", "type" -> "Symbol", 
    "uri" -> "ref/Axes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6152, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->343555024]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 253665, 5066}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2846, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3469, 91, 42, 1, 70, "ObjectName",
 CellID->13139],
Cell[3514, 94, 457, 14, 70, "Usage",
 CellID->6767]
}, Open  ]],
Cell[CellGroupData[{
Cell[4008, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4486, 130, 206, 8, 70, "Notes",
 CellID->24370],
Cell[4695, 140, 206, 8, 70, "Notes",
 CellID->6676],
Cell[4904, 150, 499, 19, 70, "Notes",
 CellID->10143],
Cell[5406, 171, 350, 12, 70, "Notes",
 CellID->30556],
Cell[5759, 185, 356, 12, 70, "Notes",
 CellID->17973]
}, Closed]],
Cell[CellGroupData[{
Cell[6152, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343555024],
Cell[CellGroupData[{
Cell[6537, 216, 146, 5, 70, "ExampleSection",
 CellID->8383472],
Cell[6686, 223, 61, 1, 70, "ExampleText",
 CellID->458529206],
Cell[CellGroupData[{
Cell[6772, 228, 192, 6, 28, "Input",
 CellID->136523611],
Cell[6967, 236, 255, 8, 167, "Output",
 CellID->571018372]
}, Open  ]],
Cell[CellGroupData[{
Cell[7259, 249, 196, 6, 70, "Input",
 CellID->299586600],
Cell[7458, 257, 7352, 126, 194, 92, 2, "CachedBoxData", "BoxData", "Output",
 CellID->319664002]
}, Open  ]],
Cell[14825, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->164152086],
Cell[14953, 391, 287, 12, 70, "ExampleText",
 CellID->147860468],
Cell[CellGroupData[{
Cell[15265, 407, 315, 10, 28, "Input",
 CellID->507563028],
Cell[15583, 419, 2393, 43, 113, "Output",
 Evaluatable->False,
 CellID->36552272]
}, Open  ]],
Cell[17991, 465, 125, 3, 70, "ExampleDelimiter",
 CellID->406724686],
Cell[18119, 470, 147, 6, 70, "ExampleText",
 CellID->395805850],
Cell[CellGroupData[{
Cell[18291, 480, 425, 14, 28, "Input",
 CellID->59629905],
Cell[18719, 496, 21306, 353, 153, "Output",
 Evaluatable->False,
 CellID->318556658]
}, Open  ]],
Cell[40040, 852, 123, 3, 70, "ExampleDelimiter",
 CellID->3532064],
Cell[40166, 857, 267, 9, 70, "ExampleText",
 CellID->256827188],
Cell[CellGroupData[{
Cell[40458, 870, 432, 13, 28, "Input",
 CellID->120129542],
Cell[40893, 885, 2440, 44, 135, "Output",
 Evaluatable->False,
 CellID->59007003]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43382, 935, 217, 7, 70, "ExampleSection",
 CellID->20920],
Cell[CellGroupData[{
Cell[43624, 946, 235, 7, 70, "ExampleSubsection",
 CellID->973565391],
Cell[43862, 955, 259, 9, 70, "ExampleText",
 CellID->180501439],
Cell[CellGroupData[{
Cell[44146, 968, 248, 7, 70, "Input",
 CellID->92125971],
Cell[44397, 977, 277, 9, 117, "Output",
 CellID->7106707]
}, Open  ]],
Cell[CellGroupData[{
Cell[44711, 991, 292, 9, 70, "Input",
 CellID->440134790],
Cell[45006, 1002, 1710, 32, 70, "Output",
 Evaluatable->False,
 CellID->28268093]
}, Open  ]],
Cell[46731, 1037, 125, 3, 70, "ExampleDelimiter",
 CellID->288243120],
Cell[46859, 1042, 205, 8, 70, "ExampleText",
 CellID->93392161],
Cell[CellGroupData[{
Cell[47089, 1054, 314, 10, 70, "Input",
 CellID->345832742],
Cell[47406, 1066, 278, 9, 126, "Output",
 CellID->224232822]
}, Open  ]],
Cell[CellGroupData[{
Cell[47721, 1080, 336, 11, 70, "Input",
 CellID->728952763],
Cell[48060, 1093, 1910, 36, 70, "Output",
 Evaluatable->False,
 CellID->29165364]
}, Open  ]],
Cell[49985, 1132, 124, 3, 70, "ExampleDelimiter",
 CellID->59886176],
Cell[50112, 1137, 91, 1, 70, "ExampleText",
 CellID->152787229],
Cell[CellGroupData[{
Cell[50228, 1142, 196, 6, 70, "Input",
 CellID->255148411],
Cell[50427, 1150, 7352, 126, 194, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->301316807]
}, Open  ]],
Cell[CellGroupData[{
Cell[57816, 1281, 309, 10, 70, "Input",
 CellID->4810412],
Cell[58128, 1293, 22071, 366, 70, "Output",
 Evaluatable->False,
 CellID->236213887]
}, Open  ]],
Cell[80214, 1662, 125, 3, 70, "ExampleDelimiter",
 CellID->521509723],
Cell[80342, 1667, 160, 4, 70, "ExampleText",
 CellID->913199839],
Cell[CellGroupData[{
Cell[80527, 1675, 251, 7, 70, "Input",
 CellID->184914044],
Cell[80781, 1684, 7374, 127, 194, 115, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->46840637]
}, Open  ]],
Cell[88170, 1814, 124, 3, 70, "ExampleDelimiter",
 CellID->62198761],
Cell[88297, 1819, 219, 8, 70, "ExampleText",
 CellID->373081102],
Cell[CellGroupData[{
Cell[88541, 1831, 1199, 36, 70, "Input",
 CellID->55835140],
Cell[89743, 1869, 14512, 250, 140, "Output",
 CellID->9966339]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104304, 2125, 231, 7, 70, "ExampleSubsection",
 CellID->2572579],
Cell[104538, 2134, 73, 1, 70, "ExampleText",
 CellID->25797943],
Cell[CellGroupData[{
Cell[104636, 2139, 391, 13, 70, "Input",
 CellID->144070148],
Cell[105030, 2154, 2456, 44, 70, "Output",
 Evaluatable->False,
 CellID->35357309]
}, Open  ]],
Cell[CellGroupData[{
Cell[107523, 2203, 314, 9, 70, "Input",
 CellID->111620456],
Cell[107840, 2214, 7630, 133, 194, 179, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->618981887]
}, Open  ]],
Cell[115485, 2350, 124, 3, 70, "ExampleDelimiter",
 CellID->63652544],
Cell[115612, 2355, 85, 1, 70, "ExampleText",
 CellID->662240017],
Cell[CellGroupData[{
Cell[115722, 2360, 243, 7, 70, "Input",
 CellID->82204535],
Cell[115968, 2369, 6468, 112, 194, 108, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->19357227]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122485, 2487, 242, 7, 70, "ExampleSubsection",
 CellID->465560348],
Cell[122730, 2496, 109, 2, 70, "ExampleText",
 CellID->5660721],
Cell[CellGroupData[{
Cell[122864, 2502, 348, 11, 70, "Input",
 CellID->155681055],
Cell[123215, 2515, 2424, 44, 70, "Output",
 Evaluatable->False,
 CellID->10071717]
}, Open  ]],
Cell[125654, 2562, 125, 3, 70, "ExampleDelimiter",
 CellID->104675169],
Cell[125782, 2567, 222, 8, 70, "ExampleText",
 CellID->597796483],
Cell[CellGroupData[{
Cell[126029, 2579, 388, 11, 70, "Input",
 CellID->13529119],
Cell[126420, 2592, 21473, 356, 70, "Output",
 Evaluatable->False,
 CellID->764048929]
}, Open  ]],
Cell[147908, 2951, 125, 3, 70, "ExampleDelimiter",
 CellID->870514339],
Cell[148036, 2956, 75, 1, 70, "ExampleText",
 CellID->409273366],
Cell[CellGroupData[{
Cell[148136, 2961, 260, 8, 70, "Input",
 CellID->52504916],
Cell[148399, 2971, 2309, 42, 70, "Output",
 Evaluatable->False,
 CellID->597732935]
}, Open  ]],
Cell[150723, 3016, 124, 3, 70, "ExampleDelimiter",
 CellID->26480736],
Cell[150850, 3021, 74, 1, 70, "ExampleText",
 CellID->467350673],
Cell[CellGroupData[{
Cell[150949, 3026, 266, 8, 70, "Input",
 CellID->268606094],
Cell[151218, 3036, 2403, 44, 70, "Output",
 Evaluatable->False,
 CellID->115436817]
}, Open  ]],
Cell[153636, 3083, 125, 3, 70, "ExampleDelimiter",
 CellID->165593776],
Cell[153764, 3088, 84, 1, 70, "ExampleText",
 CellID->77268436],
Cell[CellGroupData[{
Cell[153873, 3093, 514, 17, 70, "Input",
 CellID->709539987],
Cell[154390, 3112, 2419, 44, 70, "Output",
 Evaluatable->False,
 CellID->382991111]
}, Open  ]],
Cell[CellGroupData[{
Cell[156846, 3161, 699, 23, 70, "Input",
 CellID->90566560],
Cell[157548, 3186, 23689, 392, 70, "Output",
 Evaluatable->False,
 CellID->390500440]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[181298, 3585, 232, 7, 70, "ExampleSection",
 CellID->9053],
Cell[181533, 3594, 88, 1, 70, "ExampleText",
 CellID->824055203],
Cell[CellGroupData[{
Cell[181646, 3599, 244, 8, 70, "Input",
 CellID->206505545],
Cell[181893, 3609, 281, 9, 167, "Output",
 CellID->253848895]
}, Open  ]],
Cell[182189, 3621, 243, 8, 70, "ExampleText",
 CellID->109784410],
Cell[CellGroupData[{
Cell[182457, 3633, 469, 16, 70, "Input",
 CellID->154466856],
Cell[182929, 3651, 344, 12, 167, "Output",
 CellID->129401496]
}, Open  ]],
Cell[183288, 3666, 125, 3, 70, "ExampleDelimiter",
 CellID->360963046],
Cell[183416, 3671, 365, 13, 70, "ExampleText",
 CellID->187633893],
Cell[CellGroupData[{
Cell[183806, 3688, 239, 7, 70, "Input",
 CellID->195771483],
Cell[184048, 3697, 270, 9, 162, "Output",
 CellID->881770176]
}, Open  ]],
Cell[184333, 3709, 124, 3, 70, "ExampleDelimiter",
 CellID->60624786],
Cell[184460, 3714, 207, 7, 70, "ExampleText",
 CellID->50562259],
Cell[CellGroupData[{
Cell[184692, 3725, 247, 7, 70, "Input",
 CellID->16430822],
Cell[184942, 3734, 279, 9, 167, "Output",
 CellID->312042939]
}, Open  ]],
Cell[185236, 3746, 125, 3, 70, "ExampleDelimiter",
 CellID->963264167],
Cell[185364, 3751, 230, 7, 70, "ExampleText",
 CellID->545823904],
Cell[CellGroupData[{
Cell[185619, 3762, 246, 7, 70, "Input",
 CellID->490910882],
Cell[185868, 3771, 9895, 168, 194, 110, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->142359323]
}, Open  ]],
Cell[195778, 3942, 124, 3, 70, "ExampleDelimiter",
 CellID->34950058],
Cell[195905, 3947, 262, 8, 70, "ExampleText",
 CellID->106244178],
Cell[CellGroupData[{
Cell[196192, 3959, 355, 12, 70, "Input",
 CellID->10399395],
Cell[196550, 3973, 24286, 402, 70, "Output",
 Evaluatable->False,
 CellID->827885913]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[220885, 4381, 225, 7, 70, "ExampleSection",
 CellID->3323],
Cell[221113, 4390, 349, 13, 70, "ExampleText",
 CellID->691359341],
Cell[CellGroupData[{
Cell[221487, 4407, 496, 15, 70, "Input",
 CellID->108317878],
Cell[221986, 4424, 24294, 402, 70, "Output",
 Evaluatable->False,
 CellID->110344946]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[246329, 4832, 223, 7, 70, "ExampleSection",
 CellID->5491],
Cell[246555, 4841, 73, 1, 70, "ExampleText",
 CellID->109965688],
Cell[CellGroupData[{
Cell[246653, 4846, 802, 25, 70, "Input",
 CellID->705423511],
Cell[247458, 4873, 1751, 38, 70, "Output",
 CellID->15229065]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[249270, 4918, 311, 9, 70, "SeeAlsoSection",
 CellID->19814],
Cell[249584, 4929, 1172, 44, 70, "SeeAlso",
 CellID->21298]
}, Open  ]],
Cell[CellGroupData[{
Cell[250793, 4978, 314, 9, 70, "TutorialsSection",
 CellID->27116],
Cell[251110, 4989, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[251251, 4994, 192, 4, 70, "Tutorials",
 CellID->242403382],
Cell[251446, 5000, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[251640, 5008, 318, 9, 70, "MoreAboutSection",
 CellID->85241713],
Cell[251961, 5019, 148, 3, 70, "MoreAbout",
 CellID->351435910],
Cell[252112, 5024, 175, 3, 70, "MoreAbout",
 CellID->601391765],
Cell[252290, 5029, 163, 3, 70, "MoreAbout",
 CellID->352732663]
}, Open  ]],
Cell[252468, 5035, 27, 0, 70, "History"],
Cell[252498, 5037, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

