(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    140862,       2901]
NotebookOptionsPosition[    135089,       2707]
NotebookOutlinePosition[    136527,       2747]
CellTagsIndexPosition[    136440,       2742]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], 
          "AxesOrigin" :> 
          Documentation`HelpLookup["paclet:ref/AxesOrigin"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Axes\"\>", 
       2->"\<\"AxesOrigin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AxesEdge", "ObjectName",
 CellID->20267],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AxesEdge",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
     "\[LineSeparator]is an option for three\[Hyphen]dimensional graphics \
functions that specifies on which edges of the bounding box axes should be \
drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AxesEdge", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["y", "TI"]], ",", 
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["z", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["z", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["dir", "TI"], 
        StyleBox["y", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies on which three edges of the bounding box axes are drawn. The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must be either ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ", and specify whether axes are drawn on the edge of the box with a larger \
or smaller value of coordinate ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", respectively. "
}], "Notes",
 CellID->617],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"AxesEdge", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " chooses automatically on which exposed box edges axes should be drawn. "
}], "Notes",
 CellID->24968],

Cell[TextData[{
 "Any pair ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["j", "TI"]]}], "}"}]], "InlineFormula"],
 " in the setting for ",
 Cell[BoxData[
  ButtonBox["AxesEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesEdge"]], "InlineFormula"],
 " can be replaced by ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " to specify that the position of the corresponding axis is to be chosen \
automatically. "
}], "Notes",
 CellID->25065],

Cell[TextData[{
 "Any pair ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["dir", "TI"], 
     StyleBox["j", "TI"]]}], "}"}]], "InlineFormula"],
 " can be replaced by ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", in which case the corresponding axis will not be drawn. "
}], "Notes",
 CellID->27321],

Cell["\<\
If you explicitly specify on which edge to draw an axis, the axis will be \
drawn on that edge, whether or not the edge is exposed with the view point \
you have chosen. \
\>", "Notes",
 CellID->18655]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->907163695],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->712177048],

Cell["\<\
Automatically choose which bounding box edges to draw the axes:\
\>", "ExampleText",
 CellID->913199839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184914044],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->Automatic]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->46840637,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12504731],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->634715904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18540134],

Cell["Selectively draw the axes:", "ExampleText",
 CellID->40453982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None", ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->549021744],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->{Automatic, None, Automatic}]], "Output",
 ImageSize->{154, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1907986,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnQl0VsUVxx/ZCWE1QGQRitLi8iUBBIRiRaxQlbBD2BQjRiBhCSEhZM/3
RXEXRcUdFYVarW1t7Xbac3pOT3u0m7bWqrVW61a1WouogMA77Zs7M+/N3Lnv
ffMlX/Q0B5K8ZN6dub83b+be/8x7KauoW1e5saJu/ZqK0bNrK2rWrV+zdfSs
zbXejzJ7OY6z2/v/QJHjff9f7zv4v9t1Xe8XxudV3udMr0AGO2LfuPDhZHjf
lkKJi9FvMtmnrODYcUr+L8oxT5lXOeJrqUJhtvhZpmLLYVS8/+fD97MMq7mo
3pmW5U4QdTmZlZWV4menWZ47UFwtaCg/3Tk95NxsUY88x/etEj4iz1Pr7Oe3
l/8eToAyvAHM1mkaxVzxtY+ouTdZeqUohXse+Jzls/G+ORXKTySukSt66ghR
U9+QcycYXmYZPykSNgaww2zfhmjzOGs7QwheAxQC0GZ0PNbaeqGwPjhtFrU+
JdpbiKxlouNTrK33F9ZPtLIor7G8R/uKs0eg0lno+GQ4+xsEeXxmNjoeA0VH
u+H3/wjxuy9ZWRplEMD38BCC92hkKwcdQ93OMO8zM82rVqow6igUdbCfF3pf
85G9XHQ82rLtsq/kyJYU7ilN7B2f2D8h8eiZicenJJ6Ylnjy7MRPzkn8bGbn
L87v/OXszl9f2Pn0nMTv5iWeWZj40+LE8+WJF5cnXl6VeOWSRLawFOV5WMvk
6DbIVUaRoIRkPHJncfzW4vgdJfF7ShP3lyYe6mpbX6tIvLEm8dYV8XfWxd+r
jjvBiBpOdVRE21Wq8h7JlFRPTsQ6dsTi18firPklRvMnpdD8v1LNf39j/MOa
jgO1HU4mmoloH+T9IUf2AtFieRWc0+ti7Y2xjtZYR9Kmfwea/kNo+s+70fSD
9R2fNHQcampnwzOaZdi3J0HLJ7nmmJApfxarirXVxNrVtl8d0vZvorbPsG37
63rb/220/bP2Nhhn8lD7R0KD+7nh8dlwVx8tnfGXxtoqY23VsXbPq3rwqq0n
vfon6VUjeNXWdjTedqyz1ZEtNH3rj3wyI7ehyngDHk5eGmtdGWv1/LzC8LOT
+1kc7udZPeinu6PVvaaF8BVmILhzsuQMGenzYKLHwogx1TuYH2teGGvhECoA
wgYJoUmBcENx/Obi+G0l8TtL4veWJh5IFcLSEAhVAGEzQKgLIBzRIbjXt8BV
x7P0CMurPkhc9TxJYrrn9gLp+SrwfC14vkV63g6eX5MOz19Anldqnv9Hev6p
5nmbexV4fl2Le2Ozu7OJ8H64pfcDXDrOBXszvOOyWOO8WJOPpByQXKYg2ZYK
ku9bIlmJkbwbgaTDRNLs7qKoDLOkQmUhMGLOBCLb5wZQWjiUi0OgXBkJ5bH0
QtmGoRxnUFoDKLc0ubc1ErHEMH/0V0d4Oe+yr8554HmD6fwy6fy6WNvGWHst
ON8c6fzDqvNfpZwvo51/9VLa+Y/CnL8anL8hcN7dvd0J8sCAAGQMEFVniOvv
zAKPt4HTjarTi6TTawynO7rv9ALa6Tc9p9dipz9WnP7MczpBOX0rc9q9syHU
69FEb4fcdnZZrB4IbCcJXKITaNAJ3Fgcv6U4fntJ/C6VwMQ0EPjXBiCwRRLY
DgRaKQI3aQTce7Y5BIUicHuk6O0s63AugGtfzzs8ON+kOr8cnL881rY+1rZJ
Ot8inb/2C3C+XTh/JTh/LeX83dvc++op/4eC/zK+Y4qRUwb+18nujxEsBgSr
FQRbFQRXYQSJ+1JH8OckCOIMwVYLBDcDgts5ggYPgXt/He/kLJTnd8Awce1Z
LODMAd9ro91fEeJ+PNL9R8D973bB/cs09z+wcf965P525v69wn3cB4YAB6mh
UfG/n0cKJXBQ0E+2RrBaIll5qUKVZLW9Z1j9DVj9A1i9Hc2qve0oZ7WDs2oR
rHY1ubc3uncErNwHa6l7BhQxPjNGRhJqBM76G6dWFtsC1OoNas0qtUsltc2C
Gksbk1ObHE5tjgW19UBtU/xDTq2eUfOTRytqe6KpsZ6URcScJj34SbaqszCG
oG/Og56XFKPI33yMdQbGm4rju4rjuyXGB1PB+Ec7jAdMjHGJERIYFp6pGO/y
MG4DjFuPP1RDkSy07H9SfcARH8zv88pim8IY8oh/gZL+qQwbFYbXpYXhMmB4
sWR4OcHwIGPYoTHs1BnuBIa36QwfSAdDo4Rih42aznzoj5th4tBwztUTKD+n
BElBE4TiTMzqIZwJD+c7Ps4agVOVhVBO7adRAc57fJxbju/bhCmc0EWaOEfL
xzTrrGm2I3ktmua3k9H8g0dzUfdooqRUpiCSZj2juZfRxBRgnoCepWZkWcqx
WhrUyAUUMxy5+yl8BSVqmczulsz2Gcx+asfs78DsjaTMaG3DYHafZPbwZocY
1zi3E1Efw7wgl19QFqsui9UovBrCeKnZvap/cfk5Xbxe4rxWS15XAK9qyUuX
An0t6LjPS09zeb4jedUKXrifDSR5YV0+V/DaqPCiwz1VEECqmcprZ4/xei+C
V5gsoKdI7v2C10f714fwKhL3IV7pyrHmtIjitE3nJET01Dn91o7T+z6numSc
cCop8qjjDzJOH++vMtYnB/ic1H6FeWUHvLZEpxFIcTB5qYsOjFdpYk/aefmS
vClAmroDyjtlMuHFIp/urzZGpP4krz6oVJbgFRq1mSKFr9CovDrDeI234zVX
57VC8qpgvN7SeZmCrabTmHm6nnx5vA7v2xDBS67cG+v9VpwWG5xqdUk7gtO3
Ijk9RXF6GTi95nPyl3pMGdPXs8yEflejkm4FecLRfRuNkbsf2a8wr4zkvJqR
9GFqn+3UoliXef3FjleggBICiJGe6jmBF3YZ66B9SV5AcYm6S4cM9ckkfrUh
FEaz2vv5sDJTeTMH1QP+EFZy1RRG/MX8t2WxdWT0bqbn0YC4kE4DOtMa0BIJ
aJUEtMYAZOqpEYDMjAhieLwnAHIhiM3Ddvvg9VmILvp4FspiVXpoqqU/TobH
z5lFEtz6ORLUlipJgqbM4afoVERPE4R+Z+4U0nQhRhTy+YVlsQ0R6NTMcaWi
sCFy6iKOv7qPyU1l5H7UVXLvquRMdZIgFxXb48gKIgcY17McY7+SJKjtYPK1
/0V6/ErmRSrBNlWjbKCWwRDB/Yjg1zyCnfYEX1cImksBtJ5hZpM+QRntH/Si
WEwxP/X+t0hGs2b0b0WvhVpE9HeXhNI7Lzm9V7pDLzRXEjnAJ15Ma0tP7uPC
o98gwW9T0mxAVTF0hVxbhUvK7wfd5hesLhgCr6b/EPxEDsVj3ENejIuj/d4R
/LTVGXR8Qpc4cjXIl8jRUp6/mN01js8BxxcjOSrrDaQmZOSi+qIW53gklKOc
h+WuwgzxtRDTCs0VSO3MpxUPp/VQWmhVKrSU1RlfQdMUITIT1RZoWAR8zMsY
GBe2iZ3frUNC+tJmm4xzmaGUmcst0XS+lyoddUPMWo3OAZOOqmvgvFPPp/z8
gOWdrCthnTEvGa2w3CAJrUZqjc/fRuLvbE2NVrkVrSi1TKVFZ1OQIWQKWqTe
atCC8X5xWWx9l4HV60snSYBN6TqwNxGwmhBgqqyhpp9kxvDwJoYIx7zRrKrJ
2DZa1PBFWLQw4i8gq7vSOKvHOavpXzQrJTcosOe0xIhgQ8UMUyQzF0N6lhO1
JIKlMlXSULNQnENJ1RrPgJzVYGq0CmU1lxIzTFbmQgja+JQuVm/bsyIzdirm
Z8o17le5Pis/Oliix/R0RmQKPhspUT+C0aNpZ1SrM2oNYeTl5ERexCN7UKvD
GVH9KSzuRKxaEataXaBWF9bUTS5pZPUOYqXK1KqcGJGFyywoUKrTzQppFb5O
hkTqnmD1KmJVrbMKkxNRvq1mPEqk/pkXe9rde2GRubZKq+bTKqNmXchHmwGC
7el2jJ71Gcl9+/7eRM7ovS4zUleKgvh8UwgjmcVQz6fivFr2teQxvKlL0KJ1
Vzk+nQpHdXkySh1D2bWaFaqxKc0RItUkT5WS+fVSReNOIWk0pcbkSCelgPR5
hPQyHalckSOlWixYqIk2So5A704/0aquEUXSo7pqp+4y8DfhC6LTIonOp4n6
m9PCiFISkJmMGwkUxLh4XS4nJaL+mLk0TAM3cypd0CBkyB4mmbAnScga5GJV
GkgafbM8WUZBZKm+oIaESXXVL4zoE90haqy/hxClhCJEVMkrDhKxck9TbSZz
f1Om5HJ5z1HFu0D05S6aKpJMUFYrM5BPiOg6R5vh5d4/PNMrBLfYZ7o+wRqK
oLZUmArBpywJoiVXtOzQlozgbp0g5CeHiJibE5TvPoHYO8eMtTM8Ts48HkeS
moApY9KkSoN9peozzk9Gk1qYIikkjCN5jsx29ezkSCQp/EYHJz86O4E16Isi
iDUaxG5OIzFlwz2x34EUx0ktBeW+OrGjRI4SQazcOvfVNtGYWmYSYhOtiP0+
jcQ0tQBlwH5WJzVzi7uxPDwboVUCUsnkMjlaKEWkHksHKbTRwdQzQ3QVKv8V
uR3kJDhKySb7Fhwvs9PJmVygSitI1lTXFhC0PV2DtliBpmz21qHRKwxRAouW
yGlZRwrMzgW93IoZT3tNZk09wIy/+OEFn9lqjRnfF/KBZAauOoWHm2HcT0rM
zNPMWJgTGySJief5YAQ72zLOVUUpU+wk1/sQsUfkk6BpIQav4XKKfLXTx4UV
lxsMXEYS9tH+KjyCBcT8EWyaPalyKamQUmdPk+IbAqEXjSDVc4/VkdY27/cE
KzNhDR5bEQJ6OCtjfpySErNVlJznS+lofdTfX9R9ZvyOG6XtTjDkdIDGdBOv
LN4oE5ZJyZifUtQjqJ0po4o0UNsRRk1u/I6g9iuKGrAaY25tI3V1H5oX5jPX
r7KDBmH+4X0bUmA2Xo/EkuTr6kYiktl11sx+jJhdEDDj/WosujeJnR26eHxI
geb1NOb+NUbOjnMjRWPHoz/k5v6TZGG7UjOllhSWN40Ny9FVklxLSgtJPsKP
e1Z5J8hLJsa1IRi3I4zQ/UzpIyQNOLZvI03RfLqR3hkIq9SnKTEvkR2QJE19
01xI9PfSRJOE3ncG75C/UW9ia5aB4KGz9JJQBsZcxscsRYKQEkvjbZfOOKm8
h6YPKJlX5DgNZXskyr0GSiBYgu7tpCjN7RBIkTvc0o60I4bG3C1tlUGkyLJP
pOYe7DUvsoHZaQETGE4QnfJcfaC8yIAJz2K9bMKU67amvMlgGjISwxOWuCq7
cWxZyv2r8tn6wYKkr7lHkSwk1TiT5NUUSRgDJ+F7OwTjMzYYYZmNxEju0mFw
tKyWSDes+2Syfaww/5xkFzMKWYUUOcOwsiYWseF5DNoUQDw3Y1LRdSTmbWRW
cdCMlPWZWN2XalAYngqF1hW0gKlRgIawaor2PufmMAojSGUb+6wknoTPwSKM
ELfJJ/P4cy7YxyJLHxdG+ujwF4ye4nnFpmFnqOoGzp9lQsjah5IcJV4/tK+a
fsLQf3sejKWFdnG6UBtUWYvFXJ7pM7w2wxtSC0ObCrMrawUZJYPEG95SlTiM
WQMto2S1xWB6omzpQDph3AVtvIOISI8SEWlEC7PUFnpx5zYnL6yFzOBU2a5+
ZmTH6jOaQ0QjEa3JRhGc47WogbUxaA4zdI7XCnifWgGu3yYa0nsW1JsntT8c
PMJ8wFrp1ej9c86VNef7YQMzbIQNdj4XCp81DY1nMZmeww7/mM0qzmdnyZmV
2dVm1s39UH0wxhnvYeR7pPg8yirJYJ+yfGe9ghdK//L4BM4s6soN+WSrURO8
sVpYD+ZrZrmMeZPHSsK8xgxJ6x9HWZfvvocrwoZyNJixRs+Xrc+WZqUaYNfq
vqLV2eK6BBUwo4tYy7O5ngeWYTeaneV8YTlPu+fYK5yWMKtZwioklHYWc4XF
PuKaMousleXMnlAdjxFjAbcmpkbxQb2NTM6a2aKefrIefjME9XiNZpeErgdb
NmMUua8iQ1zbAaIeloGwti1X/JHXSK2nVwr1SM78o1DUVCU8WoFqwtGEbU34
SQZZzwZcz4H96xm5rtaD35zhK/RirFop63H5W73wnmXbeiAa904j7QclK8UT
LkYN8q2X7EOuteMnnQdQto33kuGd/Nx+oWhff2RjVQo2hqCfFlC2jEg6KM/u
xl7eIbPGLQ5FJfoksYh7TY5hsUj4idu2ElnC/SLbsDQMleidxCJ+90iWYXG4
aFv3LY0kOKgWVyCL+H0MmYbFk5JYXI4s4r6ZYVgcJbzFlpYhS/h+UC2Zf4Ei
C1krR9agB2X75V3en7mtMaJF2cjGEmSjIMLGKQRJ1dYiZAtmBO2vs3A7Y0Vb
sD8L0PnqX1EJWvEVgplqZR6yMkjUxs8el+TsOSJCGKJdiVOFDak3XITqGKzV
cXqSOmaJOti4lCWsOs4ZqI7zUR1s9GIXhu/xLCbqYGfJ+LOfsM2f3y9RiLPf
ThdReoGrzKnOeOL6slKTRel80QL+1r4JqHS2KF0qSsunGvn7XSeKFrB7h00J
47xS7GuusDkSSk1CNpkNlhmPFLlkrrDJ//bKZFcd74KzWPBY4J3RW8wj7Iwv
wxlnEfbxUzoFggtrFf/LRVOJUurxCFEH/7tT0xRP1VJFotREKDWdoIfnataC
KVD6bFe9e4NS/YVNsOacQ/Y7fYZhpWdA6RnCJi6VI2r+OpSaqfyW3YNZwsYF
8Nvz2PXxjsrgyOn1P7sUHjU=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88821601],

Cell["Specify the axis edges explicitly:", "ExampleText",
 CellID->373081102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None", ",", "None"}], 
       "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", "None"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55835140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{{-1, 1}, None, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1m3mQFcUdx4fd9/YCWVQEEUxWMYiQXs7AshVzlTmqzKpBLhWPhV3cZdn7
Zvddg4gIcqiIJwq45D4rSVXyh/kjfySVWDnMqYk5NJpLkqAoCEwl3b9f39Mz
7z0gW7DvzUxP/76fnp7u769ntqGxr6W5vbGvdX1jzSd7GrtaWtf31nyis4fu
Kh3neV4T/d94qUe//5d+g/9NQRB43nX0d2lzc/PlsPUx+ruEbpWwLbY7gB9v
Ohz9MC+b4KVmwN5r+Va5dg79zc+p5+dUOo/W8XMnsK2EjEe/XAbHl/DjEyOO
L+K1T2JbSXmcx5gGZRbwOi62mGzGKVB6Hi99SUGl38/jJ+lnFW3UCqtUqbUN
tXpzeAx2NEnP8qo+v9j/Sp3/zQ/63/nIlueu2/L9T2354af952/yf77C/9Ua
n5Wxa0pY25Oh5qu5Hqa2lNU8eUdtbm9tbv+83IH5/rML/PhAL671/3CX/8p6
//W7c39vy0ENeWO+T6MpYWdMHySZNMluJdmdtbkHa3OPasG/Ghv8ZS340c7c
f3qzxwey7EqyepNWdLie3kw7ek0LSXeRzDlqeA00vEE19GTfAg0n0+lTfpoG
sFsBddTwlpc6rlxDUo0k3UrS3SQzRDIZkr33LNTc6f85Sk0ufWZrqsTRNy4C
Re/hLQPtNpsWu4mMLCejt4CsjVxWFmTlpKynQdYXUNa1hcnq4LLe2Zyh4VBW
sH002Dni0HYhaJvBtZWxrTm02A1kM8q7laTWheQ9UJt7aF7usXm+krcM5H3U
Je82Td5GTd6wJu8+Ji/Ys5mGtu9sVDiNX08Y1ebSYg1k+EZTZBtJ95DMMMlm
SXZbhMhvFSDybyDy31Rkf/ZtKfIeJTJ4aBjuAGhMFMpVTuXtCKPrfFA5KIXe
TEZvI6n1TGgmSugYFfqBaKGrNaEbXEKzmtDdI1RosH8oeHwAdWI/nMxbsopt
LQSNAw1kCGV+RshsApm9JLOZZHOazMfPQeablsxtqWDHKJf5CJU5SMWgUmxN
e4YAxYtBcZ8legUZXQuiN5mid9XmHjZFf80l+mem6L9I0d3Roh/cjKKDA/1S
N8x7cL/LWXRxA+mWem/gekep3ttJqtnUe1+03u/G6F3H9f5T6h1iet/Npk9v
EXp3aXqf6g8O9th6dS8A7bwE2rnHlD5Cpa8kKZTeTjJ9JDNiSZ/vPxMv/WYl
/U9SenuE9PuF9H1DwWMovVe2drVSb3iRStVPqP5+uAeV/lUkdQdJbdD0+y79
Xyxcf6vQ3yf0Z6j+dHCv0L9X6H+yP3im98yznfYYBz0Fx5AYjwOj89IG0mFy
sbFF5+ogmX6SGRVcu2tz+wrj+iVw/d7k+lcermHFdbhLXhpvopPI6Zqwp3U2
kN4w1GqSupOk7jahthcJ9VsKdQeH+itCdWWPMagsh/IF1AMC6lEKNSCh7Csx
3klnO5FSN91wUXRHXHQ/cNI1G3THB0267YLuYaB7YiB4uu/M4e5jR1oLo7P9
Xomi63LSUcN1F0lTuk6SGQC6LRrdE+eFLg10WwXdHqQb4nSHuo8fabP7XJWT
Du6tej1j0cgG9GkcPRslaxFkKUG256zIXgWyf2wCsl5OhvZWOjdOth/IDjCy
k2Ob7P5W6SQDx7RMbjeQFm1GsrEaAQv9OmLdXyDWjQLrVsBqVFhHLayciSU9
CsPqOT3WHrqPkGuStbfC5mrTZ1rLHqLzl1z3mFwHKddCg+t7guvHJtcf83Jx
7yW5BhnXwZ4zYx2hO6jCyQW0dbjdQNpjoNaJdMaCeiQC6jkX1O8kVAtAdWZl
mncylTacr+bU0ETQmawwJrjnltJtAOoJA6HplJkGZovnEYhnaamMAtJdnLAW
FAhHAvv+CRHBGLlEm4t1e6esvkicOM6OMM6SaJxVBs7rJg7P7rjhN00e4oDT
KLd0lxVGM6jTrLBpspjKU5q9QPMkpVlg09i30Cr/N5TmdkUDiwpZIxnULbbu
+4S/KI7GthTo/zBVkGkYJrWMplbRHFrgf7ZwmiZJw1NbTBioiz2ju1hlLDiN
vTqVjKZZGkWzUkt8MKnEhQ25ziRpvkRp6ougeSNEc9pNw43EW0c2wsidEFm6
V22RgMutM+2Csnoyr8CUSJLsdJF8vSAS3yDpN0l0w6dbokPd7xxpC9TqUfgK
xXMNWDYIfbnOlRVrPMj1lMn17Q8B18cNrl9oXK808SU5K/k33LniUpbh3bF2
scaTl2k8Z2qF+ceBtVpLozCDzWpLV+eOpZJBiaV7POWE2NRq30mJWKZNlgGy
/LhMDeUqglyOy8v007Nm0m3QweKZ2p2mDl24zDFkuo7LOYUwPe9iei2KSWYa
hrVTbqFoJodVWM4zC5U3RTItynedbjGZ9DUfncmyq8oB9UYyTYwYIzqimGRO
IZl8bdmtWCb22KBJW8y0knhft6rC1SnXEJqZCmHqdzI1ijxJX5KQTAfm+4cX
+J87ByaZB56ymCwnFJ5tY5iWwWzrcEIymWjRslq5fASruIrpy0sjmJabTGLR
GdfvZG5rpBQ7BJPph47ROdf2RPFc1tyr/KrMJ7rcXH6xXHIxHReRbC7LhHMu
OgNTLpa2u5/dFcqF7kilFZILk1q53FcU10uSa0M8l/Cvlkc61H1ibFOBXDAG
1otkPc7GbjTz9e3nC63LhbYthCZM06mxdjfZBa4rVi/SdYezWKmRdf+fyHqz
nucZKa5OJu1glL+IIZsbnosti9ukpYUpbVGsKLJfU7K1nEyt1SIZPJu6wMin
dEcorROuShTBNjuGbZVgo2mVTBLPhm0lZ3tZY0swooky5VWJiO4HwTu5fUYM
06yoOVla9yYtVZSrEk6mb+RjohSUCZ7jX3i0S2Tyw5mTKUZmZCUKS1ubKIJr
ZgzXai0lCXPtEw+g2ANxjYuK5lzXcy66h3J5+GYDLq7jupgEO5HK0HSLSdPB
dF/o9BsxXDXa3BzHhalW2lzrU1yLHVz0C+UCmqkvrVUPeDiWWHmh2daJ0Qxk
kUBmWUPNcniVFkFJNNf0KK7lwsNvMFPj/FzwLkvZT5b7L8h7CpCAMIlrL/Qb
8uCoMV4B7daAhN94k/oN+1oh0wRrLzBOc/oNi6ldY9qqM83nTFQWZcJe9l69
B0qyF+XFas7RQvxiidSY7kHPi0O+7Q8pG3iOtx2eI4ZtSgwbeHmVR0q2HYKN
KqFsQHSlPWhc7/9Ioq0pAo1eNibRtlP8WUFhZLA9Wcv6o+BYwA6RJCMc3UPh
LmZMl7yqxKoc0RAL3o8FRrGaR3LNSTFqq0U+L50EeiRla3W1Xhn9etGhF/A9
r0lKmHibiJvSXSMszL58PiBG14TQXKlsKY2DaQSb18qoGnhriH5CJ2ef7Jkj
e3+NfU/gPvwHM+EE6llsrbpncc6BMVorzVybzeu0evSZEN7SQb+Ua2rhIKdg
NNCvq3RHxeIJ24EztD0yjgN14113Wpk+k+GbP0zK+LyaqoWWcnQ+rF5qEuRs
WpgG2E7ik22qBF8/gR0X5FXAeppXzs6FuZxVGjk3xEQvxeiiV3il2BDspzqk
IcmvxBT+6SXpTMsqlBmj3TPckStckRNylmJ7HD2XfS3hKsK69FJT2a8kH5NB
myvrc2tLOrThWi2Oyh5XZypIRLZVOf+8VJSgoeiUcCI8blp6uAQWO+GJdyIh
a+vyRMvk0XCNaBfmbcfaI1oAnqAlZEQer4LHa+PDRiHx5mjxxHUeR7+zOOFY
+MPWGEQbw8iZxLpkpY44c6045aE49lWFlemEBPTEexdaz+LXqcTucWcR3R4J
E564gJoApwIRCdtGjN/EilgWishGM/kGaF5OfXuJ2A7w7Zpw3fYaKtRYpsfA
36Vc7TLBgce5KrNO1malujpRN1xwFcssIfu9pr9O3OuB+GEUiVDECisS3NNJ
nYKdV6L1RnN2ZHvrtLaSLZGUannsEt4cXLAxhljx7VaUz1AUX70V035uVKKR
RlCG+gPrKYk8cRJOtkKj2O9Z2L3Qbkm8P2X5IniSgXorXI+w1Ipg/82C6ofg
LfhnhanDcc0reTw8/7JA/ysKFX2RdVaVcdaMUJSFvIdNNK7m5XYr0hLzHDUn
hAL5JritZw6vv5KXxqfbNaYO3gazuLdhZVgHwLeartDamR29gteY5DXiG5Mz
LcVi9prG6xRPcfFN+qsC9fck7FaYQEuVibmA7p8KpWZZddrvhbDSVVwvqxv/
VuVqq5TdI6t5aWgDb3ag3xWqVBVXchWUmhO47okKXtM1UGYur0l/g7uE10Kg
BOFbC/HSj/sf4ZES+w==\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, {1, -1}, None},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->716359988]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25135],

Cell[TextData[{
 "Draw the axis edge that is the intersection of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane and the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SubscriptBox["z", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->197471206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "None", ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162534289],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->{{1, 1}, None, None}]], "Output",
 ImageSize->{154, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->725859737,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "Draw the axis edge that is the intersection of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SubscriptBox["y", 
     StyleBox["min", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SubscriptBox["z", 
     StyleBox["max", "TI"]]}], TraditionalForm]], "InlineMath"],
 " plane:"
}], "ExampleText",
 CellID->530379811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None", ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127219369],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  AxesEdge->{{-1, 1}, None, None}]], "Output",
 ImageSize->{154, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->391453014,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747423784],

Cell[TextData[{
 "Four different positions for the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->170259671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"None", ",", "None", ",", "e"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4903241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, 1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1m3mQFNUdx5vdGRZYWFiEQFQEVEJK6d0FvAjhMjGkYkYUUURERFjZg73v
Y2ZnZgVREA8E8QJBd01i7lSSSlKVVOWPpJJULk1iQm5jzKHGlUtg6Ure+/3e
/bp7e3YJpbMz3a/f+37ee/36+/t1d2JTc0V5zabmys2bZq1s3FRfUbm5adYn
6hrJpvxRjuOUk/9bpjvk+3/JN/i/3PM8ssP6vJF85pMCefQX/eLBPyePfJ0E
JT5t7MmnHzH523Emwp8byCfdnB+xfNR6o5a73ihXEPG4ZbQHysvLoSz5SzeO
Jh+0B/hf7Ikl9BctGcfj8R/dMBs2LGb740rLdO8s2Hsda6dA10G2zIT917Cj
C42jce9CdnShNl4ol369GErNZ3WA3rhog9UUYzTqCFGCPNEXpez4YrVkXLTC
yxs9Gzd+j4dy85jiKUZrQr02FuZoYR1XMD3TjL14vKSPqunDrL7pjC+u9KIf
WT4rh70zhxHRoyb6aI7x3lLBLCVFsP0ypoS2QAfKmXi4LNu/IPvy1dkvL8p+
fUn2W8t7v/vx3u9/svcHN/b+ZFX256uzr96efW1d9uiG7J/uyULn5XlylvLe
wDlZwPZgW7OY7jw2d5zp2930rpLMYyWZ/aWZZ8uyh+frTa8Ia/r1zdm/b838
syrzdm0mJnpBjgWMlXOJwkeVOJc0uT0dbrrHTe9w07uh8SfVxq9hjX87qPG7
tMbfqsm825A+1pw+2d4j+sBScbGpYuZ9bqrG7SFaOt10mmrJqFqOzM++NJSW
33Atf1W0/Ae0wJnk5J9OpdjaEDdUfQBUfZCNB8yXuaTYWje50U2itGZd2uPR
pd0WKO295vSJtjRpiCg7m0md254EpTFD3VRQN82TqxjwXLra7b4DFG51U7Vc
YcZNP6AofI4r/Hx0hfdpCqGt0UKht7Pb29UtVitT5VSmEsa9hBRb5Xbe7Hah
1HsUqV1c6sO+Uj+So9R6qzPvZ1K9PV0+amH1cyZ7ytp/BSmWcDuE4HVUcKoC
BLdYgg/ogr8SIPgVXfAbRHClJThJBeMcRcHeY51szoqlg/XvJNa/Y/kcTbjt
N+miN4HoOi46OwLRf7RFN7GzacLpZA/5Q7v5gSRdRUG1t6/DO9AmL5LkH/b0
BNbT42RPtwnpt7hdt7rdd4L0SpDe6vZ0g/SdIH1v6fCl/0ORfqI1faoT1iVn
jKn8CaK83edaMxn0F7J+Hy/1t9gI693kvYBQH46w0AfhhzdmCcLPVISNPgjH
W9NwrSgY7OX6H+b6n2zXZg39vAC+jmXq4bpzZcJtUtR3rnK7bnG711jqk1z9
HlD/VGnmYFn2hSjq7zDV/3sbVT8A6k919KDKsZRgByd4lBOQnwebGYc8X4uB
Y4zKMQ9GgaC0AkrHTXAOIMpdbnKzm6oClDZA6dVQsojymQCUH9so90qUdxQU
PBcGe1MayV5O8lyLd7hJng6TBQVno1snsFFpSLjNNs1tCk2DQvMg0DwxLJq/
EJpyk4aNypk0u0p6D3arON7TbXBawOxipkaOiuL6uFfGsyQIKrnBTW5xU9UR
oL5wrR/UTRLqdzZUHV63ik520FWKMOEQaUz7272n2ugQPd907oV607lPlGya
06YjBqvYkoRbm3AbOV+7yne75OshfO1uT4rzPRKBjyxnQ/INNKaPt6QZX09q
MMv5dnd5jyh8zzI+OQuLrVnoce+u/C5gs9JkXKUw3u0my4GxkTKmCeP9I2b8
G2GskIw45yYwwu2CsMt7vFMSHiKEDTJSkBRFvqymGwA/+FGYr3WA22LjruW4
23Tch4Jxv5E77rEW6pzFkDLDJYD3IXCrd6j53JGG033bTBJYSyzvb/rdWARe
tJbIizHCcHhv4bzrs3/gvG8y3sy7Ou9ZwbtL4T0geQf7aqLxmlEHHOUCb71+
9etQ/SmafcHbw3kfLcnsK808XZo9FI3318h7t+T9V3Xmbc7L/NOZlArcrfon
7xkEbjzXV2tFA+N9ic3feXKEA4nB4CZF5IXE2y3iF1XipbkQ10IsyEfY9uUa
8MHmc4cpcDReOKOXq+tywq2Cq00Ia2orD+UE664RsP55k8VK414jBklKVjA4
yOoR1hfrzPOy0JcVvH6Z+J1wt1mgnWhBV4OLRlAREZqgZQz0szmBbjFB0S0g
KDMMD/HYhXwn/gfdAsFUVx2Fa5wvLWxdir8Tbo3uIIRflQGDipoeFuov11DU
30rUrIqqxpVawKOYVuKN0Ef4ZDyQ0tw6nlMCYqNhktCSC8QKHXGHL+JVFuLK
QMTXCeJWhqjlIZJ+iHtNxIH+SpNnrC8lrM6u7iFMq75ej1glYsn5QKzKvMUR
cd0twrhVi54sO0i2H++v8l1z/BlLh2S8l4e2GJWrOa79pZlnQhiDZyoyGukk
EuAi6RgzvuKMGFsRw3Sqr9rvahnOWRfkeTFQMTgzFufzCudXQzjXapwybVZv
co6X0ZdufekW8A1n+mpMB1gQzDgvxBSRuAWDMREldykpN5WxTzAuHg4jzeA6
47RYzDKBbBz7apl6kyaEcYliC3x8vRo+Yx5jhIy/9x1HTMjYEdpu3f6pbohe
MfGukCeiUOQ0r6XAuTThVhgOyEDFMA1ja5GyCUL94pCodwaikghbC9ZMZ6/7
oBfr8jwlG216W3/akoRbHeSBMIJRg9I2PUElMtrnhdaM2gIsH9ogJ4/nYKNx
LuW+wN/rrVUCU5Fc+H9wDlijatp5zfE1EdSxw6BU3Y8Wr6jxqJrlUikPC8rr
IlBu4JQ8sf5OdMqnW0UuJQdK+8oZGJVB1B1G+bmhKH9lU1ZqlMwjhGLKlNGx
/irzuhJCuszXIwjjvs4kTacikH7TIv2pTspuzgGpzPYZUTcYvhDQk/3VVg4l
nLQuwNSasViTQvogz88eGC4p3hIyU2RIKiIyQvqQlQVkWbKG9/u2OebsxccK
zHW4yMcP+dh3lbRDSZHtUW4JqKRfi0z6hk4qMgtFp4dEPdREXNHZvpocSBfa
rkg4PzUWq9GzJzZpPyG9eqSkakYB48w4YlKvhOaPuaMjDWiQrPkbwrrMdke+
EUutkkuIwvqdEbOSQWWBtjKodAukyGjsRjxStFGFM3U5ZE0CraAIXSr0fIIP
7HwG+6WhYF8LgOXJQJk+IfGLvA1BfD0YQroFrqcU1r6ehrCW2YkT3dqz8MVm
FSnP88sqz9a0wqqY3+GzLrcdUlAYo4bd27X0Lrtb2b9gJKyQ9FTvdIPRt1g7
IrGa2V84W1coPsnH9aLH32yF3+eNlSfwaYK3gbHS4JQHNf6sxC0dbKGsL9QP
9Fda52wsmDfMMUXmzQrel0N5fxHAK9Jj8MSTcdeQoO6x70mDkzjeX5UL6/xw
VnT6W5RQtUtPAoazfo+z/khnPbqBPj7A7rfZqUB41rCIDq4d21jW6VRfdQ68
ruUnWHJXjWxs3h3D5r2d827UUvdwO9eZRKYx+RvNDdMsSw6kVwQ4Jy26wRvE
aqJFzX3iDahIpLdyUn7bDXIIU2T6E/IQ73dT3EBWxTsN9tXmwDoXLrHCO5l+
WNxpw3hVJFx2uBmb9aVw1ps567osyHCmqbcoKGyThCUDS4posKZRbEYDFXDO
+t5tnaPnXKSBUgOAjXqALoFLIgDfwIETFBg5Lzx6lzmJKbCSekFgEu5QvTt9
nbFMNOXAOxuyLkGGkd6oUEM7g3d3NF48H2eIsbVhjTyTgCWOkeoNgsX8Sw60
l/g6CyMUuEcJZNv0/GEILYzjbDq0n2JDOyTvgMrLHbIPr5FvGmeQ5QfzXhTu
pNbwIO8+PRGjJhHx7iJ7eGoBm6+Xy7m8UgN+1QbG+xgGcFePGudR1YpLVoBp
1ikH3ulwxR2aF0M9kZKxeTFLKwbXGUNdwAzxoC6j25J5006otZt0ZDipTCtT
SukgDWPN4BDCKbanMOKA9XowqxLS83A0vbly5BUPiKbK9FGLpZyns6kCplzL
k53or85FeXG4GyKu3lKedsQ7FEQx+c+ZRj7AsxUTtae4WrxXJHwqbdiyMn65
EfaooZKNh3ccivx8jKmUxFoOPuQ3m2iCKL4IQyEpBa6/tGbda/jkLgKUFIYr
IW4ZKpnLFRTShvmFX2sYLvx+18KAlgv4VV91OB2wkrukNbx/LgwGPdK45ppn
bZ7VDjyjFjdieGvEy3hrBbga0oNZO76rYUA7+Rg/08rBAZPfbej5nat5C3HC
QI8RV5ah66YzGxTHJIHjLKLC4xgU0oLhtelPUGBtnnx8oIlqW8xrhOrIqlj/
nk/cZddI70vExH0YXB0p6lJaXwzrw8Bm6LpiTN0YWVcjrWsZrYu950QChiBV
8hlLT751ROupw8F2liv10F1mPaOgHloNrCfKHBFHDvbV0O7zP9J6PlKpYYXR
tplv4zXgyEMIZdRwPa8BiwTUYDrsQqOWjxm1mPeVWB94xltd6tHaW2Dm/VM8
3veeuVmP9aaXmS3HugqYlpHU4ZsvCegVMaOMNWwU+UlrwxrNcy0WMlpyvz5n
9Rr5M/SmthVGTbA/rs51WHOgjgk+rfjOY7Yf3+oT5cvxbSt8A4u/gaQev9Q4
Xu1XqWKSpVA7i0OPLfY9dolxLO8rPGay+ktRe51xFKfC/p5i9hUpeK1xBO3P
mDhiakA7C9j6Pp6VxmzcNL1vPXwvqZSVHcfK4pNB0z39ja8rWSk6PrQz8DnO
C31Gl8qYw0qPZnXic/QXGaXpDKSn7gx2LY+z0vh2F3/njJ5l9KSaTEqNZgsS
VQBtw/tx1jMUGmOxUjO+AzqT1WyuNBewUpdBqdnGXnMdm8h0zIXSl3rq/NRX
O1rnPCh1ua6O9TbdUAb75xgzMMbauAr2foh8jia/FuEcHPU/EgkvYw==\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {-1, -1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    Axes->True,
    AxesEdge->{None, None, {-1, 1}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->106763226]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17520],

Cell["Use fixed axes for 3D:", "ExampleText",
 CellID->64291483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"AxesEdge", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".5", "]"}]}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77180366],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239120603]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17728],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", the axes are placed on one of the exposed bounding box edges:"
}], "ExampleText",
 CellID->441868806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cuboid", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesEdge", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"vp", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->795724999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{CuboidBox[{0, 0, 0}], CuboidBox[{1, 1, 0}, {3, 3, 2}]},
    Axes->True,
    AxesEdge->Automatic,
    ViewPoint->{2, -2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{0, 0, 0}], CuboidBox[{1, 1, 0}, {3, 3, 2}]},
    Axes->True,
    AxesEdge->Automatic,
    ViewPoint->{-2, 2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9WtuS00YQFbZk+bK21/Z6b+zNe2PZ5RJCimsIIVQBSYAUxRdsUVsFD6mk
CI+85wsoXvNN+R9Vou7pllpHo7UXKFy1a0vqOed0T0/PSJpnx+9en/x+/O7N
q+Otx2+P/3z95tVfW4/+eJueqp8LguBj+vf3cpD+/i/9xX8fkyRJL5j/36f/
a+mlZvpdT7+f89m79D9MDxP+pD/a9FXPz/z6mXZN4a3iawHO0zPx+b1yHv8k
117y0QM5CuonJyeB+7zgKz+WuGrA5VB/EIQ6HUUpSqIfwvqNv+9BS7atZ7aM
TBjPMvVqTRihx9peN7ExHBG0iuD6z9zqtomUtW7IeWd1S+Los6LzT9jqghx1
gakFrbBv6ZgCfYtRDuBqW5TMAYqetxkQVKK0xLoLKB0PCv286UVpwjGioedo
f8OLqrGeB7ReoW+moURiPQCUvpznLCrk862s1+h6A/AQZwDXNWdvM8plOVqA
VkM5f4+tLgEGWi/A9Tvc6sgodyO0isUNLGfo2l6UK6oWWy4WvDgoxihH/fBe
UIfQftnbNxTTIM4Uu//PLhNIquTDe18/LRkksnMZuAf6a4TCVh/ekypCs/w9
QF0Ffd8x6i4njPWT6wxg10UpYp4XLQ6LIhLqyIrA5yACzAj0dgB7HfTSuKXD
PcYbQYx09Gp0GsDWEA+QZcPDYo85PqVsbBk2Pp+yESGyNsFHrJqbguNnHcPZ
2NtXLeBsiafINQE0HOV+Tq0lGtc2sHXAQ5xrtj14ZVYeS4WK1Ej8EUb+OfEW
eXekvZ9vlJhKV4poFzh64GMNuPaK6gV7n9Fw1PEoAvy++IC4+9CWaxLXmbqp
cATWB8SBUUyrmQNp4xCWvF4PAGOoGE5QcAhq3Dhc9Pg3BKQRI7lVlfZBGJRX
UflYQ/9GPsSQhHE5Tj+TxFTF0Fk6ZGqW93rZ77EPO3LYcir9bEIeWh5nUgdv
Jg4/THSqyupnMVrIv6DRMnWd7LTWRkXmQu7kyLom4sol68Zy/dIY02dpio4Q
RoHOl3HFXGGxW8UREkhflHQ1vT20PEVZJIxZ7ZI+QmXsQQm9abQ5tdiT2byR
V0FP/FamqIwhfvOJv6JGnvjFHr7yKo5XriX1VZV0mt6m6OhDO9SLfmnVnVUv
5kDozYG1KWrboEJ7CGt505sD4Rn0Fke0nUXpmFDWp2jtmBmaV/sejbYCMkVS
XtfWKxQqLvb4NF1diGEI7VEnxjzjLGiqiiPlNNb5zSkKe6ba0TfOC3Y1or2R
rQjlu5Ox11JgOjOZwjqv9aVi7WHntsUMXWdyMtiegcFGegHsu5IRPHO7nAvz
dcKXwS/20eJXYHIj6GswOUTNBFshNUvauQrTbztfQkPDepsrOW1VHH+yGl+e
9kzNM15/EQ20WqLLwxkiwaM9ykQIYvxJvMxXWKXRGBzM0h9TI6G11uVENDUz
iZVqSSTf/VlUeKoUaijdl86gpS8aWpAbc2eITB6cWpCvPWZV0APmtihCBXSX
4KrnP/8mrrmnOoxz1lOyYc5Enr7bwDUvXGFK5Z4gFtdY9H9hJqYOeDeA4xiY
e8LcJCcr5s7Z/WyJf2P5RrY5YeuIn36WsNSHyBML/orJbMvTUfuUhxzrgnfx
J/I2IJrn4bgGOlri70D8jUv5Q+Oq7hlf2ROSGVSFEoVN+UYVsagYQxTC0gyE
o7q8gotn1FQTLTsmQlxNRcuyRCQsReRMGkwu7pKCKFMgFXdfM0R41ygGBaus
wpZW3dFZmOWO94Q/B+qVOxTuTfHZPgn9bI/1CUgKeVFZXb9T9I23Z+ere3uZ
onmksyXVRudjsC3e6f2Ha2RXts0K1ImgEuKhVL6QczU9KSN4A9DdZ1SBuMWR
yd+T1aX1QTnb6EpquCYWuMoYVDBsiGZbZSLB2C+OK/FemTTzNSrGB9O3G8YD
wm5Lq12TO1nfGQ01iNtI2uET3IGXdc3j1RxUjQkoCME/rXWdmRhXPYx9QdgG
pgiYumLXLeZvUq6oPMYl5noPaHtzBfJlQZC3QEG2FqyIdlPa9ZOi71jd8dl2
vULXkic6i8KxAdr0rlqj0xC7QVK+qziLhrFHw6pgr4GGttHAKM5erHkF43++
NYOOBegjraaroGFOsyHnVvVioU/XMSKayVVZMvREYiIqlkEF5WSoxVYq5Njr
P/ZDlLObcTKEerAPo3IM/L73jri+0JWzn3He4+0F8RbZyDMe+4I4dBiR8z33
tefBPBLMEWAuCaZ9Jh2cgt2F/Pgmy/8i7gpEppuYt9Ee3I5H87fZOC9ir3o0
089+BXYbevVmVtGKuGugGWtrFX7To/32KSt9arYuPuhYlriEGXYgqzjA/d6z
pifrTcHDGcj3hqUWZBN8ga8BcXogXPj+cgJx4rEVw4iT2JSf+8nNVmHMhx5P
H2YzeJF9WzzVeQqfHJfXWT7GmofxsV0tG8Rd8BcZS/GtUtCwCtzakfieelas
ZLMnnuqTCC+vj8fuDQIfn5u8pP65KByleXxWLomqy5qX4smRiZii2dWYyz7l
pTMvMl0On94z0iHvgWEojYJG60qSV0OnxsbqCVi59V9krAhdc4x2q9T5jpqs
YjlSrPvGiteWbNUGxrtgxe98eZ60VjfBimsOvxG0jFr5Lsl53p/g1hjG6oqx
ovPuXeMIrA7BaoetxoKsd8Z7pufovHuvuwxYOg/rfEtGB2Lj3iqvQot1aYE7
3DS3+X0yV17baqVwn5C32hZ1vG+Id21YH3Q9GUOrLUG/yq0mwEXrYGqNu9I2
xO4at9qBVvpsBXehnRdN17nVHijU1SLuoFkR9Hwnl+WqSSvcD6Zzt9u3dQit
cGeSrh7cPijNLN8Khg55z2FwVdog1rycv89W1+TIu18tPXzAVtcF2bfjjg4f
stUNaYM7dFpy/hFb3UrsbJdb6fsct//wjiA3wCqU87+w1T1p49tVSefdHsz7
ia2Txfrq9nSSl1F65HaLBuf+BzI6ZaE=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{0, 0, 0}], CuboidBox[{1, 1, 0}, {3, 3, 2}]},
    Axes->True,
    AxesEdge->Automatic,
    ViewPoint->{2, 2, 2},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{491, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25375245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650711714],

Cell[TextData[{
 "In 2D, ",
 Cell[BoxData[
  ButtonBox["AxesOrigin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesOrigin"]], "InlineFormula"],
 " specifies where to draw the axes:"
}], "ExampleText",
 CellID->312308463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345832742],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesOrigin->{0, -1}]], "Output",
 ImageSize->{154, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->224232822]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6932],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesOrigin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesOrigin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26549]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16727],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78521365],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->423342153],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->67977032]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AxesEdge - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 17.2224868}", "context" -> "System`", 
    "keywords" -> {
     "axes position", "origin", "position of 3D axes", 
      "position of three-dimensional axes", "bounding box", "axis", "x axis", 
      "y axis", "z axis"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AxesEdge is an option for three-dimensional graphics functions that \
specifies on which edges of the bounding box axes should be drawn. ", 
    "synonyms" -> {"axes edge"}, "title" -> "AxesEdge", "type" -> "Symbol", 
    "uri" -> "ref/AxesEdge"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6815, 234, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->907163695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 136297, 2735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2087, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2710, 79, 46, 1, 70, "ObjectName",
 CellID->20267],
Cell[2759, 82, 521, 15, 70, "Usage",
 CellID->12341]
}, Open  ]],
Cell[CellGroupData[{
Cell[3317, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3795, 119, 1313, 46, 70, "Notes",
 CellID->617],
Cell[5111, 167, 300, 9, 70, "Notes",
 CellID->24968],
Cell[5414, 178, 666, 24, 70, "Notes",
 CellID->25065],
Cell[6083, 204, 481, 18, 70, "Notes",
 CellID->27321],
Cell[6567, 224, 211, 5, 70, "Notes",
 CellID->18655]
}, Closed]],
Cell[CellGroupData[{
Cell[6815, 234, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->907163695],
Cell[CellGroupData[{
Cell[7200, 248, 148, 5, 70, "ExampleSection",
 CellID->712177048],
Cell[7351, 255, 114, 3, 70, "ExampleText",
 CellID->913199839],
Cell[CellGroupData[{
Cell[7490, 262, 251, 7, 28, "Input",
 CellID->184914044],
Cell[7744, 271, 7374, 127, 194, 115, 3, "CachedBoxData", "BoxData", "Output",
 CellID->46840637]
}, Open  ]],
Cell[CellGroupData[{
Cell[15155, 403, 365, 11, 28, "Input",
 CellID->12504731],
Cell[15523, 416, 22071, 366, 164, "Output",
 Evaluatable->False,
 CellID->634715904]
}, Open  ]],
Cell[37609, 785, 124, 3, 70, "ExampleDelimiter",
 CellID->18540134],
Cell[37736, 790, 68, 1, 70, "ExampleText",
 CellID->40453982],
Cell[CellGroupData[{
Cell[37829, 795, 326, 10, 70, "Input",
 CellID->549021744],
Cell[38158, 807, 7172, 123, 181, 134, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->1907986]
}, Open  ]],
Cell[45345, 933, 124, 3, 70, "ExampleDelimiter",
 CellID->88821601],
Cell[45472, 938, 77, 1, 70, "ExampleText",
 CellID->373081102],
Cell[CellGroupData[{
Cell[45574, 943, 1199, 36, 70, "Input",
 CellID->55835140],
Cell[46776, 981, 14514, 250, 140, "Output",
 CellID->716359988]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61339, 1237, 216, 7, 70, "ExampleSection",
 CellID->25135],
Cell[61558, 1246, 413, 15, 70, "ExampleText",
 CellID->197471206],
Cell[CellGroupData[{
Cell[61996, 1265, 368, 12, 70, "Input",
 CellID->162534289],
Cell[62367, 1279, 7410, 127, 191, 126, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->725859737]
}, Open  ]],
Cell[69792, 1409, 409, 15, 70, "ExampleText",
 CellID->530379811],
Cell[CellGroupData[{
Cell[70226, 1428, 395, 13, 70, "Input",
 CellID->127219369],
Cell[70624, 1443, 7212, 124, 173, 127, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->391453014]
}, Open  ]],
Cell[77851, 1570, 125, 3, 70, "ExampleDelimiter",
 CellID->747423784],
Cell[77979, 1575, 166, 6, 70, "ExampleText",
 CellID->170259671],
Cell[CellGroupData[{
Cell[78170, 1585, 829, 28, 70, "Input",
 CellID->4903241],
Cell[79002, 1615, 18550, 319, 140, "Output",
 CellID->106763226]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97601, 1940, 223, 7, 70, "ExampleSection",
 CellID->17520],
Cell[97827, 1949, 64, 1, 70, "ExampleText",
 CellID->64291483],
Cell[CellGroupData[{
Cell[97916, 1954, 904, 29, 70, "Input",
 CellID->77180366],
Cell[98823, 1985, 22164, 367, 70, "Output",
 Evaluatable->False,
 CellID->239120603]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[121036, 2358, 233, 7, 70, "ExampleSection",
 CellID->17728],
Cell[121272, 2367, 253, 8, 70, "ExampleText",
 CellID->441868806],
Cell[CellGroupData[{
Cell[121550, 2379, 995, 31, 70, "Input",
 CellID->795724999],
Cell[122548, 2412, 9429, 168, 158, "Output",
 CellID->25375245]
}, Open  ]],
Cell[131992, 2583, 125, 3, 70, "ExampleDelimiter",
 CellID->650711714],
Cell[132120, 2588, 227, 8, 70, "ExampleText",
 CellID->312308463],
Cell[CellGroupData[{
Cell[132372, 2600, 314, 10, 70, "Input",
 CellID->345832742],
Cell[132689, 2612, 278, 9, 176, "Output",
 CellID->224232822]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133028, 2628, 310, 9, 70, "SeeAlsoSection",
 CellID->6932],
Cell[133341, 2639, 447, 17, 70, "SeeAlso",
 CellID->26549]
}, Open  ]],
Cell[CellGroupData[{
Cell[133825, 2661, 314, 9, 70, "TutorialsSection",
 CellID->16727],
Cell[134142, 2672, 192, 4, 70, "Tutorials",
 CellID->242403382]
}, Open  ]],
Cell[CellGroupData[{
Cell[134371, 2681, 318, 9, 70, "MoreAboutSection",
 CellID->78521365],
Cell[134692, 2692, 148, 3, 70, "MoreAbout",
 CellID->423342153],
Cell[134843, 2697, 174, 3, 70, "MoreAbout",
 CellID->67977032]
}, Open  ]],
Cell[135032, 2703, 27, 0, 70, "History"],
Cell[135062, 2705, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

