(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106788,       2481]
NotebookOptionsPosition[     99458,       2225]
NotebookOutlinePosition[    100779,       2263]
CellTagsIndexPosition[    100692,       2258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotLabel" :> Documentation`HelpLookup["paclet:ref/PlotLabel"],
           "FrameLabel" :> 
          Documentation`HelpLookup["paclet:ref/FrameLabel"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotLabel\"\>", 
       2->"\<\"FrameLabel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AxesLabel", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["AxesLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AxesLabel"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies \
labels for axes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->8339],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["label", "TI"], Cell[TextData[{
     "label for ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " in 2D or ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " in 3D "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "labels for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["y", "TI"]], ",", 
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["z", "TI"]]}], "}"}], Cell[TextData[{
     "labels for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "labels based on variables specified to ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     ", etc. "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 CellFrameLabels->{{None, None}, {None, None}},
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->20552],

Cell["\<\
By default, axes labels in two\[Hyphen]dimensional graphics are placed at the \
ends of the axes. In three\[Hyphen]dimensional graphics, they are aligned \
with the middles of the axes. \
\>", "Notes",
 CellID->26830],

Cell[TextData[{
 "Any expression can be specified as a label. It will be given by default in \
",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". Arbitrary strings of text can be given as ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20474]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345534271],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->80066861],

Cell[TextData[{
 "Place a label for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis in 2D:"
}], "ExampleText",
 CellID->684121894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"Sinc", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->882284872],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44268355]
}, Open  ]],

Cell[TextData[{
 "Place a label for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " axis in 3D:"
}], "ExampleText",
 CellID->97822314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"Abs", "[", "z", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->537177117],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55772623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->430353512],

Cell[TextData[StyleBox["Specify a label for each axis:",
 Deletable->True]], "ExampleText",
 CellID->5660721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700822432],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm]}]], "Output",
 ImageSize->{154, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->30390170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104675169],

Cell[TextData[{
 "Use labels based on variables specified in ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->597796483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"\[Theta]", " ", "\[Rho]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Rho]", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13529119],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89827965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318818776],

Cell[TextData[{
 "Overall style of all the label-like elements can be specified by ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->194566514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"2", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Bold"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558268740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143228976]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19634],

Cell[TextData[{
 "Labels use ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " by default: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20474]
}], "ExampleText",
 CellID->114355467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"Sinc", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294677654],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->827244249]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", instead:"
}], "ExampleText",
 CellID->137703732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"StandardForm", "[", 
     RowBox[{"Sinc", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353167244],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9591309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183673086],

Cell[TextData[{
 "Individually styled labels can be used together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->636303218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"x", ",", "Large", ",", "Bold", ",", "Red"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"y", ",", "Large", ",", "Bold", ",", "Blue"}], "]"}]}], 
     "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Bold"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86999437],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587922434]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25455],

Cell[TextData[{
 "Use labels based on variables specified in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->391124891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38939654],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303600967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245968933],

Cell["Any graphic can be used as a label:", "ExampleText",
 CellID->852294789],

Cell[BoxData[
 RowBox[{
  RowBox[{"label", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<radian\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", "Pink", ",", 
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"3", 
            RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->381434749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"label", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193825591],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->343747532]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30708],

Cell[TextData[{
 "The overall output format can be specified using ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41388345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36255446],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->650737227]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20800],

Cell["\<\
When different format types are combined the result is likely unpredictable: \
\
\>", "ExampleText",
 CellID->226240286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"TraditionalForm", "@", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41856964],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26466871]
}, Open  ]],

Cell["This is equivalent to: ", "ExampleText",
 CellID->106728617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23353568],

Cell[BoxData[
 TagBox[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}],
   TraditionalForm],
  TraditionalForm,
  Editable->True]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->166372388]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30518],

Cell["Use 3D graphics labels: ", "ExampleText",
 CellID->137244413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"Sphere", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"Cylinder", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126691370],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->552651136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57911686],

Cell["Use dynamic checkboxes as the axes labels:", "ExampleText",
 CellID->43286578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "=", "Automatic"}], ",", 
     RowBox[{"s", "=", "Automatic"}]}], "}"}], ",", 
   RowBox[{"Dynamic", "@", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], ",", 
          RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Labeled", "[", 
          RowBox[{
           RowBox[{"Checkbox", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "t", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"None", ",", "Automatic"}], "}"}]}], "]"}], ",", "x"}], 
          "]"}], ",", 
         RowBox[{"Labeled", "[", 
          RowBox[{
           RowBox[{"Checkbox", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "s", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"None", ",", "Automatic"}], "}"}]}], "]"}], ",", "y"}], 
          "]"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"t", ",", "s"}], "}"}]}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "40"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->616965123],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`t$$ = Automatic, $CellContext`s$$ = 
  Automatic}, 
  DynamicBox[ToBoxes[
    Show[
     Plot[{
       Sin[$CellContext`x], 
       Cos[$CellContext`x]}, {$CellContext`x, 0, 10}], AxesLabel -> {
       Labeled[
        Checkbox[
         Dynamic[$CellContext`t$$], {None, Automatic}], $CellContext`x], 
       Labeled[
        Checkbox[
         Dynamic[$CellContext`s$$], {None, Automatic}], $CellContext`y]}, 
     Ticks -> {$CellContext`t$$, $CellContext`s$$}, ImagePadding -> 40], 
    StandardForm],
   ImageSizeCache->{300., {106., 110.}}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{304, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->405352463]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10680],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameLabel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20781],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->461395077],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->67181257],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->71216409]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AxesLabel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 22.6445006}", "context" -> "System`", 
    "keywords" -> {
     "axis labels", "axis position in plots", "labeling of axes", "labels", 
      "labels on axes"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AxesLabel is an option for graphics functions that specifies labels for \
axes. ", "synonyms" -> {"axes label"}, "title" -> "AxesLabel", "type" -> 
    "Symbol", "uri" -> "ref/AxesLabel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11704, 320, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->345534271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 100548, 2251}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2462, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3085, 86, 4193, 83, 70, "ObjectNameGrid"],
Cell[7281, 171, 454, 14, 70, "Usage",
 CellID->7239]
}, Open  ]],
Cell[CellGroupData[{
Cell[7772, 190, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8250, 207, 68, 1, 70, "Notes",
 CellID->8339],
Cell[8321, 210, 2671, 83, 70, "2ColumnTableMod",
 CellID->20552],
Cell[10995, 295, 227, 5, 70, "Notes",
 CellID->26830],
Cell[11225, 302, 442, 13, 70, "Notes",
 CellID->20474]
}, Closed]],
Cell[CellGroupData[{
Cell[11704, 320, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345534271],
Cell[CellGroupData[{
Cell[12089, 334, 147, 5, 70, "ExampleSection",
 CellID->80066861],
Cell[12239, 341, 157, 6, 70, "ExampleText",
 CellID->684121894],
Cell[CellGroupData[{
Cell[12421, 351, 296, 9, 28, "Input",
 CellID->882284872],
Cell[12720, 362, 2562, 46, 140, "Output",
 Evaluatable->False,
 CellID->44268355]
}, Open  ]],
Cell[15297, 411, 156, 6, 70, "ExampleText",
 CellID->97822314],
Cell[CellGroupData[{
Cell[15478, 421, 457, 15, 28, "Input",
 CellID->537177117],
Cell[15938, 438, 14107, 235, 168, "Output",
 Evaluatable->False,
 CellID->55772623]
}, Open  ]],
Cell[30060, 676, 125, 3, 70, "ExampleDelimiter",
 CellID->430353512],
Cell[30188, 681, 109, 2, 70, "ExampleText",
 CellID->5660721],
Cell[CellGroupData[{
Cell[30322, 687, 291, 9, 70, "Input",
 CellID->700822432],
Cell[30616, 698, 341, 11, 173, "Output",
 CellID->30390170]
}, Open  ]],
Cell[30972, 712, 125, 3, 70, "ExampleDelimiter",
 CellID->104675169],
Cell[31100, 717, 222, 8, 70, "ExampleText",
 CellID->597796483],
Cell[CellGroupData[{
Cell[31347, 729, 388, 11, 28, "Input",
 CellID->13529119],
Cell[31738, 742, 21696, 360, 165, "Output",
 Evaluatable->False,
 CellID->89827965]
}, Open  ]],
Cell[53449, 1105, 125, 3, 70, "ExampleDelimiter",
 CellID->318818776],
Cell[53577, 1110, 252, 8, 70, "ExampleText",
 CellID->194566514],
Cell[CellGroupData[{
Cell[53854, 1122, 509, 16, 47, "Input",
 CellID->558268740],
Cell[54366, 1140, 2966, 53, 138, "Output",
 Evaluatable->False,
 CellID->143228976]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57381, 1199, 216, 7, 70, "ExampleSection",
 CellID->19634],
Cell[57600, 1208, 303, 11, 70, "ExampleText",
 CellID->114355467],
Cell[CellGroupData[{
Cell[57928, 1223, 296, 9, 70, "Input",
 CellID->294677654],
Cell[58227, 1234, 2563, 46, 70, "Output",
 Evaluatable->False,
 CellID->827244249]
}, Open  ]],
Cell[60805, 1283, 204, 8, 70, "ExampleText",
 CellID->137703732],
Cell[CellGroupData[{
Cell[61034, 1295, 338, 10, 70, "Input",
 CellID->353167244],
Cell[61375, 1307, 2545, 46, 70, "Output",
 Evaluatable->False,
 CellID->9591309]
}, Open  ]],
Cell[63935, 1356, 125, 3, 70, "ExampleDelimiter",
 CellID->183673086],
Cell[64063, 1361, 266, 8, 70, "ExampleText",
 CellID->636303218],
Cell[CellGroupData[{
Cell[64354, 1373, 626, 18, 70, "Input",
 CellID->86999437],
Cell[64983, 1393, 2872, 51, 70, "Output",
 Evaluatable->False,
 CellID->587922434]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67904, 1450, 239, 7, 70, "ExampleSection",
 CellID->25455],
Cell[68146, 1459, 343, 13, 70, "ExampleText",
 CellID->391124891],
Cell[CellGroupData[{
Cell[68514, 1476, 284, 8, 70, "Input",
 CellID->38939654],
Cell[68801, 1486, 2311, 42, 70, "Output",
 Evaluatable->False,
 CellID->303600967]
}, Open  ]],
Cell[71127, 1531, 125, 3, 70, "ExampleDelimiter",
 CellID->245968933],
Cell[71255, 1536, 78, 1, 70, "ExampleText",
 CellID->852294789],
Cell[71336, 1539, 706, 22, 70, "Input",
 CellID->381434749],
Cell[CellGroupData[{
Cell[72067, 1565, 425, 14, 70, "Input",
 CellID->193825591],
Cell[72495, 1581, 5681, 97, 70, "Output",
 Evaluatable->False,
 CellID->343747532]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[78225, 1684, 233, 7, 70, "ExampleSection",
 CellID->30708],
Cell[78461, 1693, 235, 8, 70, "ExampleText",
 CellID->41388345],
Cell[CellGroupData[{
Cell[78721, 1705, 406, 12, 70, "Input",
 CellID->36255446],
Cell[79130, 1719, 2758, 49, 70, "Output",
 Evaluatable->False,
 CellID->650737227]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81937, 1774, 226, 7, 70, "ExampleSection",
 CellID->20800],
Cell[82166, 1783, 130, 4, 70, "ExampleText",
 CellID->226240286],
Cell[CellGroupData[{
Cell[82321, 1791, 393, 11, 70, "Input",
 CellID->41856964],
Cell[82717, 1804, 2936, 52, 70, "Output",
 Evaluatable->False,
 CellID->26466871]
}, Open  ]],
Cell[85668, 1859, 66, 1, 70, "ExampleText",
 CellID->106728617],
Cell[CellGroupData[{
Cell[85759, 1864, 180, 5, 70, "Input",
 CellID->23353568],
Cell[85942, 1871, 282, 11, 50, "Output",
 CellID->166372388]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86273, 1888, 224, 7, 70, "ExampleSection",
 CellID->30518],
Cell[86500, 1897, 67, 1, 70, "ExampleText",
 CellID->137244413],
Cell[CellGroupData[{
Cell[86592, 1902, 696, 22, 70, "Input",
 CellID->126691370],
Cell[87291, 1926, 7182, 122, 70, "Output",
 Evaluatable->False,
 CellID->552651136]
}, Open  ]],
Cell[94488, 2051, 124, 3, 70, "ExampleDelimiter",
 CellID->57911686],
Cell[94615, 2056, 84, 1, 70, "ExampleText",
 CellID->43286578],
Cell[CellGroupData[{
Cell[94724, 2061, 1435, 43, 70, "Input",
 CellID->616965123],
Cell[96162, 2106, 815, 23, 70, "Output",
 CellID->405352463]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97038, 2136, 311, 9, 70, "SeeAlsoSection",
 CellID->10680],
Cell[97352, 2147, 456, 17, 70, "SeeAlso",
 CellID->9790]
}, Open  ]],
Cell[CellGroupData[{
Cell[97845, 2169, 314, 9, 70, "TutorialsSection",
 CellID->20781],
Cell[98162, 2180, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[98303, 2185, 192, 4, 70, "Tutorials",
 CellID->242403382],
Cell[98498, 2191, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[98692, 2199, 319, 9, 70, "MoreAboutSection",
 CellID->461395077],
Cell[99014, 2210, 172, 3, 70, "MoreAbout",
 CellID->67181257],
Cell[99189, 2215, 174, 3, 70, "MoreAbout",
 CellID->71216409]
}, Open  ]],
Cell[99378, 2221, 50, 0, 70, "History"],
Cell[99431, 2223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

