(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143902,       3187]
NotebookOptionsPosition[    135748,       2906]
NotebookOutlinePosition[    137047,       2944]
CellTagsIndexPosition[    136960,       2939]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Styles and Fonts in Output" :> 
          Documentation`HelpLookup["paclet:tutorial/StylesAndFontsInOutput"], 
          "Graphics Directives and Options" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsDirectivesAndOptions"], 
          "Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Styles and Fonts in Output\"\>", 
       2->"\<\"Graphics Directives and Options\"\>", 
       3->"\<\"Options for Cells\"\>", 4->"\<\"Options for Notebooks\"\>", 
       5->"\<\"Tables and Matrices\"\>", 
       6->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       7->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prolog" :> Documentation`HelpLookup["paclet:ref/Prolog"], 
          "PlotRegion" :> Documentation`HelpLookup["paclet:ref/PlotRegion"], 
          "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], "Item" :> 
          Documentation`HelpLookup["paclet:ref/Item"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "WindowOpacity" :> 
          Documentation`HelpLookup["paclet:ref/WindowOpacity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Prolog\"\>", 
       2->"\<\"PlotRegion\"\>", 3->"\<\"ImageMargins\"\>", 4->"\<\"Item\"\>", 
       5->"\<\"Pane\"\>", 6->"\<\"Style\"\>", 
       7->"\<\"WindowOpacity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"Font Options\"\>", 
       4->"\<\"Graphics Annotation & Appearance\"\>", 
       5->"\<\"Graphics Importing & Exporting\"\>", 
       6->"\<\"Graphics Options & Styling\"\>", 7->"\<\"Grids & Tables\"\>", 
       8->"\<\"Layout & Tables\"\>", 
       9->"\<\"Notebook Formatting & Styling\"\>", 
       10->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       11->"\<\"Window Properties\"\>", 
       12->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Background", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Background",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Background"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies what background color to \
use. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15026]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " can be any color or opacity specification. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7886],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " is an option to such functions as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1935],

Cell[TextData[{
 "When an object has option ",
 Cell[BoxData[
  RowBox[{"Background", "->", 
   StyleBox["color", "TI"]}]], "InlineFormula"],
 ", the specified color will normally be used as a background throughout the \
region defined by the object. "
}], "Notes",
 CellID->12733],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"Background", "->", 
     StyleBox["color", "TI"]}]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["color", "TI"]], "InlineFormula"],
 " should be used as the background only for the region defined by the \
bounding box of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10724],

Cell[TextData[{
 "In constructs such as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " can be used to specify that a background should fill the complete region \
for a particular item."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->183932353],

Cell["\<\
In a cell, the background is used only for the region inside any cell frame.\
\>", "Notes",
 CellID->15596],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Background", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no background should be used, so that in effect the \
background is transparent."
}], "Notes",
 CellID->78852],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Background", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies a background that follows the system appearance for the \
particular object or window used. For ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"Background", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that the background should be taken from the graphic in which it \
appears."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->188016608],

Cell[TextData[{
 "For objects such as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " can be a list that specifies backgrounds for individual columns, rows or \
elements. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15292]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325422178],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->148360695],

Cell["Insert a background color behind any expression:", "ExampleText",
 CellID->247288071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256355563],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}],
  StripOnInput->False,
  Background->RGBColor[1, 1, 0]]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116640863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140093365],

Cell["A background for graphics:", "ExampleText",
 CellID->560168594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Circle", "[", "]"}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414622450],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Background->RGBColor[0.87, 0.94, 1]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->37146038]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207599346],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], SphereBox[{0, 0, 0}]},
  Background->RGBColor[1, 0.85, 0.85]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->524534226,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21341],

Cell["Draw a grid with a light red background:", "ExampleText",
 CellID->13842222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717991278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gXTi/5s3YSQTUJgJyALRnFCaVnxGsI0MrBAKSEIYDNwgmgVZiHYiTBBf
Q13ESyLNTAXdg8L/dI/1RLLI0dQ5mjpHU+do6hxNnaOpczR1DoXUCWpfMjAC
AKzpMI8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600829084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478509987],

Cell["Draw the first item with a light blue background:", "ExampleText",
 CellID->632208948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}], ",", "b"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1949804956],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Background->RGBColor[0.87, 0.94, 1],
      StripOnInput->False], "b"},
    {"c", "d"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414773671]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5635],

Cell["\<\
Light blue and light red backgrounds for the first and second horizontal \
positions:\
\>", "ExampleText",
 CellID->946257814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"LightBlue", ",", "LightRed"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1855750711],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl00OgjAQhae0RYwaty65hhfAlYeYEBNYGA1y2W48gzeorz9LowsxGjMk
5Zt5LUyZ9C3Y89gdjjz2Lde7gc9d317q5jRA0oqIGGO7IcQeURzsPbi83vza
O9c8yAosK6AElqDGTNQyS1BjZdIS52/mKlYmi3IA7imgGWhQj0zYu3MhhAqY
8ERU44VgMZFSpC7kDlSgzV9egTbvePWCesK3/FRfvnY6np3Zz2fiCnGFuEJc
Ia4QV4grxBX/5or0X0DqDtq3uqQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->761223245]
}, Open  ]],

Cell["\<\
Light blue and light red backgrounds for the first and last horizontal \
positions:\
\>", "ExampleText",
 CellID->1638673863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"LightBlue", ",", 
        RowBox[{"{", "}"}], ",", "LightRed"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1538714088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlzsOgkAQhmdfgK/ekmt4AS2Mh9gQEyiMBrnsNpzBG6z/PioLLcRozJAs
38y/hBkm+xcc7NAeT3boGlvventpu+Zab889JCWIyGJt1oTYI4rLeg8ux5vf
I5p75x4ziccklMACVNiJWubszbwAFSolLVHEymRQDsA9BVSCOnSsQ+/xQrCY
SCkBHSpH1bnUhExTyBOoQJM7X71gBZr8RWrCt/zUXL52Op6d2c9n7Ap2BbuC
XcGuYFewK9gV/+aK9F9A4g4eZrqk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452465394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1861326313],

Cell["\<\
Light blue and light red backgrounds for the first and second vertical \
positions:\
\>", "ExampleText",
 CellID->482528275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"LightBlue", ",", "LightRed"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554886156],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlEEKgzAQRSeJLoq479Jr9ALtqocIUtBFabFeNpueoTdIvzNZpBShgrEu
FJz38yGTjDN4tn1zudq+rW116uy9aetHdbx1sIwiIov3sCdoD8Wv9R6Mo4at
oQbuAlOtFZ9IucDzA0HFwCy20jlaqg43KifSzLB7FfUv3vXvyfslbtO5Ted/
p9O58Sh5nJO8wlRrxSeiOwxEEfiGYBZb6RwtVYcblRNpZti9ivoX7/roFD5f
fjxyHijOG5hqrfhEygWIIqgYmMVWOkdL1eFG5USaGXavov7Fu/4xefIbV2+A
LnOn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->965700296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21555281],

Cell["Alternating light blue and light red backgrounds:", "ExampleText",
 CellID->954466853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"LightBlue", ",", "LightRed"}], "}"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1930194792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl00KwjAQhaf5qUWEbl32Gl5AVx4iFKFdiFJ72Ww8gzeIL00QcSMohaHM
Iv2GeUPIz/RBjm7sTmc39q1rDoO7dn17a/aXASldEJHD2G0JcUA0DRcCuLk/
Qh28rz+4Br+pCtMoRJElqKFMucwS1Fmfq66YVkI2Ad8U0Ao0qCcT9+p9DJEF
TKww78Vz1ap0SnmlFWjzTirQ/pjXM87K+hzZdNs//8zyVD73wrp7xQXEBRas
8rkX1t0rLiAusGCVz72w7l5xAXGBl5re4VQ8AT0M1RY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102625979]
}, Open  ]],

Cell["\<\
Alternating background with pink superimposed in the first and last \
positions:\
\>", "ExampleText",
 CellID->1502355071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"LightBlue", ",", "LightRed"}], "}"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Pink"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Pink"}]}], "}"}]}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448480217],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl0sKwjAQhidNWosI3brsNbyArjxEKEK7EKX2AL1mNp7BG8Q/D6U7hSoM
JYv0G/5JZ/KYDvSoh/Z01kPX6PrQ62vbNbd6f+khSUFEGmO3JdgWlh/aWnBj
x7GyxlT3h51yDf2TN0OYDJZjAUp4ghZYgBJveC2yAGfNi/leeYVfCeUBeAaD
VqDCfFJONsaZTjVGIbJXQWdCBX4w12VW00Vk4ZTiSkswjzspwTzutAS/0mMc
+ceorM+RTbXN+WaW5+VzL6yrN3WB1AUW7OVzL6yrN3WB1AUW7OVzL6yrN3WB
1AXe3vAfTuIJ56w1wg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252375681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174397539],

Cell["Set the background for a subregion of the grid:", "ExampleText",
 CellID->1095244621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "LightRed"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452610656],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+VBSK3/N2+ak8SCmH3zJsQuCI2LzwakmamVam/eBAXk
zZsQBjBsgTQLshCmCDuQYqFyyoX4jBeN5gDSrESmXkpNGDRhMSApgfQUO5qy
R1P2aMoeTdmjKXswpWxI+4OBEQBLtPe2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71559293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23277],

Cell["Show a table with alternating row background colors: ", "ExampleText",
 CellID->103672631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"LightRed", ",", "LightBlue"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43433215],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"3", "3", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"4", "6", "4", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"5", "10", "10", "5", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"6", "15", "20", "15", "6", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
     "0"},
    {"7", "21", "35", "35", "21", "7", "1", "0", "0", "0", "0", "0", "0", "0",
      "0"},
    {"8", "28", "56", "70", "56", "28", "8", "1", "0", "0", "0", "0", "0", 
     "0", "0"},
    {"9", "36", "84", "126", "126", "84", "36", "9", "1", "0", "0", "0", "0", 
     "0", "0"},
    {"10", "45", "120", "210", "252", "210", "120", "45", "10", "1", "0", "0",
      "0", "0", "0"},
    {"11", "55", "165", "330", "462", "462", "330", "165", "55", "11", "1", 
     "0", "0", "0", "0"},
    {"12", "66", "220", "495", "792", "924", "792", "495", "220", "66", "12", 
     "1", "0", "0", "0"},
    {"13", "78", "286", "715", "1287", "1716", "1716", "1287", "715", "286", 
     "78", "13", "1", "0", "0"},
    {"14", "91", "364", "1001", "2002", "3003", "3432", "3003", "2002", 
     "1001", "364", "91", "14", "1", "0"},
    {"15", "105", "455", "1365", "3003", "5005", "6435", "6435", "5005", 
     "3003", "1365", "455", "105", "15", "1"}
   },
   ColumnsEqual->False,
   GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {{
        RGBColor[1, 0.85, 0.85], 
        RGBColor[0.87, 0.94, 1]}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{459, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651178026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22278],

Cell["Background color can be seen through a transparent object:", \
"ExampleText",
 CellID->103358547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Red", ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0, 0], Opacity[0.5], DiskBox[{0, 0}]},
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->112919484]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4711],

Cell["Show 3D objects against dark background: ", "ExampleText",
 CellID->392397919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   FormBox[
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"y", "^", "4"}], "+", 
      RowBox[{"z", "^", "4"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], ")"}]}], "\[Equal]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}],
    TraditionalForm], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#2", "2"], "+", 
       SuperscriptBox["#3", "2"]}], "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"Specularity", "[", 
         RowBox[{"White", ",", "50"}], "]"}]}], "]"}], ",", "None", ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Yellow", ",", 
        RowBox[{"Specularity", "[", 
         RowBox[{"White", ",", "50"}], "]"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "35"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", ".3", "]"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".1", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393380368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 326},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->621940820]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24837],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prolog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prolog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowOpacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowOpacity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29710]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9527],

Cell[TextData[ButtonBox["Styles and Fonts in Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StylesAndFontsInOutput"]], "Tutorials",
 CellID->10807],

Cell[TextData[ButtonBox["Graphics Directives and Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsDirectivesAndOptions"]], "Tutorials",
 CellID->12027],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->1920],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Background",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Background"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->417036788],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->89995263],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->230968738],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->163183303],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->509653200],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->281344965],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->49179320],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->279379143],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->766262487],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->367449058],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->516657703],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->48104980],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->659318432]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Background - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 30.8322102}", "context" -> "System`", 
    "keywords" -> {
     "background color", "table bacground", "graphics background", 
      "cell background"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Background is an option which specifies what background color to use. ", 
    "synonyms" -> {}, "title" -> "Background", "type" -> "Symbol", "uri" -> 
    "ref/Background"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15972, 438, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->325422178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 136816, 2932}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5212, 108, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5835, 135, 4194, 83, 70, "ObjectNameGrid"],
Cell[10032, 220, 448, 14, 70, "Usage",
 CellID->15026]
}, Open  ]],
Cell[CellGroupData[{
Cell[10517, 239, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10995, 256, 365, 11, 70, "Notes",
 CellID->7886],
Cell[11363, 269, 1058, 40, 70, "Notes",
 CellID->1935],
Cell[12424, 311, 281, 8, 70, "Notes",
 CellID->12733],
Cell[12708, 321, 667, 22, 70, "Notes",
 CellID->10724],
Cell[13378, 345, 536, 17, 70, "Notes",
 CellID->183932353],
Cell[13917, 364, 117, 3, 70, "Notes",
 CellID->15596],
Cell[14037, 369, 291, 9, 70, "Notes",
 CellID->78852],
Cell[14331, 380, 814, 24, 70, "Notes",
 CellID->188016608],
Cell[15148, 406, 787, 27, 70, "Notes",
 CellID->15292]
}, Closed]],
Cell[CellGroupData[{
Cell[15972, 438, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325422178],
Cell[CellGroupData[{
Cell[16357, 452, 148, 5, 70, "ExampleSection",
 CellID->148360695],
Cell[16508, 459, 91, 1, 70, "ExampleText",
 CellID->247288071],
Cell[CellGroupData[{
Cell[16624, 464, 227, 7, 28, "Input",
 CellID->256355563],
Cell[16854, 473, 283, 10, 36, "Output",
 CellID->116640863]
}, Open  ]],
Cell[17152, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->140093365],
Cell[17280, 491, 69, 1, 70, "ExampleText",
 CellID->560168594],
Cell[CellGroupData[{
Cell[17374, 496, 228, 7, 70, "Input",
 CellID->414622450],
Cell[17605, 505, 279, 8, 121, "Output",
 CellID->37146038]
}, Open  ]],
Cell[CellGroupData[{
Cell[17921, 518, 293, 9, 70, "Input",
 CellID->207599346],
Cell[18217, 529, 12898, 217, 129, 120, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->524534226]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31164, 752, 216, 7, 70, "ExampleSection",
 CellID->21341],
Cell[31383, 761, 82, 1, 70, "ExampleText",
 CellID->13842222],
Cell[CellGroupData[{
Cell[31490, 766, 289, 9, 70, "Input",
 CellID->717991278],
Cell[31782, 777, 402, 11, 70, "Output",
 Evaluatable->False,
 CellID->600829084]
}, Open  ]],
Cell[32199, 791, 125, 3, 70, "ExampleDelimiter",
 CellID->478509987],
Cell[32327, 796, 92, 1, 70, "ExampleText",
 CellID->632208948],
Cell[CellGroupData[{
Cell[32444, 801, 371, 13, 70, "Input",
 CellID->1949804956],
Cell[32818, 816, 426, 16, 48, "Output",
 CellID->414773671]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33293, 838, 238, 7, 70, "ExampleSection",
 CellID->5635],
Cell[33534, 847, 136, 4, 70, "ExampleText",
 CellID->946257814],
Cell[CellGroupData[{
Cell[33695, 855, 413, 14, 70, "Input",
 CellID->1855750711],
Cell[34111, 871, 483, 12, 70, "Output",
 Evaluatable->False,
 CellID->761223245]
}, Open  ]],
Cell[34609, 886, 135, 4, 70, "ExampleText",
 CellID->1638673863],
Cell[CellGroupData[{
Cell[34769, 894, 447, 15, 70, "Input",
 CellID->1538714088],
Cell[35219, 911, 483, 12, 70, "Output",
 Evaluatable->False,
 CellID->452465394]
}, Open  ]],
Cell[35717, 926, 126, 3, 70, "ExampleDelimiter",
 CellID->1861326313],
Cell[35846, 931, 134, 4, 70, "ExampleText",
 CellID->482528275],
Cell[CellGroupData[{
Cell[36005, 939, 409, 14, 70, "Input",
 CellID->554886156],
Cell[36417, 955, 520, 13, 70, "Output",
 Evaluatable->False,
 CellID->965700296]
}, Open  ]],
Cell[36952, 971, 124, 3, 70, "ExampleDelimiter",
 CellID->21555281],
Cell[37079, 976, 92, 1, 70, "ExampleText",
 CellID->954466853],
Cell[CellGroupData[{
Cell[37196, 981, 442, 15, 70, "Input",
 CellID->1930194792],
Cell[37641, 998, 499, 12, 70, "Output",
 Evaluatable->False,
 CellID->102625979]
}, Open  ]],
Cell[38155, 1013, 132, 4, 70, "ExampleText",
 CellID->1502355071],
Cell[CellGroupData[{
Cell[38312, 1021, 669, 22, 70, "Input",
 CellID->448480217],
Cell[38984, 1045, 536, 13, 70, "Output",
 Evaluatable->False,
 CellID->252375681]
}, Open  ]],
Cell[39535, 1061, 125, 3, 70, "ExampleDelimiter",
 CellID->174397539],
Cell[39663, 1066, 91, 1, 70, "ExampleText",
 CellID->1095244621],
Cell[CellGroupData[{
Cell[39779, 1071, 610, 20, 70, "Input",
 CellID->452610656],
Cell[40392, 1093, 486, 12, 70, "Output",
 Evaluatable->False,
 CellID->71559293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40927, 1111, 223, 7, 70, "ExampleSection",
 CellID->23277],
Cell[41153, 1120, 96, 1, 70, "ExampleText",
 CellID->103672631],
Cell[CellGroupData[{
Cell[41274, 1125, 558, 19, 70, "Input",
 CellID->43433215],
Cell[41835, 1146, 1902, 44, 244, "Output",
 CellID->651178026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43786, 1196, 233, 7, 70, "ExampleSection",
 CellID->22278],
Cell[44022, 1205, 103, 2, 70, "ExampleText",
 CellID->103358547],
Cell[CellGroupData[{
Cell[44150, 1211, 551, 17, 70, "Input",
 CellID->16585],
Cell[44704, 1230, 430, 13, 123, "Output",
 CellID->112919484]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45183, 1249, 223, 7, 70, "ExampleSection",
 CellID->4711],
Cell[45409, 1258, 84, 1, 70, "ExampleText",
 CellID->392397919],
Cell[CellGroupData[{
Cell[45518, 1263, 1801, 53, 70, "Input",
 CellID->393380368],
Cell[47322, 1318, 81673, 1343, 70, "Output",
 Evaluatable->False,
 CellID->621940820]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129056, 2668, 311, 9, 70, "SeeAlsoSection",
 CellID->24837],
Cell[129370, 2679, 1672, 62, 70, "SeeAlso",
 CellID->29710]
}, Open  ]],
Cell[CellGroupData[{
Cell[131079, 2746, 313, 9, 70, "TutorialsSection",
 CellID->9527],
Cell[131395, 2757, 159, 3, 70, "Tutorials",
 CellID->10807],
Cell[131557, 2762, 170, 3, 70, "Tutorials",
 CellID->12027],
Cell[131730, 2767, 142, 3, 70, "Tutorials",
 CellID->1920],
Cell[131875, 2772, 155, 3, 70, "Tutorials",
 CellID->232099468],
Cell[132033, 2777, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[132183, 2782, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[132489, 2793, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[132672, 2801, 305, 8, 70, "RelatedLinksSection"],
Cell[132980, 2811, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133382, 2828, 319, 9, 70, "MoreAboutSection",
 CellID->417036788],
Cell[133704, 2839, 149, 3, 70, "MoreAbout",
 CellID->89995263],
Cell[133856, 2844, 149, 3, 70, "MoreAbout",
 CellID->230968738],
Cell[134008, 2849, 135, 3, 70, "MoreAbout",
 CellID->163183303],
Cell[134146, 2854, 175, 3, 70, "MoreAbout",
 CellID->509653200],
Cell[134324, 2859, 171, 3, 70, "MoreAbout",
 CellID->281344965],
Cell[134498, 2864, 162, 3, 70, "MoreAbout",
 CellID->49179320],
Cell[134663, 2869, 140, 3, 70, "MoreAbout",
 CellID->279379143],
Cell[134806, 2874, 142, 3, 70, "MoreAbout",
 CellID->766262487],
Cell[134951, 2879, 169, 3, 70, "MoreAbout",
 CellID->367449058],
Cell[135123, 2884, 209, 5, 70, "MoreAbout",
 CellID->516657703],
Cell[135335, 2891, 144, 3, 70, "MoreAbout",
 CellID->48104980],
Cell[135482, 2896, 171, 3, 70, "MoreAbout",
 CellID->659318432]
}, Open  ]],
Cell[135668, 2902, 50, 0, 70, "History"],
Cell[135721, 2904, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

