(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50336,       1829]
NotebookOptionsPosition[     39907,       1457]
NotebookOutlinePosition[     41224,       1495]
CellTagsIndexPosition[     41138,       1490]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/OutputFormatsForNumbers"],
           "Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Output Formats for Numbers\"\>", 
       2->"\<\"Digits in Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "IntegerString" :> 
          Documentation`HelpLookup["paclet:ref/IntegerString"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerDigits\"\>", 
       2->"\<\"IntegerString\"\>", 3->"\<\"RealDigits\"\>", 
       4->"\<\"NumberForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Number Digits\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BaseForm", "ObjectName",
 CellID->20620],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BaseForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BaseForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with the numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " given in base ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The maximum allowed base is 36. For bases larger than 10, additional digits \
are chosen from the letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->564251392]
}], "Notes",
 CellID->14838],

Cell[TextData[{
 "You can enter a number in an arbitrary base using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["base", "TI"], "^", 
   RowBox[{"^", 
    StyleBox["digits", "TI"]}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->78804805]
}], "Notes",
 CellID->19232],

Cell[TextData[{
 "When a number in an arbitrary base is given in scientific notation, the \
exponent is still given in base 10. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->274784463]
}], "Notes",
 CellID->21119],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 " and related functions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->109346987]
}], "Notes",
 CellID->30337],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->23566]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->521391432],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->356364688],

Cell["A binary integer:", "ExampleText",
 CellID->590290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"33", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->807465692],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"100001\"\>", "\<\"2\"\>"],
   33,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->109348612]
}, Open  ]],

Cell["A binary real:", "ExampleText",
 CellID->31234976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", "5", "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112456828],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"11.110101111001110011\"\>", "2"],
   3.842234583168551,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//BaseForm=",
 CellID->98054293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->564853668],

Cell["Represent single digit hexadecimal numbers:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->564251392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "15"}], "]"}], ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599952762],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV9tOwkAQ3Xa33Aw3Y6T1kvARJCb6rk9+RENM4MFokO+UT6rddlbL6RR2
F9EEEtjO7czZmdm2PKfrxctrul7O0+nTKn1fLOcf08e3Va6SgRDBpxBiGIv8
Osuviq/+bPKvEEr/SqPLRDv/iXJRyMJcfNCnz/hEFj6IMziRXD58TjVXaZKg
7RWj9S2X4QSifcN8He3wURY+Bmd8Yrlc+JxaLpyuMOOmS8vSeFsitbJyluWO
GJx/mxjM0/Hg1qWY0IFb2yOPD7cOU/vf5MjVXBq9JUfzDHOpX0QxLtx8au7D
TceoP5hV/nQV2ggQSi9V1YbEQq9dwOC9W7S2PTJ0PGLOGmP+g83xamRiehnT
yUY+PhmOHXMwNzjhzd54X1ONfOonJsyYTvJsa9qxVSx6KdbrojkvvMW1zB3I
E2PgsMNzrmY1r5EDov0+bRFdso8gT8R6DX8d0W4GcOqDzP6errV6ys2b2ZCJ
qtqRN9prna/Y+O64IPAzyHKsnWM3DF0HxegHO/T7UQdMP90rZP7X7uudBPsh
z/4EvK5BTihHsl170khatQEj44q9nnfCamPKhnfhy2YMmKjYapfcafCt2A3I
VyBXWXLxKN9a7Z3f51bN1U9OUbBSlQqb//3YqYiZ5kOq08xzdyyHhZV1wea1
M0C8Bxnt/Nxw58/UM6STIakHkmRzplRFP6H6J+A/I/8HWu9I34e8ZUv15cbi
SgRfbk5LsQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->60708447]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3834],

Cell["Represent a random number in bases 2 through 36:", "ExampleText",
 CellID->334341233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38259211],

Cell[BoxData["0.21138595642564528`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557275868]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BaseForm", "[", 
    RowBox[{"num", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2", ",", "36"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->189159971],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{569, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72222725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->515723751],

Cell["A complex number formatted in base 3:", "ExampleText",
 CellID->351015136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"RandomComplex", "[", "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332811861],

Cell[BoxData[
 TagBox[
  RowBox[{
   InterpretationBox[
    SubscriptBox["\<\"0.2222110121012\"\>", "3"],
    0.9934154184156008,
    AutoDelete->True], "+", 
   RowBox[{
    InterpretationBox[
     SubscriptBox["\<\"0.2020110001122\"\>", "3"],
     0.7462554596673463,
     AutoDelete->True], " ", "\[ImaginaryI]"}]}],
  BaseForm[#, 3]& ]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->651259073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327995091],

Cell["An arbitrary precision number in base 5:", "ExampleText",
 CellID->534950284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "20"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->257343884],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"3.032322143033432411241224042\"\>", "5"],
   3.14159265358979323846`20.,
   AutoDelete->True],
  BaseForm[#, 5]& ]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->41395950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489077040],

Cell["A vector of reals in base 8:", "ExampleText",
 CellID->519887544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179441338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.563171540115787`", ",", "4.047457231341833`", ",", "5.4649850387629195`",
    ",", "9.159431252958012`", ",", "8.296562732075456`"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->804864830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"v", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->450045706],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     SubscriptBox["\<\"7.44026\"\>", "8"],
     7.563171540115787,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"4.030231\"\>", "8"],
     4.047457231341833,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"5.356045\"\>", "8"],
     5.4649850387629195`,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"11.1215\"\>", "8"],
     9.159431252958012,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"10.22766\"\>", "8"],
     8.296562732075456,
     AutoDelete->True]}], "}"}],
  BaseForm[#, 8]& ]], "Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//BaseForm=",
 CellID->373431405]
}, Open  ]],

Cell["A matrix:", "ExampleText",
 CellID->92701300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74627261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "6.715899175112607`", ",", "9.960964479756926`", ",", 
     "3.7708938786313917`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.773255058147234`", ",", "2.059738827608202`", ",", 
     "9.788761068208927`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.5889896817888065`", ",", "5.4163727393879775`", ",", 
     "2.536086075712276`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{584, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->198005800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"m", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->378569007],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      InterpretationBox[
       SubscriptBox["\<\"6.556425\"\>", "8"],
       6.715899175112607,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"11.75401\"\>", "8"],
       9.960964479756926,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"3.612545\"\>", "8"],
       3.7708938786313917`,
       AutoDelete->True]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      InterpretationBox[
       SubscriptBox["\<\"1.61372\"\>", "8"],
       1.773255058147234,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"2.036454\"\>", "8"],
       2.059738827608202,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"11.62366\"\>", "8"],
       9.788761068208927,
       AutoDelete->True]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      InterpretationBox[
       SubscriptBox["\<\"4.45544\"\>", "8"],
       4.5889896817888065`,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"5.325136\"\>", "8"],
       5.4163727393879775`,
       AutoDelete->True], ",", 
      InterpretationBox[
       SubscriptBox["\<\"2.422364\"\>", "8"],
       2.536086075712276,
       AutoDelete->True]}], "}"}]}], "}"}],
  BaseForm[#, 8]& ]], "Output",
 ImageSize->{457, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//BaseForm=",
 CellID->12445119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63773576],

Cell["\<\
A mixed symbolic and numeric expression with numbers represented in base 12:\
\>", "ExampleText",
 CellID->431764751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"3.3", 
    RowBox[{"Sin", "[", 
     RowBox[{"50", "+", 
      RowBox[{"x", "/", "7"}]}], "]"}]}], ",", "12"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373647218],

Cell[BoxData[
 TagBox[
  RowBox[{
   InterpretationBox[
    SubscriptBox["\<\"3.3724a\"\>", "12"],
    3.3,
    AutoDelete->True], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     InterpretationBox[
      SubscriptBox["\<\"42\"\>", "\<\"12\"\>"],
      50,
      Editable->False], "+", 
     FractionBox["x", 
      InterpretationBox[
       SubscriptBox["\<\"7\"\>", "\<\"12\"\>"],
       7,
       Editable->False]]}], "]"}]}],
  BaseForm[#, 12]& ]], "Output",
 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->459045816]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31041],

Cell["Exponents are given in base 10:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->274784463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"10.", "^", "6"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272969801],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{
    SubscriptBox["\<\"2.24\"\>", "5"], "\[Times]", 
    SuperscriptBox["5", "\<\"8\"\>"]}],
   1.*^6,
   AutoDelete->True],
  BaseForm[#, 5]& ]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->3019159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646066114],

Cell["Input a number in base 16:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->78804805],

Cell[CellGroupData[{

Cell[BoxData["16^^612ad"], "Input",
 CellLabel->"In[1]:=",
 CellID->96273967],

Cell[BoxData["397997"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258607454]
}, Open  ]],

Cell["Output in base 16:", "ExampleText",
 CellID->111553781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"%", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->528227941],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"612ad\"\>", "\<\"16\"\>"],
   397997,
   Editable->False],
  BaseForm[#, 16]& ]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//BaseForm=",
 CellID->1033696422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38548823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " formats numbers in a given base:"
}], "ExampleText",
 CellID->328840501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"123456", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164913425],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"11110001001000000\"\>", "\<\"2\"\>"],
   123456,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->885850546]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " gives a list of the digits:"
}], "ExampleText",
 CellID->410137043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"123456", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233016807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400572350]
}, Open  ]],

Cell["Convert back to base 10:", "ExampleText",
 CellID->443458358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->61655630],

Cell[BoxData["123456"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->247436123]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerString"]], "InlineFormula"],
 " gives the digits as a string:"
}], "ExampleText",
 CellID->13818765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{"123456", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->172221886],

Cell[BoxData["\<\"11110001001000000\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->548778110]
}, Open  ]],

Cell["Convert the string back to a base 10 number:", "ExampleText",
 CellID->123672312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->376583142],

Cell[BoxData["123456"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->472338461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440313466],

Cell["Format a real number in base 2:", "ExampleText",
 CellID->915898932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"123.456", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169281202],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{
    SubscriptBox["\<\"1.1110110111010011\"\>", "2"], "\[Times]", 
    SuperscriptBox["2", "\<\"6\"\>"]}],
   123.456,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->47938095]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " gives a list of the digits and number of digits to the left of the \
decimal:"
}], "ExampleText",
 CellID->6713627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"digits", ",", "intdigits"}], "}"}], "=", 
  RowBox[{"RealDigits", "[", 
   RowBox[{"123.456", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->230524122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0",
      ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", 
     ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", 
     ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", 
     ",", "1", ",", "1", ",", "1"}], "}"}], ",", "7"}], "}"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93742320]
}, Open  ]],

Cell[TextData[{
 "Reconstruct the base 10 number from ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " output:"
}], "ExampleText",
 CellID->232942659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"digits", ".", 
   RowBox[{"(", 
    RowBox[{"2", "^", 
     RowBox[{"(", 
      RowBox[{"intdigits", "-", 
       RowBox[{"Range", "[", 
        RowBox[{"Length", "[", "digits", "]"}], "]"}]}], ")"}]}], ")"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->659518838],

Cell[BoxData["123.456`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->40387550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350847786],

Cell["Convert a number to base 2:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->109346987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"base2", "=", 
  RowBox[{"BaseForm", "[", 
   RowBox[{"21.345", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34042227],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"10101.010110000101001\"\>", "2"],
   21.345,
   AutoDelete->True],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->3124541]
}, Open  ]],

Cell[TextData[{
 "Represent the number precise to 3 decimal digits using ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->525729942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"base2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->798287918],

Cell[BoxData[
 TagBox[
  TagBox[
   InterpretationBox[
    SubscriptBox["\<\"10101.01011\"\>", "2"],
    21.345,
    AutoDelete->True],
   BaseForm[#, 2]& ],
  NumberForm[#, 3]& ]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//NumberForm=",
 CellID->74783557]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->130266516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{"base2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147196721],

Cell[BoxData[
 TagBox[
  TagBox[
   InterpretationBox[
    SubscriptBox["\<\" 10101.01011\"\>", "2"],
    21.345,
    AutoDelete->True],
   BaseForm[#, 2]& ],
  PaddedForm[#, 3]& ]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//PaddedForm=",
 CellID->15925370]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->78012947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EngineeringForm", "[", 
  RowBox[{"base2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35284212],

Cell[BoxData[
 TagBox[
  TagBox[
   InterpretationBox[
    RowBox[{
     SubscriptBox["\<\"10.10101011\"\>", "2"], "\[Times]", 
     SuperscriptBox["2", "\<\"3\"\>"]}],
    21.345,
    AutoDelete->True],
   BaseForm[#, 2]& ],
  EngineeringForm[#, 3]& ]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//EngineeringForm=",
 CellID->104246233]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21156529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{"base2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->128181515],

Cell[BoxData[
 TagBox[
  TagBox[
   InterpretationBox[
    RowBox[{
     SubscriptBox["\<\"1.010101011\"\>", "2"], "\[Times]", 
     SuperscriptBox["2", "\<\"4\"\>"]}],
    21.345,
    AutoDelete->True],
   BaseForm[#, 2]& ],
  ScientificForm[#, 3]& ]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//ScientificForm=",
 CellID->3788014]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6255331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AccountingForm", "[", 
  RowBox[{"base2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->422238937],

Cell[BoxData[
 TagBox[
  TagBox[
   InterpretationBox[
    SubscriptBox["\<\"10101.01011\"\>", "2"],
    21.345,
    AutoDelete->True],
   BaseForm[#, 2]& ],
  AccountingForm[#, 3]& ]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//AccountingForm=",
 CellID->526232938]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->606],

Cell["The base must be an integer between 2 and 36:", "ExampleText",
 CellID->67990391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"12345", ",", "37"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30843424],

Cell[BoxData[
 RowBox[{
  RowBox[{"BaseForm", "::", "\<\"basf\"\>"}], ":", 
  " ", "\<\"Requested base \\!\\(\\\"37\\\"\\) should be an integer between 2 \
and \\!\\(\\\"36\\\"\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/BaseForm/basf\\\", ButtonNote -> \
\\\"BaseForm::basf\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->8316121],

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"12345", ",", "37"}], "]"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->54157054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28297],

Cell["\<\
Expansions in different bases can be terminating or non-terminating for the \
same number:\
\>", "ExampleText",
 CellID->257804941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BaseForm", "[", 
     RowBox[{
      RowBox[{"1", "/", "2."}], ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "10"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143740566],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPwzAQdpO0pVSswAClPCZAQjwGEBMLTMBSWh5lqCqkgkBFhb/A7w52
HKfOxc3ZeZQUqJRc7upz7uX7Yl/2PgdPb73P536veTHqvQ+e+x/N8+GIiuwS
IWRIr69lQp9d+uRdQ9elNHq36N2mAxxKLUrLPt/1/iU2J+zORhKHM/xn+Xqk
LEvpM3lQa9vBOFIH/F0OGnPxvoCRMp9UQ0ST2eoEcZgUe34/8SN55HGnYN59
ZZaqEq9DLV/vUDOr0DsnC74y5vm7J9ojaTJPmaIYw35OFrxjbke0zq2pSu34
LMLqHGdVDM5FcoxaU5P4IPQZ8kWxQKzSBXfcS3Uo147vEkvAoxtPugjsaIfs
gN0iXPNtddTUvSBSix005sHK1XkrutJspf9mawBHJVgnSTVgJejgwBmYeSdG
Ogm1dfFAptHZk6L+dLuhWgo92kYzCL8rMsE6DezbLYZlEm9rWcUq3qS7CXpQ
OH/3UIuKgPpqafi7sO4mW/88J/F9adHPXyfgcMQR/chWjk7TX8aWoJUU6v23
pjr+u3C8EusB3zOY72DU9RfGGJH7rkYur8H8q570CmSpocwpo2U/C2koXIUr
qWti1qTMmzW11zE7zLy7IYoOgG+gHtQM35A3Lyoat3y+YJZvoBZPGzsxfh21
uLjYaiLd9GhaHIZ0y5sV3xGysXwntAyi2wrZperhTqCbqvfi6I70NH2Ujau3
FjoDXNP3qMbP4/WLHx/+yld6Z8e7JUbR/OZJIRaU1JGJ1FEFyeIs8uGMzBIe
ZoGn8vq3/lwENNfBL45A9d/jP+KxjF9Jzn9MqRdFjbMJZlM74GS71WcTAiM1
T5RRDDM/mYb1Yf4dBWdIb4PZSXcaDVhHj1I+Sekb1m7SPg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{111, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->147332311]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6102]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30432],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->17262],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->18534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->382895509],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->64678034],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->205947970]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BaseForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 37.2386242}", "context" -> "System`", 
    "keywords" -> {
     "binary numbers", "decimal", "hexadecimal numbers", "number base", 
      "octal numbers", "radix"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BaseForm[expr, n] prints with the numbers in expr given in base n. ", 
    "synonyms" -> {"base form", "^^"}, "title" -> "BaseForm", "type" -> 
    "Symbol", "uri" -> "ref/BaseForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5906, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->521391432]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40995, 1483}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2366, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2989, 83, 46, 1, 70, "ObjectName",
 CellID->20620],
Cell[3038, 86, 694, 23, 70, "Usage",
 CellID->28091]
}, Open  ]],
Cell[CellGroupData[{
Cell[3769, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4247, 131, 336, 11, 70, "Notes",
 CellID->14838],
Cell[4586, 144, 320, 12, 70, "Notes",
 CellID->19232],
Cell[4909, 158, 245, 7, 70, "Notes",
 CellID->21119],
Cell[5157, 167, 429, 16, 70, "Notes",
 CellID->30337],
Cell[5589, 185, 280, 8, 70, "Notes",
 CellID->23566]
}, Closed]],
Cell[CellGroupData[{
Cell[5906, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->521391432],
Cell[CellGroupData[{
Cell[6291, 212, 148, 5, 70, "ExampleSection",
 CellID->356364688],
Cell[6442, 219, 57, 1, 70, "ExampleText",
 CellID->590290],
Cell[CellGroupData[{
Cell[6524, 224, 128, 4, 28, "Input",
 CellID->807465692],
Cell[6655, 230, 291, 11, 50, "Output",
 CellID->109348612]
}, Open  ]],
Cell[6961, 244, 56, 1, 70, "ExampleText",
 CellID->31234976],
Cell[CellGroupData[{
Cell[7042, 249, 165, 5, 28, "Input",
 CellID->112456828],
Cell[7210, 256, 314, 11, 50, "Output",
 CellID->98054293]
}, Open  ]],
Cell[7539, 270, 125, 3, 70, "ExampleDelimiter",
 CellID->564853668],
Cell[7667, 275, 134, 2, 70, "ExampleText",
 CellID->564251392],
Cell[CellGroupData[{
Cell[7826, 281, 187, 6, 28, "Input",
 CellID->599952762],
Cell[8016, 289, 965, 20, 50, "Output",
 Evaluatable->False,
 CellID->60708447]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9030, 315, 215, 7, 70, "ExampleSection",
 CellID->3834],
Cell[9248, 324, 91, 1, 70, "ExampleText",
 CellID->334341233],
Cell[CellGroupData[{
Cell[9364, 329, 125, 4, 70, "Input",
 CellID->38259211],
Cell[9492, 335, 177, 5, 36, "Output",
 CellID->557275868]
}, Open  ]],
Cell[CellGroupData[{
Cell[9706, 345, 247, 8, 70, "Input",
 CellID->189159971],
Cell[9956, 355, 4826, 83, 70, "Output",
 Evaluatable->False,
 CellID->72222725]
}, Open  ]],
Cell[14797, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->515723751],
Cell[14925, 446, 80, 1, 70, "ExampleText",
 CellID->351015136],
Cell[CellGroupData[{
Cell[15030, 451, 163, 5, 70, "Input",
 CellID->332811861],
Cell[15196, 458, 492, 17, 50, "Output",
 CellID->651259073]
}, Open  ]],
Cell[15703, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->327995091],
Cell[15831, 483, 83, 1, 70, "ExampleText",
 CellID->534950284],
Cell[CellGroupData[{
Cell[15939, 488, 183, 6, 70, "Input",
 CellID->257343884],
Cell[16125, 496, 331, 11, 50, "Output",
 CellID->41395950]
}, Open  ]],
Cell[16471, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->489077040],
Cell[16599, 515, 71, 1, 70, "ExampleText",
 CellID->519887544],
Cell[CellGroupData[{
Cell[16695, 520, 154, 5, 70, "Input",
 CellID->179441338],
Cell[16852, 527, 327, 9, 36, "Output",
 CellID->804864830]
}, Open  ]],
Cell[CellGroupData[{
Cell[17216, 541, 127, 4, 70, "Input",
 CellID->450045706],
Cell[17346, 547, 831, 29, 50, "Output",
 CellID->373431405]
}, Open  ]],
Cell[18192, 579, 51, 1, 70, "ExampleText",
 CellID->92701300],
Cell[CellGroupData[{
Cell[18268, 584, 204, 7, 70, "Input",
 CellID->74627261],
Cell[18475, 593, 580, 19, 36, "Output",
 CellID->198005800]
}, Open  ]],
Cell[CellGroupData[{
Cell[19092, 617, 127, 4, 70, "Input",
 CellID->378569007],
Cell[19222, 623, 1513, 51, 68, "Output",
 CellID->12445119]
}, Open  ]],
Cell[20750, 677, 124, 3, 70, "ExampleDelimiter",
 CellID->63773576],
Cell[20877, 682, 127, 3, 70, "ExampleText",
 CellID->431764751],
Cell[CellGroupData[{
Cell[21029, 689, 235, 8, 70, "Input",
 CellID->373647218],
Cell[21267, 699, 602, 23, 65, "Output",
 CellID->459045816]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21918, 728, 233, 7, 70, "ExampleSection",
 CellID->31041],
Cell[22154, 737, 122, 2, 70, "ExampleText",
 CellID->274784463],
Cell[CellGroupData[{
Cell[22301, 743, 153, 5, 70, "Input",
 CellID->272969801],
Cell[22457, 750, 349, 13, 50, "Output",
 CellID->3019159]
}, Open  ]],
Cell[22821, 766, 125, 3, 70, "ExampleDelimiter",
 CellID->646066114],
Cell[22949, 771, 116, 2, 70, "ExampleText",
 CellID->78804805],
Cell[CellGroupData[{
Cell[23090, 777, 77, 2, 70, "Input",
 CellID->96273967],
Cell[23170, 781, 163, 5, 36, "Output",
 CellID->258607454]
}, Open  ]],
Cell[23348, 789, 61, 1, 70, "ExampleText",
 CellID->111553781],
Cell[CellGroupData[{
Cell[23434, 794, 128, 4, 70, "Input",
 CellID->528227941],
Cell[23565, 800, 297, 11, 50, "Output",
 CellID->1033696422]
}, Open  ]],
Cell[23877, 814, 124, 3, 70, "ExampleDelimiter",
 CellID->38548823],
Cell[24004, 819, 210, 7, 70, "ExampleText",
 CellID->328840501],
Cell[CellGroupData[{
Cell[24239, 830, 132, 4, 70, "Input",
 CellID->164913425],
Cell[24374, 836, 307, 11, 50, "Output",
 CellID->885850546]
}, Open  ]],
Cell[24696, 850, 215, 7, 70, "ExampleText",
 CellID->410137043],
Cell[CellGroupData[{
Cell[24936, 861, 137, 4, 70, "Input",
 CellID->233016807],
Cell[25076, 867, 365, 10, 36, "Output",
 CellID->400572350]
}, Open  ]],
Cell[25456, 880, 67, 1, 70, "ExampleText",
 CellID->443458358],
Cell[CellGroupData[{
Cell[25548, 885, 128, 4, 70, "Input",
 CellID->61655630],
Cell[25679, 891, 163, 5, 36, "Output",
 CellID->247436123]
}, Open  ]],
Cell[25857, 899, 216, 7, 70, "ExampleText",
 CellID->13818765],
Cell[CellGroupData[{
Cell[26098, 910, 137, 4, 70, "Input",
 CellID->172221886],
Cell[26238, 916, 183, 5, 36, "Output",
 CellID->548778110]
}, Open  ]],
Cell[26436, 924, 87, 1, 70, "ExampleText",
 CellID->123672312],
Cell[CellGroupData[{
Cell[26548, 929, 129, 4, 70, "Input",
 CellID->376583142],
Cell[26680, 935, 163, 5, 36, "Output",
 CellID->472338461]
}, Open  ]],
Cell[26858, 943, 125, 3, 70, "ExampleDelimiter",
 CellID->440313466],
Cell[26986, 948, 74, 1, 70, "ExampleText",
 CellID->915898932],
Cell[CellGroupData[{
Cell[27085, 953, 133, 4, 70, "Input",
 CellID->169281202],
Cell[27221, 959, 367, 13, 50, "Output",
 CellID->47938095]
}, Open  ]],
Cell[27603, 975, 257, 8, 70, "ExampleText",
 CellID->6713627],
Cell[CellGroupData[{
Cell[27885, 987, 219, 7, 70, "Input",
 CellID->230524122],
Cell[28107, 996, 809, 17, 54, "Output",
 CellID->93742320]
}, Open  ]],
Cell[28931, 1016, 230, 8, 70, "ExampleText",
 CellID->232942659],
Cell[CellGroupData[{
Cell[29186, 1028, 319, 11, 70, "Input",
 CellID->659518838],
Cell[29508, 1041, 164, 5, 36, "Output",
 CellID->40387550]
}, Open  ]],
Cell[29687, 1049, 125, 3, 70, "ExampleDelimiter",
 CellID->350847786],
Cell[29815, 1054, 118, 2, 70, "ExampleText",
 CellID->109346987],
Cell[CellGroupData[{
Cell[29958, 1060, 159, 5, 70, "Input",
 CellID->34042227],
Cell[30120, 1067, 302, 11, 50, "Output",
 CellID->3124541]
}, Open  ]],
Cell[30437, 1081, 242, 8, 70, "ExampleText",
 CellID->525729942],
Cell[CellGroupData[{
Cell[30704, 1093, 133, 4, 70, "Input",
 CellID->798287918],
Cell[30840, 1099, 332, 13, 50, "Output",
 CellID->74783557]
}, Open  ]],
Cell[31187, 1115, 182, 7, 70, "ExampleText",
 CellID->130266516],
Cell[CellGroupData[{
Cell[31394, 1126, 133, 4, 70, "Input",
 CellID->147196721],
Cell[31530, 1132, 333, 13, 50, "Output",
 CellID->15925370]
}, Open  ]],
Cell[31878, 1148, 191, 7, 70, "ExampleText",
 CellID->78012947],
Cell[CellGroupData[{
Cell[32094, 1159, 137, 4, 70, "Input",
 CellID->35284212],
Cell[32234, 1165, 412, 15, 50, "Output",
 CellID->104246233]
}, Open  ]],
Cell[32661, 1183, 189, 7, 70, "ExampleText",
 CellID->21156529],
Cell[CellGroupData[{
Cell[32875, 1194, 137, 4, 70, "Input",
 CellID->128181515],
Cell[33015, 1200, 408, 15, 50, "Output",
 CellID->3788014]
}, Open  ]],
Cell[33438, 1218, 188, 7, 70, "ExampleText",
 CellID->6255331],
Cell[CellGroupData[{
Cell[33651, 1229, 137, 4, 70, "Input",
 CellID->422238937],
Cell[33791, 1235, 341, 13, 50, "Output",
 CellID->526232938]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34181, 1254, 224, 7, 70, "ExampleSection",
 CellID->606],
Cell[34408, 1263, 87, 1, 70, "ExampleText",
 CellID->67990391],
Cell[CellGroupData[{
Cell[34520, 1268, 131, 4, 70, "Input",
 CellID->30843424],
Cell[34654, 1274, 417, 8, 70, "Message",
 CellID->8316121],
Cell[35074, 1284, 230, 7, 50, "Output",
 CellID->54157054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35353, 1297, 224, 7, 70, "ExampleSection",
 CellID->28297],
Cell[35580, 1306, 141, 4, 70, "ExampleText",
 CellID->257804941],
Cell[CellGroupData[{
Cell[35746, 1314, 313, 11, 70, "Input",
 CellID->143740566],
Cell[36062, 1327, 1126, 22, 70, "Output",
 Evaluatable->False,
 CellID->147332311]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37249, 1356, 311, 9, 70, "SeeAlsoSection",
 CellID->14694],
Cell[37563, 1367, 968, 35, 70, "SeeAlso",
 CellID->6102]
}, Open  ]],
Cell[CellGroupData[{
Cell[38568, 1407, 314, 9, 70, "TutorialsSection",
 CellID->30432],
Cell[38885, 1418, 160, 3, 70, "Tutorials",
 CellID->17262],
Cell[39048, 1423, 143, 3, 70, "Tutorials",
 CellID->18534]
}, Open  ]],
Cell[CellGroupData[{
Cell[39228, 1431, 319, 9, 70, "MoreAboutSection",
 CellID->382895509],
Cell[39550, 1442, 145, 3, 70, "MoreAbout",
 CellID->64678034],
Cell[39698, 1447, 137, 3, 70, "MoreAbout",
 CellID->205947970]
}, Open  ]],
Cell[39850, 1453, 27, 0, 70, "History"],
Cell[39880, 1455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

