(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72424,       2283]
NotebookOptionsPosition[     62892,       1955]
NotebookOutlinePosition[     64348,       1995]
CellTagsIndexPosition[     64262,       1990]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options for Cells\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>", 
       3->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlignmentPoint" :> 
          Documentation`HelpLookup["paclet:ref/AlignmentPoint"], "Alignment" :> 
          Documentation`HelpLookup["paclet:ref/Alignment"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"], "CellBaseline" :> 
          Documentation`HelpLookup["paclet:ref/CellBaseline"], 
          "ScriptBaselineShifts" :> 
          Documentation`HelpLookup["paclet:ref/ScriptBaselineShifts"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"AlignmentPoint\"\>", 
       2->"\<\"Alignment\"\>", 3->"\<\"Inset\"\>", 4->"\<\"CellBaseline\"\>", 
       5->"\<\"ScriptBaselineShifts\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combining Graphics\"\>", 
       2->"\<\"Controls Options\"\>", 
       3->"\<\"Graphics Annotation & Appearance\"\>", 
       4->"\<\"Graphics Options & Styling\"\>", 
       5->"\<\"Graphics Styling in Notebooks\"\>", 
       6->"\<\"Grids & Tables\"\>", 7->"\<\"Stylesheets\"\>", 
       8->"\<\"Text Layout Options\"\>", 
       9->"\<\"User Interface Structuring & Layout\"\>", 
       10->"\<\"New in 6.0: Formatting & Styling\"\>", 
       11->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       12->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BaselinePosition", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["BaselinePosition",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
     " \[LineSeparator]is an option which specifies where the baseline of an \
object is considered to be for purposes of alignment with surrounding text or \
other expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10747]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 " is an option for such objects as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13407],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"BaselinePosition", "->", 
   StyleBox["pos", "TI"]}]], "InlineFormula"],
 " specifies that position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " in an object should align with the baseline of surrounding text or other \
expressions."
}], "Notes",
 CellID->24296],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 " are:"
}], "Notes",
 CellID->23714],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "default object baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of object", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell["top of object", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "halfway between top and bottom", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the object", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the first text line", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["y", "TI"], "]"}], Cell[TextData[{
     "fraction ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " of the height of the object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["i", "TI"], Cell[TextData[{
     "baseline of row ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in a grid"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}], "}"}], Cell[TextData[{
     "baseline of element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ",",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     " in a grid"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ",",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["pos", "TI"], "->", 
     StyleBox["ref", "TI"]}], Cell[TextData[{
     "baseline offset to make ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " be aligned with ",
     Cell[BoxData[
      StyleBox["ref", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->7205],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", "0", "]"}]], "InlineFormula"],
 " corresponds to the bottom of the object; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", "1", "]"}]], "InlineFormula"],
 " to the top. If ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is outside the range 0 to 1, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 " gives a baseline that lies outside the object."
}], "Notes",
 CellID->24949],

Cell[TextData[{
 "For most objects ",
 Cell[BoxData[
  RowBox[{"BaselinePosition", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that the center of the object should align with the axis of \
surrounding text, corresponding to ",
 Cell[BoxData[
  RowBox[{"BaselinePosition", "->", 
   RowBox[{"(", 
    RowBox[{
     ButtonBox["Center",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Center"], "->", 
     ButtonBox["Axis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Axis"]}], ")"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15406],

Cell[TextData[{
 "For objects that contain lines of text, ",
 Cell[BoxData[
  RowBox[{"BaselinePosition", "->", 
   ButtonBox["Baseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Baseline"]}]], "InlineFormula"],
 " specifies that the baseline of the whole object should be taken to be the \
baseline of the first line of text. "
}], "Notes",
 CellID->18810],

Cell[TextData[{
 "For text, the position of the axis is determined by the placement of ",
 Cell[BoxData["-"], "InlineFormula"],
 " or a similar character. For other objects, the axis is taken to be the \
center, except when a construct such as a fraction bar or graphics axis \
defines another natural choice."
}], "Notes",
 CellID->21935],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{"BaselinePosition", "->", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["pos", "TI"], "->", 
     StyleBox["ref", "TI"]}], " ", ")"}]}]], "InlineFormula"],
 "the reference point ",
 Cell[BoxData[
  StyleBox["ref", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["Baseline",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Baseline"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ". It can also be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " represents a fraction of the total height of a single line of text in the \
current font."
}], "Notes",
 CellID->31588]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158920303],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->364191131],

Cell["\<\
Align the bottom of a grid with the baseline of surrounding text:\
\>", "ExampleText",
 CellID->152709064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "z"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->463703086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Bottom,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{112, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56063449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346194563],

Cell["Align the center of a graphic with the baseline of the text:", \
"ExampleText",
 CellID->458844947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94197876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    BaselinePosition->Center,
    ImageSize->50], ",", "y"}], "}"}]], "Output",
 ImageSize->{105, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->156647540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->770129464],

Cell["Specify the baseline of each cell within a grid:", "ExampleText",
 CellID->298368130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}]}], "]"}], ",", "y", 
      ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", "z"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18783497],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", 
     GraphicsBox[RectangleBox[{0, 0}],
      BaselinePosition->Bottom,
      ImageSize->30], "y", 
     GraphicsBox[DiskBox[{0, 0}],
      BaselinePosition->Axis,
      ImageSize->30], "z"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{131, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91580871]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9266],

Cell["\<\
Align the center of objects with the baseline of the surrounding text:\
\>", "ExampleText",
 CellID->127725458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->29147572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Center,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305133016]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->570395130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    BaselinePosition->Center,
    ImageSize->30], ",", "y"}], "}"}]], "Output",
 ImageSize->{85, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->71001852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "70"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->302654125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   Graphics3DBox[SphereBox[{0, 0, 0}],
    BaselinePosition->Center,
    ImageSize->70,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", "y"}], "}"}]], "Output",
 ImageSize->{125, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1206784963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->437023320],

Cell["Align the top of the grid with the baseline:", "ExampleText",
 CellID->1694006710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->881279972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Top,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59388406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->817788123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    BaselinePosition->Top,
    ImageSize->30], ",", "y"}], "}"}]], "Output",
 ImageSize->{85, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->579250161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83459646],

Cell["Align the bottom of the grid with the baseline:", "ExampleText",
 CellID->114848058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->70202562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Bottom,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41668783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Center"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236182960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    BaselinePosition->Bottom,
    ImageSize->30], ",", "y"}], "}"}]], "Output",
 ImageSize->{85, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52594115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->430571087],

Cell[TextData[{
 "Specify the baseline of panel as a fraction of the height by using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7133431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Panel", "[", 
      RowBox[{"b", ",", 
       RowBox[{"BaselinePosition", "\[Rule]", 
        RowBox[{"Scaled", "[", "b", "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210096692],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     PanelBox["0",
      BaselinePosition->Scaled[0]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     PanelBox["0.5`",
      BaselinePosition->Scaled[0.5]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     PanelBox["1",
      BaselinePosition->Scaled[1]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->88603887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->552847672],

Cell["Use the axis of a graphic as the baseline:", "ExampleText",
 CellID->239795365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208849887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    Axes->True,
    BaselinePosition->Axis], ",", "y"}], "}"}]], "Output",
 ImageSize->{155, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->59304383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->596736276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 1}],
    Axes->True,
    BaselinePosition->Axis], ",", "y"}], "}"}]], "Output",
 ImageSize->{155, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->96886889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415281801],

Cell[TextData[{
 "Specify the baseline within ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->465543794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
      RowBox[{"BaselinePosition", "\[Rule]", "Center"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
      RowBox[{"BaselinePosition", "\[Rule]", "Top"}]}], "]"}], ",", "abc"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706626803],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}],
    BaselinePosition->Center,
    ImageSize->30], "\[InvisibleSpace]", 
   GraphicsBox[RectangleBox[{0, 0}],
    BaselinePosition->Top,
    ImageSize->30], "\[InvisibleSpace]", "abc"}],
  Row[{
    Graphics[
     Disk[{0, 0}], ImageSize -> 30, BaselinePosition -> Center], 
    Graphics[
     Rectangle[{0, 0}], ImageSize -> 30, BaselinePosition -> 
     Top], $CellContext`abc}]]], "Output",
 ImageSize->{85, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10655430]
}, Open  ]],

Cell[TextData[{
 "Specify the baseline within ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->111228295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Disk", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
         RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}]}], "]"}], ",", 
       "abc"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"abc", ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "30"}], ",", 
         RowBox[{"BaselinePosition", "\[Rule]", "Top"}]}], "]"}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46955694],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[DiskBox[{0, 0}],
      BaselinePosition->Bottom,
      ImageSize->30], "abc"},
    {"abc", 
     GraphicsBox[RectangleBox[{0, 0}],
      BaselinePosition->Top,
      ImageSize->30]}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{83, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->444894043]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23627],

Cell["Align a specific grid element with the baseline:", "ExampleText",
 CellID->1980066691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "Baseline"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->79632503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"b", "c"},
      {"d", "e"}
     },
     BaselinePosition->{{1, 2}, Baseline},
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37482149]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "Top"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->157255358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"b", "c"},
      {"d", "e"}
     },
     BaselinePosition->{{1, 2}, Top},
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130315521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "^", "2"}], ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"e", "^", "2"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", "Bottom"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "y"}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->760715332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {
       SuperscriptBox["b", "2"], "c"},
      {"d", 
       SuperscriptBox["e", "2"]}
     },
     BaselinePosition->{{2, 2}, Bottom},
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{105, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->625373510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30742070],

Cell["\<\
Align the bottom of the grid with the bottom of surrounding text:\
\>", "ExampleText",
 CellID->211289917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"Bottom", "\[Rule]", "Bottom"}], ")"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", "z"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->355661845],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->(Bottom -> Bottom),
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{93, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29635773]
}, Open  ]],

Cell["Align the center of the grid with the axis of text:", "ExampleText",
 CellID->325219977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"Center", "\[Rule]", "Axis"}], ")"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "3"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->451644084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->(Center -> Axis),
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", 
   FractionBox["x", 
    RowBox[{"1", "+", 
     FractionBox["x", 
      RowBox[{"1", "+", 
       FractionBox["x", 
        RowBox[{"1", "+", "x"}]]}]]}]]}], "}"}]], "Output",
 ImageSize->{142, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18274293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20979117],

Cell["Align the axis of the graphic with the top of the text:", "ExampleText",
 CellID->11754288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"Axis", "\[Rule]", "Top"}], ")"}]}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439307830],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   GraphicsBox[CircleBox[{0, 0}],
    Axes->True,
    BaselinePosition->(Axis -> Top)], ",", "y"}], "}"}]], "Output",
 ImageSize->{155, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->434015631]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7975],

Cell["Align graphics at their top: ", "ExampleText",
 CellID->527159827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Top"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Sqrt", ",", "Exp", ",", "Sin"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->568934967],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->175361822]
}, Open  ]],

Cell[TextData[{
 "Align graphics at their ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->4135378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Sqrt", ",", "Exp", ",", "Sin"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374613142],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->105601077]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9963],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlignmentPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlignmentPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellBaseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellBaseline"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptBaselineShifts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptBaselineShifts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14177]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18334],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->992],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->811360059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BaselinePosition",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
BaselinePosition"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->40091365],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->373141304],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->82732476],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->352153648],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->38445419],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->383193612],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->137841194],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->95763011],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->4312666],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->22585177],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->81780298],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->682382711],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->29283293]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BaselinePosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 37.9730180}", "context" -> "System`", 
    "keywords" -> {
     "align objects", "align graphics", "align tables", "align formulas", 
      "align GUIs", "align widgets"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BaselinePosition is an option which specifies where the baseline of an \
object is considered to be for purposes of alignment with surrounding text or \
other expressions. ", "synonyms" -> {"baseline position"}, "title" -> 
    "BaselinePosition", "type" -> "Symbol", "uri" -> 
    "ref/BaselinePosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15475, 472, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->158920303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 64118, 1983}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4473, 96, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5096, 123, 1581, 37, 70, "ObjectNameGrid"],
Cell[6680, 162, 555, 15, 70, "Usage",
 CellID->10747]
}, Open  ]],
Cell[CellGroupData[{
Cell[7272, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7750, 199, 587, 22, 70, "Notes",
 CellID->13407],
Cell[8340, 223, 324, 10, 70, "Notes",
 CellID->24296],
Cell[8667, 235, 215, 8, 70, "Notes",
 CellID->23714],
Cell[8885, 245, 3196, 101, 70, "2ColumnTableMod",
 CellID->7205],
Cell[12084, 348, 713, 24, 70, "Notes",
 CellID->24949],
Cell[12800, 374, 642, 21, 70, "Notes",
 CellID->15406],
Cell[13445, 397, 367, 10, 70, "Notes",
 CellID->18810],
Cell[13815, 409, 339, 7, 70, "Notes",
 CellID->21935],
Cell[14157, 418, 1281, 49, 70, "Notes",
 CellID->31588]
}, Closed]],
Cell[CellGroupData[{
Cell[15475, 472, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158920303],
Cell[CellGroupData[{
Cell[15860, 486, 148, 5, 70, "ExampleSection",
 CellID->364191131],
Cell[16011, 493, 116, 3, 70, "ExampleText",
 CellID->152709064],
Cell[CellGroupData[{
Cell[16152, 500, 461, 15, 28, "Input",
 CellID->463703086],
Cell[16616, 517, 517, 17, 62, "Output",
 CellID->56063449]
}, Open  ]],
Cell[17148, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->346194563],
Cell[17276, 542, 105, 2, 70, "ExampleText",
 CellID->458844947],
Cell[CellGroupData[{
Cell[17406, 548, 322, 10, 70, "Input",
 CellID->94197876],
Cell[17731, 560, 346, 11, 73, "Output",
 CellID->156647540]
}, Open  ]],
Cell[18092, 574, 125, 3, 70, "ExampleDelimiter",
 CellID->770129464],
Cell[18220, 579, 91, 1, 70, "ExampleText",
 CellID->298368130],
Cell[CellGroupData[{
Cell[18336, 584, 695, 20, 70, "Input",
 CellID->18783497],
Cell[19034, 606, 573, 19, 76, "Output",
 CellID->91580871]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19656, 631, 215, 7, 70, "ExampleSection",
 CellID->9266],
Cell[19874, 640, 121, 3, 70, "ExampleText",
 CellID->127725458],
Cell[CellGroupData[{
Cell[20020, 647, 450, 15, 70, "Input",
 CellID->29147572],
Cell[20473, 664, 507, 17, 55, "Output",
 CellID->305133016]
}, Open  ]],
Cell[CellGroupData[{
Cell[21017, 686, 385, 11, 70, "Input",
 CellID->570395130],
Cell[21405, 699, 292, 10, 53, "Output",
 CellID->71001852]
}, Open  ]],
Cell[CellGroupData[{
Cell[21734, 714, 387, 11, 70, "Input",
 CellID->302654125],
Cell[22124, 727, 7157, 124, 99, "Output",
 CellID->1206784963]
}, Open  ]],
Cell[29296, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->437023320],
Cell[29424, 859, 88, 1, 70, "ExampleText",
 CellID->1694006710],
Cell[CellGroupData[{
Cell[29537, 864, 448, 15, 70, "Input",
 CellID->881279972],
Cell[29988, 881, 503, 17, 68, "Output",
 CellID->59388406]
}, Open  ]],
Cell[CellGroupData[{
Cell[30528, 903, 382, 11, 70, "Input",
 CellID->817788123],
Cell[30913, 916, 290, 10, 66, "Output",
 CellID->579250161]
}, Open  ]],
Cell[31218, 929, 124, 3, 70, "ExampleDelimiter",
 CellID->83459646],
Cell[31345, 934, 90, 1, 70, "ExampleText",
 CellID->114848058],
Cell[CellGroupData[{
Cell[31460, 939, 450, 15, 70, "Input",
 CellID->70202562],
Cell[31913, 956, 506, 17, 62, "Output",
 CellID->41668783]
}, Open  ]],
Cell[CellGroupData[{
Cell[32456, 978, 385, 11, 70, "Input",
 CellID->236182960],
Cell[32844, 991, 292, 10, 60, "Output",
 CellID->52594115]
}, Open  ]],
Cell[33151, 1004, 125, 3, 70, "ExampleDelimiter",
 CellID->430571087],
Cell[33279, 1009, 244, 8, 70, "ExampleText",
 CellID->7133431],
Cell[CellGroupData[{
Cell[33548, 1021, 437, 14, 70, "Input",
 CellID->210096692],
Cell[33988, 1037, 570, 20, 70, "Output",
 CellID->88603887]
}, Open  ]],
Cell[34573, 1060, 125, 3, 70, "ExampleDelimiter",
 CellID->552847672],
Cell[34701, 1065, 85, 1, 70, "ExampleText",
 CellID->239795365],
Cell[CellGroupData[{
Cell[34811, 1070, 318, 10, 70, "Input",
 CellID->208849887],
Cell[35132, 1082, 340, 11, 119, "Output",
 CellID->59304383]
}, Open  ]],
Cell[CellGroupData[{
Cell[35509, 1098, 378, 12, 70, "Input",
 CellID->596736276],
Cell[35890, 1112, 341, 11, 128, "Output",
 CellID->96886889]
}, Open  ]],
Cell[36246, 1126, 125, 3, 70, "ExampleDelimiter",
 CellID->415281801],
Cell[36374, 1131, 201, 8, 70, "ExampleText",
 CellID->465543794],
Cell[CellGroupData[{
Cell[36600, 1143, 560, 16, 70, "Input",
 CellID->706626803],
Cell[37163, 1161, 598, 19, 68, "Output",
 CellID->10655430]
}, Open  ]],
Cell[37776, 1183, 203, 8, 70, "ExampleText",
 CellID->111228295],
Cell[CellGroupData[{
Cell[38004, 1195, 758, 23, 70, "Input",
 CellID->46955694],
Cell[38765, 1220, 577, 20, 106, "Output",
 CellID->444894043]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39391, 1246, 239, 7, 70, "ExampleSection",
 CellID->23627],
Cell[39633, 1255, 92, 1, 70, "ExampleText",
 CellID->1980066691],
Cell[CellGroupData[{
Cell[39750, 1260, 566, 19, 70, "Input",
 CellID->79632503],
Cell[40319, 1281, 518, 17, 57, "Output",
 CellID->37482149]
}, Open  ]],
Cell[CellGroupData[{
Cell[40874, 1303, 562, 19, 70, "Input",
 CellID->157255358],
Cell[41439, 1324, 514, 17, 63, "Output",
 CellID->130315521]
}, Open  ]],
Cell[CellGroupData[{
Cell[41990, 1346, 625, 21, 70, "Input",
 CellID->760715332],
Cell[42618, 1369, 576, 19, 63, "Output",
 CellID->625373510]
}, Open  ]],
Cell[43209, 1391, 124, 3, 70, "ExampleDelimiter",
 CellID->30742070],
Cell[43336, 1396, 116, 3, 70, "ExampleText",
 CellID->211289917],
Cell[CellGroupData[{
Cell[43477, 1403, 517, 17, 70, "Input",
 CellID->355661845],
Cell[43997, 1422, 518, 17, 59, "Output",
 CellID->29635773]
}, Open  ]],
Cell[44530, 1442, 94, 1, 70, "ExampleText",
 CellID->325219977],
Cell[CellGroupData[{
Cell[44649, 1447, 690, 23, 70, "Input",
 CellID->451644084],
Cell[45342, 1472, 670, 23, 67, "Output",
 CellID->18274293]
}, Open  ]],
Cell[46027, 1498, 124, 3, 70, "ExampleDelimiter",
 CellID->20979117],
Cell[46154, 1503, 97, 1, 70, "ExampleText",
 CellID->11754288],
Cell[CellGroupData[{
Cell[46276, 1508, 381, 12, 70, "Input",
 CellID->439307830],
Cell[46660, 1522, 350, 11, 119, "Output",
 CellID->434015631]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47059, 1539, 222, 7, 70, "ExampleSection",
 CellID->7975],
Cell[47284, 1548, 72, 1, 70, "ExampleText",
 CellID->527159827],
Cell[CellGroupData[{
Cell[47381, 1553, 539, 17, 70, "Input",
 CellID->568934967],
Cell[47923, 1572, 4335, 75, 70, "Output",
 Evaluatable->False,
 CellID->175361822]
}, Open  ]],
Cell[52273, 1650, 155, 6, 70, "ExampleText",
 CellID->4135378],
Cell[CellGroupData[{
Cell[52453, 1660, 540, 17, 70, "Input",
 CellID->374613142],
Cell[52996, 1679, 4360, 76, 70, "Output",
 Evaluatable->False,
 CellID->105601077]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57417, 1762, 310, 9, 70, "SeeAlsoSection",
 CellID->9963],
Cell[57730, 1773, 1226, 44, 70, "SeeAlso",
 CellID->14177]
}, Open  ]],
Cell[CellGroupData[{
Cell[58993, 1822, 314, 9, 70, "TutorialsSection",
 CellID->18334],
Cell[59310, 1833, 141, 3, 70, "Tutorials",
 CellID->992],
Cell[59454, 1838, 166, 3, 70, "Tutorials",
 CellID->25408],
Cell[59623, 1843, 151, 3, 70, "Tutorials",
 CellID->811360059]
}, Open  ]],
Cell[CellGroupData[{
Cell[59811, 1851, 305, 8, 70, "RelatedLinksSection"],
Cell[60119, 1861, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60530, 1878, 318, 9, 70, "MoreAboutSection",
 CellID->40091365],
Cell[60851, 1889, 147, 3, 70, "MoreAbout",
 CellID->373141304],
Cell[61001, 1894, 142, 3, 70, "MoreAbout",
 CellID->82732476],
Cell[61146, 1899, 175, 3, 70, "MoreAbout",
 CellID->352153648],
Cell[61324, 1904, 162, 3, 70, "MoreAbout",
 CellID->38445419],
Cell[61489, 1909, 167, 3, 70, "MoreAbout",
 CellID->383193612],
Cell[61659, 1914, 140, 3, 70, "MoreAbout",
 CellID->137841194],
Cell[61802, 1919, 133, 3, 70, "MoreAbout",
 CellID->95763011],
Cell[61938, 1924, 146, 3, 70, "MoreAbout",
 CellID->4312666],
Cell[62087, 1929, 179, 3, 70, "MoreAbout",
 CellID->22585177],
Cell[62269, 1934, 170, 3, 70, "MoreAbout",
 CellID->81780298],
Cell[62442, 1939, 197, 4, 70, "MoreAbout",
 CellID->682382711],
Cell[62642, 1945, 178, 3, 70, "MoreAbout",
 CellID->29283293]
}, Open  ]],
Cell[62835, 1951, 27, 0, 70, "History"],
Cell[62865, 1953, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

