(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23277,        857]
NotebookOptionsPosition[     17285,        650]
NotebookOutlinePosition[     19084,        703]
CellTagsIndexPosition[     18917,        696]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mathematica Packages\"\>", 
       2->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BeginPackage" :> 
          Documentation`HelpLookup["paclet:ref/BeginPackage"], "End" :> 
          Documentation`HelpLookup["paclet:ref/End"], "$ContextPath" :> 
          Documentation`HelpLookup["paclet:ref/$ContextPath"], "Context" :> 
          Documentation`HelpLookup["paclet:ref/Context"], "CellContext" :> 
          Documentation`HelpLookup["paclet:ref/CellContext"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BeginPackage\"\>", 2->"\<\"End\"\>",
        3->"\<\"$ContextPath\"\>", 4->"\<\"Context\"\>", 
       5->"\<\"CellContext\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Namespace Management\"\>", 
       2->"\<\"Package Bulletproofing\"\>", 3->"\<\"Package Development\"\>", 
       4->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Begin", "ObjectName",
 CellID->31127],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Begin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Begin"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]resets the current context. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15780]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " resets the value of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22431],

Cell[TextData[{
 "The interpretation of symbol names depends on context. ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " thus affects the parsing of input expressions. "
}], "Notes",
 CellID->32380]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578629439],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->2073779],

Cell[TextData[{
 "Define a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " in the ",
 Cell[BoxData["MyContext`"], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Context"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->60875029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<MyContext`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->596713305],

Cell[BoxData["\<\"MyContext`\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301581582]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"x", "^", "2"}], " ", "+", " ", "1"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->601317634],

Cell["Restore the context:", "ExampleText",
 CellID->165022018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31808584],

Cell[BoxData["\<\"MyContext`\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->431549703]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " will generally be hidden in the restored context:"
}], "ExampleText",
 CellID->169667416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "f"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->714961715],

Cell[BoxData[
 RowBox[{
  RowBox[{"Information", "::", "\<\"notfound\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(\\\"f\\\"\\) not found. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/notfound\\\", ButtonNote -> \
\\\"Information::notfound\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->232800148]
}, Open  ]],

Cell[TextData[{
 "The definitions are all in ",
 Cell[BoxData["MyContext`f"], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->406705843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "MyContext`f"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->140132147],

Cell[CellGroupData[{

Cell["MyContext`f", "Print", "PrintUsage",
 CellTags->"Info3383914285-3411769",
 CellID->695775838],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"MyContext`f", "[", "MyContext`x_", "]"}], ":=", 
         RowBox[{
          SuperscriptBox["MyContext`x", "2"], "+", "1"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["MyContext`f"],
  Editable->False]], "Print",
 CellTags->"Info3383914285-3411769",
 CellID->203074605]
}, Open  ]]
}, Open  ]],

Cell["The function can be called using its fully qualified name:", \
"ExampleText",
 CellID->819085636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MyContext`f", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->275422903],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->395396020]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21598],

Cell["\<\
Make symbols used for package function definitions private, reducing the \
possibility for conflict:\
\>", "ExampleText",
 CellID->719623674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", "\"\<MyPackage`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423302271],

Cell[BoxData["\<\"MyPackage`\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327097612]
}, Open  ]],

Cell[TextData[{
 "Any use of the symbol ",
 Cell[BoxData["f"], "InlineFormula"],
 " in the package context ensures that ",
 Cell[BoxData["f"], "InlineFormula"],
 " is created in that context:"
}], "ExampleText",
 CellID->496248454],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "usage"}], "=", "\"\<f[x] gives x^2 + 1\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214392796],

Cell[TextData[{
 "When the context given to ",
 Cell[BoxData[
  ButtonBox["Begin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Begin"]], "InlineFormula"],
 " starts with ",
 Cell[BoxData["`"], "InlineFormula"],
 " it extends from the current context:"
}], "ExampleText",
 CellID->245224885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->731610743],

Cell[BoxData["\<\"MyPackage`Private`\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->18256425]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->94114111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->931343050],

Cell[BoxData["\<\"MyPackage`Private`\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->72991716]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EndPackage", "[", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->736583198],

Cell[TextData[{
 "Since the symbol ",
 Cell[BoxData["f"], "InlineFormula"],
 " is in the package context, the function works after ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->78203226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->364179182],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->410818042]
}, Open  ]],

Cell["\<\
You can see that the other variable uses the private context:\
\>", "ExampleText",
 CellID->701124781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "f"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->485136522],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"f[x] gives x^2 + 1\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3383914721-3148037",
 CellID->420957807],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "MyPackage`Private`x_", "]"}], ":=", 
         RowBox[{
          SuperscriptBox["MyPackage`Private`x", "2"], "+", "1"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3383914721-3148037",
 CellID->72283670]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29063],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BeginPackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BeginPackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["End",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/End"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Context",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Context"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellContext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellContext"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30183],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->307603544],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->11347]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->374026353],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->275959774],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->709925999],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->13600942]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Begin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 40.2387010}", "context" -> "System`", 
    "keywords" -> {
     "hidden symbols", "private symbols", "begin context", "set context"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Begin[\"StyleBox[ context`]\"] resets the current context. ", 
    "synonyms" -> {}, "title" -> "Begin", "type" -> "Symbol", "uri" -> 
    "ref/Begin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5081, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->578629439]},
 "Info3383914285-3411769"->{
  Cell[7764, 271, 99, 2, 70, "Print",
   CellTags->"Info3383914285-3411769",
   CellID->695775838],
  Cell[7866, 275, 848, 24, 70, "Print",
   CellTags->"Info3383914285-3411769",
   CellID->203074605]},
 "Info3383914721-3148037"->{
  Cell[12644, 479, 142, 3, 70, "Print",
   CellTags->"Info3383914721-3148037",
   CellID->420957807],
  Cell[12789, 484, 843, 24, 70, "Print",
   CellTags->"Info3383914721-3148037",
   CellID->72283670]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18308, 675},
 {"Info3383914285-3411769", 18457, 679},
 {"Info3383914721-3148037", 18689, 686}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2777, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3400, 88, 43, 1, 70, "ObjectName",
 CellID->31127],
Cell[3446, 91, 503, 16, 70, "Usage",
 CellID->15780]
}, Open  ]],
Cell[CellGroupData[{
Cell[3986, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4464, 129, 308, 12, 70, "Notes",
 CellID->22431],
Cell[4775, 143, 269, 8, 70, "Notes",
 CellID->32380]
}, Closed]],
Cell[CellGroupData[{
Cell[5081, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->578629439],
Cell[CellGroupData[{
Cell[5466, 170, 146, 5, 70, "ExampleSection",
 CellID->2073779],
Cell[5615, 177, 302, 12, 70, "ExampleText",
 CellID->60875029],
Cell[CellGroupData[{
Cell[5942, 193, 118, 3, 28, "Input",
 CellID->596713305],
Cell[6063, 198, 175, 5, 36, "Output",
 CellID->301581582]
}, Open  ]],
Cell[6253, 206, 189, 6, 70, "Input",
 CellID->601317634],
Cell[6445, 214, 63, 1, 70, "ExampleText",
 CellID->165022018],
Cell[CellGroupData[{
Cell[6533, 219, 93, 3, 70, "Input",
 CellID->31808584],
Cell[6629, 224, 175, 5, 36, "Output",
 CellID->431549703]
}, Open  ]],
Cell[6819, 232, 146, 4, 70, "ExampleText",
 CellID->169667416],
Cell[CellGroupData[{
Cell[6990, 240, 88, 3, 70, "Input",
 CellID->714961715],
Cell[7081, 245, 380, 7, 70, "Message",
 CellID->232800148]
}, Open  ]],
Cell[7476, 255, 140, 5, 70, "ExampleText",
 CellID->406705843],
Cell[CellGroupData[{
Cell[7641, 264, 98, 3, 70, "Input",
 CellID->140132147],
Cell[CellGroupData[{
Cell[7764, 271, 99, 2, 70, "Print",
 CellTags->"Info3383914285-3411769",
 CellID->695775838],
Cell[7866, 275, 848, 24, 70, "Print",
 CellTags->"Info3383914285-3411769",
 CellID->203074605]
}, Open  ]]
}, Open  ]],
Cell[8741, 303, 103, 2, 70, "ExampleText",
 CellID->819085636],
Cell[CellGroupData[{
Cell[8869, 309, 130, 4, 70, "Input",
 CellID->275422903],
Cell[9002, 315, 253, 9, 36, "Output",
 CellID->395396020]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9304, 330, 223, 7, 70, "ExampleSection",
 CellID->21598],
Cell[9530, 339, 151, 4, 70, "ExampleText",
 CellID->719623674],
Cell[CellGroupData[{
Cell[9706, 347, 125, 3, 70, "Input",
 CellID->423302271],
Cell[9834, 352, 175, 5, 36, "Output",
 CellID->327097612]
}, Open  ]],
Cell[10024, 360, 231, 7, 70, "ExampleText",
 CellID->496248454],
Cell[10258, 369, 167, 6, 70, "Input",
 CellID->214392796],
Cell[10428, 377, 295, 10, 70, "ExampleText",
 CellID->245224885],
Cell[CellGroupData[{
Cell[10748, 391, 117, 3, 70, "Input",
 CellID->731610743],
Cell[10868, 396, 183, 5, 36, "Output",
 CellID->18256425]
}, Open  ]],
Cell[11066, 404, 189, 7, 70, "Input",
 CellID->94114111],
Cell[CellGroupData[{
Cell[11280, 415, 94, 3, 70, "Input",
 CellID->931343050],
Cell[11377, 420, 183, 5, 36, "Output",
 CellID->72991716]
}, Open  ]],
Cell[11575, 428, 101, 3, 70, "Input",
 CellID->736583198],
Cell[11679, 433, 299, 10, 70, "ExampleText",
 CellID->78203226],
Cell[CellGroupData[{
Cell[12003, 447, 120, 4, 70, "Input",
 CellID->364179182],
Cell[12126, 453, 253, 9, 36, "Output",
 CellID->410818042]
}, Open  ]],
Cell[12394, 465, 112, 3, 70, "ExampleText",
 CellID->701124781],
Cell[CellGroupData[{
Cell[12531, 472, 88, 3, 70, "Input",
 CellID->485136522],
Cell[CellGroupData[{
Cell[12644, 479, 142, 3, 70, "Print",
 CellTags->"Info3383914721-3148037",
 CellID->420957807],
Cell[12789, 484, 843, 24, 70, "Print",
 CellTags->"Info3383914721-3148037",
 CellID->72283670]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13705, 516, 311, 9, 70, "SeeAlsoSection",
 CellID->29063],
Cell[14019, 527, 1196, 44, 70, "SeeAlso",
 CellID->25544]
}, Open  ]],
Cell[CellGroupData[{
Cell[15252, 576, 314, 9, 70, "TutorialsSection",
 CellID->30183],
Cell[15569, 587, 284, 9, 70, "Tutorials",
 CellID->307603544],
Cell[15856, 598, 408, 12, 70, "Tutorials",
 CellID->11347]
}, Open  ]],
Cell[CellGroupData[{
Cell[16301, 615, 299, 8, 70, "MoreAboutSection"],
Cell[16603, 625, 151, 3, 70, "MoreAbout",
 CellID->374026353],
Cell[16757, 630, 155, 3, 70, "MoreAbout",
 CellID->275959774],
Cell[16915, 635, 149, 3, 70, "MoreAbout",
 CellID->709925999],
Cell[17067, 640, 146, 3, 70, "MoreAbout",
 CellID->13600942]
}, Open  ]],
Cell[17228, 646, 27, 0, 70, "History"],
Cell[17258, 648, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

