(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36994,       1313]
NotebookOptionsPosition[     29344,       1048]
NotebookOutlinePosition[     30860,       1092]
CellTagsIndexPosition[     30727,       1086]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StirlingS2" :> 
          Documentation`HelpLookup["paclet:ref/StirlingS2"], "Subsets" :> 
          Documentation`HelpLookup["paclet:ref/Subsets"], "PartitionsQ" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StirlingS2\"\>", 
       2->"\<\"Subsets\"\>", 3->"\<\"PartitionsQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup["paclet:guide/RecurrenceAndSumFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Integer Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Recurrence and Sum Functions\"\>", 
       5->"\<\"New in 6.0: Mathematical Functions\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       7->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BellB", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BellB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BellB"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bell number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BellB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BellB"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bell polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["B", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29108]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Bell polynomials satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["e", "t"], "-", "1"}], ")"}], "x"}]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     FractionBox[
      RowBox[{
       SubscriptBox["B", "n"], 
       RowBox[{"(", "x", ")"}], 
       SuperscriptBox["t", "n"]}], 
      RowBox[{"n", "!"}]]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13437],

Cell[TextData[{
 "The Bell numbers are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "n"], "=", 
    RowBox[{
     SubscriptBox["B", "n"], "(", "1", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->25303],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->314807023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->814843761],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->314663337],

Cell["The tenth Bell number:", "ExampleText",
 CellID->153298507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", "10", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->738079116],

Cell[BoxData["115975"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277190382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->726238559],

Cell["The fifth Bell polynomial:", "ExampleText",
 CellID->501179227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134623445],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"25", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1273638]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29204],

Cell["Evaluate numerically:", "ExampleText",
 CellID->440571121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"1000", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->869496208],

Cell[BoxData["2.033008485255412563147886924576216`15.954589770191825*^1873"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289495779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282276159],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->511156831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"1000", ",", "0.500000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83537840],

Cell[BoxData["2.033008485255412603541354288460815`21.466250116726343*^1873"], \
"Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409950112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7643401],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->343769096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140967614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "5", ",", "15", ",", "52", ",", "203"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250461322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34546343],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->324411115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BellB", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56160805],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["B",
    BellB], "n"], TraditionalForm]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->65587441]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->200547772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{"n", ",", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491033751],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"StirlingS2", "[", 
    RowBox[{"n", ",", "0"}], "]"}], "+", 
   RowBox[{
    RowBox[{"StirlingS2", "[", 
     RowBox[{"n", ",", "1"}], "]"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"StirlingS2", "[", 
     RowBox[{"n", ",", "2"}], "]"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    StirlingS2[$CellContext`n, 0], 
    StirlingS2[$CellContext`n, 1], 
    StirlingS2[$CellContext`n, 2]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16680473]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32569],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " numbers versus their asymptotics:"
}], "ExampleText",
 CellID->687169592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"BellB", "[", "n", "]"}], "]"}], "n"], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", "n", "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"Log", "[", "n", "]"}], "]"}], "+", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"Log", "[", "n", "]"}]], "-", "1"}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Log", "[", 
           RowBox[{"Log", "[", "n", "]"}], "]"}], 
          RowBox[{"Log", "[", "n", "]"}]], ")"}], "2"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5", ",", "50"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324617784],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67299885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98747287],

Cell[TextData[{
 "Compute the first ten ",
 ButtonBox["complementary Bell numbers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/ComplementaryBellNumber.html"], None}],
 ":"
}], "ExampleText",
 CellID->113145085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BellB", "[", 
    RowBox[{"n", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12928864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "9"}], ",", "50", ",", "267", ",", "413"}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321309190]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8581],

Cell["Generating function:", "ExampleText",
 CellID->872812096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BellB", "[", "n", "]"}], 
    RowBox[{
     SuperscriptBox["x", "n"], "/", 
     RowBox[{"n", "!"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35276130],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}]]], "Output",
 ImageSize->{37, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->817175778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188108281],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " can give results involving ",
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->89625043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["k", "n"], "/", 
    RowBox[{"k", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,36",
 CellLabel->"In[1]:=",
 CellID->118886293],

Cell[BoxData[
 RowBox[{"\[ExponentialE]", " ", 
  RowBox[{"BellB", "[", "n", "]"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,36",
 CellLabel->"Out[1]=",
 CellID->8884183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->770419261],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions involving ",
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->90981777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"BellB", "[", 
       RowBox[{"k", "+", "p"}], "]"}], "+", 
      RowBox[{"BellB", "[", "k", "]"}], "-", 
      RowBox[{"BellB", "[", 
       RowBox[{"k", "+", "1"}], "]"}]}], ",", "p"}], "]"}], ",", 
   RowBox[{"p", " ", "\[Element]", " ", "Primes"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201896399],

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"BellB", "[", "k", "]"}]}], ",", "p"}], "]"}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275011473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14075181],

Cell["Compute Bell numbers directly from set partitions:", "ExampleText",
 CellID->247712680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", "=", 
        RowBox[{"IntegerPartitions", "[", "n", "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Multinomial", " ", "@@@", " ", "u"}], ")"}], "/", 
       RowBox[{"Times", "@@@", 
        RowBox[{"Factorial", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Map", "[", 
            RowBox[{"Length", ",", 
             RowBox[{"Split", "[", "#", "]"}]}], "]"}], "&"}], " ", "/@", " ",
           "u"}], "]"}]}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3911605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "15", ",", "52", ",", "203", ",", "877", ",", 
   "4140", ",", "21147", ",", "115975"}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16807062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"BellB", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->395081515],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "15", ",", "52", ",", "203", ",", "877", ",", 
   "4140", ",", "21147", ",", "115975"}], "}"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143921375]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2643],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["BellB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BellB"]], "InlineFormula"],
 " must be a non-negative integer:"
}], "ExampleText",
 CellID->111018749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8894341],

Cell[BoxData[
 RowBox[{
  RowBox[{"BellB", "::", "\<\"intnm\"\>"}], ":", 
  " ", "\<\"Non-negative machine-size integer expected at position \\!\\(1\\) \
in \\!\\(BellB[\\(\\(1\\/2, x\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/intnm\\\", ButtonNote -> \
\\\"BellB::intnm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->558848818],

Cell[BoxData[
 RowBox[{"BellB", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", "x"}], "]"}]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280464595]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23630],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StirlingS2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StirlingS2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartitionsQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30323],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->18001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->185410846],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->199676510],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->168191797],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->288415858],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->209445480],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->116884360],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->572533770],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->274478023]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BellB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 40.8324662}", "context" -> "System`", 
    "keywords" -> {"partitions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BellB[n] gives the Bell number B_n. BellB[n, x] gives the Bell \
polynomial B_n (x). ", "synonyms" -> {"Bell B"}, "title" -> "BellB", "type" -> 
    "Symbol", "uri" -> "ref/BellB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8559, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->814843761]},
 "Ex--21903332711190073474,36"->{
  Cell[21189, 740, 300, 10, 70, "Input",
   CellTags->"Ex--21903332711190073474,36",
   CellID->118886293],
  Cell[21492, 752, 266, 8, 36, "Output",
   CellTags->"Ex--21903332711190073474,36",
   CellID->8884183]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30335, 1072},
 {"Ex--21903332711190073474,36", 30489, 1076}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3098, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3721, 97, 1570, 37, 70, "ObjectNameGrid"],
Cell[5294, 136, 1051, 36, 70, "Usage",
 CellID->29108]
}, Open  ]],
Cell[CellGroupData[{
Cell[6382, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6860, 194, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6983, 200, 623, 22, 70, "Notes",
 CellID->13437],
Cell[7609, 224, 255, 11, 70, "Notes",
 CellID->25303],
Cell[7867, 237, 242, 8, 70, "Notes",
 CellID->314807023],
Cell[8112, 247, 212, 7, 70, "Notes",
 CellID->31226],
Cell[8327, 256, 195, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8559, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->814843761],
Cell[CellGroupData[{
Cell[8944, 282, 148, 5, 70, "ExampleSection",
 CellID->314663337],
Cell[9095, 289, 65, 1, 70, "ExampleText",
 CellID->153298507],
Cell[CellGroupData[{
Cell[9185, 294, 102, 3, 28, "Input",
 CellID->738079116],
Cell[9290, 299, 163, 5, 36, "Output",
 CellID->277190382]
}, Open  ]],
Cell[9468, 307, 125, 3, 70, "ExampleDelimiter",
 CellID->726238559],
Cell[9596, 312, 69, 1, 70, "ExampleText",
 CellID->501179227],
Cell[CellGroupData[{
Cell[9690, 317, 124, 4, 70, "Input",
 CellID->134623445],
Cell[9817, 323, 380, 13, 36, "Output",
 CellID->1273638]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10246, 342, 216, 7, 70, "ExampleSection",
 CellID->29204],
Cell[10465, 351, 64, 1, 70, "ExampleText",
 CellID->440571121],
Cell[CellGroupData[{
Cell[10554, 356, 129, 4, 70, "Input",
 CellID->869496208],
Cell[10686, 362, 220, 6, 36, "Output",
 CellID->289495779]
}, Open  ]],
Cell[10921, 371, 125, 3, 70, "ExampleDelimiter",
 CellID->282276159],
Cell[11049, 376, 113, 3, 70, "ExampleText",
 CellID->511156831],
Cell[CellGroupData[{
Cell[11187, 383, 151, 4, 70, "Input",
 CellID->83537840],
Cell[11341, 389, 220, 6, 36, "Output",
 CellID->409950112]
}, Open  ]],
Cell[11576, 398, 123, 3, 70, "ExampleDelimiter",
 CellID->7643401],
Cell[11702, 403, 204, 7, 70, "ExampleText",
 CellID->343769096],
Cell[CellGroupData[{
Cell[11931, 414, 191, 6, 70, "Input",
 CellID->140967614],
Cell[12125, 422, 251, 8, 36, "Output",
 CellID->250461322]
}, Open  ]],
Cell[12391, 433, 124, 3, 70, "ExampleDelimiter",
 CellID->34546343],
Cell[12518, 438, 203, 7, 70, "ExampleText",
 CellID->324411115],
Cell[CellGroupData[{
Cell[12746, 449, 138, 4, 70, "Input",
 CellID->56160805],
Cell[12887, 455, 247, 9, 50, "Output",
 CellID->65587441]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13183, 470, 238, 7, 70, "ExampleSection",
 CellID->5542],
Cell[13424, 479, 205, 7, 70, "ExampleText",
 CellID->200547772],
Cell[CellGroupData[{
Cell[13654, 490, 241, 8, 70, "Input",
 CellID->491033751],
Cell[13898, 500, 809, 26, 36, "Output",
 CellID->16680473]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14756, 532, 223, 7, 70, "ExampleSection",
 CellID->32569],
Cell[14982, 541, 205, 7, 70, "ExampleText",
 CellID->687169592],
Cell[CellGroupData[{
Cell[15212, 552, 1100, 35, 70, "Input",
 CellID->324617784],
Cell[16315, 589, 2395, 43, 70, "Output",
 Evaluatable->False,
 CellID->67299885]
}, Open  ]],
Cell[18725, 635, 124, 3, 70, "ExampleDelimiter",
 CellID->98747287],
Cell[18852, 640, 247, 8, 70, "ExampleText",
 CellID->113145085],
Cell[CellGroupData[{
Cell[19124, 652, 252, 9, 70, "Input",
 CellID->12928864],
Cell[19379, 663, 365, 11, 36, "Output",
 CellID->321309190]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19793, 680, 232, 7, 70, "ExampleSection",
 CellID->8581],
Cell[20028, 689, 63, 1, 70, "ExampleText",
 CellID->872812096],
Cell[CellGroupData[{
Cell[20116, 694, 313, 11, 70, "Input",
 CellID->35276130],
Cell[20432, 707, 276, 9, 38, "Output",
 CellID->817175778]
}, Open  ]],
Cell[20723, 719, 125, 3, 70, "ExampleDelimiter",
 CellID->188108281],
Cell[20851, 724, 313, 12, 70, "ExampleText",
 CellID->89625043],
Cell[CellGroupData[{
Cell[21189, 740, 300, 10, 70, "Input",
 CellTags->"Ex--21903332711190073474,36",
 CellID->118886293],
Cell[21492, 752, 266, 8, 36, "Output",
 CellTags->"Ex--21903332711190073474,36",
 CellID->8884183]
}, Open  ]],
Cell[21773, 763, 125, 3, 70, "ExampleDelimiter",
 CellID->770419261],
Cell[21901, 768, 347, 13, 70, "ExampleText",
 CellID->90981777],
Cell[CellGroupData[{
Cell[22273, 785, 435, 13, 70, "Input",
 CellID->201896399],
Cell[22711, 800, 269, 9, 36, "Output",
 CellID->275011473]
}, Open  ]],
Cell[22995, 812, 124, 3, 70, "ExampleDelimiter",
 CellID->14075181],
Cell[23122, 817, 93, 1, 70, "ExampleText",
 CellID->247712680],
Cell[CellGroupData[{
Cell[23240, 822, 749, 23, 70, "Input",
 CellID->3911605],
Cell[23992, 847, 308, 9, 36, "Output",
 CellID->16807062]
}, Open  ]],
Cell[CellGroupData[{
Cell[24337, 861, 129, 4, 70, "Input",
 CellID->395081515],
Cell[24469, 867, 309, 9, 36, "Output",
 CellID->143921375]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24827, 882, 225, 7, 70, "ExampleSection",
 CellID->2643],
Cell[25055, 891, 230, 8, 70, "ExampleText",
 CellID->111018749],
Cell[CellGroupData[{
Cell[25310, 903, 146, 5, 70, "Input",
 CellID->8894341],
Cell[25459, 910, 431, 8, 70, "Message",
 CellID->558848818],
Cell[25893, 920, 234, 8, 51, "Output",
 CellID->280464595]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26188, 935, 311, 9, 70, "SeeAlsoSection",
 CellID->23630],
Cell[26502, 946, 703, 26, 70, "SeeAlso",
 CellID->5094]
}, Open  ]],
Cell[CellGroupData[{
Cell[27242, 977, 314, 9, 70, "TutorialsSection",
 CellID->30323],
Cell[27559, 988, 156, 3, 70, "Tutorials",
 CellID->18001]
}, Open  ]],
Cell[CellGroupData[{
Cell[27752, 996, 319, 9, 70, "MoreAboutSection",
 CellID->185410846],
Cell[28074, 1007, 157, 3, 70, "MoreAbout",
 CellID->199676510],
Cell[28234, 1012, 145, 3, 70, "MoreAbout",
 CellID->168191797],
Cell[28382, 1017, 162, 3, 70, "MoreAbout",
 CellID->288415858],
Cell[28547, 1022, 165, 3, 70, "MoreAbout",
 CellID->209445480],
Cell[28715, 1027, 174, 3, 70, "MoreAbout",
 CellID->116884360],
Cell[28892, 1032, 179, 3, 70, "MoreAbout",
 CellID->572533770],
Cell[29074, 1037, 198, 4, 70, "MoreAbout",
 CellID->274478023]
}, Open  ]],
Cell[29287, 1044, 27, 0, 70, "History"],
Cell[29317, 1046, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

