(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60951,       2037]
NotebookOptionsPosition[     52494,       1748]
NotebookOutlinePosition[     53807,       1785]
CellTagsIndexPosition[     53721,       1780]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerE" :> Documentation`HelpLookup["paclet:ref/EulerE"], 
          "Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], "NorlundB" :> 
          Documentation`HelpLookup["paclet:ref/NorlundB"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EulerE\"\>", 2->"\<\"Zeta\"\>", 
       3->"\<\"NorlundB\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BernoulliB", "ObjectName",
 CellID->23225],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BernoulliB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BernoulliB"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bernoulli number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BernoulliB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BernoulliB"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bernoulli polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["B", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30881]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Bernoulli polynomials satisfy the generating function relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", 
     RowBox[{
      SuperscriptBox["e", 
       RowBox[{"x", "t"}]], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["e", "t"], "-", "1"}], ")"}]}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox["B", "n"], "(", "x", ")"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["t", "n"], "/", 
        RowBox[{"n", "!"}]}], ")"}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->106554572],

Cell[TextData[{
 "The Bernoulli numbers are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["B", "n"], "=", 
    RowBox[{
     SubscriptBox["B", "n"], "(", "0", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->5351],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100976615],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->469284636],

Cell["First ten Bernoulli numbers:", "ExampleText",
 CellID->637861393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BernoulliB", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"]}], "}"}]], "Output",
 ImageSize->{283, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1658535521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200536786],

Cell["Bernoulli polynomials:", "ExampleText",
 CellID->26164375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BernoulliB", "[", 
     RowBox[{"n", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35942848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "z"}], ",", 
   RowBox[{
    FractionBox["1", "6"], "-", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    FractionBox["z", "2"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}], "2"], "+", 
    SuperscriptBox["z", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "30"]}], "+", 
    SuperscriptBox["z", "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["z", "6"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "3"]}], "3"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "+", 
    SuperscriptBox["z", "5"]}]}], "}"}]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668763387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->72],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BernoulliB", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "6"], ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", 
   FractionBox["1", "42"]}], "}"}]], "Output",
 ImageSize->{96, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2124320558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140617476],

Cell["Plot Bernoulli polynomials:", "ExampleText",
 CellID->624630969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BernoulliB", "[", 
       RowBox[{"k", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29207427],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->806517891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509711835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->31489808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BernoulliB", "[", "n", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268072687],

Cell[BoxData[
 FormBox[
  SubscriptBox[
   TagBox["B",
    BernoulliB], "n"], TraditionalForm]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1087435673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BernoulliB", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54292087],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox["B",
     BernoulliB], "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->1445520141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13717],

Cell[TextData[{
 "Find sums of powers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "n"], 
    SuperscriptBox["k", "j"]}], TraditionalForm]]],
 " using ",
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"j", "+", "1"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "0"}], "j"], 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{
         RowBox[{"j", "+", "1"}], ",", "i"}], "]"}], " ", 
       RowBox[{"BernoulliB", "[", "i", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"j", "-", "i", "+", "1"}]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "4"}], "}"}]}], "]"}], "//", 
  "Factor"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox["n", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "30"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", "n"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{533, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374511276]
}, Open  ]],

Cell["Compare with direct summation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"i", "^", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SuperscriptBox["n", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "30"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "n"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", "n"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{533, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136446375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Set up an Euler\[Dash]Maclaurin integration formula:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "k"}], "}"}]}], "]"}], 
    RowBox[{
     RowBox[{"BernoulliB", "[", "k", "]"}], "/", 
     RowBox[{"k", "!"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67396850],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"f", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], "12"], "-", 
  RowBox[{
   FractionBox["1", "720"], " ", 
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "3", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "5", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}], "30240"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "7", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}], "1209600"], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "9", ")"}],
      Derivative],
     MultilineFunction->None], "[", "x", "]"}], "47900160"]}]], "Output",
 ImageSize->{455, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1889173276]
}, Open  ]],

Cell[TextData[{
 "Use it for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "\[LongEqual]", 
    SuperscriptBox["x", 
     RowBox[{"5", "/", "3"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "DesignDiscussion",
 CellID->901692189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"r", "=", 
     RowBox[{"%", "/.", 
      RowBox[{"f", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#", "^", 
          RowBox[{"(", 
           RowBox[{"5", "/", "3"}], ")"}]}], "&"}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", "/.", 
      RowBox[{"x", "\[Rule]", "10"}]}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"r", "/.", 
      RowBox[{"x", "\[Rule]", "1"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260152385],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["12094355", "841802544"]}], "+", 
  FractionBox[
   RowBox[{"1355", " ", 
    SuperscriptBox["5", 
     RowBox[{"2", "/", "3"}]]}], 
   RowBox[{"18", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]]}]], "+", 
  FractionBox["21635319421", 
   RowBox[{"420901272000000", " ", 
    SuperscriptBox["10", 
     RowBox[{"1", "/", "3"}]]}]], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["10", 
    RowBox[{"2", "/", "3"}]]}]}]], "Output",
 ImageSize->{369, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->789528837]
}, Open  ]],

Cell["Compare with the exact summation result:", "ExampleText",
 CellID->145591920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  RowBox[{"NSum", "[", 
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"5", "/", "3"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "9"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->273216952],

Cell[BoxData["6.330640356821959`*^-6"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->309708646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot roots of Bernoulli polynomials in the complex plane:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"n", "/", "40"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "#", "]"}], ",", 
           RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
       RowBox[{"(", 
        RowBox[{"z", "/.", 
         RowBox[{"NSolve", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"BernoulliB", "[", 
             RowBox[{"n", ",", "z"}], "]"}], "==", "0"}], ",", "z"}], "]"}]}],
         ")"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "36"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{169, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161248717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Show the approach of Bernoulli numbers to a limiting form:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"BernoulliB", "[", 
        RowBox[{"2", "n"}], "]"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Pi", " ", 
         RowBox[{"E", "/", "n"}]}], ")"}], 
       RowBox[{
        RowBox[{"2", " ", "n"}], "+", 
        RowBox[{"1", "/", "2"}]}]]}], " ", "-", 
     RowBox[{"4", " ", "Pi", " ", 
      RowBox[{"Sqrt", "[", "E", "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWE1PFEEQbZjdRRZQEBYBMaDGqNHEeDYIRIUYNVET4kWjC0FAw4eAEo1E
g4FgRPGgBxE8oYnx4EEiP8DE6MmrZ//IWt0129NTXT0M7EY3uz3dPdWv6lVV
V8/shezkYP9wdnKoL9vaPZ4dGxzqm2jtGh2HKa9ECLEGv5sNAvo56KnfWi4H
14xsPTlWH7HMzr6UTer96q/2tjfwHRr4DO3zhW8pVroemgQMS+FaCtcGOZnQ
9/3ZXf7Vc4zTapWpsxQuwkPl0Ao5lmpF2dnud/Ke+kDnzClFI49mWyh1iSSO
davsNaUyYbsZiVrlF1MiQi5tygEvaJELdhS7BM4YfBPIDb4dbUvoAejgUHlA
pGVP8T7d+RY6165+fP3qO3TWv/72bZEpUCKv2hvSN42x+EkBkdTsfF9lYjLf
rsYYxXzMlCeQE3agRU7YQd44Y/CuBnq9Nz4hPd0ZHfliDpF/wDxvi3B6wrS2
kVlhxZHeD3kwrl+SnF+Y6Ie8IFVWa08hbd0hfsEOOKIiMsrF8Uudn1G8P7z8
nSTdAbFYy5lKP+fblzQ1gNAdSAJXtApkXh8znm4PKIRynMF4mxsfdjd6YYfJ
mVAl+S6z24tpVzF8QCszX8+VpiQ5I1QNlvxU7qaxRrlIVRE9GTI2r8Hdc+xO
sqpmma1Y+rGDZdyVY8+etI4RC9bFYnVy9qVN+0i0Aek8i3SSQypnbfKz5CKL
c4LDKWMNET0KYSe0K/oYoHiVG4yTZJzg7lfrsTbMPBnQLqSFiZvaipYi3qcs
qTz/bLSbjLE66Ewzi7sfw+sszvHwOkwn00mil113zIi9rj0epI6/ql+vkntL
SZdpLTrDpOQAi39UUdf4aBSI32KljxjSiI9m3GalDzuwh1npQw7skRDDgw7M
MRbzgAPzDiu934E9wUrvc2BPuqUTV3o+aNR7IV57c0E1nrq77kd3isVqyYWq
HTw931dyfqFVH4+skTpoxlOZFstGHzd0HimU0AzFoeM9LLcHLuzQU0deGbVd
YXpoKzhAPHShbbPPXGxlfZCAzYY3L19aBdOcWNa5XJqvsYZlzcSy6YLQmljf
TVvxTvnrN4pxE7HuEZthjZZPAjmphaI8dqN4P3/88a3mpdS7nV/h4BVVzERI
BRqjpAKNMyGrqaYnLEY90RQlFWjipeqIxtkIqUDjbMjqDNHEY9QSTXNWhnAV
If+ERrOullg058rhGE+0/DtZwKeY2MsFYsmhE8OqSx7juRoSh3kXWuR7PN3F
NSQe81Z0zf3P1YEa4nVEcP+bJDEol6fsmmpiW5RUoJ+X4v/NClu1wsqY/1tI
W59FSAW2RkkFtvJScaxatuK0mV1YaDab4yrin4WiYwdedWI7TzwJVkW8XkwL
i+lJO6b5vRcdx+j8qSTxecGuqSCejpIKPMlLbX2vbbRys1oqCPdFdk2acF+0
4mA9hwr3c1Wa+GiRyRD1RhhZp+Pk2b9EcZ1f/5nJpvfKmtWKkr+X6l30\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182658682]
}, Open  ]],

Cell[BoxData["|"], "Input",
 CellLabel->"In[2]:=",
 CellID->566194524]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1993],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 " numbers from their generating function:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CoefficientList", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"t", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Exp", "[", "t", "]"}], "-", "1"}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "12"}], "}"}]}], "]"}], ",", "t"}], "]"}], 
  
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"n", "!"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "12"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["691", "2730"]}]}], "}"}]], "Output",
 ImageSize->{352, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->742455651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BernoulliB", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", " ", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["691", "2730"]}]}], "}"}]], "Output",
 ImageSize->{352, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1572137287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11455285],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 " polynomials from their generating function:"
}], "ExampleText",
 CellID->400469543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"t", " ", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"z", " ", "t"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Exp", "[", "t", "]"}], "-", "1"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", "t"}], "]"}], 
   
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "!"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "z"}], ",", 
   RowBox[{
    FractionBox["1", "6"], "-", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    FractionBox["z", "2"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}], "2"], "+", 
    SuperscriptBox["z", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "30"]}], "+", 
    SuperscriptBox["z", "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["z", "6"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "3"]}], "3"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "+", 
    SuperscriptBox["z", "5"]}], ",", 
   RowBox[{
    FractionBox["1", "42"], "-", 
    FractionBox[
     SuperscriptBox["z", "2"], "2"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    SuperscriptBox["z", "6"]}]}], "}"}]], "Output",
 ImageSize->{421, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272589921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BernoulliB", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", " ", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", "z"}], ",", 
   RowBox[{
    FractionBox["1", "6"], "-", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    FractionBox["z", "2"], "-", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}], "2"], "+", 
    SuperscriptBox["z", "3"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "30"]}], "+", 
    SuperscriptBox["z", "2"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["z", "6"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "3"]}], "3"], "-", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "+", 
    SuperscriptBox["z", "5"]}], ",", 
   RowBox[{
    FractionBox["1", "42"], "-", 
    FractionBox[
     SuperscriptBox["z", "2"], "2"], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["z", "4"]}], "2"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    SuperscriptBox["z", "6"]}]}], "}"}]], "Output",
 ImageSize->{421, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->836183196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23760],

Cell[TextData[{
 "Algorithmically produced results are frequently expressed using ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["BernoulliB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BernoulliB"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"n", "!"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", " ", "\[Pi]"}], ")"}], "n"]]}], 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "\[Infinity]"], 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox["k", "n"]], 
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", "n"}], "2"], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["2", 
    RowBox[{"1", "-", "n"}]]}], " ", 
  SuperscriptBox["\[Pi]", 
   RowBox[{"-", "n"}]], " ", 
  RowBox[{"Cos", "[", 
   FractionBox[
    RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}], " ", 
  RowBox[{"n", "!"}], " ", 
  RowBox[{"Zeta", "[", "n", "]"}]}]], "Output",
 ImageSize->{187, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597989204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96352428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"]}], "}"}]], "Output",
 ImageSize->{235, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181083668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BernoulliB", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "2", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "6"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["1", "42"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "30"]}], ",", "0", ",", 
   FractionBox["5", "66"]}], "}"}]], "Output",
 ImageSize->{235, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->488880277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255050748],

Cell[TextData[{
 "When entered in the traditional form ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["B", "n"], TraditionalForm]], "InlineMath"],
 " is not automatically interpreted as a Bernoulli number:"
}], "ExampleText",
 CellID->111777426],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  SubscriptBox["B", "n"], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->465195949],

Cell[BoxData[
 SubscriptBox["B", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338382117]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4092],

Cell["\<\
Going from Bernoulli numbers to Bernoulli polynomials with umbral calculus:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", "x"}], ")"}], "^", "12"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["b", "12"], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["b", "11"], " ", "x"}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["b", "10"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["b", "9"], " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["b", "8"], " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["b", "7"], " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"924", " ", 
   SuperscriptBox["b", "6"], " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"792", " ", 
   SuperscriptBox["b", "5"], " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"495", " ", 
   SuperscriptBox["b", "4"], " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"220", " ", 
   SuperscriptBox["b", "3"], " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"66", " ", 
   SuperscriptBox["b", "2"], " ", 
   SuperscriptBox["x", "10"]}], "+", 
  RowBox[{"12", " ", "b", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  SuperscriptBox["x", "12"]}]], "Output",
 ImageSize->{407, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651543163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"b", "^", "k_."}], ":>", 
   RowBox[{"BernoulliB", "[", "k", "]"}]}]}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["691", "2730"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  FractionBox[
   RowBox[{"33", " ", 
    SuperscriptBox["x", "4"]}], "2"], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  FractionBox[
   RowBox[{"33", " ", 
    SuperscriptBox["x", "8"]}], "2"], "+", 
  RowBox[{"11", " ", 
   SuperscriptBox["x", "10"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  SuperscriptBox["x", "12"]}]], "Output",
 ImageSize->{331, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->466824488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BernoulliB", "[", 
  RowBox[{"12", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["691", "2730"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  FractionBox[
   RowBox[{"33", " ", 
    SuperscriptBox["x", "4"]}], "2"], "+", 
  RowBox[{"22", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  FractionBox[
   RowBox[{"33", " ", 
    SuperscriptBox["x", "8"]}], "2"], "+", 
  RowBox[{"11", " ", 
   SuperscriptBox["x", "10"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "11"]}], "+", 
  SuperscriptBox["x", "12"]}]], "Output",
 ImageSize->{331, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1161407325]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27430],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NorlundB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NorlundB"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17252],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->15857]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26865],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BernoulliNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/BernoulliB/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BernoulliB"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->22020555],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->126506591],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->19098807],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->30371635]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BernoulliB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 46.5982388}", "context" -> "System`", 
    "keywords" -> {
     "Bernoulli B", "Bernoulli numbers", "Bernoulli polynomials"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BernoulliB[n] gives the Bernoulli number B_n. BernoulliB[n, x] gives the \
Bernoulli polynomial B_n (x). ", "synonyms" -> {"Bernoulli B"}, "title" -> 
    "BernoulliB", "type" -> "Symbol", "uri" -> "ref/BernoulliB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6088, 209, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->100976615]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53578, 1773}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2249, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2872, 81, 48, 1, 70, "ObjectName",
 CellID->23225],
Cell[2923, 84, 1081, 36, 70, "Usage",
 CellID->30881]
}, Open  ]],
Cell[CellGroupData[{
Cell[4041, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4519, 142, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4642, 148, 714, 25, 70, "Notes",
 CellID->106554572],
Cell[5359, 175, 259, 11, 70, "Notes",
 CellID->5351],
Cell[5621, 188, 222, 7, 70, "Notes",
 CellID->31226],
Cell[5846, 197, 205, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6088, 209, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->100976615],
Cell[CellGroupData[{
Cell[6473, 223, 148, 5, 70, "ExampleSection",
 CellID->469284636],
Cell[6624, 230, 71, 1, 70, "ExampleText",
 CellID->637861393],
Cell[CellGroupData[{
Cell[6720, 235, 202, 6, 28, "Input"],
Cell[6925, 243, 491, 16, 51, "Output",
 CellID->1658535521]
}, Open  ]],
Cell[7431, 262, 125, 3, 70, "ExampleDelimiter",
 CellID->200536786],
Cell[7559, 267, 64, 1, 70, "ExampleText",
 CellID->26164375],
Cell[CellGroupData[{
Cell[7648, 272, 268, 9, 70, "Input",
 CellID->35942848],
Cell[7919, 283, 1016, 36, 54, "Output",
 CellID->668763387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8984, 325, 213, 7, 70, "ExampleSection",
 CellID->72],
Cell[9200, 334, 194, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9419, 344, 143, 4, 70, "Input"],
Cell[9565, 350, 302, 11, 51, "Output",
 CellID->2124320558]
}, Open  ]],
Cell[9882, 364, 125, 3, 70, "ExampleDelimiter",
 CellID->140617476],
Cell[10010, 369, 70, 1, 70, "ExampleText",
 CellID->624630969],
Cell[CellGroupData[{
Cell[10105, 374, 401, 13, 70, "Input",
 CellID->29207427],
Cell[10509, 389, 5218, 90, 70, "Output",
 Evaluatable->False,
 CellID->806517891]
}, Open  ]],
Cell[15742, 482, 125, 3, 70, "ExampleDelimiter",
 CellID->509711835],
Cell[15870, 487, 202, 7, 70, "ExampleText",
 CellID->31489808],
Cell[CellGroupData[{
Cell[16097, 498, 144, 4, 70, "Input",
 CellID->268072687],
Cell[16244, 504, 254, 9, 50, "Output",
 CellID->1087435673]
}, Open  ]],
Cell[CellGroupData[{
Cell[16535, 518, 167, 5, 70, "Input",
 CellID->54292087],
Cell[16705, 525, 285, 10, 50, "Output",
 CellID->1445520141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17039, 541, 223, 7, 70, "ExampleSection",
 CellID->13717],
Cell[17265, 550, 360, 14, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17650, 568, 665, 22, 70, "Input"],
Cell[18318, 592, 1063, 37, 51, "Output",
 CellID->374511276]
}, Open  ]],
Cell[19396, 632, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19474, 636, 288, 10, 70, "Input"],
Cell[19765, 648, 1063, 37, 51, "Output",
 CellID->136446375]
}, Open  ]],
Cell[20843, 688, 105, 2, 70, "ExampleDelimiter"],
Cell[20951, 692, 83, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[21059, 698, 499, 17, 70, "Input",
 CellID->67396850],
Cell[21561, 717, 1231, 46, 54, "Output",
 CellID->1889173276]
}, Open  ]],
Cell[22807, 766, 261, 10, 70, "DesignDiscussion",
 CellID->901692189],
Cell[CellGroupData[{
Cell[23093, 780, 572, 20, 70, "Input",
 CellID->260152385],
Cell[23668, 802, 629, 22, 56, "Output",
 CellID->789528837]
}, Open  ]],
Cell[24312, 827, 83, 1, 70, "ExampleText",
 CellID->145591920],
Cell[CellGroupData[{
Cell[24420, 832, 286, 10, 70, "Input",
 CellID->273216952],
Cell[24709, 844, 179, 5, 36, "Output",
 CellID->309708646]
}, Open  ]],
Cell[24903, 852, 105, 2, 70, "ExampleDelimiter"],
Cell[25011, 856, 82, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[25118, 861, 784, 25, 70, "Input"],
Cell[25905, 888, 6796, 115, 70, "Output",
 Evaluatable->False,
 CellID->161248717]
}, Open  ]],
Cell[32716, 1006, 105, 2, 70, "ExampleDelimiter"],
Cell[32824, 1010, 83, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[32932, 1015, 633, 20, 70, "Input"],
Cell[33568, 1037, 1733, 32, 70, "Output",
 Evaluatable->False,
 CellID->182658682]
}, Open  ]],
Cell[35316, 1072, 70, 2, 70, "Input",
 CellID->566194524]
}, Closed]],
Cell[CellGroupData[{
Cell[35423, 1079, 232, 7, 70, "ExampleSection",
 CellID->1993],
Cell[35658, 1088, 211, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35894, 1099, 522, 18, 70, "Input"],
Cell[36419, 1119, 557, 18, 51, "Output",
 CellID->742455651]
}, Open  ]],
Cell[CellGroupData[{
Cell[37013, 1142, 207, 6, 70, "Input"],
Cell[37223, 1150, 558, 18, 51, "Output",
 CellID->1572137287]
}, Open  ]],
Cell[37796, 1171, 124, 3, 70, "ExampleDelimiter",
 CellID->11455285],
Cell[37923, 1176, 235, 8, 70, "ExampleText",
 CellID->400469543],
Cell[CellGroupData[{
Cell[38183, 1188, 668, 23, 70, "Input"],
Cell[38854, 1213, 1309, 46, 87, "Output",
 CellID->272589921]
}, Open  ]],
Cell[CellGroupData[{
Cell[40200, 1264, 231, 7, 70, "Input"],
Cell[40434, 1273, 1309, 46, 87, "Output",
 CellID->836183196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41792, 1325, 226, 7, 70, "ExampleSection",
 CellID->23760],
Cell[42021, 1334, 359, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[42405, 1350, 484, 18, 70, "Input"],
Cell[42892, 1370, 456, 16, 49, "Output",
 CellID->597989204]
}, Open  ]],
Cell[CellGroupData[{
Cell[43385, 1391, 183, 6, 70, "Input",
 CellID->96352428],
Cell[43571, 1399, 428, 14, 51, "Output",
 CellID->181083668]
}, Open  ]],
Cell[CellGroupData[{
Cell[44036, 1418, 212, 6, 70, "Input"],
Cell[44251, 1426, 428, 14, 51, "Output",
 CellID->488880277]
}, Open  ]],
Cell[44694, 1443, 125, 3, 70, "ExampleDelimiter",
 CellID->255050748],
Cell[44822, 1448, 243, 7, 70, "ExampleText",
 CellID->111777426],
Cell[CellGroupData[{
Cell[45090, 1459, 170, 6, 70, "Input",
 CellID->465195949],
Cell[45263, 1467, 179, 6, 36, "Output",
 CellID->338382117]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45491, 1479, 223, 7, 70, "ExampleSection",
 CellID->4092],
Cell[45717, 1488, 106, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[45848, 1494, 155, 5, 70, "Input"],
Cell[46006, 1501, 1226, 39, 54, "Output",
 CellID->651543163]
}, Open  ]],
Cell[CellGroupData[{
Cell[47269, 1545, 161, 5, 70, "Input"],
Cell[47433, 1552, 651, 23, 54, "Output",
 CellID->466824488]
}, Open  ]],
Cell[CellGroupData[{
Cell[48121, 1580, 110, 3, 70, "Input"],
Cell[48234, 1585, 652, 23, 54, "Output",
 CellID->1161407325]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48947, 1615, 311, 9, 70, "SeeAlsoSection",
 CellID->27430],
Cell[49261, 1626, 684, 26, 70, "SeeAlso",
 CellID->11351]
}, Open  ]],
Cell[CellGroupData[{
Cell[49982, 1657, 314, 9, 70, "TutorialsSection",
 CellID->17252],
Cell[50299, 1668, 156, 3, 70, "Tutorials",
 CellID->15857]
}, Open  ]],
Cell[CellGroupData[{
Cell[50492, 1676, 321, 9, 70, "RelatedLinksSection",
 CellID->26865],
Cell[50816, 1687, 186, 4, 70, "RelatedLinks"],
Cell[51005, 1693, 199, 4, 70, "RelatedLinks"],
Cell[51207, 1699, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51632, 1717, 318, 9, 70, "MoreAboutSection",
 CellID->22020555],
Cell[51953, 1728, 145, 3, 70, "MoreAbout",
 CellID->126506591],
Cell[52101, 1733, 154, 3, 70, "MoreAbout",
 CellID->19098807],
Cell[52258, 1738, 164, 3, 70, "MoreAbout",
 CellID->30371635]
}, Open  ]],
Cell[52437, 1744, 27, 0, 70, "History"],
Cell[52467, 1746, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

