(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43745,       1618]
NotebookOptionsPosition[     35245,       1320]
NotebookOutlinePosition[     36509,       1356]
CellTagsIndexPosition[     36423,       1351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BesselK" :> Documentation`HelpLookup["paclet:ref/BesselK"], 
          "AiryBi" :> Documentation`HelpLookup["paclet:ref/AiryBi"], 
          "BesselJ" :> Documentation`HelpLookup["paclet:ref/BesselJ"], 
          "BesselY" :> Documentation`HelpLookup["paclet:ref/BesselY"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BesselK\"\>", 
       2->"\<\"AiryBi\"\>", 3->"\<\"BesselJ\"\>", 
       4->"\<\"BesselY\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BesselI", "ObjectName",
 CellID->6546],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselI",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselI"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the modified Bessel function of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{"z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", 
        SuperscriptBox["n", "2"]}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->14565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]]],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31168],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->704293555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215089949],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->222583876],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->216652770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"0", ",", " ", "2.0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81704497],

Cell[BoxData["2.279585302336067`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158068068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->473970047],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->840236885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772395],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622831475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121084447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830150476],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "64"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "2304"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "147456"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "14745600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 4], 0, 
    Rational[1, 64], 0, 
    Rational[1, 2304], 0, 
    Rational[1, 147456], 0, 
    Rational[1, 14745600]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{305, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33037348]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->636],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->105782701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   RowBox[{"3", "+", "I"}], ",", " ", 
   RowBox[{"1.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7700705],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2566499289084426`"}], "+", 
  RowBox[{"0.04927707435297583`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256927088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120107551],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->320460250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", " ", "1"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228190834],

Cell[BoxData["1.\
2660658777520083355982446252147175376076703113549622067631208458195`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325654881]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->720988541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"0", ",", "1.0000000000000000000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302799674],

Cell[BoxData["1.\
2660658777520083355982446252147175376076703113549622067631208458195`48.\
616130194428095"], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83923278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264940833],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " ",
 "threads element-wise over lists",
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->45297604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", " ", "1."}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80668747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2660658777520082`", ",", "0.565159103992485`", ",", 
   "0.13574766976703828`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55359729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105144541],

Cell[TextData[{
 "For half-integer indices, ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->45499069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211985664],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sinh", "[", "x", "]"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{91, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206779388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->517234208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->100349287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselI", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468651607],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["I", "n"], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->526912206]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18677],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->305425614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18825205],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["x", "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "3"]}], "48"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "4"]}], "32"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 2], 
    Rational[-1, 4], 
    Rational[11, 48], 
    Rational[-7, 32]}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{176, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166715675]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30906],

Cell[TextData[{
 "Inductance of a solenoid of radius ",
 Cell[BoxData["r"], "InlineFormula"],
 " and length ",
 Cell[BoxData["a"], "InlineFormula"],
 " with fixed numbers of turns per unit length:"
}], "ExampleText",
 CellID->61793136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"2", 
   RowBox[{"r", "^", "2"}], " ", "a", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sinc", "[", 
        RowBox[{"x", "/", "2"}], "]"}], "^", "2"}], 
      RowBox[{"BesselI", "[", 
       RowBox[{"1", ",", 
        RowBox[{"x", " ", 
         RowBox[{"r", "/", "a"}]}]}], "]"}], "\n", "     ", 
      RowBox[{"BesselK", "[", 
       RowBox[{"1", ",", 
        RowBox[{"x", " ", 
         RowBox[{"r", "/", "a"}]}]}], "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{
       RowBox[{"r", ">", "0"}], "&&", 
       RowBox[{"a", ">", "0"}]}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435554428],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "8"}], " ", 
     SuperscriptBox["r", "3"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "-", 
       RowBox[{"4", " ", "a", " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     RowBox[{"EllipticE", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}], 
        SuperscriptBox["a", "2"]]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "3"], "+", 
       RowBox[{"4", " ", "a", " ", 
        SuperscriptBox["r", "2"]}]}], ")"}], " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}], 
        SuperscriptBox["a", "2"]]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{460, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101382076]
}, Open  ]],

Cell["Inductance per unit length of the infinite solenoid:", "ExampleText",
 CellID->7243216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"%", "/", "a"}], ",", " ", 
   RowBox[{"a", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1021045775],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53477433]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19463],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions with ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->344065199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", " ", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->842946257],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"2", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39569876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136414702],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->228055373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}], " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88765726],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "x"}]], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "+", 
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", "x"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->604666346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42140448],

Cell[TextData[{
 "Find limits of expressions involving ",
 Cell[BoxData[
  ButtonBox["BesselI",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->84781951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", 
      RowBox[{"3", "x"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"BesselI", "[", 
        RowBox[{"1", ",", "x"}], "]"}], "^", "3"}]}], ")"}]}], ",", 
   RowBox[{"x", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9397391],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645768884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92237008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/", 
    RowBox[{
     RowBox[{"n", "!"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->885119590],

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"0", ",", 
   RowBox[{"2", " ", 
    SqrtBox["x"]}]}], "]"}]], "Output",
 ImageSize->{120, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->968584932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5249],

Cell["\<\
With numeric arguments, half-integer Bessel functions are not automatically \
evaluated:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->86171805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30263350],

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   FractionBox["11", "2"], ",", "1"}], "]"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93230089]
}, Open  ]],

Cell["For symbolic arguments they are:", "ExampleText",
 CellID->861443203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200703460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      FractionBox["1890", 
       SuperscriptBox["x", "4"]], "+", 
      FractionBox["210", 
       SuperscriptBox["x", "2"]]}], ")"}], " ", 
    RowBox[{"Cosh", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1890", 
        SuperscriptBox["x", "5"]]}], "-", 
      FractionBox["840", 
       SuperscriptBox["x", "3"]], "-", 
      FractionBox["30", "x"]}], ")"}], " ", 
    RowBox[{"Sinh", "[", "x", "]"}]}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   SqrtBox["x"]}]]], "Output",
 ImageSize->{319, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->391079871]
}, Open  ]],

Cell["\<\
This can lead to major inaccuracies in machine-precision evaluation:\
\>", "ExampleText",
 CellID->307079448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{
     RowBox[{"31", "/", "2"}], ",", 
     RowBox[{"-", "1."}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{
      RowBox[{"31", "/", "2"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1."}]}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533825997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4.22129023149559`*^-18"}], " ", "\[ImaginaryI]"}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.5957691216057308`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{225, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->253800675]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8056],

Cell["Continued fraction with arithmetic progression terms:", "ExampleText",
 CellID->123850395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "/", 
    RowBox[{"BesselI", "[", 
     RowBox[{"2", ",", "2"}], "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188032228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", 
   ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15", ",", 
   "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21"}], 
  "}"}]], "Output",
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104875354]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3287],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryBi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3719],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->15469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9982],

Cell[TextData[{
 ButtonBox["Demonstrations with BesselI",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BesselI"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ModifiedBesselFunctionoftheFirstKind.\
html"], None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/BesselI/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BesselI"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->585766227],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->231676928],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->305338937]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 47.8170200}", "context" -> "System`", 
    "keywords" -> {"Bessel functions", "cylindrical functions", "Bessel I"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BesselI[n, z] gives the modified Bessel function of the first kind I_n \
(z). ", "synonyms" -> {"Bessel I"}, "title" -> "BesselI", "type" -> "Symbol", 
    "uri" -> "ref/BesselI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6551, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->215089949]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36280, 1344}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2147, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2770, 78, 44, 1, 70, "ObjectName",
 CellID->6546],
Cell[2817, 81, 698, 23, 70, "Usage",
 CellID->30439]
}, Open  ]],
Cell[CellGroupData[{
Cell[3552, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4030, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4153, 132, 687, 24, 70, "Notes",
 CellID->14565],
Cell[4843, 158, 524, 20, 70, "Notes",
 CellID->18962],
Cell[5370, 180, 474, 17, 70, "Notes",
 CellID->31168],
Cell[5847, 199, 246, 8, 70, "Notes",
 CellID->704293555],
Cell[6096, 209, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6315, 218, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6551, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215089949],
Cell[CellGroupData[{
Cell[6936, 244, 148, 5, 70, "ExampleSection",
 CellID->222583876],
Cell[7087, 251, 201, 5, 70, "ExampleText",
 CellID->216652770],
Cell[CellGroupData[{
Cell[7313, 260, 132, 4, 28, "Input",
 CellID->81704497],
Cell[7448, 266, 175, 5, 36, "Output",
 CellID->158068068]
}, Open  ]],
Cell[7638, 274, 125, 3, 70, "ExampleDelimiter",
 CellID->473970047],
Cell[7766, 279, 326, 13, 70, "ExampleText",
 CellID->840236885],
Cell[CellGroupData[{
Cell[8117, 296, 265, 9, 28, "Input",
 CellID->772395],
Cell[8385, 307, 3197, 56, 172, "Output",
 Evaluatable->False,
 CellID->622831475]
}, Open  ]],
Cell[11597, 366, 125, 3, 70, "ExampleDelimiter",
 CellID->121084447],
Cell[CellGroupData[{
Cell[11747, 373, 245, 8, 70, "Input",
 CellID->830150476],
Cell[11995, 383, 863, 29, 54, "Output",
 CellID->33037348]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12907, 418, 214, 7, 70, "ExampleSection",
 CellID->636],
Cell[13124, 427, 226, 5, 70, "ExampleText",
 CellID->105782701],
Cell[CellGroupData[{
Cell[13375, 436, 179, 6, 70, "Input",
 CellID->7700705],
Cell[13557, 444, 271, 8, 36, "Output",
 CellID->256927088]
}, Open  ]],
Cell[13843, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->120107551],
Cell[13971, 460, 207, 5, 70, "ExampleText",
 CellID->320460250],
Cell[CellGroupData[{
Cell[14203, 469, 186, 6, 70, "Input",
 CellID->228190834],
Cell[14392, 477, 235, 7, 36, "Output",
 CellID->325654881]
}, Open  ]],
Cell[14642, 487, 250, 7, 70, "ExampleText",
 CellID->720988541],
Cell[CellGroupData[{
Cell[14917, 498, 179, 5, 70, "Input",
 CellID->302799674],
Cell[15099, 505, 249, 7, 36, "Output",
 CellID->83923278]
}, Open  ]],
Cell[15363, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->264940833],
Cell[15491, 520, 354, 13, 70, "ExampleText",
 CellID->45297604],
Cell[CellGroupData[{
Cell[15870, 537, 193, 7, 70, "Input",
 CellID->80668747],
Cell[16066, 546, 274, 9, 36, "Output",
 CellID->55359729]
}, Open  ]],
Cell[16355, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->105144541],
Cell[16483, 563, 377, 12, 70, "ExampleText",
 CellID->45499069],
Cell[CellGroupData[{
Cell[16885, 579, 150, 5, 70, "Input",
 CellID->211985664],
Cell[17038, 586, 285, 11, 80, "Output",
 CellID->206779388]
}, Open  ]],
Cell[17338, 600, 125, 3, 70, "ExampleDelimiter",
 CellID->517234208],
Cell[17466, 605, 203, 7, 70, "ExampleText",
 CellID->100349287],
Cell[CellGroupData[{
Cell[17694, 616, 165, 5, 70, "Input",
 CellID->468651607],
Cell[17862, 623, 254, 8, 50, "Output",
 CellID->526912206]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18165, 637, 239, 7, 70, "ExampleSection",
 CellID->18677],
Cell[18407, 646, 346, 11, 70, "ExampleText",
 CellID->305425614],
Cell[CellGroupData[{
Cell[18778, 661, 263, 9, 70, "Input",
 CellID->18825205],
Cell[19044, 672, 755, 27, 54, "Output",
 CellID->166715675]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19848, 705, 223, 7, 70, "ExampleSection",
 CellID->30906],
Cell[20074, 714, 235, 7, 70, "ExampleText",
 CellID->61793136],
Cell[CellGroupData[{
Cell[20334, 725, 800, 25, 70, "Input",
 CellID->435554428],
Cell[21137, 752, 1036, 36, 55, "Output",
 CellID->101382076]
}, Open  ]],
Cell[22188, 791, 93, 1, 70, "ExampleText",
 CellID->7243216],
Cell[CellGroupData[{
Cell[22306, 796, 186, 6, 70, "Input",
 CellID->1021045775],
Cell[22495, 804, 207, 7, 36, "Output",
 CellID->53477433]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22751, 817, 233, 7, 70, "ExampleSection",
 CellID->19463],
Cell[22987, 826, 484, 17, 70, "ExampleText",
 CellID->344065199],
Cell[CellGroupData[{
Cell[23496, 847, 308, 10, 70, "Input",
 CellID->842946257],
Cell[23807, 859, 256, 9, 36, "Output",
 CellID->39569876]
}, Open  ]],
Cell[24078, 871, 125, 3, 70, "ExampleDelimiter",
 CellID->136414702],
Cell[24206, 876, 350, 12, 70, "ExampleText",
 CellID->228055373],
Cell[CellGroupData[{
Cell[24581, 892, 266, 9, 70, "Input",
 CellID->88765726],
Cell[24850, 903, 419, 14, 36, "Output",
 CellID->604666346]
}, Open  ]],
Cell[25284, 920, 124, 3, 70, "ExampleDelimiter",
 CellID->42140448],
Cell[25411, 925, 354, 12, 70, "ExampleText",
 CellID->84781951],
Cell[CellGroupData[{
Cell[25790, 941, 408, 14, 70, "Input",
 CellID->9397391],
Cell[26201, 957, 217, 8, 55, "Output",
 CellID->645768884]
}, Open  ]],
Cell[26433, 968, 124, 3, 70, "ExampleDelimiter",
 CellID->92237008],
Cell[CellGroupData[{
Cell[26582, 975, 283, 10, 70, "Input",
 CellID->885119590],
Cell[26868, 987, 253, 9, 43, "Output",
 CellID->968584932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27170, 1002, 225, 7, 70, "ExampleSection",
 CellID->5249],
Cell[27398, 1011, 275, 8, 70, "ExampleText",
 CellID->86171805],
Cell[CellGroupData[{
Cell[27698, 1023, 150, 5, 70, "Input",
 CellID->30263350],
Cell[27851, 1030, 237, 8, 51, "Output",
 CellID->93230089]
}, Open  ]],
Cell[28103, 1041, 75, 1, 70, "ExampleText",
 CellID->861443203],
Cell[CellGroupData[{
Cell[28203, 1046, 151, 5, 70, "Input",
 CellID->200703460],
Cell[28357, 1053, 792, 29, 66, "Output",
 CellID->391079871]
}, Open  ]],
Cell[29164, 1085, 119, 3, 70, "ExampleText",
 CellID->307079448],
Cell[CellGroupData[{
Cell[29308, 1092, 392, 14, 70, "Input",
 CellID->533825997],
Cell[29703, 1108, 386, 12, 39, "Output",
 CellID->253800675]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30138, 1126, 223, 7, 70, "ExampleSection",
 CellID->8056],
Cell[30364, 1135, 96, 1, 70, "ExampleText",
 CellID->123850395],
Cell[CellGroupData[{
Cell[30485, 1140, 285, 9, 70, "Input",
 CellID->188032228],
Cell[30773, 1151, 410, 11, 36, "Output",
 CellID->104875354]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31244, 1169, 310, 9, 70, "SeeAlsoSection",
 CellID->3287],
Cell[31557, 1180, 931, 35, 70, "SeeAlso",
 CellID->32340]
}, Open  ]],
Cell[CellGroupData[{
Cell[32525, 1220, 313, 9, 70, "TutorialsSection",
 CellID->3719],
Cell[32841, 1231, 144, 3, 70, "Tutorials",
 CellID->15469]
}, Open  ]],
Cell[CellGroupData[{
Cell[33022, 1239, 320, 9, 70, "RelatedLinksSection",
 CellID->9982],
Cell[33345, 1250, 359, 12, 70, "RelatedLinks"],
Cell[33707, 1264, 205, 4, 70, "RelatedLinks"],
Cell[33915, 1270, 205, 4, 70, "RelatedLinks"],
Cell[34123, 1276, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34545, 1294, 319, 9, 70, "MoreAboutSection",
 CellID->585766227],
Cell[34867, 1305, 158, 3, 70, "MoreAbout",
 CellID->231676928],
Cell[35028, 1310, 145, 3, 70, "MoreAbout",
 CellID->305338937]
}, Open  ]],
Cell[35188, 1316, 27, 0, 70, "History"],
Cell[35218, 1318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

