(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49511,       1721]
NotebookOptionsPosition[     41057,       1426]
NotebookOutlinePosition[     42354,       1464]
CellTagsIndexPosition[     42268,       1459]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BesselJZero" :> 
          Documentation`HelpLookup["paclet:ref/BesselJZero"], "BesselY" :> 
          Documentation`HelpLookup["paclet:ref/BesselY"], "SphericalBesselJ" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselJ"], "HankelH1" :> 
          Documentation`HelpLookup["paclet:ref/HankelH1"], "HankelH2" :> 
          Documentation`HelpLookup["paclet:ref/HankelH2"], "KelvinBer" :> 
          Documentation`HelpLookup["paclet:ref/KelvinBer"], "KelvinBei" :> 
          Documentation`HelpLookup["paclet:ref/KelvinBei"], "StruveH" :> 
          Documentation`HelpLookup["paclet:ref/StruveH"], "BesselK" :> 
          Documentation`HelpLookup["paclet:ref/BesselK"], "BesselI" :> 
          Documentation`HelpLookup["paclet:ref/BesselI"], "StruveL" :> 
          Documentation`HelpLookup["paclet:ref/StruveL"], "ZernikeR" :> 
          Documentation`HelpLookup["paclet:ref/ZernikeR"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BesselJZero\"\>", 
       2->"\<\"BesselY\"\>", 3->"\<\"SphericalBesselJ\"\>", 
       4->"\<\"HankelH1\"\>", 5->"\<\"HankelH2\"\>", 6->"\<\"KelvinBer\"\>", 
       7->"\<\"KelvinBei\"\>", 8->"\<\"StruveH\"\>", 9->"\<\"BesselK\"\>", 
       10->"\<\"BesselI\"\>", 11->"\<\"StruveL\"\>", 
       12->"\<\"ZernikeR\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Functions Used in Optics\"\>", 
       4->"\<\"Mathematical Functions\"\>", 
       5->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BesselJ", "ObjectName",
 CellID->16757],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselJ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselJ"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bessel function of the first kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{"z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", 
        SuperscriptBox["n", "2"]}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24682],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->26617],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31065],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->393840031],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177800128],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->45000075],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->308134264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"0", ",", " ", "5.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9481597],

Cell[BoxData[
 RowBox[{"-", "0.1102904397909862`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49186640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42035776],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->114350614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70556718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94856981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605478359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232918324],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "64"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "2304"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "147456"], "-", 
   FractionBox[
    SuperscriptBox["x", "10"], "14745600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 4], 0, 
    Rational[1, 64], 0, 
    Rational[-1, 2304], 0, 
    Rational[1, 147456], 0, 
    Rational[-1, 14745600]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{305, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101268355]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12306],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->337704487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"7", "/", "3"}], "+", "I"}], ",", 
   RowBox[{"4.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100710779],

Cell[BoxData[
 RowBox[{"1.1890836033640926`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.7156530815957036`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127384009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84931005],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->257377927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "4"}], "]"}], ",", " ", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80681587],

Cell[BoxData[
 RowBox[{"-", 
  "0.3971498098638473722865907684516980419756186852893888391651363324394`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365072928]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->594100288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"0", ",", "4.000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176846073],

Cell[BoxData[
 RowBox[{"-", 
  "0.3971498098638473722865907667806264879`22.870638254153242"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154649511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262493211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->843712961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540765259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2422684576748739`", ",", "0.44005058574493355`", ",", 
   "0.5579365079100995`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195532820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1457207232],

Cell[TextData[{
 "For half-integer indices, ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->514919149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43578819],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{84, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578507027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163188456],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->901551871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselJ", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205125385],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["J", "n"], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->793810442]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->128267551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", " ", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113762563],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]], 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"1", "/", "3"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["4", "3"], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"4", "/", "3"}]],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 3],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2^Rational[-1, 3]/Gamma[
     Rational[4, 3]]}, 1, 4, 3],
  Editable->False]], "Output",
 ImageSize->{149, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144589082]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12473],

Cell["Solve the Bessel differential equation:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->234677171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "n"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "+", "n"}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580259273],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"BesselY", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{327, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->643713564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175096077],

Cell["\<\
Intensity of the Fraunhofer diffraction pattern of a circular aperture versus \
diffraction angle:\
\>", "ExampleText",
 CellID->323638770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"1", ",", 
         RowBox[{"20", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"20", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ")"}]}], ")"}], "^", 
     "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217146106],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64068516]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26160],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify Bessel functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->103053797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "x"}], "]"}]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148814686],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"1", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194887519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132590385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can produce ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->279590295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", " ", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"2", "k"}]], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"k", "!"}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69537055],

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"0", ",", 
   RowBox[{"2", " ", "x"}]}], "]"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365571083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", " ", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41299201],

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"0", ",", "x"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50748457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338222839],

Cell[TextData[{
 "Find limits of expressions involving ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->564458904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"BesselJ", "[", 
     RowBox[{"3", ",", "x"}], "]"}], 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "-", "x"}]], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309344550],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "8"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154672841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4678],

Cell["\<\
With numeric arguments, half-integer Bessel functions are not automatically \
evaluated:\
\>", "ExampleText",
 CellID->57885778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299427480],

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   FractionBox["11", "2"], ",", "1"}], "]"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12433281]
}, Open  ]],

Cell["For symbolic arguments they are:", "ExampleText",
 CellID->861443203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200703460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "x", "]"}]}], "-", 
     FractionBox[
      RowBox[{"945", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], 
      SuperscriptBox["x", "4"]], "+", 
     FractionBox[
      RowBox[{"105", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], 
      SuperscriptBox["x", "2"]], "+", 
     FractionBox[
      RowBox[{"945", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SuperscriptBox["x", "5"]], "-", 
     FractionBox[
      RowBox[{"420", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SuperscriptBox["x", "3"]], "+", 
     FractionBox[
      RowBox[{"15", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "x"]}], ")"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{419, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206805271]
}, Open  ]],

Cell["\<\
This can lead to major inaccuracies in machine-precision evaluation:\
\>", "ExampleText",
 CellID->307079448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{
     RowBox[{"35", "/", "2"}], ",", "1."}], "]"}], ",", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"35", "/", "2"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "1."}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533825997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.551525807680485`*^-21", ",", 
   RowBox[{"-", "408.5168951310671`"}]}], "}"}]], "Output",
 ImageSize->{176, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254050162]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19602],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KelvinBer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinBer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KelvinBei",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinBei"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StruveH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveH"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselK"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StruveL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZernikeR",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZernikeR"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32706],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->25820]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5312],

Cell[TextData[{
 ButtonBox["Demonstrations with BesselJ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BesselJ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BesselFunctionoftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/BesselJ/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BesselJ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->308383095],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->123945454],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->34262621],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->22692103],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->692784493],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->17228833]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselJ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 48.2857820}", "context" -> "System`", 
    "keywords" -> {
     "Bessel functions", "cylindrical functions", "differential equations", 
      "Bessel J"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "BesselJ[n, z] gives the Bessel function of the first kind J_n (z). ", 
    "synonyms" -> {"Bessel J"}, "title" -> "BesselJ", "type" -> "Symbol", 
    "uri" -> "ref/BesselJ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7985, 253, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->177800128]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42125, 1452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3549, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4172, 100, 45, 1, 70, "ObjectName",
 CellID->16757],
Cell[4220, 103, 689, 23, 70, "Usage",
 CellID->23671]
}, Open  ]],
Cell[CellGroupData[{
Cell[4946, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5424, 148, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5547, 154, 687, 24, 70, "Notes",
 CellID->24682],
Cell[6237, 180, 564, 21, 70, "Notes",
 CellID->26617],
Cell[6804, 203, 474, 17, 70, "Notes",
 CellID->31065],
Cell[7281, 222, 246, 8, 70, "Notes",
 CellID->393840031],
Cell[7530, 232, 216, 7, 70, "Notes",
 CellID->31226],
Cell[7749, 241, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7985, 253, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177800128],
Cell[CellGroupData[{
Cell[8370, 267, 147, 5, 70, "ExampleSection",
 CellID->45000075],
Cell[8520, 274, 201, 5, 70, "ExampleText",
 CellID->308134264],
Cell[CellGroupData[{
Cell[8746, 283, 131, 4, 28, "Input",
 CellID->9481597],
Cell[8880, 289, 192, 6, 36, "Output",
 CellID->49186640]
}, Open  ]],
Cell[9087, 298, 124, 3, 70, "ExampleDelimiter",
 CellID->42035776],
Cell[9214, 303, 326, 13, 70, "ExampleText",
 CellID->114350614],
Cell[CellGroupData[{
Cell[9565, 320, 242, 8, 28, "Input",
 CellID->70556718],
Cell[9810, 330, 4567, 79, 151, "Output",
 Evaluatable->False,
 CellID->94856981]
}, Open  ]],
Cell[14392, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->605478359],
Cell[CellGroupData[{
Cell[14542, 419, 245, 8, 70, "Input",
 CellID->232918324],
Cell[14790, 429, 867, 29, 54, "Output",
 CellID->101268355]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15706, 464, 216, 7, 70, "ExampleSection",
 CellID->12306],
Cell[15925, 473, 226, 5, 70, "ExampleText",
 CellID->337704487],
Cell[CellGroupData[{
Cell[16176, 482, 201, 7, 70, "Input",
 CellID->100710779],
Cell[16380, 491, 273, 7, 36, "Output",
 CellID->127384009]
}, Open  ]],
Cell[16668, 501, 124, 3, 70, "ExampleDelimiter",
 CellID->84931005],
Cell[16795, 506, 207, 5, 70, "ExampleText",
 CellID->257377927],
Cell[CellGroupData[{
Cell[17027, 515, 185, 6, 70, "Input",
 CellID->80681587],
Cell[17215, 523, 253, 8, 36, "Output",
 CellID->365072928]
}, Open  ]],
Cell[17483, 534, 250, 7, 70, "ExampleText",
 CellID->594100288],
Cell[CellGroupData[{
Cell[17758, 545, 151, 4, 70, "Input",
 CellID->176846073],
Cell[17912, 551, 236, 7, 36, "Output",
 CellID->154649511]
}, Open  ]],
Cell[18163, 561, 125, 3, 70, "ExampleDelimiter",
 CellID->262493211],
Cell[18291, 566, 345, 11, 70, "ExampleText",
 CellID->843712961],
Cell[CellGroupData[{
Cell[18661, 581, 191, 6, 70, "Input",
 CellID->540765259],
Cell[18855, 589, 276, 9, 36, "Output",
 CellID->195532820]
}, Open  ]],
Cell[19146, 601, 126, 3, 70, "ExampleDelimiter",
 CellID->1457207232],
Cell[19275, 606, 378, 12, 70, "ExampleText",
 CellID->514919149],
Cell[CellGroupData[{
Cell[19678, 622, 149, 5, 70, "Input",
 CellID->43578819],
Cell[19830, 629, 284, 11, 80, "Output",
 CellID->578507027]
}, Open  ]],
Cell[20129, 643, 125, 3, 70, "ExampleDelimiter",
 CellID->163188456],
Cell[20257, 648, 203, 7, 70, "ExampleText",
 CellID->901551871],
Cell[CellGroupData[{
Cell[20485, 659, 165, 5, 70, "Input",
 CellID->205125385],
Cell[20653, 666, 254, 8, 50, "Output",
 CellID->793810442]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20956, 680, 239, 7, 70, "ExampleSection",
 CellID->32624],
Cell[21198, 689, 346, 11, 70, "ExampleText",
 CellID->128267551],
Cell[CellGroupData[{
Cell[21569, 704, 293, 10, 70, "Input",
 CellID->113762563],
Cell[21865, 716, 701, 24, 63, "Output",
 CellID->144589082]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22615, 746, 223, 7, 70, "ExampleSection",
 CellID->12473],
Cell[22841, 755, 219, 5, 70, "ExampleText",
 CellID->234677171],
Cell[CellGroupData[{
Cell[23085, 764, 583, 20, 70, "Input",
 CellID->580259273],
Cell[23671, 786, 537, 18, 36, "Output",
 CellID->643713564]
}, Open  ]],
Cell[24223, 807, 125, 3, 70, "ExampleDelimiter",
 CellID->175096077],
Cell[24351, 812, 149, 4, 70, "ExampleText",
 CellID->323638770],
Cell[CellGroupData[{
Cell[24525, 820, 558, 19, 70, "Input",
 CellID->217146106],
Cell[25086, 841, 2294, 42, 70, "Output",
 Evaluatable->False,
 CellID->64068516]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27429, 889, 233, 7, 70, "ExampleSection",
 CellID->26160],
Cell[27665, 898, 361, 12, 70, "ExampleText",
 CellID->103053797],
Cell[CellGroupData[{
Cell[28051, 914, 303, 10, 70, "Input",
 CellID->148814686],
Cell[28357, 926, 239, 8, 36, "Output",
 CellID->194887519]
}, Open  ]],
Cell[28611, 937, 125, 3, 70, "ExampleDelimiter",
 CellID->132590385],
Cell[28739, 942, 571, 21, 70, "ExampleText",
 CellID->279590295],
Cell[CellGroupData[{
Cell[29335, 967, 438, 16, 70, "Input",
 CellID->69537055],
Cell[29776, 985, 239, 8, 36, "Output",
 CellID->365571083]
}, Open  ]],
Cell[CellGroupData[{
Cell[30052, 998, 396, 12, 70, "Input",
 CellID->41299201],
Cell[30451, 1012, 213, 7, 36, "Output",
 CellID->50748457]
}, Open  ]],
Cell[30679, 1022, 125, 3, 70, "ExampleDelimiter",
 CellID->338222839],
Cell[30807, 1027, 355, 12, 70, "ExampleText",
 CellID->564458904],
Cell[CellGroupData[{
Cell[31187, 1043, 291, 10, 70, "Input",
 CellID->309344550],
Cell[31481, 1055, 196, 7, 51, "Output",
 CellID->154672841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31726, 1068, 225, 7, 70, "ExampleSection",
 CellID->4678],
Cell[31954, 1077, 138, 4, 70, "ExampleText",
 CellID->57885778],
Cell[CellGroupData[{
Cell[32117, 1085, 151, 5, 70, "Input",
 CellID->299427480],
Cell[32271, 1092, 237, 8, 51, "Output",
 CellID->12433281]
}, Open  ]],
Cell[32523, 1103, 75, 1, 70, "ExampleText",
 CellID->861443203],
Cell[CellGroupData[{
Cell[32623, 1108, 151, 5, 70, "Input",
 CellID->200703460],
Cell[32777, 1115, 949, 33, 80, "Output",
 CellID->206805271]
}, Open  ]],
Cell[33741, 1151, 119, 3, 70, "ExampleText",
 CellID->307079448],
Cell[CellGroupData[{
Cell[33885, 1158, 350, 12, 70, "Input",
 CellID->533825997],
Cell[34238, 1172, 262, 8, 39, "Output",
 CellID->254050162]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34561, 1187, 311, 9, 70, "SeeAlsoSection",
 CellID->19602],
Cell[34875, 1198, 2917, 107, 70, "SeeAlso",
 CellID->29197]
}, Open  ]],
Cell[CellGroupData[{
Cell[37829, 1310, 314, 9, 70, "TutorialsSection",
 CellID->32706],
Cell[38146, 1321, 144, 3, 70, "Tutorials",
 CellID->25820]
}, Open  ]],
Cell[CellGroupData[{
Cell[38327, 1329, 320, 9, 70, "RelatedLinksSection",
 CellID->5312],
Cell[38650, 1340, 359, 12, 70, "RelatedLinks"],
Cell[39012, 1354, 199, 4, 70, "RelatedLinks"],
Cell[39214, 1360, 205, 4, 70, "RelatedLinks"],
Cell[39422, 1366, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39844, 1384, 319, 9, 70, "MoreAboutSection",
 CellID->308383095],
Cell[40166, 1395, 158, 3, 70, "MoreAbout",
 CellID->123945454],
Cell[40327, 1400, 194, 4, 70, "MoreAbout",
 CellID->34262621],
Cell[40524, 1406, 156, 3, 70, "MoreAbout",
 CellID->22692103],
Cell[40683, 1411, 155, 3, 70, "MoreAbout",
 CellID->692784493],
Cell[40841, 1416, 144, 3, 70, "MoreAbout",
 CellID->17228833]
}, Open  ]],
Cell[41000, 1422, 27, 0, 70, "History"],
Cell[41030, 1424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

