(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37696,       1395]
NotebookOptionsPosition[     30019,       1127]
NotebookOutlinePosition[     31252,       1163]
CellTagsIndexPosition[     31166,       1158]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BesselI" :> Documentation`HelpLookup["paclet:ref/BesselI"], 
          "AiryAi" :> Documentation`HelpLookup["paclet:ref/AiryAi"], 
          "BesselJ" :> Documentation`HelpLookup["paclet:ref/BesselJ"], 
          "KelvinKer" :> Documentation`HelpLookup["paclet:ref/KelvinKer"], 
          "KelvinKei" :> Documentation`HelpLookup["paclet:ref/KelvinKei"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"BesselI\"\>", 
       2->"\<\"AiryAi\"\>", 3->"\<\"BesselJ\"\>", 4->"\<\"KelvinKer\"\>", 
       5->"\<\"KelvinKei\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BesselK", "ObjectName",
 CellID->5578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselK",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselK"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the modified Bessel function of the second kind ",
     
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["K", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14640]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["K", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{"z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", 
        SuperscriptBox["n", "2"]}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20566],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselK",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselK"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineMath"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1694],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27931],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->206335377],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126989647],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->355625503],

Cell["Evaluate numerically:", "ExampleText",
 CellID->341842651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{"0", ",", "0.53"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44012818],

Cell[BoxData["0.8765603804164857`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->804857808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96559157],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["K", "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->54648577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384118638],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0ns4E3oYB/ANM8qj6aIn8ZisjttxqVM61fH+jm4cMSl1oke51aGby1Eh
5xTPnHiM7hTxzCWZlZZIK7Etl63FyO3RylKWYmubTYdczu/88T7f5/M83z++
f7x2EaeCog0IBEIAvv/T2CNqJYEgh1sdZ6j915Twk8nrZT7GcqiNoXomZCsh
cuhXyiUzOazjrspYfF4JzUxbEnWFHIbcrasjjikh5cugCtbK4ap400vkrYSv
ZbsFf0fJgWFb+latHocBS4iZb5cDs3UbjxQ0DlUzKx7PXX4PivxRo82rxkC/
Pr7w1fYPAOVWvr6iURik/7nmqewj6PqbE4d7FRCaLN547xjOWlpjnM0IMCiC
q6esRyHnIPzy/eQH8LkYfT3wwWeIuzHWKjEchocn2EPEI2Ogi2H91l0shycR
3tzHS5Tg38bRN/LfQcjGTMecchXMsM1lw2Uy6Gpcn1TgrAb3rPojC7MHgU+f
c0iZVENwkMPN+sYBOB8TRw1r1IDjuaz+Ipt+WLJp3Ran61oY9/BZyEnrBe20
XzUjbAL29ztfb1reAxUJdV6ijTqIax3xzOV2ww8J7csWLdLD6m1S++0nukAf
7oE+9unhtjDorEWwFPJNxnJZNZOgZQRYXzvdAYySaXdV8jcwpfVWluRKYKcy
5Nuq4H8hYN7SdKBMDAOCKGKIyxSkS87c3DDSDnUXX4RR9VOQodtGjA9vgyOk
JHlHxzSk6Q58Ig62QGRCap3Zre+QeFD0qYrxAtyOOnfsCp+BEU2WTugvhM7F
LguTfp6F6rtNNVoLATy9n17oYjgHdE/RVO9cM6QSnQIlb+egZZ81ZVjaBAtk
KT4nH81DKf/3wr2vGyHxNUVM9yIgjTKQzrd8Bn7XzNJlbAJKz7NT1u/hga9/
7Qd3ChHdXfJPfLeoAVzFrkczE4mozz3P9PChx5BW2j1DHyIi29DinA5VHWgT
7La832qA3FJ55MucR9BVXMBUPDBAXwxKrDZE10KfgHex1tIQxe4dlYp2PAQh
m1txIcUQDXDX5/R4ccFKJe0RKgyRmzDA2X7tA8h3LLz3ys8IUbbaOVQx78Nf
zcwCvydGiFk7aUur4cCulcEVYhoJFc3wKpd+YwM62RZqkUVCNhOshuikKii2
jqBJ9CQkLF62M2O8EuyFlTcCQo3RbLzNm+mrdyDvR4FT93NjNFzEWd4aXAHR
E0ZdIicysp8kNVMsyiGcq6Vm5ZER2/zLptW6UmgTm2Q8myEjqoxxq6WLBbFb
318SYU9m3pktwzZ/9qS4D5upMglPx953L5anxlZorjgAtiJPoqHNktE53lNe
g5QFRsGXDjOxR2WHxqo7WeA9tNwrbI6M8h6p0q68wv39ar9j2F2a7Z/jsLOl
7QfOYqsH3+2lY3fzk5OuYLPv97qYYYeXv+G0Yu/27x9iSFj4/0tWus2T0WqN
Y1DySxbQhs84bsHWcQr5+7HbQwI9fbHdzOgeG7Apu4h7IrE7H6ZYTIhZUOIa
mZ2PPX95pOc4tnfl5oJy7KSQqB1+2ArbpXe42FYCWoMjtqtFC/8ltup4bJFC
hPdl3e4cwDar+Wregn3a4PTbEWyUW3+hDNsqNWBMi71gQZPuAvbziTVT89jv
7Ez/OIz9H4bKc/U=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.5, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0.5, 3}, {0., 0.9244189867153694}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245686603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5896193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183323660],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "+", 
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "EulerGamma", "+", 
      RowBox[{"Log", "[", "2", "]"}], "-", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-EulerGamma + Log[2] - Log[$CellContext`x], 0, 
    Rational[1, 4] (1 - EulerGamma + Log[2] - Log[$CellContext`x])}, 0, 4, 1],
  
  Editable->False]], "Output",
 ImageSize->{507, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1791167087]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25411],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->333138587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", " ", 
   RowBox[{"3.0", "-", 
    RowBox[{"2", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214104821],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.02251075513697887`"}], "+", 
  RowBox[{"0.016960737347227552`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->719467563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->475310320],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->324889296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "4"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153856889],

Cell[BoxData["0.\
0111596760858530242697451959798334892250090238884743406143577475766`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1758398731]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67967574],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->467279117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{"1", ",", "4.000000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71339142],

Cell[BoxData["0.012483498887268431470384179980806068483841547759`36.\
60205999132797"], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1885005550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249707062],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->862747241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167511656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6019072301972347`", ",", "1.6248388986351778`", ",", 
   "7.101262824737946`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1609518306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134430530],

Cell[TextData[{
 "For half-integer index ",
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellID->292672352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113153162],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{58, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1470151330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178854494],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->766292409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselK", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->443842684],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["K", "n"], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->2034044575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8957],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->275563157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{"0", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "x"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773726460],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "+", 
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-EulerGamma + Log[2] - Log[$CellContext`x]}, 
   0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394995432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24407],

Cell["Specific heat of the relativistic ideal gas per particle:", \
"ExampleText",
 CellID->429111411],

Cell[BoxData[
 RowBox[{
  RowBox[{"cv", "[", "\[Beta]_", "]"}], ":=", 
  RowBox[{"\[Beta]", 
   RowBox[{"(", 
    RowBox[{"\[Beta]", "+", 
     FractionBox["3", "\[Beta]"], "-", 
     RowBox[{
      FractionBox[
       RowBox[{"BesselK", "[", 
        RowBox[{"1", ",", "\[Beta]"}], "]"}], 
       RowBox[{"BesselK", "[", 
        RowBox[{"2", ",", "\[Beta]"}], "]"}]], 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"\[Beta]", " ", 
         FractionBox[
          RowBox[{"BesselK", "[", 
           RowBox[{"1", ",", "\[Beta]"}], "]"}], 
          RowBox[{"BesselK", "[", 
           RowBox[{"2", ",", "\[Beta]"}], "]"}]]}]}], ")"}]}]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495822524],

Cell["\<\
Find the ultra\[Hyphen]relativistic limit:\
\>", "ExampleText",
 CellID->24627214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"cv", "[", "\[Beta]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Beta]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->369777796],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "-", 
   FractionBox[
    SuperscriptBox["\[Beta]", "2"], "2"], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"3", " ", "EulerGamma"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"Log", "[", "2", "]"}]}], "-", 
      RowBox[{"3", " ", 
       RowBox[{"Log", "[", "\[Beta]", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["\[Beta]", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Beta]", "]"}], "5"],
    SeriesData[$CellContext`\[Beta], 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Beta], 0, {3, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 4] (-1 - 3 EulerGamma + 3 Log[2] - 3 
     Log[$CellContext`\[Beta]])}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->816272747]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->227],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify Bessel functions:"
}], "ExampleText",
 CellID->200839291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"2", ",", "x"}], "]"}]}], "-", " ", 
   RowBox[{"x", " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74202435],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"BesselK", "[", 
   RowBox[{"1", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->970521793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33406643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " expressions involving ",
 Cell[BoxData[
  ButtonBox["BesselK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselK"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->51676237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "n"], " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"n", "\[GreaterEqual]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287737558],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", 
  SuperscriptBox[
   RowBox[{"Gamma", "[", 
    FractionBox[
     RowBox[{"1", "+", "n"}], "2"], "]"}], "2"]}]], "Output",
 ImageSize->{120, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1421475986]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13686],

Cell["\<\
With numeric arguments, half-integer Bessel functions are not automatically \
evaluated:\
\>", "ExampleText",
 CellID->57885778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299427480],

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   FractionBox["11", "2"], ",", "1"}], "]"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2138807474]
}, Open  ]],

Cell["For symbolic arguments they are:", "ExampleText",
 CellID->861443203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselK", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200703460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["945", 
      SuperscriptBox["x", "5"]], "+", 
     FractionBox["945", 
      SuperscriptBox["x", "4"]], "+", 
     FractionBox["420", 
      SuperscriptBox["x", "3"]], "+", 
     FractionBox["105", 
      SuperscriptBox["x", "2"]], "+", 
     FractionBox["15", "x"]}], ")"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{236, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208448385]
}, Open  ]],

Cell["\<\
This can lead to inaccuracies in machine-precision evaluation:\
\>", "ExampleText",
 CellID->307079448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{
     RowBox[{"55", "/", "2"}], ",", 
     RowBox[{"-", "20."}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"BesselK", "[", 
     RowBox[{
      RowBox[{"55", "/", "2"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "20."}]}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533825997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[InvisibleSpace]", "-", 
    RowBox[{"4.857724856171423`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "-", 
    RowBox[{"4.780261608246396`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->846178438]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25106],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KelvinKer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinKer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KelvinKei",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KelvinKei"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9365],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->26756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7184],

Cell[TextData[{
 ButtonBox["Demonstrations with BesselK",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BesselK"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ModifiedBesselFunctionoftheSecondKind.\
html"], None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/BesselK/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->349732190],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->707418548],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->161200627],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->45690900],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->683568584]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselK - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 49.4889378}", "context" -> "System`", 
    "keywords" -> {"cylindrical functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BesselK[n, z] gives the modified Bessel function of the second kind K_n \
(z). ", "synonyms" -> {"Bessel K"}, "title" -> "BesselK", "type" -> "Symbol", 
    "uri" -> "ref/BesselK"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7013, 238, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126989647]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31023, 1151}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2619, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3242, 86, 44, 1, 70, "ObjectName",
 CellID->5578],
Cell[3289, 89, 705, 24, 70, "Usage",
 CellID->14640]
}, Open  ]],
Cell[CellGroupData[{
Cell[4031, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4509, 135, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4632, 141, 687, 24, 70, "Notes",
 CellID->20566],
Cell[5322, 167, 507, 19, 70, "Notes",
 CellID->1694],
Cell[5832, 188, 474, 17, 70, "Notes",
 CellID->27931],
Cell[6309, 207, 246, 8, 70, "Notes",
 CellID->206335377],
Cell[6558, 217, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6777, 226, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7013, 238, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126989647],
Cell[CellGroupData[{
Cell[7398, 252, 148, 5, 70, "ExampleSection",
 CellID->355625503],
Cell[7549, 259, 64, 1, 70, "ExampleText",
 CellID->341842651],
Cell[CellGroupData[{
Cell[7638, 264, 128, 4, 28, "Input",
 CellID->44012818],
Cell[7769, 270, 176, 5, 36, "Output",
 CellID->804857808]
}, Open  ]],
Cell[7960, 278, 124, 3, 70, "ExampleDelimiter",
 CellID->96559157],
Cell[8087, 283, 188, 9, 70, "ExampleText",
 CellID->54648577],
Cell[CellGroupData[{
Cell[8300, 296, 244, 8, 70, "Input",
 CellID->384118638],
Cell[8547, 306, 2196, 46, 164, "Output",
 CellID->245686603]
}, Open  ]],
Cell[10758, 355, 123, 3, 70, "ExampleDelimiter",
 CellID->5896193],
Cell[CellGroupData[{
Cell[10906, 362, 244, 8, 70, "Input",
 CellID->183323660],
Cell[11153, 372, 935, 29, 51, "Output",
 CellID->1791167087]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12137, 407, 216, 7, 70, "ExampleSection",
 CellID->25411],
Cell[12356, 416, 89, 1, 70, "ExampleText",
 CellID->333138587],
Cell[CellGroupData[{
Cell[12470, 421, 201, 7, 70, "Input",
 CellID->214104821],
Cell[12674, 430, 273, 8, 36, "Output",
 CellID->719467563]
}, Open  ]],
Cell[12962, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->475310320],
Cell[13090, 446, 70, 1, 70, "ExampleText",
 CellID->324889296],
Cell[CellGroupData[{
Cell[13185, 451, 181, 6, 70, "Input",
 CellID->153856889],
Cell[13369, 459, 236, 7, 36, "Output",
 CellID->1758398731]
}, Open  ]],
Cell[13620, 469, 124, 3, 70, "ExampleDelimiter",
 CellID->67967574],
Cell[13747, 474, 113, 3, 70, "ExampleText",
 CellID->467279117],
Cell[CellGroupData[{
Cell[13885, 481, 165, 5, 70, "Input",
 CellID->71339142],
Cell[14053, 488, 229, 6, 36, "Output",
 CellID->1885005550]
}, Open  ]],
Cell[14297, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->249707062],
Cell[14425, 502, 208, 7, 70, "ExampleText",
 CellID->862747241],
Cell[CellGroupData[{
Cell[14658, 513, 195, 7, 70, "Input",
 CellID->167511656],
Cell[14856, 522, 275, 9, 36, "Output",
 CellID->1609518306]
}, Open  ]],
Cell[15146, 534, 125, 3, 70, "ExampleDelimiter",
 CellID->134430530],
Cell[15274, 539, 238, 8, 70, "ExampleText",
 CellID->292672352],
Cell[CellGroupData[{
Cell[15537, 551, 150, 5, 70, "Input",
 CellID->113153162],
Cell[15690, 558, 313, 12, 65, "Output",
 CellID->1470151330]
}, Open  ]],
Cell[16018, 573, 125, 3, 70, "ExampleDelimiter",
 CellID->178854494],
Cell[16146, 578, 203, 7, 70, "ExampleText",
 CellID->766292409],
Cell[CellGroupData[{
Cell[16374, 589, 165, 5, 70, "Input",
 CellID->443842684],
Cell[16542, 596, 255, 8, 50, "Output",
 CellID->2034044575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16846, 610, 238, 7, 70, "ExampleSection",
 CellID->8957],
Cell[17087, 619, 209, 7, 70, "ExampleText",
 CellID->275563157],
Cell[CellGroupData[{
Cell[17321, 630, 264, 9, 70, "Input",
 CellID->773726460],
Cell[17588, 641, 618, 20, 36, "Output",
 CellID->394995432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18255, 667, 223, 7, 70, "ExampleSection",
 CellID->24407],
Cell[18481, 676, 102, 2, 70, "ExampleText",
 CellID->429111411],
Cell[18586, 680, 725, 23, 70, "Input",
 CellID->495822524],
Cell[19314, 705, 92, 3, 70, "ExampleText",
 CellID->24627214],
Cell[CellGroupData[{
Cell[19431, 712, 307, 9, 70, "Input",
 CellID->369777796],
Cell[19741, 723, 974, 30, 54, "Output",
 CellID->816272747]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20764, 759, 231, 7, 70, "ExampleSection",
 CellID->227],
Cell[20998, 768, 224, 8, 70, "ExampleText",
 CellID->200839291],
Cell[CellGroupData[{
Cell[21247, 780, 307, 10, 70, "Input",
 CellID->74202435],
Cell[21557, 792, 239, 8, 36, "Output",
 CellID->970521793]
}, Open  ]],
Cell[21811, 803, 124, 3, 70, "ExampleDelimiter",
 CellID->33406643],
Cell[21938, 808, 324, 12, 70, "ExampleText",
 CellID->51676237],
Cell[CellGroupData[{
Cell[22287, 824, 395, 12, 70, "Input",
 CellID->287737558],
Cell[22685, 838, 356, 13, 52, "Output",
 CellID->1421475986]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23090, 857, 226, 7, 70, "ExampleSection",
 CellID->13686],
Cell[23319, 866, 138, 4, 70, "ExampleText",
 CellID->57885778],
Cell[CellGroupData[{
Cell[23482, 874, 151, 5, 70, "Input",
 CellID->299427480],
Cell[23636, 881, 239, 8, 51, "Output",
 CellID->2138807474]
}, Open  ]],
Cell[23890, 892, 75, 1, 70, "ExampleText",
 CellID->861443203],
Cell[CellGroupData[{
Cell[23990, 897, 151, 5, 70, "Input",
 CellID->200703460],
Cell[24144, 904, 653, 23, 66, "Output",
 CellID->208448385]
}, Open  ]],
Cell[24812, 930, 113, 3, 70, "ExampleText",
 CellID->307079448],
Cell[CellGroupData[{
Cell[24950, 937, 394, 14, 70, "Input",
 CellID->533825997],
Cell[25347, 953, 408, 12, 36, "Output",
 CellID->846178438]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25816, 972, 311, 9, 70, "SeeAlsoSection",
 CellID->25106],
Cell[26130, 983, 1181, 44, 70, "SeeAlso",
 CellID->9265]
}, Open  ]],
Cell[CellGroupData[{
Cell[27348, 1032, 313, 9, 70, "TutorialsSection",
 CellID->9365],
Cell[27664, 1043, 144, 3, 70, "Tutorials",
 CellID->26756]
}, Open  ]],
Cell[CellGroupData[{
Cell[27845, 1051, 320, 9, 70, "RelatedLinksSection",
 CellID->7184],
Cell[28168, 1062, 359, 12, 70, "RelatedLinks"],
Cell[28530, 1076, 206, 4, 70, "RelatedLinks"],
Cell[28739, 1082, 205, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28981, 1091, 319, 9, 70, "MoreAboutSection",
 CellID->349732190],
Cell[29303, 1102, 158, 3, 70, "MoreAbout",
 CellID->707418548],
Cell[29464, 1107, 178, 3, 70, "MoreAbout",
 CellID->161200627],
Cell[29645, 1112, 154, 3, 70, "MoreAbout",
 CellID->45690900],
Cell[29802, 1117, 145, 3, 70, "MoreAbout",
 CellID->683568584]
}, Open  ]],
Cell[29962, 1123, 27, 0, 70, "History"],
Cell[29992, 1125, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

