(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39704,       1450]
NotebookOptionsPosition[     31959,       1179]
NotebookOutlinePosition[     33229,       1216]
CellTagsIndexPosition[     33143,       1211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BesselYZero" :> 
          Documentation`HelpLookup["paclet:ref/BesselYZero"], "BesselJ" :> 
          Documentation`HelpLookup["paclet:ref/BesselJ"], "SphericalBesselY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalBesselY"], "HankelH1" :> 
          Documentation`HelpLookup["paclet:ref/HankelH1"], "HankelH2" :> 
          Documentation`HelpLookup["paclet:ref/HankelH2"], "StruveH" :> 
          Documentation`HelpLookup["paclet:ref/StruveH"], "BesselI" :> 
          Documentation`HelpLookup["paclet:ref/BesselI"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BesselYZero\"\>", 2->"\<\"BesselJ\"\>", 
       3->"\<\"SphericalBesselY\"\>", 4->"\<\"HankelH1\"\>", 
       5->"\<\"HankelH2\"\>", 6->"\<\"StruveH\"\>", 
       7->"\<\"BesselI\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BesselY", "ObjectName",
 CellID->21948],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselY",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselY"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Bessel function of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{"z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", 
        SuperscriptBox["n", "2"]}], ")"}], "\[InvisibleSpace]", "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->5660],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17723],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->697174043],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5908863],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->7187072],

Cell["Evaluate numerically:", "ExampleText",
 CellID->627867936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{"0", ",", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->681328981],

Cell[BoxData["0.49807035961523194`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47717806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385019103],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->75544273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{"0", ",", "r"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294476947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->583904787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605478359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232918324],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"EulerGamma", "-", 
       RowBox[{"Log", "[", "2", "]"}], "+", 
       RowBox[{"Log", "[", "x", "]"}]}], ")"}]}], "\[Pi]"], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "EulerGamma", "+", 
       RowBox[{"Log", "[", "2", "]"}], "-", 
       RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"2", " ", "\[Pi]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2 Pi^(-1) (EulerGamma - Log[2] + Log[$CellContext`x]), 0, Rational[1, 2] 
    Pi^(-1) (1 - EulerGamma + Log[2] - Log[$CellContext`x])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{503, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1409360676]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22177],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->116754938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{
   RowBox[{"0.5", " ", "I"}], ",", " ", 
   RowBox[{"3", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150034167],

Cell[BoxData[
 RowBox[{"1.0468646059974462`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8847844476974692`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380255122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146780040],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->129211680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112801534],

Cell[BoxData["0.\
0882569642156769579829267660235151628278175230906755367064909858979`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36501982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141180625],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->46070198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{"0", ",", "1.0000000000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6264622],

Cell[BoxData["0.0882569642156769579829267660235151628278175229824058064853`38.\
584250149269856"], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1455972079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->298252938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->523714963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"1.0", ",", " ", "2.0", ",", " ", "3.0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361997637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0882569642156771`", ",", "0.5103756726497453`", ",", 
   "0.37685001001279045`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2094057835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->312393314],

Cell[TextData[{
 "For half-integer indices, ",
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " evaluates to elementary functions:"
}], "ExampleText",
 CellID->698203681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31454481],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     FractionBox["2", "\[Pi]"]], " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], 
   SqrtBox["x"]]}]], "Output",
 ImageSize->{91, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1868025809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39291775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->307768817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselY", "[", 
   RowBox[{"n", ",", "r"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260406],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["Y", "n"], "(", "r", ")"}], TraditionalForm]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1846336370]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29801],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->27504811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32139832],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["2", 
     RowBox[{"\[Pi]", " ", "x"}]]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", "\[Pi]"}]]}], "+", 
      FractionBox["EulerGamma", "\[Pi]"], "-", 
      FractionBox[
       RowBox[{"Log", "[", "2", "]"}], "\[Pi]"], "+", 
      FractionBox[
       RowBox[{"Log", "[", "x", "]"}], "\[Pi]"]}], ")"}], " ", "x"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {(-2)/Pi, 0, Rational[-1, 2]/Pi + EulerGamma/Pi - Pi^(-1) Log[2] + 
    Pi^(-1) Log[$CellContext`x]}, -1, 2, 1],
  Editable->False]], "Output",
 ImageSize->{351, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236671440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21913],

Cell["Solve the Bessel differential equation:", "ExampleText",
 CellID->167767953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"f", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"n", "^", "2"}]}], ")"}], 
      RowBox[{"f", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382415132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"BesselY", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{327, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597177836]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26830],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify Bessel functions:"
}], "ExampleText",
 CellID->233159827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", " ", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{"BesselY", "[", 
     RowBox[{"2", ",", "r"}], "]"}]}], "+", 
   RowBox[{"r", " ", 
    RowBox[{"BesselY", "[", 
     RowBox[{"0", ",", "r"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15189972],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"BesselY", "[", 
   RowBox[{"1", ",", "r"}], "]"}]}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1576807221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->560476268],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["BesselY",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselY"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->373587687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"r", " ", 
    RowBox[{
     RowBox[{"BesselY", "[", 
      RowBox[{"n", ",", "r"}], "]"}], "^", "2"}]}], " ", ",", "r"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1652712883],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["r", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"BesselY", "[", 
      RowBox[{"n", ",", "r"}], "]"}], "2"], "-", 
    RowBox[{
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ",", "r"}], "]"}], " ", 
     RowBox[{"BesselY", "[", 
      RowBox[{
       RowBox[{"1", "+", "n"}], ",", "r"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{381, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1450759367]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{"0", ",", "r"}], "]"}], ",", "r"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261978671],

Cell[BoxData[
 RowBox[{"r", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[Pi]", " ", 
     RowBox[{"BesselY", "[", 
      RowBox[{"0", ",", "r"}], "]"}], " ", 
     RowBox[{"StruveH", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "r"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[Pi]", " ", 
     RowBox[{"BesselY", "[", 
      RowBox[{"1", ",", "r"}], "]"}], " ", 
     RowBox[{"StruveH", "[", 
      RowBox[{"0", ",", "r"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{458, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383353131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15314],

Cell["\<\
With numeric arguments, half-integer Bessel functions are not automatically \
evaluated:\
\>", "ExampleText",
 CellID->57885778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299427480],

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{
   FractionBox["11", "2"], ",", "1"}], "]"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565131717]
}, Open  ]],

Cell["For symbolic arguments they are:", "ExampleText",
 CellID->861443203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{
   RowBox[{"11", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200703460],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"945", " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], 
       SuperscriptBox["x", "5"]]}], "+", 
     FractionBox[
      RowBox[{"420", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], 
      SuperscriptBox["x", "3"]], "-", 
     FractionBox[
      RowBox[{"15", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "x"], "-", 
     RowBox[{"Sin", "[", "x", "]"}], "-", 
     FractionBox[
      RowBox[{"945", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SuperscriptBox["x", "4"]], "+", 
     FractionBox[
      RowBox[{"105", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], 
      SuperscriptBox["x", "2"]]}], ")"}]}], 
  SqrtBox["x"]]], "Output",
 ImageSize->{419, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1996080585]
}, Open  ]],

Cell["\<\
This can lead to major inaccuracies in machine-precision evaluation:\
\>", "ExampleText",
 CellID->307079448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{
     RowBox[{"153", "/", "2"}], ",", "55."}], "]"}], ",", 
   RowBox[{
    RowBox[{"BesselY", "[", 
     RowBox[{
      RowBox[{"153", "/", "2"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "55."}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->533825997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "27823.256857458466`"}], ",", 
   RowBox[{"-", "28454.53894044622`"}]}], "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->136858661]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18178],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselYZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselYZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalBesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalBesselY"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelH2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelH2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StruveH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StruveH"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30739]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7189],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->22032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7223],

Cell[TextData[{
 ButtonBox["Demonstrations with BesselY",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BesselY"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BesselFunctionoftheSecondKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/BesselY/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BesselY"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->538892878],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->538517693],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->348531247],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->17466291]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselY - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 49.9264490}", "context" -> "System`", 
    "keywords" -> {
     "cylindrical functions", "Neumann function", "Weber functions"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BesselY[n, z] gives the Bessel function of the second kind Y_n (z). ", 
    "synonyms" -> {"Bessel Y"}, "title" -> "BesselY", "type" -> "Symbol", 
    "uri" -> "ref/BesselY"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7104, 238, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5908863]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33002, 1204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2723, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3346, 87, 45, 1, 70, "ObjectName",
 CellID->21948],
Cell[3394, 90, 689, 23, 70, "Usage",
 CellID->4200]
}, Open  ]],
Cell[CellGroupData[{
Cell[4120, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4598, 135, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4721, 141, 686, 24, 70, "Notes",
 CellID->5660],
Cell[5410, 167, 510, 19, 70, "Notes",
 CellID->1273],
Cell[5923, 188, 474, 17, 70, "Notes",
 CellID->17723],
Cell[6400, 207, 246, 8, 70, "Notes",
 CellID->697174043],
Cell[6649, 217, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6868, 226, 199, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7104, 238, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5908863],
Cell[CellGroupData[{
Cell[7487, 252, 146, 5, 70, "ExampleSection",
 CellID->7187072],
Cell[7636, 259, 64, 1, 70, "ExampleText",
 CellID->627867936],
Cell[CellGroupData[{
Cell[7725, 264, 128, 4, 28, "Input",
 CellID->681328981],
Cell[7856, 270, 176, 5, 36, "Output",
 CellID->47717806]
}, Open  ]],
Cell[8047, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->385019103],
Cell[8175, 283, 188, 9, 70, "ExampleText",
 CellID->75544273],
Cell[CellGroupData[{
Cell[8388, 296, 243, 8, 28, "Input",
 CellID->294476947],
Cell[8634, 306, 2868, 51, 121, "Output",
 Evaluatable->False,
 CellID->583904787]
}, Open  ]],
Cell[11517, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->605478359],
Cell[CellGroupData[{
Cell[11667, 367, 244, 8, 70, "Input",
 CellID->232918324],
Cell[11914, 377, 1013, 30, 55, "Output",
 CellID->1409360676]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12976, 413, 216, 7, 70, "ExampleSection",
 CellID->22177],
Cell[13195, 422, 89, 1, 70, "ExampleText",
 CellID->116754938],
Cell[CellGroupData[{
Cell[13309, 427, 181, 6, 70, "Input",
 CellID->150034167],
Cell[13493, 435, 273, 7, 36, "Output",
 CellID->380255122]
}, Open  ]],
Cell[13781, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->146780040],
Cell[13909, 450, 70, 1, 70, "ExampleText",
 CellID->129211680],
Cell[CellGroupData[{
Cell[14004, 455, 181, 6, 70, "Input",
 CellID->112801534],
Cell[14188, 463, 234, 7, 36, "Output",
 CellID->36501982]
}, Open  ]],
Cell[14437, 473, 125, 3, 70, "ExampleDelimiter",
 CellID->141180625],
Cell[14565, 478, 112, 3, 70, "ExampleText",
 CellID->46070198],
Cell[CellGroupData[{
Cell[14702, 485, 168, 5, 70, "Input",
 CellID->6264622],
Cell[14873, 492, 240, 6, 36, "Output",
 CellID->1455972079]
}, Open  ]],
Cell[15128, 501, 125, 3, 70, "ExampleDelimiter",
 CellID->298252938],
Cell[15256, 506, 208, 7, 70, "ExampleText",
 CellID->523714963],
Cell[CellGroupData[{
Cell[15489, 517, 204, 7, 70, "Input",
 CellID->361997637],
Cell[15696, 526, 277, 9, 36, "Output",
 CellID->2094057835]
}, Open  ]],
Cell[15988, 538, 125, 3, 70, "ExampleDelimiter",
 CellID->312393314],
Cell[16116, 543, 241, 8, 70, "ExampleText",
 CellID->698203681],
Cell[CellGroupData[{
Cell[16382, 555, 149, 5, 70, "Input",
 CellID->31454481],
Cell[16534, 562, 308, 12, 80, "Output",
 CellID->1868025809]
}, Open  ]],
Cell[16857, 577, 124, 3, 70, "ExampleDelimiter",
 CellID->39291775],
Cell[16984, 582, 203, 7, 70, "ExampleText",
 CellID->307768817],
Cell[CellGroupData[{
Cell[17212, 593, 162, 5, 70, "Input",
 CellID->260406],
Cell[17377, 600, 255, 8, 50, "Output",
 CellID->1846336370]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17681, 614, 239, 7, 70, "ExampleSection",
 CellID->29801],
Cell[17923, 623, 208, 7, 70, "ExampleText",
 CellID->27504811],
Cell[CellGroupData[{
Cell[18156, 634, 283, 10, 70, "Input",
 CellID->32139832],
Cell[18442, 646, 945, 30, 52, "Output",
 CellID->236671440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19436, 682, 223, 7, 70, "ExampleSection",
 CellID->21913],
Cell[19662, 691, 82, 1, 70, "ExampleText",
 CellID->167767953],
Cell[CellGroupData[{
Cell[19769, 696, 580, 20, 70, "Input",
 CellID->382415132],
Cell[20352, 718, 537, 18, 36, "Output",
 CellID->597177836]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20938, 742, 233, 7, 70, "ExampleSection",
 CellID->26830],
Cell[21174, 751, 224, 8, 70, "ExampleText",
 CellID->233159827],
Cell[CellGroupData[{
Cell[21423, 763, 307, 10, 70, "Input",
 CellID->15189972],
Cell[21733, 775, 240, 8, 36, "Output",
 CellID->1576807221]
}, Open  ]],
Cell[21988, 786, 125, 3, 70, "ExampleDelimiter",
 CellID->560476268],
Cell[22116, 791, 213, 8, 70, "ExampleText",
 CellID->373587687],
Cell[CellGroupData[{
Cell[22354, 803, 250, 9, 70, "Input",
 CellID->1652712883],
Cell[22607, 814, 607, 21, 51, "Output",
 CellID->1450759367]
}, Open  ]],
Cell[CellGroupData[{
Cell[23251, 840, 188, 6, 70, "Input",
 CellID->261978671],
Cell[23442, 848, 653, 21, 51, "Output",
 CellID->383353131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24144, 875, 226, 7, 70, "ExampleSection",
 CellID->15314],
Cell[24373, 884, 138, 4, 70, "ExampleText",
 CellID->57885778],
Cell[CellGroupData[{
Cell[24536, 892, 151, 5, 70, "Input",
 CellID->299427480],
Cell[24690, 899, 238, 8, 51, "Output",
 CellID->565131717]
}, Open  ]],
Cell[24943, 910, 75, 1, 70, "ExampleText",
 CellID->861443203],
Cell[CellGroupData[{
Cell[25043, 915, 151, 5, 70, "Input",
 CellID->200703460],
Cell[25197, 922, 953, 33, 80, "Output",
 CellID->1996080585]
}, Open  ]],
Cell[26165, 958, 119, 3, 70, "ExampleText",
 CellID->307079448],
Cell[CellGroupData[{
Cell[26309, 965, 354, 12, 70, "Input",
 CellID->533825997],
Cell[26666, 979, 277, 9, 36, "Output",
 CellID->136858661]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27004, 995, 311, 9, 70, "SeeAlsoSection",
 CellID->18178],
Cell[27318, 1006, 1692, 62, 70, "SeeAlso",
 CellID->30739]
}, Open  ]],
Cell[CellGroupData[{
Cell[29047, 1073, 313, 9, 70, "TutorialsSection",
 CellID->7189],
Cell[29363, 1084, 144, 3, 70, "Tutorials",
 CellID->22032]
}, Open  ]],
Cell[CellGroupData[{
Cell[29544, 1092, 320, 9, 70, "RelatedLinksSection",
 CellID->7223],
Cell[29867, 1103, 359, 12, 70, "RelatedLinks"],
Cell[30229, 1117, 200, 4, 70, "RelatedLinks"],
Cell[30432, 1123, 205, 4, 70, "RelatedLinks"],
Cell[30640, 1129, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31062, 1147, 319, 9, 70, "MoreAboutSection",
 CellID->538892878],
Cell[31384, 1158, 158, 3, 70, "MoreAbout",
 CellID->538517693],
Cell[31545, 1163, 195, 4, 70, "MoreAbout",
 CellID->348531247],
Cell[31743, 1169, 144, 3, 70, "MoreAbout",
 CellID->17466291]
}, Open  ]],
Cell[31902, 1175, 27, 0, 70, "History"],
Cell[31932, 1177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

