(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25861,        948]
NotebookOptionsPosition[     20548,        768]
NotebookOutlinePosition[     21945,        806]
CellTagsIndexPosition[     21860,        801]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BesselY" :> Documentation`HelpLookup["paclet:ref/BesselY"], 
          "BesselJZero" :> Documentation`HelpLookup["paclet:ref/BesselJZero"],
           "AiryAiZero" :> Documentation`HelpLookup["paclet:ref/AiryAiZero"], 
          "FindRoot" :> Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BesselY\"\>", 
       2->"\<\"BesselJZero\"\>", 3->"\<\"AiryAiZero\"\>", 
       4->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Inverse Functions\"\>", 
       3->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BesselYZero", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselYZero",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselYZero"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Bessel function of the second kind ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["Y", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BesselYZero",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BesselYZero"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero greater than ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{"BesselYZero", "[", 
    RowBox[{
     StyleBox["n", "TI"], ",", 
     StyleBox["k", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " gives a numerical approximation so long as the specified zero exists."
}], "Notes",
 CellID->43381924],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselYZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselYZero"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " represents the ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " zero greater than 0."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselYZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselYZero"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselYZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselYZero"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476814980],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->98216575],

Cell["Evaluate numerically:", "ExampleText",
 CellID->271583785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BesselYZero", "[", 
   RowBox[{"0", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20770762],

Cell[BoxData["0.8935769662791675`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159369261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347055722],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->375713404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselY", "[", 
  RowBox[{"0", ",", 
   RowBox[{"BesselYZero", "[", 
    RowBox[{"0", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139609482],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82334493]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->4879934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselYZero", "[", 
    RowBox[{"0", ",", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210060541],

Cell[BoxData["29.\
0640302527283980553047184051813443936050681215613445319582933558227`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347584342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192119288],

Cell[TextData[{
 "Find first zero of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "0"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " greater than 100:"
}], "ExampleText",
 CellID->349091422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BesselYZero", "[", 
   RowBox[{"0", ",", "1", ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343944465],

Cell[BoxData["101.31759675991941`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25009965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219294962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BesselYZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselYZero"]], "InlineFormula"],
 " ",
 "threads element-wise over lists:"
}], "ExampleText",
 CellID->65490277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselYZero", "[", 
   RowBox[{"0", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "//", "N"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->298902341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8935769662791675`", ",", "3.957678419314858`", ",", 
   "7.086051060301773`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177927079]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell[TextData[{
 "Find zero of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["J", "\[Nu]"], "(", "x", ")"}], " ", 
     RowBox[{"sin", "(", "\[Alpha]", ")"}]}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["Y", "\[Nu]"], "(", "x", ")"}], " ", 
     RowBox[{"cos", "(", "\[Alpha]", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselYZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselYZero"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    RowBox[{
     StyleBox["k", "TI"], "-", 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], "/", 
      StyleBox["\[Pi]", "TR"]}]}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->759007334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BesselYZero", "[", 
    RowBox[{"0", ",", 
     RowBox[{"2", "-", 
      RowBox[{"2", "/", "3"}]}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->309352248],

Cell[BoxData["1.89258857199296647087120429412221362873`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83916456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "%"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "3"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"BesselY", "[", 
    RowBox[{"0", ",", "%"}], "]"}], 
   RowBox[{"Cos", "[", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "3"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585149652],

Cell[BoxData["0``19.384093136192295"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294728003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64328311],

Cell[TextData[{
 "Derivative of Bessel zero with respect to ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5396862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"BesselYZero", "[", 
    RowBox[{"\[Nu]", ",", "k"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->889963302],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[Pi]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"BesselYZero", "[", 
        RowBox[{"\[Nu]", ",", "k"}], "]"}]}], "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"BesselY", "[", 
      RowBox[{"\[Nu]", ",", 
       RowBox[{"BesselYZero", "[", 
        RowBox[{"\[Nu]", ",", "k"}], "]"}]}], "]"}], "2"]}], ")"}], " ", 
  RowBox[{"BesselYZero", "[", 
   RowBox[{"\[Nu]", ",", "k"}], "]"}]}]], "Output",
 ImageSize->{470, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256997205]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Asymptotic behavior of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselYZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselYZero"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " for large ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14555186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselYZero", "[", 
    RowBox[{"\[Nu]", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70795635],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["3", "4"]}], "+", "k", "+", 
     FractionBox["\[Nu]", "2"]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}]}], 
   RowBox[{"8", " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["3", "4"]}], "+", "k", "+", 
      FractionBox["\[Nu]", "2"]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[Nu]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "31"}], "+", 
      RowBox[{"28", " ", 
       SuperscriptBox["\[Nu]", "2"]}]}], ")"}]}], 
   RowBox[{"384", " ", 
    SuperscriptBox["\[Pi]", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "4"]}], "+", "k", "+", 
       FractionBox["\[Nu]", "2"]}], ")"}], "3"]}]]}]], "Output",
 ImageSize->{430, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183636421]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselY"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAiZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAiZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->23022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->556069502],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->4982763],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->22792790],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->91331858]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselYZero - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 50.3170840}", "context" -> "System`", 
    "keywords" -> {
     "Bessel zero", "cylindrical functions", "zeros of Bessel functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BesselYZero[n, k] represents the k\\[Null]^th zero of the Bessel \
function of the second kind Y_n (x). BesselYZero[n, k, x_0] represents the \
k\\[Null]^th zero greater than x_0.", "synonyms" -> {"bessel zero"}, "title" -> 
    "BesselYZero", "type" -> "Symbol", "uri" -> "ref/BesselYZero"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8145, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->476814980]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21717, 794}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2384, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3007, 83, 1576, 37, 70, "ObjectNameGrid"],
Cell[4586, 122, 1623, 54, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6246, 181, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6724, 198, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6847, 204, 365, 12, 70, "Notes",
 CellID->43381924],
Cell[7215, 218, 456, 17, 70, "Notes",
 CellID->1067943069],
Cell[7674, 237, 224, 7, 70, "Notes",
 CellID->31226],
Cell[7901, 246, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8145, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->476814980],
Cell[CellGroupData[{
Cell[8530, 272, 147, 5, 70, "ExampleSection",
 CellID->98216575],
Cell[8680, 279, 64, 1, 70, "ExampleText",
 CellID->271583785],
Cell[CellGroupData[{
Cell[8769, 284, 158, 5, 28, "Input",
 CellID->20770762],
Cell[8930, 291, 176, 5, 36, "Output",
 CellID->159369261]
}, Open  ]],
Cell[9121, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->347055722],
Cell[9249, 304, 65, 1, 70, "ExampleText",
 CellID->375713404],
Cell[CellGroupData[{
Cell[9339, 309, 190, 6, 70, "Input",
 CellID->139609482],
Cell[9532, 317, 157, 5, 36, "Output",
 CellID->82334493]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9738, 328, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9962, 337, 68, 1, 70, "ExampleText",
 CellID->4879934],
Cell[CellGroupData[{
Cell[10055, 342, 186, 6, 70, "Input",
 CellID->210060541],
Cell[10244, 350, 236, 7, 36, "Output",
 CellID->347584342]
}, Open  ]],
Cell[10495, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->192119288],
Cell[10623, 365, 220, 9, 70, "ExampleText",
 CellID->349091422],
Cell[CellGroupData[{
Cell[10868, 378, 171, 5, 70, "Input",
 CellID->343944465],
Cell[11042, 385, 175, 5, 36, "Output",
 CellID->25009965]
}, Open  ]],
Cell[11232, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->219294962],
Cell[11360, 398, 220, 8, 70, "ExampleText",
 CellID->65490277],
Cell[CellGroupData[{
Cell[11605, 410, 218, 8, 70, "Input",
 CellID->298902341],
Cell[11826, 420, 273, 9, 36, "Output",
 CellID->177927079]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12148, 435, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[12395, 444, 767, 29, 70, "ExampleText",
 CellID->759007334],
Cell[CellGroupData[{
Cell[13187, 477, 238, 8, 70, "Input",
 CellID->309352248],
Cell[13428, 487, 201, 5, 36, "Output",
 CellID->83916456]
}, Open  ]],
Cell[CellGroupData[{
Cell[13666, 497, 404, 15, 70, "Input",
 CellID->585149652],
Cell[14073, 514, 178, 5, 36, "Output",
 CellID->294728003]
}, Open  ]],
Cell[14266, 522, 124, 3, 70, "ExampleDelimiter",
 CellID->64328311],
Cell[14393, 527, 161, 6, 70, "ExampleText",
 CellID->5396862],
Cell[CellGroupData[{
Cell[14579, 537, 188, 6, 70, "Input",
 CellID->889963302],
Cell[14770, 545, 703, 22, 68, "Output",
 CellID->256997205]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15522, 573, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[15763, 582, 385, 15, 70, "ExampleText",
 CellID->14555186],
Cell[CellGroupData[{
Cell[16173, 601, 258, 8, 70, "Input",
 CellID->70795635],
Cell[16434, 611, 1369, 49, 66, "Output",
 CellID->183636421]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17864, 667, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18183, 678, 953, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19173, 718, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19494, 729, 144, 3, 70, "Tutorials",
 CellID->23022]
}, Open  ]],
Cell[CellGroupData[{
Cell[19675, 737, 319, 9, 70, "MoreAboutSection",
 CellID->556069502],
Cell[19997, 748, 156, 3, 70, "MoreAbout",
 CellID->4982763],
Cell[20156, 753, 144, 3, 70, "MoreAbout",
 CellID->22792790],
Cell[20303, 758, 173, 3, 70, "MoreAbout",
 CellID->91331858]
}, Open  ]],
Cell[20491, 764, 27, 0, 70, "History"],
Cell[20521, 766, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

