(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    260498,       6240]
NotebookOptionsPosition[    242529,       5610]
NotebookOutlinePosition[    244292,       5661]
CellTagsIndexPosition[    244124,       5654]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/BetaRegularized"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"], 
          "Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "Pochhammer" :> Documentation`HelpLookup["paclet:ref/Pochhammer"], 
          "Multinomial" :> 
          Documentation`HelpLookup["paclet:ref/Multinomial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BetaRegularized\"\>", 
       2->"\<\"InverseBetaRegularized\"\>", 3->"\<\"Gamma\"\>", 
       4->"\<\"Pochhammer\"\>", 5->"\<\"Multinomial\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Beta", "ObjectName",
 CellID->13505],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Beta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Beta"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Euler beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[CapitalBeta]", "(", 
        RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Beta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Beta"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the incomplete beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[CapitalBeta]", "z"], "(", 
        RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20278]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalBeta]", "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalGamma]", "(", "a", ")"}], 
     RowBox[{"\[CapitalGamma]", "(", "b", ")"}], "/", 
     RowBox[{"\[CapitalGamma]", "(", 
      RowBox[{"a", "+", "b"}], ")"}]}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"a", "-", "1"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], 
       RowBox[{"b", "-", "1"}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15311],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalBeta]", "z"], "(", 
     RowBox[{"a", ",", "b"}], ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      SuperscriptBox["t", 
       RowBox[{"a", "-", "1"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "t"}], ")"}], 
       RowBox[{"b", "-", "1"}]], "d", "\[InvisibleSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29440],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20017],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the generalized incomplete beta function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     SubscriptBox["z", "0"], 
     SubscriptBox["z", "1"]], 
    RowBox[{
     SuperscriptBox["t", 
      RowBox[{"a", "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "t"}], ")"}], 
      RowBox[{"b", "-", "1"}]], "d", "\[InvisibleSpace]", "t"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30402],

Cell[TextData[{
 "Note that the arguments in the incomplete form of ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " are arranged differently from those in the incomplete form of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22869],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->66827377],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " is output using ",
 Cell[TextData[ButtonBox["\\[CapitalBeta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalBeta"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->15543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62552494],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->167259740],

Cell["Exact values:", "ExampleText",
 CellID->144841031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"5", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->967306],

Cell[BoxData[
 FractionBox["1", "280"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269201189]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"5", "/", "2"}], ",", 
   RowBox[{"7", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->414404733],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "256"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410533667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206189481],

Cell["Evaluate numerically:", "ExampleText",
 CellID->461214495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"2.3", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236580824],

Cell[BoxData["0.05402979174835722`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->583025163]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->567555255],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->713960928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451671756],

Cell[BoxData[
 RowBox[{"0.08310778366991195`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.14216394425587078`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461796182]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->572555],

Cell["Evaluate for large arguments:", "ExampleText",
 CellID->520654672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"100000", ",", "100000"}], "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2747732],

Cell[BoxData[
 TagBox[
  FractionBox["1", 
   RowBox[{"890281443636940069", 
    RowBox[{"\[LeftSkeleton]", "60172", "\[RightSkeleton]"}], 
    "135939217539200000"}]],
  Short]], "Output",
 ImageSize->{353, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->165211433]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"10.", "^", "6"}], ",", 
   RowBox[{"10.", "^", "6"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->719085793],

Cell[BoxData["3.61640469448921900725729473`9.81127204824129*^-602063"], \
"Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196669033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392763304],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->81499434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{
     RowBox[{"22", "/", "10"}], ",", 
     RowBox[{"33", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97037539],

Cell[BoxData["0.\
0564856913732825668070517540044914293695377770152411824211757452302`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244758193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108355827],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->71905740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"2.200000000000000000000000", ",", 
   RowBox[{"33", "/", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40373818],

Cell[BoxData["0.05648569137328256680705175400449293895`23.589672321931033"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133595278]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"22", "/", "10"}], ",", "3.300000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->534691918],

Cell[BoxData["0.05648569137328256680705175400449580526`23.765763580986714"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34564762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210679119],

Cell["Series expansion:", "ExampleText",
 CellID->516976087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Beta", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118300406],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "a"], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "-", 
     RowBox[{"PolyGamma", "[", 
      RowBox[{"0", ",", "b"}], "]"}]}], ")"}], "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "+", 
      SuperscriptBox["\[Pi]", "2"], "+", 
      RowBox[{"12", " ", "EulerGamma", " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"0", ",", "b"}], "]"}]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"PolyGamma", "[", 
         RowBox[{"0", ",", "b"}], "]"}], "2"]}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"1", ",", "b"}], "]"}]}]}], ")"}], " ", "a"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "2"],
    SeriesData[$CellContext`a, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {
   1, -EulerGamma - PolyGamma[0, $CellContext`b], 
    Rational[1, 12] (6 EulerGamma^2 + Pi^2 + 
     12 EulerGamma PolyGamma[0, $CellContext`b] + 
     6 PolyGamma[0, $CellContext`b]^2 - 6 PolyGamma[1, $CellContext`b])}, -1, 
   2, 1],
  Editable->False]], "Output",
 ImageSize->{366, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270443406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760443585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["\[CapitalBeta]",
    Beta,
    Editable->False,
    Selectable->False], "(", 
   RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->434560486]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->181036055],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Euler Beta Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10993277],

Cell["Evaluate symbolically in special cases:", "ExampleText",
 CellID->298788561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"0", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226653574],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311395924]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290848674],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->594822126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"Infinity", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80241163],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143556662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172644019],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->301332388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280711331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "6"], ",", 
   FractionBox["1", "12"], ",", 
   FractionBox["1", "20"], ",", 
   FractionBox["1", "30"]}], "}"}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59341905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182964011],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->505929579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     SuperscriptBox[
      RowBox[{"O", "[", "x", "]"}], "4"]}], ",", "3"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261287071],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "3"], "-", 
   FractionBox[
    RowBox[{"11", " ", "x"}], "18"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "2"]}], "27"], "+", 
   RowBox[{
    FractionBox["1", "486"], " ", 
    RowBox[{"(", 
     RowBox[{"14", "+", 
      RowBox[{"27", " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"2", ",", "1"}], "]"}]}], "-", 
      RowBox[{"27", " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"2", ",", "4"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[1, 3], 
    Rational[-11, 18], 
    Rational[13, 27], 
    Rational[1, 486] (14 + 27 PolyGamma[2, 1] - 27 PolyGamma[2, 4])}, 0, 4, 
   1],
  Editable->False]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87370160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512320018],

Cell["Series expansion at poles:", "ExampleText",
 CellID->336075855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Beta", "[", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "z"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"z", ",", " ", 
      RowBox[{"-", "5"}], ",", " ", "3"}], "}"}]}], "]"}], " ", "//", " ", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259926810],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["126", 
     RowBox[{"z", "+", "5"}]]}], "+", 
   FractionBox["1627", "10"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["60649", "600"], "-", 
      RowBox[{"42", " ", 
       SuperscriptBox["\[Pi]", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "+", "5"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["2945663", "36000"], "+", 
      FractionBox[
       RowBox[{"1627", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "30"], "-", 
      RowBox[{"252", " ", 
       RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "5"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["161926081", "2160000"], "+", 
      FractionBox[
       RowBox[{"60649", " ", 
        SuperscriptBox["\[Pi]", "2"]}], "1800"], "-", 
      FractionBox[
       RowBox[{"63", " ", 
        SuperscriptBox["\[Pi]", "4"]}], "5"], "+", 
      FractionBox[
       RowBox[{"1627", " ", 
        RowBox[{"Zeta", "[", "3", "]"}]}], "5"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "5"}], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "+", "5"}], "]"}], "4"],
    SeriesData[$CellContext`z, -5, {}, -1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, -5, {-126, 
    Rational[1627, 10], Rational[60649, 600] - 42 Pi^2, 
    Rational[2945663, 36000] + Rational[1627, 30] Pi^2 - 252 Zeta[3], 
    Rational[161926081, 2160000] + Rational[60649, 1800] Pi^2 + 
    Rational[-63, 5] Pi^4 + Rational[1627, 5] Zeta[3]}, -1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{532, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->882461057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10054809],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->788929685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249508285],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["1", "z"], ")"}], "b"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"Gamma", "[", "b", "]"}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b", " ", 
       RowBox[{"Gamma", "[", "b", "]"}]}], 
      RowBox[{"2", " ", "z"}]], "+", 
     RowBox[{
      FractionBox["1", "24"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"3", " ", "b"}]}], ")"}], " ", 
      RowBox[{"Gamma", "[", "b", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 0, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {
      Gamma[$CellContext`b], 0, 
      Rational[-1, 2] (-1 + $CellContext`b) $CellContext`b 
      Gamma[$CellContext`b], 0, 
      Rational[1, 24] (-1 + $CellContext`b) $CellContext`b (
       1 + $CellContext`b) (-2 + 3 $CellContext`b) Gamma[$CellContext`b]}, 0, 
     5, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{565, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145115440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Incomplete Beta Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->51693688],

Cell["\<\
Evaluate symbolically at integer and half\[Hyphen]integer orders:\
\>", "ExampleText",
 CellID->647654465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"z", ",", " ", "3", ",", " ", "b"}], "]"}], " ", "//", " ", 
  "FunctionExpand", " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406590799],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "b"]}], "+", 
    RowBox[{"2", " ", "b", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], "b"], " ", "z"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], "b"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], "b"]}]}], ")"}], " ", 
     SuperscriptBox["z", "2"]}]}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "b"}], "+", 
      SuperscriptBox["b", "2"]}], ")"}]}]]}]], "Output",
 ImageSize->{361, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136072827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{
     RowBox[{"13", "/", "2"}], ",", " ", 
     RowBox[{"7", "/", "2"}], ",", 
     RowBox[{"9", "/", "2"}]}], "]"}], " ", "//", " ", "FunctionExpand"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428496326],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "21123178"}], " ", "\[ImaginaryI]", " ", 
    SqrtBox["143"]}], "+", 
   RowBox[{"35", " ", 
    RowBox[{"ArcSin", "[", 
     SqrtBox[
      FractionBox["13", "2"]], "]"}]}]}], "7168"]], "Output",
 ImageSize->{248, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299472639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221705813],

Cell["Series expansion at any point:", "ExampleText",
 CellID->869625340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", " ", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "z0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49535822],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWs1rE0EUn2Q3SdO0SapU26TYWu1FRDxo9S7qQVsQvXoIRWgPotTeS/EL
UbHiWT2J/4TYkxVB/WvE67izO5NMfvtm5yMBA83uezPvY+Z9zHuTrvV2Nu/d
7+1sbfSWrm/3Hm5ubTxauvZgO0FFJcZKbxhjq3MseefJW/onPvvJX/aavb0V
35Ea5ewMwL/TWfuAPQvwr3TW4+S7kiBrMDppwFckPkqeAl2B8Z99rqzSx6a4
PK8pgClZeS5lEhuTejwB7ATAZbkaXIVaZRXwkYfsp5bV2VaPsM+6nwEW1+G0
8/EAZo4rFzoK8Hs6/pziWqBFS+6620rLAGcyac9DuzcAPkZSRTALNTjkyscE
chJG68lXOQHn5Thyw93IuH3TsKy/k4cw953kvSKfqex08C7MXAF4oj/zJoxU
OR3RKkaavDjyzZzpOCbtmZvVJLFuHpJpVE+xBwcHLPuIqZdT8+7u7sqZEdfy
gJUvZcnwbDHqviHcdtrXcWuRShnKGK0cxnc/7jhL1v3TZ71NwP4B+IYTrwVn
PcsKz6Zh9C8hWUWZoDoh4VjC6GslJ657lNVyVBjZJwFeBfiFhR4zI/K7Ra4F
TwfkegrgCwC/tNDjmYD81jWYKe/NaWXzRlO2bMD4goFPWz6n+SBD6XS4iqoc
jy3z1HiVF+uJ66OqEpf1rhN09t1EeJTToOFB27Xo0SKpaO18qli3Cvj/crTZ
yK1uHcWSt3mI7+ge739KozSayuY3KnrNVqC6EdxRWnYxb7dVj4OHr39gNaUy
Eu6Cm7Qw3wirmfDcDMslQrYok1AHtzjCWVXJLYyatntYJ2qz+3hsEGbvNPsE
1KYNRzr0DOw33c6TGYrKQbpHzg/kJipQ7L+jwD11Oj/G0lmE+4qlr4h1bMwG
VZU56iKlNUlrixMBHiX23yxTURVrpu8sSz/F80Ns6d+rqVulddJ+5DmhwbOk
DJyV994pkq4srSTbAaavSrZ28oMVN0pcJvnTUpfM1rJWx7Z7J9Sz675fWN/T
neSQh4vMMcfpG7F8fpuWM+swk8w96Hc5uSuSW1M+l+WzJcdnDHrZ+tmuI90a
uUfnJXXHskZ1f/Ae8NiNm6Xo8LwGC/t+hvGLMJ7ZF+9LzkmdsHv9BPAlUkfx
ir9tDN4WJe8jQIter6w3C3i8ZbgK8DLAr/tSdeyM5N7mAx/Rx1E7vEW4AvBp
gF+lUlXHHsun8ibVUVM51NRp1wx0rt1FaIff4W43Gi0Ln/TeJpdfh/NCqmMN
chSnMxUVRz6dZ1nJCxj12edx3nV0PGixPymoDAK1cbYoZnTvm/iCatwRa+rY
bdYa7XYBbeB2u2DqnMN0UCvd46S19JlElOnZq2ifzLdBsbNNfCMprLOk8pd/
d4/nRUjEpJHGTF2OWwzYf6/xjR2qB0Q4KOcFdHYdRzoy1w3RtQM1sOY4nj/V
qdNPnZLmOFEV7HCfhnzIuwPYafcODKvJyUJq2+0HVgIjnSIFnQx2inVSziLM
wuyJFV5Yf6mqMtTZnPWGOu/cLQFGEv0bJGoxqDZFxIgIFraJ2KDarnGtmvbq
3GJidZW+a2oB1e/qoiKqoV4a+78Fgx5ZDf8RsAUVnzbrOEVVYPcvZlm5qHft
7b6SPNEjkVv2PyIfwIJd+fyRrbf0D1a6hvk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{399, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255399040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", " ", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69196080],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "a0", ",", "b"}], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["z", "a0"]}], " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", "a0", "]"}], "2"], " ", 
       RowBox[{"HypergeometricPFQRegularized", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a0", ",", "a0", ",", 
           RowBox[{"1", "-", "b"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "+", "a0"}], ",", 
           RowBox[{"1", "+", "a0"}]}], "}"}], ",", "z"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Beta", "[", 
        RowBox[{"z", ",", "a0", ",", "b"}], "]"}], " ", 
       RowBox[{"Log", "[", "z", "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"a", "-", "a0"}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"a", "-", "a0"}], "]"}], "2"],
    SeriesData[$CellContext`a, $CellContext`a0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, $CellContext`a0, {
    Beta[$CellContext`z, $CellContext`a0, $CellContext`b], \
-$CellContext`z^$CellContext`a0 Gamma[$CellContext`a0]^2 
     HypergeometricPFQRegularized[{$CellContext`a0, $CellContext`a0, 
        1 - $CellContext`b}, {
       1 + $CellContext`a0, 1 + $CellContext`a0}, $CellContext`z] + 
    Beta[$CellContext`z, $CellContext`a0, $CellContext`b] 
     Log[$CellContext`z]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{551, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406729871]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalized Incomplete Beta Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->215540193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"x", ",", "y", ",", "a", ",", "b"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->933796700],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Beta", "[", 
    RowBox[{"x", ",", "a", ",", "b"}], "]"}]}], "+", 
  RowBox[{"Beta", "[", 
   RowBox[{"y", ",", "a", ",", "b"}], "]"}]}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389644919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38450684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{
     RowBox[{"13", "/", "2"}], ",", " ", 
     RowBox[{"7", "/", "2"}], ",", 
     RowBox[{"9", "/", "2"}], ",", " ", 
     RowBox[{"11", "/", "2"}]}], "]"}], "//", "FunctionExpand"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127330320],

Cell[BoxData[
 FractionBox[
  RowBox[{"7", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"11159185", " ", "\[ImaginaryI]", " ", 
      SqrtBox["35"]}], "-", 
     RowBox[{"3465180274", " ", "\[ImaginaryI]", " ", 
      SqrtBox["143"]}], "+", 
     RowBox[{"45", " ", 
      RowBox[{"ArcSin", "[", 
       SqrtBox[
        FractionBox["7", "2"]], "]"}]}], "-", 
     RowBox[{"45", " ", 
      RowBox[{"ArcSin", "[", 
       SqrtBox[
        FractionBox["13", "2"]], "]"}]}]}], ")"}]}], "294912"]], "Output",
 ImageSize->{514, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360917123]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->745597232],

Cell["Plot the beta function for real positive values:", "ExampleText",
 CellID->497859830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202594063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246416522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191771802],

Cell[TextData[{
 "Plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " in the complex plane: "
}], "ExampleText",
 CellID->45360317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Beta", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", 
      RowBox[{"-", "3.1"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127660828],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy0vQeYHMd1Ltq3e2YXgSBFMSg7yZav/Uw/W1aygiVZtmzZWoqZFMVMgjmC
BBhAgEQmAZLIOW3OeRcbsIvN2JxzzjnnOOe7t86pMD09swDk9739GoOeno51
/vpPrGqfp995ceNrT7/z0rNP/9l/bHr6zRdfevbtP/v1G5vYJuN/adr/+jtN
0ya/qrH1/8PW6N//AYC72D+2es21QvZpYwc8Rd+K8NNgX+mb3Fps2oqrT9LW
EsvWJ66xFa+i2ZxbNW0D+w930y3762z1N+pe8Nstlj0Mt3P9J/1XadkPdzFu
8Ngy0Qprb3D/EnFv/PwbN24UTeZ9g8cXiqfnO/BjdXku0fY3eq6r4lx2i+xw
1Uvcp/yft2yu+GZ+WnwGqyweor2zxPlRYpqd35+6Be1h+j9DnHG9aEe6WfEo
1rM+SEekiT3XiSM1L/8a8K8WC/vOjrZZjnyAjkw1XYsQFFADno62W46+n45O
EketF2ex49GGOlrT8cNQT+mGIH6WRMs9rGFnsfnXuGDB/Nz4gPzu4yzX1wy8
AU3Dz5sCXM9gff776AzRpjPg/zY6ip8CV9df5yz30lmOiOt/1QXJzr3s4uxG
IHuy1a7Ab12ztvQ9dIXDbni93e3ZA2uBnT8QT8c+7JbrrPsfXufLFungZezs
/F6W86PUNDtHixCBh6v8bpWr3GJ5Gj2olu+BD0ULXtPbck18RiV38Wi63GcV
zN29yh1ssDynHe/AUHeg2dj111iuj9cyJOzs/AbETwIF+OtqLbsO3HlrjURQ
cB3QHdjw2vImUK5rsXdgF6eear5mAHVWa4v7uCB0rfj/Jtlj2XU0I6gO2LXw
crrbNW2i3WXP1Gzma+p40Wu09m/p6mcsvUwzQuohpA4XugPe1uqqGsraENfU
LW3uZcIxrd7QHZyyPLceWs+loW5E3oceKOXO+xI+vy7b24I9833YrnMf/033
cdzaEl5hDcDuhS/sZqhx+N3Y5N3IfkA3hEettdyLzXIv9uvcy38pTFjxJ/Gh
2cIbIEwuNmotfnfurUW86aF3uNxVNZcU7SuuwSVzSHyzMqvUspoR3gjsZtii
2di9GOxedLwVg98MAtjmAcWKE7koCVPWOzSsWKK+fO2241r/c9F2N0lWjGgE
850aHlvNfJ94e/TcFrzJPm7lGamF8M/7OvfIbZkDogUls2m2qCaIpAWvze5Y
D8d/rE1XaVdkIWKjIOSBG7hPanNz30R9dyP3+gk47SJ+luhmYLfLFk3HG7ZH
NuJds5tmC7ttTd63zXzfeNOiXenmBR483b8u7t/JMea+fP37/g+6773qfp19
SGlkW0wzRNMS1Qw6exR6EkM9huap/QkT7Na95D3b1D0LJtblHdtUy7NbR366
Xr//Nd3kLlNb09PHtIDpXqNN97pqqyN/CianJpe9EO+aOh3CQ/Q83cTmdrf7
tt/wfe8Q7Xqzat+4FoiVi+Upoq73FDo+hdAEHD+rPIlL+zu1oPUZvPAZnPpd
tC1HyXbxzXnn8a0Q14qXY49gsLvXDHb7/OY1nX0YCi0R8t4JLcTLnARcsO+8
d8PChRL7XFqBykAx911kFikHq/eDq97gbtfKfvZPtL5VPOEt8gm9Etogni2t
oB7VcJeSwJphelLVf100kOod+KCip+OD6kJSkunl0fig6+UTCsvQJuwV3uOv
jTjUPq7WmtWD/Afa/Dhwz0ta/mYekFymJ7aBzppDs1saRPMkec2IcmE+flYO
XJS9xC5ThvVOy8ETgm1CC+qW/oir6yxtI/un13XahfxRu3pGgQPPbfOEBS13
CIxYNb20OfRL7Wx7Yjuw9sLmwjbTWWPp2Fq4P+/onK/sZgxFNfMdWE9vAtVh
PGsJS0+xBSnccK/DE3utt+gHvNt112upG0TQIwJB1uOl33Wr4oykDkhqh0u0
6KyZNBtvKN7TsKU0gwOLWsnS28QTmjlx1ZbS7E77XLSVxj0ibB09sMZFk66X
XgG/RAC21x/bNnbxlJxNnrLsf7NAjmoLe3IHHoUtQo3igp1EK3bsCjtswSYh
hrDqOY+tYVhwQ51RcI4uPDLZFtgM0lOS7cEBc5OlPXTxHHaP7WDe87se20N6
MRIjekon+523CX7qrFWMa/UmLwES+uP8Y3jgHs0WaWoUQzKPoZhHs9oA0m+1
4sTsrZutbhJmAFpi1c5Yl6AMiQmpfb6rGNe1zWScTKHDuNwFqZ248JbxiJZr
9yDqKx71ldLMNjNglF1E1+euHMKG9JVNk/rKihybah0X+8jJNNzSu15/+oXi
W2Im8f9tEh1pXaCzJtFZg1B72MztYXjoOVyqrCUERnSTnopBmJj7js3cd6gd
SKhm7aQ6kEtLSP/RZrar7OZnDyB28WyT/Jye+QXBDOpZ07sZutO6gT3zZVpS
CQv43Do+tiEeHB8an9zOn5xLPB6ff3XWEL3EacmrJ/dgsVh4VHomvJPUmq0z
XYY8NPkXKO0zt5jSGtEaVi/VGhfmrfOcaJ3bVc/I6IErbGGNRC1lM7eUvko7
UW+ho1Vv0YxrttKqdoxN2TGrWjHuPYb4ROM2ndnb9F4tAsb+4xGba/eaf6E2
eka0zR2yjbwye/EsrKVUY2FbmXuR5sWaKaUDkmnBlpItxJpKAMrAfnRj1otw
Cl17knFtO88DnhQOEVSmqKVb9MxzBI83Hp1h7XVa7mfUck+Ce/xIaaSsXtCx
Idfwprwim5K1JMcctqVm470zhRbEHZeAMnNUc7q0pk21ZgwytCAkydruvGTi
Z+qVXpZeKaIcNqG3rG1mjfTJqO8Gayux1Z8rHaX0u2mPW6TuyumDbFqwnQhx
mT3gbCmOOPfeqXkjfdOfk8I9WD+ytYjD4ywcLtppFQ4XbUXIc+Nw7JuGQJ2Z
vVdrLYknM8Zw9Xr67KfUio8KfH1FsVduP7CWY4um/3Ftp3Ebycxsl1ZpN8n/
3Bpx6jzplWteGEKj5nJvMde+Sme4PvdzXnNqPNWC4jvh7Y9swZ+A9C3MeSk9
rx901og6NuE6RGAvZNHCWjHDYyt2Cbxcg/k8WhCsFQ2JOptqRaEbqB3tqh05
4WmS8eg4pQlUF7VizqZaTNrcliyQtc08WeHubfagQJ3To88fgKu0uLafodpP
I6az8wZUNKdJ24vbo13KHuUoTJLNp3m01PFY0hy8+0rNIW0Q9xZUcS2851Ws
L09taZjakv/Z3HSEzdKSa1exyX5MLXi/RJvlV9SwZC8UDuLF8gchH9uUNSy2
K/XuXEvvNnjvxpYlVNyAzdLu2R9EQSIj2jgjcsP2mnat1bozlHWnkRYx5bD0
YFNUqpYHFXThAVnz0tZcjZelbe2rWHjWHv7P1Nb3CLR+XaLVVjgErH0LqIl1
1sAu7euJPZXcb9zWMYRFaLhEaFSzurUr2YO26CZhD5qtQUQuWYOGNcpnQmut
sgGpRVfLjggL0NqiMubnljVhq7zP+4hW/Ibq88VDUESLpiNabbw9WXOKFtUM
1qS5tGhmNuUt6Vkn/U8sSJfW1ZyRHUMyKfV2K5OursENmXJVLSvT3JJXqTXt
qnVFdFj659eLev2I2vO/RTt+S/5aOgwlw+y+WLPqrFGpTe3mNjWzq2bDBqU/
1qKEU5vST6w5dVN7Wn19ZUPakkwGpC4sSKdvp1rT7LXgcWtV3kkky9z41YJT
7PsU1TTxqec2lL6bm91oacMfUhv+v5atdwqMfkv19LJh4O3KFpeWNVTLOtnV
jg1Lhie3PclC1+xOfqWm1bBtNUMZ6ZrEK9evyRQxkDC16nwG2FYR3+a6y2Zu
ZdIIArUeOfaaVie3xlxtJ3PFi+IFS17GEu13sZ44J9+4BKQXbd3baSmUj0AZ
LZrOJKOb5KLZOSlbJENHedB7Xha5SHvMULpP6CThPGHMz2RVXFIxLlfPiUuR
Q554GT/s6IWaEM+89UZw5WaPUT+vEOmgKy4x9wHD1AdMNQBCsxn+f5w9+wOS
yF8Dj/Tp4v8viz7xp3LvylGoGGVPwAShMzGgFDQ79pAhKKZFMrrOBMF9biYG
1j84myOTX08GhONrsfj1egYejx3DFBPAAKPmZZEDk4JOZrESg6ZbI4x1vHc4
7Q/eO9y4yFBy4DUHrLW9LBJYJ6ImVpvu+9Tyd5m24g3IWOufKTaqGsUfWOtX
sHZn7a/ZsSsQRXlgf2oF7AYGmtbU/pqyrNdaPBOnFLol7tOpH5gZSrMrWZg4
SjE/6UmeeWONb/WJpZ2CH2vd5aD6grZ6bNOTDDS7YqhAZ4WJ2VZBZlojJeHP
JbFGSII6ivSiBdI5M/09ODPhuPXPcStGWqrHgC1VbLFKw2DS4KLQJC9p3tgb
6K/QjZnMno7NLA+dSYOkZ9XCl121sGZXXMSVMM+D4tXWqN6gBOK0x+2r9QWT
jjBkZQ23vzEqYWl9FVc1nHFVw+LXVMM6Sx+wudjeTv1gzVh+z0UKMhtjjoP9
qfSBasZAZyLR7EwilSahaJ6kotmKSSLc9LymLs+VihyNTqXLNTI5TbpcaA3p
LmnurIXeknbtGK/FsrdLVym6yeQduWpyKoDi3UTU2pmlZe0rhsm6V9khTUY/
3OWEq2jlX6/W85886nFv0Wu+DSIaVzcOtbQoaXlZpGXSJyRVFJOBUhpEZ0tD
bUJnUqECJaccFzkRe3i0ubwUo6mu5NKTuJjYn+pJVFFg6Ulcs9hjTXZXLApL
WLe6x/iVp9iVzSIlp5xFbFnUEeirSAsPoyiBRULWmACX0A+ERP5S9aT6caij
RdPNcvF2lwtZW3SMMIaHwCmfQpN87E75OPWNB1/DRT4ZUj5r3OXDe5EhVQ3n
OupA15CNEevix/E7V9kALiGbWet4iC2yriQ1jqh0q3Wr31Vax+wdkxSZVLyF
hDSDF/j7S/1/nf7EM7DfE1L6Doh4TsMEsKWeLSgvFJoN+9MY1NBCkltjlhxS
n6Zx+4BsNEPZaJqLf1gwAEpq3D/EJ7imjaAkZmcSSzdJTPQ+C/G52MmeZcZ9
j1hXK8Fb+YlmYXnmPhEpcvYhESbSRJW5l8VKYMJyWm18JIUhJGb3YCtY+5hV
av9IUvtH0ce+IzVT4wToTGyanQuOd7dalKCUmcENCRQbHbGqVaetUVwo3ByS
m/JwRKykT8RK7BbZaWhTUE1CBpnZPH6a3iUsS97bUqm3ER/azJaF4kKzjR3v
9D75ny2WeLHZGYdWvc1utfF0U32j7sG2sFh20q62SgwZ0CQtXMUIlM0qLc1Z
EW2VHG77K6XDPO3xF7IPNk/i7TdOAhOrRnK1meXqwqJ2JleNnCXsjtIWcUrW
zKJ2i2Q5EqSG81KWiFJyhrAR6S4xiSptdhvvjGnObJbTDkmS9KmkaTP3RHpy
i89ERGqLNYlTaTezajNVeV7fYnS111GqhqhZucmDJGUe0L2Kx20cntsef0n/
/Z3ok/9beVEtk8Ak2UTCVD3UsySJPpw91EWSpg6qJLnWqQ81rYCibryPXu3n
3OoSiSBPmGtEafFrtgzVN4Xdv0ZF35TnJexJsxZUvTBeht7Mvm+syOHanYzK
5Sd8Lcmlwtey3bDslA8lNJxVhs5Iuwcb5X8kz78Vcvxb6Y+1TgFbWtjiSa7u
zIt3vL6GnDjlxynhiujSMI8uaTYmXBXUoCO9FfnekGw1e5Yp+o9dVs/g0VVt
vdPaMZk6ybIAUZMS1ngps9dqMhXRVH4Fc58MQ7Uo7ExD5kXZr5JfeYTJvbZj
g7+osub6T0X2V7cytT9Cfn8t+qOUo942BToToGa3iNBT38Stom8ayLI2s+yo
X9rM/ZJLTOQZXPUm8atm52aqRXcazjyDyJCR1eMiPUOZPZqIjJg6J8UG8WjW
O22mGgESoUWO6EiQJNa4h0K4EHVrJsxT7yTuUL2TCZX3ONeeSXE9jIZ4sGY8
ZRNXk+Ffgbs3/jdy345paGcLk6pZss2eJEvXFHxrSM3pLlPBtWyLmWvXmIVq
7ozUF21mrUn3+mVlDmXJ1BE3aAXjWhwP2RW5De/02K3ytFnkqTyO9cqajXaz
YU2901Vj2kx1MlKeTJjKZ3fKc62/rOZU3dSjbPU/UrZ/IfonRSPRXuychg5a
bkSqdMYG6q5scZOt3cK1mjnLUkrCFVEzU28VspUsK+whznfcJDJrUW0dFyyX
raiG4lWK3LqlK/JOyosSPdhCcYJvRRUUvxb1XJNUm4VUI/igARep2kQVDy+A
5+69kikXqAeZ2oUHYrPGYoRcSd42Qbj0J0fwcQv2T4Xs/l71z65p6KRF05kE
NRuXYRstJEVhDXEp8mMaydVE4tVNMtQM5WxqyttU92FWnaQ5vUqk2lSi5LFo
tnOeiA3Q05hNW91s23orOWaa+ig/yjvVNbom9eUqfEuxLPyyxtonVQTAGfGs
cz6VzcSySoKGEp9mlZ8u5Odt8SAx5mnVn1Yv4+9Igt8SkvsH2Tu7Z6CLFp0J
EWWoMxGqPuildCbb1WL5GE6t6TlewNu/koI8Mv7GJLeu1JzLce2HHrxNg4nO
UDnkLJJWFrGrjv/ZONOyP2nPelsI1iQ7CofG8agA8qqLT2Lm27WryRGDOLqo
CzPkaFAbt3u4EDE4rXJnNlGQSX/rPUjNLvwPa3SaS+vror/9o5RWzwxwmemr
SIyYGMVl49JiwrLIS8V3DCUvEVWplimHSlN028vsTnKBUWRnjTBzOHFSn+MC
M0zRAb6QiUOyMtuq1AdvctGNFrkReYqMvyGkhbEcnvHhkQH8pJ7nHdviiTQ5
RzozbVJm2Mk4X6repirQ/D16GwHX8zZM3/8fkt7XQPj1TiPGzJ323llg8lQi
1TzJlKSu3A93yRpo5UgWxTtDcXo7JSl7nvI4jBKXHCqxoCjf4KypaVQPIySJ
PY/klkW9DrkTr4Jbb8lyZU6zBM3qjw+YE56gebQnRbVjXXufXcZXRXSHS4Sr
P2ssTlZtUejapuJxIodtHmuteJSL1umBBJg9EJmrC1DMuzqbkneoqglkZu8f
pMT7Z6GPFiZjTUcRe+RaqS/Zb+6M6+5rejt7sEp4YIgPZW4omWs6dl6vchUJ
cvUvuTHrEkTHR2fy5r5Jjuy2Glk9eD6SNlthP+XIHm0Wfpq0fXhJLtU90Umd
eUEuZx7p4XJvdpE7dee18arSWdNET+ZDuUQnlpKnyAD24GCqhDKxL8XPaXfs
17WudSUevBXKosuaE5B/eAbOwDgmhfqIsmKdn3gHfy+ZeWAW+mnRmdQ1b0vf
RrGjjYSGkg0FT39ma9dQQtd0FLuhurgmPRnDwtqir5soW8mct8E6d8/U3M91
IXM9BwlaFb7RKm3bIGTeJ8VuEvhlCigk8xpsLm2VCFYZRgzt8dElJHW2xImR
e0zWJHilYZWRS2KmsJ2zNoW8lmAxgkSxtppNw4OVpBl+avIjm5C1t5T1NaIK
f+OUupe71NXsVqa9OdoG54AhYAB7u8TAWo8Y6OTCp97vbbaWFcmT/iYM2DkG
sOuT06PsZYkC6v34cROPN5mBwNaF2zMkKEBnQNC8CgkHvGIGyV5obOz3Qv42
Jmobfl3Hf8/tk8LvkcLvorEexCeXVM0z68yqv69H6ZOc2QYGDPR+eKEeCVzY
Uzoxt9k/tYtKPFebynDV1Dcgc09ejs0if0+8/r+d8rdb5a97QMBfy+OH5oBh
QNPZh85goF+DCUj+UgMYDAMcABrZb2Yt3zQhRIIMYAjZe6O819aMWX2j8mHV
90tEXYgKXShp87ihFLJQ672k5Uni3rzHmyUuq+Bp3Iog+HYabcmDwrqIE2JN
oJeswLTHNAmm5+Jn1resQWhW7E16PbSes7upCpP+D6518YwMi2fkrBVUGFjF
N/ISVva17DWT1D30ertF5n8lOX94DoZoMaxSN3pnpNR526nO32kKdThjk2ss
Kr9xQnyaJe9VN8b7xi08ymE27sx6Xok9T9Q2a0KHm+y4HlC93Gbu5XS3N5kp
nolcyLsN1Mh0IW97NK8C17GKBFvOKXMSO/G4F9ufK3PW5cOI4/kMEMHKE0Zu
R6lTp7cpqeNWKfcgiy73MntWTNSs66+19HdzfsfqX/31NSXuZZH4t00S54tu
kbq2jht7vdS93Tn/mnxP/ZH3dy54HpVuGBfWXj3KnrH+rRqZfXVc/WsaU/1V
q8CgcEhGLbl+4hUSqs7IltnjtOi9cfPtvOfz9rTQfSpX9B3Ojs+BEEOCRQzg
/B94GawJjhZDIWNMPX1tYqtw6RJanWqf4cE5/txZ/7DGMwpsCgWBNU57fRX+
97Zgwa2KeBX+/46LXW+OP3tbMPHn8siROWCLZnhChYFkoGmICvICcH+TLSg0
wJRZA1DOyUwHrqgwFCo0W73w+fDL7XXcGXBDBXfeFTNoFMXmzJBNoED+p1wv
RwM66nby1rNlZCWX8QKGYm4xKwUnLkghKHZQTrisKSNtH4XlyOyDGGEd0w6M
JhhHICzaILkdPxMJGVFythTODpQUZB/eq+kDySByBJSQt+bmu8sRJG4jijVN
8L8co7jGIuk/kWiwjc6DEribvHGPNYoFmLS7iQW4uMnyN1yZny5ttflsTZL6
0epnwjaElL1QyuvMUq40lU+Z81Fm8mf9XgRd7CTjDBnwpOgZb+lscutoFaW8
PrtXuHZMytzSUzpATCfAex93z7DQHAsHuWSFqDWNfbIeHtcMCS3Y7bmIeQyA
2XvcrpfjnQO5x+4mY7oK9nqnzifHPMDpxXsaz2LV7n+lpGveapXyN+XvY/PA
Fk1HYa/Sv2k79/g01Pc6dnCbWeQuHj6HqEXXN7l2biFttPDp7KKPk9TX8D4v
BC8TyhhPxfOuKx4WfTt/UFh6OWpUo0YZRSb3blGUw753Cy3PdQDr5QoATPx5
0hLI5NXysjI4uZOPa8Qj0cxDEZtyTtiQVOm+Fr83iIXtFNmAOIilDi+OTmGE
0YJbGRD4HFfO+RpNWp5t9xI+H/n4XDtwJaAZbv19nUCDdYSoleH/0iMa1lrQ
8HX5+/g8jCMaGCQQEZwHRqQZIDBB/h+HhKa4f0MfEYE7F3ATkH114YJWFWlH
HsAkCV2fib5BVBWsRSzcwb41yhhQLS8xMCW8GA9wOCjDX5EAL61z1nxT72Jg
yKSFR9PXuqMhx3WE7JoMqRXi2iC2FbgNIDqqnUKu4fWYpgqjaF0djxyF1cuo
TiMktUJ6ByKAQYPZgUzk/mypkbE5u5C99PdlVQF+6i4WoYkVXJDgJTyB641P
sfKEZ2SssyDjq/L3iXmYQGQweEh0aMbonNAQms6wodmG5sSDo5YYnHX1EuxO
L4GwIaI2zoSoNBRbJ52VC+bc9noyAzgiUGOM8xb7EgdFxajQDGZE5JnggHTA
8yakN9IlR1zpgowuyDDhws5woUChMqXefDwaPwdTEwntiAgRvdF4vlKUUmpe
4aoGiBz9UOnn8/WoBuQIPb6Z18gy5RBQC77Mfvet4gEcTY0SF9af3ZNF4BIj
sMb83LJnN4iLb7tYBzdZ8HCn3HtS4IF9uGDCPiIxMczBYAwhFpx40GzOcDHT
HNJO7LbYiV4KDi5YYPKXYQJsTkIE8xDq5ULWoaEwwrXqLcyOqJHkwXFSQjhh
fgPTIgokmTT2lXBpR01gT+vEUP8VWqgqECFi5/k4Zibm90Oh9DlsBQOoShjO
sFaQpieMZp2+GSKaIExU2oYiPELrZaWtEVqnMmval9hKSC2CI6wOd4ig3Zio
mVgZKs5XOi5W4ooCB2cLJvggjggvTwixmxEiq91xp/UWVKhZesBZ1645pS2k
v8GCBjmHkWZMLcAkW5AUrIgwRiQrEEvYBB6YFpk1RxE1rz43h1JHSKzpdKUH
VzyIam6VKNC4TcEdxzrM9rEPvX6MOxAcGLgXGp43c2OEW5kMHdzE5CzCKYRr
lGwZRUonCuFVLTiQUcci7Q2IEgkUhhIGjxxCSAHxRckgOamDginWpHahdcmw
wYAR3iiwEcrneeGVS4o1QmpFkoetYMQI9ct6th5euxJSsxJUteJfsXKxfPli
xYpf5Yp/lSOg2kG3SZZjkEKG/RoeZs0qHqYVH6uN8beyx194xM3NFtzcKn+f
XgCGHE3HD4MDyBOruNshNmmHMBANSjsE97qpTxohilTc8UP+Bz2xaRQAcYkm
Yw4MEUgszCQdk8giP4XhRm9G3Fmwo+lYomwrH0Vq4bzC7T8GHmZJXCFeYN8x
koyDX9cxX5L9n0rL5Q5gIGLwyeyC7G6EDx37JYadjfKvkLQZY6m0HkjqBGaP
MHIJpxhTqEwlkIQktYicIRkUyC4oaBImA05k9VJY1VJwxVJA+ZJv6ZJf2ZJ/
+VJAxXJg5TJnF5vJJvXIKrxB5BhBiQoRj1jnMeNonc3Aih2KMVDkQY6YlTFo
mXXE7VYsqRmKZhZgmhbjGmiiPRmiOCfpwrMlNH2Jo0mTvg7qKBOW3IGE0Wvi
H+7WcCg5sxZ4JZ61YItRRwxEPg0nIWIgLwalFlq4I2zOeDA8qZqutaimBlBN
MSwpR1WjaYE0HQuYvZnPyfDEvA22pLZDWgdcESNIiHc2lA1B9QhUUsisgGiN
nYqTEbNqGZAYikIaZByD2alBIhsVwrNR2q2cToKkR+pbCRcrILBiKapqIbxi
IaR8IbB0wa9kwb9kIaB0IbBsMahiUc1sK/kI4WP2fImx6YpBsjTPg427Qdgy
1/N9OYLI13WrRLhWhS1+p3nA2B3cbMITX/RVMKXZxucFMXiyiAW20P6heCNn
KoUts6fkzlAajY9omjTVs5jGl43x51PoqpNVLeuVjmsaR0hxeCmDmp4b4y43
s1PWEKsxbccMoQKCF6OqjF6cR4HDiw8Qp9HhXjycyZfkNukBaRsYW+X2QB4Z
y2WDUDcCVcNQRllY5k0xbcjYTdVDeAeQ64O8QEPyEFB1wnK5jasiLu9zpSsM
QtEVcxHlc6Glc8ElcwFFcwHFc4Elc0Gl88Fl85qc/I3wElTDiSnYqe8sfjR3
pblmtJuRRbaPf7WL/rsRK/nPCDVrJVbE1uuj7HYLe62Tv88ucGvZjDe7wtsE
BxqymDFGOJuHUWFfM5zZhkWUhidoNLS1NW8BNeIwYV5rIhdr8DIM+o5o8zYH
Xxk2ZHU/Is2Lh99FApZW0KbSbmJsJgxtV6y1TeKnRnFdQuXNSGWjuBQOw9VB
yCHuSe9BqDEGEml1Xv2EmbMvazTLM/9jDnRKG2pIZmNldKKGZL8W9kHVENSP
QvUwlA9BYT+ikPuToY0QWAd+NehPXaRMCddoHG92Yf2omV7PFi/5Fc1pelTp
jLY+vGQmpGgmsBCXoKKZ4OLZkJJZRFk1iEHZVqxJv12/IevbPL+XeYwc992d
6KOojluNhgHuI6okfxKunGi6Qc67w4JGxZxzCzBLixsmbcLMp4iAwfBok3hk
mxCSiEfO6CphqFHU6E4n+81Y2Y99dkx5igBwtSqLfwwxisioGWX3WTsKyvWj
qBGa9ncy4mMwZBjkZ9NIPXM815BSLR2BgiHIHYAsojsGw8vdGPBjilDM+o5U
cWeczOwltGD4hsGQ8V4qQ2I7BnTYbqX9UD8CDaNQMwQlZOozmyyiGfUoApB5
8xcqWXspn01YVGSP2dRMRvK9H15nCud982ciiqaiS6bYZ2jBlB6UP8WUZcFU
SOF0aNE024mBT+hMm8DdjXt9LhXQGh+XaZ1vjvSrhwyhe3W7dWbwW28YfzYP
uFNz188vwBwtOmIPj+QqWDOUDtZcYg+GZEQvhUAVgEAAal9HCM4iCodpxR2E
msm2c4JQIrBx0smHcgzbWl6FVEWpJ7bO0IhYHOV6mKFRb0DebB4XPMj+2nht
G+redeyU7GQVo6h4GRtmMzbsQxgyKrzUASqeFNVE0xXoMU2gx7KVr8U1QXwz
JDQTHFsQixlkA5YPQBO7D5qHIY8p7za0487VwJkqOF0JJ0rgXAVcrBRMGEhM
qEkk2gl7p6/OXsybDsufiCmaiCyYYCt6cN4EM/3yJ0ILJsMKJ7FXhDi9SKE5
CHAhdWa9a8Yij1262nUyQ01xCH+s43ZFoFeAqy4GS0zbiioiLI9YJISuhmXL
2VCqX7Vg0mbCJF/0VXCp2aeIKF1jIIbyOJy62ulxaGs5Lrk3O+KKTm7LfYkH
Q7qnPfiwzVOorrnHUUt2HFagY2jcXknFUOyzagQNfk1n6DRq8RcGUIbNJtq9
HSPvnYwe16vgPDstO2G1JMicAcjoQw3Nc9oIFB795i/joSyY9o2oRgxmRrOl
EWIaMaoZ3wTJrZAmWbKYTMO6AShlJNuC9t7JStiXD7tz4NNcOFYMZ8vhfAVG
tjRpzdWCjIJzlGFUPVjOF3wqd/pC9mRI7lhswVh0/lhE3lho7hj7Gpo3FnZ1
PCJ/nI4R8VZvWXlh0tbXqrMRyFM5t5usvCnQaX37y2qjgjwjU70xzfK/Of9u
RaM688ICLCDuVsEj6mlC7RRFVhgedQZIF6YUutqMRn2Yge4ODkS2cBIdJl+Y
I5KTpUYRlW5TWQ8v6+A0Kfy4GjUE1MDKXEOBUdPZh84gqdeIXJ7BGLJtAhCG
eg9WjHRzLE6h3q8h97d8VMbN2A8J7cDTMAqFOM4Ex/SF41iTiHqIrEc4MiBS
bP3WeDmQs64XOgagiCn5RhQ0g92OTHjrEmxPRxQeL4YzZRKF9GYLUaGjbeA4
PJk9cT5jPDhrJD5/JCZvJDJ3JCx7JDR7JCxnJCJ3NDJvlCPHFkGTXvH0z5oQ
UeHjxoiafOOgaT4SD56HwCDl6G8QbxJJ3Bq8w/IrYcrmxBQ7fpHhg8HJBU3C
9xUIYXjC6ByiyCWyi7+NCq9D5Ix1iSRDIYnvcwffx6J9NVkzxNHUNi2ITaOA
Lg/Z83g9TVOneVUQs1UMY/Ef+6wcZow3zIxltrGWGWJjIOA0CT1T0D8trtFB
aKKMLT7Q2ss9kNQFicwtbYeYVhFE4xE0PlIbo/JhTPY3h0kOCiZyymyGum4o
aIP4evCvhEN5sDV++e3E5RfDwFsKU0Q4SBPexradyBg7mz4amD6YkDcUmzsU
lT0UnjUUljkUkTUUmTMclTusUU14bIsoEw0X9YHsHrzkjKIqasvHJwZRCEZ6
s+Y5HBAkcp5bjzMHX/O9HbcpzGA7OWdnXVqARbm4YcXCPMaUK99Qr+UVBlwJ
KttMYkWnYgOlHjV9jK2uH3XVh7ysiIOlYwZ5R9QZNknjrIaGnvPUjmbg8A87
H+JaOoTRiPIhGUdjgGHswxzHpjEXrAzOcJ7RGQypErxiDJUgM8wYWBI6ILYN
ologvImiZPVyfmxDWFHU++/0LYezJXCmCHxL8dfLDZDHRFsLF4thX+LSmxfn
Nycssu2vhsH2JDiYC6dL4Vw5xtD8pfJT/sEdXNkdTx8+kzrsn9qfmDsQlz0Q
nTkQmTEQkTEQmTkQlTUYnT3I9klsEyVmUVSKIBBkZwiyy1kovcxxEA4em6W6
xNtaMWbKFprfckL7gvNtHauwDH5fXoAlxAX7MCzYMUc8dOFd6ibsIMuQxcGx
w+Ej+GbEGWFDrrGNzAqVJdBjjKOvOSaNKguCOokTmJBbpAVVRxYUz/6UjziH
flH9+Hq2c/GgCG6VD0LlENQMC/i0jkPnhNBOtw3PithxL32ys7MzsrMwHzOt
F2LaIbIFwprQMA+mMpBAKgWg55e5vK9iZLUK/CrgQhmcKYbzxeBbgrtEVEJS
HUSUrhxLWtzmO/fK0en3EjAC9lroytZ4+CQdDl+FM6Vwvhx8K6kVAq0xCobW
r7Afjl4ePJ006JvUm5Tdl5DZF5vRF5XeF5neF3WlLzqjPyazn+1ziSoeY/lA
BY4oPhpXzg5UB3JOfaLLYJmj0mXlutmesqBM2k/W+Y6vF9f9BiHt9msgbRmR
xj6saCPO4y4lwxuv1laJArSREFcCddYKGBllGxXRXPImmKDZwkDnRJzOEEfH
e7MVJ/DmRKCXM88tncRdFuTVyDB/ybCzlrlA5pS9GPRKBqB4AMok9Aht9o4J
6J6EvikYmYExeYWb2eWYm8nMfQbgohHIGoDETghthmAKSATIyhM/0xskv46B
KIa5SvAl2DH+8i+D0HKIIiSFlIJfysJ+/9m3P5t87cjkBwkYDHszdGlbHOxM
ggMZcLwAzpUh7PyqFPK+yXAcIqse2MYjyf2nEvovJHQnZ/YkZvTEpfdEp/VE
XcbPmPTe2Cu9Gs2jYy6VZcCLdAUeWd0yE3EtC970ZgLqXZopa2DJdVurpL/u
hjI8g6qQWVmEFQSUCWXGwoKnuIWNm08cZJLXyCnkANOc2aixOYEwthDGkPU4
pWk8niYRpq2ZmMOwBzuVC8xmeV/cwMnNBWIUZzDjS1VI2/ksAPn9WMNQ0CdZ
rGoIaoehYQSaR6F9HLomYJDssYlZvCDyGg+FMDdxEvKH0DtkJlQgjkz0wyp1
P1mlzgxpvk6RzW+zrxcr4UIFctS5UmS2C0VwPh9O5JB1HTj98RcTL70/+sbh
8W0JU2zLptD5valwMB2OZsOJfDhTgscylAlFWY1KjBdL8AEVhy/1nIjrPR/b
qemX0rs07/i0rpjUrujUrpjLXbFp3XHp3YQFHKrnFW/CGa/e41ymynWE5rQi
zVM0w6UC74/MlH9NoU3XnPU2OkOZZqwQoUlOMxja0FLXCG7kAmq62QrzMuON
kxqdy5z39DYjDY1z4jHhs43MKZ5DOX+FAWxCLma8aeQP9rvqUw45Zrhb8MZH
Yphm8lH18euv9iLoivugdAAqBjGAWj9MmKMEwwjad9M4pmyA/MHuWWifgeoJ
zKlf7kLnL0CIRr9YxWum7Jx/GNg41DSdAUb7GoMbU4xHrsK+dGCA2pWEO+07
NLH5g+FnXxl869DoRwkTbMs7obOHsuF0HlwsAL9SNO6ZEmacyFYC6LxB1bxj
arcej+4+F9WekNqRlNaRmNoRl9IRk9wRm9IRl9oZf7lTowmjEtvkALBmiFGV
4bxAFM0z8livhTLnmwk1zYXRlH/ollu31nmvjjbz1jukV+BYBLYI/OkMfobA
nWZblJhjixl1aLfRsaKGQ3PqUcyLKssNrTYy2rx4QIF/corjFh3DFgcco0jM
w0/Sd437jMRwCnFdswJxrdPQNIUatHpc+ClYzjWIaW0ctY0N+BVeu5nZjUW/
uT1wtQcKezFSXzEgEIfYGoehSZichvlZYJAbo6v0zGLcIaePv5dDo07eAOdr
KJxaBidK4XSZiFtdJD3JQMfYSccvX0HMlcGpEvgiF3ZfhnejsSbnna0jr7zQ
v/Hl/rcPDu2IH9sSirD7OHrOvwSCyiCkCkKY71gNgVX4GVwt8vaiPky7+VhE
15mItriktpTUtkvJbfFJbbGX8Gt8cntCSjtHXQJN3k1c5hWjpnGQoNPlVCqc
4EiXWkYdEticlaY2M+5qnG+1c3ufgqZ50Jy4qr47FsCBnOVYcNGkEmeoTWk7
dzI13QPSuD3EuW1qXmRFLRFWHnKgStR1mrTUzHAbJR5j2LIjztA3tWhSjjM+
toGzTss0NJIKrKKIfekIt8DWq/cN8KoeXrqT1QXZXXC1G4rkzLlfbRiCthHo
HYOhCRibhAUTypg+5iWpzDsIaYaLtXCyAg4WwYF8+LwADhfB8RLEGQMZ9i1f
ZDqGr9sZsTGvkfmOJ4vhs2zYErHEfn5199TT93e98HLP5i8GdsePvBcyxjbu
jJoOqYaIWoimwFiEnEOHFxiSRgwT73y66Whox+nQlpj4ltTklqSkloTElriE
lvjE1oSk1kvJrRxhPL+ayIdESXa7Ds5oAhh7iIrm8vSBstpcsKaZ3pPHvU7r
eyesrEa2GY/0r5otlbMV3GZBo02hccEFjbRtSfiuwpNw0baGCo7xaKv3FAX9
FSSltyqxSHn5WYxmaAZ5rByPHIx2ZDqMN6CmnbNadsxzZW7E8LzQgiKGwfSs
yo7nUzadV21gRRCffTmFQu9YCNSGkXh+3Dfzu6G4B6r6oGEAWhguh6B3FKan
YGEGpsktvtqPNWhsJaoNPi2Gl+JWnvNdev700tZkx74cOFgAR4vgZImIlXLa
I0wanAWpRfBjw+Yw9E9f2TX56L+1v/RS17uf9+2NH9waMsI27o6aZJDBoXFy
hIQRQ9Z+BHqX4WKAHPsfVznijgS3nQpqioppupzUlJzYdCmhKT6+KSGh+VJi
c9KlZpIxohMrB1zH2Te6QFPpXZ4WkH+qyNKjB2tFpvRgre+Xup4H6xGp2o3W
izhR6+XgXIgmokZwJfdXkzaiRKsxJ7TzLI/OCayumbIAVYKN61CRK6WFoiv2
IUmfo5y2yBvBsyFu17uDdpTOPL4gQMv9ipuYw1AxJtKdHK4q5c5HWMaLWfs2
JLfA5VbIbIe8TijugrJuqGCQ7YWWQRgahQUG1mlU2MLjzeyFsGbYXQCvhC4/
sHPh7lennzi69GaU48MU2JsJh/PhVKlAK8Ww7mQ4Zetny5A+GZbZppd3jD36
q9ZXXux4/7OeT+L6t4VgSG1f1DgmZYmc0zqxmi65DVOv0Q2gRyKQIog+IyRC
bzoU0HIyoCEisiE9sSE1oSEpriEhtuFSXGNSfGNyQqNGMV6F0XUW+uQw1fgr
MziDEsJW9UGcvGk3oVP2vjV/JDKpVpeiwdRG3iBzUGpF4lJlFkx4XOsQOBMs
qrn4xxKNdAQPwWjEoaifpxfAIxo1PmZAsw3OmtCI0bV1Co0ckGydw5JrdR21
uhcH5Dg5LtMEfsLgzZxCW2egfgqqJqB0FAqGsegti3LvSR2YV+JjvAiJNzNW
imdE1QQpzZDeAhmtkN0Gue1wtQOqe6FzEMbHYGUa+keFbcKszaAG2JkHr11c
+t3WhXtfneDa9sNk2JfJswv4Fb2VO305DkmNv+03w7Y/+qvm115o+/BA5/7Y
3o9DMBD3adRo6ahg5bw+yOrGhGpyK/Im5reiGWRu5YMP+d8Xfo0nfOvCwuqu
JNRdjqtLjq27FF2XFFOfHFufEl+ffqWWw5DPuOgtvBPTjF+RDVyQrp6wTZUQ
X3tMEo8ROyvr1nrwisU+HvP6yhtxyUsoRlwlj6+i0CZErjcxpMSiZEbajyfz
NYpDr1f0aIUi0dewqF3C8QqGHL/ixXGpmVwZHcFoKCBqhERjag6m551eLyKQ
nRnnTiGQd85C8zTUTEL5GIbr8inbkNqNeSnybTG08XUeQmNMw2y4+AaIq4eE
BrjUCMlNkNYCRR3Q2Av9QzA7DguU16+nQiTfWth1xfHU8aW7tyw88Bragj7P
LDy5f5kj9ZMsOFqI0GNEeIEUORYpaXdcqMRKkU0Xsdrj0X9tfOP55u372z+L
6d4ZgiG6A1FDmpwKv2gQrvZhpTqDZEob1qPEoZ+LVSpfipE5188u1B87XxMS
XJMRV5MWW5MSXZMUVZMcXZsSU5saW3slvZoD0i6nWHbiUc2kzBkxrB5M0edV
EenuNbu8q9yKSDkSxprLx1WureVskNdCIO59qwWBNwkEepn9Gzc/WtvACRGj
0QQ2M/w0OYJKDnNwjpyagf4ZGJhhmBQjp4ZnyMkxJA5vYzhU9uHcPIGdse08
gnOMdPMIbWkjKqyYQPDlDEC69FnwLdjhjZin0OQbIek6YbUQjr09jGHlmxHV
EFUDSZTiqumEtl7opYjixAC0kgl5oQp2JK48+sXyvVtmH34NLb97npt7YDNs
PAab4+DjVNifDceLRA6Mo1DHIM7X/KoxmMyw+Nb5MQJi/VsbGz/e3/pFdMfu
YIzjfR45wNyw+knMsJQN4wisvF7E4hXS1JdaUVPHNTtH4K4/cK7m6JmqYP/K
jJiqK9FVlyOrkiOqUiKrU6OqL0dXZ6ZV0n40r9662GYno7rYj4REaUHabsx7
dsMfbrC+qdqqj2+/Yezpq2DPVR97s/90aSJq5NqQX6PdskBEaEbhlCzs5IXt
fJzEsKwpxuj0gJz4i4+O0HQGRo6aAXIhEJT6EPu4ncFSoXBkBiZmYWYOFui8
i/O4PjuP155fhIkF6KftDVNQNwVFcqb4xE6IoVEuYQKNWDv+Zef8vKwrV4J/
OaZb/cogsBziaiCjAa42QxmVE492w2IntLdCuphl4UuPfLL8wLvTj76GTHb/
xpknPoDn9sIbF2DbJfg0A44VwMkil0waRa/vZHB868wwYbH27efqd37adCiq
bV9wB9tyMLKPfZaPYki8YgRKBrEU+Wov5HRjbd7ldiwbTRC27c2fnq48cqoi
8GJ5emRFRmRFWkRFSlhFanjl5YjKtKjKrNRyoaE1NVsnn0NO1AEiLdq5pciz
cuQhWfxtw6O/bdbYQdJudEGnV4Dn8eRWdN52Ax63uY7pFk/49BQTkv4Nghb9
YZ495sUHLkCdF0DFlAq/mqou4Fk6gyffqI5OzlawhteCYBnTNPRNY8affR2Y
5pHCbzDADk2LZXwGQzTYg+ZhaR6W1U0sYq9gyO+gUzXTZ84QpPZCfAemQSKa
Mb3rXwsXGY2RnfdtHpW+QEmPM8VwqhAuFENIOURXQSJZ7Lk10FwDUw3Q3ADJ
dXAiDzc+uGPl4fcmH399gK0/9PzUxj2w+Si8fxG2RcD+DDicC8fy4WQhnC3F
6KMYR05Ive3NU+i+PPrL6s3P1u7+pOFIZMunwW1sy+FIJM6rA1gewVmTIbWo
H/L7cKxZhpwH+JZE+eaDfSfLDx8v8z9Xejm0LDOiLD2sLDW07HJYeVp4+ZXI
8uyUEtxJvmlG53MBS/WtPO9IPvsRpvFsZjWuqwAk/QmwGhbLMsjCoqZRzi7z
zHqsYb4ugm+zbN2gvnvGqc3y3RA6HqNG2vrl6yKVGGDtuKmcgTnIQ2QK9ot5
MxGnmGTopRK7rmn8pMYwGFr1/inQbh6chlHC3fwsLM+BYx4YSJfn8eLzlKZh
bMxOOibipd7Mpkztgdh2iGgR2GRqWdPPV4KBtelePIzDGI/x3vEChBbd59fO
ZUJ4BmTnQkM51NVAQiUcoNTJ/VtXHn1/7KnX0R78/YsTrxyC3RdhfwR8kQyH
swUyTxfD+TJU4TxZxytKcETHGyeQK//wy8p3n6nau6/uWETTZ8EtbMuxyM5U
crU5PrEMg6bxK5KzI2d24Wi2pDaB0g17jpUcOlLqe7o4NagkK6wkI7QkLbgk
LaQ0PbQ0I7w0J6lI8Khg0BYxGSOfhXNtjGTUKEuEqIHHn6T/bfAJdFf1fILM
0SFT/Sgi1P5HYvLLhMkvg/MdiZxdF4Av660sKdEntT3fjlsRj+uWZcGWwOM8
KluORzwK1fy6SZOuZ4gcIUQOSjjytuM4VB6MrWsKuqeglwLiBv73jd5JGKCv
kzMwNwtLc7DCcDkncDnP3KFZDBHNLQj6raNhjhn9kNANvo1wrg5OVcLxUkyr
nCqHM+WsbZgPohlnKYtCN4Eft3+aDnuT4aMY2B4Gh6MhJBUy8qCKMWkx7IvC
DMu9m1ee+GDkmTeQ6P7w0thbZ+HzCDidAudyQT9fxHrWhRK4WIZlDqJagc77
pcBqeP0YHfOL8vefrvhkb83J8PovgprYlhOR7Ze7gb+isGRYTDkmsufEm4hL
sjmFnbnrSNEXh4ovnChM9i/KCS3KDC5KDyxKDyq+ElycGVacd6nA85tU5evu
zHreZoale37aEzYpqC7mi8FRSnLmCDk7txWTNFOgZomPcySakHmTiRfpNtj/
ayxoXCvQaMcva1Tu2smI84hAenaGQR1BuE5ZmooMlV/cM8OrNXHwjlfHFJYH
M9x1TkIXH0PRzf77RjfhaGQKJqZhdgYWGR/OSujNIRIZ9Bx0yyuLjvkl6J9D
j4F9TR+EgGY4WgEHCuFAAXxeiCmXw8Ui9vHNE8W406E82J8Ju1NhewK8FwHv
B8OecPgiBoIuQ9pVCM+FvcGOFw4g7J7+YHDjG51s5YmXR94LgWPJEJgH4ZUQ
XgVhlRBYAcxE5UhjdBgg6/xeP9xJkCvd+lTZ/j2Vp8NrDwfVsy2nIlrSujGB
mTfAj8K3rTAHB53tHgxIXunCYXAi6rjjYP7nnxeeO5J/6WJBbnBBVmDBlQC2
FGYGFmaFFl5NvKppzvdpqJmJ8V2lCm1KV3P/Rfnbnu1KcySSRjEJxBEZ8jPw
YXIyNolcaI2Uu0XQV+HEW6+LR4QktzsXwMuCyXXSB5ec6OVEJEGPgVKfQyRy
ZuTkOEmIYR4y06AjpJ95vVUnFbursWmajsN5bK004LFtAjomhLT6JmB4Esan
YWYG5iUqGUszPmXA1Lwd8zxev7K46JhdcgzMQ6OcB8c4USFtGjrXt75g+rgQ
jhTC4QI4lA8Hr+LP+zJgZyp8mABbImFXDBxPhPMpEJgG4ZkQnOrYe9Hx/G5E
5XNb+198A/PCT786vDcROTCiEhIbIFoIUbNxNGIlTTXowTXc5n7tYBvBsnjb
UyWf7S4/G1Z9NAjDhmcimi534dQm9C4mPH5NwSAGgQpofuVcmjE5iwxJjsyP
Ps/9bH/+mYN5Ceeu5gXmZwdczfC7mumfnxWQnxOcnx+fq2nOt2qZkSl4EE/C
Y1XKjFQuj3EjyMTvIhwkudCspyU2zbajvKanWnvz9y95xOV6Cy4Rk6463GpB
Iovq4KK/EUL4n31FEqhGzrKmI2bXcB4VmlwO79BEjuVmRp5Mb3fPUC29HJaB
Y9hoboHGcSyQbxqDFuFdr+sYh94JzKWMT8H0NMzNYB5wkS3TsMJ8eoZZ7R/w
zmZXludWFuZXZhYcE0sO1gH4PIrHSDsHtsLJGthfCNsy4KMM2JUFn+TA/lzY
nwOfZMGeK7jPtmT4IAE2x8BH0XAxHaKzITgNziaAf+zcrhMLz32I+esXPux9
5U1MMz/32uCxHAiowIEaaeSNRDdg5prXR3CkYuUXX+rg1c+bEbI/L/zoycIv
dpWeD608HoSBxXMRDRzp69jt8omb8gegUEI2j0NWzg23bX/2gX15pz7LiTuV
mx+Ql+uXm+XLlrxsv7zcoLyCuGzERjzzdsyYxfhSbLOaEZb09ip4NYTO5hHw
YDUe3bgGNl29HPLLnXM0cwfbYjdaMWh3w6DV20ZMesG1PXK7RKQmnXKFSJtA
JJ91Q46w2DA0j+qWgbGLwNhKSORj1erUS1NGVQ0/JTnax6B7HAYmYGQSJnA8
0ARj2A0TEzAzCYtT4CB/3TGz4pheXp5dnp9bnp5fmVxwNI87srsd/EzfeT1q
kDfWfd9PeiEWXkuATZfgvRTYdhl2XYE9TKEzhKYLSG6Jg9cj4IUzsC8UPgmG
bRfgfMjY9s8nnnobCxBf3tb1+ptoBL7wOuZiIushl88eRhEdJuFLTHEyfyCC
cc3XI+sweR1BKetXDjQQHvN3PJF/aGfxxZCyU0GVbMvFiNqUTkzS45SUNL08
f+kSAyXOU68QKUax37T1k4xP9+Sc+DQr5nh2gV9Onm9O9oXs7As5ORdz8gJz
CmMzPSBSMhi9x85QCl67HjLpzQDB0rOhEQIeWdMW6By7+cd4N9LCdNuuyVCR
lU3Xqu/zhGRvgrMZydSRGDLXgjui3b7jkTweukwxHU1HCP/J/LwzQol8SgVw
YzI8ziHcTQVn7VRSy0dHVsl5otg+1SNQO4KTXtTQ4NuWEegYhR7GsP1joN3V
PwrDYzA5DnNkrDqmHI6pZcfU0uL00tzM8szs8tTcSuPwSmaHI7jWcb568cWg
/vvfrL7vJ+kP/jCR7f/wQXg5Ct6Khy2J8GEK7GQQzkAg7yQIv38JNsXAy2Hw
B7bbYXjj0MKxs/0f7Br4w0sY3Hx9e8dbbyISX36zV8QeCvswQs4gk90BOe2Q
2ozJpLgGiMOZ6WPZx5djGuGVT+rYvo/9S96ux/OO7CjwCy45E1jGtvhFVDP4
MiMgnRDM4Sveq5CPFZ4cvtk90jZ9f0/6Jzuzju/NiDqSmX8h6+qFrJxzmTnn
s3LZun9WcfQVxBy7GV1EOtELItzazM65HilSQWKCTbN/rtmccxzJ+fGc+DWU
ey7hS5Eq1/k/zKM8PcTYrfXhhmvUUyLaGYM3o9cm0EvLGolSgdybLKi1Wq/E
wd58f2YzOuM8iF1UHF92RpkItQy7k4vO1A5idw6xawZuuchU/y0fPlc+BKWD
WIBbSYmbhiFoGYa2YSwL6hqGgVHMb09TTnFpYpmp/pXJxaWppYXppdmZ5Ynp
5fqBlfTWFfbryeKFZ873Pvx85T0/SnnknxOQfv8x83fb4Imj8FoEbE4g7KbD
7ivIvWyFdOBfP3TA8fSOqb2fdW5+v+OhJzvZpre2t77zFqLvtbe6w5ugagRn
omKwSu2A/B5oGITyXsjvhCttkNSMw98vtUBiM+Z6Xt5bTZjN2fNYzrGPrwYE
FZ0PxPhkQHilGbM0pyeSri2PmJdZAWyhu9nw3q7UfR9lHN2ZHnHwSt7ZK/nn
MvLOZuSezcg7l5Hvd6UkKo3tlEBvaeaxfF29zU6+6cMT55rRK9/OpAvO1S1W
q+EBv/izt0fEylF+VoR6Gg96I4hdY+ZbjFZaMIur6yyYXeMaeyIuZ4fe6TCx
qiUoqvFJuhZBwHVRwLWPY3UGsVo/4Zznt3jIZLH1Yl6lqA9KSXp6DWOdrzYN
QMcQ9A3DCNHx9OjK/NjS0tiiY3xheWJxcXJpfmppbHy5pgexlNk4fzhn7rHj
PX94rPzu7yf+4cfxbOOD382890c166hfvJsIb0TjeR54e/T97S1vvll/30NY
vPPOR83vvlXDVt7Y1Jnfj+ZqM/WLkgHomYDOUWgagqp+KOyGzA6cfSGlFY0E
hs+XdlcgMn+WtecPWSc+zg0KzL8YiMHJoPAyjsw0iUx6B00f57VbuX2q0d+W
j5P2fph++KPLYZ+l5ZxKKzybfvV0et7p9Ktn0gsvppVGpEpkEiPySiq+3BhG
KdKkyT9LrP4GsEpHkTIWiU/2t8Zt/i5Z/eFxTISbVbvK26ndxstbZ4bzsqDY
zj68TDYwf0arxSAjBTrbm2xYdNJvVnF1jl9Nli9Z8DssIu1f6aBSYbZWI2f2
4BPM8Hml02mK2exuyOuGAqpKr+yF+n5oHYBuGl04MrQyNris6eODS9p3F0cW
VsYWl8YXFyaWhkeWqjqXq/uW0mrmD1yeefxA55P3lt7/o4QnfhrHDnv4exn3
/7zh3t8P3/shPHUU3oiELYxvk5FpkW+lrYDAjgGfVwZeeaPu1efLfX6LFum7
Hzd+sAlXNr3T3j87p9GcELyipX8KXcPuMWgeRmAXMce/U0SxXtpZRpDO2PNo
xqmPskMC8vwCC9iWkPCSVEm27IEzJaqJ83AK3ZsVpDdvT9zzQdrBD1NCP0nJ
Op5adPpy/qnLV09ezj99uehCall4MtkDDNRGvPPNdyp+b+MRAo5iXiVisWyV
lWCT2F2jmea+1GRkIAjnYXe1cL3ow8K2gms9xgXcR1R7wO21cvjXqv20svIa
RKiFlXXLd7sHljYcYt5Dxcs2dibC+S0K5xrVprjUA0icjy3C0AL0yXzr+qYp
THfz2byy+0Up5yWaxCuFJh7U9Az2YWRRFr6oQxz3n+290N3j6O1Z6ete7u5Z
mhhYdIwuLI8tLo4vDg4grVa1zCVVLOyJn356R/sTPoUP/yTu6X+JYdsf/UHG
g79ufvRRHDTx4C545iS8FQ3vJsD2FIQ58+p2S6R/kAI+L/U8/nTFC4/n3+uD
CfUPdtRt24QrmzdjfIGZSLOLGDfh49kGp6B/EnrGEenVZAfldUEWTTT24kfF
hPT0Pb9PP7M9I8w/JzAgj20JDy+63ImV/9ysUG+az6Gp5DnKEfHcDn5na9yu
d1M+fz8peE9SxpHk4lMpBSdS8k+kFJxMKT6fXB52CfdObAXEuy5Zm/y5ZhVh
0OwxsiqFW8bWWgAPuOdhMcHqmpyrR9gXFLp1Rb53oDXi4HEGvP9f8e5twft6
mHfBts2CdcOCdV6LarY/COOmMyLuGeGTOa1RKYw1Z4ujTXAEHoe9bD1tXeMU
jjQqG8UyPUbrqV34CpBoqjSn2l4mtW/jux+aIZmkktUEV1ugohWa2h0tbY7G
9pXGjuX+nqXZwQXHyMLy6GJ/L84FUFc7FVey9FH45MYtrY/9Ju+xf4l97hfR
bPvjP7rysE/7U09gaehzh+Cls7ApHLbEwAeJ8FEqkwXzBLU7dlF4bftl8Hm+
8577ip69P+PB35Xilp01H2/Clfe2NLeMQc80JlnMqB+ehkFVQ107iCbV1R6M
cLywDbn8sZ9e3v37tHPb0iP8soIDctiWyPACBniaSx+PwXenZPfyaDC9tFZZ
1CJD+/b7MTs2XzqwJSFwZ2L6F5dKTyQVHUsqOJZUdDyp5OylyhC0vPCFpwZD
vmFh+jj5HkybOUuh7GmbGfIS8XqojK2F1LrO9eNEPHmElvzEqtEM5+yhYgV3
kDVZxv8nlFutFCfKeazDy2OsA60UNTMYdwk1wxO60WtUzuLivEA3r3a9bYFw
Ps0DHYswsAAdpPCrxrEemlegpnThJDuhjTRXAU1XEFIvsmN/HlONdSuZdVBS
DxWNjtKmlYqW5bbOpZHexaWhhZWRhdkRRHVj2Vhk/vJ7fuMvvdr86K+znv5l
zAu/jGLbn/px+u8f6Hpm48KbO/GqbwfA5hB4PxK2xcOOZNiTDp9msTs9kMPf
/eTzXKvP3Vef+M2l39+DTLxjZ+Wut3Fl67uNzHGtG8PE4MgcAntqnkYP8hqv
vkkcRlo/jANLi/ugoBee35pHqE7Z/UjqhQ8vR/leCQvIQjINy0sXGQuvK5LM
udmC741DZN+mrBb299aWyI82JXy6Kc7/o/jLBxLKjiUWH00sOoKfpWcSqoJj
2T5JNEMqDjTWBbalz2jOb9CoUBkzNpT9oukY5DBl4eg4E5uHmK3vYBOTu9TI
yKyv5Q1BctyosrUxknCTwrKK0F1n/j/eFnYLitfBvCXmgTE7fk6eneO2tWRs
jmC7BcG6RDC4Bj14xBkpfpEi0Nwin110jDE2XXT0LkCrHB3lxVCcTiVZWI/V
iBAmNvkRznxQhbOtXKDMRVApxJRDchVk1UBWrSO/YaW2dbm7c2myb8ExtMB2
GGiYrC4cD85Z2XR69LVnGh/517SN/xb98q8i2E/P/DT9D4/1Pffq8u7DeKr9
CfBFEuxOgJ2JOMp4fyZ8noNzchwpwDprn2eafP475/e/iHrs3kK28+5d5Xvf
xpXt79dn9KJ/WzOK0zYMz2EQfULMdf7lnknM1NSO4DSnlYM4avX595GJH/9J
0u6Hk323psT4pkUEZLAtsWG4nc8+j2+70dY4UUxAVq+54RbJm++Eb3szdt8b
Mb4fxqZ+Eld+NL7kcHzx4fiSI/Hlp+Oqg1D96AzGOsMxYhjHrPAxVq7WuL4a
nm1me5yiFHLclXgbPJ/Z3vDAzwigNZT/cOVkOTsNZ0AGPT6JFc94cD528yJX
m+dPzTUJc8CXteCOQox+yNyyLtBrHjGIwKV0rt2MeX4dQc0cvZqOQbsvLdN3
B+b1MEE7Ob8yxUzfhRVmDnTNOxpnoIxCCpc6IboVJ4ohWf1NYD0E1GHZll81
1vqdL4NzJXCmEPf0K4bAEogqg8RKx5WalZLG5ebWpeHOxeU+HHo3WjFaljfh
d8XxxuHhV56ofejnyS//R+Tr/x7Oftr4s7THnx18cbPj8/OO82Q0hxZAaCGc
v4qzLXyRBYfzsBaM96a/8nmqzuc3GT7/FPLU/VhOsG936Sdv48qOD2rjmJnc
DyUjOBC7f1YM+BqdE2Mjmscx29g4SlNCD8HGLZmE3sTdD13y/+BS3MXU6IB0
tiU+LAtfr9Ftfv8Kfws3fzFnLr2Sh/sdb2wK2fpa9J5Xoy68F528J6bicGzZ
odiSg7Glh2IrTsbUBERyS1dgl7hH2Raaq0VtrrcRuDUE/xoyxmxGbK0VsSRp
TRPzASv21dYGus7mZojIB3Kt9c2aNFsqxfBkFGO1Klp3zHqDu+43xzq42YDc
S1cm5PIcnhzrusbEvXg5sh5sCrdshSHZoa13zCNgZ+ZWpueX5uYXJ+aXhuaX
u+dWmmcdFZOQNSiste8E1YMTrjVYBCvqXovgdAH40Wi7sFKILIPQYkgqX7la
vVzXsDTQvjTfhXQ7WTBQmDl1Nmnl7b2DLz1a+cBPEt74TcRbvw5jP73487Qn
Xx5942PHsVBHHE2tFVkCAQV87tLvnC3FfuHzRJXPf6T5/EPgcw9gccH+PUUH
3sGV3VurLnXDlQEoGIXaSVG7O0DjFPl8TV1T0MEshgloHkOoPvdOOuE0fveD
iYHvJyRcSI71xxjbpTDMWHCQ0juCvPm7o7JNREsvlsZ7uuX1NwLffyVi90sR
5zZHXtoZVfZFdPkX0aWfR7OVyhNRdf7YD1PIO1YzDNgu0TsB+aILu8FsE+ue
IniEEzWAkCaZ0E2ZPVlly/FLVjFdS1kPON+YRwRrLjURCFrrG+Q4er9kYlnP
SLVbkOrFPuxWT45sg0VRI6FyzTT7iWbD1N28WLwsFoPBP6jwC+YcDPHsYz3M
YWZifm55dnZpfm5xYX5ham5xeHapa2apfWaxbmpJZIyjqMKAY/ZiDY6/P1IC
hwpRbZ8shNOFcLYAfAshgBj34lXwy3PEFq5kly9X1630UvZjpWpkIrsvN236
ePTyux/2v/BwyX0/inn7t+Hv/GcI+/WVX15++q2JLZ85ziY60muRrXkG5kgm
fJGBJbPHr2JROOslrK/4PFbu8+/JPn/v++KDWG/w+d6CL97BlX0fVqT0QuYg
5I/gaB22pWUak5J9NKtx/4xAsYDwKDy76TJC+Mexux+ID34v7tL5xHj/ZLYl
OSyNv+OS8Gso/PI3oON2+Rb0V1/zf/fF0F3Ph53ZFJ6wPaL0QGTFZ5FlByLL
P4+sOhZR7xfaHBUkfLQketMhfy+A4QG5HmIYGoUxtNU9OsPCvvyP/Dk7Ry5f
ZKUj3YoIP6+R9i/bcf2qiKU6H8W7c2BYMKoibS5RMxVrE7OlIGIpCc0BSyVm
mrFE9IkBBmNFMKpGBq/GMyR4Pe02BlOY5QvCaInhdGZxcXZhZQ5ZdnJ2fnB6
oXNqYWAap/0uHl5I7lwOanBclD34B1+UwJ582JULO7NgZwYW2zCbkynvg5lw
OAMvdeQKnM1wRF51ZJQ6KmuQwsdrZhcKBoeu9F9JmjkYvPjB270bHyi45/sR
794d9u5/BbMdXv9V6rPvzWw7ueKf6chpgkTq/6fz4HAWHGVLLk3FRNXdFxla
Hy32+VXC3XddePVh1OyH9+Yd3owrn24rS2GOlKjd/krNBE4N2z6FE2330cCh
HgqTt7HtHK1vJhNao3c/EBv6bnTyufhL/hgUSw1NzeUJZZRRNrcKKDKMKMW5
NV95+eLm54N3PBdy6o3QuK1hxZ+EVx4IL98fXnEgvOZoWMPF4JaIAORZeikK
p1qqIRdI1ewJNDaHZ0tkssSTRbt63IHm0pD4xH84Zls6aRyqzkpJUTPurEiz
CZxa32jjmVnXKt9MMitX3N7ANbXMX3BuhUV1X4hS28qi4FQ5r49hquVBC9XG
QbvCx18rlqULUR/R7uBohRkErGNmaXF6YXlm3jHLXPDZhZnZienZgcm54amp
kSkct1fcM53RPn+pdelC7creYse7WQK53303Dbamw/YM2J6GQdudl2FXKuxO
gd00wuBwCtaIRWVTKDYbyi5NN0UO9KYMpsTPfnph/r03Op+9J/fe74V+cE/I
B/8dxPZ5899TN348v9t/JazYUdSGR4VTHWVoKfgXgi+j72Kc0sm3Aj0/n0cK
fH4Z+7u7zr/5CGrzY/tyjm1Gdf/Z9mJei5Q3BCU0qXv9OOYiO6fpBfb0jrpb
u6jMvZkI+JnXsEDj8X+O3H1/TMSWyNSzscn+mPlOC01CV0u9YRYZlXAh3z6O
74F5+cXzbz8b8PHTwSdeDY55L6Rwd2j1p6EVn4RWfhpaeySk8UJgW7gfdgB6
PxTydjtw6Jo9Ms3g0JXI02xxMs2HbyuP4W+mVvEFDl6yb4lh8Qh7mKyh5IOM
V0ev3YxeSbiItdssyF3rEbnrlH/G0UQrZG+yfw4V1RK2AOWdvTnLImQXYWlR
JOJoLlFtjaoqX6DIABIundWO4P2as4fMAiJ2ZgWmSVNPLTim53Bs1/QMTE/N
T02PTU6PTEzNTOLQvu6h0aaBiaq+mbzu+cimxSNFS++lLNPLPLXbT4WCr/9K
+PHJvICRjsShhOi5XSdmt7za8rRP5kM/DNl2b/A2HySat/8j5YV9yweiVwoa
sANktUBMDWfBbyRVo+4PL4fQagitwWJGn4dyfX4eec9d59/5PRYXnPwk6+Rm
VNsHtxcmd2EAI3cQJ+wrH8UpIpsmsYiujaZJ7pzm70nE897cOgFPvxJHUIzY
dV9U1JbwtDPRl/0wEHUlNDG/DwvHOSBFjqLXabMqHn1p45lNT/t99ETg8RcD
ozYH5e8IqvkkuHJvcNW+4LpDQU3n/NtDL7LdLtObyjiVJqPVakIk+U7X8LPc
4l0Cj3ScWePjBvneshBnnEsiUeLuTo+4u8WCu5uURzVnQhpbMXnq62S0lREk
h9riohgfu1YNnsFB1BJtbNdFRO8S+/jW8pwgTIk1B8ca1ebOweQMziw2OemY
nJidmBwdn5ybQKw5pvpmJoZGxsd6x6ZqBmZTG+dO5S9svrR0ugF25cFrcUK6
3340ADaGwcsR8HI4vBQKLwbDU2fhoYN4vVcPwTufwoc7lo7sm4k9PVkeORoV
trDns+l3Xmx48jdpf/hx8Mf3B338O3+255bfJL92ePlI6kptFxY2Xu2A+LqV
klZopFHamU0Qh20by4TxlzEN4PNAps/Pwu6969y7f0Cv58ynV85sSUFr4qP8
y11YuJgzgNMil45gGVw9TfvOq4z5+4S66A0abOXplzBv98SPwnbdGxGzOfTK
6Yh0PwwsZYXGF/ZDgciOGfy9UQhEb/zA7vbisyfffOLC9j/4H93oH7EpIG97
QO3ewKo9gTV7A+sP+rec9e0IOc/RqOmpmGV0RST5UVzxSaa0KyWviexCrJMh
NSNavsObezqmCKycM8iKTN2ETHUc+/q1VVEpR3UJNBIS8X/udEuzE7U4sd9a
C/sxSDpraGj+FO9ZQiV/UKaB5+ZwajHNWGQff7JEww4c5N4SJB0EyUWa4GIG
y2snJmFifGV8bHpsfH5sCMZxPB9M9sL0wMrsyMLsRHP/VHLtzLEcDCW9dKDw
ngdCH/jemWd+8hlJ7Yd3H4V7T8NjvvDYRXjsDDx2HB4jUPpsAZ8X4MlXlrdt
Wzh7aDbVfyo0aHHf7slNG2se/3Xykz8L3PVgwK57ULe9/9+X3jm3fDoP+0rT
0Ep++3JO89L0sGOAyijzu7DKK6UFC70Sm8HnvnSfnwTdd9fZrY+hqXh+f9r5
95LYyvGPc9NpfFZOP84MWTyMhRc19Io0fGEaz0S10/ihDhq28dQLkQTKkF33
hMW+E5x5KizTD7fkhMbId7jSkNirFPP3QtYU+lu79fXHzn74e9/Dz/iGve6b
s9Wvfrd/zS7/2t3+DV/4tp650Bl8FjHZCYIkOU9S3Mess1dFIkOhnDVD86Sz
rYjUbGFSa4saB4nBb90QM+J33MkLMaj8HoKjg6JIaKcAeTkrEocIwkVTdQAN
cEX0zQNTq1NzNKR/Fode6fMMer9nUFyawaEEhEL6nF6G6SVMQzIUjk3A2BiM
jS6NjiyMDsEYQXC0E8Z7HJP9K9PDSzPj9d2TCZXTBzNmD+dPP/tx3r13hz36
g5PP/+wztudzPz2GgNsD9xyA+4/Bfcfh3s/hnt1wz3a80D2vwWOvwEtvO/bt
XQw6PRfgu7Tn45E3n6549F/jn/tFwN6H/Pfe58t2+9AnYWvoclL1KFtvHlwq
aF8YGlxaHl9ZGIMeCcTcDshuh8w28Lknxeef/e6/68xHj6N74rc/xfd9NAJP
7UAfPZPGxuQPoM7mY1iraSrTxgl6mZ+Og4a+zN+L9uTGMEJh0K7fhca+HZh9
MiTbD+NBeSFROCh7ADhB5vcLHFJy1ZZLWpwvPM/16qOntz504eCTF0JfuZD1
3sWGXb61O3zrdvo2fXah7dS5rsDTGk1epUBJNp+RTJak9IP0a8SaSDdjjY2c
jiVS1OB6wKN834puic/fGBpx7LU6EjczUNqJHfkXvtgZNqkCgHwgZityeC4g
QqlFbuPwnJGz4GpqUh8+HdQsTM3CzCwOF5yj4VkLNNhlWVpTP0NTcWqZKrtm
EZ8jIzAytDg8BCN9MIJjRGG4A0a7HeP9K5NDcxNj1e0T0aVTBy7PHEgff3xL
5n2/CXvqR0df/vkBtufz/3Ls8R9d9Pku2na/2wP3HYF7j8PvjsDdB8BnJ9Lx
yx/AW1th83Y4dHD5wrnlXdsGXn+i5JGfR7/0K/9PH/H79AG0uD76XfzOhOXG
DqxbaR2Y7+yfX5lYXMFiXMf0GBY+su3lctaWW3zuvuTzwwsP3HVm15PoigQe
SAr4APPsZ3dmZtDYBYajggGsqSyVbxW11xJVNkklznG64YlnMBrwxA8Ddt0d
HLvJP/dEUK4fRrPyQyJKB/FNxghSnEkaX3Bs5PeJk2s6fhgcqVIvaje9/PCJ
D+4/9/ljZ4NfPJfxzvmGHRfqPr5Qv+NC84Fz7SdP9wScxD0ZULlFoExMTWdQ
NduYVBKmCJTPVBUrrUuhzT1h1aB3w4gJLznDUgWUKzK/eUNIXSd401l3S9Dk
UUe7Ga0YgSRNj7RqwIJDjlnA//+Sx4zQGyf9rlF14YxErRiTzV/FQ/ObTcyi
LclYc2oaZqZhdhrmKYqyrAiW4XaCcDs6ibgdGoChPhjqwaeFwXbtF46RrpXR
vpWJwamR0bLm8XB6pdeeuKGHX7l836/Cnv/xodf+FXH70i+OPfXjCz7fu3L3
T7E08G7GqIfgnmNw92HwOQg+Wx0b31veuQ/2HoD9X8CpUys73u955dGCh34S
/tqv/T57FEl13wPBO++N/TQDK24np+ba+mdWJudWJhdWJpcckysw6Rgfxfpy
olyci9Lnt3E+3z/z4F2n9z2FjkzIZ4nBW9F/ubArPbtHlFMVyXcpl4+gc85Q
W08vqmSoNRC2tz3xVCAh1m/X3YGxb/lePeGf74vRgcKQsDIqc2fMWjzgQq7s
V+RXYkVnbeKLDx57/54zBx45HbjxTPpbZ+u2n6vffq7ho3Mtn57pOHGy1/84
7e+VJklVwdUNrQZHq+wHOqNVYlWp7YXZqXtCrCaUuUCdtwWb3/CIVfMbOq5V
IStj+Xz7rND/syuIWIbjFRtDrc5Ry21TUWVIufsfrhBmOWwXCLl8+rSJBTDP
FsRfkTA2AyPTMDQFo1NodU5PwSx5B3NTOKYLz80QMbGECB+dXBweWxkagoEe
GOjCn/pbYaDNMdS5MtK7MjYwOjBcVD8WnDcRXzH5UUjvfc8k3f8vYa/+9PO3
/g1h+8ovjz33s/M+P8i6+/u19z3cReED7c6P9iwfPOT47LOVgweXPtrS8dLD
OQ/8KHjTb3wPPnaB/bz/oaA990f7leALw6Ympx3T046p2ZWpeQczlFELrDjE
20s39I5C6zD4/FeUzz+dfOiuUweeRt8m/PO40A/RpfHbfZnBJ1/WPn2TgbV0
CGcLYEZAzZiwRpsm5GjMSXj8CTSBn/jBxV0+/rFvXiw87lvoi/GDkpDgCnpb
jTteSVYMrsiwvCc8f9/hd+8+9emDJ/2fOZX2+umaD87ojdvOaF6tn5zqOna8
z/eoRjUB6YxXGVg1uwWuCq+agbH7VlMcyWyjXgu1NgtKrdF2K0rXcHjeYMWU
rLfCE2wQaLUzlBqETgZVNFU1p+e0oCLxPL+JkXkO0flFOSZpQg7q5pOu4PuY
Z3AmoN4p6JnEOtBhIfFHJidhehLmJ2GJ5gxgGF0cm58cmRkfmlweHFnpJ2O1
tw16mx19rY6BjpWhnpXRgcGeoatkTEYVT75/vuP+x5Ie/HHYmz//7J1f79cw
un7shZ+f9flRzu//teHhR/of3IS1fXfvgnsPOgmWbdm2deGD9+b3fzK77e2W
Fx7IuO/7/u/+9sLRx9Hn/fyRwE8ejCprxkEy81MTjpkpx/SMY3rOwQevTSHl
zk2i5cJW2kfB5z/Dff7x6MN3nTz4LFZfRX0eE7Ed/Z3APcnctGTIKqSiVwXY
anrJb700C+gd5bc/Rv3lyR+c3/Vbv9g3zxcfu1DiixAuCwmspHFEFszyM3OO
Na7+39K+A6ytLEtTK7BrqrtqO0xPT0/3zE7vTs/0Ts+ocnXldkW3KwiME842
zjngQBJB5JzBZLAN2AaTs40xNmByziIIEBLKWSLpft++c++TkGVqqnaX75VK
lp7ee/ec/4R77rnnmBF7bGv0tW+TQrYl5RxMrjt7o98thTnulcL42VRI8lxC
gig7loHLaBPQWjuutS9EneB6G6rMi6W0orWOP1l8WLNfYIPVn9lg87f/X1jF
qxI0VvHOGntao+pXqMMeVng2wHsDHAzi31o0LFrb8YVRe8aiWMm2WuqNDBfH
EOK6LPO4jzM1n6UmE9C/CvNapEJSJZIrkVqFdEpkVKIlnE2yIF+elS6qJNql
BcWKEDayorkJNDdmEkyYRHyTeG5VKprni5/0yNonNfkt2qvxEzucq/d9lH/1
8wj3LQDay18lsjeVsD9oOcTmnb8oPeqz6IxT96ip1rZYmHZtjQfcHtivOXVU
G+Sv8rw4enzrg61vZnEcM5MPZVBnxu7JjXAulAhhR5ZJrzTp1CYdpWz1UG5B
C8mCJsql0cC233k8FvbmfPbrMbtZ4Bbm+D0qjS4q9oXp0Z1gmHZR6pACWAdW
sQzcWHAAg5ZWtErEpNwCHEfavzcdgzbd/9vskovpXQnp3TkA4978W/0yZI1b
eh8ycWpbsb5l4NYoLeZqB68cYUde+TohyDEha19izamk3qvJPI9knmcyPyhR
EBcnzooGJEDpbHuCXeIfQHyKWUtX8wRdu5HoWmvY2qLWjp552XbI/R6EWtn8
H6oUiCFqWctc69qFQUp9qV+hvIFles61Sg4KoKuMv6W8V7q+EA4HEIfViBPp
tXjTIQOnVMwbzN1ncNf6ESVNPcdpBZql5isyNC9DIso3lWEPVYpmSAcGybJK
rF8UgR1eFcyaZniIP2qa45nmp02i2VWJcGZiob5D0jwgy36suxA6stOp2uWT
W+5fhXt9Cwi98tdE9mfl7I9aTzhPBgYrPRJX/TPhsnvikHMC2h6Pticjp1jk
GIF2OSj8vKTu5waOsqt3vpPhty0j1SWNOjN+3+3oPQCxeblGrtLoNRqTXmPS
6XBZEJBXysvWapHU7Mawv7jNZkXtfS2Z+uo292FFdEGZ313wCEIqMJooPch4
GTSqFJFerKRD8KBZtdKRKQqs+5xTAKPvpvp/k1lyIbUnPrUvB2SmPz97gPJ0
8TZNGp20frVyCzDPn9GR1F8d/jbs8l9jA76Ly9gdX3Usoedy4qR74oR74kxg
/HxsjCQDgiYNOEfwRQVrR/sDdoDRl1/EKB2vAh1bRuod2EY6bf/9f6c/zdU6
IATwD5bvdcvUQQEcv1BQ06+Q8/XL9qBGX6GgaQEmCVItYWNvWII9scQfJdI7
raVb05CYDMWLETkkCA+KYXfT6AKaWkDMacpufcwToT4R7DWlTlMvGI1CmCUt
z86t8idM0yOmmXGTYMoknDEtzE+Mgjpt7RClPDCc8u7f9V31yU3ZXlvCfNlh
1OfXtySyv6hkf9Jx7sh0WoY2sQBllaP8WrjsgSS09wbal472Z6E9qchpi9jr
6vz1Uz0uX5fveS89aGd6xhGI3CQduB23727nnH5IrJ+Q6gVyvVylX4FI7zIW
WtMSnhJSKGUaqRngT9mfZTuyIve/ngSq0r+2OvpuJRdm8UWhpZSu64X+h9AE
cUMvBmW/jCYEg0lhElcmHsHqkzr27kzGoLzh/3VGyfmUvrgbgzkgJoP5mYP0
DmL7Xiv1ifG+wRqWFl/41UNbQi5+GeW/JSZtZ2yFS1zXhfip6/FTbvGzAbGi
mChpejhBJdGddhbdSWZMdbiTgdny1+Ai7ESPvrQ+RgE2tvN42z66/w/IJGrT
0hHTnoIX+T0FMz05lim2UF7pEuPn1BtkXEGLgE2Gdfx+CeKmsAODMuZG0JVA
c3qv62eduKcpRcNWIWwRbJlFnaTwvQD1CaBpQ/c8GsO01YjAZhrnZIsz83re
tGFizMQfM81Omub5K0LB6CCU2GtvmourWjxypdt5c835zzJ8vwv1dwRUenyT
CAlGm7pcz83cvKMvfYxKHqP8B1DYivrWJQ0dy0Ync9GpO5SKE7hd4F893nFo
c/HBD9PCd6dmHwNVlXLoVuKB/AfTi02CxU7h4qhsUao16g1LhF6UR/MLowFq
wEEVLj1i7ypnb0rfyoo8+AZEawsCqupi8msCYKpeGlYMVROwkmMwKYQy7Ei7
auisjr213w5hk05guWc7zGcOvZPk/3Vaybnkgdik4Rx4nmEcdx/AgO4z72pf
80bNkSoKlmTefmBz4IXPI/y+ikrZFl12MKbjTCxz+los46U5bvRCVIQsNZSB
c/yIoiTPYWfRlP8VIu0siMS/+r0N6v7+B633untbqR/81uJP4lr2BH+LjH/B
sFukD0rlYdjBaYurxEoT5BlwTIlgTmCgt6j2KGDnXtMCrJ3U47Yh1NNTQ3kw
jRqmoTxEE3XMoN45xDPXc/itbl6nmVYoxxYkQ7OK0UnT1KhpZsI0N22cnRvs
helQ86O58OLF/afbnD+rufJFaoBjSLATgM7ru0T25jr2Z70eboI75caiBpRa
Qfrl/q3D53zXkzxXl2cHPr939JPU6H0pt06A7kl3uXVzaLWAt1I+vdIkWhlR
LS/oAWI6o2nJSGl8E8lP+eWqAbF3lLA/SXFiRbi8CQgpDqyoj8l9EAgLnxXh
9yH7WA4oGzB3Q4de6Jjc1BsAGKX8mGCSf7bHKRYjLMF/S0rJ2cShmPixHNCl
Y/mAs8HnEcZgdoMutUEZwctP933BPbcp1OfziGSHyJJ9UW0no/hXovlXo+f9
IsWRYfKUYLIuBADbsOYt/hDCgAv/8qNQ9ct1NCCdT0y53LjOM2DISJ1IijBj
AAF0KBgZl0F1LZlMGECUNaXQQ5p5EI01RGusVx8KYNNnxRSU7ro/BsmoZePQ
mqBqAtXw0GMe6pxCo+adn+/IpoziUbWwXzbVNy8c4ht4PNM0zzQ7pZ2CUM9Y
9+yj2vnAXK3zoeb9n1V6fJUcvC04bAcIo49DIntL/da/9vv6C4vrl8txv8DI
+8jrJrqQDu/d7iOPEuRVjhw+450/PHzp4NN9m/JOfnoj4eCNvJPAwKyjN7NG
UfYoKp5FT2SmQc2qAE/CFEaYhKzQca1fmXDWHntbIfujxG2s8KNvxYPLE1j6
OObWo6Ac6n1VxD2eAmpojWBQDWFcESPKBKX19+Q9ARUFqd2OUQCot+P8/5pc
cjZhJDqWh4MyvLzkIVzxaB2tJSHeI8ntIDNz6m/PZ75nPgnmbApL+ja8aHfE
s2MR/EuRM66RQt8wSUSI8kYg4e5jnENvtqZMKBNoq7us1soBq/9mgxTbrAqC
J9scH0vXVTyDAyxpDUyk1TNeJXjC7gmllgw4bYKyfCtoaXUVG0E93lFs3g2s
hShutxy14Klc8QQqHIOtZnm4rlfBMLo/jIqHUMkAKu5Fdbgcd88QmsAbS/h9
+vEuZX/XwlT/nHx02jQ1buJPKsahIvdEy1R1udAnTbF7T/ORz8v8/hofviM4
aheAyc8xkf1Ng7PTYFDkwpN2Y+0zuFRCKeLmIe5t5JsP/wwoRUGVyOHTkVN7
+y7sbdjz0c1zXySnuCTfPQ0mLOdYTtogujmKyigwSVA/DmLO6ZBYCwugizij
DuPpZ0sUmLbeYX8Qt50VdvztOABQUNHT2OzHwTAJrY28M6VE9BYJBV0JCWBh
P4ixQVDEHKG++qXzdxDhPPx2jP/mpJIzcWNR0VM5cL3JvMRhxQtAMmOJYGIt
JENWsZ3/wjn1YYDnxyEJW0ILd4Q2u4RNnQ+fvRwu8g6RhgWpkvypkxrxYtEP
owmu+KcfQBBpJvOr9RCEbZoGr8lp9RSGdIx/gsU5HcYPTL60eDWZQGjZtLi8
umxaWsah5iUIh8yY4fN0AZq5U5/fxpW3s3Hzxts9KK8H3elGdzrosbNKnqGa
NvQM1/ccblvsbtW0tEqHukXzg7P68UnT9KRpFtb4ph+NlRQtuMeI9+xoPvVl
cfDXMVG7gmJ3hwA2nBLZ3z05sH8k8oakf9jUgJszp1Ui31tLKaUopgjFlMMn
MbXIYVP/0e0d55zrdr2feXlzUsaxxMKzoFBun8ih9xOX82npHtOgaTX0c1Bj
U24kGIIg5i/YDrns96J2sMJOvgPGqS64sCU282kozBAfRuXxcenJSRzoGSea
iYKD3TA4UAQYI9i6US8/d/4mFGMoivtVQsnpGF5kJD8nBgabF0ed+qI+IhE2
iyNFYESe/Jc7P/Y88b6f+/tBcV8F33MKfnowZOJMqOBS6AInSB4aoE70AwwJ
kA2MLCiyJygig//PH4Uf21iI2aJtQBotWDU9VkZaygPVqikPnEYOZdX0JqNh
ZRFs29KySbsEZmwON13pU0F+XfUMKqR3Wtkld6HEDrJCBy9vpDWg5AcopQ7l
PERlDegpTkh90qSvb1Z2dUgm++blIzOmyQnTFOicmeqhu3fFV4Lm9zo0X9hc
GPlNZNzuoIS9gJng7QlsdtPRE2PxN+VjOAO+vBmlV63cqVkprkd5dSitDqOo
mcJM98HvWs7sqNrxbuq1rxNvnkgoOQdynn8qK5vOI/x1oxj14Ap6U3jLlQrr
Ux3OUSNRGfZ3Oex3w3eyQk+/C/ytD7nbFpveEgbzt4boW3N0fHsDBRxQPkpQ
PqNmlNjREALvBP7/d7u2BAFq3orgfhlXfCpqIjJ8LhviCDN5MbQFtAIO9cZa
/5gjIWRlfvsHbsfe9bn+bkDM5wF3HQIb9waNnwyevxAs9gxQBPtpEnyAuAL0
Imyw9gGOvG6DAVtMEKT82tpr/i3AQq1BajW8arRY4VBvVEitQBolLEdhPWPS
qVb1mhUDwGhxaUW/tKJahq3RU3o0qAHrRPk6xfSK846YNpTYBonw8Y9RVB0K
q0BBxSiiGKWXo0I8v696vFjZqGl+Jh/qFs8PClYm+aZxvIBfOnTztvS8J3/f
181Xt9yNZYcn7gtK3h/MgJWoeLbjszOXeSn3lVPYQte2mlLK9D2dqKUNVT9D
+bgzLfW5w1/a9m5uPLm1bNubSZ7fJeSfji+/AKrh3hlYHyiZRDU4q6+dcnRV
4OxTTpsUB0KUBjqWvLSI2N9kst8O3sUKOfdniFs2huZ1xKW2hYOf+yQmBwya
GqotT1PKhbqI0owUJbIfNdcO3bnZHyMjjPtlTPHJyImI0PlsmMsL8qLAboFC
sSPgwGiC+d1G4uZYz88INra9d+3I215X3+JG/YWb/61/g3PA6LFA4flAqQdX
GeSjjeNQJz0VoBfhgfXR2zY4sLU1BBe2UQD873/E+KDAoTa/USK1HKlkGB9q
wIdGYdLIVrWQzgv7iAx6vVGvWlxcMC7zjaZhLWqWoCr8RDFdKLIdRbeTMe2I
aUeRzSj0EQqsQb6lyKsA+d5FAYUooQzdqoHzCx8ZHjapB3rk2mnZKg/mT6rG
weHC4bRM2clLvAObm7y+yUvcGpZyIDD1IAhh1O44tlPbJa+pmzVQBKV/DFU2
G29VaYSjaHQYPRtE1f0ovxfl9yOHT5p3bnp4nF20/c14X4e4wnNxVZdAFdw/
l17CQzV8aL73FLuWfRRftWhWj4S4WQbpZ6/HSYbsLansN/2dWcEX3gMvtins
dnfcjc4ImJw1x2aRJTMLSqaeBwqTQgqZCe34EmzB4TdDuF9EF58InwgPXsgG
OyTMjRjGez/oFUfiSBPjw4SQp73FH+6iUWLn9I7r4Tc88OkYgaJz/jJ3X1Ug
Rx/ruZThZoMR+M2fbXhu68cSZNhGLjEy/giAUKnwqwKpMCaUUnijVmGIiE1q
aM6xotMs6XXLOrlep1TqNEKdbkq3OKI2PpODzUkdRqEdKKQdcVuQZyO68hBG
eaEUaoxxKpB7EbqaD9XsQ+6D/ogupeePf5LMGHWTqtVRqGWqre3tyRtNSFG4
nBg5uqWR+93NG9tD0w8FUl8lHwyP3RvL3t55PZjf0gYapm9kuaxR09OpN86Z
hNOrg7zVp6OrlUOr1cPI4ePHW9+vPvr1vd3vxAU6xZZcjK1xBdkvuZhKTf3r
ZtAjAWRRttGW/3fTuLE3kV4lDltR80D25mT26767WcGX3gMr0Bqe0xef2BMJ
fnFrHMRhrHHBf16BkIgehQ7GKxQ8dnzmjYERxP08svhE6ERYoCQbFOFCbijx
XCwaZECGLBpkg40GoXc/Or51kfpf0P1Fhj31shFDBPZjCujnf/9H4cB2fQXj
4J8AAUoFUsqB/ZAoKwEoqKRIKUIKAYUDUAwaxbJGtqIW6jVimVomUKtn1apx
OawDl4xr0nt18R0G38cG10L1iQTJpcCqE9u49B6unSnIJRNdyEVeFAoo77EU
xZWh+ApUiXW9dGpFN65fHYLWWYayjtacscgE1f79/ae/fhTikJXuHJLtAjhI
PRyecCDGYVe3d+zs0CB4sN2DuuJHsuW5RSRYVs0uT08tdY8vNY8tt/FMDh89
3PpemcvmvAPvxYTuiKl0jX5wFXhZfjmlahKWAh7NwY7rNrzxwDzX/50Ad6FV
GCGoDjj4Mp7N4uxhBbm+DzOTjojMwfj4/mjwbzviUyUYNzQUNFCz3wIF6nMa
DXaAhJ9u3+SJYRDA/Sy8+HjwRGiAPDuA+kSSC2DA+gFwsGHQHMMBkEO8EHSE
HcEBhgAoBAwA0E/zNN8/suGobVyE8P13tMfwDxZ+KzCn5QtIIYY3CiGSzyE5
xClWlOJllXRFKVhRzGgVAqlSMqdUSfFXLZPCyiFx5Yj0To/sRoM4JF/gEr3g
yik4v8PPi+1O+P2uQxw6mIYu3ELeBSisGEWVouRq9KADdeC2APpRiOybGkcW
7z1rTOcFRasP7Bq4+O2DqK3p2XuDbx8DymS4hCcfit5xuC8gHVK7JEJDR6+y
rUOGV4YNy/NG8YxhbNIwOAGBQocPa7a+V3To8xyXD6KjnKPrrkU9ug4Mq7qS
DJG+Wdik1LYAC/8koYo85a8pD3kB9xxW4Hr47M+jHVhee1mBVz+AH/dEpI/E
xw7FgNfRnZAsNXNbaMVwLOtTsA5rkX/q2PYJaGmXN7jcT8OKjwVNhHCV2Vzq
E1lu4AhtDShuM8Ft2GBxKfus1sDsaXbjP+A3fPqXH+Ay3o/8Qh7q39MzCMY/
IpkIeC0TINkcks4gGfjzK4qFVfmcSTaxJJtQy2YlsoUFmUglhnq63bzJTh6/
Z2q2vn/2Xt1UwE3g/pWr2Vd3+Xh/68Flu4dt88UW6nWKyeGlKOMBbGZ7hCVa
i/dPmWpGdLdb6pInfMK0B50GrrNrEpxSbh0Iyj8BHM46Gp7mErX37EBYPiww
iebUrV1i/YwKVsfn1RSZ9XM6AR9SRwSzSw4flG/9890DmzJOfBwVvzfykXtk
ozu4YbXXEhtnoeU9sFcKKXOEgn8aV8P6LJhgLNIynGjI/jTCkeW1jxXg9iH8
uD8yZTwheiQW7ENfYqJMhyTPM5l6P2ul42nzj2cUTh9dxTz25W4KKT4aMBHi
q8n2BRuSy6V4zKSYjCX6JVuJxnMHvELFNMuyVdblJhvu/WJdHv+P9TT47+Eq
UgGSziLJDJJAS4RV6dyqdNYk4SHxyKKYp5LMLEhE6gUo9Cni9wn4Q/NzI4LZ
0c6ukdxKnk/6dFjFxLWziV67Ob5fewQ5ekTugAF5fAOTO/ZV0lHTLqoYZdeg
0gaazv8mrhSLs3vkWa3lsVNu/ppD3w5wHCtStyflHw4sOAVsvnk8PPNopMu1
ofQKAJyAL21qn0NCOSyRz8uRUEkxWzULjqlcaHD4oHjru7n7Pko5uyky+UDE
U6+IJk8IrT90S+gQQRsvs5f0nwNyiBuNq2C7GDHgIpyOR80A2J+EbGV57mcF
eHwEvx2OSppMiBiPA+0/mBQv0yOpFaOpV0iKMgu0Da+dPnAFLr/u7bcpqOgI
lxfsrcsGg66+7WvNZbs1LjPNNhxWDnvNYvyyDZ8//VF8/uf1+HwMriLmI/EU
SJh4clUyYxKPo4VhJBo0isaUC9NyEfhISNBiEratijqRuFvB73v2bCineMwj
aTKisO/60TD/vZ7cLZ7h2zxjnWFGyvku+PwXkIfCdtGxT4FKDc1DWaXw9K0F
uq7kqZ7AZ8KUtsIIvqu74hi719+pNHtnXMHRgKIzMD3KPRGecyLipN9IUzMU
fZ2ZEKr4IiRcgE6ZQjFUrZ0HJ8Eg0qjEeof37219J3vP+4kXPw9PPxze6hP2
jINXozzi+ilrLKYlBQqOy2EuNqmGCNicDrcOYzDEOFmY/VGgE8vjAMvf62P4
7Vh0Aj8hbDIBpHokOUaBczKldL/GX9GJb4THGjOP1TSPt753EfPYy+8vAUUu
frwgjjEbrLX2tvcoiUwycaRpaG2WB4zeSB6TqO1e7KzBR3Y2nP7Mhoc/X5fT
v7e2zf8Tfi2CfmEm0YRJNIaEw2h+wDTfr58fVcxPGeag1C6abUaCZ0jYjkRd
4vGep08G0u+OXIvlRd5u8TgcELbfI2CzV/ROGEfELj9fx6CLX6Uc/OD+pb3d
7H0qtrOceOB/KIqUlrgPNHDax+I6c4Nnzp0Xn3HsCt1elOccXXTSv+w8MDf/
VDj7aPP58PGxASjmNDnGR6J5JBSgeQESUm9Aea+IFPoFtVKic3wvb+vb6c7v
xl79KiznaFiHX2i7D+iPJ16xWDJgAvTPw4SvKkjumtXCfvl5vGUe7DzF2g/8
trHcD7K43p/ALydjYucS8ZsbkeM3ohTmdtgS3BoWFPzz3GUwKeYyfkrY6/jO
OcxbD79P/IsO+/ACPZey3cEDue3JYNLcZWwYJpFoy1LH9/GXaY4246R4899X
Nhy1zbgjHP5f69hlxp+BkfOjpvlRJBhCggE017c616ubG9bODiI+FHVB/KfA
6blWNN8uGOp69LAv+fZQestCdNoDn6PcmANuQV9yEnZ7MWDe7Oe/Lejy5rTD
Hxa5He07e0LM3qtib547zQETGn9hNulQZ8mV7vbQ3kzu3ImjgstO7dE7Cwr3
RJSd4VZeBPfk3pkw9vHWq0mAvCXprHRqCon4TCTkU+pJOIOE4HEvL8h1EpVC
qnP8c87Wt5J3vBnpsSU090RIt39Ilx/4ss3e0ZMKKM9BzYGol9fHFMBoihvW
vBbpcc9KSt28x9nBcj/E8vP9C/x4JjZKmAhBgOmU8MmUCCWep1OSTPFaTLGb
aGutlSSbhZn63PGt08Dq19z8PvYrOszhBbivZl+nPjHedh9bi/4BBs1a256o
bGKbX9TZ3/4ovq67UrkFC+ggmu1HM71opnuF36OdGVqdfgafTzagqUaKu2jm
GZp9xu9pr63ujs/sz2oWxMSXBB33iz/kHraZc2MvMDVmDzd4R+CVLeknPi3x
PTvk5a68fA18Z7YTtD64tnUkeFdPztn+Or/BZI7AZQ/fbVtLovOd0n1hlef9
ai4DU++fD2Wf7PDMBmthWJhE1CGaQEIeElKv2E4siJckcq1UpZHrHN/N2Ppm
/LbXQn2+Dbl3OrgvIKjXH2Zerb6RszgDk8mnfN2XiN6keErRf04LZS4E5t5O
v6L4yn7XYyfL7TDLz38T8FIQFyFOBk9gNjVkGucdWNQzYSqxwtRVmBRXGS+R
6gPUH8VXhzdOUm+OvHYNbzlh2C/fuj6upL8G+WXYEYfaagZlxdM+2p92sOGR
bRUKwsk/rMfJf8Yy2IOmu9BUx9JU9+JkB5qAbXBovB5NPEZTT9B0E5pu5rW3
VpZ2RqX03mrix4XnRp70STzgEfOdV8YBCOrF7+OGOQdc+zrzwtflIVdHI8IM
YRGrcfGrRAv/0c1hIPbIUIHbSMx14ZEdfO8dT9N23648FFp7ye/BFT/qjNKL
IdsudiWXwEYVrWAELYwi0SgSjiDhKDEUSLKwKJVp5cpFhd7xnRtOb0btej3Y
3yG4+FzQUFDgQCCQv4MbIcI1gIVqiFwwmDOwU48iMkVwgZYuVgKKGLfdZr99
bRfrugvLN/BTQMBCfKjsBuBpPi1oNi2YCdVVf0IpYikWzgWcXC4081GAOcgE
RtrPqNc0JUQtsF5dvXWFeiWhVkoy1+WkvcVtpv6cfoCDuN4Y419pK/obC+eA
W22LE51o/Akah5otaPQhGn+EJhopLpomngw3tZQU4Dr1TRPx/qkJpzg39nkk
bffMOQxsS9zPjdzj7/ZN1nWn6hgOLz1t9dZN0707KCKG7sPz7ye/GuHuHUu/
wAu9LDq+bTpg1+OcvTk1R0Lqr/g+ugbec8Xl4N2ePY8aYYs5Eg+hhUEkGkDC
ASQaRmJs4qULRrl0SaFCSoPj2wlOb4TtfTM4xCmw4mLgaEjAcDBY4O4A8GOh
lC3FPw1t7RggLVifAedeIYxjv+nqzLp2hOUT/BmwXBofpEiBx1hID5hPD7QD
y7lxTZ+auUZWSohWpY0o9feS2ZNZzXXFcS2QvI1EkZL1E5IfQDzgNY9nmw1v
Xl2XV3+0+RSvh32LBasFjT1Fo5hbww/QcB0arUdjDWi8YXHkcf+jpoK81vuN
Y3efjCR6RKed8Uzd45m+xz33CLjlyQe5sfu5nt/leO+tSw6avpNvSslEMTdQ
cDxy5UCS2u6Px12dJiJPTHHPic/tmAjbXZ+/P/Ph8eDH130a3YBQ1VeCDgb2
TfTBdhe9aEgvHNTPD6xQLBPDVgRqcrUqF60opEipZv85xfHtaKfXAw++FRS5
I6DGNYAX6j8aCjLSFxSqwa6JDLdZFmvXtBzDfh64JcTUZ79+YTfr2lGWd+jn
wGZlgr86FYYhzfBbyODaU4xivCq14hbDMmMhSteaWxsobpGdgiQ2Pb4mWfaE
VUSSdv4o7vxvm0/xGhSoYNPIUzTyGA0/whoYDdZSX1FMGnlIHdq++q7axrzs
5qLHwwV1nUmXA26e80jf7ZVzyO3ucRhX6iH/qD1RHPbNoCP1WVGzBfdW4lJX
SZT7P3Z/On30az7nwKznSanrrrGYvXX3D6Y1nApqcvdp8oApSt31wOMx0Jpi
bn5qZmZihs+b5Y8bpbxlKbZi8plVhRApZUhFcSbR8a1wp9f8jrwTGOvsX3+N
OxXuxwsHRToYEmzQQVUU6r1ch6gZv9TcHpsBvYcZr4owpSmqs1ln97CuHmNx
Ij4HnmoS/XTpYJIVmT7STF8G5s5PgTt6mrLWStDipBAtCNIB0sSgdx5tJBaU
BBMYuIIkli572k3Bf7ttePDKupz69/U4hXM2Bx+hQdiUi/qqUH815tWv0VCd
svNBazlUUy17NFBY1ph6hZt/wT1zFyfvqHvhSdB66S7cmH0xPo63o84+zk+e
Ly5cSkwHn+MEx7TtPNEV/7p/i+D8zvkrLjL33UNJ+6vLD994ejbwmaf3My9g
Vb17wNlUkJeuybmuibku3uyMaFarAP9xUSlcVopMShGEltUq9rsxjm8GbWN5
H383MGkv94m730yk71QkSOJIWOAS3mMPokQy2YBdZOpuRwkEEyJyP3FgndnL
unKcxYn6AhhsSPI2ZsDiiTqLo8jyxlz6mdQ8YaCV3gvWyuJNYg5RJpFJOTff
yyUrXbfHhvq2O8MIj/5E2yW8ZotlFPVWo54K1FuJ+ijO9FczPpO01DYV1Xd1
9FY+6im6V5V5za/gknv2Du+C4+4lZ4AtWce4cftj/bbmJl5pKsoSlxUDnPyi
l8/6rDhfWN57DZ7wsKPYxVF8br/CZ09/+sHy2iOJzy4GdHC8231A/Bo9/WML
GhtmNLUjktphcStfMisDN1KtlmnU8iW1zAQHrPyw34lwfIO7g+V9+r2AtAO+
LV6+gmhg7GSk/3hkwLIeEc6AWOAduwodbtbNpBjE+O+ERVJ8OLLO7GO5nmB5
xXwJ3FlK9lzOhNioLttDne3JpOwREzgEFCWKjsGkeMR4ySJL84RLtCxh2lmi
NDSfcPzVzsIlfNYBGz78ZF2+2OZk4BVVnK3TXYG6SqlXJsUlagrfWzH/uLrh
zoNH9W019R3FOfduu/ncv+hxc5t38SmP8nOgFm6d8Es8GB+4/XYG51nVHVll
GbQZCYpbvMhduu6/eIEL1ufIDtmxXYqTzorAfT03D5U0HIttd/Xv9vXu8gMG
N3G4tfUF98aMuf3qohF1q0gzi9drxVqtWKVb1SpNWpVJqzZpNey3gx1f5ziz
vM+/7591yLfDx0cUCwzmR3Mno7krerSMeWO04hCDqQQ6w+wZqz0Glh77razT
+1mXT7I8474isdyNxhw3XY67HM+yZfgCTIozTLPQEcYwmCA9doQzmObAHrtZ
cwjNIkMW3hCRYRz8UXxh2Xy61sG+owx1lFB2p7OUSTGI8ceZBxV1N2seP3z2
sL6lNCWrwINTfN7ztpNPxVmPqovAlrzTvsmHEiL25OUGttfcW6itgMlwWKLh
kp8+MlYfELPMwVsRD7FnLu5ZCD/QecflfvOJqO5r3H4up9cf2PLM1y8Op+Ql
9iwWTS+1ypYIDn83plqRa42ret2qXm/SG0x6I/stf8fX3PewvC9/6H/rsE+v
H0cSD5eYi/Xlx/quYGoS4SGs0eKcMDURIeCRnJYFJ9YpM5LtzKs9yzevGm9e
k5v7lcuw7w1MBN5gqdlgIzWUZ6ghc6oNFs7Q02XMG+oMFxtKv7wuP15bjx9/
An60FqE2fLQXo47iiUrY1/6krqnh4ZOy2IQyL8/Ss555jr41FzxrL0Mo6u45
n5TDiQlH7t6P6n5SLn5YDXWaopN15zwVNzM1KRmLEekgJ/u+GnLfNxN7qK3o
6L2Ok+H97n7DAUDHLq5fO9fXuwV5N5MclV924gmCyrCyuri0alxeMS6ZDMsO
b3o7sq7sY3GufcTNO+I9GOAlT4S7C+N9BPGgxphQRO2VZQNaMkDzbNBHVpxQ
Yt4o8KvFB17GMxZMdpAcC8030gKB/wjZLVTfaEt1BuPYD9CbBJZsM4AwvV8H
ercUomf4aC0cKYG92U21jU8fPCoPDa319ig/7VW406f+Eoy14jLn/gXvtCPJ
aWcKK5L6uhugGtfde+qYJFVgiLi6UHW/QJ9+F8z6ro/b/A+MJ7s0VxzP7zsT
MuTlOxYEktMb6Nsd4HOhBvk8QclYAJql0DehX46niiQ3enlplVT5dnjDYxvr
ykEWx+MTv3tHvceCPZXJYIbFiRxRIofBXDUgTPWXn6M6rlGnwZRe01HEVwLC
b6BXvoiNkJmNCkY8KCN8rkj7gkYyz44oW6GhW6lTf8d/FO3foG01pjnOjmi6
C0fz3aWn9wbuwe7iZ9WPWh7UVfn7Nfi6V57klO33brwCFKt25ZRc5mQcvXHr
SsnDrEFeO8S87xeqImLElXmirlp5fY2moNqYWgW1oCIODWQcfVJ38tbg+eAx
H5+JELjCYLBPX7A38XZeujeJHoug0A7lEYr0kFFsMGcU/xQtIoc3ru5gXTnM
4nD+4ld0nDMV5qFJgdCm7IanJNmLgbtwb6TIvoK3qVjITjwpi+ZhMIHw9haa
UwfeI2fWRBTlwVrYmTGPLbAlbEMd69LdykM6YUNl29rKhOpv2XyKo+RvwlUa
89ATOHT1UJelv7q6o6quva6qLsj3Cde9+oR3zRFO83WgXe1V7/IrXlnHUwu8
ypvyR/k9kE1QVCANCZudb5qffCbpbFHWPdXlN4DflHi469bxhsens0cvBU34
e0+Hg8yMhHoPhnKyhlDuGCqcQOXTqE4AiSKjGsguUy5BEiJdRcPh9Uu7WFeO
sjh+n/qWnfCai3TTp4Ffo0z1kKd4kBrNhPZ2UD3PfslAg1BPyYEOPiGFpIjG
wdVRKYWDqf4STXVyEMADR8wax85CeoJ5+zUrzGCcsaGjbT0NQm3bTDJM7U+B
2g230ePbqmrYtzRQVdFdVdVVU/Io1KfJz6P2mHf9Ka9WdyD1w+ve1dc9c06k
lQVWtdyBOVlno/ReriAggGcamJX0CEfapU9blKWN2pMflGQdabl74mHL2YyJ
K4H8IM5MJKiF8XDOSLhX3hBUmC3hoYpp9GgetSvQkBbNGpB4EajNwNscV5eQ
w2vUTAxc/MDPfKpOeQqj3RYzILKrSXdTpblB/wxMbNAvTKA21JSjCL6IaW4w
QH4+aBpMcAZTTb3YqSw6x47SOUB7PLu1dnsYz+l5W6pbIfysDTU3rkvzd2w+
/ZmF5vU51CEtg408QxVl/ZWl3cW5T8M5LT6eD474PL3g2eEF4Gxw59R5eOSd
Tq2LrGstgBWgzseivKzJ8pwxNDCl7Z/hdwm72iQPmhRnPyy4c6yh+FRt5/nU
6esBglAvQTTQfDLKazzS884QFF+haF45Da0zOiRoWIVmDEhEqkjhnTAU2R1Z
pynH/STLK/QL77rT8AArWdcAv5nXtRnX6Z4lFLpBp0PPuRUrFUNgTpGcSdGc
CUQHalF0V9H6BmjOtKL5mp55jub2a1ETBuPCj6Lyu7T2xoj+T6Dug0z0BLYs
j5QXD1Xe781PbY/0bPX2qj/s23bNo8cbRvbEy6vey/3e2ZQnSfXdpdBArbWO
fzNleK5hBA3wVgcnxL38kY75tlbJqQ/yyk7UVJ6p7L+QPOfpL4rwFMWCzuXH
eEzFeJSOwbag6ilIOOkQw5a+CTq2tlG6CMqDqPBtrNMHWa6kLi0dFKDmxdlX
cT8O3Gdj1Ui3wiWEZWBUbyCQttCXYdEjwDcMboxte6JTyAEWlWnW5/YWhfIc
steQfHE97+8FGr9n8+mrFm+wJh01QC2i8dLCsYq7fVnRfdEe7V5eDYf8erzc
+/0AhBSqa69HlLqmtWU+Hq+HeHZTxVhmXA/qHUQDI2hwVNvPm+nmj3bOH3sv
58Gp0vpzJaOX4oXeXGm0hyQeaC2Ic6+agMaj9XzUOAvZ+ua9uhv4WlgjlhhB
e2hoXb3B7MGt3HQ1t31gQBNU0vvBgltCWgOmJhPIa087KPhgmqn7koW6oO2J
2/699LWm7eUfoC3ZIGmbwYdjPm/BVapSUD2oiMmSuxPluf3JAcMx7l0enMYD
3EEf9yF/oG2bn8cD98gar6y+/KfgGPXwGov6S9LbUW8fGhhAg4OmoWFZL4/6
yuXP6c1n7rVcuDvlGiPx4yrj3eWJYL5ECfDajltJdYrotfgRnGbB18DCndSA
M+MwlIHmGy2r3XQ/GaDu3xDqksOawEwj1No2mG0hpjOT1hN2WE+oDc/5gi8R
8lrUMm0O4c7X1sPmC/T8YB16Yqz8QVhyc6Y4d7o8ezjJZyzOo8fNu2kfd5Tr
PhoIIOsMcK/3iH4ccHPwDoTK5toG6/Pb+XWtqLcb9feiwT40NGAYgBDXwXeT
u8/d6r10U3A1UhHgp0lyUyWDcZIkXx/E5OulM1ZeGZZBUJaaeFHTBGrqJscZ
SRpcDM1oLjVhR/tflir95v5nuMg+aQ9FOkQZSS0DipjWVGTYazAF1di1YJoN
nDVK7Yh5A2pc/1E0/BCt9c8itFsoyhIUZ8+VpY/d8J6I9+i77tN6kDsZ6MEL
Adr1BLk1eMW0RuYO34Uyz9NPu2pznqLOFtTbjvo70WAXGgQduzQ2tvftuJEL
6WOu6dLrYepgX0OKmzYFaCdPuTYpgT6V8Mxj1BTvFZ4CcnIoN0eCY7NynKOp
xns8jdhwLS/Sni3pz0wqea11OjDR2GQCHTdaOm3RRY6pzxfp/kYUQg1YDZg1
LNaeQNSX1WZ3jcwRLdCE23qsR7kXKPmxzacvmyn6r5L7GaKidGHpjck0zlSs
58BVn+7jfjPBnlNhIJADodcbObE9iXdHC6AsLK++pTLtIep8gnqfof5WNNCO
BqHmzOL4mPNbkTMXE+euJqrcg/XhPktp1w1pYLZVaVcX8ArAHB0jm6X+/6pA
DX68GAsVhQqlAdrLkVq7pPnYCqkxZWfuBmWp7GcknVY30EqUtGuH61L/ZwJV
7RfxB0Slrq9PKUtlRVHL3I+mjS1FmetS9BObT83V3hh/lBWkSu/fkJQmzGR4
8qO9hlx9B8/6CsI8ZiOBosMR11p8Y0YyC8eKobLpSFXDZEUd6mxAvU9RfzMa
aEE412WRN7rjDcg9kV2L0nkFLUVBlG0pEzL/dBkQEFBqkExDryFIwDcUg0dO
kZMUM9QYaMtkXKS3TNIUtfTXsurtAvgkfTQYVn0NMTXtFnFZbgYt8fgM4mI9
52VZ6Ik1JOdHUdA2qxTPz34HkLmXrLifIC+JXsjymI3yGrnkN3bZRxThPh8N
IjoWdbWdGz2dVyysgwLFAyU1qLUadT1EvY9RfyPqBwO0OtptnIRMUrORIOmO
+M+Y7apXwx4llQYptUiBKWgHQWTQV8QMUKYCjx0XxF95jmoEhxvMOFyjGHWQ
Hg9LuIo5oRuJmBGhtsi1NdVofeiDDbOFFohUwyAxsE20FsT0+Q31A+2dBE1h
tOp+qDzHXRDBGbvInXbzlkSDBpyNvT4Ze6U7MHomH4rt6Dvqeu6VorYK1FWL
eh+ivkeoH1Y3V8a6LTYU5izLNy8vqqFuoE4DVXg0WkRWEalH1BOrqiNDwIOi
BkjAhKXTqoum0UIbq44sFHWYNG0s8mk0V9V+wYrYaSw08VuXJsQTtM1tw5SC
rgSGO9H6gnB1rrfqlocwzJt33n/eh6OIBcmbj7/GT3AdioiduwNFWzTN5bzi
AtRWiroqUW8N6qtDA2BxV8a79NMjDAt9oHr/ihotapBRAxVBjTqIoZI1CL05
mESqg5P69cvEAaHrjVn1CoP6jut0wbO2tkwrajHsCJIwnYz0XIaYCOy/2OkM
z+ktLjakFpocpyuoMj5fz9aCnC3nhy8VBOvvcLS3PRZCfCbP+ksDvdTYEVtI
ujqX5DqZmCC8C66foqEQNd9FbfdRVxksHfWC5KGR5uWJLgN/eGWOh/lOx8yo
CZLatKpBq1q0ooPy1EuUjoXC6a8QtUw0M/VKaLViJhexn7gPoJlSa70uqTf2
tBUF+pg9Ekwb6jrr0YeBCUSwFPA9tPliHc2E9cVvlu556W95SoJ9p08HqMM9
dUmge2QpV0Qpl+czbiwUQu1gSW0uas5FbfdQVzHqKUX9UD0NjTYtTXYu8wfQ
3BgS8vFemZ/COpV6BWlMJu1zdGGQRgcgafB/uq/RCo0Eggyr2nXQ7RMRrbLB
mhr2y2Z3wuxR2FkmbERv2+kttAiyGvOaRH1Ja5kNZjv2b8YcL1mg78ypQGOs
hxF7R8o0V0naJVlumrgE9kcLyzNR803Ulo+6ClFPMRrAwx97ujTViWb60Nwo
Ek4h4TSk8UFa6TwSLyCZEpeJXobSnxoE1NABNUDGKJRAnwfQJyskeGhFCVrP
EjGxo2lhLU0MK5rgPjsAcIsde4Em1H+h9IjJ+DevgwSc+fVPy9iP0WRelmde
VOYlq2tg7KgxFTVnobbbqOsO6i3C4vDANP4ETbVB4p1geC3LjaKAaBZJxFAz
UoVnMdTwNasUR7VEt5p00EfAErqDkRrW7LHJ3KUV45/0HTL3M3hBf4BNwn6j
rca1DD1iPdvM+Ot6Fvq52CypkGbIviS5EaS+E29qysJUSEbN6SRD7hemiUY0
1YpmuiGjVDiOhDzM9mmoNiuTIsphUeqAAGozAeA5oWj9RoQbKcBh7l1j6Slu
1cPWtn8Y/vdGyzkWg8O0tTh2RInCkMKf4/mW9Ub9E+tRg1DduqhIC9Teha0a
6HEc2RNPy8gv0UwXEgwi4Qge6gRa4CPJPJLLkVJtNWBc+EVrQlpEDZcaLJMa
KvRLId6BCQ/HRBtN21FusOKw+fQXrAQ9OkA0DIdkFX69zugwNsxOkTYjwHAv
HMsCXpH4OVxG0I/mh+DNwiQSzyCpCCnkSKFECjV4S2pYW4bKvdpVakCYe3aA
XXzgDlakrhLxjmzH8pKttaP9TotGt9JQoKxJzeVvrDQT5jfhy3JusPF+CFau
NDf+O1rgIfEUkswiuRhvMaP4QMmc5bGX6SfX4SdnwiNvsPRKQgbLDAPD7bl+
sy/baBp7s8dst2J5an/6qXFUivHd91CfmlDn+S+VQmYjiV9hqkumkXQO9khB
lwYFoEelw49Mis4u464O8ODm57Zbe2jcN8xWLmyp/kIHXbM1tfYgfOgR4D0h
DPY6I7BnrPVYoQgvFwGZlQqkItu79TAzVuNn1i5DDzOKztDwgpRPxyCxR4Z1
nsa2O7BtFMKiD+hn8aKfFOccvZBla6Y1HsdPGWS/oVKBH1GLGwbh+SZ5Sq35
KS2PSB0brGi63vNtMHsnFsXjRcse3kfBcKQxizN5wcNGKiWDrpSgw10SjFAr
QLsM9TSgiL0O11nWQblacne6mpQBIRs9YMVVOMedpgSuyfdCtiqmz9/gO6vw
7nut9c3JvfGNV4FHG0A3IYN1b1H6Idbr3WjNjyv0U+CabC/kYf6dGTEvwwNo
8OxUs4iJj8up6VZorFDoAGyv9S+zs/BhfazDvzfaPMsl+llwVjVju82z/NrC
EWqKY34OrJ+X8XMAB2AFAPfhw1oNHFpbmvwNcMjmvufp++IMRsYOawSQOjxQ
HgLbPC0uublCxBmjz6pGPL7nRqtxE8I97+ufoe+F84gYu9bjOs7EwzeEArIY
6PY0wEzkRjBIK6STsb1kc6dTNK7fwHdyXu9OG8idLLdh2BOpN9+HemNnlnyr
Mdne6Tg9JrxG+EIO4t9Z6Gi+jR2Axiw5ehOusw/3sbNoGHMPRwa22c/f7Qh9
N7ymgLPprPPknrs2TTSm+dpW1Fr/Xi70tfHuaMa+7x0JSJ0JI4IgwM4sf1Z3
2GBDtYP0tfF+Tcb+75E0O/qK9ja2wpbme2nu4nnQC7lrVk9qIof5Ka2xav8c
XcgvnemnxF71C7lXa3WR8UUZ6111g7UmoE7fSV/xG3zFQ1b8on9lwiJkc5WN
6PnYnhN9FWwxXshB+pUFzVbCT8n689dwoK+BtRzG0Yu1UWgBw5L7/K+/oX+N
ZZZx9L/4NfzwJZtfb6H5tRf/+hhNBTPXbUf7FX0vzNcX8iFs78W0+fXn9K8x
lRgn1/v1ms1kkJgMnI+zXbDesD3fvJcczjqNzzpNj8C2osyH9DjP47Ns17lt
dzK+R1/zEj77nM23trun3qbPvorPPm/zre3+jtfps93x2Rfo57U96z/os3Dk
E1ug/yo394/02TjC9cL6nG1m4h9oWgTis11tvrXNJfo9fe0QfPYV+nltz/pH
+iw8G3xhRct2hfs39Nkx+GzbtRvb9cRf0Wcn4LPdbL61Xen5BT26G/hsd5tv
bVczXqWvnYbP9qBHZ3vWy/RZWfgsL3xb69jPS/T3t/D31tHq43SDLNy8HX/r
Tb1CELIA/4vx3/4PJTNCrQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 240},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135630232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153181089],

Cell[TextData[{
 "Distribution of average distance ",
 Cell[BoxData["s"], "InlineFormula"],
 " of all pairs of points in a ",
 Cell[BoxData["d"], "InlineFormula"],
 "\[Hyphen]dimensional hypersphere:"
}], "ExampleText",
 CellID->418799904],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"d_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"d", " ", 
   RowBox[{"s", "^", 
    RowBox[{"(", 
     RowBox[{"d", "-", "1"}], ")"}]}], " ", 
   RowBox[{
    RowBox[{"Beta", "[", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "/", "4"}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", "1"}], ")"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "/", 
    RowBox[{"Beta", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", "1"}], ")"}], "/", "2"}], ",", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684048981],

Cell["\<\
Low\[Hyphen]dimensional distributions can be expressed in elementary \
functions:\
\>", "ExampleText",
 CellID->785253660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"FunctionExpand", "[", 
       RowBox[{"p", "[", 
        RowBox[{"d", ",", "s"}], "]"}], "]"}], ",", 
      RowBox[{"s", ">", "0"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->263680261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["s", "2"]}], ",", 
   FractionBox[
    RowBox[{"s", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "s"}], " ", 
        SqrtBox[
         RowBox[{"4", "-", 
          SuperscriptBox["s", "2"]}]]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"ArcCsc", "[", 
         FractionBox["2", 
          SqrtBox[
           RowBox[{"4", "-", 
            SuperscriptBox["s", "2"]}]]], "]"}]}]}], ")"}]}], "\[Pi]"], ",", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "s"}], ")"}], "2"], " ", 
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", "s"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{421, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->547081465]
}, Open  ]],

Cell["Plot distributions:", "ExampleText",
 CellID->148563989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"d", ",", "s"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->184448130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29809327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->614856003],

Cell[TextData[{
 "The PDF for the beta distribution for random variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->392711660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21025772],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Beta]"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Alpha]"}]]}], 
  RowBox[{"Beta", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]]], "Output",
 ImageSize->{100, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11960726]
}, Open  ]],

Cell["Plot the PDF for various parameters:", "ExampleText",
 CellID->227643171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PDF", "[", 
         RowBox[{"BetaDistribution", "[", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "[", "x", "]"}],
        ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "/", "4"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Beta]", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "/", "4"}]}], 
        "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15072923],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141506497]
}, Open  ]],

Cell["Calculate the mean:", "ExampleText",
 CellID->183466001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BetaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->96388798],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->494296775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113663361],

Cell["\<\
Express the Euler beta function as a ratio of Euler gamma functions:\
\>", "ExampleText",
 CellID->339731660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Beta", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97003833],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"a", "+", "b"}], "]"}]]], "Output",
 ImageSize->{124, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49154470]
}, Open  ]],

Cell["\<\
Reduce the generalized incomplete beta function to incomplete beta functions:\
\
\>", "ExampleText",
 CellID->35592447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"z1", ",", "z2", ",", "a", ",", "b"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236016141],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Beta", "[", 
    RowBox[{"z1", ",", "a", ",", "b"}], "]"}]}], "+", 
  RowBox[{"Beta", "[", 
   RowBox[{"z2", ",", "a", ",", "b"}], "]"}]}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110447451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237937354],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify beta functions:"
}], "ExampleText",
 CellID->108063952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{
     RowBox[{"2", " ", "a"}], ",", 
     RowBox[{"2", " ", "b"}]}], "]"}], 
   RowBox[{
    RowBox[{"Beta", "[", 
     RowBox[{"b", ",", "b"}], "]"}], "/", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Beta", "[", 
       RowBox[{"a", ",", "b"}], "]"}], " ", 
      RowBox[{"Beta", "[", 
       RowBox[{
        RowBox[{"a", "+", 
         RowBox[{"1", "/", "2"}]}], ",", "b"}], "]"}]}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270240049],

Cell[BoxData[
 SuperscriptBox["4", 
  RowBox[{"-", "b"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135347049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74289641],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->24823202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Beta", "[", 
      RowBox[{"1", ",", "z"}], "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"Beta", "[", 
       RowBox[{"2", ",", 
        RowBox[{"z", "^", "2"}]}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->456394373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "1.7500595608727254`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19989029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85777943],

Cell[TextData[{
 "Sum expressions involving ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->95292240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "n"], 
  RowBox[{"Beta", "[", 
   RowBox[{"k", ",", "k"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599570563],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", "\[Pi]"}], 
   RowBox[{"3", " ", 
    SqrtBox["3"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "n"}]}]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{"1", ",", 
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{
       FractionBox["3", "2"], "+", "n"}], ",", 
      FractionBox["1", "4"]}], "]"}]}], 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["3", "2"], "+", "n"}], "]"}]]}]], "Output",
 ImageSize->{443, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257002478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "n"], 
  FractionBox[
   SuperscriptBox["z", "k"], 
   RowBox[{"Beta", "[", 
    RowBox[{"k", ",", 
     RowBox[{"2", "k"}]}], "]"}]]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504371935],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "z", " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox["4", "3"], ",", 
     FractionBox["5", "3"], ",", 
     FractionBox["3", "2"], ",", 
     FractionBox[
      RowBox[{"27", " ", "z"}], "4"]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"1", "+", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"3", "+", 
      RowBox[{"3", " ", "n"}]}], "]"}], " ", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{
         FractionBox["4", "3"], "+", "n"}], ",", 
        RowBox[{
         FractionBox["5", "3"], "+", "n"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "+", "n"}], ",", 
        RowBox[{
         FractionBox["3", "2"], "+", "n"}]}], "}"}], ",", 
      FractionBox[
       RowBox[{"27", " ", "z"}], "4"]}], "]"}]}], 
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", "n"}]}], "]"}]}]]}]], "Output",
 ImageSize->{491, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91231055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156622989],

Cell["Generating function:", "ExampleText",
 CellID->245918793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"k", ",", "b"}], "]"}], " ", 
   SuperscriptBox["x", "k"]}]}]], "Input",
 CellTags->"Fibonacci",
 CellLabel->"In[1]:=",
 CellID->90671346],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", "+", "b"}], "}"}], ",", "x"}], "]"}]}], "b"]], "Output",
 ImageSize->{261, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Fibonacci",
 CellLabel->"Out[1]=",
 CellID->1839498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270776500],

Cell["Generate from integrals:", "ExampleText",
 CellID->139190428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", 
     RowBox[{"(", 
      RowBox[{"a", "-", "1"}], ")"}]}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"b", "-", "1"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"a", ">", "0"}], "\[And]", 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202368664],

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{"z", ",", "a", ",", "b"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41565982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3039949],

Cell["Obtain as special cases of hypergeometric functions:", "ExampleText",
 CellID->166258578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"Hypergeometric2F1Regularized", "[", 
    RowBox[{"a", ",", 
     RowBox[{"1", "-", "b"}], ",", 
     RowBox[{"1", "+", "a"}], ",", "z"}], "]"}], "//", 
   "FunctionExpand"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448481230],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"-", "a"}]], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}]}], 
  RowBox[{"Gamma", "[", "a", "]"}]]], "Output",
 ImageSize->{114, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183877359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "-", "a"}], ",", "b"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"-", "a"}], "}"}]}], "}"}], ",", 
    RowBox[{"-", "z"}]}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430649621],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"Beta", "[", 
   RowBox[{"z", ",", "a", ",", "b"}], "]"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "b"}], "]"}]}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1071704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401144144],

Cell["Obtain as the solution of a differential equation:", "ExampleText",
 CellID->188120525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "z"}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "a", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "-", "2"}], ")"}], " ", "z"}]}], ")"}], " ",
        
       RowBox[{
        SuperscriptBox["w", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], 
    " ", ",", 
    RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393587001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}]}]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], 
         RowBox[{"-", "b"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}], "b"], " ", 
        SuperscriptBox["z", "a"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           SuperscriptBox["z", 
            RowBox[{"-", "a"}]], " ", 
           RowBox[{"Beta", "[", 
            RowBox[{"z", ",", "a", ",", 
             RowBox[{"1", "+", "b"}]}], "]"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           SuperscriptBox["z", 
            RowBox[{"-", "a"}]], " ", 
           RowBox[{"Beta", "[", 
            RowBox[{"z", ",", 
             RowBox[{"1", "+", "a"}], ",", "b"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "+", 
     RowBox[{"C", "[", "2", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{524, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565820927]
}, Open  ]],

Cell["Form the Wronskian:", "ExampleText",
 CellID->732271362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"Coefficient", "[", 
      RowBox[{
       RowBox[{"%", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", " ", "1", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], ",", 
         RowBox[{"C", "[", "2", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->746516458],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", "b"}]]}], " ", 
  SuperscriptBox["z", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307184646]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->88739050],

Cell["\<\
Large arguments can give results too small to be computed explicitly:\
\>", "ExampleText",
 CellID->468921773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"10", "^", "10."}], ",", 
   RowBox[{"10.", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404920665],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->77531014],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176076589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538832788],

Cell["\<\
Machine\[Hyphen]number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->19682407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Beta", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], ",", 
   RowBox[{"10.", "^", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216218868],

Cell[BoxData["9.7649020396999469221232`12.602458100562545*^-604"], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371598331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74944910],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->763524952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->782532896],

Cell["\<\
Algorithmically generated results often use gamma and hypergeometric rather \
than beta functions:\
\>", "ExampleText",
 CellID->457461084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "0"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{"Pochhammer", "[", 
    RowBox[{
     RowBox[{"1", "-", "b"}], ",", "k"}], "]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "k"}], ")"}], " ", 
    RowBox[{"k", "!"}]}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639376175],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"a", "+", "b"}], "]"}]]], "Output",
 ImageSize->{124, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118756783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", 
     RowBox[{"a", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], 
     RowBox[{"b", "-", "1"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{
      RowBox[{"Re", "[", "a", "]"}], ">", "0"}], "\[And]", 
     RowBox[{
      RowBox[{"Re", "[", "b", "]"}], ">", "0"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37019647],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Csc", "[", 
    RowBox[{"b", " ", "\[Pi]"}], "]"}], " ", 
   RowBox[{"Gamma", "[", "a", "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "b"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"a", "+", "b"}], "]"}]}]]], "Output",
 ImageSize->{163, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->718385537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"a", "+", "b", "-", "1"}]], 
  RowBox[{
   UnderoverscriptBox["\[Product]", 
    RowBox[{"k", "=", "1"}], "\[Infinity]"], 
   FractionBox[
    RowBox[{"k", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b", "+", "k", "-", "2"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "k", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "k", "-", "1"}], ")"}]}]]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93237357],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "a", "+", "b"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "a", "+", "b"}], "]"}]}]]], "Output",
 ImageSize->{182, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->571024638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "a", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b", "-", "2"}], ")"}], " ", "z"}]}], ")"}], " ", 
      
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], " ",
    ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24665828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "-", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}]}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "z"}], ")"}], 
        RowBox[{"-", "b"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], "b"], " ", 
       SuperscriptBox["z", "a"], " ", 
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "a"}], ")"}], " ", 
          RowBox[{"Hypergeometric2F1", "[", 
           RowBox[{"a", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"1", "+", "a"}], ",", "z"}], "]"}]}], "+", 
         RowBox[{"a", " ", "z", " ", 
          RowBox[{"Hypergeometric2F1", "[", 
           RowBox[{
            RowBox[{"1", "+", "a"}], ",", 
            RowBox[{"1", "-", "b"}], ",", 
            RowBox[{"2", "+", "a"}], ",", "z"}], "]"}]}]}], ")"}]}]}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{564, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->592609307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->367214135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}]}]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "z"}], ")"}], 
         RowBox[{"-", "b"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}], "b"], " ", 
        SuperscriptBox["z", "a"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           SuperscriptBox["z", 
            RowBox[{"-", "a"}]], " ", 
           RowBox[{"Beta", "[", 
            RowBox[{"z", ",", "a", ",", 
             RowBox[{"1", "+", "b"}]}], "]"}]}], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "a"}], ")"}], " ", 
           SuperscriptBox["z", 
            RowBox[{"-", "a"}]], " ", 
           RowBox[{"Beta", "[", 
            RowBox[{"z", ",", 
             RowBox[{"1", "+", "a"}], ",", "b"}], "]"}]}]}], ")"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "+", 
     RowBox[{"C", "[", "2", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{524, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->217151948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174356589],

Cell[TextData[{
 "Beta functions are typically not generated by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93348789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Beta", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23263124],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"a", "+", "b"}], "]"}]]], "Output",
 ImageSize->{124, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6667453]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->603116260],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"a", "+", "b"}], "]"}]]], "Output",
 ImageSize->{124, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37036675]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->194634380],

Cell[TextData[{
 "Nest ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText",
 CellID->38701751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DensityPlot", "[", 
   RowBox[{
    RowBox[{"Arg", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Beta", "[", 
         RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ",", " ", "3"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Exclusions", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49290586],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266395655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6934249],

Cell[TextData[{
 "The determinant of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix of reciprocals of beta functions is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "!"}], TraditionalForm]], "InlineMath"],
 " :"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->35095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Beta", "[", "##", "]"}]}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "n"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457266984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720", ",", "5040", 
   ",", "40320", ",", "362880", ",", "3628800"}], "}"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24572871]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18863],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Multinomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Multinomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20848],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30226]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16760],

Cell[TextData[{
 ButtonBox["Demonstrations with Beta",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Beta"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/BetaFunction.html"], 
   None}], "IT"]], "RelatedLinks",
 CellID->83052060],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Beta/"], 
   None}]], "RelatedLinks",
 CellID->28918843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->328645639],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->44031266],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->49587843],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->286203319]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Beta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 25, 57.2703870}", "context" -> "System`", 
    "keywords" -> {
     "beta function", "Euler beta function", "incomplete beta function"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Beta[a, b] gives the Euler beta function \\[CapitalBeta](a, b). Beta[z, \
a, b] gives the incomplete beta function \\[CapitalBeta]_z (a, b). ", 
    "synonyms" -> {}, "title" -> "Beta", "type" -> "Symbol", "uri" -> 
    "ref/Beta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9406, 327, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62552494]},
 "Fibonacci"->{
  Cell[141114, 3406, 287, 10, 70, "Input",
   CellTags->"Fibonacci",
   CellID->90671346],
  Cell[141404, 3418, 410, 14, 51, "Output",
   CellTags->"Fibonacci",
   CellID->1839498]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[237262, 5411, 356, 12, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->35095]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 243630, 5636},
 {"Fibonacci", 243765, 5640},
 {"XRef-2005-4-26-23-37-1.8558342", 243985, 5647}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2592, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3215, 87, 42, 1, 70, "ObjectName",
 CellID->13505],
Cell[3260, 90, 1236, 40, 70, "Usage",
 CellID->20278]
}, Open  ]],
Cell[CellGroupData[{
Cell[4533, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5011, 152, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5134, 158, 699, 23, 70, "Notes",
 CellID->15311],
Cell[5836, 183, 522, 19, 70, "Notes",
 CellID->29440],
Cell[6361, 204, 596, 22, 70, "Notes",
 CellID->20017],
Cell[6960, 228, 883, 32, 70, "Notes",
 CellID->30402],
Cell[7846, 262, 397, 13, 70, "Notes",
 CellID->22869],
Cell[8246, 277, 239, 8, 70, "Notes",
 CellID->66827377],
Cell[8488, 287, 210, 7, 70, "Notes",
 CellID->31226],
Cell[8701, 296, 193, 7, 70, "Notes",
 CellID->28162],
Cell[8897, 305, 472, 17, 70, "Notes",
 CellID->15543]
}, Closed]],
Cell[CellGroupData[{
Cell[9406, 327, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62552494],
Cell[CellGroupData[{
Cell[9790, 341, 148, 5, 70, "ExampleSection",
 CellID->167259740],
Cell[9941, 348, 56, 1, 70, "ExampleText",
 CellID->144841031],
Cell[CellGroupData[{
Cell[10022, 353, 120, 4, 28, "Input",
 CellID->967306],
Cell[10145, 359, 180, 6, 51, "Output",
 CellID->269201189]
}, Open  ]],
Cell[CellGroupData[{
Cell[10362, 370, 171, 6, 28, "Input",
 CellID->414404733],
Cell[10536, 378, 207, 7, 51, "Output",
 CellID->410533667]
}, Open  ]],
Cell[10758, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->206189481],
Cell[10886, 393, 64, 1, 70, "ExampleText",
 CellID->461214495],
Cell[CellGroupData[{
Cell[10975, 398, 127, 4, 70, "Input",
 CellID->236580824],
Cell[11105, 404, 177, 5, 36, "Output",
 CellID->583025163]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11331, 415, 220, 7, 70, "ExampleSection",
 CellID->567555255],
Cell[11554, 424, 74, 1, 70, "ExampleText",
 CellID->713960928],
Cell[CellGroupData[{
Cell[11653, 429, 173, 6, 70, "Input",
 CellID->451671756],
Cell[11829, 437, 275, 7, 36, "Output",
 CellID->461796182]
}, Open  ]],
Cell[12119, 447, 122, 3, 70, "ExampleDelimiter",
 CellID->572555],
Cell[12244, 452, 72, 1, 70, "ExampleText",
 CellID->520654672],
Cell[CellGroupData[{
Cell[12341, 457, 160, 5, 70, "Input",
 CellID->2747732],
Cell[12504, 464, 327, 11, 52, "Output",
 CellID->165211433]
}, Open  ]],
Cell[CellGroupData[{
Cell[12868, 480, 175, 6, 70, "Input",
 CellID->719085793],
Cell[13046, 488, 214, 6, 36, "Output",
 CellID->196669033]
}, Open  ]],
Cell[13275, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->392763304],
Cell[13403, 502, 69, 1, 70, "ExampleText",
 CellID->81499434],
Cell[CellGroupData[{
Cell[13497, 507, 233, 8, 70, "Input",
 CellID->97037539],
Cell[13733, 517, 235, 7, 36, "Output",
 CellID->244758193]
}, Open  ]],
Cell[13983, 527, 125, 3, 70, "ExampleDelimiter",
 CellID->108355827],
Cell[14111, 532, 112, 3, 70, "ExampleText",
 CellID->71905740],
Cell[CellGroupData[{
Cell[14248, 539, 173, 5, 70, "Input",
 CellID->40373818],
Cell[14424, 546, 219, 6, 36, "Output",
 CellID->133595278]
}, Open  ]],
Cell[CellGroupData[{
Cell[14680, 557, 177, 6, 70, "Input",
 CellID->534691918],
Cell[14860, 565, 218, 6, 36, "Output",
 CellID->34564762]
}, Open  ]],
Cell[15093, 574, 125, 3, 70, "ExampleDelimiter",
 CellID->210679119],
Cell[15221, 579, 60, 1, 70, "ExampleText",
 CellID->516976087],
Cell[CellGroupData[{
Cell[15306, 584, 264, 9, 70, "Input",
 CellID->118300406],
Cell[15573, 595, 1408, 42, 100, "Output",
 CellID->270443406]
}, Open  ]],
Cell[16996, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->760443585],
Cell[17124, 645, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[17352, 656, 161, 5, 70, "Input",
 CellID->35954786],
Cell[17516, 663, 345, 12, 50, "Output",
 CellID->434560486]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17910, 681, 243, 7, 70, "ExampleSection",
 CellID->181036055],
Cell[CellGroupData[{
Cell[18178, 692, 239, 7, 70, "ExampleSubsection",
 CellID->10993277],
Cell[18420, 701, 82, 1, 70, "ExampleText",
 CellID->298788561],
Cell[CellGroupData[{
Cell[18527, 706, 123, 4, 70, "Input",
 CellID->226653574],
Cell[18653, 712, 173, 5, 36, "Output",
 CellID->311395924]
}, Open  ]],
Cell[18841, 720, 125, 3, 70, "ExampleDelimiter",
 CellID->290848674],
Cell[18969, 725, 84, 1, 70, "ExampleText",
 CellID->594822126],
Cell[CellGroupData[{
Cell[19078, 730, 129, 4, 70, "Input",
 CellID->80241163],
Cell[19210, 736, 173, 5, 36, "Output",
 CellID->143556662]
}, Open  ]],
Cell[19398, 744, 125, 3, 70, "ExampleDelimiter",
 CellID->172644019],
Cell[19526, 749, 202, 7, 70, "ExampleText",
 CellID->301332388],
Cell[CellGroupData[{
Cell[19753, 760, 192, 6, 70, "Input",
 CellID->280711331],
Cell[19948, 768, 314, 11, 51, "Output",
 CellID->59341905]
}, Open  ]],
Cell[20277, 782, 125, 3, 70, "ExampleDelimiter",
 CellID->182964011],
Cell[20405, 787, 201, 7, 70, "ExampleText",
 CellID->505929579],
Cell[CellGroupData[{
Cell[20631, 798, 314, 11, 70, "Input",
 CellID->261287071],
Cell[20948, 811, 1076, 36, 54, "Output",
 CellID->87370160]
}, Open  ]],
Cell[22039, 850, 125, 3, 70, "ExampleDelimiter",
 CellID->512320018],
Cell[22167, 855, 69, 1, 70, "ExampleText",
 CellID->336075855],
Cell[CellGroupData[{
Cell[22261, 860, 376, 13, 70, "Input",
 CellID->259926810],
Cell[22640, 875, 1898, 59, 87, "Output",
 CellID->882461057]
}, Open  ]],
Cell[24553, 937, 124, 3, 70, "ExampleDelimiter",
 CellID->10054809],
Cell[24680, 942, 72, 1, 70, "ExampleText",
 CellID->788929685],
Cell[CellGroupData[{
Cell[24777, 947, 248, 8, 70, "Input",
 CellID->249508285],
Cell[25028, 957, 1647, 52, 84, "Output",
 CellID->145115440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26724, 1015, 244, 7, 70, "ExampleSubsection",
 CellID->51693688],
Cell[26971, 1024, 116, 3, 70, "ExampleText",
 CellID->647654465],
Cell[CellGroupData[{
Cell[27112, 1031, 199, 6, 70, "Input",
 CellID->406590799],
Cell[27314, 1039, 1008, 35, 62, "Output",
 CellID->136072827]
}, Open  ]],
Cell[CellGroupData[{
Cell[28359, 1079, 301, 10, 70, "Input",
 CellID->428496326],
Cell[28663, 1091, 395, 14, 76, "Output",
 CellID->299472639]
}, Open  ]],
Cell[29073, 1108, 125, 3, 70, "ExampleDelimiter",
 CellID->221705813],
Cell[29201, 1113, 73, 1, 70, "ExampleText",
 CellID->869625340],
Cell[CellGroupData[{
Cell[29299, 1118, 256, 8, 70, "Input",
 CellID->49535822],
Cell[29558, 1128, 1895, 35, 70, "Output",
 Evaluatable->False,
 CellID->255399040]
}, Open  ]],
Cell[CellGroupData[{
Cell[31490, 1168, 256, 8, 70, "Input",
 CellID->69196080],
Cell[31749, 1178, 1679, 47, 75, "Output",
 CellID->406729871]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33477, 1231, 257, 7, 70, "ExampleSubsection",
 CellID->215540193],
Cell[CellGroupData[{
Cell[33759, 1242, 184, 6, 70, "Input",
 CellID->933796700],
Cell[33946, 1250, 331, 11, 36, "Output",
 CellID->389644919]
}, Open  ]],
Cell[34292, 1264, 124, 3, 70, "ExampleDelimiter",
 CellID->38450684],
Cell[CellGroupData[{
Cell[34441, 1271, 333, 11, 70, "Input",
 CellID->127330320],
Cell[34777, 1284, 640, 21, 79, "Output",
 CellID->360917123]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35478, 1312, 227, 7, 70, "ExampleSection",
 CellID->745597232],
Cell[35708, 1321, 91, 1, 70, "ExampleText",
 CellID->497859830],
Cell[CellGroupData[{
Cell[35824, 1326, 310, 10, 70, "Input",
 CellID->202594063],
Cell[36137, 1338, 13653, 228, 70, "Output",
 Evaluatable->False,
 CellID->246416522]
}, Open  ]],
Cell[49805, 1569, 125, 3, 70, "ExampleDelimiter",
 CellID->191771802],
Cell[49933, 1574, 226, 8, 70, "ExampleText",
 CellID->45360317],
Cell[CellGroupData[{
Cell[50184, 1586, 464, 16, 70, "Input",
 CellID->127660828],
Cell[50651, 1604, 52331, 862, 70, "Output",
 Evaluatable->False,
 CellID->135630232]
}, Open  ]],
Cell[102997, 2469, 125, 3, 70, "ExampleDelimiter",
 CellID->153181089],
Cell[103125, 2474, 239, 7, 70, "ExampleText",
 CellID->418799904],
Cell[103367, 2483, 713, 25, 70, "Input",
 CellID->684048981],
Cell[104083, 2510, 132, 4, 70, "ExampleText",
 CellID->785253660],
Cell[CellGroupData[{
Cell[104240, 2518, 395, 13, 70, "Input",
 CellID->263680261],
Cell[104638, 2533, 925, 33, 75, "Output",
 CellID->547081465]
}, Open  ]],
Cell[105578, 2569, 62, 1, 70, "ExampleText",
 CellID->148563989],
Cell[CellGroupData[{
Cell[105665, 2574, 393, 13, 70, "Input",
 CellID->184448130],
Cell[106061, 2589, 7995, 135, 70, "Output",
 Evaluatable->False,
 CellID->29809327]
}, Open  ]],
Cell[114071, 2727, 125, 3, 70, "ExampleDelimiter",
 CellID->614856003],
Cell[114199, 2732, 182, 6, 70, "ExampleText",
 CellID->392711660],
Cell[CellGroupData[{
Cell[114406, 2742, 211, 7, 70, "Input",
 CellID->21025772],
Cell[114620, 2751, 475, 17, 56, "Output",
 CellID->11960726]
}, Open  ]],
Cell[115110, 2771, 79, 1, 70, "ExampleText",
 CellID->227643171],
Cell[CellGroupData[{
Cell[115214, 2776, 867, 27, 70, "Input",
 CellID->15072923],
Cell[116084, 2805, 17679, 294, 70, "Output",
 Evaluatable->False,
 CellID->141506497]
}, Open  ]],
Cell[133778, 3102, 62, 1, 70, "ExampleText",
 CellID->183466001],
Cell[CellGroupData[{
Cell[133865, 3107, 179, 5, 70, "Input",
 CellID->96388798],
Cell[134047, 3114, 221, 7, 51, "Output",
 CellID->494296775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[134317, 3127, 237, 7, 70, "ExampleSection",
 CellID->113663361],
Cell[134557, 3136, 119, 3, 70, "ExampleText",
 CellID->339731660],
Cell[CellGroupData[{
Cell[134701, 3143, 164, 5, 70, "Input",
 CellID->97003833],
Cell[134868, 3150, 323, 11, 53, "Output",
 CellID->49154470]
}, Open  ]],
Cell[135206, 3164, 129, 4, 70, "ExampleText",
 CellID->35592447],
Cell[CellGroupData[{
Cell[135360, 3172, 186, 6, 70, "Input",
 CellID->236016141],
Cell[135549, 3180, 333, 11, 36, "Output",
 CellID->110447451]
}, Open  ]],
Cell[135897, 3194, 125, 3, 70, "ExampleDelimiter",
 CellID->237937354],
Cell[136025, 3199, 222, 8, 70, "ExampleText",
 CellID->108063952],
Cell[CellGroupData[{
Cell[136272, 3211, 562, 20, 70, "Input",
 CellID->270240049],
Cell[136837, 3233, 199, 7, 36, "Output",
 CellID->135347049]
}, Open  ]],
Cell[137051, 3243, 124, 3, 70, "ExampleDelimiter",
 CellID->74289641],
Cell[137178, 3248, 95, 1, 70, "ExampleText",
 CellID->24823202],
Cell[CellGroupData[{
Cell[137298, 3253, 430, 15, 70, "Input",
 CellID->456394373],
Cell[137731, 3270, 226, 7, 36, "Output",
 CellID->19989029]
}, Open  ]],
Cell[137972, 3280, 124, 3, 70, "ExampleDelimiter",
 CellID->85777943],
Cell[138099, 3285, 200, 8, 70, "ExampleText",
 CellID->95292240],
Cell[CellGroupData[{
Cell[138324, 3297, 204, 7, 70, "Input",
 CellID->599570563],
Cell[138531, 3306, 791, 28, 70, "Output",
 CellID->257002478]
}, Open  ]],
Cell[CellGroupData[{
Cell[139359, 3339, 273, 10, 70, "Input",
 CellID->504371935],
Cell[139635, 3351, 1248, 42, 91, "Output",
 CellID->91231055]
}, Open  ]],
Cell[140898, 3396, 125, 3, 70, "ExampleDelimiter",
 CellID->156622989],
Cell[141026, 3401, 63, 1, 70, "ExampleText",
 CellID->245918793],
Cell[CellGroupData[{
Cell[141114, 3406, 287, 10, 70, "Input",
 CellTags->"Fibonacci",
 CellID->90671346],
Cell[141404, 3418, 410, 14, 51, "Output",
 CellTags->"Fibonacci",
 CellID->1839498]
}, Open  ]],
Cell[141829, 3435, 125, 3, 70, "ExampleDelimiter",
 CellID->270776500],
Cell[141957, 3440, 67, 1, 70, "ExampleText",
 CellID->139190428],
Cell[CellGroupData[{
Cell[142049, 3445, 586, 20, 70, "Input",
 CellID->202368664],
Cell[142638, 3467, 220, 7, 36, "Output",
 CellID->41565982]
}, Open  ]],
Cell[142873, 3477, 123, 3, 70, "ExampleDelimiter",
 CellID->3039949],
Cell[142999, 3482, 95, 1, 70, "ExampleText",
 CellID->166258578],
Cell[CellGroupData[{
Cell[143119, 3487, 281, 9, 70, "Input",
 CellID->448481230],
Cell[143403, 3498, 346, 12, 54, "Output",
 CellID->183877359]
}, Open  ]],
Cell[CellGroupData[{
Cell[143786, 3515, 479, 17, 70, "Input",
 CellID->430649621],
Cell[144268, 3534, 353, 12, 36, "Output",
 CellID->1071704]
}, Open  ]],
Cell[144636, 3549, 125, 3, 70, "ExampleDelimiter",
 CellID->401144144],
Cell[144764, 3554, 93, 1, 70, "ExampleText",
 CellID->188120525],
Cell[CellGroupData[{
Cell[144882, 3559, 789, 26, 70, "Input",
 CellID->393587001],
Cell[145674, 3587, 1482, 46, 75, "Output",
 CellID->565820927]
}, Open  ]],
Cell[147171, 3636, 62, 1, 70, "ExampleText",
 CellID->732271362],
Cell[CellGroupData[{
Cell[147258, 3641, 702, 23, 70, "Input",
 CellID->746516458],
Cell[147963, 3666, 411, 16, 36, "Output",
 CellID->307184646]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[148423, 3688, 229, 7, 70, "ExampleSection",
 CellID->88739050],
Cell[148655, 3697, 120, 3, 70, "ExampleText",
 CellID->468921773],
Cell[CellGroupData[{
Cell[148800, 3704, 177, 6, 70, "Input",
 CellID->404920665],
Cell[148980, 3712, 357, 7, 70, "Message",
 CellID->77531014],
Cell[149340, 3721, 188, 6, 36, "Output",
 CellID->176076589]
}, Open  ]],
Cell[149543, 3730, 125, 3, 70, "ExampleDelimiter",
 CellID->538832788],
Cell[149671, 3735, 120, 3, 70, "ExampleText",
 CellID->19682407],
Cell[CellGroupData[{
Cell[149816, 3742, 175, 6, 70, "Input",
 CellID->216218868],
Cell[149994, 3750, 207, 5, 36, "Output",
 CellID->371598331]
}, Open  ]],
Cell[CellGroupData[{
Cell[150238, 3760, 109, 3, 70, "Input",
 CellID->74944910],
Cell[150350, 3765, 162, 5, 36, "Output",
 CellID->763524952]
}, Open  ]],
Cell[150527, 3773, 125, 3, 70, "ExampleDelimiter",
 CellID->782532896],
Cell[150655, 3778, 149, 4, 70, "ExampleText",
 CellID->457461084],
Cell[CellGroupData[{
Cell[150829, 3786, 364, 13, 70, "Input",
 CellID->639376175],
Cell[151196, 3801, 324, 11, 53, "Output",
 CellID->118756783]
}, Open  ]],
Cell[CellGroupData[{
Cell[151557, 3817, 560, 19, 70, "Input",
 CellID->37019647],
Cell[152120, 3838, 448, 15, 53, "Output",
 CellID->718385537]
}, Open  ]],
Cell[CellGroupData[{
Cell[152605, 3858, 508, 17, 70, "Input",
 CellID->93237357],
Cell[153116, 3877, 460, 16, 53, "Output",
 CellID->571024638]
}, Open  ]],
Cell[CellGroupData[{
Cell[153613, 3898, 727, 24, 70, "Input",
 CellID->24665828],
Cell[154343, 3924, 1360, 43, 97, "Output",
 CellID->592609307]
}, Open  ]],
Cell[CellGroupData[{
Cell[155740, 3972, 110, 3, 70, "Input",
 CellID->367214135],
Cell[155853, 3977, 1482, 46, 75, "Output",
 CellID->217151948]
}, Open  ]],
Cell[157350, 4026, 125, 3, 70, "ExampleDelimiter",
 CellID->174356589],
Cell[157478, 4031, 236, 8, 70, "ExampleText",
 CellID->93348789],
Cell[CellGroupData[{
Cell[157739, 4043, 160, 5, 70, "Input",
 CellID->23263124],
Cell[157902, 4050, 322, 11, 53, "Output",
 CellID->6667453]
}, Open  ]],
Cell[CellGroupData[{
Cell[158261, 4066, 108, 3, 70, "Input",
 CellID->603116260],
Cell[158372, 4071, 323, 11, 53, "Output",
 CellID->37036675]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[158744, 4088, 228, 7, 70, "ExampleSection",
 CellID->194634380],
Cell[158975, 4097, 202, 8, 70, "ExampleText",
 CellID->38701751],
Cell[CellGroupData[{
Cell[159202, 4109, 660, 21, 70, "Input",
 CellID->49290586],
Cell[159865, 4132, 77256, 1271, 70, "Output",
 Evaluatable->False,
 CellID->266395655]
}, Open  ]],
Cell[237136, 5406, 123, 3, 70, "ExampleDelimiter",
 CellID->6934249],
Cell[237262, 5411, 356, 12, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->35095],
Cell[CellGroupData[{
Cell[237643, 5427, 413, 14, 70, "Input",
 CellID->457266984],
Cell[238059, 5443, 313, 9, 36, "Output",
 CellID->24572871]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[238433, 5459, 311, 9, 70, "SeeAlsoSection",
 CellID->18863],
Cell[238747, 5470, 1232, 44, 70, "SeeAlso",
 CellID->25646]
}, Open  ]],
Cell[CellGroupData[{
Cell[240016, 5519, 314, 9, 70, "TutorialsSection",
 CellID->20848],
Cell[240333, 5530, 144, 3, 70, "Tutorials",
 CellID->30226]
}, Open  ]],
Cell[CellGroupData[{
Cell[240514, 5538, 321, 9, 70, "RelatedLinksSection",
 CellID->16760],
Cell[240838, 5549, 348, 11, 70, "RelatedLinks"],
Cell[241189, 5562, 202, 5, 70, "RelatedLinks",
 CellID->83052060],
Cell[241394, 5569, 208, 5, 70, "RelatedLinks",
 CellID->28918843]
}, Open  ]],
Cell[CellGroupData[{
Cell[241639, 5579, 319, 9, 70, "MoreAboutSection",
 CellID->328645639],
Cell[241961, 5590, 164, 3, 70, "MoreAbout",
 CellID->44031266],
Cell[242128, 5595, 181, 3, 70, "MoreAbout",
 CellID->49587843],
Cell[242312, 5600, 145, 3, 70, "MoreAbout",
 CellID->286203319]
}, Open  ]],
Cell[242472, 5606, 27, 0, 70, "History"],
Cell[242502, 5608, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

