(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    125320,       3239]
NotebookOptionsPosition[    114316,       2875]
NotebookOutlinePosition[    115579,       2911]
CellTagsIndexPosition[    115492,       2906]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Beta" :> Documentation`HelpLookup["paclet:ref/Beta"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Beta\"\>", 
       2->"\<\"InverseBetaRegularized\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BetaRegularized", "ObjectName",
 CellID->1925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BetaRegularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BetaRegularized"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the regularized incomplete beta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["I", "z"], "(", 
        RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For non\[Hyphen]singular cases, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"I", "(", 
     RowBox[{"z", ",", "a", ",", "b"}], ")"}], "=", 
    RowBox[{
     RowBox[{"B", "(", 
      RowBox[{"z", ",", "a", ",", "b"}], ")"}], "/", 
     RowBox[{"B", "(", 
      RowBox[{"a", ",", "b"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15304],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the generalized regularized incomplete beta function defined in non\
\[Hyphen]singular cases as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Beta",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Beta"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["0", "TR"]], ",", 
     SubscriptBox[
      StyleBox["z", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}], "/", 
   RowBox[{
    ButtonBox["Beta",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Beta"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22378],

Cell[TextData[{
 "Note that the arguments in ",
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " are arranged differently from those in ",
 Cell[BoxData[
  ButtonBox["GammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaRegularized"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1391],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->477251588],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13002806],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->879006606],

Cell["Evaluate numerically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{"2", ",", "2.4", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"12.45846774248475`", "\[InvisibleSpace]", "+", 
  RowBox[{"8.325064120692744`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->731200073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BetaRegularized", "[", 
       RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", " ", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122508691]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z", ",", "3", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75236264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192621073]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->62550901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BetaRegularized", "[", 
   RowBox[{
    RowBox[{"2", "+", 
     RowBox[{"3", "I"}]}], ",", 
    RowBox[{"4", "-", "I"}], ",", 
    RowBox[{"2", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14756986],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "10703.389202494927`"}], "-", 
  RowBox[{"17471.711946139058`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250155121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53279368],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{
     RowBox[{"22", "/", "10"}], ",", 
     RowBox[{"2", "+", "I"}], ",", " ", "3"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.7326371016366146924991544222649314110403769462382607822188658204016`\
48.81790561164299"}], "+", 
  RowBox[{
  "15.7408577554498439954252413048158900706709630136261049874127312842687`50.\
15004509792569", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493863523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{"2.20000000000000000000000", ",", 
   RowBox[{"2", "+", "I"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.73263710163661469249937715198082117139`19.95688577029626"}],
   "+", 
  RowBox[{
  "15.740857755449843995425285446220775754`21.305293131552027", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490220661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{494, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42657929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BetaRegularized", "[", 
   RowBox[{"z", ",", "a", ",", "b"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    InterpretationBox["I",
     BetaRegularized,
     Editable->False,
     Selectable->False], "z"], "(", 
   RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->226386202]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Ordinary Regularized Incomplete Beta Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate at integer and half\[Hyphen]integer arguments:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BetaRegularized", "[", 
   RowBox[{"z", ",", "2", ",", "5"}], "]"}], "//", "FunctionExpand", 
  "  "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"15", "-", 
    RowBox[{"40", " ", "z"}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"24", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["z", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168886562]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BetaRegularized", "[", 
   RowBox[{"z", ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"3", "/", "2"}]}], "]"}], "//", "FunctionExpand", "  "}]], "Input",\

 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SqrtBox["z"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", "z"}]], "2"], "+", 
     FractionBox[
      RowBox[{"ArcSin", "[", 
       SqrtBox["z"], "]"}], 
      RowBox[{"2", " ", 
       SqrtBox["z"]}]]}], ")"}]}], "\[Pi]"]], "Output",
 ImageSize->{171, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167119218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{"Infinity", ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181492082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7"}], "}"}], ",", "2.5", ",", 
   "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "-", 
    RowBox[{"2.6618379233724268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.9999999999999997`", "\[InvisibleSpace]", "-", 
    RowBox[{"5.4078844712241905`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.9999999999999992`", "\[InvisibleSpace]", "-", 
    RowBox[{"13.256264306821171`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.9999999999999986`", "\[InvisibleSpace]", "-", 
    RowBox[{"24.415962537061418`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96401248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"]}], ",", "a", ",", 
   RowBox[{"5", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"a", " ", 
    RowBox[{"Beta", "[", 
     RowBox[{"a", ",", 
      FractionBox["5", "2"]}], "]"}]}]], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"a", " ", "x"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"Floor", "[", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Arg", "[", "x", "]"}], 
          RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["2", "5"]}], " ", "\[ImaginaryI]", " ", "a", " ", 
          SuperscriptBox["x", 
           RowBox[{"5", "/", "2"}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "x", "]"}], "3"],
          SeriesData[$CellContext`x, 0, {}, 5, 6, 2],
          Editable->False]}],
        SeriesData[$CellContext`x, 0, {Complex[0, 
            Rational[-2, 5]] $CellContext`a}, 5, 6, 2],
        Editable->False], ")"}]}], "+", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         RowBox[{"3", " ", 
          SqrtBox["\[Pi]"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "a"}], "]"}]}], 
         RowBox[{"4", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{
            FractionBox["5", "2"], "+", "a"}], "]"}]}]], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{"a", " ", 
            SqrtBox["\[Pi]"], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "a"}], "]"}]}], ")"}], " ", "x"}], 
         RowBox[{"4", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{
            FractionBox["5", "2"], "+", "a"}], "]"}]}]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "x", "]"}], "2"],
         SeriesData[$CellContext`x, 0, {}, 0, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 0, {
        Rational[3, 4] Pi^Rational[1, 2] Gamma[1 + $CellContext`a]/Gamma[
         Rational[5, 2] + $CellContext`a], Rational[-3, 4] $CellContext`a 
         Pi^Rational[1, 2] Gamma[1 + $CellContext`a]/Gamma[
         Rational[5, 2] + $CellContext`a]}, 0, 2, 1],
       Editable->False], ")"}]}], ")"}]}]}]], "Output",
 ImageSize->{393, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"-", "a"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "a"}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "a", "-", "b"}], "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["z", 
        RowBox[{"a", "+", "b"}]], " ", 
       RowBox[{"(", 
        InterpretationBox[
         RowBox[{
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"1", "+", "a", "+", "b"}]], " ", "a", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "-", "b"}], "]"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "a", "+", "b"}], ")"}], " ", "z"}]], 
          "+", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"a", "+", "b"}]], " ", "a", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "-", "b"}], "]"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              FractionBox["1", "z"], ")"}], "2"]}], 
           RowBox[{
            RowBox[{"-", "2"}], "+", "a", "+", "b"}]], "+", 
          InterpretationBox[
           SuperscriptBox[
            RowBox[{"O", "[", 
             FractionBox["1", "z"], "]"}], "3"],
           SeriesData[$CellContext`z, 
            DirectedInfinity[1], {}, 1, 3, 1],
           Editable->False]}],
         SeriesData[$CellContext`z, 
          DirectedInfinity[
          1], {(-1)^(
             1 + $CellContext`a + $CellContext`b) $CellContext`a (-1 + \
$CellContext`a + $CellContext`b)^(-1) 
           Gamma[1 - $CellContext`b], (-1)^($CellContext`a + $CellContext`b) \
$CellContext`a (-1 + $CellContext`b) (-2 + $CellContext`a + \
$CellContext`b)^(-1) Gamma[1 - $CellContext`b]}, 1, 3, 1],
         Editable->False], ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"a", " ", 
    RowBox[{"Beta", "[", 
     RowBox[{"a", ",", "b"}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "-", "b"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{538, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138692563]
}, Open  ]],

Cell["Give the result for an arbitrary symbolic direction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"DirectedInfinity", "[", "x", "]"}], ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{559, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230300223]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalized Regularized Incomplete Beta Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection"],

Cell["\<\
Evaluate at integer and half\[Hyphen]integer arguments:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z", ",", "2", ",", " ", 
     RowBox[{"7", "/", "2"}], ",", " ", 
     RowBox[{"1", "/", "2"}]}], "]"}], "//", "FunctionExpand"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"15", " ", "\[Pi]", " ", 
    SqrtBox[
     RowBox[{"1", "-", "z"}]]}]], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"15", " ", 
      SqrtBox["z"]}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["z", 
       RowBox[{"3", "/", "2"}]]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["z", 
       RowBox[{"5", "/", "2"}]]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["z", 
       RowBox[{"7", "/", "2"}]]}], "+", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", "z"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "67"}], " ", "\[ImaginaryI]", " ", 
         SqrtBox["2"]}], "+", 
        RowBox[{"15", " ", 
         RowBox[{"ArcSin", "[", 
          SqrtBox["2"], "]"}]}]}], ")"}]}], "-", 
     RowBox[{"15", " ", 
      SqrtBox[
       RowBox[{"1", "-", "z"}]], " ", 
      RowBox[{"ArcSin", "[", 
       SqrtBox["z"], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{425, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10081954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansions at generic point:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z0", ",", "z1", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z0", ",", "\[Zeta]", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{509, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96777902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z0", ",", "z1", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "\[Alpha]", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{531, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247551644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42124962],

Cell["Series expansion at infinity:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BetaRegularized", "[", 
    RowBox[{"z0", ",", "z1", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"-", "a"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "a"], " ", "a", " ", 
        RowBox[{"Beta", "[", 
         RowBox[{"a", ",", "b"}], "]"}], " ", 
        RowBox[{"BetaRegularized", "[", 
         RowBox[{"z0", ",", "a", ",", "b"}], "]"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "-", "b"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "a"}], "]"}], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "-", "a", "-", "b"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z1", 
         RowBox[{"a", "+", "b"}]], " ", 
        RowBox[{"(", 
         InterpretationBox[
          RowBox[{
           FractionBox[
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], 
              RowBox[{"a", "+", "b"}]], " ", "a", " ", 
             RowBox[{"Gamma", "[", 
              RowBox[{"1", "-", "b"}], "]"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "a", "+", "b"}], ")"}], " ", "z1"}]], 
           "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], 
              RowBox[{"a", "+", "b"}]], " ", "a", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "b"}], ")"}], " ", 
             RowBox[{"Gamma", "[", 
              RowBox[{"1", "-", "b"}], "]"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               FractionBox["1", "z1"], ")"}], "2"]}], 
            RowBox[{
             RowBox[{"-", "2"}], "+", "a", "+", "b"}]], "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", 
              FractionBox["1", "z1"], "]"}], "3"],
            SeriesData[$CellContext`z1, 
             DirectedInfinity[1], {}, 1, 3, 1],
            Editable->False]}],
          SeriesData[$CellContext`z1, 
           DirectedInfinity[
           1], {(-1)^($CellContext`a + $CellContext`b) $CellContext`a (-1 + \
$CellContext`a + $CellContext`b)^(-1) 
            Gamma[1 - $CellContext`b], -(-1)^($CellContext`a + \
$CellContext`b) $CellContext`a (-1 + $CellContext`b) (-2 + $CellContext`a + \
$CellContext`b)^(-1) Gamma[1 - $CellContext`b]}, 1, 3, 1],
          Editable->False], ")"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"a", " ", 
     RowBox[{"Beta", "[", 
      RowBox[{"a", ",", "b"}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "-", "b"}], "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{553, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578355561]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 " in the complex plane: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"BetaRegularized", "[", 
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", 
      RowBox[{"-", "1.5"}], ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydfAd4Fde17rnnqNBsiB0HJ3YS5yb3OrmJHcfJy30vuSnPKTf2ewMYGzCm
GgOm2AbTjOnVojfRhPo56l1CAiEhiiQQQhJCvSAhJIHoiCqK9H/v7bX2ntEw
51AcfaM5s/fs2eVfa/9r7TKjfTRr0oTPPpo1+eOPXvnvGR9NnzT545mv/H3a
DBHl+BebzZYh/te9aBPX/09c8X8GAHHDdJ4hzl7i1p84NJPODhHkkB47yxRL
l3/k2NmW2D88JpZKsXl1x5rLs4tQX/FLD9ktT9O9VznlSssdh1uO/84/i1R7
HE+Z/mnz/UrVtNdTpv9Ategl9SsTSmB7PmUewy3pXlR1sKs29lBhH/X7qsen
XlA18KKAt4yfMGGCkvD/9PjM86aSzPGch+NJT/dTJfbmR2Rq+cB/ekz/rCrN
jFFvS0l0/7cGshR6RpXSj9tllKLSy7TjPaDfz5QzXVrb+GtOOk6V8h1Laqte
vcmpxyiJ9PeQN+XyG071JxV6Wf2+ZEntZcn7V/zUH92040VV2sv/5PPfUeVb
03/Xkp+35f4bj8jveVWfHz2mPiSEPqpchyXewMJD3t9Sz/ybJW8fS916uj3p
a0nx4iNKeFbV/tUnlOBQ6SQspgweUZIubWo13fy5B3Qp/mlr/n/g3kuseVqf
9HXL2xsm3bP9Q9XhDUs+PSz5+HjMx5ziexz9qspP13BzXa1lWFlQZzFf9Stz
/KkHLCj4a1O8yJNrTBV8jZ96RYWsGv6dR9RLckTQCYqj3PpYnvsPj3V5HiZm
NcX/XMV7U4amFve2pPuZx1x1jX9TtcHXkksvdf/nHp9+VpX9K/VrD6anZcvo
7KPnplpvbelPDTmaOVbPzZdzk1lRRl6m3GwqvTk3aZF+Y9Ky7jqJC/FLlz50
8jJyFQfLiCyHKsfmVk+Z868sOXuHUM7B/ASdqb7MOFyCOT+zLKgw2e6+6GZW
uvlLQzdC+Ck6+4Y8XHu7KsNcLl+STZJp5A03dJjTlD3qrsl3LWV7h5bK+yGl
oKK5jV6qMvznzaUZNRIHScRLR9mkN+6l9/wGPeU1A42wUoTy0V078SsqaLPT
ycuoGklbBAwJG9Uj1HQfgX713m+1r4YNtj1nufOcBSeqFJchfuXhZaqbfukI
0dE8wWhS7RzutdPFaSrP2nvZb3iIE73cYl7wWPN+HrD9hWqFV3gpuCUOoyU2
uzjZRQO4/uLXK0S1NIQxFwe1QnYj/U+2w/sJOvD0bejrFq/77K/rvTpclSVa
EE6aQScvqr/eELPu2JRm293awnnpUgouZV22tqOnLvOnrr+Oue5r6rX2plpz
VfWKO6lC4SelVoY9rEHeSgo+ev2oi5OExMmqL4y1txFWvdtthPOI+n5f1c/o
c16hRYxkCUSN7c4T8HKqOohf50mRkzhJrRKVp9ZQnDh5hYkLh5QDtUHXJFYl
Fcft8ZbtkVLgVklWK9X5q49bXZ+2Nd+ztMYeXEiFHodoVFgx17YEok0Ol6ib
U9bPmxrlkA2htlCz7KItXmZOVKzjzfLotkOkP1Rxqzz0MY151CTZRR9bmfsk
2Wf2+HrvzGdmPwZR7xBx6BUP57o7SfAuUhvXye4e6KCAw1UG8avLR8pLtodl
Q4Il+XiFntQZVQqGWiDrI1slaVXEWVpl9tQo+b/yrz7moxZ4cws27MfmA/A/
hO252JmHXUfYnBUitBBhxxFWRPURjXE4S+iGS2fLCFXniDKIw2YXJ2qSbEeZ
4b17hat0oi1S3brbJKXEqagpuiV7RHusDPVDbs/jrIOXkhL5fD2pQs8tSsbS
NKxIx6o9VPqGbGzKgf9BbDvc3fTQY9TucHEUwVkM0WzZyyJLEXlSHY5I1dJI
2XoHtZ5aLBBwUOu9wsugtFPK0aEEZteZzSI9qmdv1ZZXuGXeT8FgRqvVcJj8
zr5U2/4TwvBJOCY7MdWFzyIwPZKSz43HgiQsTsGyNHydjtV7KXJjNjbnYOsh
7MjFrnwEHeVOVwjncZm1zSuiBJHcz6NEO6LLYI8S/wYC5RCHZAQvcRXBB2u5
wsIRXqazjo6CUGRGhs4OD4iw9EIeL/8ffCOUjB5jys2X4nwnxeGTWEyMppQf
R2CcC2OdogZjwsTQRUSNCQEdwRgThLHBlGh8CCaGYVI4pjjxqQvTGNqv4rEw
CUtSsGI3/DIoZv0+bMqG/wFsO4SduQjMl3rU01WEiGJEMqZRpYhmIGLKEUso
xlbAHlMh2hldofOFPUrc8I2qgEQ6UsfXRekFxnZnmaFdktElsDq2DKRBgL5P
QPX730z3umNECb46Kz4/ew9mZmDGbkxPxecplHpqIibH45M4TIzB+CiKkUAL
mEeHYnQIxYwW8NpHBwkHbnQgxgSyQIIxIQSfhGJyGKaGU8ysaMyNw8JELE3B
yt1YxVhvyMLm/RJf36AjCC2gyMhiRJUg6gSiSaNiCI5Y1sQ4ga09vlKm946t
pDhxjqkEoW4XUNtJpb0kzuIsoLbrmksNpM7N/duMt854Ni9peiTkPZ6A98tP
jbdunVibuQ8pYtfL/e6iHCzYj3lZ+Gof3SAhpOOL3ZgmhJBMMVMSMCmetH1C
tBICSSCcJDAqBKNYu0cGYaSA3j5yl3BsR+9iSQVhfDAmhmBSKKaEUczMKMyN
xYIE6RrYem7Zj20HEZCL4HyEM/jRxYg9gVhCPo4wiitDfDniKxSn9EqsQoJ+
xFeZJMBCIBkINtH7gBABt9hbqLtTP7jd4WXS/OvWhfARsmC9N/GJt7KZOsM+
PXfoqOszq7bnVh3B13l0a9khLDkIA/S5ZtDTCPTPGPTJAvQ49Kdn+30ZgwXx
WJKElWlYzZrrvx87DiIwFyH5cBYg8jhFxpci4SQSRd9OLFceWXIVkquRXCPw
TKoWfJBYbUKuChI8pX8CvAn6n52wI/11dtvmcHXpsLCFXZzsFuQeGhk9Qodf
esgSP2SRnzNSSTg3FGJ9IdYWYM1RPAbIHtSOVwVbTIjBx1EYF8H0EI5RoRgR
jA8DMZzZYXgAhu/E8B0Yvh0fbuc0OzE2AON2YXwgJrM+z4jAl9FYEIelAvVU
itmche05CDqMsHxEFCD6OOLYWUsuQ4puyfqkViK1CqnVdGN3LdJqkVqLlBqS
AEFfjfhqg3VtPkJro1hZhcpGVEBhbvNylpu8PgG7gXiYzs/sDX0DfpZzX8+b
MSYzJkBdd4xwXS1xFV6pD2X3C6mVs0xk/GkSxUzSsf0oAmOc3PFD8WEwPgjE
sAAM3UkxQ7dj6DYM3Yqh/hQctgXD/TFiK0Zvw8cBFPN5GGa6MDcKC2KxLBGr
0lijs7HzAEJyEXEUMccRXyw1uM/uSqRX8VGDjFrsqaPEGfVIr0NaHaNb282y
DqHTMVVSpwW4Qqcru+GVXonAVrIA2T9P2NoUGShsrcj29KSvJn9Zn6HtRtvL
8CPWFjzEvK8vP0xhpcTZ+CoLX2YyT2Yo/v00GVMSKWZiLMZHY1wkxrowig3a
8CACfWgAhuzA+9so5j1/vLcF723G4E0c3ID3N+CDTRi1FR/vYNxDMNOJuZFY
FIcVyVi7myK370fQIYV1Mrtr6RXYU4W91cisRWYd9tUj6xSyGujW3lPdWPsK
4MV1Yg2pdVw1JPSMO+fWQ2q0iw8r6nbl23oz5O6Ma52dcx8HWmemexrc/Cip
WGekvHWmMZR/ZR5W5GIZS2XxQSzMwfxssopfssc7Ix3T01RXeJYy7TtoEwZt
xMANGLieEgxai8HrMGwjRvljHPPKZ8GYGY75UViWIKtvezY8D9EFSCiCAHs3
Q5JZjX01yKrD/nrkNOBAI3IaoaPca88ppJ/C7nqk1SOlTiEeX0OIC7hZj4hH
pJY/zCPekkek3dPZ227Rdy8+GRKwzpeY+eSJcw/WOXwpE3fraJUdtYLHnb3E
hRCFH0tjRR5EBxEsT9I4QNJgbnr+sxRMTSKPRHQKEf4oEmNEpwjDh+wNih7x
/g68uxWD/DFwM8UM2IAB6zBgjXBMWGorE7GOVT9gP0IPIfIIEo4j9QTSy5DJ
QGbXYH8dcupxsEEpJw0Ds08jqxGZjdjbgAwhkVO6RKhpdlJ93+gqKFFUdovC
5pnTzXLQB7fmGQefR/CO+wyV557wCNQfijGk6qer//JcpaffNYzqnL3klIso
xUcJkAZWxIyNIDIaEYoPgihIuG/DwC0YuJEQFzHaGmirBAKaH2wvkChWYfAa
DFuPkUxRkwPwRQjmurAkBn5J2MhSCTmAyDwkHENaCfaUYV8FsthdkeD0zm9C
3hkcPoODTRSb0wQhGJJKIzIaSCqKwRNrqZfEVkPKxsddNjKd0Ud48C2cmzIW
h+opaqZMtwbC5Frl0ssNVWuv0MeRfb5Bb6BcWQ4OwUZL2dGRNuNFIRdpJ4TL
KBiJaJ37g/AXRX/4mMejo50YGYbhwRjKjjgJxR8DNulC+RraCti15ZL9xPWA
lXjPDx+swQjmsakBmBmC+S4si8EaNvtB2XAdRvxRpBUjU6DCkhDxRxpR0ISC
MzjSjPxm5DUjt5nSHziD7CYlid7UU05RbFIdDKnEMH0JoZCFliMwIRKXyV6Y
peIdVtbde6y9hS6tnrr7mqqVm3o/QhqeLIiRvo8IL2cLIWUijMSiA/TUfJbK
nEwIl+l50gFtCWz9tMWM9xIMXIr3VmCoHz5kCXwegNkhWOjCylhs5HFueA5i
8ni0wrXvlV9PsYVNKGrG8WYUtuBYCwpacbQV+a2yhb2zz2BfE/aeRkYj0hu6
MTYAlj2ZfCBFRhXKpy938+mtem/F15M/b9Zbm617zKOvtz4OYatt19cGmY3M
CEt/9LlZ7BGJK+kRCQYaH4OPeApFaXog3mPvc8BmCMLX1hLx8LO9tAUYuAiD
WQQiPGEzpu3E3BAsjcTaBNZliXleJY7WoLAeRWx+T7agtBUlZ1F8FkXnJOY9
88+yejfDDP7uBqScUmj7KK2Wis1G2U5c8wgbUPaNbIDVq5dz4d4W3K3884zO
JS9LdRWGlDQ2u5vcFbQmEhnLQ6cPQzEsCEMCMJgdzAEboa2DthraStbrhdDm
CR6ZyzNiBo79o3OQkod9x5FXjqJanDiFstOUvuosqttQ2YaK8xQsu4CSCzjO
13lncbAVWc3IbCJA0xqUVvaIk7pswjSSYSVMbb6uim48H2YMK7IWHg856cbj
un2Vs/f6mjn9sgoKbTTQExQsR8wCQMnCwi8karD1UfgIhl3KEM2D9iW02dBm
cXAWBVnAfT/ZiDkBWOHE5ngEMf4ph7DvGPJKUVKDilOobkJdK8U3nFfc36P+
EmouofISTl5C8UUG7hwOtKoZwpQGJNYjgX1EgZsggG5FtEcqr9zhqtD51eCB
cMUD4iRtjnQN9bG94Z8rnrWudEvEiC8dHrRP97wdZjQN6lwgXOz9sp/2/pTn
PT6JV117NA8vhf69vwuDt5NbIbnAoc2BNhPaNFWxfhJVcWe0Hz7fjAW7sMaF
nYmI5Mn6rCPIL8GJSlSfQn0TGluk7Hq0XkbLFTRfxemrqL+K6qs4eQXFlxS3
7m/B3jNIPw0BatKpblxja3RE1ew+ayNZLsmtDhOmzIk2Sa1uo3cfA1M6Sgmq
J82XPN/Npxbv4hGz+yqGVot5vq3/fB5jiivhPsza0z3GFDET42iAKR06ERwa
RHQ6SDgO7KgJ/01bBmHOtPkK9Ve1KXxjCrRPoU0niRC3rsKsLVgehM1RCGXD
ti8X+UU4UY6aOjQyDbSewwXW3UvtuNiOc+04cx2n2lF1jSKPX6Lz/lbsbcZu
hj+ZJRBfB4G9HMGQLlP/p1a7GHpl1eiup95v8Goow+3Gqz2Ufn77GyBsV+lZ
X74jWUHga8zoCWaVRku6ZzYewwtmHROBkQzxkEAMFhBvJW/Zps8SS0XWpj7Q
PnnAOT+jTYA2iUAWgeGLMHkV5vljbTgC4hHD7l/uURSf0BmirQWX2tDOIF6/
jvabuHwT528qna9sR9Fl5F9gwbQgvQkpjQSu7PWuSkRUkpPA7Gp3qUlXxRaM
vAfGYKy9DKwJSQtneGJaq37+M3r9gs4mBvJiqD43E88oNLmH+mhfKd3UPrmv
jb2rjbnP8S9rk5kyFuPz1Vi8DVtciOCOcCiXztXlaKnHpWa0n8PNi7h1lSLv
3MLN23Rx4Raab6L+BkqvoeASchnQ1CblecbUIqoaAk2nNE/ehORDtt/HgqPd
0FnRJKWz3hYUHWpkbp0Z0bnVE+86vqE+99eZorech7LJSQ+ekpbzUIKax0lq
5pl13/cDMGg7BmyBtoExXg7hFUhu9NbG3ddG3KHYYXe0UQ+kf+SYuUbHQepk
SQHqT+JcLa424fZZdFzAvSt4cF3NbNy5g/YOXOxA0y1UtaPwippbSmhATB0i
q+GsRGg5wsoRzvjawyULdPu4UnsZfh+ZRoIu/nj2zwM3mzwwT36vvkvaOm5z
x9X+T2p2f51XegkuEaIQXDJ7L7kaJBBJ2uyryXGYYOwPQ8gBFncFY2ubyUuz
8biD/I9ZSh7f1obcpNiB17Xh90geNtuIGZRu4QZsCUJUHF0X5+JUCdqq0N6A
e614cB5dl4F2WZt+nXdx9y7a7+LcLdTc5OH3BaS1IJGH4uFVCKtESDmCTiK4
DCFlyuMQMCspOCxSkWEpCT2pVSK8umDTCVL2Bbs4Wdd5razyZNSldHTdN8/n
GvtZqTPMkfjvITq36bOffaSGL4LwfjVGUXCL1Oj+2tuXtXeuakM6tBH3RHjU
DMxYhrVbEeZCBtvEugK0luJKNe43obMNXWwNcb1LnLs60HUPt+8pPvctuo79
F5FwBqE1CGA62XlSjTS8g6UxE0hJFqHpPn5TwQO7EKp8z8IqT4Pkk998kEjq
O6L0vY5cDCE4nRcS5VKu6vVjXWqGYgjPUAz0hyYGF2ukxvxI+7yTEB1xS3v3
Gl38pU37+2Vt8G1xPfiTrolzsHAVdgQghef/anLRXIj2Cjw4hU52mHGpC9c6
cZNUvOsuwXrtHpruoKgdya1dYXVdm092qfXEjYXwL8K2IuwoRkAJbeUMlhtM
BAkLTg6XOuzLFGIgKg5mSZOf7DDPorJcKIW+Q8g64n0cgtYVMkbxO2KQNjOd
FmO+4MUSouQkmoqj9Rie8pGAfiC8ZV5iEd4yAbqaNXMBkYD0U7Qh7do7FyS3
aX+5qA28JS5GTu2aPh9r1iEyGIfYVTl7FDdL8aCG0TzXiQsPcPkurt3GjQ7Z
F2/cvV93835U4wMpz2cG+N38MAafpuELnipccQgbC+BfiB1F2FWCQLnXtVT3
mrsZQdlC73CTdSSd9dJZwAO+8o8018rMVs31NBPnCXc73G0ol2HrHru8qGSh
z1bYvKQ0xCGk8azkAz990CfGJ5MVNt/W/tqq/dcZuvEWIT989N0Jn3ctXoJA
f+zlGYyWQ7jFC7j367tw5h7OCpftGi5extVr0hov+n3k6reTp/8tSwQG+WF4
KImeYD6ADUew5ZhiBFq+FirJ+OkaK3F26uvBhgU0WEFybZlcC7DZnsizvias
3NbB3LjCR2dR6H9URH+FpXwjwrTLjk7PTmOSFIzxqdz8wUtfImaMEyN5QuI9
qeKbld+qfSE85AfG8y9ov62T2Q0acGPk2Luz53T5r0VyMD1zOhM3eaPSnfIH
qL+JpotoOYe2c1TBy6dx/cLZ1iKZi/fyP7mCh6WsePcACe5/N8qxZ4/NR7Gt
EAHFagejRNtZxqMPHv/ZdP51R5pHJ6zMIcbqIl3qO/OYLUR832+A5LcVkjxW
7C8znc67CMSw4zMGUhDF1AQCcuKjgRTeG83Ti5Z+pc8Han9tofCbVQqPIYNv
TZjUtWpJV/Q25EYoHn/l6pGujpLbqLxCcxWnG9Bcy4xRfa+18HRDbsCWJSK4
+i1n2oTUHaMPz3mvibKcePe95RgVhM/jqcRVB7ExH/4F2HEcgSW8jc/Atfzh
OXp9Scs8AiGpe+IKkxbz+oxFi71Mvdm8v6vPo7F3e0OJZEW7f20vyrIM0OUG
DjHomxIPY8F8rHCbXQ/hPsDfjHuXNq1Tcqv2hwbt9VLtl+Vqv+zwDzvmfnHf
0O/vn8/sunaw417BNZxoQ0Uj6irRcIIqd6b0fiOp686Ni8R5w9/Djs5Mi5+a
v2MKSXLQ2PuikNEbMTUCc7mC6w7B/yh2HkdwCW+r5L2jLncPjfGjuSELznZ9
YljpMrGFtwlnXpCnPeNPhbG+Sq77X32VhHjO6LuyiNmpmJWCGcn4IgnTmQE/
jcOUGEyKwgRm0rG81+PDQAzlBe+Bm6CtVxIjVp7epY27o1DVXivS3qjsRnXt
vHuJG+6XusjzuL7v+oPDF7qOnblfUo9Kxrbm0IOafQ/q9hC8axeI89Z3Qk4t
3X3wq2NpS86K4PyFnePmdY5djy9cWMDwbs7F9gLd4jlPwsU+bkQ5z12YR9d6
Hbr9tnLoNtBb4Wqdg9NxB/Qdu0+D7+NsY2+FN4+q/1OWNicVs1MwKxkzBN6J
Ot6xmBSNiWa8g2gfgmKS9d1MIv60j+9oA8nqaa8VivPgP7d+8P71BVNvhS3r
OBJAOn0l7drd7LaOw023C2pxgtKgLKOzPLWzMklc7/CbJ84BA4La1qTVbzhe
sq0tjSf5N+zAjK1qF5lvcBFCS2iXvUBY7b2jOQzaBuaQi30GwgJ1h8nfkCSi
T2AQNzPWD62GUxk9PSJsXe/Qwz0Vkvz24/cMJOekEJgzhfIykp/FYaoFyRBG
cqcJST+DG0hztQFtcoQx4M3a9//RNnPcjR1f3d6/6a6IuhB3+VbGuRvZp+/k
lhOGxzNRlNhVHNtxIvrC4Y3bl8+l9gwOvLoptT30+GnXuapY5QH3CE1HaA6C
8tTuR9cJuEoRKaxVpNJGM3403ell0yc8FZo8rmBuCC1TvrMctYW4+2zuu+h9
PGLb1+Rd0E3aeUcLyLaXaD5nWqfQK1aqHHF+9/cNE4Zc2jj95m4/GiGcjbh0
Lfns5YzGuznFVEx+GgricMwlrs8dXB+44kuq/7CAO9tTbjpzm6Ma1c6twgzk
ZiMnD5lFSC5GAm9bjyuj/bWxFbRRLq5K+j20mux4eGad2yMxkTrpkF2YQCHr
ZA/tZk6+zZzwkJZZUPHMmX099GFKxHv0vy3i56biS6FmyZiVhBmsZsLIfhqL
ydH4hNVsHO/aJIJkNRsk1exraWd/LFElYH9ZMeTvrcvGX4ldeKNgw1URczG2
5UpKzb3Mo1T64WTkxSA/nCDNWef0I0jjRu5EUNKdiOyzMdUieGlvhzifOoaq
MpRU40g19lcjiwcUu9U8riOpVl7Q5iFap48mZI2VM5aLXe+xJl7UfSk29HKw
9RBHMpTBcrbM1yOOXrbHzJeZ/H96kN+cp22Y89JghlfECBMkevGUaLI/Ivix
E2NCMSKIdsIRtltM5n1ulzA+UtN+oL1ePOh39bOGnQueceWA32UR1epqvhZf
RuVmpuNgAg5E4lCoCLZlrYtZM0dcpI3bgZD4e1G7r6VSsvs5NCy+UYnz9Whs
RNVpFDciv1HNGe2tRzofcn9Kci2tutt4TSi2Wu1oiOItFZE840sY200+q66h
Zq3l0UHIw3Nj8p02d7/KHW8ZrcP66N2y5id/qqdasBvz0/BVKr5FKX6ozevS
ZnRpE0i9tDfKJ77dtP7j1tT55MK3Bje0RxVRxntSkR2LLCcO7SJy3Ls2ef1s
cZE1eVtXaHRnbLy4fpDT2HmYnuqsR0czrrSiuVV5tT0LeTeDjff8GLt9UuqR
VKfsea9YXl8zltgMLAWUzgo1LpEEYBCjl0RSKqx5Rosg9HkCjr0Ni/M0M4nd
z9F7xlzjfhJDcTVHqG8ivojH57GYyuOBCS58FEb7uIfL7SLCL90kZzh+ov3y
2PD/ql34fr3zs4aiVWeoYwcXUIHpSdgbjT2hyAmgyPQ1GRsJ4cPTtnaFRSAu
ihDOKu8qaETFFUrfhju80ttyHvXnUd6GorM4wrM1+5uw7zRt35HjjBTe+ZBY
h4RaxNG+ZdrI4DBgVnPLAmSnPudLZ4diWenrn5QEoFT16bB1exPIDVvrc/wO
98vixpIMLE7HQtZTEZwrKELQbwKmxeFT3ic1MQJEvCFEvCI4eBsGGJO0C/n8
erb2q7K5WnX4pLrCFQ1yXz6S05Eaj7QIpAVj304RdSV19f4ts8RF4Wz/rnAn
4smodR48jqIqVLdRXXkq8eYVXLxCq5unLqPiIorPq5F9zz1yu4JcYLfZEuoQ
VwupyiqFVGGpxQbAYeXQXX/9DZwQNYyVb1t167HU/KBSvbf/s1jzngbxGL+T
TtsLlu2BgHkRwyyCpMo8B9tjAG9Zou02ZLaOznm7PHR81bEldXK3FJJSkRyD
pHAkBWLPDhF1LWn1EX9yh8rmb+kKD0M8WbGuI4dRVILaMzh7g6rR3nX/Bm7e
wOUbaGmn5WFuu2/eWeS0YN8Z7G1CeiNSG5Bcr8aX0bS7XqhoJGupwQT6NIzN
h6ZY5KFP2zp0PbXJIRTbOxH0Cip1R8cNwye9gWC1fPTmHs9h9BGGTFgxYcIk
B4ioSZEY71QcIIJDdqj5zaFvFoeMLT8yT80BvILEZCRFITYUKVuxe5uIuh6/
qsR/vrioXba5yxmCBDJbOJqF4gLU1dP1ZZphxG3cu432W2i7QQXQYvtlFLGy
HmxFdjMyzyDjtOTNHoZOCkzNiLJNkp1dqiV5V2yjuv0AL4WhrpMEpcRTvqVv
sKY7nqb3YvQ5LavfzzaJ3NCv92FFJpbtxdI9WMwznsJKfZWCOUmYyf1exEyO
wkQXxoWpt5SG7cR72zBok7Ix/Qe/kR808sShmSdFoG1TFhISkBCByCAkb0Lq
FurFsX7VW2kgf2bVpi5nEGnpoVgcTUPJYdRXUFuuXJd59XrQgVsdVEjzLdRf
R8VV2shwhPk2R+0W6yl6Pe1lMDYy1CKmhhGu1nu2S1dajyhLjQg+SRPk+hvK
ug8rAA6SIyXP2L7gCUfqvn77sDITy/dCdm8RI7r3POFl6TaKNfblDwLw/nba
0Ku9FinCY35NXuipxXkEQkIc4pwI24X4jSJ4N2Pp7eiVp7cuEdcXNmyAi+x/
56FIHI1HaRbqeYB57RJu35V25FIHWm/j1A1UXkPJZYWE774W7DlD2w9SeXk8
oZ62H0jdIm30imAHVYJlxor+5LqlACxEV8pg+TanTo+GA8XfuvAO1PUScsaE
d8HJryWI4M90pvTLglA63ohs8yLDIrzOSAjLLeWivbZblS/fNkLQDsRsIEDS
lnRErTi7czF11m3rEUEc+OCQs+toFE6mU8nn63DtHO7c6bx7T87lX7qLltu0
ul3OOzKOXsTh88jhjW+ESpNCRWmNVCTSIgMbF8Pj1HfYSuZjbMSvYj3jvWbp
jwbp1lpc2AUuXoEnLG8JSk/yRYsm6d8VsX1LqpLslSIsDPKCNNUlRXB6HD6L
geySpEGhGBkke6LPygSpC8/fT1l8L2L5xcCFBFvgOkRuFRf3DoZ2FkR0ladS
XS5U4vr5rg5itOv3cfEeZXXqturR3oVXcOQSY3UO+1oV7/eQ+hPHnY56HGMl
kFI+YgXZWNIew0c09IbH1cGER6n89odN/6CJDo7VMvAssNtXl/jLJjQ6XJ0N
qUYruM/Z2HMxOpwIGk7hJB4sCoMwmg1CD4ER7xXuTFz8wLX0WggxPsLWIHIz
YXUw8H6Bk+6eyeu8VINbF2204tbVdg/Nd9U6/onrOH4NRy8j9yIOnsf+c1I3
fFJP0/6eRB2j2DrpwZEGeTv1HRQmhCS/n+x+yzuYqUe6HA/NNVjnFSQ23/OE
DXWhNdlYlUXwrBS9jFZzeoo2y/Wb206ahEL414iiHtVxcOe9gjBx0d5y/PYV
snEXO+6e6UDdHarriRsouk4X+aKtl5TfkNGC9Gak8Sp5ciM3V98v2iOyGhFV
vFuEmxteoTwuuXc3pAyGSlC7SR9kj4fx0TWrpZctfUkxCHEt59Xna+4h4koY
rUWye/CAYGYipsfjs1gayfK+Xb3l/eBajuh14urOga2dx6nNl8/R+Kr2+q3i
9q5C2c5ryL2KA5eRdUHK2jfzHDJakXoGyU1IOo2ERsTr+zl7CgHH1HIn4KkA
1XLZbOVflis/SfjxZdLJJDHTGD9YfavB0l7Pkv6+JZbH8f3E42v3Q3SEVdm6
sNm3FEZ8AXcEESTLozvvvC6j4/EsIhYjZrW4un1g873isOq6/JLWpuxzt5Na
aJE5rgXx4mhGkrS59sRmKeTEJsQ3Iq5R7V2J4RFOdC2iahFZg4hquKrgVIzg
E1ZByi7ticTCjAOzqE3/amB366yYSAx+4AkD8qbX5mANw+DH2wEJhl56P6cL
8UuXQuujFiD2a3Fx8wDpfmXDETlynXHgIf72Dq5FWD3C+XDV67KMrEdkHSLq
aEeZmutxidbqHod3OBsKanGF6uHlrN19LfW2jiJk637ooXVyJ6nQ9OWZUGq+
2zTo1X0zmxc1z9E2brxqKYfpYcSsFOcbB0jrte1KJtP2Ye4h1eD1J7BFzT/5
hrASh1aDjiqEiKNS79fhVRDNE0dYJTVPtjNU9uvnnyA9+QbPK56kR5Mg6w9g
nS5AEfw6S5m9xRlqdPQlj0Blv7aZe7SjI2+DklsvbsH6Emw5ia1l2FaG7axz
O8v1NYugCgTzQToXKvzv0ApjJfxx0pG1/5HiH2ZYejF3w0GIikvNE0G/bOp9
PVXtWCvvH9s+hO3NsDB84MRwl/5m8oQUTEnHtEzMVjuvHSuNNymlhHaUYWcZ
AsqwqxyB5QiSemT9nqHVO5U1/bEl9idQPtcmKXP5rvpK1qklrFM2HoB+aUyz
8lhBtKIfp1yajxVH4FeANYVYX4RN/JbwtlJsVw6g9auGVisua/UTT7Ui6W85
jM2HsfEQBKDruBuuYiiVxmfoteOJypmqdtyz6cWUUeG0/XREGEbwJtRRERgT
hbEx+Ij7xaRkTE3DtAzMzMRcFtPiXCzLk9ssrV9M9FxvayquNymbfy625HLV
TfWWPZVeJfIWNaQK/oI7hPE8pFcsxxH/rnTq33QJbc2DyJZrRylIUn9mlTSe
Fxfy2Z9a6vWveljp0TDT/e4Sf2Z5yiq7YW6lSW76D0s6a1/+wFKafOrnqn3W
1MNVvEz1muXu9x+b+nXLXWuf4O/KGql/ablr/aLoEJVajlLeUCVZU70rTgQK
72eSXzQ13bXyh6ZSy93Xv7bctX4B9W2VWn7D8jeWu9avq/5NpZbfy/gflrvW
celbqnWMP3/x1a6viJpS/VHlybwhv1hruvucJfw7lVp+X/B/We5+yxL+rUot
v8X4O8td65dm31SpWWq236v6WlO9rlLJ79D+wXL3GUv45woD+WXdP1ru9rGE
X1V5c03lN5ito39T+Mcqtfze859Vfa2pfqhSvcWp3rLcta52v6RS/51T/8Vy
1+ob67u43uHUf7XctdrhF1TeGqf+m6qvNdW3VKp3OdV/W+5aWfIZlXoIp/4H
HsV2lIa/a8wa/zDH+Kr7o/j+O6pN+p6Wjzj2/4ozZTyeQ7Z/+f+EpNQ1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->731081535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"BetaRegularized", "[", 
     RowBox[{"2", ",", 
      RowBox[{"ax", "+", 
       RowBox[{"I", " ", "ay"}]}], ",", " ", "I"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ax", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ay", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209124304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Distribution of average distance ",
 Cell[BoxData["s"], "InlineFormula"],
 " of all pairs of points in a ",
 Cell[BoxData["d"], "InlineFormula"],
 "\[Hyphen]dimensional hypersphere:"
}], "ExampleText",
 CellID->415407570],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"d_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"d", " ", 
   RowBox[{"s", "^", 
    RowBox[{"(", 
     RowBox[{"d", "-", "1"}], ")"}]}], " ", 
   RowBox[{"BetaRegularized", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "/", "4"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", "1"}], ")"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52358197],

Cell["\<\
Low\[Hyphen]dimensional distributions can be expressed in elementary \
functions:\
\>", "ExampleText",
 CellID->85007122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"FunctionExpand", "[", 
       RowBox[{"p", "[", 
        RowBox[{"d", ",", "s"}], "]"}], "]"}], ",", 
      RowBox[{"s", ">", "0"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->601287903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["s", "2"]}], ",", 
   FractionBox[
    RowBox[{"s", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "s"}], " ", 
        SqrtBox[
         RowBox[{"4", "-", 
          SuperscriptBox["s", "2"]}]]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"ArcCsc", "[", 
         FractionBox["2", 
          SqrtBox[
           RowBox[{"4", "-", 
            SuperscriptBox["s", "2"]}]]], "]"}]}]}], ")"}]}], "\[Pi]"], ",", 
   RowBox[{
    FractionBox["3", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "s"}], ")"}], "2"], " ", 
    SuperscriptBox["s", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", "s"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{421, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101163122]
}, Open  ]],

Cell["Plot distributions:", "ExampleText",
 CellID->330206390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"d", ",", "s"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "6"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481223486],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->76341018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["CDF of the Student t distribution:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"r_", ",", "t_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{"StudentTDistribution", "[", "t", "]"}], "]"}], "[", "r", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"BetaRegularized", "[", 
      RowBox[{
       FractionBox["t", 
        RowBox[{
         SuperscriptBox["r", "2"], "+", "t"}]], ",", "1", ",", 
       FractionBox["t", "2"], ",", 
       FractionBox["1", "2"]}], "]"}], " ", 
     RowBox[{"Sign", "[", "r", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{322, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92322647]
}, Open  ]],

Cell["Plot the CDF for various parameters:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"r", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "1", ",", "6"}], "}"}]}], "]"}], "]"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->459215868]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express through ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Beta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Beta"]], "InlineFormula"],
 " functions:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"BetaRegularized", "[", 
   RowBox[{"z", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"a", "+", "b"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}]]], "Output",
 ImageSize->{173, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233098426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"BetaRegularized", "[", 
      RowBox[{"z", ",", " ", "2", ",", " ", "3"}], "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"BetaRegularized", "[", 
       RowBox[{"2", ",", 
        RowBox[{"z", "+", "2"}], ",", "3"}], "]"}]}], "+", "z"}], "\[Equal]", 
    "6"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"-", "0.9637362682941374`"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482871811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Compose with the inverse function:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"InverseBetaRegularized", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", "a", ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"InverseBetaRegularized", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], ",", "a", ",", "b"}], 
  "]"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220996090]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multi-valuedness ambiguity:"
}], "ExampleText",
 CellID->901520282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->461140045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"10", "^", "20."}], ",", 
   RowBox[{"10", "^", "30."}], ",", 
   RowBox[{"10.", "^", "20."}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->500477987],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->137718245],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->43984505],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(General :: \\\"ovfl\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->422081217],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107577511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine\[Hyphen]number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{
   RowBox[{"10.", "^", "1"}], ",", " ", 
   RowBox[{"10.", "^", "3"}], ",", " ", 
   RowBox[{"10.", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  "3.439405166119301066164261139833569`15.954589770191278*^1237"}]], "Output",\

 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93911996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52419483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Regularized beta functions are typically not generated by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"BetaRegularized", "[", 
   RowBox[{"z", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"a", "+", "b"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}]]], "Output",
 ImageSize->{173, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215932574]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"z", ",", "a", ",", "b"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"a", "+", "b"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", "a", "]"}], " ", 
   RowBox[{"Gamma", "[", "b", "]"}]}]]], "Output",
 ImageSize->{173, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622345022]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28125],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->690]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28433],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->13260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2725],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/RegularizedBetaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/BetaRegularized/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->173797838],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->181452065],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->13598132]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BetaRegularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 0.7861020}", "context" -> "System`", 
    "keywords" -> {"beta function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BetaRegularized[z, a, b] gives the regularized incomplete beta function \
I_z (a, b). ", "synonyms" -> {"beta regularized"}, "title" -> 
    "BetaRegularized", "type" -> "Symbol", "uri" -> "ref/BetaRegularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6853, 238, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13002806]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115350, 2899}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2083, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2706, 78, 52, 1, 70, "ObjectName",
 CellID->1925],
Cell[2761, 81, 765, 24, 70, "Usage",
 CellID->27201]
}, Open  ]],
Cell[CellGroupData[{
Cell[3563, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4041, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4164, 133, 392, 14, 70, "Notes",
 CellID->15304],
Cell[4559, 149, 1142, 41, 70, "Notes",
 CellID->22378],
Cell[5704, 192, 394, 13, 70, "Notes",
 CellID->1391],
Cell[6101, 207, 262, 8, 70, "Notes",
 CellID->477251588],
Cell[6366, 217, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6601, 226, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6853, 238, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13002806],
Cell[CellGroupData[{
Cell[7237, 252, 148, 5, 70, "ExampleSection",
 CellID->879006606],
Cell[7388, 259, 44, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7457, 263, 128, 3, 28, "Input"],
Cell[7588, 268, 271, 7, 36, "Output",
 CellID->731200073]
}, Open  ]],
Cell[7874, 278, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[8004, 284, 493, 15, 28, "Input"],
Cell[8500, 301, 10273, 172, 165, "Output",
 Evaluatable->False,
 CellID->122508691]
}, Open  ]],
Cell[CellGroupData[{
Cell[18810, 478, 280, 9, 28, "Input",
 CellID->75236264],
Cell[19093, 489, 2303, 42, 131, "Output",
 Evaluatable->False,
 CellID->192621073]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21445, 537, 200, 6, 70, "ExampleSection"],
Cell[21648, 545, 73, 1, 70, "ExampleText",
 CellID->62550901],
Cell[CellGroupData[{
Cell[21746, 550, 263, 9, 70, "Input",
 CellID->14756986],
Cell[22012, 561, 270, 8, 36, "Output",
 CellID->250155121]
}, Open  ]],
Cell[22297, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->53279368],
Cell[22424, 577, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22499, 581, 241, 8, 70, "Input"],
Cell[22743, 591, 417, 12, 54, "Output",
 CellID->493863523]
}, Open  ]],
Cell[23175, 606, 105, 2, 70, "ExampleDelimiter"],
Cell[23283, 610, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23401, 616, 172, 4, 70, "Input"],
Cell[23576, 622, 358, 11, 36, "Output",
 CellID->490220661]
}, Open  ]],
Cell[23949, 636, 105, 2, 70, "ExampleDelimiter"],
Cell[24057, 640, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24122, 644, 242, 7, 70, "Input"],
Cell[24367, 653, 2764, 49, 70, "Output",
 Evaluatable->False,
 CellID->42657929]
}, Open  ]],
Cell[27146, 705, 105, 2, 70, "ExampleDelimiter"],
Cell[27254, 709, 183, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[27462, 719, 166, 5, 70, "Input"],
Cell[27631, 726, 370, 13, 50, "Output",
 CellID->226386202]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28050, 745, 223, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[28298, 755, 246, 6, 70, "ExampleSubsection"],
Cell[28547, 763, 86, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[28658, 769, 171, 5, 70, "Input"],
Cell[28832, 776, 467, 16, 39, "Output",
 CellID->168886562]
}, Open  ]],
Cell[CellGroupData[{
Cell[29336, 797, 220, 7, 70, "Input"],
Cell[29559, 806, 468, 18, 78, "Output",
 CellID->167119218]
}, Open  ]],
Cell[30042, 827, 105, 2, 70, "ExampleDelimiter"],
Cell[30150, 831, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30239, 835, 131, 3, 70, "Input"],
Cell[30373, 840, 185, 6, 36, "Output",
 CellID->181492082]
}, Open  ]],
Cell[30573, 849, 105, 2, 70, "ExampleDelimiter"],
Cell[30681, 853, 204, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30910, 863, 201, 6, 70, "Input"],
Cell[31114, 871, 698, 16, 36, "Output",
 CellID->96401248]
}, Open  ]],
Cell[31827, 890, 105, 2, 70, "ExampleDelimiter"],
Cell[31935, 894, 203, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[32163, 904, 239, 7, 70, "Input"],
Cell[32405, 913, 2554, 76, 116, "Output",
 CellID->439235]
}, Open  ]],
Cell[34974, 992, 105, 2, 70, "ExampleDelimiter"],
Cell[35082, 996, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35159, 1000, 249, 7, 70, "Input"],
Cell[35411, 1009, 2579, 76, 129, "Output",
 CellID->138692563]
}, Open  ]],
Cell[38005, 1088, 75, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[38105, 1092, 291, 9, 70, "Input"],
Cell[38399, 1103, 4792, 83, 70, "Output",
 Evaluatable->False,
 CellID->230300223]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43240, 1192, 249, 6, 70, "ExampleSubsection"],
Cell[43492, 1200, 86, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[43603, 1206, 270, 8, 70, "Input"],
Cell[43876, 1216, 1122, 40, 77, "Output",
 CellID->10081954]
}, Open  ]],
Cell[45013, 1259, 105, 2, 70, "ExampleDelimiter"],
Cell[45121, 1263, 58, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[45204, 1267, 261, 7, 70, "Input"],
Cell[45468, 1276, 2398, 43, 70, "Output",
 Evaluatable->False,
 CellID->96777902]
}, Open  ]],
Cell[CellGroupData[{
Cell[47903, 1324, 261, 7, 70, "Input"],
Cell[48167, 1333, 4031, 70, 70, "Output",
 Evaluatable->False,
 CellID->247551644]
}, Open  ]],
Cell[52213, 1406, 124, 3, 70, "ExampleDelimiter",
 CellID->42124962],
Cell[52340, 1411, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[52417, 1415, 262, 7, 70, "Input"],
Cell[52682, 1424, 3020, 86, 146, "Output",
 CellID->578355561]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[55763, 1517, 207, 6, 70, "ExampleSection"],
Cell[55973, 1525, 229, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[56227, 1536, 465, 15, 70, "Input"],
Cell[56695, 1553, 13933, 232, 70, "Output",
 Evaluatable->False,
 CellID->731081535]
}, Open  ]],
Cell[CellGroupData[{
Cell[70665, 1790, 449, 14, 70, "Input"],
Cell[71117, 1806, 13527, 226, 70, "Output",
 Evaluatable->False,
 CellID->209124304]
}, Open  ]],
Cell[84659, 2035, 105, 2, 70, "ExampleDelimiter"],
Cell[84767, 2039, 239, 7, 70, "ExampleText",
 CellID->415407570],
Cell[85009, 2048, 520, 18, 70, "Input",
 CellID->52358197],
Cell[85532, 2068, 131, 4, 70, "ExampleText",
 CellID->85007122],
Cell[CellGroupData[{
Cell[85688, 2076, 395, 13, 70, "Input",
 CellID->601287903],
Cell[86086, 2091, 925, 33, 75, "Output",
 CellID->101163122]
}, Open  ]],
Cell[87026, 2127, 62, 1, 70, "ExampleText",
 CellID->330206390],
Cell[CellGroupData[{
Cell[87113, 2132, 393, 13, 70, "Input",
 CellID->481223486],
Cell[87509, 2147, 7995, 135, 70, "Output",
 Evaluatable->False,
 CellID->76341018]
}, Open  ]],
Cell[95519, 2285, 105, 2, 70, "ExampleDelimiter"],
Cell[95627, 2289, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[95709, 2293, 238, 8, 70, "Input"],
Cell[95950, 2303, 537, 18, 52, "Output",
 CellID->92322647]
}, Open  ]],
Cell[96502, 2324, 59, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[96586, 2328, 388, 12, 70, "Input"],
Cell[96977, 2342, 6166, 105, 70, "Output",
 Evaluatable->False,
 CellID->459215868]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103192, 2453, 217, 6, 70, "ExampleSection"],
Cell[103412, 2461, 448, 17, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[103885, 2482, 166, 4, 70, "Input"],
Cell[104054, 2488, 416, 14, 53, "Output",
 CellID->233098426]
}, Open  ]],
Cell[104485, 2505, 105, 2, 70, "ExampleDelimiter"],
Cell[104593, 2509, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[104694, 2513, 463, 14, 70, "Input"],
Cell[105160, 2529, 247, 8, 36, "Output",
 CellID->482871811]
}, Open  ]],
Cell[105422, 2540, 105, 2, 70, "ExampleDelimiter"],
Cell[105530, 2544, 57, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[105612, 2548, 212, 6, 70, "Input"],
Cell[105827, 2556, 321, 10, 36, "Output",
 CellID->220996090]
}, Open  ]],
Cell[106163, 2569, 233, 8, 70, "ExampleText",
 CellID->901520282],
Cell[CellGroupData[{
Cell[106421, 2581, 87, 2, 70, "Input"],
Cell[106511, 2585, 158, 5, 36, "Output",
 CellID->461140045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106718, 2596, 210, 6, 70, "ExampleSection"],
Cell[106931, 2604, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[107056, 2610, 206, 6, 70, "Input"],
Cell[107265, 2618, 357, 7, 70, "Message",
 CellID->500477987],
Cell[107625, 2627, 357, 7, 70, "Message",
 CellID->137718245],
Cell[107985, 2636, 356, 7, 70, "Message",
 CellID->43984505],
Cell[108344, 2645, 420, 8, 70, "Message",
 CellID->422081217],
Cell[108767, 2655, 170, 5, 36, "Output",
 CellID->107577511]
}, Open  ]],
Cell[108952, 2663, 105, 2, 70, "ExampleDelimiter"],
Cell[109060, 2667, 101, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[109186, 2673, 212, 6, 70, "Input"],
Cell[109401, 2681, 239, 8, 36, "Output",
 CellID->93911996]
}, Open  ]],
Cell[CellGroupData[{
Cell[109677, 2694, 90, 2, 70, "Input"],
Cell[109770, 2698, 161, 5, 36, "Output",
 CellID->52419483]
}, Open  ]],
Cell[109946, 2706, 105, 2, 70, "ExampleDelimiter"],
Cell[110054, 2710, 229, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[110308, 2721, 166, 4, 70, "Input"],
Cell[110477, 2727, 416, 14, 53, "Output",
 CellID->215932574]
}, Open  ]],
Cell[CellGroupData[{
Cell[110930, 2746, 88, 2, 70, "Input"],
Cell[111021, 2750, 416, 14, 53, "Output",
 CellID->622345022]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111498, 2771, 311, 9, 70, "SeeAlsoSection",
 CellID->28125],
Cell[111812, 2782, 469, 17, 70, "SeeAlso",
 CellID->690]
}, Open  ]],
Cell[CellGroupData[{
Cell[112318, 2804, 314, 9, 70, "TutorialsSection",
 CellID->28433],
Cell[112635, 2815, 144, 3, 70, "Tutorials",
 CellID->13260]
}, Open  ]],
Cell[CellGroupData[{
Cell[112816, 2823, 320, 9, 70, "RelatedLinksSection",
 CellID->2725],
Cell[113139, 2834, 194, 4, 70, "RelatedLinks"],
Cell[113336, 2840, 200, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113573, 2849, 319, 9, 70, "MoreAboutSection",
 CellID->173797838],
Cell[113895, 2860, 165, 3, 70, "MoreAbout",
 CellID->181452065],
Cell[114063, 2865, 181, 3, 70, "MoreAbout",
 CellID->13598132]
}, Open  ]],
Cell[114259, 2871, 27, 0, 70, "History"],
Cell[114289, 2873, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

