(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     92204,       2540]
NotebookOptionsPosition[     83114,       2240]
NotebookOutlinePosition[     85008,       2285]
CellTagsIndexPosition[     84922,       2280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinLists" :> Documentation`HelpLookup["paclet:ref/BinLists"], 
          "Tally" :> Documentation`HelpLookup["paclet:ref/Tally"], "Count" :> 
          Documentation`HelpLookup["paclet:ref/Count"], "PDF" :> 
          Documentation`HelpLookup["paclet:ref/PDF"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BinLists\"\>", 2->"\<\"Tally\"\>", 
       3->"\<\"Count\"\>", 4->"\<\"PDF\"\>", 5->"\<\"Floor\"\>", 
       6->"\<\"Ceiling\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete & Integer Data\"\>", 
       4->"\<\"Handling Arrays of Data\"\>", 5->"\<\"List Manipulation\"\>", 
       6->"\<\"Math & Counting Operations on Lists\"\>", 
       7->"\<\"Numerical Data\"\>", 8->"\<\"Statistics\"\>", 
       9->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       10->"\<\"New in 6.0: List Manipulation\"\>", 
       11->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       12->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       13->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BinCounts", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinCounts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinCounts"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]counts the number of elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whose values lie in successive integer bins."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinCounts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinCounts"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]counts the number of elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " whose values lie in successive bins of width ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinCounts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinCounts"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]counts the number of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in successive bins of width ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinCounts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinCounts"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["b", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]counts the number of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in the intervals ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]]}], ")"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["b", "TI"], 
         StyleBox["3", "TR"]]}], ")"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinCounts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinCounts"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["xbins", "TI"], ",", 
        StyleBox["ybins", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an array of counts where the first index \
corresponds to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " bins, the second to ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", and so on. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " drops elements whose values do not correspond to real numbers."
}], "Notes",
 CellID->989418566],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 " takes the bin boundaries to be integer multiples of ",
 Cell[BoxData[
  StyleBox["dx", "TI"]], "InlineFormula"],
 ", with the first bin starting at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Min",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Min"], "[", 
      StyleBox["data", "TI"], "]"}], "-", 
     StyleBox["dx", "TI"]}], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 " and the last bin ending at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Max",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Max"], "[", 
      StyleBox["data", "TI"], "]"}], "+", 
     StyleBox["dx", "TI"]}], ",", 
    StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->82409304],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->210517892],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->126729676],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " at each end can be ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"+", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->497450453],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " do not form an increasing sequence, they are automatically sorted by ",
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->168774678],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", elements are counted in bin ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " when their values satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "i"], "\[LessEqual]", "x", "<", 
    SubscriptBox["b", 
     RowBox[{"i", "+", "1"}]]}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->94503541],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " consists of length-",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " sublists, then ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " bin specifications must be given, and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields an array of depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->553010305]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745551],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->122348688],

Cell["\<\
Count the number of elements in bins of width 1 from 0 to 10:\
\>", "ExampleText",
 CellID->18927180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38712768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99614887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->689178298],

Cell["Count the number of elements in a sequence of ranges:", "ExampleText",
 CellID->26246007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "Infinity"}], ",", "2", ",", "5", ",", "7", ",", 
      "Infinity"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107309661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "2", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51549383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194206092],

Cell["Count the number of elements in bins of a specified width:", \
"ExampleText",
 CellID->245743928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "1", ",", "4", ",", "5", ",", "6", ",", 
     "2"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235360212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10658643]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Count squares mod 3 and 5 in 2\[Hyphen]dimensional unit bins:\
\>", "ExampleText",
 CellID->422181288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "100"}], "}"}]}], "]"}], ",", "1", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92857074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "14", ",", "0", ",", "0", ",", "13"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "14", ",", "26", ",", "0", ",", "0", ",", "27"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{412, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324731095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385637151],

Cell["Count random pairs in bins of width 0.25 in both dimensions:", \
"ExampleText",
 CellID->254770907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", ".25"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", ".25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112655837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "15", ",", "14", ",", "26", ",", "13", ",", "15", ",", "7", ",", "11", 
     ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "14", ",", "11", ",", "15", ",", "16", ",", "21", ",", "15", ",", "7", 
     ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "16", ",", "10", ",", "19", ",", "16", ",", "18", ",", "10", ",", "15", 
     ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "19", ",", "18", ",", "12", ",", "22", ",", "15", ",", "16", ",", "15", 
     ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "11", ",", "18", ",", "24", ",", "13", ",", "13", ",", "17", ",", "20", 
     ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "19", ",", "15", ",", "19", ",", "8", ",", "11", ",", "17", ",", "19", 
     ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "16", ",", "17", ",", "20", ",", "22", ",", "19", ",", "19", 
     ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "20", ",", "15", ",", "8", ",", "20", ",", "24", ",", "14", ",", "13", 
     ",", "16"}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57300052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102656935],

Cell["Count multidimensional data in ranges:", "ExampleText",
 CellID->793572346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", ".3", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", ".4"}], ",", ".2", ",", "1"}], "}"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570033843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"189", ",", "172", ",", "274"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"125", ",", "96", ",", "144"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->821687699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105306913],

Cell["Count data in any dimension:", "ExampleText",
 CellID->96436699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->782641426],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm99vEzEMx6+9/mCMrRsCtMf9I/CCBE/8EdWEtD0g0Nj/X5r00qU+575x
7LtbWZFGm2tjO7aTu3zq/Fg/3f/8tX56uFvffn9c/7l/uPt7++334/ZSPamq
yeeqqr7eVNv3m+07/+f+fdn+7d7u3r13/9fh0001A+0r0v4Evv9W2R/J09p3
bmwfatfe69fCXu77023zhpHmrlOvpL7PWcP1l+qnXszVL21Pi7znrHTNWfM6
J5+fNdenic+pvDeMVfNts070XwL9yH6qLzW+urGDfr5orofxLYC8M6H/pPKH
ibrvNd+3vYwqcdX13efx7FnGzqctqUSr60l9VqJ9KeyDvMHZZeEl3k6aFdRz
oTdda4a1QJ+H9A6Bei3B5y7nFlVINX+5lWV0JBdAZs36x8+gzuxGHkN6+bjQ
mUs9QrVeCj34TihfmweTTcl6hFbFc9Z3ebN/BWTzUnA+cKudRC8dM5VH+zv9
M2Z8dM4hX9I8Tckd584UVrF587pqxaEs6vNDOc2Yrxot/JqAbEURDmOhEVmx
2lB+cWvrtHp+8rgukjpOlCU5Wj7TvZaD3PnYutL3rGb7iyxg53fLFx/UI3t5
T56xr8uzgO/F3leNni/L7jj81QuFXTRzhvdEWU5JuUvYW8UrYVjVa8ZKmrPx
3ta9XhJ5OQRCYt8KyKfjj/vPCuwr4zDuLSVi8neUfkhtOTG1Anuh1TkZ/RqY
2oE8tdcQC5KyrlKWlmJdqI1YWtCfYlmBdUn1pphandCjHSerXx39MahWv3St
xK/lXI0jVDrb8omaTLfds9DeQugz1PaWdj7/o6dSQ45G/R210ZqHtLLjjtqU
d6H9mJSn8Xt3tHKyUtQrTnt/K405Yk55MxfF3IKj0Mxzw2YZT0dGszvpFhPS
joZ9QlTHOqwWYeyBXM2j1y6fdvMv6a9uKGJeXt5OU7AipQgYvxKtNjx9kxJv
m/glWJRibmKJ1vPQfr0BM9JAwzDR7Z+sWFIt6eiOi2fZ683LIS3pkFIoCcXK
WeNLKVbYhdHc66JYcf9SiuXt9Q09pTpVetnal/MEd6r0kngr/NJXXuGFKqBS
VCmXSk2N5JdSKSsqpqnwsqBR7N11kAqvl02jjqXWS+av/iq++vvFbr/nKqv3
UtdASRkRV0mDGaCWTHXwMciPWCrVuS+i3Ivduyni7i1U13lk7WkF35dGvp/f
8/uhZPK9sTRDpe3d7ySlFV1sFRTxB3d/RZQvJ+Y5zx1ZTIuRGxga4kxd9Irj
joiGDRO9rHqmVq7TFRzNc1Zq/3VaA7MsKfEbJsJ6ikI9h2bwWNzmuDjWmHVZ
u0zS1mHFhGfGjChFsEoJ0VB1WKV1YllUxzf0RMv63n8iXiWxtD5d8VoI2GFd
lrUXrc8E0t2bdR0Y0pca3yIaJ6e/LyKmHR9/N+rlxFo2p9Gd6/u/qBi3Sx+q
UmtcEvZcr2V9moLumKh8VKeEWEBWXRNYU7o+zzr9GK+xVZseoloxORXTjor1
kvlKZHUSsGiXjWa/or98j23PxPqpF7HOgLC20Iz32sRn+rgxxycFr0hbS8Zi
+YfRCDVYSAM62yi1eJiooXkrP0PMzmD+rB9kbkWzNWGbk98/v85jiePEOu8Z
QkOFLCu8EJEruhN0jsC1+dFLyUL/PDIvg6wJSkyfps2aFto146cuOkZPAXJ0
DclL2bdo7EP1Y5L6rhz7WHt9I4d3VZN/v0cjTQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{317, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749162563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91707437],

Cell["Count binned data ignoring values that are not real:", "ExampleText",
 CellID->407025834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "3", ",", "a", ",", "2.5", ",", "1", ",", "I"}], 
    "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103395590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436612420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297373174],

Cell["Count binned data of any precision:", "ExampleText",
 CellID->25385746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.5", ",", "3", ",", 
     RowBox[{"N", "[", 
      RowBox[{"3", ",", "20"}], "]"}], ",", "2.5", ",", "1", ",", "E"}], 
    "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29800496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241664417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell[TextData[{
 "Count data in a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93310457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705020460],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239290855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108702580],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "6"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28943293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Visualize density of 2\[Hyphen]dimensional data in bins:\
\>", "ExampleText",
 CellID->286062020],

Cell[BoxData[
 RowBox[{
  RowBox[{"counts", "=", 
   RowBox[{"BinCounts", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "2"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->757980791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "counts", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->623751355],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{12, 13, 14, 12, 10, 14, 14, 11, 11, 10}, {8, 7, 13, 12, 15, 13, 
   10, 16, 7, 7}, {8, 9, 12, 8, 9, 10, 7, 8, 9, 8}, {10, 7, 7, 7, 10, 13, 8, 
   5, 12, 11}, {8, 8, 4, 16, 8, 5, 9, 6, 5, 7}, {11, 7, 11, 9, 5, 9, 12, 11, 
   13, 0}, {10, 12, 9, 16, 12, 12, 9, 7, 11, 14}, {10, 15, 12, 9, 12, 11, 7, 
   7, 7, 12}, {4, 6, 12, 9, 11, 8, 12, 5, 18, 11}, {11, 13, 9, 14, 12, 13, 14,
    9, 14, 10}}, {{0, 0}, {10, 10}}, {0, 20}],
  Frame->Automatic,
  FrameTicks->{None, None}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364825040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"counts", ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->170390343],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJy920Gq3dgZReFHQsBNN6rhhhuOeBRFEYqaQTyGDCGQdqaeIaTjY8h3WdkS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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwt1Hl8D2QcB/DfbGOXmd1jdrH7Pm2z2ULpkkyOLrGEkkn3IUQXnbovlUqp
FCW6k6NLpehAhS5ddNJBkffSH+8/vp/X54/n9Tzf15PZOrmlrUMgEBhCCEG0
z8H/z6F0pBNhhBNBJFFkkkVPetGZaLoQQwKJJJHMERzJURxNV2KJI54epJFO
BtnkkEsejfSliWbKqaCSKqqpoTe15FNAIUXM5wEe5CEOoR/9GcChHMZADqeO
evrQQArd6E4qgziGwRxLMSWUUsYYWjmVsZzMKE5hNOdxPhdwIRdxMZcwleM5
gRM5iSmczTmcy2mMYzwTmM0cruFaLmUa05nBrdzG7dzBMIYzgpFcwZVcxdVc
x/XcwI1cxkxmcTlzuYmbuYV53Mt93B84uFctDOU47uQu7uYeTucMJnJm+3tY
wH70ZwBdiSWOeJ7QeZLFLOEpnmYpz/Aar/MGb/IWa3mbd3iZV1jBq6xkFatZ
wzKW8yzP8Twv8CIv8S7reI/3+YIv+Yqv+YiP2cgmNvMJn/IZP/ITP/ML69nA
B3zIdr7hW77je35gBzvZwla28Tm/8hu72M3v/MGf/MUe9vI3/xDkDjsQTAih
dKQTYezT2c+/gcB/n0E4EUQSxaPix3icRSTIEkkimc5E04UYUuhGd1LpQRrp
ZJBJFj3pRT4FFFJEMSWUUkY2OeSSRzkVVFJFHfX0oYEFzvgwj7CQalkNvaml
kb400cwknTYmcxYHAL/tivk=
        "]]]}, {}, {}, {}, 
     {Opacity[0.5], EdgeForm[None], 
      GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwl1Hl8D2QcB/Df9tvmNmeEsMqtHFFSJJQOEhFR0iKSNhGd6ESJUiFKJVeF
CjmKVFSE3Dfb7DDHbGZ2Gdt67+WP9/M8r8/r+3q+zx/P80RFx/aOCQ0EAr0I
o5WhDbfQmvDwQKA0pYggXZbJeTL4LxgI7GYXOwlRE0aQUHLU5JNHLoUlTeTF
5iIucYXLFPA3W9nCP1wgm4tk8S872M424jhBAvGc5DSnSOUM50jjLEc4zjGO
lpyf3exiJwc4zCEOsof97GMvf/IXm9nEb/zB72zkPT5gKu+znJ/4kR/4jmUs
5XtW8DOrWMkivmUJi5nH13zFl8xnIQv4hucZRSwxrGYda1nDHL7gc+Yyk8+Y
zSzeZQqTmcQ0PuJDpvMm7/A2b/EKr/MarzKWl3mJcSSSQjJJzOBTPuFjxvMG
E5lAGXehPOUoywuyFxnDaJ5lJM8xgsd4nIEM4G660oXOPMFgnmQQfelPPx7l
frrzIA/Qiz48Qm968DA9eYjrqE896nIP99GNe+lAJ+6iI21px23cyu3cyR20
5ymG8DTRNKE5zWhKFDdyA9dzEy1pwc00oDGNaMgeb24/+9hLdVlNanANJ2Wn
OUUqZWTlKUdZwilNKSKoQCUiqUgIYQQJ5ZI9rnCZAgqDVz+OYnMR11rXoTa1
qEw1qlKFHDX55JHLBbK5SBaJpJBMEmc4RxpnieMECcRzgMMc4iBD9RjOMJ7h
Fzawnl9JV5PJeTI4wnGOcZQK7mAlIqnI/2OjtNI=
        "],
        VertexColors->None]]}, 
     {Opacity[0.5], EdgeForm[None], 
      GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwt13fc1eMbwPGn8xSJhIhEKZGRrEpJRFu7tPfee++9J+2l8bQ1pF1SGiql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        "],
        VertexColors->None]]}, {}, {}}, {Line3DBox[{2, 1, 4, 3, 2}], 
     Line3DBox[{6, 5, 8, 7, 6}], Line3DBox[{10, 9, 12, 11, 10}], 
     Line3DBox[{14, 13, 16, 15, 14}], Line3DBox[{18, 17, 20, 19, 18}], 
     Line3DBox[{22, 21, 24, 23, 22}], Line3DBox[{26, 25, 28, 27, 26}], 
     Line3DBox[{30, 29, 32, 31, 30}], Line3DBox[{34, 33, 36, 35, 34}], 
     Line3DBox[{38, 37, 40, 39, 38}], Line3DBox[{42, 41, 44, 43, 42}], 
     Line3DBox[{46, 45, 48, 47, 46}], Line3DBox[{50, 49, 52, 51, 50}], 
     Line3DBox[{54, 53, 56, 55, 54}], Line3DBox[{58, 57, 60, 59, 58}], 
     Line3DBox[{62, 61, 64, 63, 62}], Line3DBox[{66, 65, 68, 67, 66}], 
     Line3DBox[{70, 69, 72, 71, 70}], Line3DBox[{74, 73, 76, 75, 74}], 
     Line3DBox[{78, 77, 80, 79, 78}], Line3DBox[{82, 81, 84, 83, 82}], 
     Line3DBox[{86, 85, 88, 87, 86}], Line3DBox[{90, 89, 92, 91, 90}], 
     Line3DBox[{94, 93, 96, 95, 94}], Line3DBox[{98, 97, 100, 99, 98}], 
     Line3DBox[{102, 101, 104, 103, 102}], 
     Line3DBox[{106, 105, 108, 107, 106}], 
     Line3DBox[{110, 109, 112, 111, 110}], 
     Line3DBox[{114, 113, 116, 115, 114}], 
     Line3DBox[{118, 117, 120, 119, 118}], 
     Line3DBox[{122, 121, 124, 123, 122}], 
     Line3DBox[{126, 125, 128, 127, 126}], 
     Line3DBox[{130, 129, 132, 131, 130}], 
     Line3DBox[{134, 133, 136, 135, 134}], 
     Line3DBox[{138, 137, 140, 139, 138}], 
     Line3DBox[{142, 141, 144, 143, 142}], 
     Line3DBox[{146, 145, 148, 147, 146}], 
     Line3DBox[{150, 149, 152, 151, 150}], 
     Line3DBox[{154, 153, 156, 155, 154}], 
     Line3DBox[{158, 157, 160, 159, 158}], 
     Line3DBox[{162, 161, 164, 163, 162}], 
     Line3DBox[{166, 165, 168, 167, 166}], 
     Line3DBox[{170, 169, 172, 171, 170}], 
     Line3DBox[{174, 173, 176, 175, 174}], 
     Line3DBox[{178, 177, 180, 179, 178}], 
     Line3DBox[{182, 181, 184, 183, 182}], 
     Line3DBox[{186, 185, 188, 187, 186}], 
     Line3DBox[{190, 189, 192, 191, 190}], 
     Line3DBox[{194, 193, 196, 195, 194}], 
     Line3DBox[{198, 197, 200, 199, 198}], 
     Line3DBox[{202, 201, 204, 203, 202}], 
     Line3DBox[{206, 205, 208, 207, 206}], 
     Line3DBox[{210, 209, 212, 211, 210}], 
     Line3DBox[{214, 213, 216, 215, 214}], 
     Line3DBox[{218, 217, 220, 219, 218}], 
     Line3DBox[{222, 221, 224, 223, 222}], 
     Line3DBox[{226, 225, 228, 227, 226}], 
     Line3DBox[{230, 229, 232, 231, 230}], 
     Line3DBox[{234, 233, 236, 235, 234}], 
     Line3DBox[{238, 237, 240, 239, 238}], 
     Line3DBox[{242, 241, 244, 243, 242}], 
     Line3DBox[{246, 245, 248, 247, 246}], 
     Line3DBox[{250, 249, 252, 251, 250}], 
     Line3DBox[{254, 253, 256, 255, 254}], 
     Line3DBox[{258, 257, 260, 259, 258}], 
     Line3DBox[{262, 261, 264, 263, 262}], 
     Line3DBox[{266, 265, 268, 267, 266}], 
     Line3DBox[{270, 269, 272, 271, 270}], 
     Line3DBox[{274, 273, 276, 275, 274}], 
     Line3DBox[{278, 277, 280, 279, 278}], 
     Line3DBox[{282, 281, 284, 283, 282}], 
     Line3DBox[{286, 285, 288, 287, 286}], 
     Line3DBox[{290, 289, 292, 291, 290}], 
     Line3DBox[{294, 293, 296, 295, 294}], 
     Line3DBox[{298, 297, 300, 299, 298}], 
     Line3DBox[{302, 301, 304, 303, 302}], 
     Line3DBox[{306, 305, 308, 307, 306}], 
     Line3DBox[{310, 309, 312, 311, 310}], 
     Line3DBox[{314, 313, 316, 315, 314}], 
     Line3DBox[{318, 317, 320, 319, 318}], 
     Line3DBox[{322, 321, 324, 323, 322}]}},
   VertexNormals->CompressedData["
1:eJztzrENRXAQwOGLF70VzPGKt4MRJLRGsIm8Tf4LmENtBBVREHSK75pLvivu
V9Zd1WQRUeQRnzib+cc555xzzjnnnHPOOeecc84555zvffz27fCf1p3Wy4Wn
h779uenpoevXr1+/fv369evXr1+/fv369evXr1+/fv369evXr1+/fv369evX
r1+/fv369evXr1+/fv369evXr1+/fv369evXr/8F/cczJ84555xzzjnnnHPO
Oeecc84553zvC9oWuDI=
    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  Method->{
   "RotationControl" -> "Globe", "SpherePoints" -> Automatic, 
    "CylinderPoints" -> Automatic},
  PlotRange->{{1., 10.}, {1., 10.}, {2., 16.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158946320,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 " are equivalent to the lengths of ",
 Cell[BoxData[
  ButtonBox["BinLists",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinLists"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->649914853],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71746030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->277884677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "81", ",", "110", ",", "101", ",", "101", ",", "117", ",", "105", ",", "96",
    ",", "101", ",", "91", ",", "97"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209805277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"BinLists", "[", "data", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->402198174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "81", ",", "110", ",", "101", ",", "101", ",", "117", ",", "105", ",", "96",
    ",", "101", ",", "91", ",", "97"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->111023543]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->66283699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", "data2", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->511930846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "11", ",", "20", ",", "5", ",", "12", ",", "9", ",", "10", ",", "10", ",",
      "5", ",", "13", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12", ",", "6", ",", "9", ",", "8", ",", "11", ",", "8", ",", "17", ",", 
     "12", ",", "12", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "14", ",", "11", ",", "13", ",", "4", ",", "10", ",", "12", ",", "12", 
     ",", "6", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "18", ",", "11", ",", "9", ",", "5", ",", "6", ",", "8", ",", 
     "7", ",", "11", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "11", ",", "10", ",", "8", ",", "8", ",", "12", ",", "12", ",", "9", ",", 
     "17", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "15", ",", "8", ",", "12", ",", "10", ",", "13", ",", "6", ",",
      "13", ",", "8", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "13", ",", "11", ",", "13", ",", "12", ",", "8", ",", "7", ",", 
     "6", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "15", ",", "12", ",", "14", ",", "14", ",", "13", ",", "10", 
     ",", "11", ",", "13", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "5", ",", "8", ",", "11", ",", "11", ",", "13", ",", "8", ",", 
     "9", ",", "10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15", ",", "9", ",", "5", ",", "12", ",", "5", ",", "10", ",", "10", ",", 
     "11", ",", "7", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3396871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Length", ",", 
   RowBox[{"BinLists", "[", "data2", "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->15118708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "11", ",", "20", ",", "5", ",", "12", ",", "9", ",", "10", ",", "10", ",",
      "5", ",", "13", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "12", ",", "6", ",", "9", ",", "8", ",", "11", ",", "8", ",", "17", ",", 
     "12", ",", "12", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "14", ",", "11", ",", "13", ",", "4", ",", "10", ",", "12", ",", "12", 
     ",", "6", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "18", ",", "11", ",", "9", ",", "5", ",", "6", ",", "8", ",", 
     "7", ",", "11", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "11", ",", "10", ",", "8", ",", "8", ",", "12", ",", "12", ",", "9", ",", 
     "17", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "10", ",", "15", ",", "8", ",", "12", ",", "10", ",", "13", ",", "6", ",",
      "13", ",", "8", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "9", ",", "13", ",", "11", ",", "13", ",", "12", ",", "8", ",", "7", ",", 
     "6", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "13", ",", "15", ",", "12", ",", "14", ",", "14", ",", "13", ",", "10", 
     ",", "11", ",", "13", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "5", ",", "8", ",", "11", ",", "11", ",", "13", ",", "8", ",", 
     "9", ",", "10", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "15", ",", "9", ",", "5", ",", "12", ",", "5", ",", "10", ",", "10", ",", 
     "11", ",", "7", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->102961445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Binning intervals are closed on the left:", "ExampleText",
 CellID->36684001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39370045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43247631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "-", "$MachineEpsilon"}], ",", "2", ",", "3", ",", "4", ",", 
    "5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272316163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622560148]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinLists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->1010511862],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->60500434],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->654941414],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->28957085],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->945136914],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->844587408],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->74113356],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->173656765],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->32117950],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->119993687],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->28603899],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->80533686],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->690627238]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinCounts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 4.6768266}", "context" -> "System`", 
    "keywords" -> {
     "binning", "category counts", "density estimation", "histogram", 
      "range counts", "symbolic dynamics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BinCounts[{x_1, x_2, ...}] counts the number of elements x_i whose \
values lie in successive integer bins. BinCounts[{x_1, x_2, ...}, dx] counts \
the number of elements x_i whose values lie in successive bins of width dx. \
BinCounts[{x_1, x_2, ...}, {x_min, x_max, dx}] counts the number of x_i in \
successive bins of width dx from x_min to x_max. BinCounts[{x_1, x_2, ...}, \
{{b_1, b_2, ...}}] counts the number of x_i in the intervals (b_1, b_2), \
(b_2, b_3), .... BinCounts[{{x_1, y_1, ...}, {x_2, y_2, ...}, ...}, xbins, \
ybins, ...] gives an array of counts where the first index corresponds to x \
bins, the second to y, and so on. ", "synonyms" -> {"bin counts"}, "title" -> 
    "BinCounts", "type" -> "Symbol", "uri" -> "ref/BinCounts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18415, 601, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->745551]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 84781, 2273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3645, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4268, 100, 1574, 37, 70, "ObjectNameGrid"],
Cell[5845, 139, 6042, 197, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[11924, 341, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12402, 358, 236, 7, 70, "Notes",
 CellID->989418566],
Cell[12641, 367, 1222, 44, 70, "Notes",
 CellID->82409304],
Cell[13866, 413, 451, 17, 70, "Notes",
 CellID->210517892],
Cell[14320, 432, 892, 34, 70, "Notes",
 CellID->126729676],
Cell[15215, 468, 975, 39, 70, "Notes",
 CellID->497450453],
Cell[16193, 509, 361, 13, 70, "Notes",
 CellID->168774678],
Cell[16557, 524, 846, 32, 70, "Notes",
 CellID->94503541],
Cell[17406, 558, 645, 24, 70, "Notes",
 CellID->1067943069],
Cell[18054, 584, 324, 12, 70, "Notes",
 CellID->553010305]
}, Closed]],
Cell[CellGroupData[{
Cell[18415, 601, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745551],
Cell[CellGroupData[{
Cell[18797, 615, 148, 5, 70, "ExampleSection",
 CellID->122348688],
Cell[18948, 622, 111, 3, 70, "ExampleText",
 CellID->18927180],
Cell[CellGroupData[{
Cell[19084, 629, 307, 10, 28, "Input",
 CellID->38712768],
Cell[19394, 641, 290, 9, 36, "Output",
 CellID->99614887]
}, Open  ]],
Cell[19699, 653, 125, 3, 70, "ExampleDelimiter",
 CellID->689178298],
Cell[19827, 658, 95, 1, 70, "ExampleText",
 CellID->26246007],
Cell[CellGroupData[{
Cell[19947, 663, 396, 13, 70, "Input",
 CellID->107309661],
Cell[20346, 678, 222, 7, 36, "Output",
 CellID->51549383]
}, Open  ]],
Cell[20583, 688, 125, 3, 70, "ExampleDelimiter",
 CellID->194206092],
Cell[20711, 693, 103, 2, 70, "ExampleText",
 CellID->245743928],
Cell[CellGroupData[{
Cell[20839, 699, 248, 8, 70, "Input",
 CellID->235360212],
Cell[21090, 709, 222, 7, 36, "Output",
 CellID->10658643]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21361, 722, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[21585, 731, 112, 3, 70, "ExampleText",
 CellID->422181288],
Cell[CellGroupData[{
Cell[21722, 738, 398, 14, 70, "Input",
 CellID->92857074],
Cell[22123, 754, 499, 16, 36, "Output",
 CellID->324731095]
}, Open  ]],
Cell[22637, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->385637151],
Cell[22765, 778, 105, 2, 70, "ExampleText",
 CellID->254770907],
Cell[CellGroupData[{
Cell[22895, 784, 497, 17, 70, "Input",
 CellID->112655837],
Cell[23395, 803, 1281, 39, 88, "Output",
 CellID->57300052]
}, Open  ]],
Cell[24691, 845, 125, 3, 70, "ExampleDelimiter",
 CellID->102656935],
Cell[24819, 850, 81, 1, 70, "ExampleText",
 CellID->793572346],
Cell[CellGroupData[{
Cell[24925, 855, 585, 21, 70, "Input",
 CellID->570033843],
Cell[25513, 878, 333, 11, 36, "Output",
 CellID->821687699]
}, Open  ]],
Cell[25861, 892, 125, 3, 70, "ExampleDelimiter",
 CellID->105306913],
Cell[25989, 897, 70, 1, 70, "ExampleText",
 CellID->96436699],
Cell[CellGroupData[{
Cell[26084, 902, 293, 10, 70, "Input",
 CellID->782641426],
Cell[26380, 914, 1960, 36, 70, "Output",
 Evaluatable->False,
 CellID->749162563]
}, Open  ]],
Cell[28355, 953, 124, 3, 70, "ExampleDelimiter",
 CellID->91707437],
Cell[28482, 958, 95, 1, 70, "ExampleText",
 CellID->407025834],
Cell[CellGroupData[{
Cell[28602, 963, 226, 7, 70, "Input",
 CellID->103395590],
Cell[28831, 972, 203, 7, 36, "Output",
 CellID->436612420]
}, Open  ]],
Cell[29049, 982, 125, 3, 70, "ExampleDelimiter",
 CellID->297373174],
Cell[29177, 987, 77, 1, 70, "ExampleText",
 CellID->25385746],
Cell[CellGroupData[{
Cell[29279, 992, 284, 9, 70, "Input",
 CellID->29800496],
Cell[29566, 1003, 203, 7, 36, "Output",
 CellID->241664417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29818, 1016, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[30065, 1025, 204, 8, 70, "ExampleText",
 CellID->93310457],
Cell[CellGroupData[{
Cell[30294, 1037, 441, 15, 70, "Input",
 CellID->705020460],
Cell[30738, 1054, 481, 17, 36, "Output",
 CellID->239290855]
}, Open  ]],
Cell[CellGroupData[{
Cell[31256, 1076, 108, 3, 70, "Input",
 CellID->108702580],
Cell[31367, 1081, 478, 17, 36, "Output",
 CellID->28943293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31894, 1104, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[32124, 1113, 107, 3, 70, "ExampleText",
 CellID->286062020],
Cell[32234, 1118, 354, 12, 70, "Input",
 CellID->757980791],
Cell[CellGroupData[{
Cell[32613, 1134, 110, 3, 70, "Input",
 CellID->623751355],
Cell[32726, 1139, 658, 14, 201, "Output",
 CellID->364825040]
}, Open  ]],
Cell[CellGroupData[{
Cell[33421, 1158, 276, 7, 70, "Input",
 CellID->170390343],
Cell[33700, 1167, 37746, 650, 166, 12078, 225, "CachedBoxData", "BoxData", \
"Output",
 CellID->158946320]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71495, 1823, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[71736, 1832, 338, 12, 70, "ExampleText",
 CellID->649914853],
Cell[72077, 1846, 257, 10, 70, "Input",
 CellID->71746030],
Cell[CellGroupData[{
Cell[72359, 1860, 108, 3, 70, "Input",
 CellID->277884677],
Cell[72470, 1865, 307, 9, 36, "Output",
 CellID->209805277]
}, Open  ]],
Cell[CellGroupData[{
Cell[72814, 1879, 166, 5, 70, "Input",
 CellID->402198174],
Cell[72983, 1886, 307, 9, 36, "Output",
 CellID->111023543]
}, Open  ]],
Cell[73305, 1898, 308, 11, 70, "Input",
 CellID->66283699],
Cell[CellGroupData[{
Cell[73638, 1913, 109, 3, 70, "Input",
 CellID->511930846],
Cell[73750, 1918, 1738, 47, 105, "Output",
 CellID->3396871]
}, Open  ]],
Cell[CellGroupData[{
Cell[75525, 1970, 200, 6, 70, "Input",
 CellID->15118708],
Cell[75728, 1978, 1740, 47, 105, "Output",
 CellID->102961445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77517, 2031, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[77751, 2040, 83, 1, 70, "ExampleText",
 CellID->36684001],
Cell[CellGroupData[{
Cell[77859, 2045, 184, 6, 70, "Input",
 CellID->39370045],
Cell[78046, 2053, 246, 8, 36, "Output",
 CellID->43247631]
}, Open  ]],
Cell[CellGroupData[{
Cell[78329, 2066, 226, 7, 70, "Input",
 CellID->272316163],
Cell[78558, 2075, 247, 8, 36, "Output",
 CellID->622560148]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78866, 2090, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[79185, 2101, 1405, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[80627, 2159, 299, 8, 70, "MoreAboutSection"],
Cell[80929, 2169, 156, 3, 70, "MoreAbout",
 CellID->1010511862],
Cell[81088, 2174, 154, 3, 70, "MoreAbout",
 CellID->60500434],
Cell[81245, 2179, 157, 3, 70, "MoreAbout",
 CellID->654941414],
Cell[81405, 2184, 154, 3, 70, "MoreAbout",
 CellID->28957085],
Cell[81562, 2189, 145, 3, 70, "MoreAbout",
 CellID->945136914],
Cell[81710, 2194, 190, 4, 70, "MoreAbout",
 CellID->844587408],
Cell[81903, 2200, 138, 3, 70, "MoreAbout",
 CellID->74113356],
Cell[82044, 2205, 132, 3, 70, "MoreAbout",
 CellID->173656765],
Cell[82179, 2210, 184, 3, 70, "MoreAbout",
 CellID->32117950],
Cell[82366, 2215, 164, 3, 70, "MoreAbout",
 CellID->119993687],
Cell[82533, 2220, 178, 3, 70, "MoreAbout",
 CellID->28603899],
Cell[82714, 2225, 174, 3, 70, "MoreAbout",
 CellID->80533686],
Cell[82891, 2230, 151, 3, 70, "MoreAbout",
 CellID->690627238]
}, Open  ]],
Cell[83057, 2236, 27, 0, 70, "History"],
Cell[83087, 2238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

