(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27576,        844]
NotebookOptionsPosition[     23127,        699]
NotebookOutlinePosition[     24665,        740]
CellTagsIndexPosition[     24580,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Files" :> 
          Documentation`HelpLookup["paclet:tutorial/BinaryFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Binary Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], 
          "BinaryWrite" :> Documentation`HelpLookup["paclet:ref/BinaryWrite"],
           "Read" :> Documentation`HelpLookup["paclet:ref/Read"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinaryReadList\"\>", 
       2->"\<\"BinaryWrite\"\>", 3->"\<\"Read\"\>", 4->"\<\"Import\"\>", 
       5->"\<\"ImportString\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"Files\"\>", 
       4->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BinaryRead", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryRead"], "[", 
       StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads one byte of raw binary data from an input stream, \
and returns an integer from 0 to 255. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryRead"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads an object of the specified type. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryRead",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryRead"], "[", 
       RowBox[{
        StyleBox["stream", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads a sequence of objects of the specified types. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible types to read are: ", "Notes",
 CellID->297],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Byte\>\"", Cell[
    "8\[Hyphen]bit unsigned integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Character8\>\"", Cell[
    "8\[Hyphen]bit character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Character16\>\"", Cell[
    "16\[Hyphen]bit character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex64\>\"", Cell["\<\
IEEE single\[Hyphen]precision complex number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex128\>\"", Cell["\<\
IEEE double\[Hyphen]precision complex number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex256\>\"", Cell["\<\
IEEE quad\[Hyphen]precision complex number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer8\>\"", Cell[
    "8\[Hyphen]bit signed integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer16\>\"", Cell[
    "16\[Hyphen]bit signed integer ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Integer24\>\"", Cell[
    "24-bit signed integer", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer32\>\"", Cell[
    "32\[Hyphen]bit signed integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer64\>\"", Cell[
    "64\[Hyphen]bit signed integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer128\>\"", Cell[
    "128\[Hyphen]bit signed integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real32\>\"", Cell["\<\
IEEE single\[Hyphen]precision real number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real64\>\"", Cell["\<\
IEEE double\[Hyphen]precision real number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real128\>\"", Cell["\<\
IEEE quad\[Hyphen]precision real number \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["\"\<TerminatedString\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/TerminatedString"], Cell["\<\
null\[Hyphen]terminated string of 8\[Hyphen]bit characters \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger8\>\"", Cell[
    "8\[Hyphen]bit unsigned integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger16\>\"", Cell[
    "16\[Hyphen]bit unsigned integer ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<UnsignedInteger24\>\"", Cell[
    "24-bit unsigned integer", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger32\>\"", Cell[
    "32\[Hyphen]bit unsigned integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger64\>\"", Cell[
    "64\[Hyphen]bit unsigned integer ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger128\>\"", Cell[
    "128\[Hyphen]bit unsigned integer ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, None, None, None, 
     None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->15727],

Cell[TextData[{
 "The first argument to ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ", or simply ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 " if there is only one open input stream with the specified name. "
}], "Notes",
 CellID->4665],

Cell[TextData[{
 "You can open a file or pipe to get an ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " object using ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10300],

Cell[TextData[{
 "Streams for use with ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " should be opened with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21888],

Cell[TextData[{
 "There is always a \[OpenCurlyDoubleQuote]current point\
\[CloseCurlyDoubleQuote] maintained for any stream. When you read an object \
from a stream, the current point is left after the input you read. Successive \
calls to ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " can therefore be used to read successive objects in a stream such as a \
file. "
}], "Notes",
 CellID->14969],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " if you are at the end of the file. "
}], "Notes",
 CellID->21813],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " for IEEE \[OpenCurlyDoubleQuote]infinity\[CloseCurlyDoubleQuote], and ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " for IEEE \[OpenCurlyDoubleQuote]not\[Hyphen]a\[Hyphen]number\
\[CloseCurlyDoubleQuote]. "
}], "Notes",
 CellID->14398],

Cell["The following options can be given: ", "Notes",
 CellID->1244],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    ButtonBox["$ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ByteOrdering"], Cell[
    "what byte ordering to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Path",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Path"], 
    ButtonBox["$Path",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Path"], Cell[
    "the path to search for files to be opened ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->20359]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325262633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->793119516],

Cell["Create a file with a sequence of bytes:", "ExampleText",
 CellID->817451210],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->963183574],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "[", 
   RowBox[{"file", ",", " ", 
    RowBox[{"{", 
     RowBox[{"8", ",", "97", ",", "255"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1449596611],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1359588613],

Cell["Read the first byte from the file:", "ExampleText",
 CellID->224833898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1379814611],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->339145251]
}, Open  ]],

Cell["Read the second byte as 8-bit character:", "ExampleText",
 CellID->2101448772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"file", ",", " ", "\"\<Character8\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1533452442],

Cell[BoxData["\<\"a\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->279978359]
}, Open  ]],

Cell["Read the next byte as 8-bit signed integer:", "ExampleText",
 CellID->1783564786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", 
  RowBox[{"file", ",", " ", "\"\<Integer8\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->95632256],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->72216978]
}, Open  ]],

Cell["Close the file:", "ExampleText",
 CellID->954459324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "file", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1866941297],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test1\"\>"], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->80873442]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8428],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3913]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26850],

Cell[TextData[ButtonBox["Binary Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BinaryFiles"]], "Tutorials",
 CellID->20456]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->49274108],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->857140283],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->514197632],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->190757388],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->569667231]
}, Open  ]],

Cell["New in 5.1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinaryRead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 3.6768010}", "context" -> "System`", 
    "keywords" -> {
     "data input", "low-level data", "raw data", "reading binary data", 
      "fast file I/O", "binary file I/O"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BinaryRead[stream] reads one byte of raw binary data from an input \
stream, and returns an integer from 0 to 255. BinaryRead[stream, type] reads \
an object of the specified type. BinaryRead[stream, {type_1, type_2, ...}] \
reads a sequence of objects of the specified types. ", 
    "synonyms" -> {"binary read"}, "title" -> "BinaryRead", "type" -> 
    "Symbol", "uri" -> "ref/BinaryRead"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17161, 457, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->325262633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24436, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2499, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3122, 84, 4194, 83, 70, "ObjectNameGrid"],
Cell[7319, 169, 1542, 46, 70, "Usage",
 CellID->12855]
}, Open  ]],
Cell[CellGroupData[{
Cell[8898, 220, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9376, 237, 59, 1, 70, "Notes",
 CellID->297],
Cell[9438, 240, 3784, 77, 70, "2ColumnTableMod",
 CellID->15727],
Cell[13225, 319, 615, 20, 70, "Notes",
 CellID->4665],
Cell[13843, 341, 356, 13, 70, "Notes",
 CellID->10300],
Cell[14202, 356, 457, 17, 70, "Notes",
 CellID->21888],
Cell[14662, 375, 479, 12, 70, "Notes",
 CellID->14969],
Cell[15144, 389, 342, 12, 70, "Notes",
 CellID->21813],
Cell[15489, 403, 598, 18, 70, "Notes",
 CellID->14398],
Cell[16090, 423, 68, 1, 70, "Notes",
 CellID->1244],
Cell[16161, 426, 963, 26, 70, "3ColumnTableMod",
 CellID->20359]
}, Closed]],
Cell[CellGroupData[{
Cell[17161, 457, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->325262633],
Cell[CellGroupData[{
Cell[17546, 471, 148, 5, 70, "ExampleSection",
 CellID->793119516],
Cell[17697, 478, 82, 1, 70, "ExampleText",
 CellID->817451210],
Cell[17782, 481, 182, 6, 70, "Input",
 CellID->963183574],
Cell[17967, 489, 222, 7, 70, "Input",
 CellID->1449596611],
Cell[18192, 498, 123, 4, 70, "Input",
 CellID->1359588613],
Cell[18318, 504, 77, 1, 70, "ExampleText",
 CellID->224833898],
Cell[CellGroupData[{
Cell[18420, 509, 110, 3, 70, "Input",
 CellID->1379814611],
Cell[18533, 514, 158, 5, 36, "Output",
 CellID->339145251]
}, Open  ]],
Cell[18706, 522, 84, 1, 70, "ExampleText",
 CellID->2101448772],
Cell[CellGroupData[{
Cell[18815, 527, 155, 4, 70, "Input",
 CellID->1533452442],
Cell[18973, 533, 166, 5, 36, "Output",
 CellID->279978359]
}, Open  ]],
Cell[19154, 541, 87, 1, 70, "ExampleText",
 CellID->1783564786],
Cell[CellGroupData[{
Cell[19266, 546, 151, 4, 70, "Input",
 CellID->95632256],
Cell[19420, 552, 174, 6, 36, "Output",
 CellID->72216978]
}, Open  ]],
Cell[19609, 561, 58, 1, 70, "ExampleText",
 CellID->954459324],
Cell[CellGroupData[{
Cell[19692, 566, 105, 3, 70, "Input",
 CellID->1866941297],
Cell[19800, 571, 239, 6, 36, "Output",
 CellID->80873442]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20100, 584, 310, 9, 70, "SeeAlsoSection",
 CellID->8428],
Cell[20413, 595, 1199, 44, 70, "SeeAlso",
 CellID->3913]
}, Open  ]],
Cell[CellGroupData[{
Cell[21649, 644, 314, 9, 70, "TutorialsSection",
 CellID->26850],
Cell[21966, 655, 134, 3, 70, "Tutorials",
 CellID->20456]
}, Open  ]],
Cell[CellGroupData[{
Cell[22137, 663, 318, 9, 70, "MoreAboutSection",
 CellID->49274108],
Cell[22458, 674, 133, 3, 70, "MoreAbout",
 CellID->857140283],
Cell[22594, 679, 149, 3, 70, "MoreAbout",
 CellID->514197632],
Cell[22746, 684, 122, 3, 70, "MoreAbout",
 CellID->190757388],
Cell[22871, 689, 159, 3, 70, "MoreAbout",
 CellID->569667231]
}, Open  ]],
Cell[23045, 695, 52, 0, 70, "History"],
Cell[23100, 697, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

