(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19357,        652]
NotebookOptionsPosition[     15193,        523]
NotebookOutlinePosition[     16982,        567]
CellTagsIndexPosition[     16897,        562]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Files" :> 
          Documentation`HelpLookup["paclet:tutorial/BinaryFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Binary Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "BinaryRead" :> Documentation`HelpLookup["paclet:ref/BinaryRead"], 
          "Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "ReadList" :> Documentation`HelpLookup["paclet:ref/ReadList"], 
          "FileByteCount" :> 
          Documentation`HelpLookup["paclet:ref/FileByteCount"], "FileHash" :> 
          Documentation`HelpLookup["paclet:ref/FileHash"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Import\"\>", 
       2->"\<\"BinaryRead\"\>", 3->"\<\"Export\"\>", 4->"\<\"ReadList\"\>", 
       5->"\<\"FileByteCount\"\>", 6->"\<\"FileHash\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"File Operations\"\>", 
       4->"\<\"Files\"\>", 5->"\<\"Importing & Exporting\"\>", 
       6->"\<\"Low-Level File Operations\"\>", 
       7->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BinaryReadList", "ObjectName",
 CellID->13854],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryReadList"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]reads all remaining bytes from a file, and returns them \
as a list of integers from 0 to 255. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads objects of the specified type from a file, until \
the end of the file is reached. The list of objects read is returned. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads objects with a sequence of types, until the end \
of the file is reached. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryReadList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryReadList"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        StyleBox["types", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]reads only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " objects of the specified types. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryReadList"]], "InlineFormula"],
 " supports the same types and options as ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3992],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " is not already open for reading, ",
 Cell[BoxData[
  ButtonBox["BinaryReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryReadList"]], "InlineFormula"],
 " opens it, then closes it when it is finished. If the file is already open, \
",
 Cell[BoxData[
  ButtonBox["BinaryReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryReadList"]], "InlineFormula"],
 " does not close it at the end. "
}], "Notes",
 CellID->27602],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["type", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " reads the sequence of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["type", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in order. If the end of file is reached while partway through this \
sequence, ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " is returned in place of elements in the sequence that have not yet been \
read. "
}], "Notes",
 CellID->32226],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"], "[", 
   RowBox[{"\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " reads from a pipe. "
}], "Notes",
 CellID->29994],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"], "[", 
   StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
 " reads from an open input stream, as returned by ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25045]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->442161354],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->46472898],

Cell["Create a file with a sequence of bytes:", "ExampleText",
 CellID->817451210],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->963183574],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "[", 
   RowBox[{"file", ",", " ", 
    RowBox[{"{", 
     RowBox[{"8", ",", "97", ",", "255"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1449596611],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1359588613],

Cell["Read all the data in the file:", "ExampleText",
 CellID->224833898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryReadList", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1379814611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", "97", ",", "255"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->32150006]
}, Open  ]],

Cell["Read the data as objects of a sequence of types:", "ExampleText",
 CellID->1963831106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryReadList", "[", 
  RowBox[{"file", ",", " ", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Byte\>\"", ",", "\"\<Character8\>\"", ",", "\"\<Integer8\>\""}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1433227799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"8", ",", "\<\"a\"\>", ",", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->781304311]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11881],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21374],

Cell[TextData[ButtonBox["Binary Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BinaryFiles"]], "Tutorials",
 CellID->2548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->28384384],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->142047404],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->112670860],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->167245755],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->421208931],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->155157518],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->561035114],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->247516456]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinaryReadList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 3.4111692}", "context" -> "System`", 
    "keywords" -> {
     "read binary file", "binary file I/O", "file I/O", "fast file I/O", 
      "parse binary files", "decode binary files"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BinaryReadList[\"file\"] reads all remaining bytes from a file, and \
returns them as a list of integers from 0 to 255. BinaryReadList[\"file\", \
type] reads objects of the specified type from a file, until the end of the \
file is reached. The list of objects read is returned. \
BinaryReadList[\"file\", {type_1, type_2, ...}] reads objects with a sequence \
of types, until the end of the file is reached. BinaryReadList[\"file\", \
types, n] reads only the first n objects of the specified types. ", 
    "synonyms" -> {"binary read list"}, "title" -> "BinaryReadList", "type" -> 
    "Symbol", "uri" -> "ref/BinaryReadList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9203, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->442161354]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16754, 555}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3019, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3642, 94, 52, 1, 70, "ObjectName",
 CellID->13854],
Cell[3697, 97, 2226, 63, 70, "Usage",
 CellID->28454]
}, Open  ]],
Cell[CellGroupData[{
Cell[5960, 165, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6438, 182, 348, 12, 70, "Notes",
 CellID->3992],
Cell[6789, 196, 531, 17, 70, "Notes",
 CellID->27602],
Cell[7323, 215, 855, 28, 70, "Notes",
 CellID->32226],
Cell[8181, 245, 331, 11, 70, "Notes",
 CellID->29994],
Cell[8515, 258, 651, 23, 70, "Notes",
 CellID->25045]
}, Closed]],
Cell[CellGroupData[{
Cell[9203, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->442161354],
Cell[CellGroupData[{
Cell[9588, 300, 147, 5, 70, "ExampleSection",
 CellID->46472898],
Cell[9738, 307, 82, 1, 70, "ExampleText",
 CellID->817451210],
Cell[9823, 310, 182, 6, 70, "Input",
 CellID->963183574],
Cell[10008, 318, 222, 7, 70, "Input",
 CellID->1449596611],
Cell[10233, 327, 123, 4, 70, "Input",
 CellID->1359588613],
Cell[10359, 333, 73, 1, 70, "ExampleText",
 CellID->224833898],
Cell[CellGroupData[{
Cell[10457, 338, 114, 3, 70, "Input",
 CellID->1379814611],
Cell[10574, 343, 215, 7, 36, "Output",
 CellID->32150006]
}, Open  ]],
Cell[10804, 353, 92, 1, 70, "ExampleText",
 CellID->1963831106],
Cell[CellGroupData[{
Cell[10921, 358, 254, 8, 70, "Input",
 CellID->1433227799],
Cell[11178, 368, 265, 9, 36, "Output",
 CellID->781304311]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11504, 384, 311, 9, 70, "SeeAlsoSection",
 CellID->11881],
Cell[11818, 395, 1437, 53, 70, "SeeAlso",
 CellID->31975]
}, Open  ]],
Cell[CellGroupData[{
Cell[13292, 453, 314, 9, 70, "TutorialsSection",
 CellID->21374],
Cell[13609, 464, 133, 3, 70, "Tutorials",
 CellID->2548]
}, Open  ]],
Cell[CellGroupData[{
Cell[13779, 472, 318, 9, 70, "MoreAboutSection",
 CellID->28384384],
Cell[14100, 483, 133, 3, 70, "MoreAbout",
 CellID->142047404],
Cell[14236, 488, 147, 3, 70, "MoreAbout",
 CellID->112670860],
Cell[14386, 493, 141, 3, 70, "MoreAbout",
 CellID->167245755],
Cell[14530, 498, 122, 3, 70, "MoreAbout",
 CellID->421208931],
Cell[14655, 503, 154, 3, 70, "MoreAbout",
 CellID->155157518],
Cell[14812, 508, 159, 3, 70, "MoreAbout",
 CellID->561035114],
Cell[14974, 513, 145, 3, 70, "MoreAbout",
 CellID->247516456]
}, Open  ]],
Cell[15134, 519, 29, 0, 70, "History"],
Cell[15166, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

