(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20381,        701]
NotebookOptionsPosition[     15828,        558]
NotebookOutlinePosition[     17629,        602]
CellTagsIndexPosition[     17544,        597]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Files" :> 
          Documentation`HelpLookup["paclet:tutorial/BinaryFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Binary Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "WriteString" :> 
          Documentation`HelpLookup["paclet:ref/WriteString"], "Export" :> 
          Documentation`HelpLookup["paclet:ref/Export"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BinaryRead\"\>", 2->"\<\"WriteString\"\>", 
       3->"\<\"Export\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Files\"\>", 3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Low-Level File Operations\"\>", 
       5->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BinaryWrite", "ObjectName",
 CellID->3266],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a byte of data, specified as an integer from 0 \
to 255. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a sequence of bytes. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes the raw sequence of characters in a string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes an object of the specified type. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a sequence of objects of the specified type. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BinaryWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BinaryWrite"], "[", 
       RowBox[{
        StyleBox["channel", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["type", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes a sequence of objects with a sequence of types. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " supports the same types as ",
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18482],

Cell[TextData[{
 "The output channel used by ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " can be a single file or pipe, or a list of them, each specified by a \
string giving its name, or by an ",
 Cell[BoxData[
  ButtonBox["OutputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputStream"]], "InlineFormula"],
 " object that has been opened with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryFormat"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24508],

Cell[TextData[{
 "If any of the specified files or pipes are not already open, ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["OpenWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenWrite"]], "InlineFormula"],
 " to open them. "
}], "Notes",
 CellID->1802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " does not close files and pipes after it finishes writing to them. "
}], "Notes",
 CellID->12494],

Cell["\<\
When a list of types is given, the list is effectively repeated as many times \
as necessary. \
\>", "Notes",
 CellID->22571],

Cell["The following options can be given: ", "Notes",
 CellID->10506],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    ButtonBox["$ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ByteOrdering"], Cell[
    "what byte ordering to use ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->698],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinaryWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryWrite"], "[", 
   RowBox[{
    StyleBox["channel", "TI"], ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " uses type ",
 Cell[BoxData["\"\<Character8\>\""], "InlineFormula"],
 ", so all characters in ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 " should have character codes in the range 0\[Dash]255. "
}], "Notes",
 CellID->27955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it encounters a data element that cannot match the type specified. "
}], "Notes",
 CellID->29144]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639834983],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->3796028],

Cell["Create a file with a sequence of bytes:", "ExampleText",
 CellID->817451210],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->963183574],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "[", 
   RowBox[{"file", ",", " ", 
    RowBox[{"{", 
     RowBox[{"8", ",", "97", ",", "255"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1449596611],

Cell["Close the stream:", "ExampleText",
 CellID->1451818078],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1359588613],

Cell["Read the first byte from the file:", "ExampleText",
 CellID->224833898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1379814611],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->172524543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", "file", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->997239732],

Cell[BoxData["97"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->165090971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinaryRead", "[", "file", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->118738681],

Cell[BoxData["255"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->134687108]
}, Open  ]],

Cell["Close the stream:", "ExampleText",
 CellID->1000248488],

Cell[BoxData[
 RowBox[{
  RowBox[{"Close", "[", "file", "]"}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1866941297]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30031],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WriteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WriteString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22444],

Cell[TextData[ButtonBox["Binary Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BinaryFiles"]], "Tutorials",
 CellID->19224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->102835880],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->34152996],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->195612578],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->7512226],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->582115782],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->357020430]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BinaryWrite - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 4.3486932}", "context" -> "System`", 
    "keywords" -> {
     "devices", "writing binary files", "fast binary files", "fast file I/O", 
      "binary file I/O", "data layout I/O"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BinaryWrite[channel, b] writes a byte of data, specified as an integer \
from 0 to 255. BinaryWrite[channel, {b_1, b_2, ...}] writes a sequence of \
bytes. BinaryWrite[channel, \" string\"] writes the raw sequence of \
characters in a string. BinaryWrite[channel, x, type] writes an object of the \
specified type. BinaryWrite[channel, {x_1, x_2, ...}, type] writes a sequence \
of objects of the specified type. BinaryWrite[channel, {x_1, x_2, ...}, \
{type_1, type_2, ...}] writes a sequence of objects with a sequence of types. \
", "synonyms" -> {"binary write"}, "title" -> "BinaryWrite", "type" -> 
    "Symbol", "uri" -> "ref/BinaryWrite"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10709, 345, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->639834983]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17400, 590}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2435, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3058, 84, 48, 1, 70, "ObjectName",
 CellID->3266],
Cell[3109, 87, 3568, 109, 70, "Usage",
 CellID->16729]
}, Open  ]],
Cell[CellGroupData[{
Cell[6714, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7192, 218, 331, 12, 70, "Notes",
 CellID->18482],
Cell[7526, 232, 713, 23, 70, "Notes",
 CellID->24508],
Cell[8242, 257, 386, 13, 70, "Notes",
 CellID->1802],
Cell[8631, 272, 240, 7, 70, "Notes",
 CellID->12494],
Cell[8874, 281, 135, 4, 70, "Notes",
 CellID->22571],
Cell[9012, 287, 69, 1, 70, "Notes",
 CellID->10506],
Cell[9084, 290, 672, 18, 70, "3ColumnTableMod",
 CellID->698],
Cell[9759, 310, 535, 16, 70, "Notes",
 CellID->27955],
Cell[10297, 328, 375, 12, 70, "Notes",
 CellID->29144]
}, Closed]],
Cell[CellGroupData[{
Cell[10709, 345, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639834983],
Cell[CellGroupData[{
Cell[11094, 359, 146, 5, 70, "ExampleSection",
 CellID->3796028],
Cell[11243, 366, 82, 1, 70, "ExampleText",
 CellID->817451210],
Cell[11328, 369, 182, 6, 70, "Input",
 CellID->963183574],
Cell[11513, 377, 222, 7, 70, "Input",
 CellID->1449596611],
Cell[11738, 386, 61, 1, 70, "ExampleText",
 CellID->1451818078],
Cell[11802, 389, 123, 4, 70, "Input",
 CellID->1359588613],
Cell[11928, 395, 77, 1, 70, "ExampleText",
 CellID->224833898],
Cell[CellGroupData[{
Cell[12030, 400, 110, 3, 70, "Input",
 CellID->1379814611],
Cell[12143, 405, 158, 5, 36, "Output",
 CellID->172524543]
}, Open  ]],
Cell[CellGroupData[{
Cell[12338, 415, 109, 3, 70, "Input",
 CellID->997239732],
Cell[12450, 420, 159, 5, 36, "Output",
 CellID->165090971]
}, Open  ]],
Cell[CellGroupData[{
Cell[12646, 430, 109, 3, 70, "Input",
 CellID->118738681],
Cell[12758, 435, 160, 5, 36, "Output",
 CellID->134687108]
}, Open  ]],
Cell[12933, 443, 61, 1, 70, "ExampleText",
 CellID->1000248488],
Cell[12997, 446, 123, 4, 70, "Input",
 CellID->1866941297]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13169, 456, 311, 9, 70, "SeeAlsoSection",
 CellID->30031],
Cell[13483, 467, 702, 26, 70, "SeeAlso",
 CellID->18740]
}, Open  ]],
Cell[CellGroupData[{
Cell[14222, 498, 314, 9, 70, "TutorialsSection",
 CellID->22444],
Cell[14539, 509, 134, 3, 70, "Tutorials",
 CellID->19224]
}, Open  ]],
Cell[CellGroupData[{
Cell[14710, 517, 319, 9, 70, "MoreAboutSection",
 CellID->102835880],
Cell[15032, 528, 132, 3, 70, "MoreAbout",
 CellID->34152996],
Cell[15167, 533, 122, 3, 70, "MoreAbout",
 CellID->195612578],
Cell[15292, 538, 152, 3, 70, "MoreAbout",
 CellID->7512226],
Cell[15447, 543, 159, 3, 70, "MoreAbout",
 CellID->582115782],
Cell[15609, 548, 145, 3, 70, "MoreAbout",
 CellID->357020430]
}, Open  ]],
Cell[15769, 554, 29, 0, 70, "History"],
Cell[15801, 556, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

