(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46424,       1506]
NotebookOptionsPosition[     39024,       1235]
NotebookOutlinePosition[     40227,       1271]
CellTagsIndexPosition[     40141,       1266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitOr" :> Documentation`HelpLookup["paclet:ref/BitOr"], 
          "BitXor" :> Documentation`HelpLookup["paclet:ref/BitXor"], "BitNot" :> 
          Documentation`HelpLookup["paclet:ref/BitNot"], "BitGet" :> 
          Documentation`HelpLookup["paclet:ref/BitGet"], "And" :> 
          Documentation`HelpLookup["paclet:ref/And"], "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "DigitCount" :> 
          Documentation`HelpLookup["paclet:ref/DigitCount"], 
          "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BitOr\"\>", 2->"\<\"BitXor\"\>", 
       3->"\<\"BitNot\"\>", 4->"\<\"BitGet\"\>", 5->"\<\"And\"\>", 
       6->"\<\"IntegerDigits\"\>", 7->"\<\"DigitCount\"\>", 
       8->"\<\"CellularAutomaton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Discrete Mathematics\"\>", 4->"\<\"Integer Functions\"\>", 
       5->"\<\"Mathematical Functions\"\>", 6->"\<\"Number Digits\"\>", 
       7->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BitAnd", "ObjectName",
 CellID->27401],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitAnd",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitAnd"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the bitwise AND of the integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15937]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of all of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " have ones. "
}], "Notes",
 CellID->11347],

Cell[TextData[{
 "For negative integers ",
 Cell[BoxData[
  ButtonBox["BitAnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitAnd"]], "InlineFormula"],
 " assumes a two's complement representation. "
}], "Notes",
 CellID->26919],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitAnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitAnd"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->501059406],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->863515119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"61", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20795],

Cell[BoxData["13"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerDigits", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"61", ",", "15", ",", "13"}], "}"}], ",", "2", ",", "6"}], "]"}],
   "//", "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29411],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVs0OgjAMHkwkmhj15pG776EnH2IhJnAwLsj7Yzf8IWUwhht4GMna9WMt
H+vyZRdWZtcbK/OUJeeC8SxPH8npXgBEA0IIh3E8EJhXMJODVxX42i6EpQKV
D1mheGs5pvKrFKFrMCGEO43fo7xQWU3EIowQHnfgSzARae9FF25aR81SotEn
lmvqXPGnce9b3CUdbl6tzT9UdbJVc6NEdadiWBbe78BgX13y+qXfnte/81Kh
9JX99lirmjg+tbUC8l7rVdlclU3x+VXZBJ9Wj3Xx9Eqsi6fXFM/IFaMxitv0
XnG/qEsFtXMPxqtsq6mLuy/+Y9Pu27zvYsZuuIzrpecyPxcVqtOYofdXEjwB
zJ7BkQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11801911]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6655],

Cell["Use numbers of any size:", "ExampleText",
 CellID->10371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{
   RowBox[{"3", "^", "100"}], ",", 
   RowBox[{"5", "^", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25502],

Cell[BoxData["503913279078601980753385379100266097026814443729"], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27761],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitAnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitAnd"]], "InlineFormula"],
 " takes any number of arguments:"
}], "ExampleText",
 CellID->15717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"3333", ",", "5555", ",", "7777", ",", "9999"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13965],

Cell[BoxData["1025"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19501],

Cell["Use negative numbers:", "ExampleText",
 CellID->6423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23815],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29409]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10053],

Cell["Basic symbolic simplifications are done automatically:", "ExampleText",
 CellID->6002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"x", ",", "y", ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4431],

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11585]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"3", ",", "5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17089],

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"1", ",", "x"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29807]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"1", ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15944],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10812],

Cell["Extract the second-lowest-order bits in numbers:", "ExampleText",
 CellID->13627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BitAnd", "[", 
    RowBox[{"i", ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "2", ",", "2", ",", "0", ",", "0", ",", "2", ",", "2", ",", "0", 
   ",", "0", ",", "2"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30095],

Cell["\<\
\[OpenCurlyDoubleQuote]Mask\[CloseCurlyDoubleQuote] to test whether bits 3 or \
4 are 1:\
\>", "ExampleText",
 CellID->28885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"BitAnd", "[", 
     RowBox[{"i", ",", 
      RowBox[{
       RowBox[{"2", "^", "2"}], "+", 
       RowBox[{"2", "^", "3"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "16"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "0"}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29755],

Cell["Make a nested pattern:", "ExampleText",
 CellID->2415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"BitAnd", "[", 
       RowBox[{"i", ",", "j"}], "]"}], "==", "0"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "63"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5741],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyllcENwzAMA+lu0k06Q0fIAt3/10f8EYHqSsuGIBAMQtgypef1eV8PSa8d
WrM1/YHW7AfTI2jHuf7sDrT3uf69zvVrzvVrzvVVcq5/K5/egSxy/Rq5ft25
fl25fo9Zv8esrxazflVM78Drnr4Dr3v6Drzu6TvwuqfvwP2f9gP3f9oP3P9p
P3D/p/3A/Z/2A/d/2g/c/2k/cP+n/YA+QB4+QB4UkIczIr/6MyIPdUYe6ow8
1Bl5yzEPfkce/I48+B15i5gHvyMPfkce/I78FMP8RwzzHzHMf8Srn/+IYf4j
hvmPGOY/4mnWMP+Y+39nmP+Yp6FhTPdwfQFOWw9Q
   "], {{0, 0}, {64, 64}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->7056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitAnd", "[", 
     RowBox[{"i", ",", 
      RowBox[{"i", "-", "1"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16019],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdz0lKQ0EUheGHI4cZOHDgwIiIiEjs25ibvu9eWqei42zhLu0uySWoWBHO
XxCK/zsUjxTfN/nnTpZlHz+/3/vvfFUyPaa5a+oF7HvwffQB/BDvj+DH6BP4
KfYz+Dn6Al7C9y/hV+hr+A32W/gd+h7+gPeP8Cf0M/wFexn+iq7ALd3puMGr
2l6F17DX4HVtr8MbeN+AN7W9CW9hb8Hb2t6Gd/D9Dryr7V14D3sP3tf2PnyA
9wP4UNuH8BH2EXys7WP4JN3p2ETd0UGf6m5TdUcHPcf7XN3RQZ/pbjN1Rwd9
ju/P1R0d9IXutlB3dNCXeL9Ud3TQV7rbSt3RQV+ne/v/1+qODvrb//4NQEKA
Hg==
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25827]
}, Open  ]],

Cell["Test for powers of 2:", "ExampleText",
 CellID->6862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"BitAnd", "[", 
      RowBox[{"i", ",", 
       RowBox[{"i", "-", "1"}]}], "]"}], "==", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitAnd", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8731],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdkcuKAkEMRYMrly5cuHChIiLDIL6fM9Nl+362+AmCa3+hPtlPmJFJhJyC
5nJy06mkUr09rveciIS/76X/55mIP8FjPvh4AX4RXEJeOfh4Bfk1cB3cwP1N
1PkAfyKvhXgb9TvgLriH+/vwB+Chss0/UrX5x+hjAp6CZ8H39YU63+Af5CWI
B99vBMsc/ptVU/hgWSjr/NHY5l/if7Cs4L9Zda2q+45g2ajq/qOx7X+rqnNH
sOzgG9s77OGD5aCaqm9s73D0fUSwnOAbWx9nXyeCJfN5MUP8oiryC2xAO5U=

    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->28751]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"BitAnd", "[", 
     RowBox[{"i", ",", 
      RowBox[{"2", "i"}], ",", 
      RowBox[{"3", "i"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "64"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28251],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxd0UmKQjEUheGDoxo6cOCgBioiIiL2vb7Y9w0uQXDsFrJkl6BF5Qr5A4/w
cXJzk5f8/Xl7pCS5z/c3/49Xoni4mD9wGs7AWfjXxXU55AW4CJfgMlyBq+hT
c3FdHesbcBNuwW24A3fhXrDdv498AA/hUbCdewxP4Cn6JKhz8f4e1gw5rDly
WAvkZrv/EjmsFXJYa+SwNsHh/b3Z3n+Lelg75LD2yGEdgsN/9eZ5mI/IYZ2Q
m+2c59ge1iXu48227vo97xvicDMl
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30498],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{"BitAnd", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15138],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0"},
    {"0", "0"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitAnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitAnd"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12413],

Cell[BoxData[
 RowBox[{"BitAnd", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17781]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"BitAnd", ",", 
    RowBox[{"{", 
     RowBox[{"63", ",", "63"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7277],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->423899353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", 
       RowBox[{"BitAnd", "[", 
        RowBox[{"i", ",", "j"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "31"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "31"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14541],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 198},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->762027322]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11425],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27091],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->27148]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->141956690],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->41334340],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->402521931],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->607456543],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->50790554],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->10280136],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->126372567],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->96738244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with BitAnd",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=BitAnd"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
BitAnd"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitAnd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 13.9739396}", "context" -> "System`", 
    "keywords" -> {"mask"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BitAnd[n_1, n_2, ...] gives the bitwise AND of the integers n_i. ", 
    "synonyms" -> {"bit and"}, "title" -> "BitAnd", "type" -> "Symbol", "uri" -> 
    "ref/BitAnd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6683, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->501059406]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39998, 1259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3442, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4065, 101, 44, 1, 70, "ObjectName",
 CellID->27401],
Cell[4112, 104, 812, 27, 70, "Usage",
 CellID->15937]
}, Open  ]],
Cell[CellGroupData[{
Cell[4961, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5439, 153, 128, 4, 70, "Notes",
 CellID->20640],
Cell[5570, 159, 639, 22, 70, "Notes",
 CellID->11347],
Cell[6212, 183, 234, 8, 70, "Notes",
 CellID->26919],
Cell[6449, 193, 197, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6683, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->501059406],
Cell[CellGroupData[{
Cell[7068, 219, 148, 5, 70, "ExampleSection",
 CellID->863515119],
Cell[CellGroupData[{
Cell[7241, 228, 123, 4, 28, "Input",
 CellID->20795],
Cell[7367, 234, 155, 5, 36, "Output",
 CellID->23638]
}, Open  ]],
Cell[CellGroupData[{
Cell[7559, 244, 235, 8, 28, "Input",
 CellID->29411],
Cell[7797, 254, 585, 14, 64, "Output",
 Evaluatable->False,
 CellID->11801911]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8431, 274, 215, 7, 70, "ExampleSection",
 CellID->6655],
Cell[8649, 283, 63, 1, 70, "ExampleText",
 CellID->10371],
Cell[CellGroupData[{
Cell[8737, 288, 173, 6, 70, "Input",
 CellID->25502],
Cell[8913, 296, 202, 5, 36, "Output",
 CellID->25100]
}, Open  ]],
Cell[9130, 304, 121, 3, 70, "ExampleDelimiter",
 CellID->27761],
Cell[9254, 309, 200, 7, 70, "ExampleText",
 CellID->15717],
Cell[CellGroupData[{
Cell[9479, 320, 153, 4, 70, "Input",
 CellID->13965],
Cell[9635, 326, 156, 5, 36, "Output",
 CellID->4539]
}, Open  ]],
Cell[9806, 334, 121, 3, 70, "ExampleDelimiter",
 CellID->19501],
Cell[9930, 339, 59, 1, 70, "ExampleText",
 CellID->6423],
Cell[CellGroupData[{
Cell[10014, 344, 159, 6, 70, "Input",
 CellID->23815],
Cell[10176, 352, 171, 6, 36, "Output",
 CellID->29409]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10396, 364, 239, 7, 70, "ExampleSection",
 CellID->10053],
Cell[10638, 373, 92, 1, 70, "ExampleText",
 CellID->6002],
Cell[CellGroupData[{
Cell[10755, 378, 140, 4, 70, "Input",
 CellID->4431],
Cell[10898, 384, 209, 7, 36, "Output",
 CellID->11585]
}, Open  ]],
Cell[CellGroupData[{
Cell[11144, 396, 131, 4, 70, "Input",
 CellID->17089],
Cell[11278, 402, 209, 7, 36, "Output",
 CellID->29807]
}, Open  ]],
Cell[CellGroupData[{
Cell[11524, 414, 131, 4, 70, "Input",
 CellID->15944],
Cell[11658, 420, 154, 5, 36, "Output",
 CellID->25535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11861, 431, 223, 7, 70, "ExampleSection",
 CellID->10812],
Cell[12087, 440, 87, 1, 70, "ExampleText",
 CellID->13627],
Cell[CellGroupData[{
Cell[12199, 445, 228, 8, 70, "Input",
 CellID->8984],
Cell[12430, 455, 287, 9, 36, "Output",
 CellID->22755]
}, Open  ]],
Cell[12732, 467, 121, 3, 70, "ExampleDelimiter",
 CellID->30095],
Cell[12856, 472, 135, 4, 70, "ExampleText",
 CellID->28885],
Cell[CellGroupData[{
Cell[13016, 480, 346, 12, 70, "Input",
 CellID->10449],
Cell[13365, 494, 351, 10, 36, "Output",
 CellID->27238]
}, Open  ]],
Cell[13731, 507, 121, 3, 70, "ExampleDelimiter",
 CellID->29755],
Cell[13855, 512, 60, 1, 70, "ExampleText",
 CellID->2415],
Cell[CellGroupData[{
Cell[13940, 517, 416, 13, 70, "Input",
 CellID->5741],
Cell[14359, 532, 688, 17, 246, "Output",
 CellID->7056]
}, Open  ]],
Cell[15062, 552, 120, 3, 70, "ExampleDelimiter",
 CellID->4609],
Cell[CellGroupData[{
Cell[15207, 559, 301, 10, 70, "Input",
 CellID->16019],
Cell[15511, 571, 762, 20, 165, "Output",
 CellID->25827]
}, Open  ]],
Cell[16288, 594, 59, 1, 70, "ExampleText",
 CellID->6862],
Cell[CellGroupData[{
Cell[16372, 599, 320, 11, 70, "Input",
 CellID->14248],
Cell[16695, 612, 391, 10, 36, "Output",
 CellID->14779]
}, Open  ]],
Cell[17101, 625, 121, 3, 70, "ExampleDelimiter",
 CellID->11343],
Cell[CellGroupData[{
Cell[17247, 632, 294, 10, 70, "Input",
 CellID->8731],
Cell[17544, 644, 697, 19, 166, "Output",
 CellID->28751]
}, Open  ]],
Cell[CellGroupData[{
Cell[18278, 668, 327, 11, 70, "Input",
 CellID->28251],
Cell[18608, 681, 591, 16, 141, "Output",
 CellID->5096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19248, 703, 233, 7, 70, "ExampleSection",
 CellID->30498],
Cell[19484, 712, 185, 8, 70, "ExampleText",
 CellID->30979],
Cell[CellGroupData[{
Cell[19694, 724, 269, 9, 70, "Input",
 CellID->15138],
Cell[19966, 735, 217, 10, 48, "Output",
 CellID->32306]
}, Open  ]],
Cell[20198, 748, 121, 3, 70, "ExampleDelimiter",
 CellID->13991],
Cell[20322, 753, 300, 12, 70, "ExampleText",
 CellID->28301],
Cell[CellGroupData[{
Cell[20647, 769, 121, 4, 70, "Input",
 CellID->12413],
Cell[20771, 775, 209, 7, 36, "Output",
 CellID->17781]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21029, 788, 223, 7, 70, "ExampleSection",
 CellID->8286],
Cell[CellGroupData[{
Cell[21277, 799, 214, 7, 70, "Input",
 CellID->7277],
Cell[21494, 808, 3160, 56, 70, "Output",
 Evaluatable->False,
 CellID->423899353]
}, Open  ]],
Cell[CellGroupData[{
Cell[24691, 869, 437, 14, 70, "Input",
 CellID->14541],
Cell[25131, 885, 8448, 143, 70, "Output",
 Evaluatable->False,
 CellID->762027322]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33640, 1035, 311, 9, 70, "SeeAlsoSection",
 CellID->11425],
Cell[33954, 1046, 1925, 71, 70, "SeeAlso",
 CellID->10090]
}, Open  ]],
Cell[CellGroupData[{
Cell[35916, 1122, 314, 9, 70, "TutorialsSection",
 CellID->27091],
Cell[36233, 1133, 198, 4, 70, "Tutorials",
 CellID->27148]
}, Open  ]],
Cell[CellGroupData[{
Cell[36468, 1142, 319, 9, 70, "MoreAboutSection",
 CellID->141956690],
Cell[36790, 1153, 146, 3, 70, "MoreAbout",
 CellID->41334340],
Cell[36939, 1158, 164, 3, 70, "MoreAbout",
 CellID->402521931],
Cell[37106, 1163, 151, 3, 70, "MoreAbout",
 CellID->607456543],
Cell[37260, 1168, 144, 3, 70, "MoreAbout",
 CellID->50790554],
Cell[37407, 1173, 154, 3, 70, "MoreAbout",
 CellID->10280136],
Cell[37564, 1178, 137, 3, 70, "MoreAbout",
 CellID->126372567],
Cell[37704, 1183, 159, 3, 70, "MoreAbout",
 CellID->96738244]
}, Open  ]],
Cell[CellGroupData[{
Cell[37900, 1191, 305, 8, 70, "RelatedLinksSection"],
Cell[38208, 1201, 357, 12, 70, "RelatedLinks"],
Cell[38568, 1215, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[38967, 1231, 27, 0, 70, "History"],
Cell[38997, 1233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

