(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17443,        623]
NotebookOptionsPosition[     13693,        488]
NotebookOutlinePosition[     14872,        524]
CellTagsIndexPosition[     14787,        519]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitAnd" :> Documentation`HelpLookup["paclet:ref/BitAnd"], 
          "BitOr" :> Documentation`HelpLookup["paclet:ref/BitOr"], "BitXor" :> 
          Documentation`HelpLookup["paclet:ref/BitXor"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BitAnd\"\>", 2->"\<\"BitOr\"\>", 
       3->"\<\"BitXor\"\>", 4->"\<\"Not\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"Number Digits\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BitNot", "ObjectName",
 CellID->1933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitNot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitNot"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the bitwise NOT of the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " turns ones into zeros and vice versa in the binary bit representation of \
",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20089],

Cell[TextData[{
 "Integers are assumed to be represented in two's complement form, with an \
unlimited number of digits, so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is simply equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12242],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BitNot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BitNot"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7178186],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->252628871],

Cell["-1 corresponds to having all bits on:", "ExampleText",
 CellID->29955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitNot", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitNot", "[", "7", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27388],

Cell[BoxData[
 RowBox[{"-", "8"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29646]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4413],

Cell["Basic symbolic simplifications are done automatically:", "ExampleText",
 CellID->28796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitNot", "[", 
  RowBox[{"BitNot", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9726],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25065]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2181],

Cell["Make a shifted version of the rule 45 cellular automaton:", \
"ExampleText",
 CellID->27829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"IntegerDigits", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"BitXor", "[", 
        RowBox[{
         RowBox[{"4", "#"}], ",", 
         RowBox[{"BitOr", "[", 
          RowBox[{
           RowBox[{"2", "#"}], ",", 
           RowBox[{"BitNot", "[", "#", "]"}]}], "]"}]}], "]"}], "&"}], ",", 
      "1", ",", "60"}], "]"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5256],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztV9uNGzEMtJE0kkLSREq4BvKd7nOXZAGBmZfsXdN71gIDyytSomZIyv72
9vPH25fL5fL9Hb/e8fXy57l+PPVzG6PvI5Td+CC/+qj5uj6bT2JK/FFcbh92
5nvHLL6EL6cXitn5K57YHIurziXzLvbU3/mmNbHHmMXn8uFj+PdrppHbV+WI
ql22PuPQzbvYU41Ubalc2KNu0/gEH5cRSZ9gHCY6KE4SjtwZk9xEsaR8Mt3Z
HkeM03y/Fm03pHWiuEHnVJwm66PzJfNu7TQ3VH4mmu9Zz279K9F2Q7o+48tx
w3LD5ULlLqk7FAPgA2rmdGRnVP4sjtmx4EVqu8HxOhO70letq3LBnJHyoXRD
vkr/ZH2mY1KHM2dO6rZC5XTQI+C5E42TNZW9yz1lw86EbFxPYHbVdqc6n9J2
g1tf8cHiVXynNePs01xzfmivmZ7A8mPPOr/eqO0Gln9M5+S8KufTmkk5TPRL
6pL5uZ4Q1F4U7551W6FyF/HG3iXf0bkUr8g3rZtkDxabiifZf9a+8nLdSdsN
juOkFtAZEt5VLql+gb6n+ZTmUNoTkrGqkzLeVdsNKndZnC63ESfJPmot9Ki6
UXmp7F08Sd26NcHZDtF2g8pdds7k7KwfqH1mOEJ7sXdoT6c1i0dxorh6ZN1W
qNxV+Vffpf1A7ZP0kLqO8mEcMz+0X1KHbgxif4i2G5RmiZ5j/OQ81DeppURP
5sNyjfmh/dSZWfxi/FBtNyS8uP5WH/U+5T/JvaRPuJhvrEMYD+Kgo24rlJ6M
K5Xf7r3iDNkx3lhNp7qomFAMaQ8pvq3abkh7meKV2TMeWA6oNes8y7eZ/EvH
zhfE2q7rCBWzArKrZ1VcqcfppdZkcaK907E7w7PVbUXCE9NY8ZnwrOo17YuA
5+le4sbBGdp1VFCaJRpXfhNNVK5Uf+TD9ru1l7ixiK1dvwSq9zqNEReKE1en
rJZQbGi/W3uJG4MztOs2g0Qv9Km4TLhm+6JxWp9Kl6QvBLXdrtctULqo74yv
ZF7lw/hutj4n6tDGfea6rUj4Qt8ZH6lmMzWmek1Qe/+tObFOuz57IOlXqjci
Hh1/szWW7uf6xESdt+uyJ1RfZPXk6otpVLl0eyuN0JyKI7Rv1+MIuDxXWrH6
Qv7Vx2mh1pwds7WGz3YdjkTSp+scsmXzTNPqp+zYnulY5FY7/4+Ay3PEF7J1
uTCjp8svte4r3rcOqmbY/cr4dn6JFmgvZ/Pq962Dqhl2N6M5pQ27z9E+47vU
5tXvW4ekxlQtKt2dxiw3qpbO5tXvW4ekxpxOro+q/Kg+aOxsRrtVt1jjhGM3
p/rqrb2b7SfG7Xw+IxKekzmmN/JN7odqW59Vt3MaO66TOTRmvspn3bfHauw4
dvyrPs5qeybHhs923s6EpO+q30ju95HS2PmDcTtfZ0TCL7s/3X05kwfIf/hs
5+nMUDUKuIbvXC8ebdZ926/xzP05zqFcqN/Xfdun8cj5zP1Z9WHarfv2OTQe
9UjvT3UPI/tqN3y28/CZkdy9yd1atUP2wKb9/K+A5O5VfRvZ13G16T7zq2Hm
fw/Sa923zw/Vh939u+7bc0D13fFzG6/79nxI/g+N79Z9ez4ozdz/YDBuP88C
13jUKv0fPHy2n2NBa6x+b43vq77dsS/Ma4x0rrquuj0f1H/f+q471oX7NDZa
t8e5cJ/G67793CC/odvjWthf439PezwLx2jcHcPCsfgN9GVRNw==
   "], {{0, 0}, {121, 61}}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->4188]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BitNot", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "7"}], ",", 
   RowBox[{"-", "8"}], ",", 
   RowBox[{"-", "9"}], ",", 
   RowBox[{"-", "10"}], ",", 
   RowBox[{"-", "11"}]}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20998]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12065],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25805]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21704],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->137591470],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->406849972],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->280495653]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitNot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 16.1302448}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "BitNot[n] gives the bitwise NOT of the integer n. ", 
    "synonyms" -> {"bit not"}, "title" -> "BitNot", "type" -> "Symbol", "uri" -> 
    "ref/BitNot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5112, 173, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7178186]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14646, 512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2183, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2806, 79, 43, 1, 70, "ObjectName",
 CellID->1933],
Cell[2852, 82, 550, 18, 70, "Usage",
 CellID->8722]
}, Open  ]],
Cell[CellGroupData[{
Cell[3439, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3917, 122, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4052, 128, 354, 13, 70, "Notes",
 CellID->20089],
Cell[4409, 143, 462, 16, 70, "Notes",
 CellID->12242],
Cell[4874, 161, 201, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5112, 173, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7178186],
Cell[CellGroupData[{
Cell[5495, 187, 148, 5, 70, "ExampleSection",
 CellID->252628871],
Cell[5646, 194, 76, 1, 70, "ExampleText",
 CellID->29955],
Cell[CellGroupData[{
Cell[5747, 199, 96, 3, 28, "Input",
 CellID->625],
Cell[5846, 204, 171, 6, 36, "Output",
 CellID->11210]
}, Open  ]],
Cell[6032, 213, 121, 3, 70, "ExampleDelimiter",
 CellID->17156],
Cell[CellGroupData[{
Cell[6178, 220, 98, 3, 28, "Input",
 CellID->27388],
Cell[6279, 225, 171, 6, 36, "Output",
 CellID->29646]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6499, 237, 238, 7, 70, "ExampleSection",
 CellID->4413],
Cell[6740, 246, 93, 1, 70, "ExampleText",
 CellID->28796],
Cell[CellGroupData[{
Cell[6858, 251, 130, 4, 70, "Input",
 CellID->9726],
Cell[6991, 257, 154, 5, 36, "Output",
 CellID->25065]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7194, 268, 222, 7, 70, "ExampleSection",
 CellID->2181],
Cell[7419, 277, 98, 2, 70, "ExampleText",
 CellID->27829],
Cell[CellGroupData[{
Cell[7542, 283, 498, 16, 70, "Input",
 CellID->5256],
Cell[8043, 301, 2104, 40, 139, "Output",
 CellID->4188]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10196, 347, 233, 7, 70, "ExampleSection",
 CellID->12716],
Cell[CellGroupData[{
Cell[10454, 358, 202, 7, 70, "Input",
 CellID->838],
Cell[10659, 367, 472, 17, 36, "Output",
 CellID->20998]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11192, 391, 311, 9, 70, "SeeAlsoSection",
 CellID->12065],
Cell[11506, 402, 917, 35, 70, "SeeAlso",
 CellID->25805]
}, Open  ]],
Cell[CellGroupData[{
Cell[12460, 442, 314, 9, 70, "TutorialsSection",
 CellID->21704],
Cell[12777, 453, 198, 4, 70, "Tutorials",
 CellID->22869]
}, Open  ]],
Cell[CellGroupData[{
Cell[13012, 462, 319, 9, 70, "MoreAboutSection",
 CellID->137591470],
Cell[13334, 473, 147, 3, 70, "MoreAbout",
 CellID->406849972],
Cell[13484, 478, 137, 3, 70, "MoreAbout",
 CellID->280495653]
}, Open  ]],
Cell[13636, 484, 27, 0, 70, "History"],
Cell[13666, 486, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

