(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17178,        591]
NotebookOptionsPosition[     13519,        468]
NotebookOutlinePosition[     14806,        505]
CellTagsIndexPosition[     14721,        500]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitClear" :> Documentation`HelpLookup["paclet:ref/BitClear"], 
          "BitGet" :> Documentation`HelpLookup["paclet:ref/BitGet"], 
          "BitLength" :> Documentation`HelpLookup["paclet:ref/BitLength"], 
          "BitOr" :> Documentation`HelpLookup["paclet:ref/BitOr"], 
          "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BitClear\"\>", 2->"\<\"BitGet\"\>", 
       3->"\<\"BitLength\"\>", 4->"\<\"BitOr\"\>", 
       5->"\<\"ReplacePart\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bitwise Operations" :> 
          Documentation`HelpLookup["paclet:guide/BitwiseOperations"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Bitwise Operations\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Integer Functions\"\>", 4->"\<\"Number Digits\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["BitSet", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["BitSet",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BitSet"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets to 1 the bit corresponding to the coefficient of \
",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["2", "k"], TraditionalForm]], "InlineMath"],
     " in the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitSet"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " sets the bit ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " places from the right."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->510744604],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->414415286],

Cell["Display coefficients at powers of 2 in the integer 42:", "ExampleText",
 CellID->175881030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"42", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377175807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146842157]
}, Open  ]],

Cell[TextData[{
 "Set the bit corresponding to the coefficient at ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["2", "TR"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->503604002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitSet", "[", 
  RowBox[{"42", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651100650],

Cell[BoxData["43"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218009969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->797606992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->110617962]
}, Open  ]],

Cell[TextData[{
 "Set the bit corresponding to the coefficient at ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["2", "TR"], 
   StyleBox["4", "TR"]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->252559831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitSet", "[", 
  RowBox[{"42", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27494014],

Cell[BoxData["58"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->765689662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->30144982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->515604527]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitClear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitClear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitGet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->168107157],

Cell[TextData[ButtonBox["Bitwise Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BitwiseOperations"]], "MoreAbout",
 CellID->341083161],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->635309221],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->934445712],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->86433937],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->574942438],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->83300829]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BitSet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 26, 17.3646514}", "context" -> "System`", 
    "keywords" -> {
     "bit operations", "bitwise operations", "logical bit operations"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "BitSet[n, k] sets to 1 the bit corresponding to the coefficient of 2^k \
in the integer n. ", "synonyms" -> {"bit set"}, "title" -> "BitSet", "type" -> 
    "Symbol", "uri" -> "ref/BitSet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6954, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->510744604]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14578, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3086, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3709, 96, 1571, 37, 70, "ObjectNameGrid"],
Cell[5283, 135, 755, 25, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6075, 165, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6553, 182, 364, 14, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6954, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->510744604],
Cell[CellGroupData[{
Cell[7339, 215, 148, 5, 70, "ExampleSection",
 CellID->414415286],
Cell[7490, 222, 97, 1, 70, "ExampleText",
 CellID->175881030],
Cell[CellGroupData[{
Cell[7612, 227, 133, 4, 28, "Input",
 CellID->377175807],
Cell[7748, 233, 247, 8, 36, "Output",
 CellID->146842157]
}, Open  ]],
Cell[8010, 244, 280, 11, 70, "ExampleText",
 CellID->503604002],
Cell[CellGroupData[{
Cell[8315, 259, 126, 4, 28, "Input",
 CellID->651100650],
Cell[8444, 265, 159, 5, 36, "Output",
 CellID->218009969]
}, Open  ]],
Cell[CellGroupData[{
Cell[8640, 275, 132, 4, 70, "Input",
 CellID->797606992],
Cell[8775, 281, 247, 8, 36, "Output",
 CellID->110617962]
}, Open  ]],
Cell[9037, 292, 214, 8, 70, "ExampleText",
 CellID->252559831],
Cell[CellGroupData[{
Cell[9276, 304, 125, 4, 70, "Input",
 CellID->27494014],
Cell[9404, 310, 159, 5, 36, "Output",
 CellID->765689662]
}, Open  ]],
Cell[CellGroupData[{
Cell[9600, 320, 131, 4, 70, "Input",
 CellID->30144982],
Cell[9734, 326, 247, 8, 36, "Output",
 CellID->515604527]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10042, 341, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10361, 352, 1188, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[11586, 401, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11907, 412, 198, 4, 70, "Tutorials",
 CellID->22869]
}, Open  ]],
Cell[CellGroupData[{
Cell[12142, 421, 319, 9, 70, "MoreAboutSection",
 CellID->168107157],
Cell[12464, 432, 147, 3, 70, "MoreAbout",
 CellID->341083161],
Cell[12614, 437, 164, 3, 70, "MoreAbout",
 CellID->635309221],
Cell[12781, 442, 145, 3, 70, "MoreAbout",
 CellID->934445712],
Cell[12929, 447, 136, 3, 70, "MoreAbout",
 CellID->86433937],
Cell[13068, 452, 179, 3, 70, "MoreAbout",
 CellID->574942438],
Cell[13250, 457, 197, 4, 70, "MoreAbout",
 CellID->83300829]
}, Open  ]],
Cell[13462, 464, 27, 0, 70, "History"],
Cell[13492, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

